/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.utils;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.opmc.pbs.business.domain.workflow.entity.FlowRuProcBo;
import kd.opmc.pbs.business.domain.workflow.service.FlowDefProcDomainService;
import kd.opmc.pbs.business.domain.workflow.service.FlowRuProcBatchDomainService;
import kd.opmc.pbs.business.domain.workflow.service.FlowRuProcDomainService;
import kd.opmc.pbs.business.domain.workflow.service.FlowRuSecondDomainService;
import kd.opmc.pbs.common.utils.CommonResultBo;
import kd.opmc.pbs.common.utils.OpmcPermissionUtils;

public class InterViewObjUtils {
    private static final Log log = LogFactory.getLog(InterViewObjUtils.class);
    private static final FlowDefProcDomainService FLOW_DEF_PROC_DOMAIN_SERVICE = FlowDefProcDomainService.getInstance();
    private static final FlowRuProcDomainService FLOW_RU_PROC_DOMAIN_SERVICE = FlowRuProcDomainService.getInstance();
    private static final FlowRuSecondDomainService FLOW_RUSECOND_DOMAIN_SERVICE = FlowRuSecondDomainService.getInstance();
    private static final FlowRuProcBatchDomainService FLOW_RU_PROC_BATCH_DOMAIN_SERVICE = FlowRuProcBatchDomainService.getInstance();

    private InterViewObjUtils() {
    }

    public static FlowRuProcBo buildIntProcBo(DynamicObject interviewObj, Long flowVid) {
        DynamicObject person = interviewObj.getDynamicObject("person");
        long actEvalObjId = interviewObj.getLong("id");
        DynamicObject interActConf = interviewObj.getDynamicObject("interact");
        long perfOrgId = interviewObj.getLong("perforg.id");
        long adminOrgId = interActConf.getLong("adminorg.id");
        long activityId = interActConf.getLong("id");
        long empPosRelId = interviewObj.getLong("empposrel.id");
        long perfWorkFlowId = interActConf.getLong("perfworkflow.id");
        String settingmode = FLOW_DEF_PROC_DOMAIN_SERVICE.getHandlerSettingMode(Long.valueOf(perfWorkFlowId), "7");
        return FlowRuProcBo.builder().flowVid(flowVid).person(person).perfOrgId(Long.valueOf(perfOrgId)).adminOrgId(Long.valueOf(adminOrgId)).actEvalObjId(Long.valueOf(actEvalObjId)).activityId(Long.valueOf(activityId)).empPosRelId(Long.valueOf(empPosRelId)).settingMode(settingmode).workflowType("3").build();
    }

    public static boolean checkInterViewQueryPermission(IFormView formView) {
        boolean isPass = OpmcPermissionUtils.checkPermission((String)"24E05ECYZ6K0", (String)"epa_interactconf", (String)"47150e89000000ac");
        if (!isPass) {
            formView.showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u9762\u8c08\u6d3b\u52a8\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"InterViewObjUtils_0", (String)"opmc-epa-business", (Object[])new Object[0]));
        }
        return isPass;
    }

    public static boolean checkInterViewAddPermission(IFormView formView) {
        boolean isPass = OpmcPermissionUtils.checkPermission((String)"24E05ECYZ6K0", (String)"epa_interactconf", (String)"47156aff000000ac");
        if (!isPass) {
            formView.showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u9762\u8c08\u6d3b\u52a8\u201d\u7684\u201c\u65b0\u589e\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"InterViewObjUtils_1", (String)"opmc-epa-business", (Object[])new Object[0]));
        }
        return isPass;
    }

    public static boolean checkInterViewDelPermission(IFormView formView) {
        boolean isPass = OpmcPermissionUtils.checkPermission((String)"24E05ECYZ6K0", (String)"epa_interactconf", (String)"4715e1f1000000ac");
        if (!isPass) {
            formView.showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u9762\u8c08\u6d3b\u52a8\u201d\u7684\u201c\u5220\u9664\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"InterViewObjUtils_2", (String)"opmc-epa-business", (Object[])new Object[0]));
        }
        return isPass;
    }

    public static boolean checkInterViewStartPermission(IFormView formView) {
        boolean isPass = OpmcPermissionUtils.checkPermission((String)"24E05ECYZ6K0", (String)"epa_interactconf", (String)"1//K7E3YE3D6");
        if (!isPass) {
            formView.showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u9762\u8c08\u6d3b\u52a8\u201d\u7684\u201c\u542f\u52a8\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"InterViewObjUtils_3", (String)"opmc-epa-business", (Object[])new Object[0]));
        }
        return isPass;
    }

    public static boolean checkInterViewEndPermission(IFormView formView) {
        boolean isPass = OpmcPermissionUtils.checkPermission((String)"24E05ECYZ6K0", (String)"epa_interactconf", (String)"0=KX5+R7YT2N");
        if (!isPass) {
            formView.showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u9762\u8c08\u6d3b\u52a8\u201d\u7684\u201c\u7ed3\u675f\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"InterViewObjUtils_4", (String)"opmc-epa-business", (Object[])new Object[0]));
        }
        return isPass;
    }

    public static boolean checkActivityQueryPermission(IFormView formView) {
        boolean isPass = OpmcPermissionUtils.checkPermission((String)"24E05ECYZ6K0", (String)"epa_activity", (String)"47150e89000000ac");
        if (!isPass) {
            formView.showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u8003\u6838\u6d3b\u52a8\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"InterViewObjUtils_5", (String)"opmc-epa-business", (Object[])new Object[0]));
        }
        return isPass;
    }

    public static boolean checkInterViewProcessPermission(IFormView formView) {
        boolean isPass = OpmcPermissionUtils.checkPermission((String)"24E05ECYZ6K0", (String)"epa_interactconf", (String)"37LTQSOQE94P");
        if (!isPass) {
            formView.showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u9762\u8c08\u6d3b\u52a8\u201d\u7684\u201c\u6267\u884c\u8fc7\u7a0b\u7ba1\u7406\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"InterViewObjUtils_6", (String)"opmc-epa-business", (Object[])new Object[0]));
        }
        return isPass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static Map<Long, Long> preCreateProcessInstance(DynamicObject[] evalObjs, Long flowVid) {
        HashMap<Long, Long> objRefProInstMap = new HashMap<Long, Long>(16);
        if (Objects.isNull(evalObjs) || evalObjs.length <= 0) {
            return objRefProInstMap;
        }
        try (TXHandle txhandle = TX.required();){
            void object2;
            List processIdList = Arrays.stream(evalObjs).map(object -> object.getLong("interflowins.id")).collect(Collectors.toList());
            boolean deleteFlag = FLOW_RUSECOND_DOMAIN_SERVICE.deleteRunProc(processIdList);
            if (!deleteFlag) {
                HashMap<Long, Long> hashMap = objRefProInstMap;
                return hashMap;
            }
            LinkedList<FlowRuProcBo> ret = new LinkedList<FlowRuProcBo>();
            DynamicObject[] dynamicObjectArray = evalObjs;
            int n = dynamicObjectArray.length;
            boolean bl = false;
            while (object2 < n) {
                DynamicObject evalObj = dynamicObjectArray[object2];
                FlowRuProcBo flowRuProcBo = InterViewObjUtils.buildIntProcBo(evalObj, flowVid);
                ret.add(flowRuProcBo);
                ++object2;
            }
            CommonResultBo resultBo = FlowRuProcBatchDomainService.getInstance().preCreateProcessInstanceNoTx(ret, null);
            Map actevaobjProcMap = resultBo.getResultMap();
            for (DynamicObject evalObj : evalObjs) {
                Long actEvaObjId = evalObj.getLong("id");
                if (null == actevaobjProcMap || null == actevaobjProcMap.get(actEvaObjId)) continue;
                Long ruProcId = (Long)actevaobjProcMap.get(actEvaObjId);
                objRefProInstMap.put(actEvaObjId, ruProcId);
            }
            HashMap<Long, Long> hashMap = objRefProInstMap;
            return hashMap;
        }
        return objRefProInstMap;
    }
}

