/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.utils;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.extplugin.PluginFilter;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.epa.business.domain.activitymanage.extpoint.INotValidateIndFieldService;
import kd.opmc.epa.business.domain.activitymanage.extpoint.impl.NotValidateIndFieldService;

public class NumberValidateUtils {
    private static final Log LOGGER = LogFactory.getLog(NumberValidateUtils.class);

    public static void validate(String name, IFormView view, Set<String> validateNumberFiled) {
        String evalType = (String)view.getModel().getValue("evaltype");
        if (HRStringUtils.equals((String)evalType, (String)"20") && validateNumberFiled.contains(name)) {
            String value = (String)view.getModel().getValue(name);
            if (ObjectUtils.isEmpty((Object)value)) {
                return;
            }
            if (!NumberValidateUtils.validateNumber(value)) {
                view.getModel().setValue(name, null);
                view.showErrorNotification(ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u8f93\u5165\u6570\u5b57", (String)"NumberValidateUtils_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public static boolean opValidate(IFormView view, Set<String> validateNumberFiled) {
        String evalType = (String)view.getModel().getValue("evaltype");
        if (HRStringUtils.equals((String)evalType, (String)"20")) {
            HashSet<String> filedSet = new HashSet<String>(validateNumberFiled);
            for (String filed2 : validateNumberFiled) {
                String value = (String)view.getModel().getValue(filed2);
                if (ObjectUtils.isEmpty((Object)value)) {
                    filedSet.remove(filed2);
                    continue;
                }
                if (!NumberValidateUtils.validateNumber(value)) continue;
                filedSet.remove(filed2);
            }
            if (!ObjectUtils.isEmpty(filedSet)) {
                String filedStr = Arrays.toString(filedSet.stream().map(filed -> view.getModel().getProperty(filed).getDisplayName().getLocaleValue()).toArray());
                String validateMsg = ResManager.loadKDString((String)"{0}\u53ea\u80fd\u8f93\u5165\u6570\u5b57", (String)"NumberValidateUtils_1", (String)"opmc-epa-formplugin", (Object[])new Object[]{filedStr});
                view.showErrorNotification(validateMsg);
                return false;
            }
        }
        return true;
    }

    private static boolean validateNumber(String value) {
        return value.matches("^-?([1-9]\\d*\\.\\d+|0\\.\\d*[1-9]\\d*|0\\.0+|[1-9]\\d*|0)$");
    }

    public static boolean opValidateEntryQualityRes(IFormView view, ChangeData changeData) {
        if (HRStringUtils.isEmpty((String)((String)changeData.getNewValue()))) {
            return true;
        }
        DynamicObjectCollection entryEntity = view.getModel().getEntryEntity("entryentity");
        DynamicObject indRecordDy = (DynamicObject)entryEntity.get(changeData.getRowIndex());
        String evalType = indRecordDy.getString("indicator.evaltype");
        if (HRStringUtils.equals((String)evalType, (String)"20") && !NumberValidateUtils.validateNumber((String)changeData.getNewValue())) {
            String showTipsTag = "qualityres" + changeData.getRowIndex() + changeData.getNewValue();
            String isShowTips = view.getPageCache().get(showTipsTag);
            if (HRStringUtils.equals((String)isShowTips, (String)"true")) {
                view.getPageCache().remove(showTipsTag);
                view.getModel().setValue("qualityres", changeData.getOldValue(), changeData.getRowIndex());
                return false;
            }
            String validateMsg = ResManager.loadKDString((String)"{0}\u7684\u201c\u5b9e\u9645\u5b8c\u6210\u503c\u201d\u53ea\u80fd\u8f93\u5165\u6570\u5b57", (String)"NumberValidateUtils_2", (String)"opmc-epa-formplugin", (Object[])new Object[]{indRecordDy.getString("indicator.indctrname")});
            view.showTipNotification(validateMsg);
            LOGGER.info("after show tips oldValue:{}, newValue", changeData.getOldValue());
            view.getModel().setValue("qualityres", changeData.getOldValue(), changeData.getRowIndex());
            return false;
        }
        return true;
    }

    public static String[] removeNotValidateField(String[] validateNumberFiled) {
        Set notValidateFields;
        NotValidateIndFieldService notValidateService = new NotValidateIndFieldService();
        HRPluginProxy proxy = HRPlugInProxyFactory.create((Object)notValidateService, INotValidateIndFieldService.class, (String)"kd.opmc.epa.business.domain.activitymanage.extpoint.INotValidateIndFieldService#getNotValidateField", (PluginFilter)null);
        List result = proxy.callReplaceIfPresent(INotValidateIndFieldService::getNotValidateField);
        if (!ObjectUtils.isEmpty((Object)result) && !ObjectUtils.isEmpty((Object)(notValidateFields = (Set)result.get(0)))) {
            return (String[])Arrays.stream(validateNumberFiled).filter(field -> !notValidateFields.contains(field)).toArray(String[]::new);
        }
        return validateNumberFiled;
    }

    public static void removeNotValidateField(Set<String> validateNumberFiled) {
        Set notValidateFields;
        NotValidateIndFieldService notValidateService = new NotValidateIndFieldService();
        HRPluginProxy proxy = HRPlugInProxyFactory.create((Object)notValidateService, INotValidateIndFieldService.class, (String)"kd.opmc.epa.business.domain.activitymanage.extpoint.INotValidateIndFieldService#getNotValidateField", (PluginFilter)null);
        List result = proxy.callReplaceIfPresent(INotValidateIndFieldService::getNotValidateField);
        if (!ObjectUtils.isEmpty((Object)result) && !ObjectUtils.isEmpty((Object)(notValidateFields = (Set)result.get(0)))) {
            validateNumberFiled.removeAll(notValidateFields);
        }
    }
}

