/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.pbs.business;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;

public class ServiceFactory {
    private static final Map<String, String> SERVICE_MAP = new HashMap<String, String>();

    public static <T> T getService(Class<T> clazz) {
        return (T)ServiceFactory.getService(clazz.getSimpleName());
    }

    public static Object getService(String serviceName) {
        String className = SERVICE_MAP.get(serviceName);
        if (className == null) {
            throw new RuntimeException(String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230\u201c%s\u201d\u5bf9\u5e94\u7684\u670d\u52a1\u5b9e\u73b0\u3002", (String)"ServiceFactory_0", (String)"opmc-pbs-business", (Object[])new Object[0]), serviceName));
        }
        try {
            Class<?> clz = Class.forName(className);
            return clz.newInstance();
        }
        catch (Exception exp) {
            throw new RuntimeException(String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230\u201c%s\u201d\u5bf9\u5e94\u7684\u670d\u52a1\u5b9e\u73b0\u3002", (String)"ServiceFactory_0", (String)"opmc-pbs-business", (Object[])new Object[0]), serviceName), exp);
        }
    }

    static {
        SERVICE_MAP.put("IDepempService", "kd.opmc.pbs.business.external.hrpi.impl.DepempServiceImpl");
        SERVICE_MAP.put("IHSPMService", "kd.opmc.pbs.business.external.hspm.impl.HSPMServiceImpl");
        SERVICE_MAP.put("IHRPIWorkRoleService", "kd.opmc.pbs.business.external.hrpi.impl.HRPIWorkRoleServiceImpl");
        SERVICE_MAP.put("IPersonChgService", "kd.opmc.pbs.business.external.hpfs.impl.PersonChgServiceImpl");
        SERVICE_MAP.put("IStrategyService", "kd.opmc.pbs.business.external.hrcs.impl.StrategyServiceImpl");
        SERVICE_MAP.put("IHAOSBatchAdminOrgInfoQueryService", "kd.opmc.pbs.business.external.haos.impl.HAOSBatchAdminOrgInfoQueryServiceImpl");
        SERVICE_MAP.put("PerfCecycleApplicationService", "kd.opmc.pbs.business.application.service.PerfCecycleApplicationService");
        SERVICE_MAP.put("PerfCecycleEntityService", "kd.opmc.pbs.business.domain.perfcecycle.entityservice.PerfCecycleEntityService");
        SERVICE_MAP.put("PerfCecycleSerivce", "kd.opmc.pbs.business.domain.perfcecycle.service.PerfCecycleSerivce");
        SERVICE_MAP.put("PotMemberApplicationService", "kd.opmc.pbs.business.application.service.pot.PotMemberApplicationService");
        SERVICE_MAP.put("PotMemberDomainService", "kd.opmc.pbs.business.domain.pot.service.PotMemberDomainService");
        SERVICE_MAP.put("PotMemberEntityService", "kd.opmc.pbs.business.domain.pot.entityservice.PotMemberEntityService");
        SERVICE_MAP.put("ProjectOrgTeamApplicationService", "kd.opmc.pbs.business.application.service.pot.ProjectOrgTeamApplicationService");
        SERVICE_MAP.put("ProjectOrgTeamDomainService", "kd.opmc.pbs.business.domain.pot.service.ProjectOrgTeamDomainService");
        SERVICE_MAP.put("ProjectOrgTeamEntityService", "kd.opmc.pbs.business.domain.pot.entityservice.ProjectOrgTeamEntityService");
        SERVICE_MAP.put("IHRPIPersonService", "kd.opmc.pbs.business.external.hrpi.impl.HRPIPersonService");
        SERVICE_MAP.put("PotLabelApplicationService", "kd.opmc.pbs.business.application.service.pot.PotLabelApplicationService");
        SERVICE_MAP.put("PotLabelDomainService", "kd.opmc.pbs.business.domain.pot.service.PotLabelDomainService");
        SERVICE_MAP.put("PotLabelEntityService", "kd.opmc.pbs.business.domain.pot.entityservice.PotLabelEntityService");
        SERVICE_MAP.put("AssessNodeApplicationService", "kd.opmc.pbs.business.application.service.assessnode.AssessNodeApplicationService");
        SERVICE_MAP.put("AssessNodeDomainService", "kd.opmc.pbs.business.domain.assessnode.service.AssessNodeDomainService");
        SERVICE_MAP.put("AssessNodeEntityService", "kd.opmc.pbs.business.domain.assessnode.entityservice.AssessNodeEntityService");
        SERVICE_MAP.put("IHRCSMsgService", "kd.opmc.pbs.business.external.hrcs.impl.HRCSMsgServiceImpl");
        SERVICE_MAP.put("IEmployeeService", "kd.opmc.pbs.business.external.hrpi.impl.EmployeeServiceImpl");
        SERVICE_MAP.put("CycleSchemeEntityService", "kd.opmc.pbs.business.domain.perfcecycle.entityservice.CycleSchemeEntityService");
        SERVICE_MAP.put("ScoreSystemEntityService", "kd.opmc.pbs.business.domain.perfcecycle.entityservice.ScoreSystemEntityService");
        SERVICE_MAP.put("PerfLevelEntityService", "kd.opmc.pbs.business.domain.perfcecycle.entityservice.PerfLevelEntityService");
        SERVICE_MAP.put("IEPAAssessActivityService", "kd.opmc.pbs.business.external.epa.impl.EPAAssessActivityServiceImpl");
        SERVICE_MAP.put("IEPAPerfWorkflowService", "kd.opmc.pbs.business.external.epa.impl.EPAPerfWorkflowServiceImpl");
        SERVICE_MAP.put("IHRCSTipService", "kd.opmc.pbs.business.external.hrcs.impl.HRCSTipServiceImpl");
        SERVICE_MAP.put("TimeTagApplicationService", "kd.opmc.pbs.business.application.service.timetag.TimeTagApplicationService");
        SERVICE_MAP.put("TimeTagDomainService", "kd.opmc.pbs.business.domain.timetag.service.TimeTagDomainService");
        SERVICE_MAP.put("TimeTagEntityService", "kd.opmc.pbs.business.domain.timetag.entityservice.TimeTagEntityService");
        SERVICE_MAP.put("WorkFlowApplicationService", "kd.opmc.pbs.business.application.service.workflow.WorkFlowApplicationService");
        SERVICE_MAP.put("FlowDefProcApplicationService", "kd.opmc.pbs.business.application.service.workflow.FlowDefProcApplicationService");
        SERVICE_MAP.put("FlowDefProcEntityService", "kd.opmc.pbs.business.domain.workflow.entityservice.FlowDefProcEntityService");
        SERVICE_MAP.put("FlowDefProcWithoutEntryEntityService", "kd.opmc.pbs.business.domain.workflow.entityservice.FlowDefProcWithoutEntryEntityService");
        SERVICE_MAP.put("WorkFlowEntityService", "kd.opmc.pbs.business.domain.workflow.entityservice.WorkFlowEntityService");
        SERVICE_MAP.put("FlowDefProcDomainService", "kd.opmc.pbs.business.domain.workflow.service.FlowDefProcDomainService");
        SERVICE_MAP.put("FlowDefRoleEntityService", "kd.opmc.pbs.business.domain.workflow.entityservice.FlowDefRoleEntityService");
        SERVICE_MAP.put("WorkFlowDomainService", "kd.opmc.pbs.business.domain.workflow.service.WorkFlowDomainService");
        SERVICE_MAP.put("BatchStartEvalEntityService", "kd.opmc.pbs.business.domain.flowscan.entityservice.BatchStartEvalEntityService");
        SERVICE_MAP.put("BatchFlowTaskService", "kd.opmc.pbs.business.domain.flowscan.service.BatchFlowTaskService");
        SERVICE_MAP.put("MsgTemplateEntity", "kd.opmc.pbs.business.domain.msg.entityservice.MsgTemplateEntity");
        SERVICE_MAP.put("MsgLogEntity", "kd.opmc.pbs.business.domain.msg.entityservice.MsgLogEntity");
        SERVICE_MAP.put("MsgLogDomainService", "kd.opmc.pbs.business.domain.msg.service.MsgLogDomainService");
        SERVICE_MAP.put("MessageCenterCallBackService", "kd.opmc.pbs.business.domain.msg.service.MessageCenterCallBackService");
        SERVICE_MAP.put("MsgSendDomainService", "kd.opmc.pbs.business.domain.msg.service.MsgSendDomainService");
        SERVICE_MAP.put("MergeMsgSendService", "kd.opmc.pbs.business.domain.msg.service.MergeMsgSendService");
        SERVICE_MAP.put("MsgSendApplication", "kd.opmc.pbs.business.application.service.msg.MsgSendApplication");
        SERVICE_MAP.put("RollbackMsgSendService", "kd.opmc.pbs.business.domain.msg.service.RollbackMsgSendService");
        SERVICE_MAP.put("FlowRuProcApplicationService", "kd.opmc.pbs.business.application.service.workflow.FlowRuProcApplicationService");
        SERVICE_MAP.put("FlowRuNodeEntityService", "kd.opmc.pbs.business.domain.workflow.entityservice.FlowRuNodeEntityService");
        SERVICE_MAP.put("FlowRuProcEntityService", "kd.opmc.pbs.business.domain.workflow.entityservice.FlowRuProcEntityService");
        SERVICE_MAP.put("FlowRuRoleEntityService", "kd.opmc.pbs.business.domain.workflow.entityservice.FlowRuRoleEntityService");
        SERVICE_MAP.put("FlowRuTaskEntityService", "kd.opmc.pbs.business.domain.workflow.entityservice.FlowRuTaskEntityService");
        SERVICE_MAP.put("FlowRuOpEntityService", "kd.opmc.pbs.business.domain.workflow.entityservice.FlowRuOpEntityService");
        SERVICE_MAP.put("FlowRuProcDomainService", "kd.opmc.pbs.business.domain.workflow.service.FlowRuProcDomainService");
        SERVICE_MAP.put("FlowHandlerDomainService", "kd.opmc.pbs.business.domain.workflow.service.FlowHandlerDomainService");
        SERVICE_MAP.put("FlowRuMonitorDomainService", "kd.opmc.pbs.business.domain.workflow.service.FlowRuMonitorDomainService");
        SERVICE_MAP.put("FlowHandlerBatchDomainService", "kd.opmc.pbs.business.domain.workflow.service.FlowHandlerBatchDomainService");
        SERVICE_MAP.put("IEPAEvalResultCalcService", "kd.opmc.pbs.business.external.epa.impl.EPAEvalResultCalcServiceImpl");
        SERVICE_MAP.put("IHRCSDataPermissionService", "kd.opmc.pbs.business.external.hrcs.impl.HRCSDataPermissionServiceImpl");
        SERVICE_MAP.put("FlowRunSupDomainService", "kd.opmc.pbs.business.domain.workflow.service.FlowRunSupDomainService");
        SERVICE_MAP.put("CrossScoreDomainService", "kd.opmc.pbs.business.domain.workflow.service.CrossScoreDomainService");
        SERVICE_MAP.put("CrossRoleSetEntityService", "kd.opmc.pbs.business.domain.workflow.entityservice.CrossRoleSetEntityService");
        SERVICE_MAP.put("IndicatorRoleSetEntityService", "kd.opmc.pbs.business.domain.workflow.entityservice.IndicatorRoleSetEntityService");
        SERVICE_MAP.put("FlowRuSecondDomainService", "kd.opmc.pbs.business.domain.workflow.service.FlowRuSecondDomainService");
        SERVICE_MAP.put("FlowDefNodeEntityService", "kd.opmc.pbs.business.domain.workflow.entityservice.FlowDefNodeEntityService");
        SERVICE_MAP.put("BatchTaskmapEntityService", "kd.opmc.pbs.business.domain.workflow.entityservice.BatchTaskmapEntityService");
        SERVICE_MAP.put("IEPARoleTypeService", "kd.opmc.pbs.business.external.epa.impl.EPARoleTypeServiceImpl");
        SERVICE_MAP.put("IEPAActevalobjService", "kd.opmc.pbs.business.external.epa.impl.EPAActevalobjServiceImpl");
        SERVICE_MAP.put("CustomServiceEntityService", "kd.opmc.pbs.business.domain.customservice.entityservice.CustomServiceEntityService");
        SERVICE_MAP.put("CustomSerService", "kd.opmc.pbs.business.domain.customservice.service.CustomSerService");
        SERVICE_MAP.put("IWorkFlowOutService", "kd.opmc.pbs.business.domain.workflow.outService.impl.WorkFlowOutServiceImpl");
        SERVICE_MAP.put("FlowRuTaskIndEntryService", "kd.opmc.pbs.business.domain.workflow.entityservice.FlowRuTaskIndEntryService");
        SERVICE_MAP.put("FlowRuTaskEntityUnitTestService", "kd.opmc.pbs.unittest.form.web.entityservice.FlowRuTaskEntityUnitTestService");
        SERVICE_MAP.put("FlowRuProcEntityUnitTestService", "kd.opmc.pbs.unittest.form.web.entityservice.FlowRuProcEntityUnitTestService");
        SERVICE_MAP.put("FlowBatchHandlerDomainService", "kd.opmc.pbs.business.domain.workflow.service.FlowBatchHandlerDomainService");
        SERVICE_MAP.put("FlowAssistDomainService", "kd.opmc.pbs.business.domain.workflow.service.FlowAssistDomainService");
        SERVICE_MAP.put("ICustomTerminologyService", "kd.opmc.pbs.business.domain.common.service.CustomTerminologyServiceImpl");
        SERVICE_MAP.put("CustomTerminologyDomainService", "kd.opmc.pbs.business.domain.common.service.CustomTerminologyDomainService");
        SERVICE_MAP.put("IMsgSendService", "kd.opmc.pbs.business.domain.msg.extpoint.impl.MsgSendServiceImpl");
        SERVICE_MAP.put("FlowCooperateDomainService", "kd.opmc.pbs.business.domain.workflow.service.FlowCooperateDomainService");
        SERVICE_MAP.put("FlowCooperateRuProcDomainService", "kd.opmc.pbs.business.domain.workflow.service.FlowCooperateRuProcDomainService");
        SERVICE_MAP.put("PerfParamConfigApplicationService", "kd.opmc.pbs.business.application.service.PerfParamConfigApplicationService");
        SERVICE_MAP.put("FlowRuTaskProcLogEntityService", "kd.opmc.pbs.business.domain.workflow.entityservice.FlowRuTaskProcLogEntityService");
        SERVICE_MAP.put("FlowRuProcBatchDomainService", "kd.opmc.pbs.business.domain.workflow.service.FlowRuProcBatchDomainService");
        SERVICE_MAP.put("IWorkFlowTaskOutService", "kd.opmc.pbs.business.domain.workflow.outService.impl.WorkFlowTaskOutServiceImpl");
        SERVICE_MAP.put("IEPAActEvalRecordService", "kd.opmc.pbs.business.external.epa.impl.EPAActEvalRecordServiceImpl");
        SERVICE_MAP.put("IRoleTypeUserDefService", "kd.opmc.pbs.business.domain.workflow.outService.impl.RoleTypeUserDefServiceImpl");
        SERVICE_MAP.put("OpmcPromptUpgradeServiceImpl", "kd.opmc.pbs.business.upgrade.OpmcPromptUpgradeServiceImpl");
        SERVICE_MAP.put("IJumpTaskForNoAuditorService", "kd.opmc.pbs.business.domain.extpoint.impl.JumpTaskForNoAuditorService");
        SERVICE_MAP.put("IWorkflowSupportCopyService", "kd.opmc.pbs.business.domain.extpoint.impl.WorkflowSupportCopyService");
    }
}

