/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.pbs.business.application.impl.mq;

import com.alibaba.fastjson.JSONObject;
import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.pbs.business.domain.flowscan.entityservice.BatchStartEvalEntityService;
import kd.opmc.pbs.business.domain.flowscan.enums.TaskStatusEnum;
import kd.opmc.pbs.business.domain.flowscan.enums.TaskTypeEnum;
import org.apache.commons.collections.CollectionUtils;

public class StartProcessPublisher {
    private static final Log LOGGER = LogFactory.getLog(StartProcessPublisher.class);
    private static final BatchStartEvalEntityService BATCH_START_EVAL_ENTITY_SERVICE = BatchStartEvalEntityService.getInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void publish(List<Long> batchStartIdList, String taskType) {
        if (CollectionUtils.isEmpty(batchStartIdList)) {
            return;
        }
        LOGGER.info("\u3010OPMC\u3011-begin startprocess publish");
        MessagePublisher pub = MQFactory.get().createSimplePublisher("opmc", "opmc_pbs_startprocess_queue");
        try {
            JSONObject paramJsonObject = new JSONObject();
            paramJsonObject.put("batchStartIds", batchStartIdList);
            if (HRStringUtils.equals((String)taskType, (String)TaskTypeEnum.INDICATOR_START.getValue()) || HRStringUtils.equals((String)taskType, (String)TaskTypeEnum.EVAL_START.getValue())) {
                paramJsonObject.put("businessType", (Object)"20");
            } else {
                paramJsonObject.put("businessType", (Object)"10");
            }
            paramJsonObject.put("taskType", (Object)taskType);
            paramJsonObject.put("pushTime", (Object)System.currentTimeMillis());
            BATCH_START_EVAL_ENTITY_SERVICE.updateBatchTaskStatus(batchStartIdList, TaskStatusEnum.PUSHED);
            pub.publish(HRJSONUtils.toString((Object)paramJsonObject));
        }
        catch (Exception e) {
            BATCH_START_EVAL_ENTITY_SERVICE.updateBatchTaskStatus(batchStartIdList, TaskStatusEnum.UNPROCESS);
            LOGGER.error("\u3010OPMC\u3011-StartProcessPublisher publish error,message : {0}", (Object)e.getMessage());
        }
        finally {
            pub.close();
            LOGGER.info("StartProcessPublisher.close");
        }
        LOGGER.info("\u3010OPMC\u3011-end startprocess publish");
    }
}

