/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.pbs.business.application.impl.mq;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.bos.orm.query.QFilter;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowRuTaskEntityService;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowRuTaskProcLogEntityService;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuTaskStatusEnum;
import kd.opmc.pbs.business.domain.workflow.service.FlowRuProcDomainService;
import kd.opmc.pbs.business.domain.workflow.service.FlowRunSupDomainService;

public class SubmitTaskConsumer
implements MessageConsumer {
    private static final Log LOGGER = LogFactory.getLog(SubmitTaskConsumer.class);
    private static final FlowRuProcDomainService FLOW_RU_PROC_DOMAIN_SERVICE = FlowRuProcDomainService.getInstance();
    private static final FlowRuTaskProcLogEntityService FLOW_RUTASK_LOG_SERVICE = FlowRuTaskProcLogEntityService.getInstance();
    private static final FlowRuTaskEntityService FLOW_RU_TASK_ENTITY_SERVICE = FlowRuTaskEntityService.getInstance();
    private static final FlowRunSupDomainService FLOW_RUSUP_DOMAIN_SERVICE = FlowRunSupDomainService.getInstance();

    public void onMessage(Object body, String messageId, boolean flag, MessageAcker messageAcker) {
        String msg = (String)body;
        LOGGER.info("SubmitTaskConsumer.onMessage messageId:{}", (Object)messageId);
        try {
            Map taskMap = (Map)SerializationUtils.fromJsonString((String)msg, Map.class);
            Map<Long, Boolean> resultMap = FLOW_RU_PROC_DOMAIN_SERVICE.dealSubmitTask((List)taskMap.get("taskIds"), Boolean.FALSE);
            ArrayList<Long> submitFaildTaskIdList = new ArrayList<Long>(10);
            for (Map.Entry<Long, Boolean> entry : resultMap.entrySet()) {
                if (entry.getValue().booleanValue()) continue;
                submitFaildTaskIdList.add(entry.getKey());
            }
            QFilter taskFilter = new QFilter("id", "in", submitFaildTaskIdList);
            DynamicObject[] ruTaskDyns = FLOW_RU_TASK_ENTITY_SERVICE.query("taskstatus,updatestatustime,modifier,modifytime", new QFilter[]{taskFilter});
            FLOW_RUSUP_DOMAIN_SERVICE.updateTaskStatus(ruTaskDyns, FlowRuTaskStatusEnum.PROCESSING.getCode());
            FLOW_RU_TASK_ENTITY_SERVICE.save(ruTaskDyns);
            FLOW_RUTASK_LOG_SERVICE.updateRuTaskProcLog((List)taskMap.get("taskIds"), resultMap);
        }
        catch (Exception e) {
            LOGGER.error("\u3010OPMC\u3011-SubmitTaskConsumer onMessage error,message : {0}", (Object)e.getMessage());
        }
        messageAcker.ack(messageId);
    }
}

