/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.pbs.business.application.service.workflow;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.opmc.pbs.business.ServiceFactory;
import kd.opmc.pbs.business.domain.workflow.entity.FlowValidateResultBo;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowRuNodeEntityService;
import kd.opmc.pbs.business.domain.workflow.model.FlowRuNodeBo;
import kd.opmc.pbs.business.domain.workflow.model.RollbackParamBo;
import kd.opmc.pbs.business.domain.workflow.service.FlowRuMonitorDomainService;
import kd.opmc.pbs.business.domain.workflow.service.FlowRuProcDomainService;
import kd.opmc.pbs.business.domain.workflow.service.FlowRuSecondDomainService;
import kd.opmc.pbs.business.domain.workflow.service.FlowRunSupDomainService;
import kd.opmc.pbs.business.domain.workflow.vo.NodeIdAndTaskIdMapVO;

public class FlowRuProcApplicationService {
    private static final FlowRuProcDomainService FLOW_RU_PROC_DOMAIN_SERVICE = FlowRuProcDomainService.getInstance();
    private static final FlowRuMonitorDomainService FLOW_RU_MONITOR_DOMAIN_SERVICE = FlowRuMonitorDomainService.getInstance();
    private static final FlowRunSupDomainService FLOW_RUSUP_DOMAIN_SERVICE = FlowRunSupDomainService.getInstance();
    private static final FlowRuSecondDomainService FLOW_RUSECOND_DOMAIN_SERVICE = FlowRuSecondDomainService.getInstance();
    private static final FlowRuNodeEntityService FLOW_RU_NODE_ENTITY_SERVICE = FlowRuNodeEntityService.getInstance();

    public static FlowRuProcApplicationService getInstance() {
        return ServiceFactory.getService(FlowRuProcApplicationService.class);
    }

    public Map<Long, String> queryActivityNameByIds(List<Long> ids) {
        return FLOW_RU_MONITOR_DOMAIN_SERVICE.queryActivityNameByIds(ids);
    }

    public DataSet queryFlowRuntimeReportDataSet(Long id) {
        return FLOW_RU_MONITOR_DOMAIN_SERVICE.queryFlowRuntimeReportDataSet(id);
    }

    public DataSet queryFlowTaskReportDataSet(Long id) {
        return FLOW_RU_MONITOR_DOMAIN_SERVICE.queryFlowTaskReportDataSet(id);
    }

    public DataSet queryFlowNodeReportDataSet(Long id) {
        return FLOW_RU_MONITOR_DOMAIN_SERVICE.queryFlowNodeReportDataSet(id);
    }

    public DataSet queryFlowRuntimeNodeReportDataSet(Long id) {
        return FLOW_RU_MONITOR_DOMAIN_SERVICE.queryFlowRuntimeNodeReportDataSet(id);
    }

    public DynamicObject[] queryAllNodeByProcId(Long procId) {
        return FLOW_RUSUP_DOMAIN_SERVICE.queryAllNodeByProcId(procId);
    }

    public DynamicObject[] queryAllTaskByProcId(Long procId) {
        return FLOW_RUSUP_DOMAIN_SERVICE.queryAllTaskByProcId(procId);
    }

    public DynamicObject[] queryAllRoleByProcId(Long procId) {
        return FLOW_RUSUP_DOMAIN_SERVICE.queryAllRoleByProcId(procId);
    }

    public void pauseProcess(List<Long> ruProcIds, String pauseType, String describe) {
        FLOW_RU_PROC_DOMAIN_SERVICE.pauseProcess(ruProcIds, pauseType, describe);
    }

    public void restartProcess(List<Long> ruProcIds) {
        FLOW_RU_PROC_DOMAIN_SERVICE.restartProcess(ruProcIds);
    }

    public boolean notPrepareRestart(Long ruProcId) {
        return FLOW_RU_PROC_DOMAIN_SERVICE.notPrepareRestart(ruProcId);
    }

    public DynamicObject[] queryProcByProcIds(List<Long> procIds) {
        return FLOW_RUSUP_DOMAIN_SERVICE.queryProcByProcIds(procIds);
    }

    public String queryProcStatus(Long ruProcId) {
        return FLOW_RUSUP_DOMAIN_SERVICE.queryProcStatus(ruProcId);
    }

    public boolean isAllowedChangeHandler(Long ruTaskId) {
        return FLOW_RU_PROC_DOMAIN_SERVICE.isAllowedChangeHandler(ruTaskId);
    }

    public void pauseProcessForChangeHandler(Long ruProcId) {
        FLOW_RU_PROC_DOMAIN_SERVICE.pauseProcessForChangeHandler(ruProcId);
    }

    public boolean changeHandler(Long ruTaskId, Long newHandlerId) {
        return FLOW_RU_PROC_DOMAIN_SERVICE.changeHandler(ruTaskId, newHandlerId);
    }

    public Map<Long, List<DynamicObject>> queryTaskByNodeIds(List<Long> nodeIds) {
        return FLOW_RUSUP_DOMAIN_SERVICE.queryTaskByNodeIds(nodeIds);
    }

    public Map<Long, List<DynamicObject>> queryCanSetHandlerTaskByNodeIds(List<Long> nodeIds) {
        return FLOW_RUSUP_DOMAIN_SERVICE.queryCanSetHandlerTaskByNodeIds(nodeIds);
    }

    public Map<Long, List<DynamicObject>> queryCanSetHandlerTaskByNodeIds(ExtendedDataEntity[] dataEntities) {
        HashMap<Long, List<DynamicObject>> nodeIdTaskDyListMap = new HashMap<Long, List<DynamicObject>>(16);
        for (ExtendedDataEntity task : dataEntities) {
            List<DynamicObject> taskDyList;
            Long nodeId = task.getDataEntity().getLong("flowrunode.id");
            if (nodeIdTaskDyListMap.get(nodeId) == null) {
                taskDyList = new ArrayList(10);
                taskDyList.add(task.getDataEntity());
                nodeIdTaskDyListMap.put(nodeId, taskDyList);
                continue;
            }
            taskDyList = (List)nodeIdTaskDyListMap.get(nodeId);
            taskDyList.add(task.getDataEntity());
        }
        return nodeIdTaskDyListMap;
    }

    public DynamicObject[] queryProcByEvaObjIds(List<Long> actEvalObjIds) {
        return FLOW_RU_PROC_DOMAIN_SERVICE.queryProcByEvaObjIds(actEvalObjIds);
    }

    public DynamicObject[] queryNoOperateTasksById(List<Long> ids) {
        return FLOW_RU_PROC_DOMAIN_SERVICE.queryNoOperateTasksById(ids);
    }

    public Map<Long, String> queryRoleStatusByIds(List<Long> taskIds) {
        return FLOW_RU_PROC_DOMAIN_SERVICE.queryRoleStatusByIds(taskIds);
    }

    public Map<Long, List<Map<String, Long>>> queryBatchTaskByFitlers(QFilter qfilter) {
        return FLOW_RUSECOND_DOMAIN_SERVICE.queryBatchTaskByFitlers(qfilter);
    }

    public List<Map<String, Object>> getBatchTaskDetails(Long taskId, QFilter cusFilter) {
        return FLOW_RUSECOND_DOMAIN_SERVICE.getBatchTaskDetails(taskId, cusFilter);
    }

    public Map<Long, List<Map<String, Object>>> getAllBatchTaskDetails(List<Long> batchTaskIdList) {
        return FLOW_RUSECOND_DOMAIN_SERVICE.getAllBatchTaskDetails(batchTaskIdList);
    }

    public boolean isFormulateLastTask(Long taskId) {
        return FLOW_RUSECOND_DOMAIN_SERVICE.isFormulateLastTask(taskId);
    }

    public DynamicObject queryNodeRoleByTask(Long taskId) {
        return FLOW_RUSUP_DOMAIN_SERVICE.queryNodeRoleByTask(taskId);
    }

    public FlowRuNodeBo getRuNodeInstance(Long ruNodeId) {
        return FLOW_RUSUP_DOMAIN_SERVICE.getRuNodeInstance(ruNodeId);
    }

    public DynamicObject getTaskById(Long taskId) {
        return FLOW_RU_PROC_DOMAIN_SERVICE.getTaskById(taskId);
    }

    public Map<Long, String> getSubmitTaskStatus(List<Long> taskIds) {
        return FLOW_RU_PROC_DOMAIN_SERVICE.getSubmitTaskStatus(taskIds);
    }

    public boolean submitTask(Long taskId) {
        return FLOW_RU_PROC_DOMAIN_SERVICE.submitTask(taskId);
    }

    public Map<Long, Boolean> submitTask(List<Long> taskIds) {
        return FLOW_RU_PROC_DOMAIN_SERVICE.submitTask(taskIds);
    }

    public Long queryDefNodeByTaskId(Long taskId) {
        return FLOW_RU_PROC_DOMAIN_SERVICE.queryDefNodeByTaskId(taskId);
    }

    public Map<Long, Long> queryDefNodeByTaskIds(List<Long> taskIds) {
        return FLOW_RU_NODE_ENTITY_SERVICE.queryDefNodeByTaskIds(taskIds);
    }

    public FlowValidateResultBo batchRollbackTasks(List<Long> taskIds, String reason) {
        return FLOW_RUSECOND_DOMAIN_SERVICE.batchRollbackTasks(taskIds, reason);
    }

    public DynamicObject[] queryTaskByIds(List<Long> taskIds) {
        return FLOW_RUSECOND_DOMAIN_SERVICE.queryTaskByIds(taskIds);
    }

    public String getTaskStatus(Long taskId) {
        return FLOW_RU_PROC_DOMAIN_SERVICE.getTaskStateCode(taskId);
    }

    public Map<Long, Integer> getTaskIdIndexMap(List<Long> taskIds) {
        return FLOW_RU_PROC_DOMAIN_SERVICE.getTaskIdIndexMap(taskIds);
    }

    public NodeIdAndTaskIdMapVO getNodeIdAndTaskIdMapVO(List<Long> taskIds) {
        return FLOW_RUSECOND_DOMAIN_SERVICE.getNodeIdAndTaskIdMapVO(taskIds);
    }

    public DynamicObject[] haveInHandCompleteProcs(Long activityId, Long procDefId) {
        return FLOW_RU_PROC_DOMAIN_SERVICE.procsProgressingOrFinishByProdefActivity(activityId, procDefId);
    }

    public FlowValidateResultBo rollbackToSpecifiedNode(List<RollbackParamBo> rollbackParamBos) {
        return FLOW_RUSECOND_DOMAIN_SERVICE.rollbackToSpecifiedNode(rollbackParamBos);
    }

    public FlowValidateResultBo rollbackToLastNodeOrRole(List<RollbackParamBo> rollbackParamBos) {
        return FLOW_RUSECOND_DOMAIN_SERVICE.rollbackToLastNodeOrRole(rollbackParamBos);
    }

    public FlowValidateResultBo rollbackToSpecifiedTask(List<RollbackParamBo> rollbackParamBos) {
        return FLOW_RUSECOND_DOMAIN_SERVICE.rollbackToSpecifiedTask(rollbackParamBos);
    }
}

