/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.pbs.business.application.service.workflow;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.hr.hbp.business.application.impl.newhismodel.HisModelController;
import kd.hr.hbp.business.domain.model.newhismodel.HisBaseBo;
import kd.hr.hbp.business.domain.model.newhismodel.HisResponse;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamBo;
import kd.hr.hbp.business.domain.model.newhismodel.VersionChangeRespData;
import kd.hr.hbp.business.domain.model.newhismodel.enable.HisEnableParamBo;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisDisabledService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisVersionChangeService;
import kd.hr.hbp.common.constants.newhismodel.EnumHisOperateType;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.opmc.pbs.business.ServiceFactory;
import kd.opmc.pbs.business.application.service.workflow.FlowDefProcApplicationService;
import kd.opmc.pbs.business.application.service.workflow.FlowRuProcApplicationService;
import kd.opmc.pbs.business.domain.workflow.model.CheckFlowBo;
import kd.opmc.pbs.business.domain.workflow.service.FlowRuSecondDomainService;
import kd.opmc.pbs.business.domain.workflow.service.WorkFlowDomainService;

public class WorkFlowApplicationService {
    private static final WorkFlowDomainService WORK_FLOW_DOMAIN_SERVICE = WorkFlowDomainService.getInstance();
    private static final FlowDefProcApplicationService FLOW_DEF_PROC_APPLICATION_SERVICE = FlowDefProcApplicationService.getInstance();
    private static final FlowRuSecondDomainService FLOW_RU_SECOND_DOMAIN_SERVICE = FlowRuSecondDomainService.getInstance();
    private static final FlowRuProcApplicationService FLOW_RU_PROC_APPLICATION_SERVICE = FlowRuProcApplicationService.getInstance();

    public static WorkFlowApplicationService getInstance() {
        return ServiceFactory.getService(WorkFlowApplicationService.class);
    }

    public void disableOrEnableFlow(boolean disabled, long id, String entityNumber) {
        HisBaseBo hisBo = new HisBaseBo();
        hisBo.setEntityNumber(entityNumber);
        hisBo.setBoIdList(Collections.singletonList(id));
        HisEnableParamBo hisEnableParamBo = new HisEnableParamBo();
        hisEnableParamBo.setDisabled(disabled);
        hisEnableParamBo.setHisBaseBo(hisBo);
        hisEnableParamBo.setEffectDate(new Date());
        HisDisabledService hisDisabledService = new HisDisabledService();
        hisDisabledService.disableOrEnableBo(hisEnableParamBo);
    }

    public void disableOrEnableFlow(DynamicObject flow) {
        WORK_FLOW_DOMAIN_SERVICE.save(flow);
    }

    public HisResponse<VersionChangeRespData> hisVersionChange(DynamicObject[] hisDyns, String entityNumber, boolean effImmediately) {
        HisVersionParamBo hisVersionParamBo = new HisVersionParamBo();
        hisVersionParamBo.setEffImmediately(effImmediately);
        hisVersionParamBo.setAtomicTrans(true);
        hisVersionParamBo.setEntityNumber(entityNumber);
        hisVersionParamBo.setOperateType(EnumHisOperateType.SAVE_VERSION.getType());
        hisVersionParamBo.setHisDyns(hisDyns);
        return HisVersionChangeService.getInstance().hisVersionChange(hisVersionParamBo);
    }

    public void deleteBo(long id, String entityNumber) {
        HisModelController hisModelController = new HisModelController();
        HisBaseBo hisBaseBo = new HisBaseBo();
        hisBaseBo.setBoIdList(Collections.singletonList(id));
        hisBaseBo.setEntityNumber(entityNumber);
        hisModelController.deleteBo(hisBaseBo);
    }

    public boolean validatorFlowData(DynamicObjectCollection flowEntry, long flowId, List<CheckFlowBo> checkFlowBos) {
        List<Long> flowIds = flowEntry.stream().map(dynamicObject -> dynamicObject.getLong("flowid")).collect(Collectors.toList());
        DynamicObject currentWorkflow = WORK_FLOW_DOMAIN_SERVICE.getWorkflowById(flowId);
        DynamicObject[] workflows = WORK_FLOW_DOMAIN_SERVICE.getWorkflowsByIdAndFlowType(flowIds, currentWorkflow.getString("workflowtype"));
        DynamicObject workflow = this.getLastWorkflow(flowId);
        return FLOW_DEF_PROC_APPLICATION_SERVICE.validatorFlowData(workflows, workflow, checkFlowBos);
    }

    public DynamicObject getLastWorkflow(long flowBoId) {
        DynamicObject workflow = this.getTempWorkflow(flowBoId);
        if (HRObjectUtils.isEmpty((Object)workflow)) {
            workflow = this.getWorkflow(flowBoId);
        }
        return workflow;
    }

    public DynamicObject[] getWorkflows(List<Long> flowIds) {
        return WORK_FLOW_DOMAIN_SERVICE.getWorkflows(flowIds);
    }

    public DynamicObject[] getAllWorkflows(List<Long> flowIds) {
        return WORK_FLOW_DOMAIN_SERVICE.getAllWorkflows(flowIds);
    }

    public DynamicObject[] getWorkflowsByVid(List<Long> vids) {
        return WORK_FLOW_DOMAIN_SERVICE.getWorkflowsByVid(vids);
    }

    public DynamicObject[] getWorkflowsByVids(List<Long> vids) {
        return WORK_FLOW_DOMAIN_SERVICE.getWorkflowsByVids(vids);
    }

    public DynamicObject[] getPublishFlows(List<Long> flowIds) {
        return WORK_FLOW_DOMAIN_SERVICE.getPublishFlows(flowIds);
    }

    public DynamicObject getWorkflow(long flowId) {
        return WORK_FLOW_DOMAIN_SERVICE.getWorkflow(flowId);
    }

    public DynamicObject getTempWorkflow(long flowId) {
        return WORK_FLOW_DOMAIN_SERVICE.getTempWorkflow(flowId);
    }

    public DynamicObject getCurrentWorkflow(long flowId) {
        return WORK_FLOW_DOMAIN_SERVICE.getCurrentWorkflow(flowId);
    }

    public DynamicObject getCurrentTempWorkflow(long flowId) {
        return WORK_FLOW_DOMAIN_SERVICE.getCurrentTempWorkflow(flowId);
    }

    public DynamicObject[] getCurrentTempWorkflows(List<Long> flowIds) {
        return WORK_FLOW_DOMAIN_SERVICE.getCurrentTempWorkflows(flowIds);
    }

    public DynamicObject[] getCopyTempWorkflow(List<Long> flowIds) {
        return WORK_FLOW_DOMAIN_SERVICE.getCopyTempWorkflow(flowIds);
    }

    public DynamicObject generateEmptyDynamicObject() {
        return WORK_FLOW_DOMAIN_SERVICE.generateEmptyDynamicObject();
    }

    public void deleteBackupFlows(List<Long> flowIds) {
        WORK_FLOW_DOMAIN_SERVICE.deleteBackupFlows(flowIds);
    }

    public DynamicObject getChangeLastWorkflow(long flowBoId) {
        DynamicObject workflow = this.getCurrentTempWorkflow(flowBoId);
        if (HRObjectUtils.isEmpty((Object)workflow)) {
            workflow = this.getCurrentWorkflow(flowBoId);
        }
        return workflow;
    }

    public DynamicObject getWorkflowById(long flowId) {
        return WORK_FLOW_DOMAIN_SERVICE.getWorkflowById(flowId);
    }

    public Object save(DynamicObject dynamicObject) {
        return WORK_FLOW_DOMAIN_SERVICE.save(dynamicObject);
    }

    public Object[] save(DynamicObjectCollection dynamicObjects) {
        return WORK_FLOW_DOMAIN_SERVICE.save(dynamicObjects);
    }

    public DynamicObject getWorkflowVersion(long flowId) {
        return WORK_FLOW_DOMAIN_SERVICE.getWorkflowVersion(flowId);
    }

    public Map<Long, String> queryTasksStatusByIds(List<Long> taskIds) {
        return FLOW_RU_SECOND_DOMAIN_SERVICE.queryTasksStatusByIds(taskIds);
    }

    public DynamicObject getSaveOrEffWorkflows(long flowId) {
        return WORK_FLOW_DOMAIN_SERVICE.getSaveOrEffWorkflows(flowId);
    }

    public DynamicObject[] loadWorkflows(Set<Long> workflowIds) {
        return WORK_FLOW_DOMAIN_SERVICE.loadWorkflows(workflowIds);
    }

    public DynamicObject[] haveInHandCompleteProcs(Long activityId, Long procDefId) {
        return FLOW_RU_PROC_APPLICATION_SERVICE.haveInHandCompleteProcs(activityId, procDefId);
    }
}

