/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.pbs.business.domain.flowscan.entityservice;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.pbs.business.ServiceFactory;
import kd.opmc.pbs.business.domain.OpmcEntityService;
import kd.opmc.pbs.business.domain.flowscan.entity.BatchFlowTaskResultBo;
import kd.opmc.pbs.business.domain.flowscan.enums.EntryTaskStatusEnum;
import kd.opmc.pbs.business.domain.flowscan.enums.TaskStatusEnum;
import kd.opmc.pbs.business.domain.flowscan.enums.TaskTypeEnum;
import kd.opmc.pbs.business.domain.workflow.entity.FlowRuProcBo;

public class BatchStartEvalEntityService
extends OpmcEntityService {
    private static final Log LOG = LogFactory.getLog(BatchStartEvalEntityService.class);
    private static final HRBaseServiceHelper HELPER = new HRBaseServiceHelper("pbs_batchstartevaobj");
    private static final int BATCH_NUM = 1000;

    public static BatchStartEvalEntityService getInstance() {
        return ServiceFactory.getService(BatchStartEvalEntityService.class);
    }

    public BatchFlowTaskResultBo generateBatchFlowTaskData(List<FlowRuProcBo> flowRuProcBoList, String tasktype) {
        int batchSize = 0;
        StringBuilder msgSb = new StringBuilder();
        ArrayList<Long> batchTaskIdList = new ArrayList<Long>(10);
        int ruProcBoSize = flowRuProcBoList.size();
        ArrayList<FlowRuProcBo> flowRuProcBoTmpList = new ArrayList<FlowRuProcBo>(10);
        for (int i = 0; i < ruProcBoSize; ++i) {
            flowRuProcBoTmpList.add(flowRuProcBoList.get(i));
            if (i > 0 && i % 1000 == 0) {
                batchTaskIdList.addAll(this.saveBatchFlowTaskData(flowRuProcBoTmpList, tasktype));
                flowRuProcBoTmpList.clear();
                ++batchSize;
                continue;
            }
            if (i != ruProcBoSize - 1 || flowRuProcBoTmpList.size() <= 0) continue;
            batchTaskIdList.addAll(this.saveBatchFlowTaskData(flowRuProcBoTmpList, tasktype));
            ++batchSize;
        }
        msgSb.append(MessageFormat.format(ResManager.loadKDString((String)"\u5171\u542f\u52a8{0}\u6761\u6570\u636e\uff0c\u5206\u4e3a{1}\u6279\u6b21\u5904\u7406\uff0c", (String)"BatchStartEvalEntityService_0", (String)"opmc-pbs-business", (Object[])new Object[0]), flowRuProcBoList.size(), batchSize));
        return this.buildResultInfo("1", msgSb.toString(), batchTaskIdList);
    }

    private BatchFlowTaskResultBo buildResultInfo(String operationType, String resultDetail, List<Long> batchTaskIdList) {
        BatchFlowTaskResultBo batchFlowTaskResultBo = new BatchFlowTaskResultBo();
        batchFlowTaskResultBo.setOperationType(operationType);
        batchFlowTaskResultBo.setResultDetial(resultDetail);
        batchFlowTaskResultBo.setBatchTaskIdList(batchTaskIdList);
        return batchFlowTaskResultBo;
    }

    private List<Long> saveBatchFlowTaskData(List<FlowRuProcBo> flowRuProcBoList, String tasktype) {
        try {
            if (flowRuProcBoList.isEmpty()) {
                return new ArrayList<Long>(10);
            }
            Date date = new Date();
            long userId = UserServiceHelper.getCurrentUserId();
            DynamicObject batchFlowTaskData = this.generateEmptyDynamicObject();
            batchFlowTaskData.set("creator", (Object)userId);
            batchFlowTaskData.set("createtime", (Object)date);
            batchFlowTaskData.set("modifier", (Object)userId);
            batchFlowTaskData.set("modifytime", (Object)date);
            batchFlowTaskData.set("taskstatus", (Object)TaskStatusEnum.UNPROCESS.getValue());
            batchFlowTaskData.set("tasktype", (Object)tasktype);
            if (HRStringUtils.isEmpty((String)flowRuProcBoList.get(0).getBatchNo())) {
                String batchno = this.requireBatchNo(batchFlowTaskData);
                batchFlowTaskData.set("batchno", (Object)batchno);
            } else {
                batchFlowTaskData.set("batchno", (Object)flowRuProcBoList.get(0).getBatchNo());
            }
            DynamicObjectCollection dyColl = this.generateEmptyEntryCollection(batchFlowTaskData, "entryentity");
            for (FlowRuProcBo flowRuProcBo : flowRuProcBoList) {
                DynamicObject entryDy = this.generateEmptyEntryDynamicObject("entryentity");
                flowRuProcBo.setBatchNo(batchFlowTaskData.getString("batchno"));
                entryDy.set("actevaobj", (Object)flowRuProcBo.getActEvalObjId());
                entryDy.set("ruprocparam", (Object)SerializationUtils.toJsonString((Object)flowRuProcBo));
                entryDy.set("entrytaskstatus", (Object)EntryTaskStatusEnum.UNEXECUTE.getValue());
                entryDy.set("excutecount", (Object)0);
                dyColl.add((Object)entryDy);
            }
            Object pk = this.saveOne(batchFlowTaskData);
            ArrayList<Long> batchStartIdList = new ArrayList<Long>(1);
            batchStartIdList.add(((DynamicObject)pk).getLong("id"));
            return batchStartIdList;
        }
        catch (Exception e) {
            LOG.error(" OPMC_PBS_ERROR : saveBatchFlowTaskData flowRuProcBoList [{}] tasktype [{}] ", (Object)SerializationUtils.toJsonString(flowRuProcBoList), (Object)tasktype);
            return new ArrayList<Long>(10);
        }
    }

    private String requireBatchNo(DynamicObject batchFlowTaskData) {
        CodeRuleInfo codeRule = CodeRuleServiceHelper.getCodeRule((String)batchFlowTaskData.getDataEntityType().getName(), (DynamicObject)batchFlowTaskData, null);
        return CodeRuleServiceHelper.getNumber((CodeRuleInfo)codeRule, (DynamicObject)batchFlowTaskData);
    }

    public String requireBatchNoByBatchTask(TaskTypeEnum taskTypeEnum) {
        DynamicObject batchFlowTaskData = this.generateEmptyDynamicObject();
        batchFlowTaskData.set("tasktype", (Object)taskTypeEnum.getValue());
        CodeRuleInfo codeRule = CodeRuleServiceHelper.getCodeRule((String)batchFlowTaskData.getDataEntityType().getName(), (DynamicObject)batchFlowTaskData, null);
        return CodeRuleServiceHelper.getNumber((CodeRuleInfo)codeRule, (DynamicObject)batchFlowTaskData);
    }

    @Override
    protected HRBaseServiceHelper getServiceHelper() {
        return HELPER;
    }

    public DynamicObject[] queryUnProcessFlowTask(int top) {
        return HELPER.query("id,batchno,tasktype,taskstatus,creator,createtime,modifier,modifytime,starttime,endtime,entryentity.actevaobj,entryentity.ruprocparam,entryentity.ruprocid,entryentity.entrytaskstatus,entryentity.taskmsg,entryentity.excutecount", new QFilter[]{new QFilter("taskstatus", "=", (Object)TaskStatusEnum.UNPROCESS.getValue())}, "createtime", top);
    }

    public DynamicObject[] queryUnProcessFlowTaskByCusFilter(QFilter cusFilter) {
        return HELPER.query("id,batchno,tasktype,taskstatus,creator,createtime,modifier,modifytime,starttime,endtime,entryentity.actevaobj,entryentity.ruprocparam,entryentity.ruprocid,entryentity.entrytaskstatus,entryentity.taskmsg,entryentity.excutecount", new QFilter[]{cusFilter});
    }

    public void updateBatchTaskStatus(List<Long> batchTaskIdList, TaskStatusEnum taskStatusEnum) {
        QFilter filter = new QFilter("id", "in", batchTaskIdList);
        DynamicObject[] batchTaskDyns = HELPER.query("id,taskstatus,modifytime", new QFilter[]{filter});
        Date curDate = new Date();
        for (DynamicObject batchTask : batchTaskDyns) {
            batchTask.set("taskstatus", (Object)taskStatusEnum.getValue());
            batchTask.set("modifytime", (Object)curDate);
        }
        this.save(batchTaskDyns);
    }

    public List<Long> getActevaobjUnCompletedTask(List<Long> evaObjIdList, String taskType) {
        ArrayList<Long> unCompleActevaObjIdList = new ArrayList<Long>(10);
        try {
            QFilter filter = new QFilter("entryentity.actevaobj", "in", evaObjIdList);
            filter.and(new QFilter("entryentity.entrytaskstatus", "not in", (Object)EntryTaskStatusEnum.COMPLETED.getValue()));
            filter.and(new QFilter("tasktype", "=", (Object)taskType));
            DynamicObject[] batchStartDyns = HELPER.query("id,entryentity.actevaobj,entryentity.entrytaskstatus,entryentity.excutecount,starttime,endtime,taskstatus,createtime", new QFilter[]{filter});
            ArrayList<DynamicObject> needRestBatchTaskList = new ArrayList<DynamicObject>(10);
            Date now = new Date();
            long userId = UserServiceHelper.getCurrentUserId();
            for (DynamicObject batchStartDy : batchStartDyns) {
                String taskStatus = batchStartDy.getString("taskstatus");
                long diffTime = now.getTime() - batchStartDy.getDate("createtime").getTime();
                long diffTime2 = now.getTime() - batchStartDy.getDate("starttime").getTime();
                if (HRStringUtils.equals((String)taskStatus, (String)TaskStatusEnum.UNPROCESS.getValue()) && diffTime / 1000L / 60L > 3L || (HRStringUtils.equals((String)taskStatus, (String)TaskStatusEnum.PROCESSING.getValue()) || HRStringUtils.equals((String)taskStatus, (String)TaskStatusEnum.PUSHED.getValue())) && diffTime2 / 1000L / 60L > 5L) {
                    batchStartDy.set("creator", (Object)userId);
                    batchStartDy.set("createtime", (Object)now);
                    batchStartDy.set("starttime", (Object)now);
                    batchStartDy.set("modifier", (Object)userId);
                    batchStartDy.set("modifytime", (Object)now);
                    batchStartDy.set("taskstatus", (Object)TaskStatusEnum.UNPROCESS.getValue());
                    needRestBatchTaskList.add(batchStartDy);
                }
                DynamicObjectCollection batchStartEntyColl = batchStartDy.getDynamicObjectCollection("entryentity");
                for (DynamicObject entry : batchStartEntyColl) {
                    if (!EntryTaskStatusEnum.UNEXECUTE.getValue().equals(entry.getString("entrytaskstatus")) || diffTime / 1000L / 60L >= 3L) continue;
                    unCompleActevaObjIdList.add(entry.getLong("actevaobj"));
                }
            }
            HELPER.save(needRestBatchTaskList.toArray(new DynamicObject[0]));
        }
        catch (Exception e) {
            LOG.error("\u3010OPMC\u3011-getActevaobjUnCompletedTask error,traceId={},,msg is {}", (Object)RequestContext.get().getTraceId(), (Object)e.getMessage());
        }
        return unCompleActevaObjIdList;
    }
}

