/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.pbs.business.domain.flowscan.service;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.pbs.business.ServiceFactory;
import kd.opmc.pbs.business.domain.flowscan.entity.BatchFlowTaskResultBo;
import kd.opmc.pbs.business.domain.flowscan.entity.ReWriteEvalObjInfo;
import kd.opmc.pbs.business.domain.flowscan.entity.ReWriteEvalObjRequest;
import kd.opmc.pbs.business.domain.flowscan.entityservice.BatchStartEvalEntityService;
import kd.opmc.pbs.business.domain.flowscan.enums.EntryTaskStatusEnum;
import kd.opmc.pbs.business.domain.flowscan.enums.TaskStatusEnum;
import kd.opmc.pbs.business.domain.flowscan.enums.TaskTypeEnum;
import kd.opmc.pbs.business.domain.workflow.dto.SendMessageDTO;
import kd.opmc.pbs.business.domain.workflow.entity.FlowMsgMergeEnumBO;
import kd.opmc.pbs.business.domain.workflow.entity.FlowRuProcBo;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuMsgMergeEnum;
import kd.opmc.pbs.business.domain.workflow.service.FlowHandlerBatchDomainService;
import kd.opmc.pbs.business.domain.workflow.service.FlowRuProcBatchDomainService;
import kd.opmc.pbs.business.domain.workflow.service.FlowRuProcDomainService;
import kd.opmc.pbs.business.external.epa.IEPAActevalobjService;
import kd.opmc.pbs.common.utils.CommonResultBo;

public class BatchFlowTaskService {
    private static final BatchStartEvalEntityService BATCH_START_EVAL_ENTITY_SERVICE = BatchStartEvalEntityService.getInstance();
    private static final FlowRuProcDomainService FLOW_RU_PROC_DOMAIN_SERVICE = FlowRuProcDomainService.getInstance();
    private static final FlowRuProcBatchDomainService FLOW_RU_PROC_BATCH_DOMAIN_SERVICE = FlowRuProcBatchDomainService.getInstance();
    private static final FlowHandlerBatchDomainService FLOW_HANDLER_BATCH_DOMAIN_SERVICE = FlowHandlerBatchDomainService.getInstance();
    protected static final IEPAActevalobjService EPA_ACTEVAOBJ_SERVICE = IEPAActevalobjService.getInstance();
    private static final Log LOG = LogFactory.getLog(BatchStartEvalEntityService.class);

    public static BatchFlowTaskService getInstance() {
        return ServiceFactory.getService(BatchFlowTaskService.class);
    }

    public BatchFlowTaskResultBo batchFlowTaskWrite(List<FlowRuProcBo> flowRuProcBoList, String tasktype) {
        if (CollectionUtils.isEmpty(flowRuProcBoList)) {
            return this.buildResultInfo("0", ResManager.loadKDString((String)"\u8bf7\u6c42\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BatchFlowTaskService_0", (String)"opmc-pbs-business", (Object[])new Object[0]));
        }
        return BATCH_START_EVAL_ENTITY_SERVICE.generateBatchFlowTaskData(flowRuProcBoList, tasktype);
    }

    private BatchFlowTaskResultBo buildResultInfo(String operationType, String resultDetail) {
        BatchFlowTaskResultBo batchFlowTaskResultBo = new BatchFlowTaskResultBo();
        batchFlowTaskResultBo.setOperationType(operationType);
        batchFlowTaskResultBo.setResultDetial(resultDetail);
        return batchFlowTaskResultBo;
    }

    public DynamicObject[] queryUnProcessFlowTask(int top) {
        return BATCH_START_EVAL_ENTITY_SERVICE.queryUnProcessFlowTask(top);
    }

    public String requireBatchNoByBatchTask(TaskTypeEnum taskTypeEnum) {
        return BATCH_START_EVAL_ENTITY_SERVICE.requireBatchNoByBatchTask(taskTypeEnum);
    }

    public void batchFlowTaskScanExe(RequestContext requestContext, Map<String, Object> map) {
        ArrayList<DynamicObject> needAutoCompensationTaskList = new ArrayList<DynamicObject>(10);
        QFilter cusFilter = new QFilter("taskstatus", "in", Arrays.asList(TaskStatusEnum.UNPROCESS.getValue(), TaskStatusEnum.PROCESSING.getValue(), TaskStatusEnum.PUSHED.getValue()));
        DynamicObject[] taskDyArry = BATCH_START_EVAL_ENTITY_SERVICE.queryUnProcessFlowTaskByCusFilter(cusFilter);
        int handleLimitTime = Integer.parseInt(map.get("handleLimitTime").toString());
        int unHandleLimitTime = Integer.parseInt(map.get("unHandleLimitTime").toString());
        Date now = new Date();
        for (DynamicObject batchTask : taskDyArry) {
            String taskStatus = batchTask.getString("taskstatus");
            long diffTime = now.getTime() - batchTask.getDate("createtime").getTime();
            long diffTime2 = now.getTime() - batchTask.getDate("starttime").getTime();
            if ((!HRStringUtils.equals((String)taskStatus, (String)TaskStatusEnum.UNPROCESS.getValue()) || diffTime / 1000L / 60L <= (long)unHandleLimitTime) && (!HRStringUtils.equals((String)taskStatus, (String)TaskStatusEnum.PROCESSING.getValue()) && !HRStringUtils.equals((String)taskStatus, (String)TaskStatusEnum.PUSHED.getValue()) || diffTime2 / 1000L / 60L <= (long)handleLimitTime)) continue;
            needAutoCompensationTaskList.add(batchTask);
        }
        if (needAutoCompensationTaskList.size() > 0) {
            this.setTaskDyStatus(requestContext, needAutoCompensationTaskList.toArray(new DynamicObject[0]), TaskStatusEnum.PROCESSING);
            List<DynamicObject> failedTaskList = this.processFlowTask(needAutoCompensationTaskList.toArray(new DynamicObject[0]));
            this.setTaskDyStatus(requestContext, needAutoCompensationTaskList.toArray(new DynamicObject[0]), TaskStatusEnum.PROCESSED);
            if (!CollectionUtils.isEmpty(failedTaskList)) {
                this.setTaskDyStatus(requestContext, failedTaskList.toArray(new DynamicObject[0]), TaskStatusEnum.UNPROCESS);
            }
        }
    }

    private int requireTopNum(Map<String, Object> map) {
        int top = 5;
        String exeBatchNumStr = (String)map.get("exeBatchNum");
        if (HRStringUtils.isNotEmpty((String)exeBatchNumStr)) {
            top = Integer.parseInt(exeBatchNumStr);
        }
        return top;
    }

    private List<DynamicObject> processFlowTask(DynamicObject[] taskDyArry) {
        ArrayList<DynamicObject> failedTaskList = new ArrayList<DynamicObject>(taskDyArry.length);
        for (DynamicObject dy : taskDyArry) {
            try {
                String taskType = dy.getString("tasktype");
                String batchNo = dy.getString("batchno");
                if (HRStringUtils.isEmpty((String)taskType)) {
                    LOG.info("batchFlowTaskScanExe : batchno[{}] - task's taskType is empty.", (Object)batchNo);
                    continue;
                }
                ReWriteEvalObjRequest reWriteEvalObjRequest = new ReWriteEvalObjRequest();
                this.processFlowTaskWithEntry(dy, reWriteEvalObjRequest, taskType, batchNo);
                dy.set("taskstatus", (Object)TaskStatusEnum.PROCESSED.getValue());
                Date date = new Date();
                dy.set("endtime", (Object)date);
                this.reWriteStatus2Invoker(dy, reWriteEvalObjRequest);
                if (!HRStringUtils.equals((String)taskType, (String)TaskTypeEnum.INDICATOR_START.getValue()) && !HRStringUtils.equals((String)taskType, (String)TaskTypeEnum.EVAL_START.getValue()) && !HRStringUtils.equals((String)taskType, (String)TaskTypeEnum.INTERVIEW_START.getValue())) continue;
                this.batchSendMsg2Handler(dy, batchNo);
            }
            catch (Exception e) {
                LOG.error("\u3010OPMC\u3011-processFlowTask error,batchNo is {},message is {}", (Object)dy.getString("batchno"), (Object)e);
                failedTaskList.add(dy);
            }
        }
        return failedTaskList;
    }

    private void processFlowTaskWithEntry(DynamicObject batchTaskDyn, ReWriteEvalObjRequest reWriteEvalObjRequest, String taskType, String batchNo) {
        Long actEvaObjId;
        DynamicObjectCollection entryEntityColl = batchTaskDyn.getDynamicObjectCollection("entryentity");
        reWriteEvalObjRequest.setTaskType(taskType);
        reWriteEvalObjRequest.setBatchNo(batchNo);
        int failureCount = 0;
        int suspendCount = 0;
        ArrayList<FlowRuProcBo> preFlowRuProcBoList = new ArrayList<FlowRuProcBo>(10);
        ArrayList<FlowRuProcBo> startFlowRuProcBoList = new ArrayList<FlowRuProcBo>(10);
        ArrayList<Long> allActEvaObjIdList = new ArrayList<Long>(10);
        for (DynamicObject entryEntityDy : entryEntityColl) {
            allActEvaObjIdList.add(entryEntityDy.getLong("actevaobj"));
        }
        DynamicObject[] existActEvaObjDyns = null;
        existActEvaObjDyns = TaskTypeEnum.INT_PRE_INSTANTIATION.getValue().equals(taskType) || TaskTypeEnum.INTERVIEW_START.getValue().equals(taskType) ? IEPAActevalobjService.getInstance().getIntObjArrayById(allActEvaObjIdList) : IEPAActevalobjService.getInstance().getActevalobjArrayById(allActEvaObjIdList);
        List existActEvaObjIdList = Arrays.stream(existActEvaObjDyns).map(o -> o.getLong("id")).collect(Collectors.toList());
        for (DynamicObject entryEntityDy : entryEntityColl) {
            if (entryEntityDy.getString("entrytaskstatus").equals(EntryTaskStatusEnum.COMPLETED.getValue()) || entryEntityDy.getInt("excutecount") > 3) continue;
            String ruProcParam = entryEntityDy.getString("ruprocparam");
            FlowRuProcBo flowRuProcBo = null;
            try {
                flowRuProcBo = this.formJsonStr2FlowRuProBo(ruProcParam);
            }
            catch (Exception e) {
                LOG.error("\u3010OPMC\u3011-processFlowTaskWithEntry\uff0cformJsonStr2FlowRuProBo error,traceId is {},message is {}", (Object)RequestContext.get().getTraceId(), (Object)e.getMessage());
            }
            actEvaObjId = entryEntityDy.getLong("actevaobj");
            if (Objects.isNull(flowRuProcBo) || !existActEvaObjIdList.contains(actEvaObjId)) {
                entryEntityDy.set("ruprocid", null);
                entryEntityDy.set("entrytaskstatus", (Object)EntryTaskStatusEnum.FAILED.getValue());
                entryEntityDy.set("taskmsg", (Object)" Flow's flowRuProcBo is null.");
                ++failureCount;
                reWriteEvalObjRequest.setReWriteEvalObjInfoList(entryEntityDy.getLong("actevaobj"), null, Boolean.FALSE);
                LOG.error("\u3010OPMC\u3011-batchFlowTaskScanExe error: batchno[{}] - task's flowRuProcBo is null or actevaobj is not exist.", (Object)batchNo);
                continue;
            }
            if (HRStringUtils.equals((String)taskType, (String)TaskTypeEnum.INDICATOR_START.getValue()) || HRStringUtils.equals((String)taskType, (String)TaskTypeEnum.EVAL_START.getValue()) || HRStringUtils.equals((String)taskType, (String)TaskTypeEnum.INTERVIEW_START.getValue())) {
                startFlowRuProcBoList.add(flowRuProcBo);
                continue;
            }
            preFlowRuProcBoList.add(flowRuProcBo);
        }
        CommonResultBo resultBo = new CommonResultBo();
        if (!CollectionUtils.isEmpty(preFlowRuProcBoList)) {
            resultBo = FLOW_RU_PROC_BATCH_DOMAIN_SERVICE.preCreateProcessInstance(preFlowRuProcBoList, null);
        } else if (!CollectionUtils.isEmpty(startFlowRuProcBoList)) {
            resultBo = FLOW_RU_PROC_BATCH_DOMAIN_SERVICE.startBatchProcess(startFlowRuProcBoList);
        }
        Map actevaobjProcMap = resultBo.getResultMap();
        for (DynamicObject entryEntityDy : entryEntityColl) {
            actEvaObjId = entryEntityDy.getLong("actevaobj");
            if (null != actevaobjProcMap && null != actevaobjProcMap.get(actEvaObjId)) {
                Long ruProcId = (Long)actevaobjProcMap.get(actEvaObjId);
                entryEntityDy.set("taskmsg", (Object)MessageFormat.format("actEvaObjId={0},deal data success.", actEvaObjId));
                entryEntityDy.set("entrytaskstatus", (Object)EntryTaskStatusEnum.COMPLETED.getValue());
                entryEntityDy.set("ruprocid", (Object)ruProcId);
                reWriteEvalObjRequest.setReWriteEvalObjInfoList(entryEntityDy.getLong("actevaobj"), entryEntityDy.getLong("ruprocid"), Boolean.TRUE);
                LOG.info("batchFlowTaskScanExe : batchno[{}] -actEvaObjId={},traceId={},process data sucess.", new Object[]{batchNo, actEvaObjId, RequestContext.get().getTraceId()});
            } else {
                LOG.error("batchFlowTaskScanExe error: batchno[{}] -actEvaObjId={},traceId={}.", new Object[]{batchNo, actEvaObjId, RequestContext.get().getTraceId()});
                ++failureCount;
                entryEntityDy.set("ruprocid", null);
                entryEntityDy.set("taskmsg", (Object)MessageFormat.format("actEvaObjId={0},process data failure.{1}", actEvaObjId, entryEntityDy.get("taskmsg")));
                entryEntityDy.set("entrytaskstatus", (Object)EntryTaskStatusEnum.FAILED.getValue());
                reWriteEvalObjRequest.setReWriteEvalObjInfoList(entryEntityDy.getLong("actevaobj"), null, Boolean.FALSE);
            }
            entryEntityDy.set("excutecount", (Object)(entryEntityDy.getInt("excutecount") + 1));
        }
        reWriteEvalObjRequest.setCount(entryEntityColl.size(), failureCount, suspendCount, entryEntityColl.size() - failureCount);
    }

    private FlowRuProcBo formJsonStr2FlowRuProBo(String ruProcParam) {
        Map map = (Map)SerializationUtils.fromJsonString((String)ruProcParam, Map.class);
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("hrpi_person");
        DynamicObject person = hrBaseServiceHelper.generateEmptyDynamicObject();
        person.set("id", ((Map)map.get("person")).get("id"));
        FlowRuProcBo flowRuProcBo = FlowRuProcBo.builder().flowVid(this.dataType2Long(map.get("flowVid"))).person(person).perfOrgId(this.dataType2Long(map.get("perfOrgId"))).adminOrgId(this.dataType2Long(map.get("adminOrgId"))).assessYear((Integer)map.get("assessYear")).assessPeriod((String)map.get("assessPeriod")).actEvalObjId(this.dataType2Long(map.get("actEvalObjId"))).activityId(this.dataType2Long(map.get("activityId"))).empPosRelId(this.dataType2Long(map.get("empPosRelId"))).settingMode((String)map.get("settingMode")).workflowType((String)map.get("workflowType")).batchNo((String)map.get("batchNo")).build();
        return flowRuProcBo;
    }

    private Long dataType2Long(Object obj) {
        if (Objects.isNull(obj)) {
            return null;
        }
        if (obj instanceof Integer) {
            return ((Integer)obj).longValue();
        }
        if (obj instanceof Long) {
            return (Long)obj;
        }
        return null;
    }

    private void batchSendMsg2Handler(DynamicObject dy, String batchNo) {
        String taskType = dy.getString("tasktype");
        if (!(HRStringUtils.equals((String)taskType, (String)TaskTypeEnum.INDICATOR_START.getValue()) || HRStringUtils.equals((String)taskType, (String)TaskTypeEnum.EVAL_START.getValue()) || HRStringUtils.equals((String)taskType, (String)TaskTypeEnum.INTERVIEW_START.getValue()))) {
            return;
        }
        FlowMsgMergeEnumBO flowMsgMergeEnumBO = new FlowMsgMergeEnumBO(FlowRuMsgMergeEnum.START_EVALUATE_SIN, FlowRuMsgMergeEnum.START_EVALUATE_MUL);
        if (HRStringUtils.equals((String)taskType, (String)TaskTypeEnum.INDICATOR_START.getValue())) {
            flowMsgMergeEnumBO = new FlowMsgMergeEnumBO(FlowRuMsgMergeEnum.START_FORMULATE_SIN, FlowRuMsgMergeEnum.START_FORMULATE_MUL);
        }
        if (HRStringUtils.equals((String)taskType, (String)TaskTypeEnum.INTERVIEW_START.getValue())) {
            flowMsgMergeEnumBO = new FlowMsgMergeEnumBO(FlowRuMsgMergeEnum.START_INTERVIEW_SIN, FlowRuMsgMergeEnum.START_INTERVIEW_MUL);
        }
        SendMessageDTO SendMessageDTO2 = new SendMessageDTO(batchNo, flowMsgMergeEnumBO);
        FLOW_HANDLER_BATCH_DOMAIN_SERVICE.sendMessageMerge(Collections.singletonList(SendMessageDTO2));
    }

    private void reWriteStatus2Invoker(DynamicObject dy, ReWriteEvalObjRequest reWriteEvalObjRequest) {
        String taskType = dy.getString("tasktype");
        List<ReWriteEvalObjInfo> reWriteEvalObjInfoList = reWriteEvalObjRequest.getReWriteEvalObjInfoList();
        HashMap<Long, Long> updateFormulateInsMap = new HashMap<Long, Long>(16);
        HashMap<Long, Long> updateEvalInsMap = new HashMap<Long, Long>(16);
        HashMap<Long, Long> updateIntInsMap = new HashMap<Long, Long>(16);
        for (ReWriteEvalObjInfo reWriteEvalObjInfo : reWriteEvalObjInfoList) {
            if (taskType.equals(TaskTypeEnum.INDICATOR_PRE_INSTANTIATION.getValue()) || taskType.equals(TaskTypeEnum.INDICATOR_START.getValue())) {
                updateFormulateInsMap.put(reWriteEvalObjInfo.getEvalObjId(), reWriteEvalObjInfo.getRuProcId());
            }
            if (taskType.equals(TaskTypeEnum.EVAL_PRE_INSTANTIATION.getValue()) || taskType.equals(TaskTypeEnum.EVAL_START.getValue())) {
                updateEvalInsMap.put(reWriteEvalObjInfo.getEvalObjId(), reWriteEvalObjInfo.getRuProcId());
            }
            if (!taskType.equals(TaskTypeEnum.INT_PRE_INSTANTIATION.getValue()) && !taskType.equals(TaskTypeEnum.INTERVIEW_START.getValue())) continue;
            updateIntInsMap.put(reWriteEvalObjInfo.getEvalObjId(), reWriteEvalObjInfo.getRuProcId());
        }
        if (taskType.equals(TaskTypeEnum.INT_PRE_INSTANTIATION.getValue())) {
            LOG.info("\u3010OPMC\u3011-reWriteStatus2Invoker,begin updateIntObjFlowInstance,updateIntInsMap is {}", (Object)SerializationUtils.toJsonString(updateIntInsMap));
            EPA_ACTEVAOBJ_SERVICE.updateIntObjFlowInstance(updateIntInsMap);
        } else {
            LOG.info("\u3010OPMC\u3011-reWriteStatus2Invoker,begin updateActEvaObjFlowInstance,updateFormulateInsMap is {},updateEvalInsMap is {}", (Object)SerializationUtils.toJsonString(updateIntInsMap), (Object)SerializationUtils.toJsonString(updateEvalInsMap));
            EPA_ACTEVAOBJ_SERVICE.updateActEvaObjFlowInstance(updateFormulateInsMap, updateEvalInsMap);
        }
    }

    private void setTaskDyStatus(RequestContext requestContext, DynamicObject[] taskDyArry, TaskStatusEnum taskStatusEnum) {
        long userId = requestContext.getCurrUserId();
        Date date = new Date();
        for (DynamicObject dy : taskDyArry) {
            dy.set("taskstatus", (Object)taskStatusEnum.getValue());
            dy.set("modifier", (Object)userId);
            dy.set("modifytime", (Object)date);
            if (taskStatusEnum != TaskStatusEnum.PROCESSING) continue;
            dy.set("starttime", (Object)date);
        }
        BATCH_START_EVAL_ENTITY_SERVICE.save(taskDyArry);
    }

    public void dealBatchFlowTask(List<Long> batchStartIdList) {
        if (CollectionUtils.isEmpty(batchStartIdList)) {
            return;
        }
        LOG.info("\u3010OPMC\u3011-dealBatchFlowTask,batchStartIdList is {}", (Object)batchStartIdList.toString());
        RequestContext requestContext = RequestContext.get();
        QFilter cusFilter = new QFilter("taskstatus", "in", Arrays.asList(TaskStatusEnum.PUSHED.getValue(), TaskStatusEnum.UNPROCESS.getValue()));
        cusFilter.and(new QFilter("id", "in", batchStartIdList));
        DynamicObject[] taskDyArry = BATCH_START_EVAL_ENTITY_SERVICE.queryUnProcessFlowTaskByCusFilter(cusFilter);
        if (null == taskDyArry || taskDyArry.length <= 0) {
            LOG.info("batchFlowTaskScanExe : Haven't Task to execute.");
            return;
        }
        this.setTaskDyStatus(requestContext, taskDyArry, TaskStatusEnum.PROCESSING);
        List<DynamicObject> failedTaskList = this.processFlowTask(taskDyArry);
        this.setTaskDyStatus(requestContext, taskDyArry, TaskStatusEnum.PROCESSED);
        if (!CollectionUtils.isEmpty(failedTaskList)) {
            this.setTaskDyStatus(requestContext, failedTaskList.toArray(new DynamicObject[0]), TaskStatusEnum.UNPROCESS);
        }
    }
}

