/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.pbs.business.domain.msg.entityservice;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.pbs.business.ServiceFactory;
import kd.opmc.pbs.business.domain.OpmcEntityService;
import kd.opmc.pbs.common.enums.MsgLogStatusEnum;

public class MsgLogEntity
extends OpmcEntityService {
    private static final HRBaseServiceHelper HELPER = new HRBaseServiceHelper("pbs_msglog");

    public static MsgLogEntity getInstance() {
        return ServiceFactory.getService(MsgLogEntity.class);
    }

    @Override
    protected HRBaseServiceHelper getServiceHelper() {
        return HELPER;
    }

    public List<DynamicObject> generateDynamicObjectByMsg(Long msgId, DynamicObject msgTemplate, MessageInfo messageInfo, MsgLogStatusEnum msgLogStatusEnum, Map<String, String> urlParams) {
        ArrayList<DynamicObject> msgLogs = new ArrayList<DynamicObject>(10);
        List userIds = messageInfo.getUserIds();
        for (Long userId : userIds) {
            DynamicObject msgLogObj = MsgLogEntity.getInstance().generateEmptyDynamicObject();
            String number = CodeRuleServiceHelper.getNumber((String)"pbs_msglog", (DynamicObject)msgLogObj, null);
            msgLogObj.set("number", (Object)number);
            msgLogObj.set("user", (Object)userId);
            msgLogObj.set("msgchannels", (Object)msgTemplate.getString("msgchannel"));
            msgLogObj.set("status", (Object)msgLogStatusEnum.getValue());
            msgLogObj.set("pushtime", null);
            msgLogObj.set("msgtemplatenumber", msgTemplate.get("number"));
            msgLogObj.set("msgtemplatename", msgTemplate.get("name"));
            msgLogObj.set("fmsgtype", (Object)msgTemplate.getString("msgtype"));
            DynamicObjectCollection msgSceneValues = msgTemplate.getDynamicObjectCollection("msgscenevalue");
            StringBuilder msgSceneIdsSb = new StringBuilder();
            for (DynamicObject msgSceneValue : msgSceneValues) {
                long msgSceneId = msgSceneValue.getLong("fbasedataid_id");
                if (msgSceneId == 0L) continue;
                msgSceneIdsSb.append(msgSceneId);
                msgSceneIdsSb.append(",");
            }
            if (msgSceneIdsSb.length() > 0) {
                msgLogObj.set("msgtemplatesc", (Object)msgSceneIdsSb.substring(0, msgSceneIdsSb.length() - 1));
            }
            msgLogObj.set("msgentity", (Object)msgTemplate.getDynamicObject("msgentity"));
            msgLogObj.set("msgtemplate", (Object)msgTemplate);
            msgLogObj.set("msg", (Object)msgId);
            if (urlParams != null && !HRStringUtils.isBlank((CharSequence)urlParams.get("batchTaskId"))) {
                msgLogObj.set("taskid", (Object)Long.valueOf(urlParams.get("batchTaskId")));
            } else if (urlParams != null && !HRStringUtils.isBlank((CharSequence)urlParams.get("taskId"))) {
                msgLogObj.set("taskid", (Object)Long.valueOf(urlParams.get("taskId")));
            } else if (urlParams != null && !HRStringUtils.isBlank((CharSequence)urlParams.get("pkId"))) {
                msgLogObj.set("taskid", (Object)Long.valueOf(urlParams.get("pkId")));
            }
            msgLogObj.set("createtime", (Object)messageInfo.getSendTime());
            msgLogObj.set("creator", (Object)UserServiceHelper.getCurrentUserId());
            msgLogObj.set("modifytime", (Object)messageInfo.getSendTime());
            msgLogObj.set("modifier", (Object)UserServiceHelper.getCurrentUserId());
            msgLogs.add(msgLogObj);
        }
        return msgLogs;
    }
}

