/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.pbs.business.domain.msg.service;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.hr.hbp.common.util.DatePattern;
import kd.hr.hbp.common.util.DateUtils;
import kd.opmc.pbs.business.ServiceFactory;
import kd.opmc.pbs.business.domain.msg.entityservice.MsgLogEntity;
import kd.opmc.pbs.business.domain.msg.service.dto.MessageCenterCallBackDto;
import kd.opmc.pbs.common.enums.MsgLogStatusEnum;

public class MsgLogDomainService {
    private static final Log LOG = LogFactory.getLog(MsgLogDomainService.class);
    protected static final MsgLogEntity MSG_LOG_ENTITY = MsgLogEntity.getInstance();
    private static ThreadPool threadPool;
    private static final String OPMC_PBS_MSG_LOG_LIST_KEY = "opmcPbsMsgLogListKey";

    public static MsgLogDomainService getInstance() {
        return ServiceFactory.getService(MsgLogDomainService.class);
    }

    public void recordLogs(DynamicObject msgTemplate, MessageInfo messageInfo, Map<String, Object> result, Map<String, String> urlParams) {
        List<DynamicObject> msgLogs;
        if (result.get("success") != null && result.get("success").equals(Boolean.TRUE)) {
            LOG.info("send success");
            HashMap data = (HashMap)result.get("data");
            ArrayList successMsgIds = (ArrayList)data.get("successMsgIds");
            Long msgId = (Long)successMsgIds.get(0);
            msgLogs = MSG_LOG_ENTITY.generateDynamicObjectByMsg(msgId, msgTemplate, messageInfo, MsgLogStatusEnum.WAITING, urlParams);
        } else {
            LOG.info("send fail");
            msgLogs = MSG_LOG_ENTITY.generateDynamicObjectByMsg(null, msgTemplate, messageInfo, MsgLogStatusEnum.FAILED, urlParams);
        }
        MSG_LOG_ENTITY.save(msgLogs.toArray(new DynamicObject[0]));
    }

    public void updateMsgLogsByMsgIdDB(Long msgId, String msgLogStatusEnumValue) {
        QFilter msgIdFilter = new QFilter("msg", "=", (Object)msgId);
        DynamicObject[] msgLogs = MSG_LOG_ENTITY.query("id,msg,status,pushtime,modifytime", new QFilter[]{msgIdFilter});
        if (msgLogs.length > 0) {
            this.updateMsgLogs(msgLogs, msgLogStatusEnumValue);
        } else {
            threadPool.execute(() -> {
                boolean isSuccess = false;
                for (int i = 0; i < 4; ++i) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        LOG.error((Throwable)e);
                        Thread.currentThread().interrupt();
                    }
                    DynamicObject[] tMsgLogs = MSG_LOG_ENTITY.query("id,msg,status,pushtime,modifytime", new QFilter[]{msgIdFilter});
                    if (tMsgLogs.length <= 0) continue;
                    this.updateMsgLogs(tMsgLogs, msgLogStatusEnumValue);
                    isSuccess = true;
                    break;
                }
                if (!isSuccess) {
                    LOG.error("updateMsgLogsByMsgId error,msgId-->" + msgId);
                }
            });
        }
    }

    private void updateMsgLogs(DynamicObject[] msgLogs, String msgLogStatusEnum) {
        for (DynamicObject msgLog : msgLogs) {
            msgLog.set("status", (Object)msgLogStatusEnum);
            Date now = new Date();
            msgLog.set("pushtime", (Object)now);
            msgLog.set("modifytime", (Object)now);
        }
        MSG_LOG_ENTITY.save(msgLogs);
    }

    public void updateMsgLogsByMsgId(MessageCenterCallBackDto messageCenterCallBackDto, boolean isFourceHandle) {
        block27: {
            LOG.info("updateMsgLogsByMsgId:" + messageCenterCallBackDto);
            DistributeSessionlessCache commonRegionCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("commonRegion");
            try (DLock lock = DLock.create((String)OPMC_PBS_MSG_LOG_LIST_KEY);){
                lock.lock();
                String[] pbsMsgLogJsons = commonRegionCache.getList(OPMC_PBS_MSG_LOG_LIST_KEY);
                if (pbsMsgLogJsons != null && (pbsMsgLogJsons.length >= 200 || isFourceHandle)) {
                    HashMap<Long, MessageCenterCallBackDto> map = new HashMap<Long, MessageCenterCallBackDto>(pbsMsgLogJsons.length);
                    for (String string : pbsMsgLogJsons) {
                        MessageCenterCallBackDto dto = (MessageCenterCallBackDto)JSON.parseObject((String)string, MessageCenterCallBackDto.class);
                        map.put(dto.getMsgId(), dto);
                    }
                    if (messageCenterCallBackDto != null) {
                        map.put(messageCenterCallBackDto.getMsgId(), messageCenterCallBackDto);
                    }
                    QFilter msgIdFilter = new QFilter("msg", "in", new ArrayList(map.keySet()));
                    DynamicObject[] msgLogs = MSG_LOG_ENTITY.query("id,msg,status,pushtime,modifytime", new QFilter[]{msgIdFilter});
                    HashMap<Long, DynamicObject> handleMsgLogMap = new HashMap<Long, DynamicObject>(msgLogs.length);
                    for (DynamicObject msgLog : msgLogs) {
                        handleMsgLogMap.put(msgLog.getLong("msg"), msgLog);
                    }
                    ArrayList<DynamicObject> arrayList = new ArrayList<DynamicObject>(10);
                    ArrayList<String> notHandleList = new ArrayList<String>(10);
                    for (Map.Entry entry : map.entrySet()) {
                        Long msgId = (Long)entry.getKey();
                        MessageCenterCallBackDto backDto = (MessageCenterCallBackDto)entry.getValue();
                        if (handleMsgLogMap.containsKey(msgId)) {
                            DynamicObject msgLog = (DynamicObject)handleMsgLogMap.get(msgId);
                            msgLog.set("status", (Object)backDto.getMsgLogStatusEnumValue());
                            Date pushTime = DateUtils.stringToDate((String)backDto.getPushTimeStr(), (DatePattern)DatePattern.YYYY_MM_DD_HH_MM_MS);
                            msgLog.set("pushtime", (Object)pushTime);
                            msgLog.set("modifytime", (Object)pushTime);
                            arrayList.add(msgLog);
                            continue;
                        }
                        notHandleList.add(JSON.toJSONString((Object)backDto));
                    }
                    if (arrayList.size() > 0) {
                        MSG_LOG_ENTITY.save(arrayList.toArray(new DynamicObject[0]));
                    }
                    commonRegionCache.remove(OPMC_PBS_MSG_LOG_LIST_KEY);
                    if (notHandleList.size() > 0) {
                        commonRegionCache.addList(OPMC_PBS_MSG_LOG_LIST_KEY, notHandleList.toArray(new String[0]), 2592000);
                    }
                } else if (messageCenterCallBackDto != null) {
                    commonRegionCache.addList(OPMC_PBS_MSG_LOG_LIST_KEY, new String[]{JSON.toJSONString((Object)messageCenterCallBackDto)}, 2592000);
                }
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
                try {
                    if (messageCenterCallBackDto != null) {
                        commonRegionCache.addList(OPMC_PBS_MSG_LOG_LIST_KEY, new String[]{JSON.toJSONString((Object)messageCenterCallBackDto)}, 2592000);
                    }
                }
                catch (Exception ee) {
                    LOG.error((Throwable)ee);
                    if (messageCenterCallBackDto == null) break block27;
                    this.updateMsgLogsByMsgIdDB(messageCenterCallBackDto.getMsgId(), messageCenterCallBackDto.getMsgLogStatusEnumValue());
                }
            }
        }
    }

    static {
        try {
            threadPool = ThreadPools.newFixedThreadPool((String)"OPMC_PBS_MSGLOG_SERVICE_POOL", (int)3);
        }
        catch (Exception var1) {
            LOG.error("OPMC_PBS_MSGLOG_SERVICE_POOL create error", (Throwable)var1);
        }
    }
}

