/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.pbs.business.domain.msg.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.extplugin.PluginFilter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.pbs.business.ServiceFactory;
import kd.opmc.pbs.business.domain.msg.entityservice.MsgTemplateEntity;
import kd.opmc.pbs.business.domain.msg.extpoint.IMsgSendService;
import kd.opmc.pbs.business.domain.msg.service.MsgLogDomainService;
import kd.opmc.pbs.common.utils.OpmcLogUtils;

public class MsgSendDomainService {
    private static final Log LOG = LogFactory.getLog(MsgSendDomainService.class);
    protected static final MsgTemplateEntity MSG_TEMPLATE_ENTITY = MsgTemplateEntity.getInstance();
    protected static final MsgLogDomainService MSG_LOG_DOMAIN_SERVICE = MsgLogDomainService.getInstance();
    protected static final IMsgSendService MSG_SEND_SERVICE = IMsgSendService.getInstance();

    public static MsgSendDomainService getInstance() {
        return ServiceFactory.getService(MsgSendDomainService.class);
    }

    public void sendMessageWithUrl(Long templateID, List<Long> userIds, DynamicObject businessObject, Map<String, String> urlParams) {
        this.sendMessageWithUrl(templateID, userIds, businessObject, urlParams, ResManager.loadKDString((String)"\u901a\u77e5", (String)"MsgSendDomainService_0", (String)"opmc-pbs-business", (Object[])new Object[0]));
    }

    public void sendMessageWithUrl(Long templateId, List<Long> userIds, DynamicObject businessObject, Map<String, String> urlParams, String tag) {
        DynamicObject msgTemplate = MSG_TEMPLATE_ENTITY.queryMsgTemplateById(templateId);
        Tuple<String, String> messageContextTuple = this.getMessageContextTuple(businessObject, msgTemplate);
        this.batchSendMessages(userIds, businessObject, urlParams, tag, msgTemplate, messageContextTuple);
    }

    protected void batchSendMessages(List<Long> userIds, DynamicObject businessObject, Map<String, String> urlParams, String tag, DynamicObject msgTemplate, Tuple<String, String> messageContextTuple) {
        HRPluginProxy pluginProxy = HRPlugInProxyFactory.create((Object)MSG_SEND_SERVICE, IMsgSendService.class, (String)"kd.opmc.pbs.business.domain.msg.extpoint.IMsgSendService#batchSendMessages", (PluginFilter)null);
        List result = pluginProxy.callReplaceIfPresent(p -> p.batchSendMessages(userIds, businessObject, urlParams, tag, msgTemplate, messageContextTuple));
        if (!ObjectUtils.isEmpty((Object)result) && !((Boolean)result.get(0)).booleanValue()) {
            return;
        }
        MessageInfo message = new MessageInfo();
        message.setType(msgTemplate.getString("msgtype"));
        message.setNotifyType(msgTemplate.getString("msgchannel"));
        message.setTitle((String)messageContextTuple.item1);
        message.setContent((String)messageContextTuple.item2);
        message.setUserIds(userIds);
        message.setSendTime(new Date());
        message.setTag(tag);
        message.setEntityNumber(msgTemplate.getString("msgentity.number"));
        String contentUrl = UrlService.getAccountCookieUrl((String)this.buildURL(urlParams), (String)RequestContext.get().getTenantId(), (String)RequestContext.get().getAccountId());
        message.setContentUrl(contentUrl);
        message.setSenderId(Long.valueOf(UserServiceHelper.getCurrentUserId()));
        message.setMessageSenderName((ILocaleString)this.wrapLocalStringProperty(UserServiceHelper.getCurrentUser((String)"name").getLocaleString("name")));
        message.setBizDataId(Long.valueOf(businessObject.getLong("id")));
        try {
            String batchTaskId = urlParams.get("batchTaskId");
            if (!HRStringUtils.isEmpty((String)batchTaskId)) {
                message.setNestBillId(Long.valueOf(Long.parseLong(batchTaskId)));
            } else {
                message.setNestBillId(Long.valueOf(System.currentTimeMillis()));
            }
        }
        catch (Exception ex) {
            OpmcLogUtils.error((String)"MsgSendDomainService.batchSendMessages", (Throwable)ex);
        }
        message.setNestBillno(businessObject.getString("id"));
        message.setSource("NoCodeFlow");
        ArrayList<MessageInfo> messageList = new ArrayList<MessageInfo>(10);
        LOG.info(message.toString());
        messageList.add(message);
        Map msgResult = MessageCenterServiceHelper.batchSendMessages(messageList);
        LOG.info("\u3010OPMC\u3011-invoke batchSendMessages result is {},traceId={}", (Object)SerializationUtils.toJsonString((Object)msgResult), (Object)RequestContext.get().getTraceId());
    }

    private LocaleString wrapLocalStringProperty(Object property) {
        LocaleString ls = new LocaleString();
        if (property != null) {
            Map tmap = (Map)property;
            for (Map.Entry entry : tmap.entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                ls.setItem(key, (Object)((String)value));
            }
        }
        return ls;
    }

    protected String buildURL(Map<String, String> params) {
        if (ObjectUtils.isEmpty(params)) {
            return null;
        }
        String contentUrl = UrlService.getDomainContextUrl();
        String paramString = params.entrySet().stream().map(entry -> String.format(Locale.ROOT, "%s=%s", entry.getKey(), entry.getValue())).collect(Collectors.joining("&"));
        return String.format(Locale.ROOT, "%s/?%s", contentUrl, paramString);
    }

    protected Tuple<String, String> getMessageContextTuple(DynamicObject businessDynamicObject, DynamicObject msgTemplateDyc) {
        if (Objects.isNull(msgTemplateDyc)) {
            return Tuple.create((Object)"", (Object)"");
        }
        String msgTemplate = msgTemplateDyc.getLocaleString("msgtemplate").getLocaleValue();
        if (HRStringUtils.isEmpty((String)msgTemplate)) {
            msgTemplate = msgTemplateDyc.getLocaleString("msgtemplate").getLocaleValue_zh_CN();
        }
        String title = this.setParams(msgTemplate, businessDynamicObject, "title");
        String content = this.setParams(msgTemplate, businessDynamicObject, "content");
        return Tuple.create((Object)title, (Object)content);
    }

    protected String setParams(String msgTemplate, DynamicObject businessDynamicObject, String content) {
        ArrayList<String> params = new ArrayList<String>();
        JSONObject templateObject = JSON.parseObject((String)msgTemplate);
        String str = this.parseMsgTemplate(templateObject.getString(content), params);
        ArrayList<String> result = new ArrayList<String>();
        for (String param : params) {
            String[] split = param.split("\\.");
            DynamicObject object = this.getDynamicObject(split, businessDynamicObject, 1);
            String strId = split[split.length - 1];
            if (Objects.isNull(object)) {
                result.add(strId);
                continue;
            }
            String string = object.get(strId) != null && Timestamp.class.equals(object.get(strId).getClass()) ? HRDateTimeUtils.format((Date)object.getDate(strId), (String)"yyyy-MM-dd") : object.getString(strId);
            result.add(string);
        }
        return MessageFormat.format(str, result.toArray());
    }

    protected DynamicObject getDynamicObject(String[] split, DynamicObject dynamicObject, int index) {
        if (index < split.length - 1) {
            DynamicObject dynamicObject1 = dynamicObject.getDynamicObject(split[index]);
            return this.getDynamicObject(split, dynamicObject1, index + 1);
        }
        return dynamicObject;
    }

    protected String parseMsgTemplate(String msgTemplate, List<String> params) {
        if (HRStringUtils.isEmpty((String)msgTemplate)) {
            return "";
        }
        String result = msgTemplate;
        String[] split = msgTemplate.split("\\{");
        if (split.length <= 1) {
            return result;
        }
        for (int i = 1; i < split.length; ++i) {
            String param = split[i];
            params.add(param.substring(0, param.indexOf(125)));
            result = result.replace('{' + param.substring(0, param.indexOf(125)) + "}", "{" + (i - 1) + "}");
        }
        return result;
    }
}

