/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.pbs.business.domain.msg.service;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.pbs.business.ServiceFactory;
import kd.opmc.pbs.business.domain.msg.service.MsgSendDomainService;

public class RollbackMsgSendService
extends MsgSendDomainService {
    public static RollbackMsgSendService getInstance() {
        return ServiceFactory.getService(RollbackMsgSendService.class);
    }

    @Override
    public void sendMessageWithUrl(Long templateId, List<Long> userIds, DynamicObject businessObject, Map<String, String> urlParams, String tag) {
        DynamicObject msgTemplate = MSG_TEMPLATE_ENTITY.queryMsgTemplateById(templateId);
        String actevalobj = urlParams.remove("actevalobj");
        String billno = urlParams.remove("billno");
        String reason = urlParams.remove("reason");
        String modifyer = urlParams.remove("modifyer");
        Tuple<String, String> messageContextTuple = this.getMessageContextTuple(businessObject, msgTemplate, actevalobj, billno, reason, modifyer);
        this.batchSendMessages(userIds, businessObject, urlParams, tag, msgTemplate, messageContextTuple);
    }

    private Tuple<String, String> getMessageContextTuple(DynamicObject businessDynamicObject, DynamicObject msgTemplateDyc, String actevalobj, String billno, String reason, String modifyer) {
        if (Objects.isNull(msgTemplateDyc)) {
            return Tuple.create((Object)"", (Object)"");
        }
        String msgTemplate = msgTemplateDyc.getLocaleString("msgtemplate").getLocaleValue();
        if (HRStringUtils.isEmpty((String)msgTemplate)) {
            msgTemplate = msgTemplateDyc.getLocaleString("msgtemplate").getLocaleValue_zh_CN();
        }
        String titleTuple = this.setParams(msgTemplate, businessDynamicObject, "title");
        String title = titleTuple.replace("%%%", HRStringUtils.isEmpty((String)actevalobj) ? "" : actevalobj);
        title = title.replace("###", HRStringUtils.isEmpty((String)billno) ? "" : billno);
        String item = this.setParams(msgTemplate, businessDynamicObject, "content");
        String content = item.replace("%%%", HRStringUtils.isEmpty((String)actevalobj) ? "" : actevalobj);
        content = content.replace("###", HRStringUtils.isEmpty((String)billno) ? "" : billno);
        content = content.replace("&&&", HRStringUtils.isEmpty((String)reason) ? "" : reason);
        content = content.replace("@@@", HRStringUtils.isEmpty((String)modifyer) ? "" : modifyer);
        return Tuple.create((Object)title, (Object)content);
    }
}

