/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.pbs.business.domain.perfcecycle.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.pbs.business.ServiceFactory;
import kd.opmc.pbs.business.domain.perfcecycle.entityservice.PerfCecycleEntityService;
import kd.opmc.pbs.business.domain.perfcecycle.enums.CeCycleLenEnum;
import kd.opmc.pbs.common.utils.ListUtils;

public class PerfCecycleSerivce {
    private static final PerfCecycleEntityService PERF_CECYCLE_ENTITY_SERVICE = PerfCecycleEntityService.getInstance();
    private static final int MAX_INIT = 10;
    private static Set<Integer> ONE_QUARTER = new HashSet<Integer>(){
        private static final long serialVersionUID = -7211683791943153031L;
        {
            this.add(10);
            this.add(11);
            this.add(12);
        }
    };
    private static Set<Integer> TWO_QUARTER = new HashSet<Integer>(){
        private static final long serialVersionUID = 9148073136421783720L;
        {
            this.add(1);
            this.add(2);
            this.add(3);
        }
    };
    private static HashSet<Integer> THREE_QUARTER = new HashSet<Integer>(){
        private static final long serialVersionUID = 5685248183864131165L;
        {
            this.add(4);
            this.add(5);
            this.add(6);
        }
    };
    private static Set<Integer> FOUR_QUARTER = new HashSet<Integer>(){
        private static final long serialVersionUID = -273715239416376819L;
        {
            this.add(7);
            this.add(8);
            this.add(9);
        }
    };
    private static Map<Integer, Set<Integer>> QUARTER_MAP = new HashMap<Integer, Set<Integer>>(){
        private static final long serialVersionUID = 8239077800502155483L;
        {
            this.put(0, ONE_QUARTER);
            this.put(3, TWO_QUARTER);
            this.put(6, THREE_QUARTER);
            this.put(9, FOUR_QUARTER);
        }
    };
    private static Set<Integer> FIRST_HALF_YEAR = new HashSet<Integer>(){
        private static final long serialVersionUID = -1580171215765391550L;
        {
            this.add(7);
            this.add(8);
            this.add(9);
            this.add(10);
            this.add(11);
            this.add(12);
        }
    };
    private static Set<Integer> SECOND_HALF = new HashSet<Integer>(){
        private static final long serialVersionUID = 151364864011540707L;
        {
            this.add(1);
            this.add(2);
            this.add(3);
            this.add(4);
            this.add(5);
            this.add(6);
        }
    };
    private static Map<Integer, Set<Integer>> HALF_MAP = new HashMap<Integer, Set<Integer>>(){
        private static final long serialVersionUID = 7602029730831649877L;
        {
            this.put(0, FIRST_HALF_YEAR);
            this.put(6, SECOND_HALF);
        }
    };

    public static PerfCecycleSerivce getInstance() {
        return ServiceFactory.getService(PerfCecycleSerivce.class);
    }

    public DynamicObject[] getRunTimeCycleIns(List<Long> ids) {
        return PERF_CECYCLE_ENTITY_SERVICE.getRunTimeCycleIns(ids);
    }

    public DynamicObject[] getCycleIns(Long id) {
        return PERF_CECYCLE_ENTITY_SERVICE.getCycleIns(id);
    }

    public DynamicObject getRunTimeCycleIns(Long id) {
        return PERF_CECYCLE_ENTITY_SERVICE.getRunTimeCycleIns(id);
    }

    public void updateRunTimeCeCycleIns() {
        DynamicObject[] dynamicObjects = PERF_CECYCLE_ENTITY_SERVICE.getWaitTimeCycleInsIds();
        if (!HRObjectUtils.isEmpty((Object)dynamicObjects)) {
            List cecycleInsIds = Arrays.stream(dynamicObjects).map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
            ListUtils.excute(cecycleInsIds, (int)10, this::batchUpdateCeCycle);
        }
    }

    private void batchUpdateCeCycle(List<Long> ids) {
        Date currentDate = new Date();
        for (Long id : ids) {
            DynamicObject cycleIns = PERF_CECYCLE_ENTITY_SERVICE.getCycleInsById(id);
            DynamicObject[] cycleInsList = PERF_CECYCLE_ENTITY_SERVICE.getCycleIns(cycleIns.getLong("cecycle.id"));
            ArrayList<DynamicObject> hisIns = new ArrayList<DynamicObject>(10);
            for (DynamicObject dynamicObject : cycleInsList) {
                Date firstStartTime = dynamicObject.getDate("insstarttime");
                Date firstEndTime = dynamicObject.getDate("insendtime");
                if (HRDateTimeUtils.dayBefore((Date)firstStartTime, (Date)currentDate) && HRDateTimeUtils.dayBefore((Date)currentDate, (Date)firstEndTime)) {
                    dynamicObject.set("insstatus", (Object)"2");
                } else if (HRDateTimeUtils.dayBefore((Date)currentDate, (Date)firstStartTime)) {
                    dynamicObject.set("insstatus", (Object)"1");
                } else if (HRDateTimeUtils.dayBefore((Date)firstEndTime, (Date)currentDate)) {
                    dynamicObject.set("insstatus", (Object)"3");
                }
                hisIns.add(dynamicObject);
            }
            PERF_CECYCLE_ENTITY_SERVICE.batchSave(hisIns.toArray(new DynamicObject[0]));
            if (!HRObjectUtils.isEmpty((Object)cycleIns.getDynamicObject("cecycle")) && (HRStringUtils.equals((String)cycleIns.getDynamicObject("cecycle").getString("enable"), (String)"0") || HRObjectUtils.isEmpty((Object)cycleIns.getDynamicObject("cecycle").getDate("fstarttime")))) continue;
            this.makeCecycleIns(cycleIns.getDynamicObject("cecycle"), 1, hisIns.stream().map(ins -> ins.getString("name")).collect(Collectors.toList()));
        }
    }

    public void makeCecycleIns(DynamicObject dynamicObject, int offset, List<String> hisInsName) {
        List<DynamicObject> insList = this.getCycleIns(dynamicObject, offset, hisInsName);
        if (ObjectUtils.isEmpty(insList)) {
            return;
        }
        PERF_CECYCLE_ENTITY_SERVICE.batchSave(insList.toArray(new DynamicObject[0]));
    }

    public void makeCecycleWaitRunIns(DynamicObject dynamicObject, int offset, List<String> hisInsName) {
        List<DynamicObject> insList = this.getCycleIns(dynamicObject, offset, hisInsName);
        if (ObjectUtils.isEmpty(insList)) {
            return;
        }
        List<DynamicObject> waitRunInsList = insList.stream().filter(ins -> HRStringUtils.equals((String)ins.getString("insstatus"), (String)"1")).collect(Collectors.toList());
        DynamicObject waitRunIns = PERF_CECYCLE_ENTITY_SERVICE.getWaitRunTimeCycleIns(dynamicObject.getLong("id"));
        if (ObjectUtils.isEmpty(waitRunInsList)) {
            return;
        }
        if (HRObjectUtils.isEmpty((Object)waitRunIns)) {
            PERF_CECYCLE_ENTITY_SERVICE.batchSave(waitRunInsList.toArray(new DynamicObject[0]));
        } else {
            DynamicObject dyc = (DynamicObject)waitRunInsList.get(0);
            waitRunIns.set("insstarttime", dyc.get("insstarttime"));
            waitRunIns.set("nextstarttime", dyc.get("nextstarttime"));
            waitRunIns.set("insendtime", dyc.get("insendtime"));
            waitRunIns.set("nextavltime", dyc.get("nextavltime"));
            waitRunIns.set("insstatus", dyc.get("insstatus"));
            waitRunIns.set("name", dyc.get("name"));
            PERF_CECYCLE_ENTITY_SERVICE.saveOne(waitRunIns);
        }
    }

    private List<DynamicObject> getCycleIns(DynamicObject dynamicObject, int offset, List<String> hisInsName) {
        if (HRObjectUtils.isEmpty((Object)dynamicObject) || ObjectUtils.isEmpty((Object)dynamicObject.getDate("fstarttime"))) {
            return null;
        }
        ArrayList<DynamicObject> insList = new ArrayList<DynamicObject>(10);
        GregorianCalendar calendar = new GregorianCalendar();
        Date firstStartTime = HRDateTimeUtils.truncateDate((Date)dynamicObject.getDate("fstarttime"));
        int nextVal = dynamicObject.getInt("nextavl");
        String cycleLen = dynamicObject.getString("cyclelen");
        String customLen = dynamicObject.getString("customlen");
        String customLenType = dynamicObject.getString("customlentype");
        Date currentDate = new Date();
        Date startAddTime = firstStartTime;
        String insStatus = "3";
        do {
            DynamicObject insDyc = PERF_CECYCLE_ENTITY_SERVICE.generateEmpty();
            insDyc.set("insstarttime", (Object)firstStartTime);
            insDyc.set("cecycle", (Object)dynamicObject);
            Date nextStart = this.getNextStartDate(startAddTime, cycleLen, customLen, customLenType, offset);
            insDyc.set("nextstarttime", (Object)nextStart);
            Date firstEndTime = this.getEndDate(nextStart);
            insDyc.set("insendtime", (Object)firstEndTime);
            calendar.setTime(nextStart);
            ((Calendar)calendar).add(5, nextVal * -1);
            insDyc.set("nextavltime", (Object)calendar.getTime());
            if (HRDateTimeUtils.dayBefore((Date)firstStartTime, (Date)currentDate) && HRDateTimeUtils.dayBefore((Date)currentDate, (Date)firstEndTime)) {
                insStatus = "2";
            } else if (HRDateTimeUtils.dayBefore((Date)currentDate, (Date)firstStartTime)) {
                insStatus = "1";
            } else if (HRDateTimeUtils.dayBefore((Date)firstEndTime, (Date)currentDate)) {
                insStatus = "3";
            }
            insDyc.set("insstatus", (Object)insStatus);
            insDyc.set("name", (Object)this.getInsName(cycleLen, firstStartTime, firstEndTime));
            this.setStatus(insDyc);
            ++offset;
            firstStartTime = nextStart;
            if (!HRObjectUtils.isEmpty(hisInsName) && hisInsName.contains(insDyc.getString("name"))) continue;
            insList.add(insDyc);
        } while (!HRStringUtils.equals((String)insStatus, (String)"1"));
        return insList;
    }

    private void setStatus(DynamicObject insDyc) {
        insDyc.set("status", (Object)"C");
        insDyc.set("enable", (Object)"1");
    }

    public void deleteRunTimeCycleIns(Long id) {
        PERF_CECYCLE_ENTITY_SERVICE.deleteRunTimeCycleIns(id);
    }

    public void deleteRunTimeCycleIns(List<Long> ids) {
        PERF_CECYCLE_ENTITY_SERVICE.deleteRunTimeCycleIns(ids);
    }

    private String getInsName(String cyclelen, Date startDate, Date endDate) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(startDate);
        int startYear = calendar.get(1);
        int startMonth = calendar.get(2) + 1;
        int startDay = calendar.get(5);
        calendar.setTime(endDate);
        int endYear = calendar.get(1);
        int endMonth = calendar.get(2) + 1;
        int endDay = calendar.get(5);
        String insName = "";
        switch (Objects.requireNonNull(CeCycleLenEnum.getByValue(cyclelen))) {
            case ONE_MONTH: {
                insName = ResManager.loadKDString((String)"{0}\u5e74{1}\u6708", (String)"PerfCecycleSerivce_0", (String)"opmc-pbs-business", (Object[])new Object[]{String.valueOf(startYear), startMonth});
                break;
            }
            case TWO_MONTH: 
            case THREE_MONTH: 
            case SIX_MONTH: {
                insName = HRObjectUtils.equals((Object)startYear, (Object)endYear) ? ResManager.loadKDString((String)"{0}\u5e74{1}\u6708\uff5e{2}\u6708", (String)"PerfCecycleSerivce_1", (String)"opmc-pbs-business", (Object[])new Object[]{String.valueOf(startYear), startMonth, endMonth}) : ResManager.loadKDString((String)"{0}\u5e74{1}\u6708\uff5e{2}\u5e74{3}\u6708", (String)"PerfCecycleSerivce_2", (String)"opmc-pbs-business", (Object[])new Object[]{String.valueOf(startYear), startMonth, String.valueOf(endYear), endMonth});
                break;
            }
            case TWELVE_MONTH: {
                insName = ResManager.loadKDString((String)"{0}\u5e74", (String)"PerfCecycleSerivce_3", (String)"opmc-pbs-business", (Object[])new Object[]{String.valueOf(startYear)});
                break;
            }
            case CUS_MONTH: {
                insName = ResManager.loadKDString((String)"{0}-{1}-{2}\uff5e{3}-{4}-{5}", (String)"PerfCecycleSerivce_4", (String)"opmc-pbs-business", (Object[])new Object[]{String.valueOf(startYear), startMonth, startDay, String.valueOf(endYear), endMonth, endDay});
                break;
            }
        }
        return insName;
    }

    public Date getDefaultFirstStartDate(String cyclelen) {
        Date defaultFirstDate = new Date();
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(defaultFirstDate);
        int month = calendar.get(2) + 1;
        CeCycleLenEnum cycleLenEnum = CeCycleLenEnum.getByValue(cyclelen);
        switch (Objects.requireNonNull(cycleLenEnum)) {
            case ONE_MONTH: 
            case CUS_MONTH: {
                this.calculationOneMonthFirstDate(calendar);
                break;
            }
            case TWO_MONTH: {
                this.calculationTwoMonthFirstDate(calendar, month);
                break;
            }
            case THREE_MONTH: {
                this.calculationThreeMonthFirstDate(defaultFirstDate, calendar, month);
                break;
            }
            case SIX_MONTH: {
                this.calculationSixMonthFirstDate(defaultFirstDate, calendar, month);
                break;
            }
            case TWELVE_MONTH: {
                this.calculationTwelveMonthFirstDate(defaultFirstDate, calendar);
                break;
            }
        }
        defaultFirstDate = calendar.getTime();
        return defaultFirstDate;
    }

    private void calculationTwoMonthFirstDate(Calendar calendar, int month) {
        if (month % 2 == 0) {
            calendar.add(2, 1);
        } else {
            calendar.add(2, 2);
        }
        calendar.set(5, 1);
    }

    private void calculationThreeMonthFirstDate(Date defaultFirstDate, Calendar calendar, int month) {
        QUARTER_MAP.forEach((key, value) -> {
            if (value.contains(month + 1)) {
                calendar.set(2, (int)key);
            }
        });
        calendar.set(5, 1);
        if (HRDateTimeUtils.dayBefore((Date)calendar.getTime(), (Date)defaultFirstDate)) {
            calendar.add(1, 1);
        }
    }

    private void calculationSixMonthFirstDate(Date defaultFirstDate, Calendar calendar, int month) {
        HALF_MAP.forEach((key, value) -> {
            if (value.contains(month + 1)) {
                calendar.set(2, (int)key);
            }
        });
        calendar.set(5, 1);
        if (HRDateTimeUtils.dayBefore((Date)calendar.getTime(), (Date)defaultFirstDate)) {
            calendar.add(1, 1);
        }
    }

    private void calculationTwelveMonthFirstDate(Date defaultFirstDate, Calendar calendar) {
        calendar.set(2, 0);
        calendar.set(5, 1);
        if (HRDateTimeUtils.dayBefore((Date)calendar.getTime(), (Date)defaultFirstDate)) {
            calendar.add(1, 1);
        }
    }

    private void calculationOneMonthFirstDate(Calendar calendar) {
        calendar.add(2, 1);
        calendar.set(5, 1);
    }

    public boolean isNotRangeNextVal(String nextVal, String cyclelen, String customlen, String customLenType) {
        boolean rangeFlag;
        int monthMax = 30;
        CeCycleLenEnum cycleLenEnum = CeCycleLenEnum.getByValue(cyclelen);
        if (HRObjectUtils.equals((Object)((Object)cycleLenEnum), (Object)((Object)CeCycleLenEnum.CUS_MONTH))) {
            rangeFlag = this.cusMonthCheck(nextVal, customlen, customLenType, monthMax);
        } else {
            assert (cycleLenEnum != null);
            rangeFlag = this.monthCheckFlag(nextVal, monthMax, cycleLenEnum);
        }
        return rangeFlag;
    }

    private boolean monthCheckFlag(String nextVal, int monthMax, CeCycleLenEnum cycleLenEnum) {
        if (HRObjectUtils.equals((Object)((Object)cycleLenEnum), (Object)((Object)CeCycleLenEnum.TWELVE_MONTH))) {
            return Integer.parseInt(nextVal) > 365;
        }
        return Integer.parseInt(nextVal) > monthMax * cycleLenEnum.getIntValue();
    }

    private boolean cusMonthCheck(String nextVal, String customlen, String customlentype, int monthMax) {
        if (HRStringUtils.isNotEmpty((String)customlen) && HRStringUtils.isNotEmpty((String)customlentype)) {
            if (HRStringUtils.equals((String)customlentype, (String)"1")) {
                return Integer.parseInt(nextVal) > Integer.parseInt(customlen);
            }
            return Integer.parseInt(nextVal) > monthMax * Integer.parseInt(customlen);
        }
        return false;
    }

    private Date getNextStartDate(Date startDate, String cyclelen, String customlen, String customlentype, int offset) {
        Date defaultFirstDate = this.getDate(startDate, cyclelen, customlen, customlentype, offset);
        return defaultFirstDate;
    }

    private Date getDate(Date startDate, String cyclelen, String customlen, String customlentype, int offset) {
        Date defaultFirstDate;
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(startDate);
        CeCycleLenEnum ceCycleLenEnum = CeCycleLenEnum.getByValue(cyclelen);
        if (HRObjectUtils.equals((Object)((Object)ceCycleLenEnum), (Object)((Object)CeCycleLenEnum.CUS_MONTH))) {
            if (HRStringUtils.isNotEmpty((String)customlen) && HRStringUtils.isNotEmpty((String)customlentype)) {
                if (HRStringUtils.equals((String)customlentype, (String)"1")) {
                    ((Calendar)calendar).add(5, Integer.parseInt(customlen) * offset);
                } else {
                    ((Calendar)calendar).add(2, Integer.parseInt(customlen) * offset);
                }
                defaultFirstDate = calendar.getTime();
            } else {
                defaultFirstDate = null;
            }
        } else {
            assert (ceCycleLenEnum != null);
            ((Calendar)calendar).add(2, ceCycleLenEnum.getIntValue() * offset);
            defaultFirstDate = calendar.getTime();
        }
        return defaultFirstDate;
    }

    private Date getEndDate(Date nextStartDate) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(nextStartDate);
        ((Calendar)calendar).add(12, -1);
        return calendar.getTime();
    }

    public Date calculationEndDate(Date startDate, String cycleLen, String customLen, String customLenType) {
        Date defaultFirstDate = this.getDate(startDate, cycleLen, customLen, customLenType, 1);
        if (!HRObjectUtils.isEmpty((Object)defaultFirstDate)) {
            defaultFirstDate = this.getEndDate(HRDateTimeUtils.truncateDate((Date)defaultFirstDate));
        }
        return defaultFirstDate;
    }

    public DynamicObject getDefaultCycleIns() {
        return PERF_CECYCLE_ENTITY_SERVICE.getDefaultCycleIns();
    }

    public BasedataEntityType getBaseDataEntityType() {
        DynamicObject ins = BusinessDataServiceHelper.newDynamicObject((String)"pbs_perfcycleins");
        BasedataEntityType basedataEntityType = (BasedataEntityType)ins.getDataEntityType();
        return basedataEntityType;
    }
}

