/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.pbs.business.domain.pot.entityservice;

import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.opmc.pbs.business.ServiceFactory;
import kd.opmc.pbs.business.domain.OpmcEntityService;

public class PotMemberEntityService
extends OpmcEntityService {
    private static final HRBaseServiceHelper HELPER = new HRBaseServiceHelper("pbs_potmember");

    public static PotMemberEntityService getInstance() {
        return ServiceFactory.getService(PotMemberEntityService.class);
    }

    @Override
    protected HRBaseServiceHelper getServiceHelper() {
        return HELPER;
    }

    public DynamicObject generateEmpty() {
        return HELPER.generateEmptyDynamicObject();
    }

    public DynamicObject getPotMember(Long dutyPersonId) {
        return HELPER.queryOne("person, pot", new QFilter[]{new QFilter("id", "in", (Object)dutyPersonId)});
    }

    public DynamicObject getPotMemberByUser(Long userId) {
        return HELPER.queryOne("id, person, pot", new QFilter[]{new QFilter("user", "in", (Object)userId)}, "id asc");
    }

    public DynamicObject[] getPotMemberByCurrentUser() {
        QFilter userFilter = new QFilter("user", "=", (Object)RequestContext.get().getCurrUserId());
        QFilter editFilter = new QFilter("isedit", "=", (Object)Boolean.FALSE);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        return HELPER.query("id, pot, teamrole, parent, person", new QFilter[]{userFilter, editFilter, enableFilter}, "id asc");
    }

    public boolean isPotMemberOfCurrentUser() {
        long userId = RequestContext.get().getCurrUserId();
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        return HELPER.isExists(new QFilter[]{new QFilter("user", "=", (Object)userId), enableFilter});
    }

    public DynamicObject[] getTeamMembers(Set<Long> potIds) {
        QFilter potFilter = new QFilter("pot", "in", potIds);
        QFilter editFilter = new QFilter("isedit", "=", (Object)Boolean.FALSE);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        return HELPER.query(new QFilter[]{potFilter, editFilter, enableFilter});
    }
}

