/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.pbs.business.domain.pot.service;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.orm.query.QFilter;
import kd.opmc.pbs.business.ServiceFactory;
import kd.opmc.pbs.business.domain.pot.entityservice.PotLabelEntityService;

public class PotLabelDomainService {
    private static final PotLabelEntityService LABEL_ENTITY_SERVICE = PotLabelEntityService.getInstance();
    public static final String SELECT_PROPERTIES = "pot, isedit, name, description, index";

    public static PotLabelDomainService getInstance() {
        return ServiceFactory.getService(PotLabelDomainService.class);
    }

    public DynamicObject[] queryLabels(long potId) {
        return LABEL_ENTITY_SERVICE.query(SELECT_PROPERTIES, new QFilter[]{new QFilter("pot", "=", (Object)potId)}, "index");
    }

    public void deleteLabelById(List<Long> deleteIds) {
        LABEL_ENTITY_SERVICE.delete(deleteIds.toArray(new Long[0]));
    }

    public void saveLabels(DynamicObjectCollection labelDatas, Long potId) {
        DynamicObject[] labels;
        Map labelDataMap = labelDatas.stream().collect(Collectors.toMap(labelData -> labelData.getDynamicObject("label").getLong("id"), Function.identity()));
        Set<Long> labelIds = labelDataMap.keySet();
        for (DynamicObject label : labels = LABEL_ENTITY_SERVICE.query(SELECT_PROPERTIES, new QFilter[]{new QFilter("id", "in", labelIds)})) {
            long memberId = label.getLong("id");
            DynamicObject labelData2 = (DynamicObject)labelDataMap.get(memberId);
            label.set("pot", (Object)potId);
            label.set("isedit", (Object)Boolean.FALSE);
            label.set("name", labelData2.get("name"));
            label.set("description", labelData2.get("description"));
            label.set("index", labelData2.get("index"));
        }
        LABEL_ENTITY_SERVICE.save(labels);
        QFilter deleteFilter = new QFilter("id", "not in", labelIds).and("pot", "=", (Object)potId);
        LABEL_ENTITY_SERVICE.deleteByFilter(new QFilter[]{deleteFilter});
    }

    public boolean disable(List<DynamicObject> selectDys) {
        DynamicObject[] labelDys;
        for (DynamicObject labelDy : labelDys = this.getLabelsForEntry(selectDys)) {
            labelDy.set("enable", (Object)"0");
        }
        LABEL_ENTITY_SERVICE.save(labelDys);
        return labelDys.length > 0;
    }

    private DynamicObject[] getLabelsForEntry(List<DynamicObject> selectDys) {
        List labelIds = selectDys.stream().filter(select -> !ObjectUtils.isEmpty((Object)select.getDynamicObject("label"))).map(dy -> dy.getDynamicObject("label").getLong("id")).collect(Collectors.toList());
        QFilter idFilter = new QFilter("id", "in", labelIds);
        return LABEL_ENTITY_SERVICE.query("enable", new QFilter[]{idFilter});
    }

    public boolean enable(List<DynamicObject> selectedEntry) {
        DynamicObject[] labelDys;
        for (DynamicObject labelDy : labelDys = this.getLabelsForEntry(selectedEntry)) {
            labelDy.set("enable", (Object)"1");
        }
        LABEL_ENTITY_SERVICE.save(labelDys);
        return labelDys.length > 0;
    }

    public void deleteEditLabelById(List<Long> labelIds) {
        QFilter deleteFilter = new QFilter("id", "in", labelIds).and("isedit", "=", (Object)Boolean.TRUE);
        LABEL_ENTITY_SERVICE.deleteByFilter(new QFilter[]{deleteFilter});
    }
}

