/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.pbs.business.domain.pot.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.opmc.pbs.business.ServiceFactory;
import kd.opmc.pbs.business.application.service.pot.ProjectOrgTeamApplicationService;
import kd.opmc.pbs.business.domain.pot.entityservice.PotMemberEntityService;
import kd.opmc.pbs.business.domain.pot.enums.TeamRoleEnum;
import kd.opmc.pbs.business.domain.pot.service.PotLabelDomainService;
import kd.opmc.pbs.business.external.hrpi.IDepempService;
import kd.opmc.pbs.business.external.hrpi.IHRPIPersonService;
import kd.opmc.pbs.business.external.hrpi.IHRPIWorkRoleService;
import kd.opmc.pbs.business.task.PotMemberInsTask;

public class PotMemberDomainService {
    private static final Log LOG = LogFactory.getLog(PotMemberDomainService.class);
    private static final IHRPIPersonService PERSON_SERVICE = IHRPIPersonService.getInstance();
    private static final PotMemberEntityService MEMBER_ENTITY_SERVICE = PotMemberEntityService.getInstance();
    private static final IDepempService DEP_EMP_SERVICE = IDepempService.getInstance();
    private static final IHRPIWorkRoleService WORK_ROLE_SERVICE = IHRPIWorkRoleService.getInstance();
    private static final ProjectOrgTeamApplicationService POT_SERVICE = ProjectOrgTeamApplicationService.getInstance();
    private static final PotLabelDomainService LABEL_SERVICE = PotLabelDomainService.getInstance();

    public static PotMemberDomainService getInstance() {
        return ServiceFactory.getService(PotMemberDomainService.class);
    }

    public Map<String, List<Map<String, Object>>> getActivePersonByOrg(long adminOrgId) {
        return PERSON_SERVICE.getActivePersonByOrg(adminOrgId);
    }

    public DynamicObject[] initPotMemberOfOrg(long adminOrgId, long teamLeader, Date effectDate, PotMemberInsTask potMemberInsTask) {
        Map<String, List<Map<String, Object>>> activePersonByOrg = this.getActivePersonByOrg(adminOrgId);
        if (ObjectUtils.isEmpty(activePersonByOrg)) {
            return new DynamicObject[0];
        }
        List<Map<String, Object>> list = activePersonByOrg.get("list");
        if (ObjectUtils.isEmpty(list)) {
            list = new ArrayList<Map<String, Object>>();
        }
        List<Long> demEmpIds = list.stream().map(depEmpMap -> Long.valueOf(depEmpMap.get("id").toString())).collect(Collectors.toList());
        return this.initPotMemberByDemEmp(demEmpIds, teamLeader, effectDate, true, potMemberInsTask);
    }

    public DynamicObject[] initPotMemberByDemEmp(List<Long> demEmpIds, long teamLeader, Date effectDate, boolean isInit, PotMemberInsTask potMemberInsTask) {
        if (!demEmpIds.contains(teamLeader) && isInit) {
            demEmpIds.add(teamLeader);
        }
        List<DynamicObject> empOrgrelDys = DEP_EMP_SERVICE.listDataEmpOrgrelDys(demEmpIds);
        this.feedbackProgress(potMemberInsTask, 20);
        Map<Long, List<DynamicObject>> empOrgrelOfPersonMap = empOrgrelDys.stream().collect(Collectors.groupingBy(empOrgrelDy -> empOrgrelDy.getLong("person.id")));
        ArrayList<Long> personIds = new ArrayList<Long>(empOrgrelOfPersonMap.keySet());
        HashMap<String, List<Long>> idMaps = new HashMap<String, List<Long>>(16);
        idMaps.put("person", personIds);
        Map<String, Object> userIdByPersonInfo = PERSON_SERVICE.getUserIdByPersonInfo(idMaps);
        this.feedbackProgress(potMemberInsTask, 40);
        Map data = (Map)userIdByPersonInfo.get("data");
        DynamicObject[] memberDys = new DynamicObject[empOrgrelOfPersonMap.size()];
        String[] numbers = CodeRuleServiceHelper.getBatchNumber((String)"pbs_potmember", (DynamicObject)MEMBER_ENTITY_SERVICE.generateEmptyDynamicObject(), null, (int)empOrgrelOfPersonMap.size());
        this.feedbackProgress(potMemberInsTask, 60);
        int index = 0;
        for (Map.Entry<Long, List<DynamicObject>> empOrgrelOfPerson : empOrgrelOfPersonMap.entrySet()) {
            DynamicObject empOrgrelDy2 = empOrgrelOfPerson.getValue().stream().filter(empOrgrel -> StringUtils.equals((CharSequence)empOrgrel.getString("isprimary"), (CharSequence)"1")).findFirst().orElseGet(() -> (DynamicObject)((List)empOrgrelOfPerson.getValue()).get(0));
            Long personId = empOrgrelOfPerson.getKey();
            DynamicObject memberDy = MEMBER_ENTITY_SERVICE.generateEmptyDynamicObject();
            this.feedbackProgress(potMemberInsTask, 80);
            memberDy.set("status", (Object)"C");
            memberDy.set("enable", (Object)"1");
            memberDy.set("number", (Object)numbers[index]);
            memberDy.set("name", (Object)numbers[index]);
            memberDy.set("empposrel", (Object)empOrgrelDy2.getLong("id"));
            memberDy.set("depemp", (Object)empOrgrelDy2.getLong("depemp.id"));
            memberDy.set("person", (Object)personId);
            memberDy.set("effectdate", (Object)effectDate);
            memberDy.set("isedit", (Object)Boolean.TRUE);
            memberDy.set("creator", (Object)RequestContext.get().getCurrUserId());
            memberDy.set("createtime", (Object)new Date());
            memberDy.set("level", (Object)1);
            memberDy.set("modifier", (Object)RequestContext.get().getCurrUserId());
            memberDy.set("modifytime", (Object)new Date());
            memberDy.set("longnumber", (Object)numbers[index]);
            memberDy.set("fullname", (Object)numbers[index]);
            long userId = 0L;
            if (data != null) {
                Map userInfo = (Map)data.get(personId);
                userId = userInfo == null ? 0L : (Long)userInfo.get("user");
            }
            memberDy.set("user", (Object)userId);
            memberDys[index++] = memberDy;
        }
        Object[] members = this.saveMemberByOp(memberDys);
        this.feedbackProgress(potMemberInsTask, 90);
        if (ObjectUtils.isEmpty((Object[])members)) {
            return members;
        }
        return this.initReportRel(teamLeader, (DynamicObject[])members);
    }

    private void feedbackProgress(PotMemberInsTask potMemberInsTask, int process) {
        if (ObjectUtils.isEmpty((Object)((Object)potMemberInsTask))) {
            return;
        }
        String desc = ResManager.loadKDString((String)"\u8bf7\u52ff\u9000\u51fa\u9875\u9762\u6216\u6267\u884c\u4fdd\u5b58\u7b49\u64cd\u4f5c\uff0c\u4ee5\u514d\u5f71\u54cd\u521d\u59cb\u5316\u8fc7\u7a0b\u3002", (String)"PotMemberDomainService_1", (String)"opmc-pbs-business", (Object[])new Object[0]);
        potMemberInsTask.feedbackProgress(process, desc, null);
    }

    private DynamicObject[] initReportRel(long teamLeader, DynamicObject[] members) {
        Map memberOfDepEmpMap = Arrays.stream(members).collect(Collectors.toMap(member -> member.getLong("depemp.id"), Function.identity(), (key1, key2) -> key2));
        Map<Long, List<Map<String, Object>>> superiorInfo = WORK_ROLE_SERVICE.getDirectSuperiorByDepempId(new ArrayList<Long>(memberOfDepEmpMap.keySet()));
        DynamicObject teamLeaderDy = (DynamicObject)memberOfDepEmpMap.get(teamLeader);
        if (!ObjectUtils.isEmpty((Object)teamLeaderDy)) {
            teamLeaderDy.set("teamrole", (Object)TeamRoleEnum.TEAM_LEADER.getRoleId());
            teamLeaderDy.set("parent", null);
        }
        for (Map.Entry memberOfDepEmp : memberOfDepEmpMap.entrySet()) {
            Long depEmpId = memberOfDepEmp.getKey();
            if (depEmpId.equals(teamLeader)) continue;
            DynamicObject member2 = (DynamicObject)memberOfDepEmp.getValue();
            member2.set("teamrole", (Object)TeamRoleEnum.TEAM_MEMBER.getRoleId());
            List<Map<String, Object>> superior = superiorInfo.get(depEmpId);
            if (!ObjectUtils.isEmpty(superior)) {
                Long parentDepEmpId = (Long)superior.get(0).get("depemp.id");
                DynamicObject parent = (DynamicObject)memberOfDepEmpMap.get(parentDepEmpId);
                if (!ObjectUtils.isEmpty((Object)parent) && parent.getLong("depemp.id") != teamLeader) {
                    parent.set("teamrole", (Object)TeamRoleEnum.GROUP_LEADER.getRoleId());
                }
                member2.set("parent", (Object)(parent == null ? teamLeaderDy : parent));
                continue;
            }
            member2.set("parent", (Object)teamLeaderDy);
        }
        for (Map.Entry memberOfDepEmp : memberOfDepEmpMap.entrySet()) {
            DynamicObject member3 = (DynamicObject)memberOfDepEmp.getValue();
            DynamicObject parent = member3.getDynamicObject("parent");
            if (ObjectUtils.isEmpty((Object)parent)) continue;
            String parentNum = parent.getString("number");
            Long parentId = member3.getLong("parent.id");
            String targetNum = this.getNumStr(parentNum, parentId, members);
            String cNumber = member3.getString("number");
            member3.set("longnumber", (Object)(targetNum + "." + cNumber));
        }
        Collection<DynamicObject> values = memberOfDepEmpMap.values();
        DynamicObject[] memberDyArr = values.toArray(new DynamicObject[0]);
        return (DynamicObject[])MEMBER_ENTITY_SERVICE.save(memberDyArr);
    }

    private String getNumStr(String target, Long parentId, DynamicObject[] memberDys) {
        for (DynamicObject member : memberDys) {
            long cMemberId = member.getLong("id");
            if (parentId != cMemberId) continue;
            long pId = member.getLong("parent.id");
            if (pId == 0L) break;
            String pNum = member.getDynamicObject("parent").getString("number");
            target = this.getNumStr(pNum + "." + target, pId, memberDys);
        }
        return target;
    }

    private DynamicObject[] saveMemberByOp(DynamicObject[] memberDys) {
        DynamicObject[] saveDys = (DynamicObject[])MEMBER_ENTITY_SERVICE.save(memberDys);
        List memberIds = Arrays.stream(saveDys).map(dy -> dy.getLong("id")).collect(Collectors.toList());
        return MEMBER_ENTITY_SERVICE.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", memberIds)});
    }

    public DynamicObject[] queryMembers(long potId) {
        QFilter potFilter = new QFilter("pot", "=", (Object)potId);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        return MEMBER_ENTITY_SERVICE.loadDynamicObjectArray(new QFilter[]{potFilter, enableFilter});
    }

    public DynamicObject[] queryMemberByPid(List<Long> parentIds) {
        QFilter potFilter = new QFilter("parent", "in", parentIds);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        return MEMBER_ENTITY_SERVICE.loadDynamicObjectArray(new QFilter[]{potFilter, enableFilter});
    }

    public void deleteMemberById(List<Long> deleteMemberIds) {
        MEMBER_ENTITY_SERVICE.delete(deleteMemberIds.toArray(new Long[0]));
    }

    public void saveMembers(DynamicObjectCollection memberDatas, Long potId, List<Long> potMemberIds) {
        Object[] members;
        Map memberDataMap = memberDatas.stream().collect(Collectors.toMap(memberData -> memberData.getDynamicObject("cmember").getLong("id"), Function.identity()));
        Set<Long> memberIds = memberDataMap.keySet();
        for (Object member : members = MEMBER_ENTITY_SERVICE.query("pot, isedit, teamrole, parent, effectdate, grouplabel", new QFilter[]{new QFilter("id", "in", memberIds)})) {
            long memberId = member.getLong("id");
            DynamicObject memberData2 = (DynamicObject)memberDataMap.get(memberId);
            member.set("pot", (Object)potId);
            member.set("isedit", (Object)Boolean.FALSE);
            member.set("teamrole", memberData2.get("teamrole"));
            member.set("parent", memberData2.get("parent"));
            member.set("effectdate", memberData2.get("effectdate"));
            member.set("grouplabel", memberData2.get("grouplabel"));
            member.set("longnumber", memberData2.get("longnumber"));
        }
        if (!ObjectUtils.isEmpty((Object[])members)) {
            MEMBER_ENTITY_SERVICE.save((DynamicObject[])members);
        }
        QFilter delFilter = new QFilter("pot", "=", (Object)potId).and("id", "not in", potMemberIds).and("isedit", "=", (Object)Boolean.TRUE);
        MEMBER_ENTITY_SERVICE.deleteByFilter(new QFilter[]{delFilter});
    }

    public DynamicObject[] loadDynamicObjectArray(List<Long> idList) {
        QFilter qFilter = new QFilter("id", "in", idList);
        return MEMBER_ENTITY_SERVICE.loadDynamicObjectArray(new QFilter[]{qFilter});
    }

    public DynamicObjectCollection queryPotByParentId(Long parentId) {
        return POT_SERVICE.queryPotByParentId(parentId);
    }

    public DynamicObject queryOne(Long pkId) {
        return MEMBER_ENTITY_SERVICE.queryOne("enable", pkId);
    }

    public void disableMemberById(List<Long> disableMemberIds) {
        DynamicObject[] members;
        if (ObjectUtils.isEmpty(disableMemberIds)) {
            return;
        }
        QFilter qFilter = new QFilter("id", "in", disableMemberIds);
        for (DynamicObject member : members = MEMBER_ENTITY_SERVICE.query("enable", new QFilter[]{qFilter})) {
            member.set("enable", (Object)"0");
        }
        MEMBER_ENTITY_SERVICE.save(members);
    }

    public DynamicObject[] queryLabelByPotId(long potId) {
        return LABEL_SERVICE.queryLabels(potId);
    }

    public DynamicObject queryOne(String selectProperties, Long pkId) {
        return MEMBER_ENTITY_SERVICE.queryOne(selectProperties, pkId);
    }

    public void updateOne(DynamicObject member) {
        MEMBER_ENTITY_SERVICE.updateOne(member);
    }

    public void updateDatas(DynamicObject[] members) {
        MEMBER_ENTITY_SERVICE.updateDatas(members);
    }

    public void updateParentByIds(List<Long> subIds) {
        QFilter qFilter = new QFilter("id", "in", subIds);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        Object[] memberList = MEMBER_ENTITY_SERVICE.query("id, parent, pot", new QFilter[]{qFilter, enableFilter});
        if (ObjectUtils.isEmpty((Object[])memberList)) {
            return;
        }
        long potId = memberList[0].getLong("pot.id");
        DynamicObject teamLeader = this.queryTeamLeader(potId);
        long teamLeaderId = ObjectUtils.isEmpty((Object)teamLeader) ? 0L : teamLeader.getLong("id");
        for (Object member : memberList) {
            member.set("parent", (Object)teamLeaderId);
        }
        MEMBER_ENTITY_SERVICE.update((DynamicObject[])memberList);
    }

    public DynamicObject queryTeamLeader(long potId) {
        QFilter potFilter = new QFilter("pot", "=", (Object)potId);
        QFilter teamLeaderFilter = new QFilter("teamrole", "=", (Object)TeamRoleEnum.TEAM_LEADER.getRoleId());
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        return MEMBER_ENTITY_SERVICE.queryOne("id,person", new QFilter[]{potFilter, teamLeaderFilter, enableFilter});
    }

    public DynamicObject getPotMember(Long dutyPersonId) {
        return MEMBER_ENTITY_SERVICE.getPotMember(dutyPersonId);
    }

    public DynamicObject getPotMemberByUser(Long userId) {
        return MEMBER_ENTITY_SERVICE.getPotMemberByUser(userId);
    }

    public DynamicObject[] getPotMemberByCurrentUser() {
        return MEMBER_ENTITY_SERVICE.getPotMemberByCurrentUser();
    }

    public boolean isPotMemberOfCurrentUser() {
        return MEMBER_ENTITY_SERVICE.isPotMemberOfCurrentUser();
    }

    public DynamicObject[] getTeamMembers(DynamicObject[] memberDys) {
        Set<Long> potIds = Arrays.stream(memberDys).map(memberDy -> memberDy.getLong("pot.id")).collect(Collectors.toSet());
        return MEMBER_ENTITY_SERVICE.getTeamMembers(potIds);
    }
}

