/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.pbs.business.domain.pot.service;

import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.pbs.business.ServiceFactory;
import kd.opmc.pbs.business.domain.pot.entityservice.PotMemberEntityService;
import kd.opmc.pbs.business.domain.pot.entityservice.ProjectOrgTeamEntityService;
import kd.opmc.pbs.business.domain.pot.enums.POTStatusEnum;
import kd.opmc.pbs.business.external.hrpi.IHRPIPersonService;
import kd.opmc.pbs.business.external.hrpi.IHRPIWorkRoleService;

public class ProjectOrgTeamDomainService {
    private static final Log LOG = LogFactory.getLog(ProjectOrgTeamDomainService.class);
    private static final ProjectOrgTeamEntityService POT_ENTITY = ProjectOrgTeamEntityService.getInstance();
    private static final PotMemberEntityService POT_MEMBER_ENTITY = PotMemberEntityService.getInstance();
    private static final IHRPIPersonService PERSON_SERVICE = IHRPIPersonService.getInstance();
    private static final IHRPIWorkRoleService WORK_ROLE_SERVICE = IHRPIWorkRoleService.getInstance();

    public static ProjectOrgTeamDomainService getInstance() {
        return ServiceFactory.getService(ProjectOrgTeamDomainService.class);
    }

    public List<Map<String, Object>> getMainChargeInfoByOrg(Long adminOrgId) {
        List<Map<String, Object>> mainChargeInfoByOrg = WORK_ROLE_SERVICE.getMainChargeInfoByOrg(Collections.singletonList(adminOrgId));
        LOG.info("getMainChargeInfoByOrg\uff1a{}", mainChargeInfoByOrg);
        return mainChargeInfoByOrg;
    }

    public int countMember(Long potId) {
        QFilter potFilter = new QFilter("pot", "=", (Object)potId);
        QFilter isEditFilter = new QFilter("isedit", "=", (Object)Boolean.FALSE);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        return POT_MEMBER_ENTITY.count("pbs_potmember", new QFilter[]{potFilter, isEditFilter, enableFilter});
    }

    public DynamicObject getPerson(long personId) {
        HRBaseServiceHelper personHelper = new HRBaseServiceHelper("hrpi_person");
        return personHelper.queryOne((Object)personId);
    }

    public void save(DynamicObject[] dataEntities) {
        POT_ENTITY.save(dataEntities);
    }

    public DynamicObjectCollection queryPotByParentId(Long parentId) {
        QFilter nodeIdQf = new QFilter("parent", "=", (Object)parentId);
        return POT_ENTITY.queryOriginalCollection("id,name,enable", new QFilter[]{nodeIdQf});
    }

    public boolean canUpdate(Long primaryKeyValue) {
        DynamicObject dynamicObject = POT_ENTITY.queryOne("enable", primaryKeyValue);
        return HRStringUtils.equals((String)dynamicObject.getString("enable"), (String)"1");
    }

    public void TeamStatusChange() {
        DynamicObject[] objects = POT_ENTITY.query("id, effectdate, enable, teamstatus", new QFilter[0]);
        DynamicObject[] updateDatas = (DynamicObject[])Arrays.stream(objects).peek(obj -> {
            String enable = obj.getString("enable");
            Date date = obj.getDate("effectdate");
            POTStatusEnum statusEnum = POTStatusEnum.calculateTeamStatus(enable, date);
            obj.set("teamstatus", (Object)statusEnum.getValue());
        }).toArray(DynamicObject[]::new);
        POT_ENTITY.updateDatas(updateDatas);
    }

    public DynamicObject[] queryAllSubPotByNum(String cPotNum) {
        QFilter qFilter = new QFilter("longnumber", "like", (Object)("%" + cPotNum + "%"));
        return POT_ENTITY.query("id", new QFilter[]{qFilter});
    }

    public DynamicObject queryByNum(String number) {
        QFilter qFilter = new QFilter("number", "=", (Object)number);
        return POT_ENTITY.queryOne(new QFilter[]{qFilter});
    }
}

