/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.pbs.business.domain.workflow.entityservice;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.opmc.pbs.business.ServiceFactory;
import kd.opmc.pbs.business.domain.OpmcEntityService;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowRuTaskEntityService;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuTaskStatusEnum;

public class BatchTaskmapEntityService
extends OpmcEntityService {
    private static final HRBaseServiceHelper HELPER = new HRBaseServiceHelper("pbs_batchtaskmap");
    private static final String SELECTPROPERTIES = "id,rutask.id,rutask.taskstatus,actevaobj.id,batchtask";

    public static BatchTaskmapEntityService getInstance() {
        return ServiceFactory.getService(BatchTaskmapEntityService.class);
    }

    @Override
    protected HRBaseServiceHelper getServiceHelper() {
        return HELPER;
    }

    public DynamicObject queryBatchTaskByPk(Long pk) {
        return this.queryOne(SELECTPROPERTIES, pk);
    }

    public DynamicObject[] queryBatchTaskByPkIds(List<Long> pkIds) {
        QFilter qFilter = new QFilter("id", "in", pkIds);
        return this.query(SELECTPROPERTIES, new QFilter[]{qFilter});
    }

    public DynamicObject[] queryBatchTaskByFilter(QFilter qFilter) {
        return this.query(SELECTPROPERTIES, new QFilter[]{qFilter});
    }

    public DynamicObject[] queryEffectTaskByBatchTaskIds(List<Long> batchTaskIds, QFilter cusFilter) {
        QFilter qFilter = new QFilter("batchtask", "in", batchTaskIds);
        qFilter.and(new QFilter("rutask.taskstatus", "not in", Collections.singletonList(FlowRuTaskStatusEnum.EXPIRED.getCode())));
        if (null != cusFilter) {
            qFilter.and(cusFilter);
        }
        return this.query(SELECTPROPERTIES, new QFilter[]{qFilter});
    }

    public DynamicObject[] queryTaskByBatchTaskIds(List<Long> batchTaskIds) {
        QFilter qFilter = new QFilter("batchtask", "in", batchTaskIds);
        return this.query(SELECTPROPERTIES, new QFilter[]{qFilter});
    }

    public Object[] generateBatchTask(Long batchTaskId, List<Long> taskIdList) {
        Date date = new Date();
        long userId = UserServiceHelper.getCurrentUserId();
        DynamicObject[] taskDyns = FlowRuTaskEntityService.getInstance().queryTasksByIds(taskIdList);
        HashMap<Long, Long> taskEvaObjMap = new HashMap<Long, Long>(16);
        for (DynamicObject task : taskDyns) {
            taskEvaObjMap.put(task.getLong("id"), task.getLong("flowruproc.actevalobj"));
        }
        ArrayList<DynamicObject> batchTaskList = new ArrayList<DynamicObject>(10);
        for (Long taskId : taskIdList) {
            DynamicObject batchTask = this.generateEmptyDynamicObject();
            batchTask.set("creator", (Object)userId);
            batchTask.set("createtime", (Object)date);
            batchTask.set("modifier", (Object)userId);
            batchTask.set("modifytime", (Object)date);
            batchTask.set("rutask", (Object)taskId);
            batchTask.set("actevaobj", taskEvaObjMap.get(taskId));
            batchTask.set("batchtask", (Object)batchTaskId);
            batchTaskList.add(batchTask);
        }
        return this.save(batchTaskList.toArray(new DynamicObject[0]));
    }

    public boolean deleteByActevalObjs(List<Long> actevalobjs) {
        QFilter qFilter = new QFilter("actevaobj", "in", actevalobjs);
        return this.deleteByFilter(new QFilter[]{qFilter}) > 0 ? Boolean.TRUE : Boolean.FALSE;
    }
}

