/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.pbs.business.domain.workflow.entityservice;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.pbs.business.ServiceFactory;
import kd.opmc.pbs.business.domain.OpmcEntityService;
import kd.opmc.pbs.business.domain.workflow.entityservice.IndicatorRoleSetEntityService;
import kd.opmc.pbs.business.domain.workflow.model.CrossScoreParamsBo;
import kd.opmc.pbs.business.domain.workflow.model.CrossScoreRoleBo;

public class CrossRoleSetEntityService
extends OpmcEntityService {
    private static final IndicatorRoleSetEntityService INDICATOR_ROLESET_ENTITYSERVICE = IndicatorRoleSetEntityService.getInstance();
    private static final HRBaseServiceHelper HELPER = new HRBaseServiceHelper("pbs_crossroleset");
    private static final String SELECTPROPERTIES = "id,entryentity,entryentity.handlerid";

    public static CrossRoleSetEntityService getInstance() {
        return ServiceFactory.getService(CrossRoleSetEntityService.class);
    }

    @Override
    protected HRBaseServiceHelper getServiceHelper() {
        return HELPER;
    }

    public DynamicObject queryCrossRoleSetByPk(Long pk) {
        return this.queryOne(SELECTPROPERTIES, pk);
    }

    public DynamicObject[] queryCrossRoleSetByIds(List<Long> ids) {
        QFilter qFilter = new QFilter("id", "in", ids);
        return this.loadDynamicObjectArray(new QFilter[]{qFilter});
    }

    public Map<String, List<DynamicObject>> queryCrossRoleSet(List<String> setNoList) {
        DynamicObject[] crossRoleArr;
        HashMap<String, List<DynamicObject>> resultMap = new HashMap<String, List<DynamicObject>>(16);
        QFilter qFilter = new QFilter("setno", "in", setNoList);
        for (DynamicObject crossRole : crossRoleArr = this.loadDynamicObjectArray(new QFilter[]{qFilter})) {
            List<DynamicObject> crossRoleList;
            if (null != resultMap.get(crossRole.getString("setno"))) {
                crossRoleList = (List)resultMap.get(crossRole.getString("setno"));
                crossRoleList.add(crossRole);
                continue;
            }
            crossRoleList = new ArrayList<DynamicObject>(10);
            crossRoleList.add(crossRole);
            resultMap.put(crossRole.getString("setno"), crossRoleList);
        }
        return resultMap;
    }

    public Map<String, List<DynamicObject>> queryCrossRoleSetByNodeDef(Long nodeDefId) {
        DynamicObject[] crossRoleArr;
        HashMap<String, List<DynamicObject>> resultMap = new HashMap<String, List<DynamicObject>>(16);
        QFilter qFilter = new QFilter("nodedef", "=", (Object)nodeDefId);
        for (DynamicObject crossRole : crossRoleArr = this.loadDynamicObjectArray(new QFilter[]{qFilter})) {
            List<DynamicObject> crossRoleList;
            if (null != resultMap.get(crossRole.getString("setno"))) {
                crossRoleList = (List)resultMap.get(crossRole.getString("setno"));
                crossRoleList.add(crossRole);
                continue;
            }
            crossRoleList = new ArrayList<DynamicObject>(10);
            crossRoleList.add(crossRole);
            resultMap.put(crossRole.getString("setno"), crossRoleList);
        }
        return resultMap;
    }

    public void generateCrossRoleSet(CrossScoreParamsBo crossScoreBo) {
        ArrayList<DynamicObject> crossRoleSetList = new ArrayList<DynamicObject>(10);
        String existedSetNo = this.requireExistSameSetNo(crossScoreBo);
        if (HRStringUtils.isNotEmpty((String)existedSetNo)) {
            this.generateIndicator(crossScoreBo, existedSetNo, "0");
        } else {
            List<CrossScoreRoleBo> crossRoleBoList = crossScoreBo.getCrossScoreRoleBo();
            String batchNo = CodeRuleServiceHelper.getNumber((String)"pbs_crossroleset", (DynamicObject)this.generateEmptyDynamicObject(), null);
            for (CrossScoreRoleBo crossRoleBo : crossRoleBoList) {
                DynamicObject crossRoleSetDy = this.generateEmptyDynamicObject();
                crossRoleSetDy.set("defroleid", (Object)crossRoleBo.getRoleDef());
                crossRoleSetDy.set("roleweight", (Object)crossRoleBo.getRoleWeight());
                crossRoleSetDy.set("turnoversort", (Object)crossRoleBo.getTurnoverSort());
                crossRoleSetDy.set("setno", (Object)batchNo);
                crossRoleSetDy.set("nodedef", (Object)crossScoreBo.getNodeDefId());
                List<Long> handlerList = crossRoleBo.getRoleHandlerList();
                DynamicObjectCollection roleHandlerColl = crossRoleSetDy.getDynamicObjectCollection("entryentity");
                for (Long userId : handlerList) {
                    DynamicObject handlerDy = roleHandlerColl.addNew();
                    handlerDy.set("handlerid", (Object)userId);
                }
                crossRoleSetList.add(crossRoleSetDy);
            }
            this.save(crossRoleSetList.toArray(new DynamicObject[0]));
            this.generateIndicator(crossScoreBo, batchNo, "1");
        }
    }

    private void generateIndicator(CrossScoreParamsBo crossScoreBo, String batchNo, String dataType) {
        Map<Long, Map<Long, Long>> actEvaObjIndMap = crossScoreBo.getActEvaObjIndMap();
        ArrayList<Long> indicatorIdList = new ArrayList<Long>(10);
        ArrayList<DynamicObject> indicatorRoleSetList = new ArrayList<DynamicObject>(10);
        HashSet<Object> crossNoSet = new HashSet(16);
        if (HRStringUtils.equals((String)dataType, (String)"0")) {
            crossNoSet = this.queryIndicatorIdBySetNo(crossScoreBo, batchNo, dataType);
        }
        for (Map.Entry<Long, Map<Long, Long>> entry : actEvaObjIndMap.entrySet()) {
            Map<Long, Long> indMap = entry.getValue();
            for (Map.Entry<Long, Long> indEntry : indMap.entrySet()) {
                Long indicatorId = indEntry.getKey();
                if (HRStringUtils.equals((String)dataType, (String)"0") && crossNoSet.contains(indicatorId)) continue;
                DynamicObject indRoleSetDy = new HRBaseServiceHelper("pbs_indroleset").generateEmptyDynamicObject();
                indRoleSetDy.set("indicatorid", (Object)indicatorId);
                indRoleSetDy.set("arearegid", (Object)indEntry.getValue());
                indRoleSetDy.set("evaobjid", (Object)entry.getKey());
                indRoleSetDy.set("crossrolesetno", (Object)batchNo);
                indRoleSetDy.set("nodedef", (Object)crossScoreBo.getNodeDefId());
                indicatorRoleSetList.add(indRoleSetDy);
                indicatorIdList.add(indEntry.getKey());
            }
        }
        INDICATOR_ROLESET_ENTITYSERVICE.save(indicatorRoleSetList.toArray(new DynamicObject[0]));
        this.deleteRelDataSetNo(crossScoreBo, batchNo, indicatorIdList);
    }

    private HashSet<Long> queryIndicatorIdBySetNo(CrossScoreParamsBo crossScoreBo, String batchNo, String dataType) {
        HashSet<Long> crossNoSet = new HashSet<Long>(16);
        QFilter qFilter = new QFilter("nodedef", "=", (Object)crossScoreBo.getNodeDefId());
        qFilter.and("crossrolesetno", "=", (Object)batchNo);
        DynamicObject[] existIndRoleSetArr = INDICATOR_ROLESET_ENTITYSERVICE.queryCrossRoleSetByCusFilter(qFilter);
        int existIndRoleSize = existIndRoleSetArr.length;
        if (existIndRoleSize <= 0) {
            return crossNoSet;
        }
        for (int index = 0; index < existIndRoleSize; ++index) {
            crossNoSet.add(existIndRoleSetArr[index].getLong("indicatorid"));
        }
        return crossNoSet;
    }

    private void deleteRelDataSetNo(CrossScoreParamsBo crossScoreBo, String batchNo, List<Long> indicatorIdList) {
        DynamicObject[] indRoleSetArr;
        QFilter qFilter = new QFilter("indicatorid", "in", indicatorIdList);
        qFilter.and("nodedef", "=", (Object)crossScoreBo.getNodeDefId());
        qFilter.and("crossrolesetno", "!=", (Object)batchNo);
        DynamicObject[] existIndRoleSetArr = INDICATOR_ROLESET_ENTITYSERVICE.queryCrossRoleSetByCusFilter(qFilter);
        HashSet<String> crossNoSet = new HashSet<String>(16);
        int existIndRoleSize = existIndRoleSetArr.length;
        if (existIndRoleSize > 0) {
            Object[] pks = new Object[existIndRoleSize];
            for (int i = 0; i < existIndRoleSize; ++i) {
                pks[i] = existIndRoleSetArr[i].get("id");
                crossNoSet.add(existIndRoleSetArr[i].getString("crossrolesetno"));
            }
            INDICATOR_ROLESET_ENTITYSERVICE.delete(pks);
        }
        QFilter cusFilter = new QFilter("crossrolesetno", "in", crossNoSet.stream().collect(Collectors.toList()));
        for (DynamicObject indRoleSet : indRoleSetArr = INDICATOR_ROLESET_ENTITYSERVICE.queryCrossRoleSetByCusFilter(cusFilter)) {
            crossNoSet.remove(indRoleSet.getString("crossrolesetno"));
        }
        if (crossNoSet.size() > 0) {
            QFilter delFilter = new QFilter("setno", "in", crossNoSet.stream().collect(Collectors.toList()));
            this.deleteByFilter(new QFilter[]{delFilter});
        }
    }

    private String requireExistSameSetNo(CrossScoreParamsBo crossScoreBo) {
        Map<String, List<DynamicObject>> setNoMap = this.queryCrossRoleSetByNodeDef(crossScoreBo.getNodeDefId());
        if (null == setNoMap || setNoMap.size() <= 0) {
            return "";
        }
        List<CrossScoreRoleBo> crossRoleBoList = crossScoreBo.getCrossScoreRoleBo();
        if (CollectionUtils.isEmpty(crossRoleBoList)) {
            return "";
        }
        int inputRoleSize = crossRoleBoList.size();
        Map<Long, Double> inputRoleMap = crossRoleBoList.stream().collect(Collectors.toMap(CrossScoreRoleBo::getRoleDef, CrossScoreRoleBo::getRoleWeight));
        for (Map.Entry<String, List<DynamicObject>> entry : setNoMap.entrySet()) {
            boolean isExsitSameHandler;
            List<DynamicObject> setNoDyList = entry.getValue();
            boolean isSmaeRole = this.isExsitSameRoleDef(inputRoleMap, setNoDyList, inputRoleSize);
            if (!isSmaeRole || !(isExsitSameHandler = this.isExistSameHandlerWithRoleDef(crossRoleBoList, setNoDyList))) continue;
            return entry.getKey();
        }
        return "";
    }

    private boolean isExsitSameRoleDef(Map<Long, Double> inputRoleMap, List<DynamicObject> setNoDyList, int inputRoleSize) {
        if (inputRoleSize != setNoDyList.size()) {
            return Boolean.FALSE;
        }
        for (DynamicObject setNoDy : setNoDyList) {
            BigDecimal queryRoleWeight = setNoDy.getBigDecimal("roleweight");
            Long defRoleId = setNoDy.getLong("defroleid.id");
            Double inputRoleWeight = inputRoleMap.get(defRoleId);
            if (null != inputRoleWeight && queryRoleWeight.compareTo(BigDecimal.valueOf(inputRoleWeight)) == 0) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private boolean isExistSameHandlerWithRoleDef(List<CrossScoreRoleBo> crossRoleBoList, List<DynamicObject> setNoDy) {
        for (CrossScoreRoleBo scoreRoleBo : crossRoleBoList) {
            List queryRoleSetNoDyList = setNoDy.stream().filter(role -> scoreRoleBo.getRoleDef().equals(role.getLong("defroleid.id"))).collect(Collectors.toList());
            DynamicObject querySetNody = (DynamicObject)queryRoleSetNoDyList.get(0);
            DynamicObjectCollection entryColl = querySetNody.getDynamicObjectCollection("entryentity");
            List queryHandlerList = entryColl.stream().map(handler -> handler.getLong("handlerid.id")).collect(Collectors.toList());
            if (org.apache.commons.collections.CollectionUtils.isEqualCollection(scoreRoleBo.getRoleHandlerList(), queryHandlerList)) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public List<DynamicObject> queryCrossRoleSetByIndicatorList(Long nodeId, List<Long> indicatorIdList) {
        DynamicObject[] indRoleSetArr = INDICATOR_ROLESET_ENTITYSERVICE.queryCrossRoleSet(nodeId, indicatorIdList);
        HashSet<String> crossNoSet = new HashSet<String>(16);
        for (DynamicObject indRoleSet : indRoleSetArr) {
            crossNoSet.add(indRoleSet.getString("crossrolesetno"));
        }
        if (crossNoSet.size() > 1) {
            return null;
        }
        ArrayList<String> crossNoList = new ArrayList<String>(crossNoSet);
        if (crossNoList.isEmpty() || indRoleSetArr.length != indicatorIdList.size()) {
            return null;
        }
        Map<String, List<DynamicObject>> resutlMap = this.queryCrossRoleSet(crossNoList);
        return resutlMap.get(crossNoList.get(0));
    }

    public Map<String, Map<String, Object>> queryAllCrossRoleSetByIndicatorList(Long nodeId, List<Long> indicatorIdList) {
        HashMap<String, Map<String, Object>> resultMap = new HashMap<String, Map<String, Object>>(16);
        DynamicObject[] indRoleSetArr = INDICATOR_ROLESET_ENTITYSERVICE.queryCrossRoleSet(nodeId, indicatorIdList);
        HashSet<String> crossNoSet = new HashSet<String>(16);
        HashMap indRoleSetMap = new HashMap(16);
        for (DynamicObject indRoleSet : indRoleSetArr) {
            List<DynamicObject> indList;
            crossNoSet.add(indRoleSet.getString("crossrolesetno"));
            if (null != indRoleSetMap.get(indRoleSet.getString("crossrolesetno"))) {
                indList = (List)indRoleSetMap.get(indRoleSet.getString("crossrolesetno"));
                indList.add(indRoleSet);
                continue;
            }
            indList = new ArrayList<DynamicObject>(10);
            indList.add(indRoleSet);
            indRoleSetMap.put(indRoleSet.getString("crossrolesetno"), indList);
        }
        List<String> crossNoList = crossNoSet.stream().collect(Collectors.toList());
        Map<String, List<DynamicObject>> roleSetMap = this.queryCrossRoleSet(crossNoList);
        for (Map.Entry<String, List<DynamicObject>> entry : roleSetMap.entrySet()) {
            HashMap<String, List<Object>> crossMap = new HashMap<String, List<Object>>(16);
            crossMap.put("crossRoleSet", entry.getValue());
            crossMap.put("indRoleSet", (List<Object>)indRoleSetMap.get(entry.getKey()));
            resultMap.put(entry.getKey(), crossMap);
        }
        return resultMap;
    }

    public DynamicObject[] queryByDefRoleIds(List<Long> defRoleIds) {
        if (CollectionUtils.isEmpty(defRoleIds)) {
            return new DynamicObject[0];
        }
        QFilter qFilter = new QFilter("defroleid", "in", defRoleIds);
        return this.loadDynamicObjectArray(qFilter.toArray());
    }

    public int deleteSetByActEvalObjs(List<Long> actEvalObjIds) {
        if (CollectionUtils.isEmpty(actEvalObjIds)) {
            return 0;
        }
        QFilter setFilter = new QFilter("evaobjid", "in", actEvalObjIds);
        DynamicObject[] deleteSets = INDICATOR_ROLESET_ENTITYSERVICE.query("id, crossrolesetno, evaobjid", setFilter.toArray());
        Set deletIds = Arrays.stream(deleteSets).map(e -> e.getLong("id")).collect(Collectors.toSet());
        Set crossRoleSetNos = Arrays.stream(deleteSets).map(e -> e.getString("crossrolesetno")).collect(Collectors.toSet());
        QFilter setNosFilter = new QFilter("crossrolesetno", "in", crossRoleSetNos);
        DynamicObject[] allSets = INDICATOR_ROLESET_ENTITYSERVICE.query("id, crossrolesetno", setNosFilter.toArray());
        Set exist = Arrays.stream(allSets).filter(e -> !deletIds.contains(e.getLong("id"))).map(e -> e.getString("crossrolesetno")).collect(Collectors.toSet());
        crossRoleSetNos.removeAll(exist);
        INDICATOR_ROLESET_ENTITYSERVICE.delete(deletIds.toArray());
        QFilter deleteRoleSetFilter = new QFilter("setno", "in", crossRoleSetNos);
        this.deleteByFilter(deleteRoleSetFilter.toArray());
        return actEvalObjIds.size();
    }

    public DynamicObject[] queryCrossRoleSetByDefNodeIds(List<Long> defNodeIds) {
        if (CollectionUtils.isEmpty(defNodeIds)) {
            return new DynamicObject[0];
        }
        QFilter qFilter = new QFilter("nodedef", "in", defNodeIds);
        return this.loadDynamicObjectArray(qFilter.toArray());
    }
}

