/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.pbs.business.domain.workflow.entityservice;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.opmc.pbs.business.ServiceFactory;
import kd.opmc.pbs.business.domain.OpmcEntityService;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowRuTaskEntityService;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuNodeStatusEnum;

public class FlowRuNodeEntityService
extends OpmcEntityService {
    private static final HRBaseServiceHelper HELPER = new HRBaseServiceHelper("pbs_flowrunode");
    private static final FlowRuTaskEntityService FLOW_RU_TASK_ENTITY_SERVICE = FlowRuTaskEntityService.getInstance();
    private static final String SELECTPROPERTIES = "id,flownodedef,flownodedef.crossscore,flownodedef.manualop,flownodedef.nodetype,flownodedef.nodetype.id,nodestatus, updatestatustime, modifier, modifytime, handlertype, appointemp, starttime,iscrossnode,index";

    public static FlowRuNodeEntityService getInstance() {
        return ServiceFactory.getService(FlowRuNodeEntityService.class);
    }

    @Override
    protected HRBaseServiceHelper getServiceHelper() {
        return HELPER;
    }

    public DynamicObject[] queryRunningNodeByPks(List<Long> pkIds) {
        QFilter qFilter = new QFilter("id", "in", pkIds).and("nodestatus", "=", (Object)FlowRuNodeStatusEnum.RUNNING.getCode());
        return this.query("nodestatus, updatestatustime, modifier, modifytime", new QFilter[]{qFilter});
    }

    public DynamicObject[] queryByRuNodeIds(List<Long> ruNodeIds) {
        QFilter qFilter = new QFilter("id", "in", ruNodeIds);
        return this.query("id,nodestatus, updatestatustime,flowruproc.id, flownodedef.id, flownodedef.sameauditjump, flownodedef.nodetype.id, modifier, modifytime, iscrossnode", new QFilter[]{qFilter});
    }

    public DynamicObject[] queryByProcIds(List<Long> procIds) {
        QFilter qFilter = new QFilter("flowruproc", "in", procIds);
        return this.query("id,nodestatus, updatestatustime,flowruproc.id, flownodedef.id,flownodedef.nodetype.id, modifier, modifytime, iscrossnode", new QFilter[]{qFilter});
    }

    public DynamicObject[] queryNodeByProcIds(List<Long> procIds) {
        QFilter qFilter = new QFilter("flowruproc", "in", procIds);
        qFilter.and("nodestatus", "not in", Arrays.asList(FlowRuNodeStatusEnum.RETURNED.getCode(), FlowRuNodeStatusEnum.EXPIRED.getCode(), FlowRuNodeStatusEnum.NOT_ACTIVE.getCode()));
        return this.queryOriginalArray("id, name, index,flowruproc.id", new QFilter[]{qFilter}, "index ASC");
    }

    public DynamicObject[] queryPendingOrStopNodeByPks(List<Long> pkIds) {
        QFilter qFilter = new QFilter("id", "in", pkIds).and("nodestatus", "in", Arrays.asList("10", "15"));
        return this.query("id, nodestatus, updatestatustime, modifier, modifytime, assessyear, assessperiod, activity, perforg", new QFilter[]{qFilter});
    }

    public DynamicObject queryRuNodeByPk(Long ruNodeId) {
        return this.queryOne(SELECTPROPERTIES, ruNodeId);
    }

    public DynamicObject queryRuNodeByIndex(Long ruProcId, int index) {
        QFilter qFilter = new QFilter("flowruproc", "=", (Object)ruProcId).and("index", "=", (Object)index);
        return this.queryOne(SELECTPROPERTIES, new QFilter[]{qFilter});
    }

    public DynamicObject queryNotPreCrossRuNode(Long ruProcId, int index) {
        QFilter qFilter = new QFilter("flowruproc", "=", (Object)ruProcId).and("index", "<=", (Object)index).and("iscrossnode", "!=", (Object)"1");
        DynamicObject[] ruNodes = this.query(SELECTPROPERTIES, new QFilter[]{qFilter}, "index desc");
        if (ruNodes != null) {
            for (DynamicObject ruNode : ruNodes) {
                if (ruNode == null) continue;
                return ruNode;
            }
        }
        return null;
    }

    public List<DynamicObject> generateRuNode(DynamicObject ruProc, DynamicObject flowDef, boolean isSave) {
        DynamicObjectCollection nodeDefList = flowDef.getDynamicObjectCollection("nodeentry");
        ArrayList<DynamicObject> ruNodeList = new ArrayList<DynamicObject>(nodeDefList.size());
        Date date = new Date();
        long userId = UserServiceHelper.getCurrentUserId();
        for (int i = 0; i < nodeDefList.size(); ++i) {
            DynamicObject nodeDef = (DynamicObject)nodeDefList.get(i);
            DynamicObject ruNode = this.generateEmptyDynamicObject();
            ruNode.set("creator", (Object)userId);
            ruNode.set("createtime", (Object)date);
            ruNode.set("modifier", (Object)userId);
            ruNode.set("modifytime", (Object)date);
            ruNode.set("name", nodeDef.get("nodename"));
            ruNode.set("ismatrixnode", nodeDef.get("ismatrixnode"));
            ruNode.set("ismajornode", nodeDef.get("ismajornode"));
            ruNode.set("flownodedef", (Object)nodeDef);
            ruNode.set("nodestatus", (Object)FlowRuNodeStatusEnum.NOT_ACTIVE.getCode());
            ruNode.set("assessyear", ruProc.get("assessyear"));
            ruNode.set("assessperiod", ruProc.get("assessperiod"));
            ruNode.set("flowruproc", (Object)ruProc);
            ruNode.set("nodeweight", nodeDef.get("nodeweight"));
            ruNode.set("updatestatustime", (Object)date);
            ruNode.set("index", nodeDef.get("seq"));
            ruNode.set("activity", ruProc.get("activity"));
            ruNode.set("perforg", ruProc.get("perforg"));
            ruNode.set("handlertype", nodeDef.get("handlertype"));
            ruNode.set("appointemp", nodeDef.get("appointemp"));
            ruNode.set("iscrossnode", nodeDef.get("crossscore"));
            ruNode.set("id", (Object)ORM.create().genLongId("pbs_flowrunode"));
            ruNode.set("starttime", (Object)date);
            ruNode.set("updatestatustime", (Object)date);
            ruNode.set("modifier", (Object)UserServiceHelper.getCurrentUserId());
            ruNode.set("modifytime", (Object)date);
            ruNodeList.add(ruNode);
        }
        if (isSave) {
            this.save(ruNodeList.toArray(new DynamicObject[0]));
        }
        return ruNodeList;
    }

    public DynamicObject[] queryNodeWeightByProcId(Long ruProcId) {
        QFilter qFilter = new QFilter("flowruproc", "=", (Object)ruProcId).and("nodestatus", "=", (Object)FlowRuNodeStatusEnum.FINISHED.getCode());
        return this.queryOriginalArray("id, nodeweight", new QFilter[]{qFilter});
    }

    public DynamicObject[] queryAllNodeByProcId(Long procId) {
        String selectFields = "id, name, ismatrixnode, ismajornode, majornode, nodeweight, nodestatus, index,iscrossnode,flownodedef,flownodedef.nodetype.id,assessyear,assessperiod,flowruproc,activity,perforg,starttime,modifytime,updatestatustime,modifier,handlertype";
        QFilter filter = new QFilter("flowruproc", "=", (Object)procId);
        return this.query(selectFields, new QFilter[]{filter}, "index");
    }

    public DynamicObject[] queryPendingNodeByProcIds(Set<Long> procIds) {
        String selectFields = "id, name, ismatrixnode, ismajornode, majornode, nodeweight, nodestatus, index";
        QFilter filter = new QFilter("flowruproc", "in", procIds);
        filter.and("nodestatus", "=", (Object)FlowRuNodeStatusEnum.PENDING.getCode());
        return this.query(selectFields, new QFilter[]{filter});
    }

    public DynamicObject[] queryPendingNodeByIds(Set<Long> nodeIds) {
        String selectFields = "id, name, ismatrixnode, ismajornode, majornode, nodeweight, nodestatus, flowruproc, flownodedef, updatestatustime, modifier, modifytime";
        QFilter filter = new QFilter("id", "in", nodeIds);
        filter.and("nodestatus", "=", (Object)FlowRuNodeStatusEnum.PENDING.getCode());
        return this.query(selectFields, filter.toArray());
    }

    public DynamicObject[] queryAllNodeByProcIds(Long[] procIds) {
        String selectFields = "id, name, ismatrixnode, ismajornode,flowruproc.id, majornode, nodeweight, nodestatus, index,iscrossnode,flownodedef,flownodedef.id,flownodedef.nodetype,flowruproc.workflowtype";
        QFilter filter = new QFilter("flowruproc", "in", (Object)procIds);
        return this.query(selectFields, new QFilter[]{filter}, "index");
    }

    public DynamicObject[] queryOriginalAllNodeByProcIds(Long[] procIds) {
        String selectFields = "id, name, ismatrixnode, ismajornode,flowruproc.id, majornode, nodeweight, nodestatus, index,iscrossnode,flownodedef,flownodedef.id,flownodedef.nodetype,flowruproc.workflowtype";
        QFilter filter = new QFilter("flowruproc", "in", (Object)procIds);
        return this.queryOriginalArray(selectFields, new QFilter[]{filter}, "index");
    }

    public boolean deleteAllNodeByProcInstId(List<Long> procIds) {
        QFilter qFilter = new QFilter("flowruproc", "in", procIds);
        return this.deleteByFilter(new QFilter[]{qFilter}) > 0 ? Boolean.TRUE : Boolean.FALSE;
    }

    public Long queryDefNodeByTaskId(Long taskId) {
        DynamicObject taskDyn = FLOW_RU_TASK_ENTITY_SERVICE.queryTaskByPk(taskId);
        DynamicObject ruNodeDyn = this.queryRuNodeByPk(taskDyn.getLong("flowrunode.id"));
        Long nodeType = ruNodeDyn.getLong("flownodedef.nodetype.id");
        return nodeType;
    }

    public Map<Long, Long> queryDefNodeByTaskIds(List<Long> taskIds) {
        DynamicObject[] ruNodeDyns;
        HashMap<Long, Long> resultMap = new HashMap<Long, Long>(16);
        DynamicObject[] taskDyns = FLOW_RU_TASK_ENTITY_SERVICE.queryTaskByPks(taskIds);
        HashMap<Long, Long> taskRuNodeMap = new HashMap<Long, Long>(16);
        ArrayList<Long> ruNodeIds = new ArrayList<Long>(10);
        for (DynamicObject taskDyn : taskDyns) {
            taskRuNodeMap.put(taskDyn.getLong("flowrunode.id"), taskDyn.getLong("id"));
            ruNodeIds.add(taskDyn.getLong("flowrunode.id"));
        }
        for (DynamicObject ruNodeDyn : ruNodeDyns = this.queryByRuNodeIds(ruNodeIds)) {
            Long nodeType = ruNodeDyn.getLong("flownodedef.nodetype.id");
            Long ruNodeId = ruNodeDyn.getLong("id");
            resultMap.put((Long)taskRuNodeMap.get(ruNodeId), nodeType);
        }
        return resultMap;
    }

    public DynamicObject[] loadRuNodeByIds(List<Long> ruNodeIds) {
        QFilter qFilter = new QFilter("id", "in", ruNodeIds);
        return this.loadDynamicObjectArray(new QFilter[]{qFilter});
    }

    public DynamicObject[] queryRuNodeByIds(List<Long> ruNodeIds) {
        QFilter qFilter = new QFilter("id", "in", ruNodeIds);
        return this.query("id, nodestatus, flowruproc.id, updatestatustime, modifier, modifytime, index,iscrossnode", new QFilter[]{qFilter});
    }

    public DynamicObject[] loadRuNodeByProcIdsAndIndexs(List<Long> ruProcIds, List<Integer> nodeIndexs) {
        QFilter qFilter = new QFilter("flowruproc", "in", ruProcIds);
        qFilter.and("nodestatus", "!=", (Object)FlowRuNodeStatusEnum.NOT_ACTIVE.getCode());
        if (!nodeIndexs.isEmpty()) {
            qFilter.and("index", "in", nodeIndexs);
        }
        return this.loadDynamicObjectArray(new QFilter[]{qFilter});
    }

    public DynamicObject[] queryRuNodeByProcIdsAndIndexs(List<Long> ruProcIds, List<Integer> nodeIndexs) {
        QFilter qFilter = new QFilter("flowruproc", "in", ruProcIds);
        qFilter.and("nodestatus", "!=", (Object)FlowRuNodeStatusEnum.NOT_ACTIVE.getCode());
        if (!nodeIndexs.isEmpty()) {
            qFilter.and("index", "in", nodeIndexs);
        }
        return this.query("id, nodestatus, flowruproc.id, updatestatustime, modifier, modifytime, index,iscrossnode", new QFilter[]{qFilter});
    }

    public DynamicObject[] loadRuNodeByProcIds(List<Long> ruProcIds) {
        QFilter qFilter = new QFilter("flowruproc", "in", ruProcIds);
        qFilter.and("nodestatus", "!=", (Object)FlowRuNodeStatusEnum.NOT_ACTIVE.getCode());
        return this.loadDynamicObjectArray(new QFilter[]{qFilter});
    }

    public DynamicObject[] loadAllRuNodeByProcIds(List<Long> ruProcIds) {
        QFilter qFilter = new QFilter("flowruproc", "in", ruProcIds);
        return this.loadDynamicObjectArray(new QFilter[]{qFilter});
    }

    public DynamicObject[] queryRuNodeByProcIds(List<Long> ruProcIds) {
        QFilter qFilter = new QFilter("flowruproc", "in", ruProcIds);
        qFilter.and("nodestatus", "!=", (Object)FlowRuNodeStatusEnum.NOT_ACTIVE.getCode());
        return this.query("id, nodestatus, flowruproc.id, updatestatustime, modifier, modifytime, index,iscrossnode", new QFilter[]{qFilter});
    }

    public DynamicObject[] queryOriginalNodeByProcIds(List<Long> ruProcIds) {
        QFilter qFilter = new QFilter("flowruproc", "in", ruProcIds);
        qFilter.and("nodestatus", "!=", (Object)FlowRuNodeStatusEnum.NOT_ACTIVE.getCode());
        return this.queryOriginalArray("id, flowruproc.id, index,iscrossnode", new QFilter[]{qFilter});
    }

    public DynamicObject loadRuNodeByProcIdAndPreIndex(Long ruProcId, Integer nodeIndex) {
        QFilter qFilter = new QFilter("flowruproc", "in", (Object)ruProcId);
        qFilter.and("nodestatus", "!=", (Object)FlowRuNodeStatusEnum.NOT_ACTIVE.getCode());
        qFilter.and("index", "in", (Object)nodeIndex);
        return this.loadDynamicObject(new QFilter[]{qFilter});
    }

    public List<DynamicObject> batchGenerateRuNode(List<DynamicObject> ruProcList, Map<Long, DynamicObject> workflowMap) {
        ArrayList<DynamicObject> ruNodeList = new ArrayList<DynamicObject>(10);
        for (DynamicObject ruProc : ruProcList) {
            ruNodeList.addAll(this.generateRuNode(ruProc, workflowMap.get(ruProc.getLong("defproc")), Boolean.FALSE));
        }
        return ruNodeList;
    }
}

