/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.pbs.business.domain.workflow.entityservice;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.pbs.business.ServiceFactory;
import kd.opmc.pbs.business.domain.OpmcEntityService;
import kd.opmc.pbs.business.domain.workflow.entity.FlowRuProcBo;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuProcStatusEnum;
import kd.opmc.pbs.business.domain.workflow.enums.RefObjTypeEnum;
import kd.opmc.pbs.business.domain.workflow.service.FlowRuProcBatchDomainService;

public class FlowRuProcEntityService
extends OpmcEntityService {
    private static final HRBaseServiceHelper HELPER = new HRBaseServiceHelper("pbs_flowruproc");
    private static final String SELECTPROPERTIES = "id, ismatrixproc, procstatus, updatestatustime, modifier,person, modifytime,nodenum, currentnode,currentnode.index,remark, assessyear, assessperiod, activity, perforg,  creator, majorproc, actevalobj,workflowtype,settingmode,entryentity,entryentity.ruroleid,defproc.id,defproc.name,flowv";

    public static FlowRuProcEntityService getInstance() {
        return ServiceFactory.getService(FlowRuProcEntityService.class);
    }

    @Override
    protected HRBaseServiceHelper getServiceHelper() {
        return HELPER;
    }

    public DynamicObject queryRuProcByPk(Long pk) {
        return this.queryOne(SELECTPROPERTIES, pk);
    }

    public DynamicObject[] queryPersonByPkIds(List<Long> pkIds) {
        QFilter qFilter = new QFilter("id", "in", pkIds);
        return this.query("id, person", new QFilter[]{qFilter});
    }

    public DynamicObject[] queryProcByPkIds(List<Long> pkIds) {
        QFilter qFilter = new QFilter("id", "in", pkIds);
        return this.query(SELECTPROPERTIES, new QFilter[]{qFilter});
    }

    public DynamicObject queryProcStatus(Long ruProcId) {
        return this.queryOriginalOne("procstatus", ruProcId);
    }

    public DynamicObject[] queryProcByEvaObjIds(List<Long> actEvalObjIds) {
        QFilter qFilter = new QFilter("actevalobj", "in", actEvalObjIds);
        qFilter.and("procstatus", "!=", (Object)FlowRuProcStatusEnum.DEPRECATED.getCode());
        return this.loadDynamicObjectArray(new QFilter[]{qFilter});
    }

    public DynamicObject[] queryEvaluateProcByEvaObjIds(List<Long> actEvalObjIds) {
        QFilter qFilter = new QFilter("actevalobj", "in", actEvalObjIds);
        qFilter.and("workflowtype", "=", (Object)"2");
        qFilter.and("procstatus", "!=", (Object)FlowRuProcStatusEnum.DEPRECATED.getCode());
        qFilter.and("procstatus", "!=", (Object)FlowRuProcStatusEnum.NOTACTIVE.getCode());
        return this.loadDynamicObjectArray(new QFilter[]{qFilter});
    }

    public DynamicObject[] queryNoDeprecatedProcByEvaObjIds(List<Long> actEvalObjIds) {
        QFilter qFilter = new QFilter("actevalobj", "in", actEvalObjIds);
        qFilter.and("procstatus", "!=", (Object)FlowRuProcStatusEnum.DEPRECATED.getCode());
        return this.loadDynamicObjectArray(new QFilter[]{qFilter});
    }

    public DynamicObject[] queryProcByActObjIds(List<Long> actEvaObjIdList) {
        QFilter qFilter = new QFilter("actevalobj", "in", actEvaObjIdList);
        qFilter.and("procstatus", "!=", (Object)FlowRuProcStatusEnum.DEPRECATED.getCode());
        return this.queryOriginalArray("id,name,workflowtype,actevalobj", new QFilter[]{qFilter});
    }

    public DynamicObject[] queryRunProcByEvaObjIds(List<Long> actEvalObjIds) {
        QFilter qFilter = new QFilter("actevalobj", "in", actEvalObjIds);
        qFilter.and("procstatus", "in", Arrays.asList(FlowRuProcStatusEnum.RUNNING.getCode(), FlowRuProcStatusEnum.PENDING.getCode()));
        return this.loadDynamicObjectArray(new QFilter[]{qFilter});
    }

    public DynamicObject[] queryOriginalProcByEvaObjAndDefprocIdList(List<Long> actEvaObjIdList, List<Long> defprocIdList) {
        QFilter qFilter = new QFilter("actevalobj", "in", actEvaObjIdList);
        qFilter.and("procstatus", "!=", (Object)FlowRuProcStatusEnum.DEPRECATED.getCode());
        qFilter.and("defproc", "in", defprocIdList);
        return this.queryOriginalArray("id,actevalobj,defproc.id", new QFilter[]{qFilter});
    }

    public DynamicObject[] queryEvalProcByEvaObjIdsAndActId(List<Long> actEvalObjIds, Long activityId, String workFlowType) {
        QFilter qFilter = new QFilter("actevalobj", "in", actEvalObjIds);
        qFilter.and("activity", "=", (Object)activityId);
        qFilter.and("workflowtype", "=", (Object)workFlowType);
        qFilter.and("procstatus", "!=", (Object)FlowRuProcStatusEnum.DEPRECATED.getCode());
        return this.loadDynamicObjectArray(new QFilter[]{qFilter});
    }

    public DynamicObject[] queryProcByEvaObjIdAndDefprocId(Long actEvaObj, Long defprocId) {
        QFilter qFilter = new QFilter("actevalobj", "=", (Object)actEvaObj);
        qFilter.and("procstatus", "!=", (Object)FlowRuProcStatusEnum.DEPRECATED.getCode());
        qFilter.and("defproc", "=", (Object)defprocId);
        return this.loadDynamicObjectArray(new QFilter[]{qFilter});
    }

    public boolean deleteProcByPk(List<Long> pks) {
        QFilter qFilter = new QFilter("id", "in", pks);
        return this.deleteByFilter(new QFilter[]{qFilter}) > 0 ? Boolean.TRUE : Boolean.FALSE;
    }

    public DynamicObject generateRuProcess(FlowRuProcBo flowRuProcBo, DynamicObject flowDef, String name, boolean isSave) {
        DynamicObject ruProcess = this.generateEmptyDynamicObject();
        Date date = new Date();
        long userId = UserServiceHelper.getCurrentUserId();
        ruProcess.set("creator", (Object)userId);
        ruProcess.set("createtime", (Object)date);
        ruProcess.set("modifier", (Object)userId);
        ruProcess.set("modifytime", (Object)date);
        DynamicObject person = flowRuProcBo.getPerson();
        ruProcess.set("person", (Object)person);
        String procName = person.getString("name") + name;
        if (!HRStringUtils.isEmpty((String)procName) && procName.length() > 100) {
            procName = procName.substring(0, 100);
        }
        ruProcess.set("name", (Object)procName);
        ruProcess.set("ismatrixproc", flowDef.get("ismatrixproc"));
        ruProcess.set("ismajorproc", flowDef.get("ismajorproc"));
        ruProcess.set("workflowtype", flowDef.get("workflowtype"));
        ruProcess.set("refobjtype", (Object)(flowDef.getBoolean("ismatrixproc") ? RefObjTypeEnum.AREA.getCode() : RefObjTypeEnum.FORM.getCode()));
        ruProcess.set("defproc", flowDef.getPkValue());
        ruProcess.set("procstatus", (Object)FlowRuProcStatusEnum.NOTACTIVE.getCode());
        ruProcess.set("updatestatustime", (Object)date);
        ruProcess.set("flowv", (Object)flowRuProcBo.getFlowVid());
        ruProcess.set("perforg", (Object)flowRuProcBo.getPerfOrgId());
        ruProcess.set("adminorg", (Object)flowRuProcBo.getAdminOrgId());
        ruProcess.set("assessyear", (Object)flowRuProcBo.getAssessYear());
        ruProcess.set("assessperiod", (Object)flowRuProcBo.getAssessPeriod());
        ruProcess.set("nodenum", (Object)flowDef.getDynamicObjectCollection("nodeentry").size());
        ruProcess.set("index", flowDef.get("index"));
        ruProcess.set("actevalobj", (Object)flowRuProcBo.getActEvalObjId());
        ruProcess.set("activity", (Object)flowRuProcBo.getActivityId());
        ruProcess.set("empposrel", (Object)flowRuProcBo.getEmpPosRelId());
        ruProcess.set("number", (Object)CodeRuleServiceHelper.getNumber((String)"pbs_flowruproc", (DynamicObject)ruProcess, null));
        ruProcess.set("settingmode", (Object)flowRuProcBo.getSettingMode());
        ruProcess.set("updatestatustime", (Object)date);
        ruProcess.set("modifier", (Object)UserServiceHelper.getCurrentUserId());
        ruProcess.set("modifytime", (Object)date);
        if (isSave) {
            this.saveOne(ruProcess);
        }
        return ruProcess;
    }

    public DynamicObject[] queryPendingProcByIds(Set<Long> procIds) {
        QFilter filter = new QFilter("id", "in", procIds);
        filter.and("procstatus", "=", (Object)FlowRuProcStatusEnum.PENDING.getCode());
        String property = "id, procstatus, updatestatustime, modifier, modifytime";
        return this.query(property, filter.toArray());
    }

    public DynamicObject[] loadRuProcByIds(List<Long> ruProcIds) {
        QFilter qFilter = new QFilter("id", "in", ruProcIds);
        return this.loadDynamicObjectArray(new QFilter[]{qFilter});
    }

    public DynamicObject[] queryRuProcByIds(List<Long> ruProcIds) {
        QFilter qFilter = new QFilter("id", "in", ruProcIds);
        return this.query("id, procstatus, updatestatustime, modifier, modifytime, currentnode, assessyear,assessperiod, activity, perforg.id,entryentity.ruroleid,workflowtype,defproc.id,defproc.name", new QFilter[]{qFilter});
    }

    public DynamicObject[] loadRuProcByActEvalObjIds(List<Long> actEvalObjIds, String workflowType) {
        QFilter qFilter = new QFilter("actevalobj", "in", actEvalObjIds);
        qFilter.and("procstatus", "!=", (Object)FlowRuProcStatusEnum.DEPRECATED.getCode());
        if (HRStringUtils.isNotEmpty((String)workflowType)) {
            qFilter.and("workflowtype", "=", (Object)workflowType);
        }
        return this.loadDynamicObjectArray(new QFilter[]{qFilter});
    }

    public DynamicObject[] loadRuProcByActEvalObjIds(Long activityId, List<Long> actEvalObjIds, String workflowType) {
        QFilter qFilter = new QFilter("actevalobj", "in", actEvalObjIds);
        qFilter.and("activity", "=", (Object)activityId);
        qFilter.and("procstatus", "!=", (Object)FlowRuProcStatusEnum.DEPRECATED.getCode());
        if (HRStringUtils.isNotEmpty((String)workflowType)) {
            qFilter.and("workflowtype", "=", (Object)workflowType);
        }
        return this.loadDynamicObjectArray(new QFilter[]{qFilter});
    }

    public DynamicObject queryProcByActevaObjAndWorkflowType(Long actevaObjId, String workflowType) {
        QFilter qFilter = new QFilter("actevalobj", "=", (Object)actevaObjId).and("workflowtype", "=", (Object)workflowType);
        return this.queryOne(SELECTPROPERTIES, new QFilter[]{qFilter});
    }

    public List<DynamicObject> batchGenerateRuProcess(List<FlowRuProcBo> flowRuProcBoList) {
        ArrayList<DynamicObject> ruProcessList = new ArrayList<DynamicObject>(flowRuProcBoList.size());
        FlowRuProcBatchDomainService domainService = new FlowRuProcBatchDomainService();
        for (FlowRuProcBo flowRuProcBo : flowRuProcBoList) {
            DynamicObject workflow = domainService.getWorkflowMap(flowRuProcBo.getFlowVid()).getWorkflow();
            Long flowDefId = ((DynamicObject)workflow.getDynamicObjectCollection("entryentity").get(0)).getLong("flowdefproc");
            DynamicObject flowDef = domainService.getWorkflowMap(flowRuProcBo.getFlowVid()).getFlowDef();
            ruProcessList.add(this.generateRuProcess(flowRuProcBo, flowDef, workflow.getString("name"), Boolean.FALSE));
        }
        return ruProcessList;
    }

    public DynamicObject[] procsProgressingOrFinishByProdefActivity(Long activityId, Long procDefId) {
        QFilter qFilter = new QFilter("activity", "=", (Object)activityId).and("defproc.id", "=", (Object)procDefId).and("procstatus", "in", Arrays.asList(FlowRuProcStatusEnum.RUNNING.getCode(), FlowRuProcStatusEnum.PENDING.getCode(), FlowRuProcStatusEnum.STOP.getCode(), FlowRuProcStatusEnum.FINISHED.getCode()));
        return this.queryOriginalArray(SELECTPROPERTIES, new QFilter[]{qFilter});
    }
}

