/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.pbs.business.domain.workflow.entityservice;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.pbs.business.ServiceFactory;
import kd.opmc.pbs.business.domain.OpmcEntityService;
import kd.opmc.pbs.business.domain.workflow.entity.FlowRuProcBo;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuRoleStatusEnum;
import kd.opmc.pbs.common.constants.NodeTypeConstants;

public class FlowRuRoleEntityService
extends OpmcEntityService {
    private static final HRBaseServiceHelper HELPER = new HRBaseServiceHelper("pbs_flowrurole");
    private static final String SELECTPROPERTIES = "id, flowruproc, flowrunode, flowdefrole, roletype, rolestatus, updatestatustime, modifier, modifytime, assessyear, assessperiod, activity, perforg,turnoversort,issethandler,setno";

    public static FlowRuRoleEntityService getInstance() {
        return ServiceFactory.getService(FlowRuRoleEntityService.class);
    }

    @Override
    protected HRBaseServiceHelper getServiceHelper() {
        return HELPER;
    }

    public DynamicObject[] queryPendingRoleByNodeIds(List<Long> pendingNodeIds) {
        QFilter qFilter = new QFilter("flowrunode", "in", pendingNodeIds).and("rolestatus", "=", (Object)FlowRuRoleStatusEnum.PENDING.getCode());
        return this.query("id, flowruproc, flowrunode.handlertype, flowrunode.appointemp, flowdefrole, rolestatus, updatestatustime, modifier, modifytime, assessyear, assessperiod, activity, perforg", new QFilter[]{qFilter});
    }

    public DynamicObject[] queryPendingRoleByProcId(Long ruProcId) {
        QFilter qFilter = new QFilter("flowruproc", "=", (Object)ruProcId).and("rolestatus", "=", (Object)FlowRuRoleStatusEnum.PENDING.getCode());
        return this.query("flowrunode.handlertype, flowrunode.appointemp, flowdefrole", new QFilter[]{qFilter});
    }

    public DynamicObject[] queryPendingRoleByIds(List<Long> ids) {
        QFilter qFilter = new QFilter("id", "in", ids).and("rolestatus", "=", (Object)FlowRuRoleStatusEnum.PENDING.getCode());
        return this.query("id, flowruproc, flowrunode.handlertype, flowrunode.appointemp, flowrunode.flownodedef, flowdefrole, rolestatus, updatestatustime, modifier, modifytime, assessyear, assessperiod, activity, perforg", new QFilter[]{qFilter});
    }

    public DynamicObject queryRuRoleByPk(Long ruRoleId) {
        return this.queryOne("rolestatus, updatestatustime, modifier, modifytime, flowdefrole.outflow, flowdefrole.minnum,turnoversort,setno,iscrossrole", ruRoleId);
    }

    public DynamicObject[] queryConcurrentRuRole(Long ruNodeId, Long ruRoleId, int turnoversort) {
        QFilter qFilter = new QFilter("id", "!=", (Object)ruRoleId);
        qFilter.and("flowrunode", "=", (Object)ruNodeId).and("turnoversort", "=", (Object)turnoversort);
        return this.query("rolestatus, updatestatustime, modifier, modifytime, flowdefrole.outflow, flowdefrole.minnum,turnoversort", new QFilter[]{qFilter});
    }

    public DynamicObject[] queryCrossConcurrentRuRole(Long ruNodeId, Long ruRoleId, int turnoversort, String setNo) {
        QFilter qFilter = new QFilter("id", "!=", (Object)ruRoleId);
        qFilter.and("flowrunode", "=", (Object)ruNodeId).and("turnoversort", "=", (Object)turnoversort).and("setno", "=", (Object)setNo);
        return this.query("rolestatus, updatestatustime, modifier, modifytime, flowdefrole.outflow, flowdefrole.minnum,turnoversort", new QFilter[]{qFilter});
    }

    public DynamicObject[] queryByRuRoleIds(List<Long> roleRuIds) {
        QFilter qFilter = new QFilter("id", "in", roleRuIds);
        return this.query("id,rolestatus, updatestatustime,flowdefrole,flowrunode.id, modifier, modifytime, crossroleset.id, setno, turnoversort,roletype,iscrossrole", new QFilter[]{qFilter});
    }

    public DynamicObject[] queryByRuProcIds(List<Long> ruProcIds) {
        QFilter qFilter = new QFilter("flowruproc", "in", ruProcIds);
        return this.query("id,rolestatus, updatestatustime,flowdefrole.id,flowrunode.id, iscrossrole, issethandler, flowruproc.actevalobj, modifier, modifytime, crossroleset.id, setno", new QFilter[]{qFilter});
    }

    public int countUnhandRoleByNodeId(Long ruNodeId) {
        QFilter qFilter = new QFilter("flowrunode", "=", (Object)ruNodeId).and("rolestatus", "in", Arrays.asList(FlowRuRoleStatusEnum.BE_WAITTING.getCode(), FlowRuRoleStatusEnum.RUNNING.getCode(), FlowRuRoleStatusEnum.NOT_ACTIVE.getCode(), FlowRuRoleStatusEnum.RETURNED.getCode(), FlowRuRoleStatusEnum.PENDING.getCode()));
        return this.count("pbs_flowrurole", new QFilter[]{qFilter});
    }

    public DynamicObject[] queryRoleByNodeId(Long ruNodeId) {
        QFilter qFilter = new QFilter("flowrunode", "=", (Object)ruNodeId);
        return this.query("id, flowruproc, flowrunode, flowdefrole, roletype, rolestatus, updatestatustime, modifier, modifytime, assessyear, assessperiod, activity, perforg,turnoversort,name,ishandlerempty,crossroleset.id", new QFilter[]{qFilter}, "turnoversort asc");
    }

    public DynamicObject[] queryRolesByNodeIds(Long[] ruNodeIds) {
        QFilter qFilter = new QFilter("flowrunode", "in", (Object)ruNodeIds);
        return this.query("id, flowruproc, flowrunode, flowdefrole, roletype, rolestatus, updatestatustime, modifier, modifytime, assessyear, assessperiod, activity, perforg,turnoversort,ishandlerempty,setno,iscrossrole", new QFilter[]{qFilter}, "turnoversort asc");
    }

    public DynamicObject[] queryOriginalRolesByNodeIds(Long[] ruNodeIds) {
        QFilter qFilter = new QFilter("flowrunode", "in", (Object)ruNodeIds);
        return this.queryOriginalArray("id, flowruproc,flowrunode.id, flowrunode, flowdefrole, roletype, rolestatus, updatestatustime, modifier, modifytime, assessyear, assessperiod, activity, perforg,turnoversort,ishandlerempty,setno", new QFilter[]{qFilter}, "turnoversort asc");
    }

    public DynamicObject[] queryRoleByProcIdAndNodeId(Long ruProcId, Long ruNodeId) {
        QFilter qFilter = new QFilter("flowrunode", "=", (Object)ruNodeId);
        qFilter.and(new QFilter("flowruproc", "=", (Object)ruProcId));
        return this.query("id, flowruproc, flowrunode, flowdefrole, roletype, rolestatus, updatestatustime, modifier, modifytime, assessyear, assessperiod, activity, perforg", new QFilter[]{qFilter});
    }

    public DynamicObject[] queryRuRoleByCusFilter(QFilter qFilter) {
        return this.query("id, flowruproc, flowrunode, flowdefrole, roletype, rolestatus, updatestatustime, modifier, modifytime, assessyear, assessperiod, activity, perforg,turnoversort,name", new QFilter[]{qFilter}, "turnoversort asc");
    }

    public DynamicObject[] queryNeedActiveRunRoleByNodeId(Long ruNodeId) {
        QFilter qFilter = new QFilter("flowrunode", "=", (Object)ruNodeId);
        qFilter.and(new QFilter("rolestatus", "in", Arrays.asList(FlowRuRoleStatusEnum.NOT_ACTIVE.getCode(), FlowRuRoleStatusEnum.RETURNED.getCode(), FlowRuRoleStatusEnum.BE_WAITTING.getCode(), FlowRuRoleStatusEnum.PENDING.getCode())));
        DynamicObject[] runRoleDynArr = this.query(SELECTPROPERTIES, new QFilter[]{qFilter}, "turnoversort asc");
        ArrayList<DynamicObject> tobeActiveRoleList = new ArrayList<DynamicObject>(10);
        if (runRoleDynArr.length > 0) {
            int turnoversort = runRoleDynArr[0].getInt("turnoversort");
            for (DynamicObject runRoleDyn : runRoleDynArr) {
                if (turnoversort != runRoleDyn.getInt("turnoversort")) continue;
                tobeActiveRoleList.add(runRoleDyn);
            }
        }
        return (DynamicObject[])tobeActiveRoleList.stream().toArray(DynamicObject[]::new);
    }

    public DynamicObject[] queryCrossNodeNeedActiveRunRoleByNodeId(Long ruNodeId) {
        QFilter qFilter = new QFilter("flowrunode", "=", (Object)ruNodeId);
        qFilter.and(new QFilter("rolestatus", "in", Arrays.asList(FlowRuRoleStatusEnum.NOT_ACTIVE.getCode(), FlowRuRoleStatusEnum.RETURNED.getCode(), FlowRuRoleStatusEnum.BE_WAITTING.getCode())));
        DynamicObject[] runRoleDynArr = this.query(SELECTPROPERTIES, new QFilter[]{qFilter}, "turnoversort asc");
        HashMap ruRoleMap = new HashMap(16);
        for (DynamicObject ruRole : runRoleDynArr) {
            List<DynamicObject> ruRoleList;
            if (null != ruRoleMap.get(ruRole.getString("setno"))) {
                ruRoleList = (List)ruRoleMap.get(ruRole.getString("setno"));
                ruRoleList.add(ruRole);
                continue;
            }
            ruRoleList = new ArrayList<DynamicObject>(10);
            ruRoleList.add(ruRole);
            ruRoleMap.put(ruRole.getString("setno"), ruRoleList);
        }
        ArrayList<DynamicObject> tobeActiveRoleList = new ArrayList<DynamicObject>(10);
        for (Map.Entry entry : ruRoleMap.entrySet()) {
            List sameSetNoRoleList = (List)entry.getValue();
            int turnOverSort = ((DynamicObject)sameSetNoRoleList.get(0)).getInt("turnoversort");
            for (DynamicObject role : sameSetNoRoleList) {
                if (role.getInt("turnoversort") != turnOverSort) continue;
                tobeActiveRoleList.add(role);
            }
        }
        return (DynamicObject[])tobeActiveRoleList.stream().toArray(DynamicObject[]::new);
    }

    public DynamicObject[] queryNextNeedActiveRunRole(Long ruNodeId, int turnoversort, String setNo) {
        QFilter qFilter = new QFilter("flowrunode", "=", (Object)ruNodeId);
        qFilter.and(new QFilter("rolestatus", "in", Arrays.asList(FlowRuRoleStatusEnum.NOT_ACTIVE.getCode(), FlowRuRoleStatusEnum.RETURNED.getCode(), FlowRuRoleStatusEnum.BE_WAITTING.getCode(), FlowRuRoleStatusEnum.PENDING.getCode())));
        qFilter.and("turnoversort", ">", (Object)turnoversort);
        if (!HRStringUtils.isEmpty((String)setNo)) {
            qFilter.and("setno", "=", (Object)setNo);
        }
        DynamicObject[] runRoleDynArr = this.query("id, flowruproc, flowrunode, flowdefrole, roletype, rolestatus, updatestatustime, modifier, modifytime, assessyear, assessperiod, activity, perforg,turnoversort,issethandler", new QFilter[]{qFilter}, "turnoversort asc");
        ArrayList<DynamicObject> tobeActiveRoleList = new ArrayList<DynamicObject>(10);
        if (runRoleDynArr.length > 0) {
            int sort = runRoleDynArr[0].getInt("turnoversort");
            for (DynamicObject runRoleDyn : runRoleDynArr) {
                if (sort != runRoleDyn.getInt("turnoversort")) continue;
                tobeActiveRoleList.add(runRoleDyn);
            }
        }
        return (DynamicObject[])tobeActiveRoleList.stream().toArray(DynamicObject[]::new);
    }

    public DynamicObject[] queryNotActiveRunRole(Long ruNodeId, int turnoversort, String setNo) {
        QFilter qFilter = new QFilter("flowrunode", "=", (Object)ruNodeId);
        qFilter.and(new QFilter("rolestatus", "in", Arrays.asList(FlowRuRoleStatusEnum.NOT_ACTIVE.getCode(), FlowRuRoleStatusEnum.PENDING.getCode(), FlowRuRoleStatusEnum.RUNNING.getCode())));
        qFilter.and("turnoversort", "=", (Object)turnoversort);
        if (!HRStringUtils.isEmpty((String)setNo)) {
            qFilter.and("setno", "=", (Object)setNo);
        }
        DynamicObject[] runRoleDynArr = this.query("id, flowruproc, flowrunode, flowdefrole, roletype, rolestatus, updatestatustime, modifier, modifytime, assessyear, assessperiod, activity, perforg,turnoversort,issethandler", new QFilter[]{qFilter}, "turnoversort asc");
        ArrayList<DynamicObject> tobeActiveRoleList = new ArrayList<DynamicObject>(10);
        if (runRoleDynArr.length > 0) {
            int sort = runRoleDynArr[0].getInt("turnoversort");
            for (DynamicObject runRoleDyn : runRoleDynArr) {
                if (sort != runRoleDyn.getInt("turnoversort")) continue;
                tobeActiveRoleList.add(runRoleDyn);
            }
        }
        return tobeActiveRoleList.toArray(new DynamicObject[0]);
    }

    public List<DynamicObject> generateRuRole(List<DynamicObject> ruNodeList, DynamicObject flowDef, boolean isPreInstance, FlowRuProcBo flowRuProcBo, boolean isSave) {
        DynamicObjectCollection nodeDefList = flowDef.getDynamicObjectCollection("nodeentry");
        ArrayList<DynamicObject> ruRoleList = new ArrayList<DynamicObject>(ruNodeList.size());
        Date date = new Date();
        long userId = UserServiceHelper.getCurrentUserId();
        for (int i = 0; i < ruNodeList.size(); ++i) {
            DynamicObject ruNode = ruNodeList.get(i);
            DynamicObject nodeDef = (DynamicObject)nodeDefList.get(i);
            if (nodeDef.getBoolean("crossscore")) continue;
            DynamicObjectCollection roleDefList = nodeDef.getDynamicObjectCollection("roleentry");
            for (DynamicObject roleDef : roleDefList) {
                DynamicObject ruRole = this.generateEmptyDynamicObject();
                ruRole.set("creator", (Object)userId);
                ruRole.set("createtime", (Object)date);
                ruRole.set("modifier", (Object)userId);
                ruRole.set("modifytime", (Object)date);
                ruRole.set("flowrunode", (Object)ruNode);
                ruRole.set("rolestatus", (Object)FlowRuRoleStatusEnum.NOT_ACTIVE.getCode());
                ruRole.set("assessyear", ruNode.get("assessyear"));
                ruRole.set("assessperiod", ruNode.get("assessperiod"));
                ruRole.set("flowruproc", ruNode.get("flowruproc"));
                if (NodeTypeConstants.EVALUATE_AUDIT.equals(nodeDef.getLong("nodetype.id")) || NodeTypeConstants.INDICATOR_AUDIT.equals(nodeDef.getLong("nodetype.id"))) {
                    ruRole.set("roleweight", (Object)0);
                } else {
                    ruRole.set("roleweight", roleDef.get("roleweight"));
                }
                ruRole.set("roletype", roleDef.get("roletype"));
                ruRole.set("updatestatustime", (Object)date);
                ruRole.set("activity", ruNode.get("activity"));
                ruRole.set("perforg", ruNode.get("perforg"));
                ruRole.set("flowdefrole", (Object)roleDef);
                if (isPreInstance && flowRuProcBo.getSettingMode().equals("20")) {
                    ruRole.set("issethandler", (Object)1);
                }
                ruRole.set("turnoversort", roleDef.get("turnoversort"));
                ruRole.set("name", roleDef.get("rolename"));
                ruRole.set("iscrossrole", nodeDef.get("crossscore"));
                ruRole.set("id", (Object)ORM.create().genLongId("pbs_flowrurole"));
                ruRole.set("updatestatustime", (Object)date);
                ruRole.set("modifier", (Object)UserServiceHelper.getCurrentUserId());
                ruRole.set("modifytime", (Object)date);
                ruRoleList.add(ruRole);
            }
        }
        if (isSave) {
            this.save(ruRoleList.toArray(new DynamicObject[0]));
        }
        return ruRoleList;
    }

    public DynamicObject[] queryRoleWeightByNodeId(Long ruNodeId) {
        QFilter qFilter = new QFilter("flowrunode", "=", (Object)ruNodeId).and("rolestatus", "=", (Object)FlowRuRoleStatusEnum.FINISHED.getCode());
        return this.query("id, roleweight", new QFilter[]{qFilter});
    }

    public DynamicObject[] queryAllRoleByProcId(Long procId) {
        String selectFields = "id, flowrunode, roleweight, roletype";
        QFilter filter = new QFilter("flowruproc", "=", (Object)procId);
        return this.query(selectFields, new QFilter[]{filter}, "roletype");
    }

    public DynamicObject queryRoleByProp(Long ruNodeId, String prop) {
        QFilter qFilter = new QFilter("flowrunode", "=", (Object)ruNodeId).and("flowdefrole.confjson", "like", (Object)String.format("%%\"%s\":true%%", prop));
        return this.queryOriginalOne("id", qFilter);
    }

    public DynamicObject queryGradeRole(Long ruProcId) {
        QFilter qFilter = new QFilter("flowruproc", "=", (Object)ruProcId).and("flowdefrole.confjson", "like", (Object)"%%\"isgradelevel\":true%%");
        return this.queryOriginalOne("id", qFilter);
    }

    public void setRoleIsSetHander(DynamicObject[] roles) {
        Date date = new Date();
        long userId = UserServiceHelper.getCurrentUserId();
        for (DynamicObject role : roles) {
            role.set("updatestatustime", (Object)date);
            role.set("issethandler", (Object)true);
            role.set("modifier", (Object)userId);
            role.set("modifytime", (Object)date);
        }
    }

    public DynamicObject[] queryByPkValue(List<Long> roleRuIds) {
        QFilter qFilter = new QFilter("id", "in", roleRuIds);
        return this.query("id, flowruproc.actevalobj, flowruproc.person, rolestatus, flowdefrole, turnoversort", new QFilter[]{qFilter});
    }

    public DynamicObject[] queryLessThanRoleSortRoles(Long flowRuRoleId) {
        if (flowRuRoleId == null) {
            return null;
        }
        DynamicObject ruNodeDynamicObj = this.queryOne(flowRuRoleId);
        if (ruNodeDynamicObj == null) {
            return null;
        }
        long flowRuNodeId = ruNodeDynamicObj.getLong("flowrunode.id");
        int turNoverSort = ruNodeDynamicObj.getInt("turnoversort");
        QFilter filter = new QFilter("turnoversort", "<", (Object)turNoverSort);
        QFilter nodeFilter = new QFilter("flowrunode", "=", (Object)flowRuNodeId);
        filter.and(nodeFilter);
        DynamicObject[] dynamicObjects = this.query("id,turnoversort,flowdefrole.id,iscrossrole", new QFilter[]{filter}, "turnoversort desc");
        return dynamicObjects;
    }

    public boolean isFirstRole(Long flowRuRoleId) {
        if (flowRuRoleId == null) {
            return true;
        }
        DynamicObject flowRuRoleDy = this.queryOriginalOne("iscrossrole,setno,flowrunode.id,turnoversort", flowRuRoleId);
        if (flowRuRoleDy == null) {
            return true;
        }
        boolean isCrossRole = flowRuRoleDy.getBoolean("iscrossrole");
        int turnOverSort = flowRuRoleDy.getInt("turnoversort");
        long flowRuNodeId = flowRuRoleDy.getLong("flowrunode.id");
        if (isCrossRole) {
            QFilter filter = new QFilter("turnoversort", "<", (Object)turnOverSort);
            QFilter nodeFilter = new QFilter("flowrunode", "=", (Object)flowRuNodeId);
            filter.and(nodeFilter);
            filter.and(new QFilter("setno", "=", (Object)flowRuRoleDy.getString("setno")));
            boolean exists = this.isExists(filter);
            return !exists;
        }
        QFilter filter = new QFilter("turnoversort", "<", (Object)turnOverSort);
        QFilter nodeFilter = new QFilter("flowrunode", "=", (Object)flowRuNodeId);
        filter.and(nodeFilter);
        boolean exists = this.isExists(filter);
        return !exists;
    }

    public DynamicObject[] queryLessThanNotCrossRoleSortRoles(Long flowRuRoleId) {
        if (flowRuRoleId == null) {
            return null;
        }
        DynamicObject ruNodeDynamicObj = this.queryOne(flowRuRoleId);
        if (ruNodeDynamicObj == null) {
            return null;
        }
        long flowRuNodeId = ruNodeDynamicObj.getLong("flowrunode.id");
        int turNoverSort = ruNodeDynamicObj.getInt("turnoversort");
        QFilter filter = new QFilter("turnoversort", "<", (Object)turNoverSort);
        QFilter nodeFilter = new QFilter("flowrunode", "=", (Object)flowRuNodeId);
        QFilter noCrossRoleFilter = new QFilter("iscrossrole", "!=", (Object)"1");
        filter.and(nodeFilter);
        filter.and(noCrossRoleFilter);
        DynamicObject[] dynamicObjects = this.query("id,turnoversort,flowdefrole.id,iscrossrole", new QFilter[]{filter}, "turnoversort desc");
        return dynamicObjects;
    }

    public boolean deleteAllRoleByProcInstId(List<Long> procIds) {
        QFilter qFilter = new QFilter("flowruproc", "in", procIds);
        return this.deleteByFilter(new QFilter[]{qFilter}) > 0 ? Boolean.TRUE : Boolean.FALSE;
    }

    public DynamicObject[] loadRuRoleByIds(List<Long> ruRoleIds) {
        QFilter qFilter = new QFilter("id", "in", ruRoleIds);
        return this.loadDynamicObjectArray(new QFilter[]{qFilter});
    }

    public DynamicObject[] loadRuRoleByNodeIds(List<Long> ruNodeIds) {
        QFilter qFilter = new QFilter("flowrunode", "in", ruNodeIds);
        qFilter.and("rolestatus", "not in", Arrays.asList(FlowRuRoleStatusEnum.NOT_ACTIVE.getCode(), FlowRuRoleStatusEnum.RETURNED.getCode()));
        return this.loadDynamicObjectArray(new QFilter[]{qFilter});
    }

    public DynamicObject[] queryRuRolesByNodeIds(List<Long> ruNodeIds) {
        QFilter qFilter = new QFilter("flowrunode", "in", ruNodeIds);
        qFilter.and("rolestatus", "!=", (Object)FlowRuRoleStatusEnum.NOT_ACTIVE.getCode());
        return this.query("id, flowrunode.id, rolestatus, updatestatustime, modifier,modifytime,turnoversort,setno", new QFilter[]{qFilter});
    }

    public DynamicObject[] queryRuRoleByNodeIds(List<Long> ruNodeIds) {
        QFilter qFilter = new QFilter("flowrunode", "in", ruNodeIds);
        qFilter.and("rolestatus", "not in", Arrays.asList(FlowRuRoleStatusEnum.NOT_ACTIVE.getCode(), FlowRuRoleStatusEnum.RETURNED.getCode()));
        return this.query("id, flowrunode.id, rolestatus, updatestatustime, modifier,modifytime,turnoversort,setno", new QFilter[]{qFilter});
    }

    public DynamicObject[] queryOriginalRuRoleByNodeIds(List<Long> ruNodeIds) {
        QFilter qFilter = new QFilter("flowrunode", "in", ruNodeIds);
        qFilter.and("rolestatus", "not in", Arrays.asList(FlowRuRoleStatusEnum.NOT_ACTIVE.getCode(), FlowRuRoleStatusEnum.RETURNED.getCode()));
        return this.queryOriginalArray("id, flowrunode.id,flowdefrole.confjson, updatestatustime,modifytime,turnoversort,setno", new QFilter[]{qFilter});
    }

    public DynamicObject[] loadRoleByNodeIds(List<Long> ruNodeIds) {
        QFilter qFilter = new QFilter("flowrunode", "in", ruNodeIds);
        qFilter.and("rolestatus", "!=", (Object)FlowRuRoleStatusEnum.NOT_ACTIVE.getCode());
        return this.loadDynamicObjectArray(new QFilter[]{qFilter});
    }

    public List<DynamicObject> batchGenerateRuRole(List<DynamicObject> ruNodeList, Map<Long, DynamicObject> workflowMap, Map<Long, FlowRuProcBo> flowRuProcBoMap, Boolean isPreInstance) {
        ArrayList<DynamicObject> ruRoleList = new ArrayList<DynamicObject>(10);
        Map ruNodeListMap = ruNodeList.stream().sorted(Comparator.comparing(rn -> rn.getInt("index"))).collect(Collectors.groupingBy(dy -> dy.getLong("flowruproc.id"), Collectors.mapping(dy -> dy, Collectors.toList())));
        for (Map.Entry entry : ruNodeListMap.entrySet()) {
            DynamicObject ruProc = ((DynamicObject)entry.getValue().get(0)).getDynamicObject("flowruproc");
            DynamicObject flowDef = workflowMap.get(ruProc.getLong("defproc"));
            FlowRuProcBo flowRuProcBo = flowRuProcBoMap.get(ruProc.getLong("actevalobj"));
            ruRoleList.addAll(this.generateRuRole(entry.getValue(), flowDef, isPreInstance, flowRuProcBo, Boolean.FALSE));
        }
        return ruRoleList;
    }

    public List<Long> queryByRuNodeIndexAndRuProc(Object seq, List<Long> flowRuProcIdList) {
        QFilter qFilter = new QFilter("flowrunode.index", "=", seq).and("flowruproc.id", "in", flowRuProcIdList);
        DynamicObject[] dynamicObjects = this.query("id", new QFilter[]{qFilter});
        return Arrays.stream(dynamicObjects).map(evalObjDy -> evalObjDy.getLong("id")).collect(Collectors.toList());
    }
}

