/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.pbs.business.domain.workflow.entityservice;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.extplugin.PluginFilter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.opmc.pbs.business.ServiceFactory;
import kd.opmc.pbs.business.domain.OpmcEntityService;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowDefNodeEntityService;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowRuNodeEntityService;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowRuTaskProcLogEntityService;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuNodeStatusEnum;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuRoleStatusEnum;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuTaskStatusEnum;
import kd.opmc.pbs.business.domain.workflow.outService.IWorkFlowTaskOutService;
import kd.opmc.pbs.common.constants.NodeTypeConstants;

public class FlowRuTaskEntityService
extends OpmcEntityService {
    private static final Log log = LogFactory.getLog(FlowRuTaskEntityService.class);
    private static final HRBaseServiceHelper HELPER = new HRBaseServiceHelper("pbs_flowrutask");
    private static final FlowDefNodeEntityService FLOW_NODEDEF_NODE_ENTITYSERVICE = FlowDefNodeEntityService.getInstance();
    private static final IWorkFlowTaskOutService I_WORK_FLOW_TASK_OUT_SERVICE = IWorkFlowTaskOutService.getInstance();
    private static final String TASK_UPDATE_FIELDS = "id,taskstatus, updatestatustime, modifier, modifytime, handler,handler.enable,handler.isactived, flowruproc.procstatus, flowruproc.actevalobj, flowruproc.person,flowruproc.workflowtype, flowrunode,flownodedef, flowrurole.flowdefrole, assessyear, assessperiod, activity, perforg,isreplace, iscrossevaluate, entryentity,flowruproc,flowrunode.index,flowrurole.id,flowrurole.turnoversort,isrollbacked,iscotask,iscohandlerdeal,hosttask.id";
    private static final FlowRuTaskProcLogEntityService FLOW_RU_TASK_PROC_LOG_ENTITY_SERVICE = FlowRuTaskProcLogEntityService.getInstance();

    public static FlowRuTaskEntityService getInstance() {
        return ServiceFactory.getService(FlowRuTaskEntityService.class);
    }

    @Override
    protected HRBaseServiceHelper getServiceHelper() {
        return HELPER;
    }

    public DynamicObject queryTaskByPk(Long pk) {
        return this.queryOne(TASK_UPDATE_FIELDS, pk);
    }

    public DynamicObject[] queryTaskByPks(List<Long> pks) {
        if (pks == null) {
            pks = new ArrayList<Long>(10);
        }
        QFilter filter = new QFilter("id", "in", pks);
        return this.query(TASK_UPDATE_FIELDS, new QFilter[]{filter});
    }

    public DynamicObject queryOriginalTaskByPk(Long pk) {
        return this.queryOriginalOne("flowrunode,flowrurole, flowrunode.index, flowruproc,flowruproc.defproc", pk);
    }

    public DynamicObject[] queryTasksByProcId(Long ruProcId) {
        QFilter qFilter = new QFilter("flowruproc", "=", (Object)ruProcId).and("taskstatus", "in", Arrays.asList("20", "30"));
        return this.query(TASK_UPDATE_FIELDS, new QFilter[]{qFilter});
    }

    public DynamicObject[] queryWaittingTasksByProcId(Long ruProcId) {
        QFilter qFilter = new QFilter("flowruproc", "=", (Object)ruProcId).and("taskstatus", "=", (Object)FlowRuTaskStatusEnum.WAITING.getCode());
        return this.query(TASK_UPDATE_FIELDS, new QFilter[]{qFilter});
    }

    public DynamicObject[] queryWaittingTasksByProcIds(Set<Long> ruProcIds) {
        QFilter qFilter = new QFilter("flowruproc", "in", ruProcIds).and("taskstatus", "=", (Object)FlowRuTaskStatusEnum.WAITING.getCode());
        return this.query(TASK_UPDATE_FIELDS, new QFilter[]{qFilter});
    }

    public DynamicObject[] queryAllTasksByProcId(Long ruProcId) {
        QFilter qFilter = new QFilter("flowruproc", "=", (Object)ruProcId);
        return this.query("id, taskstatus, updatestatustime, flowrurole, handler,batchno", new QFilter[]{qFilter});
    }

    public DynamicObject[] queryTasksByBatchNo(String batchNo) {
        String selectFields = "id, taskstatus, flowruproc.id, flowruproc.workflowtype, flowrunode.id,flowrunode.index,flowrunode.name,flowrurole.id,handler.id,updatestatustime,modifier,createtime,modifytime";
        QFilter qFilter = new QFilter("batchno", "=", (Object)batchNo).and("taskstatus", "in", Arrays.asList("20", "30"));
        qFilter.and("iscotask", "!=", (Object)"1");
        return this.query(selectFields, new QFilter[]{qFilter});
    }

    public DynamicObject[] queryTaskHandlersByNodeIds(List<Long> ruNodeIds) {
        QFilter qFilter = new QFilter("flowrunode", "in", ruNodeIds).and("taskstatus", "in", Arrays.asList("20", "30"));
        return this.query("flowruproc, handler", new QFilter[]{qFilter});
    }

    public DynamicObject queryLastTaskByNodeId(Long ruNodeId) {
        QFilter qFilter = new QFilter("flowrunode", "=", (Object)ruNodeId).and("taskstatus", "=", (Object)FlowRuTaskStatusEnum.PROCESSED.getCode());
        return this.queryOriginalOne("id", new QFilter[]{qFilter}, "updatestatustime desc");
    }

    public DynamicObject[] querySpecifyTaskByRoleIds(List<Long> ruRoleIds) {
        QFilter qFilter = new QFilter("flowrurole", "in", ruRoleIds);
        qFilter.and("iscotask", "=", (Object)Boolean.FALSE);
        return this.query(TASK_UPDATE_FIELDS, new QFilter[]{qFilter});
    }

    public DynamicObject[] queryOriginalSpecifyTaskByRoleIds(List<Long> ruRoleIds) {
        QFilter qFilter = new QFilter("flowrurole", "in", ruRoleIds);
        return this.queryOriginalArray("id,taskstatus,flowrurole.id", new QFilter[]{qFilter});
    }

    public DynamicObject queryLastTaskByRoleId(Long ruRoleId) {
        QFilter qFilter = new QFilter("flowrurole", "=", (Object)ruRoleId).and("taskstatus", "=", (Object)FlowRuTaskStatusEnum.PROCESSED.getCode());
        return this.queryOriginalOne("id", new QFilter[]{qFilter}, "updatestatustime desc");
    }

    public DynamicObject[] queryLastTaskByRoleIds(List<Long> ruRoleIds) {
        QFilter qFilter = new QFilter("flowrurole", "in", ruRoleIds).and("taskstatus", "=", (Object)FlowRuTaskStatusEnum.PROCESSED.getCode());
        return this.queryOriginalArray("id", new QFilter[]{qFilter}, "updatestatustime desc");
    }

    public DynamicObject[] queryTaskByRoleId(Long ruRoleId) {
        QFilter qFilter = new QFilter("flowrurole", "=", (Object)ruRoleId).and("taskstatus", "=", (Object)FlowRuTaskStatusEnum.PROCESSED.getCode());
        return this.queryOriginalArray("id", new QFilter[]{qFilter});
    }

    public DynamicObject[] queryValidTaskByRoleId(Long ruRoleId) {
        QFilter qFilter = new QFilter("flowrurole", "=", (Object)ruRoleId).and("taskstatus", "in", Arrays.asList(FlowRuTaskStatusEnum.WAITING.getCode(), FlowRuTaskStatusEnum.PROCESSING.getCode(), FlowRuTaskStatusEnum.PROCESSED.getCode(), FlowRuTaskStatusEnum.BE_WAITTING.getCode(), FlowRuTaskStatusEnum.RETURNED.getCode(), FlowRuTaskStatusEnum.PENDING.getCode()));
        return this.query(TASK_UPDATE_FIELDS, new QFilter[]{qFilter});
    }

    public int countValidTaskByRoleId(Long ruRoleId) {
        QFilter qFilter = new QFilter("flowrurole", "=", (Object)ruRoleId).and("taskstatus", "in", Arrays.asList(FlowRuTaskStatusEnum.WAITING.getCode(), FlowRuTaskStatusEnum.PROCESSING.getCode(), FlowRuTaskStatusEnum.PROCESSED.getCode(), FlowRuTaskStatusEnum.RETURNED.getCode()));
        return this.count("pbs_flowrutask", new QFilter[]{qFilter});
    }

    public DynamicObject[] queryUnhandTaskByRoleId(Long ruRoleId) {
        QFilter qFilter = new QFilter("flowrurole", "=", (Object)ruRoleId).and("taskstatus", "in", Arrays.asList("20", "30"));
        return this.query(TASK_UPDATE_FIELDS, new QFilter[]{qFilter});
    }

    public int countUnhandTaskByRoleId(Long ruRoleId) {
        QFilter qFilter = new QFilter("flowrurole", "=", (Object)ruRoleId).and("taskstatus", "in", Arrays.asList(FlowRuTaskStatusEnum.WAITING.getCode(), FlowRuTaskStatusEnum.PROCESSING.getCode(), FlowRuTaskStatusEnum.BE_WAITTING.getCode(), FlowRuTaskStatusEnum.NOT_ACTIVE.getCode()));
        return this.count("pbs_flowrutask", new QFilter[]{qFilter});
    }

    public List<DynamicObject> generateTaskByRuRole(DynamicObject ruNode, DynamicObject ruRole, List<Long> handlerIds, boolean isReplace) {
        List<DynamicObject> tasks = this.generateTaskByRuRole(ruRole, handlerIds, isReplace);
        for (DynamicObject task : tasks) {
            if (UserServiceHelper.isUserEnable((long)task.getLong("handler"))) continue;
            task.set("taskstatus", (Object)FlowRuTaskStatusEnum.PENDING.getCode());
        }
        return tasks;
    }

    public void setTaskModifyStatus(DynamicObject[] tasks) {
        Date date = new Date();
        long userId = UserServiceHelper.getCurrentUserId();
        for (DynamicObject task : tasks) {
            task.set("updatestatustime", (Object)date);
            task.set("modifier", (Object)userId);
            task.set("modifytime", (Object)date);
        }
    }

    public List<DynamicObject> generateTaskByRuRole(DynamicObject ruRole, List<Long> handlerIds, boolean isReplace) {
        ArrayList<DynamicObject> tasks = new ArrayList<DynamicObject>(handlerIds.size());
        Date date = new Date();
        long userId = UserServiceHelper.getCurrentUserId();
        for (Long handlerId : handlerIds) {
            DynamicObject task = this.generateEmptyDynamicObject();
            task.set("creator", (Object)userId);
            task.set("createtime", (Object)date);
            task.set("modifier", (Object)userId);
            task.set("modifytime", (Object)date);
            task.set("updatestatustime", (Object)date);
            task.set("flowruproc", ruRole.get("flowruproc"));
            task.set("flowrunode", ruRole.get("flowrunode"));
            task.set("flowrurole", (Object)ruRole);
            task.set("handler", (Object)handlerId);
            task.set("assessyear", ruRole.get("assessyear"));
            task.set("assessperiod", ruRole.get("assessperiod"));
            task.set("activity", ruRole.get("activity"));
            task.set("perforg", ruRole.get("perforg"));
            task.set("isreplace", (Object)isReplace);
            task.set("taskstatus", (Object)FlowRuTaskStatusEnum.NOT_ACTIVE.getCode());
            tasks.add(task);
        }
        return tasks;
    }

    public List<DynamicObject> generateCrossTaskByRuRole(DynamicObject ruRole, List<Long> handlerIds, boolean isReplace) {
        ArrayList<DynamicObject> tasks = new ArrayList<DynamicObject>(handlerIds.size());
        Date date = new Date();
        long userId = UserServiceHelper.getCurrentUserId();
        for (Long handlerId : handlerIds) {
            DynamicObject task = this.generateEmptyDynamicObject();
            task.set("creator", (Object)userId);
            task.set("createtime", (Object)date);
            task.set("modifier", (Object)userId);
            task.set("modifytime", (Object)date);
            task.set("updatestatustime", (Object)date);
            task.set("flowruproc", ruRole.get("flowruproc"));
            task.set("flowrunode", ruRole.get("flowrunode"));
            task.set("flowrurole", (Object)ruRole);
            task.set("handler", (Object)handlerId);
            task.set("assessyear", ruRole.get("assessyear"));
            task.set("assessperiod", ruRole.get("assessperiod"));
            task.set("activity", ruRole.get("activity"));
            task.set("perforg", ruRole.get("perforg"));
            task.set("isreplace", (Object)isReplace);
            task.set("iscrossevaluate", (Object)Boolean.TRUE);
            task.set("taskstatus", (Object)FlowRuTaskStatusEnum.NOT_ACTIVE.getCode());
            tasks.add(task);
        }
        return tasks;
    }

    public DynamicObject generateTaskByOldTask(DynamicObject oldTask, Date date, long userId, Long newHandlerId) {
        DynamicObject newTask = this.generateEmptyDynamicObject();
        newTask.set("creator", (Object)userId);
        newTask.set("createtime", (Object)date);
        newTask.set("modifier", (Object)userId);
        newTask.set("modifytime", (Object)date);
        newTask.set("taskstatus", (Object)FlowRuTaskStatusEnum.WAITING.getCode());
        newTask.set("updatestatustime", (Object)date);
        newTask.set("flowruproc", oldTask.get("flowruproc"));
        newTask.set("flowrunode", oldTask.get("flowrunode"));
        newTask.set("flowrurole", oldTask.get("flowrurole"));
        newTask.set("handler", (Object)newHandlerId);
        newTask.set("assessyear", oldTask.get("assessyear"));
        newTask.set("assessperiod", oldTask.get("assessperiod"));
        newTask.set("activity", oldTask.get("activity"));
        newTask.set("perforg", oldTask.get("perforg"));
        newTask.set("isreplace", (Object)Boolean.FALSE);
        return newTask;
    }

    public DynamicObject[] queryAllTaskByProcId(Long procId) {
        String selectFields = "id, taskstatus, updatestatustime, flowrurole, handler,batchno";
        QFilter filter = new QFilter("flowruproc", "=", (Object)procId);
        return this.queryOriginalArray(selectFields, new QFilter[]{filter}, "updatestatustime");
    }

    public DynamicObject[] queryTaskByNodeIds(List<Long> nodeIds) {
        String selectFields = "id, taskstatus, flowrunode, updatestatustime, flowrurole.id, flowrurole.roletype.name, handler.id,handler.number, handler.name";
        QFilter filter = new QFilter("flowrunode", "in", nodeIds);
        return this.queryOriginalArray(selectFields, new QFilter[]{filter});
    }

    public DynamicObject[] queryTaskWithoutExpiredByNodeIds(List<Long> nodeIds) {
        String selectFields = "id, flowrunode.id, updatestatustime, flowrurole.id,flowrurole.name, handler.name";
        QFilter filter = new QFilter("flowrunode", "in", nodeIds);
        filter.and("taskstatus", "=", (Object)FlowRuTaskStatusEnum.PROCESSED.getCode());
        return this.queryOriginalArray(selectFields, new QFilter[]{filter}, "updatestatustime ASC");
    }

    public DynamicObject[] queryCanSetHandlerTaskByNodeIds(List<Long> nodeIds) {
        String selectFields = "id, taskstatus, flowrunode, updatestatustime, flowrurole.id, flowrurole.roletype.name, handler.number, handler.name";
        QFilter filter = new QFilter("flowrunode", "in", nodeIds);
        filter.and("taskstatus", "not in", Arrays.asList(FlowRuTaskStatusEnum.PROCESSED.getCode(), FlowRuTaskStatusEnum.EXPIRED.getCode(), FlowRuTaskStatusEnum.RETURNED.getCode()));
        return this.queryOriginalArray(selectFields, new QFilter[]{filter});
    }

    public DynamicObject[] queryTasksByRunRoleId(Long ruRoleId) {
        QFilter qFilter = new QFilter("flowrurole", "=", (Object)ruRoleId);
        return this.query(TASK_UPDATE_FIELDS, new QFilter[]{qFilter});
    }

    public DynamicObject[] queryTasksByRunRoleIds(List<Long> ruRoleIds) {
        QFilter qFilter = new QFilter("flowrurole", "in", ruRoleIds);
        return this.query(TASK_UPDATE_FIELDS, new QFilter[]{qFilter});
    }

    public DynamicObject[] queryTasksByIds(List<Long> taskIds) {
        String selectFields = "id, taskstatus, updatestatustime, modifier, modifytime, flowrunode, flowruproc.id,flowrunode.id,flowrunode.index,flowrurole.id,handler.id,isdeleteop,iscotask";
        QFilter qFilter = new QFilter("id", "in", taskIds);
        return this.query(selectFields, new QFilter[]{qFilter});
    }

    public DynamicObject[] queryOriginalTasksByIds(List<Long> taskIds) {
        String selectFields = "id, taskstatus, updatestatustime, modifier, modifytime, flowrunode, flowruproc.id,flowrunode.id,flowrunode.index,flowrurole.id,handler.id,isdeleteop,iscotask";
        QFilter qFilter = new QFilter("id", "in", taskIds);
        return this.queryOriginalArray(selectFields, new QFilter[]{qFilter});
    }

    public DynamicObject[] queryMergerMsgTasksByIds(List<Long> taskIds) {
        String selectFields = "id, taskstatus,flowrunode, flowruproc.id, flowruproc.workflowtype, flowrunode.id,flowrunode.index,flowrunode.name,flowrurole.id,handler.id,updatestatustime,modifier,createtime,modifytime";
        QFilter qFilter = new QFilter("id", "in", taskIds).and("taskstatus", "in", Arrays.asList("20", "30"));
        return this.query(selectFields, new QFilter[]{qFilter});
    }

    public Map<Long, String> queryTasksStatusByIds(List<Long> taskIds) {
        String selectFields = "id, taskstatus";
        QFilter qFilter = new QFilter("id", "in", taskIds);
        DynamicObject[] dynamicObjects = this.query(selectFields, new QFilter[]{qFilter});
        return Arrays.stream(dynamicObjects).collect(Collectors.toMap(taskId -> taskId.getLong("id"), taskStatus -> taskStatus.getString("taskstatus")));
    }

    public DynamicObject[] loadTasksByIds(List<Long> taskIds) {
        QFilter qFilter = new QFilter("id", "in", taskIds);
        return this.loadDynamicObjectArray(new QFilter[]{qFilter});
    }

    public DynamicObject[] queryRuTasksByIds(List<Long> taskIds) {
        QFilter qFilter = new QFilter("id", "in", taskIds);
        return this.query("id, taskstatus, updatestatustime, modifier, modifytime, flowrunode.id, flowruproc.id,flowrurole.id,handler.id,entryentity.indicatorid,isrollbacked", new QFilter[]{qFilter});
    }

    public DynamicObject[] queryCoTasksByIds(List<Long> hostTaskIds) {
        QFilter qFilter = new QFilter("hosttask.id", "in", hostTaskIds);
        qFilter.and("taskstatus", "!=", (Object)FlowRuTaskStatusEnum.EXPIRED.getCode());
        return this.query("id, taskstatus, updatestatustime, modifier, modifytime,hosttask.id", new QFilter[]{qFilter});
    }

    public DynamicObject[] queryHostTaskAndCoTaskByIds(List<Long> hostTaskIds) {
        QFilter qFilter = new QFilter("hosttask.id", "in", hostTaskIds);
        qFilter.and("hosttask.id", "!=", (Object)0L);
        qFilter.or("id", "in", hostTaskIds);
        return this.loadDynamicObjectArray(new QFilter[]{qFilter});
    }

    public DynamicObject[] loadTasksByRoleIds(List<Long> ruRoleIds) {
        QFilter qFilter = new QFilter("flowrurole", "in", ruRoleIds);
        qFilter.and("taskstatus", "!=", (Object)FlowRuTaskStatusEnum.EXPIRED.getCode());
        return this.loadDynamicObjectArray(new QFilter[]{qFilter});
    }

    public DynamicObject[] queryTasksByRoleIds(List<Long> ruRoleIds) {
        QFilter qFilter = new QFilter("flowrurole", "in", ruRoleIds);
        qFilter.and("taskstatus", "!=", (Object)FlowRuTaskStatusEnum.EXPIRED.getCode());
        return this.query("id, taskstatus, updatestatustime, modifier, modifytime, flowrunode.id, flowruproc.id,flowrurole.id,handler.id,entryentity.indicatorid,isrollbacked", new QFilter[]{qFilter});
    }

    public DynamicObject[] queryOriginalTasksByRoleIds(List<Long> ruRoleIds) {
        QFilter qFilter = new QFilter("flowrurole", "in", ruRoleIds);
        qFilter.and("taskstatus", "!=", (Object)FlowRuTaskStatusEnum.EXPIRED.getCode());
        return this.queryOriginalArray("id, updatestatustime, modifytime,flowrurole.id,entryentity,entryentity.indicatorid", new QFilter[]{qFilter});
    }

    public DynamicObject[] loadTasksByProcIds(List<Long> ruProcIds) {
        QFilter qFilter = new QFilter("flowruproc", "in", ruProcIds);
        qFilter.and("taskstatus", "!=", (Object)FlowRuTaskStatusEnum.EXPIRED.getCode());
        return this.loadDynamicObjectArray(new QFilter[]{qFilter});
    }

    public DynamicObject[] loadTasksByRowProcIds(List<Long> ruProcIds) {
        QFilter qFilter = new QFilter("flowruproc", "in", ruProcIds);
        return this.loadDynamicObjectArray(new QFilter[]{qFilter});
    }

    public DynamicObject[] queryAllTaskByRoleId(Long ruRoleId) {
        QFilter qFilter = new QFilter("flowrurole", "=", (Object)ruRoleId);
        return this.loadDynamicObjectArray(new QFilter[]{qFilter});
    }

    public DynamicObject[] queryAllTaskByRoleIds(List<Long> ruRoleIds) {
        QFilter qFilter = new QFilter("flowrurole", "in", ruRoleIds);
        qFilter.and("taskstatus", "in", Arrays.asList(FlowRuTaskStatusEnum.NOT_ACTIVE.getCode(), FlowRuTaskStatusEnum.BE_WAITTING.getCode(), FlowRuTaskStatusEnum.PENDING.getCode()));
        return this.query("id,flowrurole.id,flowrunode.id", new QFilter[]{qFilter});
    }

    public DynamicObject[] queryEffectTasksByRoleIds(Set<Long> ruRoleIds) {
        QFilter qFilter = new QFilter("flowrurole", "in", ruRoleIds);
        qFilter.and("taskstatus", "in", Arrays.asList(FlowRuTaskStatusEnum.NOT_ACTIVE.getCode(), FlowRuTaskStatusEnum.WAITING.getCode(), FlowRuTaskStatusEnum.PROCESSING.getCode(), FlowRuTaskStatusEnum.PROCESSED.getCode(), FlowRuTaskStatusEnum.BE_WAITTING.getCode(), FlowRuTaskStatusEnum.RETURNED.getCode(), FlowRuTaskStatusEnum.PENDING.getCode()));
        return this.query("id, flowrurole_id", new QFilter[]{qFilter});
    }

    public boolean deleteAllTaskByProcInstId(List<Long> procIds) {
        QFilter qFilter = new QFilter("flowruproc", "in", procIds);
        return this.deleteByFilter(new QFilter[]{qFilter}) > 0 ? Boolean.TRUE : Boolean.FALSE;
    }

    public DynamicObject[] loadTasksByCusFilter(QFilter cusFilter) {
        return this.loadDynamicObjectArray(new QFilter[]{cusFilter});
    }

    public DynamicObject[] queryNoOperateTasksById(List<Long> ids) {
        QFilter qFilter = new QFilter("id", "in", ids).and("taskstatus", "not in", Arrays.asList("20", "30"));
        return this.query(TASK_UPDATE_FIELDS, new QFilter[]{qFilter});
    }

    public DynamicObject[] queryToImportScoreTasks(List<Long> procIds) {
        QFilter filter = new QFilter("flowruproc", "in", procIds);
        filter.and("taskstatus", "in", Arrays.asList(FlowRuTaskStatusEnum.PROCESSING.getCode(), FlowRuTaskStatusEnum.PROCESSED.getCode(), FlowRuTaskStatusEnum.WAITING.getCode(), FlowRuTaskStatusEnum.RETURNED.getCode(), FlowRuTaskStatusEnum.PENDING.getCode()));
        return this.query("id,flowrunode.id", new QFilter[]{filter});
    }

    public Map<Long, String> queryRoleStatusByIds(List<Long> taskIds) {
        String selectFields = "id, taskstatus,flowrurole.id,flowrurole.rolestatus";
        QFilter qFilter = new QFilter("id", "in", taskIds);
        DynamicObject[] tasks = this.query(selectFields, new QFilter[]{qFilter});
        return Arrays.stream(tasks).collect(Collectors.toMap(x -> x.getLong("id"), y -> y.getString("flowrurole.rolestatus")));
    }

    public DynamicObject[] queryActeavlObjWorkflowTypeTasks(Long acteavlobj, String workflowType) {
        QFilter qFilter = new QFilter("taskstatus", "in", Arrays.asList("20", "30")).and("flowruproc.actevalobj", "=", (Object)acteavlobj).and("flowruproc.workflowtype", "=", (Object)workflowType);
        return this.query(TASK_UPDATE_FIELDS, new QFilter[]{qFilter});
    }

    public boolean queryHasSameHandlerCompleteTask(DynamicObject ruNode, Long handlerId) {
        String selectFields = "id,flowrunode.flownodedef.id";
        QFilter qFilter = new QFilter("handler.id", "=", (Object)handlerId);
        qFilter.and("flowruproc.id", "=", ruNode.get("flowruproc.id"));
        qFilter.and("flowrunode.index", "<", ruNode.get("index"));
        qFilter.and("taskstatus", "=", (Object)FlowRuTaskStatusEnum.PROCESSED.getCode());
        qFilter.and("flowrurole.rolestatus", "=", (Object)FlowRuRoleStatusEnum.FINISHED.getCode());
        DynamicObject[] tasks = this.queryOriginalArray(selectFields, new QFilter[]{qFilter});
        List<Long> nodeDefIdList = Arrays.stream(tasks).map(e -> e.getLong("flowrunode.flownodedef.id")).distinct().collect(Collectors.toList());
        DynamicObject[] nodeDefDyns = FLOW_NODEDEF_NODE_ENTITYSERVICE.getFlowDefNode(nodeDefIdList);
        boolean hasAuditNode = Boolean.FALSE;
        for (DynamicObject nodeDef : nodeDefDyns) {
            if (!NodeTypeConstants.INDICATOR_AUDIT.equals(nodeDef.getLong("nodetype.id"))) continue;
            hasAuditNode = Boolean.TRUE;
            break;
        }
        DynamicObject preRuNodeDyn = FlowRuNodeEntityService.getInstance().queryRuNodeByIndex(ruNode.getLong("flowruproc.id"), ruNode.getInt("index") - 1);
        boolean isPreRuNodeFinished = Boolean.TRUE;
        if (null != preRuNodeDyn && !preRuNodeDyn.getString("nodestatus").equals(FlowRuNodeStatusEnum.FINISHED.getCode())) {
            isPreRuNodeFinished = Boolean.FALSE;
        }
        if (tasks.length > 0 && hasAuditNode && isPreRuNodeFinished) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public boolean queryHasSameHandlerCompleteTaskForEvalWorkflow(DynamicObject ruNode, DynamicObject runTask, Map<Long, Long> soureOfJumpTaskMap) {
        Long handlerId = runTask.getLong("handler.id");
        String selectFields = "id,flowrunode.flownodedef.id,flowrurole.turnoversort,flowrunode.id,updatestatustime";
        QFilter qFilter = new QFilter("handler.id", "=", (Object)handlerId);
        qFilter.and("flowruproc.id", "=", ruNode.get("flowruproc.id"));
        qFilter.and("flowrunode.index", "<=", ruNode.get("index"));
        qFilter.and("taskstatus", "=", (Object)FlowRuTaskStatusEnum.PROCESSED.getCode());
        qFilter.and("iscrossevaluate", "=", (Object)Boolean.FALSE);
        log.info("\u3010OPMC\u3011-queryHasSameHandlerCompleteTaskForEvalWorkflow before add filter : flowrurole.rolestatus");
        qFilter.and("flowrurole.rolestatus", "=", (Object)FlowRuRoleStatusEnum.FINISHED.getCode());
        log.info("\u3010OPMC\u3011-queryHasSameHandlerCompleteTaskForEvalWorkflow after  filter : flowrurole.rolestatus");
        DynamicObject[] tasks = this.queryOriginalArray(selectFields, new QFilter[]{qFilter}, "flowrunode.index,updatestatustime DESC");
        Map nodeTaskMap = Arrays.stream(tasks).collect(Collectors.groupingBy(e -> e.getLong("flowrunode.flownodedef.id"), Collectors.mapping(ts -> ts, Collectors.toList())));
        List<Long> nodeDefIdList = Arrays.stream(tasks).map(e -> e.getLong("flowrunode.flownodedef.id")).distinct().collect(Collectors.toList());
        DynamicObject[] nodeDefDyns = FLOW_NODEDEF_NODE_ENTITYSERVICE.getFlowDefNode(nodeDefIdList);
        List nodeDefDynsList = Arrays.stream(nodeDefDyns).collect(Collectors.toList());
        nodeDefDynsList.sort((o1, o2) -> {
            Integer seq1 = o1.getInt("entryseq");
            Integer seq2 = o2.getInt("entryseq");
            return seq2.compareTo(seq1);
        });
        Boolean hasSameHandlerNode = Boolean.FALSE;
        for (DynamicObject nodeDef : nodeDefDynsList) {
            if (!NodeTypeConstants.EVALUATE_SCORE.equals(nodeDef.getLong("nodetype.id")) && !NodeTypeConstants.BATCH_EVALUSUMSCORE.equals(nodeDef.getLong("nodetype.id"))) continue;
            List nodeTasks = nodeTaskMap.get(nodeDef.getLong("id"));
            nodeTasks.sort((o1, o2) -> {
                Date d1 = o1.getDate("updatestatustime");
                Date d2 = o2.getDate("updatestatustime");
                return d2.compareTo(d1);
            });
            for (DynamicObject task : nodeTasks) {
                if (ruNode.getLong("id") == task.getLong("flowrunode.id") && runTask.getLong("flowrurole.turnoversort") == task.getLong("flowrurole.turnoversort")) continue;
                soureOfJumpTaskMap.put(runTask.getLong("id"), task.getLong("id"));
                hasSameHandlerNode = Boolean.TRUE;
                break;
            }
            if (!hasSameHandlerNode.booleanValue()) continue;
            break;
        }
        if (tasks.length > 0 && hasSameHandlerNode.booleanValue()) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public int countAuditNodeHandlerProceedOrRollBackTasks(Long procId, Long handler) {
        QFilter qFilter = new QFilter("flowruproc.id", "=", (Object)procId).and("flowrunode.flownodedef.nodetype", "=", (Object)NodeTypeConstants.INDICATOR_AUDIT).and("handler.id", "=", (Object)handler).and("taskstatus", "in", Collections.singletonList("40"));
        return this.count("pbs_flowrutask", new QFilter[]{qFilter});
    }

    public Map<Long, String> getSubmitTaskStatus(List<Long> taskIds) {
        DynamicObject[] rutaskProcLogDyns;
        HashMap<Long, String> taskStatusMap = new HashMap<Long, String>(16);
        String selectFields = "id, taskstatus";
        QFilter qFilter = new QFilter("id", "in", taskIds);
        DynamicObject[] taskDyns = this.queryOriginalArray(selectFields, new QFilter[]{qFilter});
        ArrayList<Long> needQueryTaskProcLogIdList = new ArrayList<Long>(10);
        for (DynamicObject task : taskDyns) {
            if (task.getString("taskstatus").equals(FlowRuTaskStatusEnum.WAITING.getCode())) {
                needQueryTaskProcLogIdList.add(task.getLong("id"));
            }
            taskStatusMap.put(task.getLong("id"), task.getString("taskstatus"));
        }
        for (DynamicObject rutaskProcLog : rutaskProcLogDyns = FLOW_RU_TASK_PROC_LOG_ENTITY_SERVICE.queryRuTaskProcLogByTaskIds(needQueryTaskProcLogIdList)) {
            taskStatusMap.put(rutaskProcLog.getLong("flowrutask"), FlowRuTaskStatusEnum.PROCESSED.getCode());
        }
        return taskStatusMap;
    }

    public DynamicObject[] loadTasksByProcIdsAndStatus(List<Long> ruProcIds, List<String> taskStatusCodes, List<Long> currentNodeId) {
        QFilter qFilter = new QFilter("flowruproc", "in", ruProcIds);
        qFilter.and("taskstatus", "in", taskStatusCodes).and("flowrunode", "in", currentNodeId);
        return this.loadDynamicObjectArray(new QFilter[]{qFilter});
    }

    public DynamicObject[] queryBeWattingTaskByActevalObj(List<Long> actevalObjs, String workflowType) {
        QFilter qFilter = new QFilter("flowruproc.actevalobj", "in", actevalObjs);
        qFilter.and("flowruproc.workflowtype", "=", (Object)workflowType).and("taskstatus", "=", (Object)"70");
        return this.queryOriginalArray("id,flowruproc.actevalobj,taskstatus", new QFilter[]{qFilter});
    }

    protected void postProcessAfterTaskChange(DynamicObject[] oldTaskList, DynamicObject[] newTaskList) {
        log.info("taskStatusMonitor start,oldTaskList:{},newTaskList:{}", Arrays.asList(oldTaskList), Arrays.asList(newTaskList));
        this.taskStatusMonitor(oldTaskList, newTaskList);
        log.info("taskStatusMonitor end");
    }

    protected List<Map<Object, Object>> taskStatusMonitor(DynamicObject[] oldTaskList, DynamicObject[] newTaskList) {
        HRPluginProxy proxy = new HRPluginProxy((Object)I_WORK_FLOW_TASK_OUT_SERVICE, IWorkFlowTaskOutService.class, "kd.opmc.pbs.business.domain.workflow.outService.IWorkFlowTaskOutService.taskStatusMonitor", (PluginFilter)null);
        return proxy.callReplaceIfPresent(p -> p.taskStatusMonitor(oldTaskList, newTaskList));
    }

    @Override
    public Object[] save(DynamicObject[] tasks) {
        ArrayList<Long> taskIds = new ArrayList<Long>(10);
        for (DynamicObject task : tasks) {
            taskIds.add(task.getLong("id"));
        }
        DynamicObject[] oldTasks = new DynamicObject[]{};
        if (CollectionUtils.isNotEmpty(taskIds)) {
            oldTasks = this.queryTaskByPks(taskIds);
        }
        Object[] result = super.save(tasks);
        this.postProcessAfterTaskChange(oldTasks, tasks);
        return result;
    }

    @Override
    public Object saveOne(DynamicObject task) {
        return super.save(new DynamicObject[]{task});
    }

    @Override
    public Object[] save(DynamicObjectCollection taskCollection) {
        return super.save((DynamicObject[])taskCollection.toArray((Object[])new DynamicObject[0]));
    }

    @Override
    public int deleteByFilter(QFilter[] filters) {
        DynamicObject[] oldTasks = this.query(filters);
        if (oldTasks == null || oldTasks.length == 0) {
            return 0;
        }
        int i = super.deleteByFilter(filters);
        this.postProcessAfterTaskChange(oldTasks, new DynamicObject[0]);
        return i;
    }

    @Override
    public void delete(Object[] pks) {
        QFilter filter = new QFilter("id", "in", Arrays.asList(pks));
        this.deleteByFilter(new QFilter[]{filter});
    }

    @Override
    public void deleteOne(Object pk) {
        QFilter filter = new QFilter("id", "=", pk);
        this.deleteByFilter(new QFilter[]{filter});
    }

    @Override
    public Object[] update(DynamicObject[] dobjs) {
        return this.save(dobjs);
    }

    @Override
    public Object updateOne(DynamicObject dobj) {
        return this.save(new DynamicObject[]{dobj});
    }

    @Override
    public void updateDataOne(DynamicObject dobj) {
        this.save(new DynamicObject[]{dobj});
    }

    @Override
    public void updateDatas(DynamicObject[] dobjs) {
        this.save(dobjs);
    }

    public boolean queryEffectiveTask(long ruNodeId, Long userId) {
        QFilter qFilter = new QFilter("flowrunode", "=", (Object)ruNodeId).and("handler", "=", (Object)userId).and("taskstatus", "in", Arrays.asList(FlowRuTaskStatusEnum.WAITING.getCode(), FlowRuTaskStatusEnum.PROCESSING.getCode()));
        return this.isExists(qFilter);
    }

    public DynamicObject[] loadCoopTasksByMainTaskIds(List<Long> mainTaskIds) {
        QFilter qFilter = new QFilter("hosttask.id", "in", mainTaskIds);
        return this.loadDynamicObjectArray(new QFilter[]{qFilter});
    }

    public DynamicObject[] queryMainTasks(List<Long> handlerList, Long activityId, String workflowType) {
        QFilter qFilter = new QFilter("handler.id", "in", handlerList);
        qFilter.and("activity", "=", (Object)activityId);
        qFilter.and("flowruproc.workflowtype", "=", (Object)workflowType);
        return this.queryOriginalArray("id,handler.id", new QFilter[]{qFilter});
    }

    public DynamicObject getTaskId(Long nodeDefId) {
        QFilter qFilter = new QFilter("flowrunode.flownodedef.id", "=", (Object)nodeDefId).and("taskstatus", "=", (Object)FlowRuTaskStatusEnum.WAITING.getCode());
        return this.queryOriginalOne("id", new QFilter[]{qFilter});
    }
}

