/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.pbs.business.domain.workflow.entityservice;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.opmc.pbs.business.ServiceFactory;
import kd.opmc.pbs.business.domain.OpmcEntityService;

public class FlowRuTaskProcLogEntityService
extends OpmcEntityService {
    private static final HRBaseServiceHelper HELPER = new HRBaseServiceHelper("pbs_flowrutaskproclog");

    @Override
    protected HRBaseServiceHelper getServiceHelper() {
        return HELPER;
    }

    public static FlowRuTaskProcLogEntityService getInstance() {
        return ServiceFactory.getService(FlowRuTaskProcLogEntityService.class);
    }

    public void generateRuTaskLog(List<DynamicObject> rutaskList) {
        ArrayList<DynamicObject> rutaskLogList = new ArrayList<DynamicObject>(rutaskList.size());
        for (DynamicObject rutask : rutaskList) {
            DynamicObject rutaskLog = this.generateEmptyDynamicObject();
            Date date = new Date();
            long userId = UserServiceHelper.getCurrentUserId();
            rutaskLog.set("creator", (Object)userId);
            rutaskLog.set("createtime", (Object)date);
            rutaskLog.set("modifier", (Object)userId);
            rutaskLog.set("modifytime", (Object)date);
            rutaskLog.set("description", null);
            rutaskLog.set("consumestatus", (Object)"10");
            rutaskLog.set("receivems", (Object)System.currentTimeMillis());
            rutaskLog.set("consumems", null);
            rutaskLog.set("retrycount", (Object)0);
            rutaskLog.set("assessyear", rutask.get("assessyear"));
            rutaskLog.set("assessperiod", rutask.get("assessperiod"));
            rutaskLog.set("activity", rutask.get("activity"));
            rutaskLog.set("flowruproc", (Object)rutask.getLong("flowruproc.id"));
            rutaskLog.set("flowrunode", (Object)rutask.getLong("flowrunode.id"));
            rutaskLog.set("flowrurole", (Object)rutask.getLong("flowrurole.id"));
            rutaskLog.set("flowrutask", (Object)rutask.getLong("id"));
            rutaskLog.set("perforg", (Object)rutask.getLong("perforg"));
            rutaskLogList.add(rutaskLog);
        }
        this.save(rutaskLogList.toArray(new DynamicObject[0]));
    }

    public DynamicObject[] queryRuTaskProcLogByTaskIds(List<Long> taskIds) {
        QFilter qFilter = new QFilter("flowrutask", "in", taskIds);
        return this.query("flowrutask,consumestatus,consumems,", new QFilter[]{qFilter});
    }

    public void updateRuTaskProcLog(List<Long> taskIds, Map<Long, Boolean> resultMap) {
        DynamicObject[] ruTaskProcLogDyns = this.queryRuTaskProcLogByTaskIds(taskIds);
        long now = System.currentTimeMillis();
        for (DynamicObject ruTaskProcLog : ruTaskProcLogDyns) {
            boolean dealStatus = null != resultMap.get(ruTaskProcLog.getLong("flowrutask")) ? resultMap.get(ruTaskProcLog.getLong("flowrutask")).booleanValue() : Boolean.FALSE.booleanValue();
            ruTaskProcLog.set("consumestatus", (Object)(dealStatus ? "20" : "30"));
            ruTaskProcLog.set("consumems", (Object)now);
        }
        this.save(ruTaskProcLogDyns);
    }
}

