/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.pbs.business.domain.workflow.entityservice;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.opmc.pbs.business.ServiceFactory;
import kd.opmc.pbs.business.domain.OpmcEntityService;

public class WorkFlowEntityService
extends OpmcEntityService {
    private static final HRBaseServiceHelper HELPER = new HRBaseServiceHelper("pbs_workflow");

    public static WorkFlowEntityService getInstance() {
        return ServiceFactory.getService(WorkFlowEntityService.class);
    }

    @Override
    public HRBaseServiceHelper getServiceHelper() {
        return HELPER;
    }

    public DynamicObject[] getWorkflows(List<Long> flowIds) {
        QFilter qFilter = new QFilter("iscurrentversion", "=", (Object)"1").and("boid", "in", flowIds).and("hisversion", "!=", (Object)"COPYTEMP");
        return HELPER.query("boid,sourcevid,processinfo,nodenum,name,number,isdefault,ismatrix,status,datastatus,iscurrentversion,bsed,bred,bsled,enable,publishstatus,hisversion,workflowtype,modifytime", new QFilter[]{qFilter}, "enable desc, modifytime desc, createtime desc");
    }

    public DynamicObject[] getAllWorkflows(List<Long> flowIds) {
        QFilter qFilter = new QFilter("boid", "in", flowIds).and("hisversion", "!=", (Object)"COPYTEMP");
        return HELPER.query("boid,sourcevid,processinfo,nodenum,name,number,isdefault,ismatrix,status,datastatus,iscurrentversion,bsed,bred,bsled,enable,publishstatus,hisversion,workflowtype,modifytime", new QFilter[]{qFilter}, "enable desc, modifytime desc, createtime desc");
    }

    public DynamicObject[] getWorkflowsByVid(List<Long> vids) {
        QFilter qFilter = new QFilter("id", "in", vids).and("hisversion", "!=", (Object)"COPYTEMP");
        return HELPER.query("processinfo,nodenum,name,number,isdefault,ismatrix,enable,publishstatus,status,datastatus,iscurrentversion,bsed,bred,bsled,hisversion,boid,entryentity,flowdefproc,workflowtype,modifytime,sourceflowid", new QFilter[]{qFilter}, "enable desc, modifytime desc, createtime desc");
    }

    public DynamicObject[] getWorkflowsByVids(List<Long> vids) {
        QFilter qFilter = new QFilter("id", "in", vids).and("hisversion", "!=", (Object)"COPYTEMP");
        return HELPER.loadDynamicObjectArray(new QFilter[]{qFilter});
    }

    public DynamicObject getWorkflow(long flowId) {
        QFilter qFilter = new QFilter("boid", "=", (Object)flowId).and("iscurrentversion", "=", (Object)"1").and("hisversion", "!=", (Object)"COPYTEMP");
        DynamicObject[] workflowDyns = HELPER.loadDynamicObjectArray(new QFilter[]{qFilter});
        if (workflowDyns.length > 0) {
            return workflowDyns[0];
        }
        return null;
    }

    public DynamicObject getTempWorkflow(long flowId) {
        QFilter qFilter = new QFilter("boid", "=", (Object)flowId).and("status", "=", (Object)"A").and("datastatus", "=", (Object)"-3").and("iscurrentversion", "=", (Object)"1").and("hisversion", "!=", (Object)"COPYTEMP");
        DynamicObject[] dynamicObjects = HELPER.loadDynamicObjectArray(new QFilter[]{qFilter});
        if (0 != dynamicObjects.length) {
            return dynamicObjects[0];
        }
        return null;
    }

    public DynamicObject[] getPublishFlows(List<Long> flowIds) {
        QFilter qFilter = new QFilter("iscurrentversion", "=", (Object)"1").and("boid", "in", flowIds).and("hisversion", "!=", (Object)"COPYTEMP");
        return HELPER.loadDynamicObjectArray(new QFilter[]{qFilter});
    }

    public DynamicObject getCurrentTempWorkflow(long flowId) {
        QFilter qFilter = new QFilter("boid", "=", (Object)flowId).and("status", "=", (Object)"A").and("datastatus", "=", (Object)"-3").and("iscurrentversion", "=", (Object)"1").and("hisversion", "!=", (Object)"COPYTEMP");
        return HELPER.loadDynamicObject(new QFilter[]{qFilter});
    }

    public DynamicObject[] getCurrentTempWorkflows(List<Long> flowIds) {
        QFilter qFilter = new QFilter("boid", "in", flowIds).and("status", "=", (Object)"A").and("datastatus", "=", (Object)"-3").and("iscurrentversion", "=", (Object)"1").and("hisversion", "!=", (Object)"COPYTEMP");
        return HELPER.loadDynamicObjectArray(new QFilter[]{qFilter});
    }

    public DynamicObject[] getCopyTempWorkflow(List<Long> flowIds) {
        QFilter qFilter = new QFilter("sourcevid", "in", flowIds).and("hisversion", "=", (Object)"COPYTEMP");
        return HELPER.loadDynamicObjectArray(new QFilter[]{qFilter});
    }

    public void deleteBackupFlows(List<Long> flowIds) {
        QFilter qFilter = new QFilter("sourcevid", "in", flowIds).and("hisversion", "=", (Object)"COPYTEMP");
        HELPER.deleteByFilter(new QFilter[]{qFilter});
    }

    public DynamicObject getCurrentWorkflow(long flowId) {
        QFilter qFilter = new QFilter("boid", "=", (Object)flowId).and("status", "=", (Object)"C").and("datastatus", "=", (Object)"1").and("iscurrentversion", "=", (Object)"1").and("hisversion", "!=", (Object)"COPYTEMP");
        DynamicObject workflow = HELPER.loadDynamicObject(new QFilter[]{qFilter});
        if (null == workflow) {
            QFilter qFilter2 = new QFilter("boid", "=", (Object)flowId).and("status", "=", (Object)"C").and("datastatus", "=", (Object)"1").and("iscurrentversion", "=", (Object)"0").and("hisversion", "!=", (Object)"COPYTEMP");
            return HELPER.loadDynamicObject(new QFilter[]{qFilter2});
        }
        return workflow;
    }

    public DynamicObject getWorkflowById(long flowId) {
        return HELPER.loadSingle((Object)flowId);
    }

    public DynamicObject getSaveOrEffWorkflows(long flowId) {
        QFilter qFilter = new QFilter("boid", "=", (Object)flowId).and("status", "=", (Object)"A").and("datastatus", "=", (Object)"-3").and("iscurrentversion", "=", (Object)"1").and("hisversion", "!=", (Object)"COPYTEMP");
        DynamicObject workflow = HELPER.loadDynamicObject(new QFilter[]{qFilter});
        if (null != workflow) {
            QFilter qFilter2 = new QFilter("boid", "=", (Object)flowId).and("status", "=", (Object)"C").and("datastatus", "=", (Object)"1").and("iscurrentversion", "=", (Object)"0").and("hisversion", "!=", (Object)"COPYTEMP");
            return HELPER.loadDynamicObject(new QFilter[]{qFilter2});
        }
        return null;
    }

    public Object save(DynamicObject dynamicObject) {
        return HELPER.saveOne(dynamicObject);
    }

    public DynamicObject getWorkflowVersion(long flowId) {
        QFilter qFilter = new QFilter("boid", "=", (Object)flowId).and("hisversion", "not in", Arrays.asList(" ", "COPYTEMP"));
        return HELPER.queryOne("id,hisversion", new QFilter[]{qFilter}, "id desc");
    }

    public DynamicObject[] getWorkflowById(Set<Object> flowIds) {
        QFilter qFilter = new QFilter("id", "in", flowIds).and("hisversion", "!=", (Object)"COPYTEMP");
        return HELPER.query("id,name,isdefault,entryentity,flowdefproc", new QFilter[]{qFilter}, "enable desc, modifytime desc, createtime desc");
    }

    public DynamicObject[] getWorkflowsByIdAndFlowType(List<Long> flowIds, String flowType) {
        QFilter qFilter = new QFilter("iscurrentversion", "=", (Object)"1").and("boid", "in", flowIds);
        qFilter.and("workflowtype", "=", (Object)flowType).and("hisversion", "!=", (Object)"COPYTEMP");
        return HELPER.query("boid,sourcevid,processinfo,nodenum,name,number,isdefault,ismatrix,status,datastatus,iscurrentversion,bsed,bred,bsled,enable,publishstatus,hisversion,workflowtype,modifytime", new QFilter[]{qFilter}, "enable desc, modifytime desc, createtime desc");
    }

    public DynamicObject[] getWorkFlowsByDefProcId(Set<Long> procDefId) {
        QFilter qFilter = new QFilter("entryentity.flowdefproc", "in", procDefId).and("iscurrentversion", "=", (Object)"1");
        return HELPER.query("id,name,entryentity,entryentity.flowdefproc", new QFilter[]{qFilter});
    }
}

