/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.pbs.business.domain.workflow.enums;

import java.util.Arrays;
import kd.opmc.pbs.business.domain.workflow.constants.FlowRuntimeConstants;

public enum FlowRuNodeStatusEnum {
    PENDING("10", "#FB2323"),
    STOP("15", "#FF991C"),
    RUNNING("20", "#276FF5"),
    NOT_ACTIVE("30", "#212121"),
    FINISHED("40", "#1BA854"),
    EXPIRED("60", "#808080"),
    BE_WAITTING("70", "#EEE8AA"),
    RETURNED("80", "#F08080");

    private final String code;
    private final String colour;

    private FlowRuNodeStatusEnum(String code, String colour) {
        this.code = code;
        this.colour = colour;
    }

    public String getCode() {
        return this.code;
    }

    public String getColour() {
        return this.colour;
    }

    public String getText() {
        String res = "";
        switch (this) {
            case PENDING: {
                res = FlowRuntimeConstants.getFlowRuProcPendingText();
                break;
            }
            case STOP: {
                res = FlowRuntimeConstants.getFlowRuProcStopText();
                break;
            }
            case RUNNING: {
                res = FlowRuntimeConstants.getFlowRuProcRunning2Text();
                break;
            }
            case NOT_ACTIVE: {
                res = FlowRuntimeConstants.getFlowRuProcNotActiveText();
                break;
            }
            case FINISHED: {
                res = FlowRuntimeConstants.getFlowRuProcDeprecatedText();
                break;
            }
        }
        return res;
    }

    public static FlowRuNodeStatusEnum getFlowRuNodeStatusByCode(String code) {
        return Arrays.stream(FlowRuNodeStatusEnum.values()).filter(timeStampEnums -> timeStampEnums.code.equals(code)).findFirst().orElse(null);
    }
}

