/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.pbs.business.domain.workflow.enums;

import java.util.Arrays;
import kd.opmc.pbs.business.domain.workflow.constants.FlowRuntimeConstants;

public enum FlowRuProcStatusEnum {
    NOTACTIVE("00", "#5582F3", "#f2f9ff"),
    RUNNING("10", "#5582F3", "#f2f9ff"),
    PENDING("20", "#FB2323", "#fff2f4"),
    STOP("30", "#FF991C", "#fffbf2"),
    DEPRECATED("40", "#666666", "#f5f5f5"),
    FINISHED("50", "#1BA854", "#f2fff5");

    private final String code;
    private final String colour;
    private final String backColour;

    private FlowRuProcStatusEnum(String code, String colour, String backColour) {
        this.code = code;
        this.colour = colour;
        this.backColour = backColour;
    }

    public String getBackColour() {
        return this.backColour;
    }

    public String getCode() {
        return this.code;
    }

    public String getColour() {
        return this.colour;
    }

    public String getText() {
        String res = "";
        switch (this) {
            case RUNNING: {
                res = FlowRuntimeConstants.getFlowRuProcRunningText();
                break;
            }
            case PENDING: {
                res = FlowRuntimeConstants.getFlowRuProcPendingText();
                break;
            }
            case STOP: {
                res = FlowRuntimeConstants.getFlowRuProcStopText();
                break;
            }
            case DEPRECATED: {
                res = FlowRuntimeConstants.getFlowRuProcDeprecatedText();
                break;
            }
            case FINISHED: {
                res = FlowRuntimeConstants.getFlowRuProcFinishedText();
                break;
            }
            case NOTACTIVE: {
                res = FlowRuntimeConstants.getFlowRuProcNotActiveText();
                break;
            }
        }
        return res;
    }

    public static FlowRuProcStatusEnum getFlowRuProcStatusByCode(String code) {
        return Arrays.stream(FlowRuProcStatusEnum.values()).filter(timeStampEnums -> timeStampEnums.code.equals(code)).findFirst().orElse(null);
    }
}

