/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.pbs.business.domain.workflow.enums;

import java.util.Arrays;
import kd.opmc.pbs.business.domain.workflow.constants.FlowRuntimeConstants;

public enum FlowRuRoleStatusEnum {
    PENDING("10", "#FB2323"),
    RUNNING("20", "#276FF5"),
    FINISHED("30", "#1BA854"),
    NOT_ACTIVE("50", "#212121"),
    EXPIRED("60", "#999999"),
    BE_WAITTING("70", "#212121"),
    RETURNED("80", "#F08080");

    private final String code;
    private final String colour;

    private FlowRuRoleStatusEnum(String code, String colour) {
        this.code = code;
        this.colour = colour;
    }

    public String getCode() {
        return this.code;
    }

    public String getColour() {
        return this.colour;
    }

    public String getText() {
        String res = "";
        switch (this) {
            case PENDING: {
                res = FlowRuntimeConstants.getFlowRuProcPendingText();
                break;
            }
            case RUNNING: {
                res = FlowRuntimeConstants.getFlowRuProcProcessingText();
                break;
            }
            case FINISHED: {
                res = FlowRuntimeConstants.getFlowRuProcFinishedText();
                break;
            }
            case EXPIRED: {
                res = FlowRuntimeConstants.getFlowRuProcExpiredText();
                break;
            }
            case NOT_ACTIVE: {
                res = FlowRuntimeConstants.getFlowRuProcNotActiveText();
                break;
            }
            case BE_WAITTING: {
                res = FlowRuntimeConstants.getFlowRuProcBeWaittingText();
                break;
            }
            case RETURNED: {
                res = FlowRuntimeConstants.getFlowRuProcReturnedText();
                break;
            }
        }
        return res;
    }

    public static FlowRuRoleStatusEnum getFlowRuRoleStatusByCode(String code) {
        return Arrays.stream(FlowRuRoleStatusEnum.values()).filter(timeStampEnums -> timeStampEnums.code.equals(code)).findFirst().orElse(null);
    }
}

