/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.pbs.business.domain.workflow.enums;

import java.util.Arrays;
import kd.opmc.pbs.business.domain.workflow.constants.FlowRuntimeConstants;

public enum FlowRuRoleTypeEnum {
    SELF("10"),
    APPOINT("20"),
    SUPERIOR("30"),
    SUBORDINATE("40"),
    INCHARGE("50"),
    TOGETHER("60"),
    AUDIT("70");

    private final String code;

    private FlowRuRoleTypeEnum(String code) {
        this.code = code;
    }

    public String getCode() {
        return this.code;
    }

    public String getText() {
        String res = "";
        switch (this) {
            case SELF: {
                res = FlowRuntimeConstants.getFlowRuRoleTypeSelfText();
                break;
            }
            case APPOINT: {
                res = FlowRuntimeConstants.getFlowRuRoleTypeAppointText();
                break;
            }
            case SUPERIOR: {
                res = FlowRuntimeConstants.getFlowRuRoleTypeSuperiorText();
                break;
            }
            case SUBORDINATE: {
                res = FlowRuntimeConstants.getFlowRuRoleTypeSubordinateText();
                break;
            }
            case INCHARGE: {
                res = FlowRuntimeConstants.getFlowRuRoleTypeInChargeText();
                break;
            }
            case TOGETHER: {
                res = FlowRuntimeConstants.getFlowRuRoleTypeTogetherText();
                break;
            }
            case AUDIT: {
                res = FlowRuntimeConstants.getFlowRuRoleTypeAuditText();
                break;
            }
        }
        return res;
    }

    public static FlowRuRoleTypeEnum getFlowRuRoleTypeByCode(String code) {
        return Arrays.stream(FlowRuRoleTypeEnum.values()).filter(timeStampEnums -> timeStampEnums.code.equals(code)).findFirst().orElse(null);
    }
}

