/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.pbs.business.domain.workflow.enums;

import java.util.Arrays;
import kd.opmc.pbs.business.domain.workflow.constants.FlowRuntimeConstants;

public enum FlowRuTaskStatusEnum {
    NOT_ACTIVE("10", "#212121"),
    WAITING("20", "#FF991C"),
    PROCESSING("30", "#276FF5"),
    PROCESSED("40", "#1BA854"),
    REJECTED("50", "#FB2323"),
    EXPIRED("60", "#999999"),
    BE_WAITTING("70", "#212121"),
    RETURNED("80", "#F08080"),
    PENDING("90", "#FB2323");

    private final String code;
    private final String colour;

    private FlowRuTaskStatusEnum(String code, String colour) {
        this.code = code;
        this.colour = colour;
    }

    public String getCode() {
        return this.code;
    }

    public String getColour() {
        return this.colour;
    }

    public String getText() {
        String res = "";
        switch (this) {
            case NOT_ACTIVE: {
                res = FlowRuntimeConstants.getFlowRuProcNotActiveText();
                break;
            }
            case WAITING: {
                res = FlowRuntimeConstants.getFlowRuProcWaitingText();
                break;
            }
            case PROCESSING: {
                res = FlowRuntimeConstants.getFlowRuProcProcessingText();
                break;
            }
            case PROCESSED: {
                res = FlowRuntimeConstants.getFlowRuProcProcessedText();
                break;
            }
            case REJECTED: {
                res = FlowRuntimeConstants.getFlowRuProcRejectedText();
                break;
            }
            case EXPIRED: {
                res = FlowRuntimeConstants.getFlowRuProcExpiredText();
                break;
            }
            case RETURNED: {
                res = FlowRuntimeConstants.getFlowRuProcReturnedText();
                break;
            }
            case BE_WAITTING: {
                res = FlowRuntimeConstants.getFlowRuProcBeWaittingText();
                break;
            }
            case PENDING: {
                res = FlowRuntimeConstants.getFlowRuProcPendingText();
                break;
            }
        }
        return res;
    }

    public static FlowRuTaskStatusEnum getFlowRuTaskStatusByCode(String code) {
        return Arrays.stream(FlowRuTaskStatusEnum.values()).filter(timeStampEnums -> timeStampEnums.code.equals(code)).findFirst().orElse(null);
    }
}

