/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.pbs.business.domain.workflow.service;

import com.tongtech.backport.java.util.Collections;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.opmc.pbs.business.ServiceFactory;
import kd.opmc.pbs.business.domain.workflow.entity.FlowRuProcBo;
import kd.opmc.pbs.business.domain.workflow.entityservice.CrossRoleSetEntityService;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowDefNodeEntityService;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowRuRoleEntityService;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowRuTaskEntityService;
import kd.opmc.pbs.business.domain.workflow.entityservice.IndicatorRoleSetEntityService;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuNodeStatusEnum;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuRoleStatusEnum;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuTaskStatusEnum;
import kd.opmc.pbs.business.domain.workflow.model.CrossScoreParamsBo;
import kd.opmc.pbs.business.domain.workflow.vo.QueryHandlerVO;
import kd.opmc.pbs.business.external.epa.IEPAActevalobjService;
import kd.opmc.pbs.common.constants.NodeTypeConstants;

public class CrossScoreDomainService {
    private static final Log LOG = LogFactory.getLog(CrossScoreDomainService.class);
    private static final CrossRoleSetEntityService CROSS_ROLESET_ENTITYSERVICE = CrossRoleSetEntityService.getInstance();
    private static final FlowRuRoleEntityService FLOW_RU_ROLE_ENTITY_SERVICE = FlowRuRoleEntityService.getInstance();
    protected static final IEPAActevalobjService EPA_ACTEVAOBJ_SERVICE = IEPAActevalobjService.getInstance();
    protected static final FlowDefNodeEntityService FLOW_DEFNODE_ENTITY_SERVICE = FlowDefNodeEntityService.getInstance();
    private static final FlowRuTaskEntityService FLOW_RU_TASK_ENTITY_SERVICE = FlowRuTaskEntityService.getInstance();
    private static final IndicatorRoleSetEntityService INDICATOR_ROLE_SET_ENTITY_SERVICE = IndicatorRoleSetEntityService.getInstance();

    public static CrossScoreDomainService getInstance() {
        return ServiceFactory.getService(CrossScoreDomainService.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setCrossScore(CrossScoreParamsBo crossScoreBo) {
        try (TXHandle txhandle = TX.required();){
            CROSS_ROLESET_ENTITYSERVICE.generateCrossRoleSet(crossScoreBo);
        }
        return Boolean.TRUE;
    }

    public List<DynamicObject> queryCrossRoleSetByIndicatorList(Long nodeId, List<Long> indicatorIdList) {
        return CROSS_ROLESET_ENTITYSERVICE.queryCrossRoleSetByIndicatorList(nodeId, indicatorIdList);
    }

    public void dealCrossNodeForStartProc(FlowRuProcBo flowRuProcBo, DynamicObject ruProc, List<DynamicObject> ruNodeList) {
        HashMap<Long, DynamicObject> ruNodeMap = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject ruNode : ruNodeList) {
            if (!ruNode.getBoolean("iscrossnode")) continue;
            ruNodeMap.put(ruNode.getLong("flownodedef.id"), ruNode);
        }
        Map<Long, Map<Long, Long>> evaObjIndMap = EPA_ACTEVAOBJ_SERVICE.queryIndicatorByObjIds(Collections.singletonList((Object)flowRuProcBo.getActEvalObjId()));
        ArrayList<Long> indicatorIdList = new ArrayList<Long>(10);
        Map<Long, Long> indicatorMap = evaObjIndMap.get(flowRuProcBo.getActEvalObjId());
        if (null == indicatorMap || indicatorMap.isEmpty()) {
            return;
        }
        for (Map.Entry<Long, Long> entry : indicatorMap.entrySet()) {
            indicatorIdList.add(entry.getKey());
        }
        for (Map.Entry<Long, Long> entry : ruNodeMap.entrySet()) {
            Map<String, Map<String, Object>> crossMap = CROSS_ROLESET_ENTITYSERVICE.queryAllCrossRoleSetByIndicatorList(entry.getKey(), indicatorIdList);
            for (Map.Entry<String, Map<String, Object>> crossEntry : crossMap.entrySet()) {
                List crossRoleSetList = (List)crossEntry.getValue().get("crossRoleSet");
                List indRoleSetList = (List)crossEntry.getValue().get("indRoleSet");
                DynamicObject nodeDef = FLOW_DEFNODE_ENTITY_SERVICE.getFlowDefNode(entry.getKey());
                this.generateCrossRuRole(crossRoleSetList, indRoleSetList, (DynamicObject)entry.getValue(), nodeDef);
            }
        }
    }

    public List<DynamicObject> generateCrossRuRole(List<DynamicObject> crossRoleSetList, List<DynamicObject> indRoleSetList, DynamicObject ruNode, DynamicObject nodeDef) {
        int crossRoleSize = crossRoleSetList.size();
        ArrayList<DynamicObject> ruRoleList = new ArrayList<DynamicObject>(crossRoleSize);
        Date date = new Date();
        long userId = UserServiceHelper.getCurrentUserId();
        for (DynamicObject crossRole : crossRoleSetList) {
            DynamicObject roleDef = crossRole.getDynamicObject("defroleid");
            DynamicObject ruRole = FLOW_RU_ROLE_ENTITY_SERVICE.generateEmptyDynamicObject();
            ruRole.set("creator", (Object)userId);
            ruRole.set("createtime", (Object)date);
            ruRole.set("modifier", (Object)userId);
            ruRole.set("modifytime", (Object)date);
            ruRole.set("flowrunode", (Object)ruNode);
            ruRole.set("rolestatus", (Object)FlowRuRoleStatusEnum.NOT_ACTIVE.getCode());
            ruRole.set("assessyear", ruNode.get("assessyear"));
            ruRole.set("assessperiod", ruNode.get("assessperiod"));
            ruRole.set("flowruproc", ruNode.get("flowruproc"));
            if (NodeTypeConstants.EVALUATE_AUDIT.equals(nodeDef.getLong("nodetype.id")) || NodeTypeConstants.INDICATOR_AUDIT.equals(nodeDef.getLong("nodetype.id"))) {
                ruRole.set("roleweight", (Object)0);
            } else {
                ruRole.set("roleweight", crossRole.get("roleweight"));
            }
            ruRole.set("roletype", roleDef.get("roletype"));
            ruRole.set("updatestatustime", (Object)date);
            ruRole.set("activity", ruNode.get("activity"));
            ruRole.set("perforg", ruNode.get("perforg"));
            ruRole.set("flowdefrole", roleDef.getPkValue());
            ruRole.set("turnoversort", roleDef.get("turnoversort"));
            ruRole.set("name", roleDef.get("rolename"));
            ruRole.set("iscrossrole", (Object)Boolean.TRUE);
            ruRole.set("crossroleset", (Object)crossRole);
            ruRole.set("setno", crossRole.get("setno"));
            Long id = ORM.create().genLongId("pbs_flowrurole");
            ruRole.set("id", (Object)id);
            ruRoleList.add(ruRole);
        }
        this.generateCrossRuTask(indRoleSetList, ruRoleList);
        FLOW_RU_ROLE_ENTITY_SERVICE.save(ruRoleList.toArray(new DynamicObject[0]));
        return ruRoleList;
    }

    public void generateCrossRuTask(List<DynamicObject> indRoleSetList, List<DynamicObject> ruRoleList) {
        List<Long> crossRoleSetIdList = ruRoleList.stream().map(k -> k.getLong("crossroleset.id")).collect(Collectors.toList());
        DynamicObject[] crossRoleSetDys = CROSS_ROLESET_ENTITYSERVICE.queryCrossRoleSetByIds(crossRoleSetIdList);
        HashMap<Long, DynamicObject> crossRoleSetMap = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject crossRoleSet : crossRoleSetDys) {
            crossRoleSetMap.put(crossRoleSet.getLong("id"), crossRoleSet);
        }
        ArrayList<DynamicObject> taskList = new ArrayList<DynamicObject>(10);
        for (DynamicObject ruRole : ruRoleList) {
            DynamicObjectCollection crossHandlerColl = ((DynamicObject)crossRoleSetMap.get(ruRole.getLong("crossroleset.id"))).getDynamicObjectCollection("entryentity");
            ArrayList<Long> handlerIds = new ArrayList<Long>(10);
            for (DynamicObject crossHandler : crossHandlerColl) {
                Long handlerId = crossHandler.getLong("handlerid.id");
                if (!UserServiceHelper.isUserEnable((long)handlerId)) continue;
                handlerIds.add(handlerId);
            }
            if (CollectionUtils.isEmpty(handlerIds)) {
                String msg = String.format("batchQueryFlowRoleHandler: not found handler, roleId:%s", ruRole.getLong("id"));
                LOG.error(msg);
                ArrayList<Long> nodeHandlerList = new ArrayList<Long>(10);
                nodeHandlerList.add(0L);
                List<DynamicObject> defaultTaskList = this.generateTaskByRuRole(ruRole, nodeHandlerList, indRoleSetList);
                taskList.addAll(defaultTaskList);
                ruRole.set("rolestatus", (Object)FlowRuRoleStatusEnum.PENDING.getCode());
                continue;
            }
            taskList.addAll(this.generateTaskByRuRole(ruRole, handlerIds, indRoleSetList));
        }
        FLOW_RU_TASK_ENTITY_SERVICE.save(taskList.toArray(new DynamicObject[0]));
    }

    public List<DynamicObject> generateTaskByRuRole(DynamicObject ruRole, List<Long> handlerIds, List<DynamicObject> indRoleSetList) {
        ArrayList<DynamicObject> tasks = new ArrayList<DynamicObject>(handlerIds.size());
        Date date = new Date();
        long userId = UserServiceHelper.getCurrentUserId();
        for (Long handlerId : handlerIds) {
            DynamicObject task = FLOW_RU_TASK_ENTITY_SERVICE.generateEmptyDynamicObject();
            task.set("creator", (Object)userId);
            task.set("createtime", (Object)date);
            task.set("modifier", (Object)userId);
            task.set("modifytime", (Object)date);
            task.set("updatestatustime", (Object)date);
            task.set("flowruproc", ruRole.get("flowruproc"));
            task.set("flowrunode", ruRole.get("flowrunode"));
            task.set("flowrurole", (Object)ruRole);
            task.set("handler", (Object)handlerId);
            task.set("assessyear", ruRole.get("assessyear"));
            task.set("assessperiod", ruRole.get("assessperiod"));
            task.set("activity", ruRole.get("activity"));
            task.set("perforg", ruRole.get("perforg"));
            task.set("isreplace", (Object)Boolean.FALSE);
            if (FlowRuRoleStatusEnum.BE_WAITTING.getCode().equals(ruRole.getString("rolestatus"))) {
                task.set("taskstatus", (Object)FlowRuTaskStatusEnum.BE_WAITTING.getCode());
            } else {
                task.set("taskstatus", (Object)FlowRuTaskStatusEnum.NOT_ACTIVE.getCode());
            }
            task.set("iscrossevaluate", ruRole.get("iscrossrole"));
            DynamicObjectCollection taskIndicatorColl = task.getDynamicObjectCollection("entryentity");
            for (DynamicObject indRoleSet : indRoleSetList) {
                DynamicObject taskIndicatorDy = taskIndicatorColl.addNew();
                taskIndicatorDy.set("indicatorid", indRoleSet.get("indicatorid"));
                taskIndicatorDy.set("arearegid", indRoleSet.get("arearegid"));
            }
            if (handlerId.equals(0L)) {
                task.set("taskstatus", (Object)FlowRuTaskStatusEnum.PENDING.getCode());
            }
            tasks.add(task);
        }
        return tasks;
    }

    public Map<Long, QueryHandlerVO> queryHandlerByCross(Long nodedefId, List<Long> indicatorIds) {
        if (CollectionUtils.isEmpty(indicatorIds)) {
            return new HashMap<Long, QueryHandlerVO>(0);
        }
        Map<Long, QueryHandlerVO> resMap = indicatorIds.stream().collect(Collectors.toMap(k -> k, QueryHandlerVO::new));
        Map<String, Map<String, Object>> crossMap = CROSS_ROLESET_ENTITYSERVICE.queryAllCrossRoleSetByIndicatorList(nodedefId, indicatorIds);
        for (Map.Entry<String, Map<String, Object>> cross : crossMap.entrySet()) {
            List crossRoleSets = (List)cross.getValue().get("crossRoleSet");
            List indRoleSets = (List)cross.getValue().get("indRoleSet");
            for (DynamicObject indRole : indRoleSets) {
                QueryHandlerVO vo = resMap.get(indRole.getLong("indicatorid"));
                vo.setIndroleset(indRole);
                vo.setCrossRoleSets(crossRoleSets);
            }
        }
        return resMap;
    }

    public int deleteSetByActEvalObjs(List<Long> actEvalObjIds) {
        return CROSS_ROLESET_ENTITYSERVICE.deleteSetByActEvalObjs(actEvalObjIds);
    }

    public Map<Long, List<DynamicObject>> queryCrossNodeHandlerByRuNodes(List<DynamicObject> crossRuNodeList) {
        if (CollectionUtils.isEmpty(crossRuNodeList)) {
            return new HashMap<Long, List<DynamicObject>>(0);
        }
        ArrayList<Long> expiredRuNodeList = new ArrayList<Long>(crossRuNodeList.size());
        for (DynamicObject crossRuNode : crossRuNodeList) {
            if (!crossRuNode.getString("nodestatus").equals(FlowRuNodeStatusEnum.EXPIRED.getCode())) continue;
            expiredRuNodeList.add(crossRuNode.getLong("id"));
        }
        List ruNodeIdList = crossRuNodeList.stream().filter(e -> !e.getString("nodestatus").equals(FlowRuNodeStatusEnum.EXPIRED.getCode())).map(v -> v.getLong("id")).collect(Collectors.toList());
        QFilter taskFilter = new QFilter("flowrunode", "in", ruNodeIdList);
        DynamicObject[] taskDyns = FLOW_RU_TASK_ENTITY_SERVICE.loadTasksByCusFilter(taskFilter);
        Map fixedHandlerMap = Arrays.stream(taskDyns).filter(e -> !e.getString("taskstatus").equals(FlowRuTaskStatusEnum.EXPIRED.getCode())).collect(Collectors.groupingBy(e -> e.getLong("flowrunode.id"), Collectors.mapping(e -> e.getDynamicObject("handler"), Collectors.toList())));
        List hasTaslRuNodeIdList = Arrays.stream(taskDyns).map(tk -> tk.getLong("flowrunode.id")).collect(Collectors.toList());
        ArrayList<DynamicObject> ruNodeList = new ArrayList<DynamicObject>();
        for (DynamicObject dynamicObject : crossRuNodeList) {
            if (null == fixedHandlerMap || fixedHandlerMap.containsKey(dynamicObject.getLong("id")) || hasTaslRuNodeIdList.contains(dynamicObject.getLong("id"))) continue;
            ruNodeList.add(dynamicObject);
        }
        HashMap<Long, String> ruNodeEvaobjNodeDefMap = new HashMap<Long, String>(ruNodeList.size());
        for (DynamicObject dynamicObject : ruNodeList) {
            ruNodeEvaobjNodeDefMap.put(dynamicObject.getLong("id"), dynamicObject.getString("flowruproc.actevalobj") + dynamicObject.getString("flownodedef.id"));
        }
        HashMap<Long, List<DynamicObject>> hashMap = new HashMap<Long, List<DynamicObject>>(16);
        List list = ruNodeList.stream().map(v -> v.getLong("flowruproc.actevalobj")).collect(Collectors.toList());
        List nodeDefIdList = ruNodeList.stream().map(v -> v.getLong("flownodedef.id")).collect(Collectors.toList());
        QFilter cusFilter = new QFilter("evaobjid", "in", list);
        cusFilter.and("nodedef", "in", nodeDefIdList);
        DynamicObject[] indRoleSetDyns = INDICATOR_ROLE_SET_ENTITY_SERVICE.queryCrossRoleSetByCusFilter(cusFilter);
        HashMap evaObjNodeCrossMap = new HashMap(16);
        for (DynamicObject indRoleSet : indRoleSetDyns) {
            List<String> setNoList;
            StringBuilder stringBuilder = new StringBuilder(indRoleSet.getString("evaobjid")).append(indRoleSet.getString("nodedef.id"));
            String key = stringBuilder.toString();
            if (CollectionUtils.isEmpty((Collection)((Collection)evaObjNodeCrossMap.get(key)))) {
                setNoList = new ArrayList(10);
                setNoList.add(indRoleSet.getString("crossrolesetno"));
                evaObjNodeCrossMap.put(key, setNoList);
                continue;
            }
            setNoList = (List)evaObjNodeCrossMap.get(key);
            setNoList.add(indRoleSet.getString("crossrolesetno"));
            evaObjNodeCrossMap.put(key, setNoList);
        }
        List<String> setNoList = Arrays.stream(indRoleSetDyns).map(v -> v.getString("crossrolesetno")).collect(Collectors.toList());
        Map<String, List<DynamicObject>> crossRoleSetMap = CROSS_ROLESET_ENTITYSERVICE.queryCrossRoleSet(setNoList);
        HashMap crossRoleHandlerMap = new HashMap(crossRoleSetMap.size());
        for (Map.Entry entry : crossRoleSetMap.entrySet()) {
            List crossRoleList = (List)entry.getValue();
            ArrayList handlerDyList = new ArrayList(10);
            for (DynamicObject crossRole : crossRoleList) {
                DynamicObjectCollection handlerColl = crossRole.getDynamicObjectCollection("entryentity");
                handlerDyList.addAll(handlerColl.stream().map(v -> v.getDynamicObject("handlerid")).collect(Collectors.toList()));
            }
            crossRoleHandlerMap.put(entry.getKey(), handlerDyList);
        }
        HashMap evaObjNodeHandlerMap = new HashMap(16);
        for (Map.Entry evaObjNodeCrossEntry : evaObjNodeCrossMap.entrySet()) {
            List crossSetNoList = (List)evaObjNodeCrossEntry.getValue();
            ArrayList setNoHandlerList = new ArrayList(10);
            for (String setNo : crossSetNoList) {
                setNoHandlerList.addAll((Collection)crossRoleHandlerMap.get(setNo));
            }
            evaObjNodeHandlerMap.put(evaObjNodeCrossEntry.getKey(), setNoHandlerList);
        }
        for (Map.Entry ruNodeEntry : ruNodeEvaobjNodeDefMap.entrySet()) {
            if (expiredRuNodeList.contains(ruNodeEntry.getKey())) continue;
            hashMap.put((Long)ruNodeEntry.getKey(), (List<DynamicObject>)evaObjNodeHandlerMap.get(ruNodeEntry.getValue()));
        }
        if (null != fixedHandlerMap) {
            hashMap.putAll(fixedHandlerMap);
        }
        return hashMap;
    }
}

