/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.pbs.business.domain.workflow.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.opmc.pbs.business.ServiceFactory;
import kd.opmc.pbs.business.domain.workflow.entity.FlowCommonResultBo;
import kd.opmc.pbs.business.domain.workflow.entityservice.CrossRoleSetEntityService;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowRuNodeEntityService;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowRuProcEntityService;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowRuRoleEntityService;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowRuTaskEntityService;
import kd.opmc.pbs.business.domain.workflow.entityservice.IndicatorRoleSetEntityService;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuNodeStatusEnum;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuProcStatusEnum;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuTaskStatusEnum;
import kd.opmc.pbs.business.domain.workflow.enums.UserTypeEnum;
import kd.opmc.pbs.business.domain.workflow.model.FlowDefNodeBo;
import kd.opmc.pbs.business.domain.workflow.model.RuNodeBo;
import kd.opmc.pbs.business.domain.workflow.model.RuNodeTaskBo;
import kd.opmc.pbs.business.domain.workflow.model.WorkflowBo;
import kd.opmc.pbs.business.domain.workflow.service.FlowBatchHandlerDomainService;
import kd.opmc.pbs.business.domain.workflow.service.FlowDefProcDomainService;
import kd.opmc.pbs.business.external.epa.IEPAPerfWorkflowService;

public class FlowAssistDomainService {
    private static final Log LOGGER = LogFactory.getLog(FlowAssistDomainService.class);
    private static final FlowRuNodeEntityService FLOW_RU_NODE_ENTITY_SERVICE = FlowRuNodeEntityService.getInstance();
    private static final FlowRuTaskEntityService FLOW_RU_TASK_ENTITY_SERVICE = FlowRuTaskEntityService.getInstance();
    private static final FlowRuProcEntityService FLOW_RU_PROC_ENTITY_SERVICE = FlowRuProcEntityService.getInstance();
    private static final FlowDefProcDomainService FLOW_DEF_PROC_DOMAIN_SERVICE = FlowDefProcDomainService.getInstance();
    private static final FlowRuRoleEntityService FLOW_RU_ROLE_ENTITY_SERVICE = FlowRuRoleEntityService.getInstance();
    private static final CrossRoleSetEntityService CROSS_ROLE_SET_ENTITY_SERVICE = CrossRoleSetEntityService.getInstance();
    private static final IndicatorRoleSetEntityService INDICATOR_ROLE_SET_ENTITY_SERVICE = IndicatorRoleSetEntityService.getInstance();
    private static final IEPAPerfWorkflowService PERFWORKFLOW_SERVICE = IEPAPerfWorkflowService.getInstance();
    private static final FlowBatchHandlerDomainService FLOW_BATCH_HANDLER_DOMAIN_SERVICE = FlowBatchHandlerDomainService.getInstance();

    public static FlowAssistDomainService getInstance() {
        return ServiceFactory.getService(FlowAssistDomainService.class);
    }

    public List<RuNodeTaskBo> getRuNodeAndTask(List<Long> evaObjList) {
        ArrayList<RuNodeTaskBo> ruNodeTaskBoList = new ArrayList<RuNodeTaskBo>(10);
        DynamicObject[] ruProcDyns = FLOW_RU_PROC_ENTITY_SERVICE.queryEvaluateProcByEvaObjIds(evaObjList);
        List<Long> procIdList = Arrays.stream(ruProcDyns).map(proc -> proc.getLong("id")).distinct().collect(Collectors.toList());
        DynamicObject[] ruNodeDyns = FLOW_RU_NODE_ENTITY_SERVICE.queryAllNodeByProcIds(procIdList.toArray(new Long[0]));
        DynamicObject[] taskDyns = FLOW_RU_TASK_ENTITY_SERVICE.queryToImportScoreTasks(procIdList);
        Map<Long, List<DynamicObject>> ruNodeMap = Arrays.stream(ruNodeDyns).collect(Collectors.groupingBy(ev -> ev.getLong("flowruproc.id")));
        Map<Long, List<DynamicObject>> ruTaskMap = Arrays.stream(taskDyns).collect(Collectors.groupingBy(ev -> ev.getLong("flowrunode.id")));
        for (DynamicObject ruProc : ruProcDyns) {
            RuNodeTaskBo ruNodeTaskBo = new RuNodeTaskBo();
            ruNodeTaskBo.setEvaObj(ruProc.getLong("actevalobj"));
            ruNodeTaskBo.setRuProc(ruProc.getLong("id"));
            ArrayList<RuNodeBo> nodeBoList = new ArrayList<RuNodeBo>(10);
            for (DynamicObject ruNode : ruNodeMap.get(ruProc.getLong("id"))) {
                RuNodeBo ruNodeBo = new RuNodeBo();
                ruNodeBo.setRuNodeId(ruNode.getLong("id"));
                ruNodeBo.setNodeType(ruNode.getLong("flownodedef.nodetype.id"));
                ruNodeBo.setNodeStatus(FlowRuNodeStatusEnum.getFlowRuNodeStatusByCode(ruNode.getString("nodestatus")));
                List<DynamicObject> ruTaskList = ruTaskMap.get(ruNode.getLong("id"));
                if (!CollectionUtils.isEmpty(ruTaskList)) {
                    List<Long> taskIdList = ruTaskList.stream().map(task -> task.getLong("id")).collect(Collectors.toList());
                    ruNodeBo.setRuTaskIdList(taskIdList);
                }
                nodeBoList.add(ruNodeBo);
            }
            ruNodeTaskBo.setNodeBoList(nodeBoList);
            ruNodeTaskBoList.add(ruNodeTaskBo);
        }
        return ruNodeTaskBoList;
    }

    public List<Long> getBeWaittingSendActEvaObjIdListByActivity(Long activityId) {
        ArrayList<Long> evaObjIdList = new ArrayList(10);
        QFilter filter = new QFilter("activity", "=", (Object)activityId);
        filter.and(new QFilter("taskstatus", "=", (Object)FlowRuTaskStatusEnum.BE_WAITTING.getCode()));
        filter.and(new QFilter("flowruproc.procstatus", "!=", (Object)FlowRuProcStatusEnum.DEPRECATED.getCode()));
        DynamicObject[] ruTaskDynArr = FLOW_RU_TASK_ENTITY_SERVICE.queryOriginalArray("id,flowruproc.id,flowruproc.actevalobj", new QFilter[]{filter});
        evaObjIdList = Arrays.stream(ruTaskDynArr).map(dy -> dy.getLong("flowruproc.actevalobj")).collect(Collectors.toList());
        return evaObjIdList;
    }

    public Map<Long, Boolean> hasToBeSendTaskFormulate(List<Long> actEvalObjs) {
        return this.hasToBeSendTaskByActEvalObjs(actEvalObjs, "1");
    }

    public Map<Long, Boolean> hasToBeSendTaskEvaluate(List<Long> actEvalObjs) {
        return this.hasToBeSendTaskByActEvalObjs(actEvalObjs, "2");
    }

    private Map<Long, Boolean> hasToBeSendTaskByActEvalObjs(List<Long> actEvalObjs, String workflowType) {
        Map<Long, Boolean> resultMap = actEvalObjs.stream().collect(Collectors.toMap(k -> k, v -> Boolean.FALSE));
        DynamicObject[] tasks = FLOW_RU_TASK_ENTITY_SERVICE.queryBeWattingTaskByActevalObj(actEvalObjs, workflowType);
        Map actObjWattingTaskMap = Arrays.stream(tasks).collect(Collectors.groupingBy(k -> k.getLong("flowruproc.actevalobj"), Collectors.toList()));
        actObjWattingTaskMap.forEach((K, V) -> resultMap.computeIfPresent((Long)K, (k, v) -> Boolean.TRUE));
        return resultMap;
    }

    public boolean batchRefreshRunproc(List<Long> fomulateInsIdList, List<Long> evalflowInsIdList, Long epaWorkflowId) {
        try {
            LOGGER.info("\u3010OPMC\u3011-fomulateInsIdList :{},evalflowInsIdList : {},epaWorkflowId : {}", new Object[]{fomulateInsIdList, evalflowInsIdList, epaWorkflowId});
            DynamicObject[] fomulateRuProcDyns = FLOW_RU_PROC_ENTITY_SERVICE.queryProcByPkIds(fomulateInsIdList);
            DynamicObject[] evaluRuProcDyns = FLOW_RU_PROC_ENTITY_SERVICE.queryProcByPkIds(evalflowInsIdList);
            ArrayList<Long> pbsflowIds = new ArrayList<Long>(10);
            for (DynamicObject fomulateRuProc : fomulateRuProcDyns) {
                pbsflowIds.add(fomulateRuProc.getLong("flowv.id"));
            }
            for (DynamicObject evaluRuProc : evaluRuProcDyns) {
                pbsflowIds.add(evaluRuProc.getLong("flowv.id"));
            }
            ArrayList<Long> targetWorkflowIdList = new ArrayList<Long>(10);
            DynamicObject[] perfWorkflowDynColl = PERFWORKFLOW_SERVICE.getPerfWorkflowsByVid(Collections.singletonList(epaWorkflowId));
            if (perfWorkflowDynColl.length > 0) {
                DynamicObjectCollection targetWorkflowColl = perfWorkflowDynColl[0].getDynamicObjectCollection("flowentry");
                for (DynamicObject targetWorkflow : targetWorkflowColl) {
                    targetWorkflowIdList.add(targetWorkflow.getLong("flowvid"));
                }
            }
            LOGGER.info("\u3010OPMC\u3011-targetWorkflowIdList : {}", targetWorkflowIdList);
            List<WorkflowBo> targetWorkflowBoList = FLOW_DEF_PROC_DOMAIN_SERVICE.getPbsWorkflowCollByIds(targetWorkflowIdList);
            HashMap<Long, Long> pbsWorkflowMap = new HashMap<Long, Long>(16);
            HashMap<Long, Long> flowdefProcMap = new HashMap<Long, Long>(16);
            HashMap<Long, Long> flowdefNodeMap = new HashMap<Long, Long>(16);
            HashMap<Long, Long> flowdefRoleMap = new HashMap<Long, Long>(16);
            List<WorkflowBo> sourceWorkflowBoList = FLOW_DEF_PROC_DOMAIN_SERVICE.getPbsWorkflowCollByIds(pbsflowIds);
            Map<Long, WorkflowBo> sourceWorkflowBoMap = sourceWorkflowBoList.stream().collect(Collectors.toMap(ko -> ko.getWorkflowDyn().getLong("id"), vo -> vo));
            HashMap<Long, List<FlowDefNodeBo>> targetFlowDefNodeBoMap = new HashMap<Long, List<FlowDefNodeBo>>(16);
            HashMap<Long, List<FlowDefNodeBo>> sourceFlowDefNodeBoMap = new HashMap<Long, List<FlowDefNodeBo>>(16);
            for (WorkflowBo workflowBo : targetWorkflowBoList) {
                DynamicObject pbsWorkflowDy = workflowBo.getWorkflowDyn();
                LOGGER.info("\u3010OPMC\u3011-pbsWorkflowMap,sourceflowid is  : {},new flowid is \uff1a{}", (Object)pbsWorkflowDy.getLong("sourceflowid"), (Object)pbsWorkflowDy.getLong("id"));
                pbsWorkflowMap.put(pbsWorkflowDy.getLong("sourceflowid"), pbsWorkflowDy.getLong("id"));
                DynamicObjectCollection targetPbsflowEntryColl = pbsWorkflowDy.getDynamicObjectCollection("entryentity");
                WorkflowBo sourceWorkflowBo = sourceWorkflowBoMap.get(pbsWorkflowDy.getLong("sourceflowid"));
                if (null == sourceWorkflowBo) continue;
                DynamicObjectCollection sourcePbsflowEntryColl = sourceWorkflowBo.getWorkflowDyn().getDynamicObjectCollection("entryentity");
                Long sourceFlowDefProcId = ((DynamicObject)sourcePbsflowEntryColl.get(0)).getLong("flowdefproc");
                Long targetFlowDefProcId = ((DynamicObject)targetPbsflowEntryColl.get(0)).getLong("flowdefproc");
                flowdefProcMap.put(sourceFlowDefProcId, targetFlowDefProcId);
                targetFlowDefNodeBoMap.put(targetFlowDefProcId, workflowBo.getFlowdefNodeBoList());
                sourceFlowDefNodeBoMap.put(sourceFlowDefProcId, sourceWorkflowBo.getFlowdefNodeBoList());
            }
            for (Map.Entry entry : sourceFlowDefNodeBoMap.entrySet()) {
                List sourceFlowDefNodeBoList = (List)entry.getValue();
                List targetFlowDefNodeBoList = (List)targetFlowDefNodeBoMap.get(flowdefProcMap.get(entry.getKey()));
                for (FlowDefNodeBo sourceDefNodeBo : sourceFlowDefNodeBoList) {
                    DynamicObject sourceFlowDefNodeDyn = sourceDefNodeBo.getFlowdefNodeDyn();
                    targetFlowDefNodeBoList.forEach(targetDefNodeBo -> {
                        DynamicObject targetFlowDefNodeDyn = targetDefNodeBo.getFlowdefNodeDyn();
                        if (sourceFlowDefNodeDyn.getString("nodename").equals(targetFlowDefNodeDyn.getString("nodename"))) {
                            flowdefNodeMap.put(sourceFlowDefNodeDyn.getLong("id"), targetFlowDefNodeDyn.getLong("id"));
                            DynamicObjectCollection sourceDefRoleDynColl = sourceDefNodeBo.getFlowdefRoleDynColl();
                            DynamicObjectCollection targetDefRoleDynColl = targetDefNodeBo.getFlowdefRoleDynColl();
                            for (DynamicObject sourceDefRole : sourceDefRoleDynColl) {
                                for (DynamicObject targetDefRole : targetDefRoleDynColl) {
                                    if (!sourceDefRole.getString("rolename").equals(targetDefRole.getString("rolename"))) continue;
                                    flowdefRoleMap.put(sourceDefRole.getLong("id"), targetDefRole.getLong("id"));
                                }
                            }
                        }
                    });
                }
            }
            this.updateWorkflowData(fomulateInsIdList, evalflowInsIdList, epaWorkflowId, fomulateRuProcDyns, evaluRuProcDyns, pbsWorkflowMap, flowdefProcMap, flowdefNodeMap, flowdefRoleMap);
        }
        catch (Exception e) {
            LOGGER.error("\u3010OPMC\u3011-batchRefreshRunproc error.", (Throwable)e);
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateWorkflowData(List<Long> fomulateInsIdList, List<Long> evalflowInsIdList, Long epaWorkflowId, DynamicObject[] fomulateRuProcDyns, DynamicObject[] evaluRuProcDyns, Map<Long, Long> pbsWorkflowMap, Map<Long, Long> flowdefProcMap, Map<Long, Long> flowdefNodeMap, Map<Long, Long> flowdefRoleMap) {
        String fomulateSettingMode = FLOW_DEF_PROC_DOMAIN_SERVICE.getHandlerSettingMode(epaWorkflowId, "1");
        String evaluSettingMode = FLOW_DEF_PROC_DOMAIN_SERVICE.getHandlerSettingMode(epaWorkflowId, "4");
        DynamicObject[] fomulateRuNodeDyns = FLOW_RU_NODE_ENTITY_SERVICE.queryByProcIds(fomulateInsIdList);
        DynamicObject[] evaluRuNodeDyns = FLOW_RU_NODE_ENTITY_SERVICE.queryByProcIds(evalflowInsIdList);
        DynamicObject[] fomulateRuRoleDyns = FLOW_RU_ROLE_ENTITY_SERVICE.queryByRuProcIds(fomulateInsIdList);
        DynamicObject[] evaluRuRoleDyns = FLOW_RU_ROLE_ENTITY_SERVICE.queryByRuProcIds(evalflowInsIdList);
        ArrayList<Long> crossNodeIdList = new ArrayList<Long>(10);
        try (TXHandle txhandle = TX.required();){
            this.updateRuProcData(fomulateRuProcDyns, pbsWorkflowMap, flowdefProcMap, fomulateSettingMode);
            this.updateRuProcData(evaluRuProcDyns, pbsWorkflowMap, flowdefProcMap, evaluSettingMode);
            this.updateRuNodeData(crossNodeIdList, fomulateRuNodeDyns, flowdefNodeMap);
            this.updateRuNodeData(crossNodeIdList, evaluRuNodeDyns, flowdefNodeMap);
            this.updateRuRoleData(fomulateRuRoleDyns, flowdefRoleMap);
            this.updateRuRoleData(evaluRuRoleDyns, flowdefRoleMap);
            this.updateCrossRoleSetData(flowdefNodeMap, flowdefRoleMap, crossNodeIdList);
        }
    }

    protected void updateRuProcData(DynamicObject[] ruProcDyns, Map<Long, Long> pbsWorkflowMap, Map<Long, Long> flowdefProcMap, String settingMode) {
        for (DynamicObject ruProc : ruProcDyns) {
            if (null == pbsWorkflowMap.get(ruProc.getLong("flowv.id"))) continue;
            LOGGER.info("\u3010OPMC\u3011-updateRuProcData,ruProcId is : {} ,sourceFlowVid is  : {},new flowvid is \uff1a{}", new Object[]{ruProc.getLong("id"), ruProc.getLong("flowv.id"), pbsWorkflowMap.get(ruProc.getLong("flowv.id"))});
            ruProc.set("flowv", (Object)pbsWorkflowMap.get(ruProc.getLong("flowv.id")));
            ruProc.set("defproc", (Object)flowdefProcMap.get(ruProc.getLong("defproc.id")));
            ruProc.set("settingmode", (Object)settingMode);
        }
        if (ruProcDyns.length > 0) {
            FLOW_RU_PROC_ENTITY_SERVICE.save(ruProcDyns);
        }
    }

    protected void updateRuNodeData(List<Long> crossNodeIdList, DynamicObject[] ruNodeDyns, Map<Long, Long> flowdefNodeMap) {
        for (DynamicObject ruNode : ruNodeDyns) {
            if (null == flowdefNodeMap.get(ruNode.getLong("flownodedef.id"))) continue;
            LOGGER.info("\u3010OPMC\u3011-updateRuNodeData,ruNodeId is : {} ,sourceDefNode is  : {},new defNode is \uff1a{}", new Object[]{ruNode.getLong("id"), ruNode.getLong("flownodedef.id"), flowdefNodeMap.get(ruNode.getLong("flownodedef.id"))});
            ruNode.set("flownodedef", (Object)flowdefNodeMap.get(ruNode.getLong("flownodedef.id")));
            if (!ruNode.getBoolean("iscrossnode")) continue;
            crossNodeIdList.add(ruNode.getLong("flownodedef.id"));
        }
        if (ruNodeDyns.length > 0) {
            FLOW_RU_NODE_ENTITY_SERVICE.save(ruNodeDyns);
        }
    }

    protected void updateRuRoleData(DynamicObject[] ruRoleDyns, Map<Long, Long> flowdefRoleMap) {
        for (DynamicObject ruRole : ruRoleDyns) {
            if (null == flowdefRoleMap.get(ruRole.getLong("flowdefrole.id"))) continue;
            LOGGER.info("\u3010OPMC\u3011-updateRuRoleData,ruRoleId is : {} ,sourceDefRole is  : {},new defRole is \uff1a{}", new Object[]{ruRole.getLong("id"), ruRole.getLong("flowdefrole.id"), flowdefRoleMap.get(ruRole.getLong("flowdefrole.id"))});
            ruRole.set("flowdefrole", (Object)flowdefRoleMap.get(ruRole.getLong("flowdefrole.id")));
        }
        if (ruRoleDyns.length > 0) {
            FLOW_RU_ROLE_ENTITY_SERVICE.save(ruRoleDyns);
        }
    }

    protected void updateCrossRoleSetData(Map<Long, Long> flowdefNodeMap, Map<Long, Long> flowdefRoleMap, List<Long> crossNodeIdList) {
        DynamicObject[] crossRoleSetDys = CROSS_ROLE_SET_ENTITY_SERVICE.queryCrossRoleSetByDefNodeIds(crossNodeIdList);
        QFilter cusFilter = new QFilter("nodedef", "in", crossNodeIdList);
        DynamicObject[] indicatorRoleSetDys = INDICATOR_ROLE_SET_ENTITY_SERVICE.queryCrossRoleSetByCusFilter(cusFilter);
        for (DynamicObject crossRoleSetDy : crossRoleSetDys) {
            if (null != flowdefNodeMap.get(crossRoleSetDy.getLong("nodedef"))) {
                LOGGER.info("\u3010OPMC\u3011-updateCrossRoleSetData,crossRoleSet Id is : {} ,sourceNodeDef is  : {},new nodeDef is \uff1a{}", new Object[]{crossRoleSetDy.getLong("id"), crossRoleSetDy.getLong("nodedef"), flowdefNodeMap.get(crossRoleSetDy.getLong("nodedef"))});
                crossRoleSetDy.set("nodedef", (Object)flowdefNodeMap.get(crossRoleSetDy.getLong("nodedef")));
            }
            if (null == flowdefRoleMap.get(crossRoleSetDy.getLong("defroleid"))) continue;
            LOGGER.info("\u3010OPMC\u3011-updateCrossRoleSetData,crossRoleSet Id is : {} ,sourceDefRole is  : {},new defRole is \uff1a{}", new Object[]{crossRoleSetDy.getLong("id"), crossRoleSetDy.getLong("defroleid"), flowdefRoleMap.get(crossRoleSetDy.getLong("defroleid"))});
            crossRoleSetDy.set("defroleid", (Object)flowdefRoleMap.get(crossRoleSetDy.getLong("defroleid")));
        }
        if (crossRoleSetDys.length > 0) {
            CROSS_ROLE_SET_ENTITY_SERVICE.save(crossRoleSetDys);
        }
        for (DynamicObject indicatorRoleSetDy : indicatorRoleSetDys) {
            if (null == flowdefNodeMap.get(indicatorRoleSetDy.getLong("nodedef"))) continue;
            LOGGER.info("\u3010OPMC\u3011-updateCrossRoleSetData,indicatorRoleSet Id is : {} ,sourceNodeDef is  : {},new nodeDef is \uff1a{}", new Object[]{indicatorRoleSetDy.getLong("id"), indicatorRoleSetDy.getLong("nodedef"), flowdefRoleMap.get(flowdefNodeMap.get(indicatorRoleSetDy.getLong("nodedef")))});
            indicatorRoleSetDy.set("nodedef", (Object)flowdefNodeMap.get(indicatorRoleSetDy.getLong("nodedef")));
        }
        if (indicatorRoleSetDys.length > 0) {
            INDICATOR_ROLE_SET_ENTITY_SERVICE.save(indicatorRoleSetDys);
        }
    }

    public List<FlowCommonResultBo> verifyUserIsValid(List<Long> userIdList, UserTypeEnum userTypeEnum) {
        ArrayList<FlowCommonResultBo> resultList;
        block7: {
            FlowCommonResultBo resultBo;
            String inValidMsg;
            block6: {
                resultList = new ArrayList<FlowCommonResultBo>(10);
                if (CollectionUtils.isEmpty(userIdList)) {
                    LOGGER.error("\u3010OPMC\u3011-invoke verifyUserIsValid, userIdList is null,tracId={}", (Object)RequestContext.get().getTraceId());
                    return resultList;
                }
                inValidMsg = ResManager.loadKDString((String)"\u6240\u9009\u5904\u7406\u4eba\u5728\u5e73\u53f0\u8d26\u53f7\u5b58\u5728\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"FlowAssistDomainService_1", (String)"opmc-pbs-business", (Object[])new Object[0]);
                if (!userTypeEnum.getCode().equals(UserTypeEnum.PLATFORM_USER.getCode())) break block6;
                Map<Long, Boolean> userValidMap = FLOW_BATCH_HANDLER_DOMAIN_SERVICE.batchQueryUserIsEnable(userIdList);
                for (Map.Entry<Long, Boolean> entry : userValidMap.entrySet()) {
                    FlowCommonResultBo resultBo2 = new FlowCommonResultBo();
                    resultBo2.setDataId(entry.getKey());
                    resultBo2.setCode(entry.getValue() != false ? "1" : "-1");
                    resultBo2.setMessage(entry.getValue() != false ? "SUCCESS" : inValidMsg);
                    resultList.add(resultBo2);
                }
                break block7;
            }
            if (!userTypeEnum.getCode().equals(UserTypeEnum.HRPI_PERSON.getCode())) break block7;
            Map<Long, Long> validUserMap = FLOW_BATCH_HANDLER_DOMAIN_SERVICE.getUserIdsByPersonIds(userIdList);
            if (null != validUserMap) {
                for (Map.Entry entry : validUserMap.entrySet()) {
                    resultBo = new FlowCommonResultBo();
                    resultBo.setDataId((Long)entry.getKey());
                    resultBo.setCode("1");
                    resultBo.setMessage("SUCCESS");
                    resultList.add(resultBo);
                    userIdList.remove(entry.getKey());
                }
            }
            if (!CollectionUtils.isEmpty(userIdList)) {
                for (Long l : userIdList) {
                    resultBo = new FlowCommonResultBo();
                    resultBo.setDataId(l);
                    resultBo.setCode("-1");
                    resultBo.setMessage(inValidMsg);
                    resultList.add(resultBo);
                }
            }
        }
        return resultList;
    }
}

