/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.pbs.business.domain.workflow.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.toolkit.utils.SerializationUtils;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.opmc.pbs.business.ServiceFactory;
import kd.opmc.pbs.business.domain.msg.service.MsgSendDomainService;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowDefNodeEntityService;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowDefRoleEntityService;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowRuNodeEntityService;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowRuProcEntityService;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowRuRoleEntityService;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowRuTaskEntityService;
import kd.opmc.pbs.business.domain.workflow.service.FlowRuProcBatchDomainService;
import kd.opmc.pbs.business.domain.workflow.service.FlowRuProcDomainService;
import kd.opmc.pbs.business.domain.workflow.service.FlowRuSecondDomainService;
import kd.opmc.pbs.business.domain.workflow.service.FlowRunSupDomainService;
import kd.opmc.pbs.business.domain.workflow.utils.WorkflowUtils;
import kd.opmc.pbs.business.external.epa.IEPAActevalobjService;
import kd.opmc.pbs.business.external.epa.IEPAAssessActivityService;
import kd.opmc.pbs.business.external.epa.IEPARoleTypeService;
import kd.opmc.pbs.business.external.epa.po.RoleTypeCustomPo;
import kd.opmc.pbs.business.external.hrpi.IHRPIPersonService;
import kd.opmc.pbs.business.external.hrpi.IHRPIWorkRoleService;
import kd.opmc.pbs.business.model.HandlerBatchParamsBo;
import kd.opmc.pbs.common.constants.RoleTypeConstants;
import kd.opmc.pbs.common.utils.CommonWorkflowCacheBo;

public class FlowBatchHandlerDomainService {
    private static final Log LOG = LogFactory.getLog(FlowBatchHandlerDomainService.class);
    protected static final FlowRuProcEntityService FLOW_RU_PROC_ENTITY_SERVICE = FlowRuProcEntityService.getInstance();
    protected static final IHRPIPersonService PERSON_SERVICE = IHRPIPersonService.getInstance();
    protected static final IHRPIWorkRoleService WORK_ROLE_SERVICE = IHRPIWorkRoleService.getInstance();
    protected static final FlowDefRoleEntityService FLOW_DEF_ROLE_ENTITY_SERVICE = FlowDefRoleEntityService.getInstance();
    protected static final FlowDefNodeEntityService FLOW_DEF_NODE_ENTITY_SERVICE = FlowDefNodeEntityService.getInstance();
    protected static final IEPAAssessActivityService ACTIVITY_SERVICE = IEPAAssessActivityService.getInstance();
    protected static final FlowRuNodeEntityService FLOW_RU_NODE_ENTITY_SERVICE = FlowRuNodeEntityService.getInstance();
    protected static final FlowRuRoleEntityService FLOW_RU_ROLE_ENTITY_SERVICE = FlowRuRoleEntityService.getInstance();
    protected static final FlowRuTaskEntityService FLOW_RU_TASK_ENTITY_SERVICE = FlowRuTaskEntityService.getInstance();
    protected static final FlowRunSupDomainService FLOW_RUSUP_DOMAIN_SERVICE = FlowRunSupDomainService.getInstance();
    protected static final MsgSendDomainService MSG_SEND_DOMAIN_SERVICE = MsgSendDomainService.getInstance();
    protected static final FlowRuSecondDomainService FLOW_RUSECOND_DOMAIN_SERVICE = FlowRuSecondDomainService.getInstance();
    protected static final IEPARoleTypeService EPA_ROLETYPE_SERVICE = IEPARoleTypeService.getInstance();
    protected static final FlowRuProcDomainService FLOW_RU_PROC_DOMAIN_SERVICE = FlowRuProcDomainService.getInstance();
    private static Map<Long, Function<HandlerBatchParamsBo, Map<Long, List<Long>>>> roleTypeHandlerMap;
    private static int INT_TEN;
    private static final String ISFORBIDDEN = "isforbidden";

    public static FlowBatchHandlerDomainService getInstance() {
        return ServiceFactory.getService(FlowBatchHandlerDomainService.class);
    }

    public boolean queryUserIsEnable(Long appointId) {
        List userInfo = UserServiceHelper.get(Collections.singletonList(appointId), (String[])new String[]{ISFORBIDDEN, "enable"}, null);
        if (CollectionUtils.isEmpty((Collection)userInfo)) {
            return false;
        }
        Map userInfoMap = (Map)userInfo.get(0);
        String enable = (String)userInfoMap.get("enable");
        return (Boolean)userInfoMap.get(ISFORBIDDEN) == false && "1".equals(enable);
    }

    public Map<Long, Boolean> batchQueryUserIsEnable(List<Long> userIds) {
        List userInfo = UserServiceHelper.get(userIds, (String[])new String[]{"id", ISFORBIDDEN, "enable"}, null);
        HashMap<Long, Boolean> ret = new HashMap<Long, Boolean>(16);
        if (CollectionUtils.isEmpty((Collection)userInfo)) {
            return ret;
        }
        for (Map user : userInfo) {
            ret.put((Long)user.get("id"), (Boolean)user.get(ISFORBIDDEN) == false && "1".equals(user.get("enable")));
        }
        return ret;
    }

    public Map<Long, List<Long>> batchQueryFlowRoleHandler(List<DynamicObject> ruRoleList, Map<Long, DynamicObject> ruRoleProcMap) {
        long start = System.currentTimeMillis();
        Map<Long, List<Long>> resultMap = new HashMap<Long, List<Long>>(16);
        Map roleDefMap = ruRoleList.stream().collect(Collectors.groupingBy(k -> k.getLong("flowdefrole_id"), Collectors.toList()));
        List roleDefIdList = ruRoleList.stream().map(k -> k.getLong("flowdefrole_id")).distinct().collect(Collectors.toList());
        HashMap<Long, Long> roleDefWorkflowMap = new HashMap<Long, Long>(roleDefIdList.size());
        for (DynamicObject ruRole : ruRoleList) {
            roleDefWorkflowMap.computeIfAbsent(ruRole.getLong("flowdefrole_id"), v -> ((DynamicObject)ruRoleProcMap.get(ruRole.getLong("id"))).getLong("id"));
        }
        ArrayList<Long> needQueryDefIdList = new ArrayList<Long>(10);
        FlowRuProcBatchDomainService FLOW_RU_PROC_BATCH_DOMAIN_SERVICE = new FlowRuProcBatchDomainService();
        for (Long l : roleDefIdList) {
            Long workflowId = (Long)roleDefWorkflowMap.get(l);
            CommonWorkflowCacheBo wfCacheBo = FLOW_RU_PROC_BATCH_DOMAIN_SERVICE.getWorkflowMap(workflowId);
            if (!HRObjectUtils.isEmpty((Object)wfCacheBo) && !HRObjectUtils.isEmpty((Object)wfCacheBo.getFlowRoleDefMap()) && !HRObjectUtils.isEmpty(wfCacheBo.getFlowRoleDefMap().get(l))) continue;
            needQueryDefIdList.add(l);
        }
        if (needQueryDefIdList.size() > 0) {
            DynamicObject[] roleDefDyns = FLOW_DEF_ROLE_ENTITY_SERVICE.queryRoleDefByPks(needQueryDefIdList.toArray(new Long[needQueryDefIdList.size()]));
            FLOW_RU_PROC_BATCH_DOMAIN_SERVICE.initializWorkflowDefRoleMap(roleDefDyns, roleDefWorkflowMap);
        }
        if (null == roleTypeHandlerMap || roleTypeHandlerMap.isEmpty()) {
            roleTypeHandlerMap = this.initroleTypeBatchHandlerMap();
        }
        for (Map.Entry entry : roleDefMap.entrySet()) {
            Long roleDefId = (Long)entry.getKey();
            Long workflowId = (Long)roleDefWorkflowMap.get(roleDefId);
            DynamicObject flowDefRole = (DynamicObject)FLOW_RU_PROC_BATCH_DOMAIN_SERVICE.getWorkflowMap(workflowId).getFlowRoleDefMap().get(roleDefId);
            HandlerBatchParamsBo handerParamsBo = new HandlerBatchParamsBo();
            handerParamsBo.setFlowRuRoles(roleDefMap.get(roleDefId));
            HashMap<Long, DynamicObject> ruRoleProcTmpMap = new HashMap<Long, DynamicObject>(16);
            for (DynamicObject dynamicObject : roleDefMap.get(roleDefId)) {
                ruRoleProcTmpMap.put(dynamicObject.getLong("id"), ruRoleProcMap.get(dynamicObject.getLong("id")));
            }
            if (null == roleTypeHandlerMap.get(flowDefRole.getLong("roletype.id"))) {
                for (Map.Entry entry2 : ruRoleProcTmpMap.entrySet()) {
                    Map<Long, List<Long>> cusHandlerMap = WorkflowUtils.getUserIdByUserDefRoleType(flowDefRole.getLong("roletype.id"), (DynamicObject)entry2.getValue());
                    assert (cusHandlerMap != null);
                    resultMap.put((Long)entry2.getKey(), cusHandlerMap.get(((DynamicObject)entry2.getValue()).getLong("id")));
                }
                continue;
            }
            handerParamsBo.setRuRoleProcMap(ruRoleProcTmpMap);
            handerParamsBo.setFlowDefRole(flowDefRole);
            handerParamsBo.setReplace(Boolean.FALSE);
            Long roleTypeId = flowDefRole.getLong("roletype.id");
            resultMap.putAll(roleTypeHandlerMap.get(roleTypeId).apply(handerParamsBo));
        }
        long end = System.currentTimeMillis();
        LOG.info("FlowBatchHandlerDomainService.batchQueryFlowRoleHandler takes time : " + (end - start) + " ms");
        LOG.info("\u3010OPMC\u3011-batchQueryFlowRoleHandler before dealUserEffectiveAndRemoveDuplicate :{}", (Object)resultMap.toString());
        resultMap = this.dealUserEffectiveAndRemoveDuplicate(resultMap);
        LOG.info("\u3010OPMC\u3011-FlowBatchHandlerDomainService.batchQueryFlowRoleHandler after dealUserEffectiveAndRemoveDuplicate :{}", (Object)resultMap.toString());
        return resultMap;
    }

    public Map<Long, List<Long>> queryReplaceFlowRoleHandler(List<DynamicObject> ruRoleList, Map<Long, DynamicObject> ruRoleProcMap) {
        DynamicObject[] flowDefNodeArr;
        long start = System.currentTimeMillis();
        Map<Long, List<Long>> resultMap = new HashMap<Long, List<Long>>(16);
        if (null == roleTypeHandlerMap || roleTypeHandlerMap.isEmpty()) {
            roleTypeHandlerMap = this.initroleTypeBatchHandlerMap();
        }
        Map<Object, Object> roleNodeMap = new HashMap(16);
        roleNodeMap = ruRoleList.stream().collect(Collectors.groupingBy(e -> e.getLong("flowrunode.flownodedef.id"), Collectors.toList()));
        HashSet<Long> nodeDefSet = new HashSet<Long>(16);
        for (DynamicObject dynamicObject : ruRoleList) {
            long ruNodeId = 0L;
            try {
                ruNodeId = dynamicObject.getLong("flowrunode.flownodedef.id");
                if (ruNodeId == 0L) {
                    ruNodeId = dynamicObject.getLong("flowrunode.flownodedef");
                }
            }
            catch (Exception e2) {
                ruNodeId = dynamicObject.getLong("flowrunode.flownodedef");
            }
            nodeDefSet.add(ruNodeId);
        }
        for (DynamicObject nodeDef : flowDefNodeArr = FLOW_DEF_NODE_ENTITY_SERVICE.getFlowDefNode(nodeDefSet.stream().collect(Collectors.toList()))) {
            HandlerBatchParamsBo handerParamsBo = new HandlerBatchParamsBo();
            List ruRolesTmp = (List)roleNodeMap.get(nodeDef.getLong("id"));
            handerParamsBo.setFlowRuRoles(ruRolesTmp);
            HashMap<Long, DynamicObject> ruRoleProcMapTmp = new HashMap<Long, DynamicObject>(ruRolesTmp.size());
            for (DynamicObject ruRoleTp : ruRolesTmp) {
                ruRoleProcMapTmp.put(ruRoleTp.getLong("id"), ruRoleProcMap.get(ruRoleTp.getLong("id")));
            }
            handerParamsBo.setRuRoleProcMap(ruRoleProcMapTmp);
            handerParamsBo.setFlowDefNode(nodeDef);
            handerParamsBo.setReplace(Boolean.TRUE);
            Long handlerType = 0L;
            try {
                handlerType = nodeDef.getLong("handlertype.id");
            }
            catch (Exception e3) {
                LOG.error("[OPMC\u3011-queryReplaceFlowRoleHandler,get handlertype error,msg :", (Throwable)e3);
            }
            if (null == roleTypeHandlerMap.get(handlerType)) {
                for (DynamicObject ruRoleTmp : ruRolesTmp) {
                    DynamicObject ruProcTmp = ruRoleProcMap.get(ruRoleTmp.getLong("id"));
                    Map<Long, List<Long>> cusHandlerMap = WorkflowUtils.getUserIdByUserDefRoleType(handlerType, ruProcTmp);
                    assert (cusHandlerMap != null);
                    resultMap.put(ruRoleTmp.getLong("id"), cusHandlerMap.get(ruProcTmp.getLong("id")));
                }
                continue;
            }
            resultMap.putAll(roleTypeHandlerMap.get(handlerType).apply(handerParamsBo));
        }
        LOG.info("\u3010OPMC\u3011-FlowBatchHandlerDomainService.queryReplaceFlowRoleHandler before dealUserEffectiveAndRemoveDuplicate :{}", (Object)resultMap.toString());
        resultMap = this.dealUserEffectiveAndRemoveDuplicate(resultMap);
        LOG.info("\u3010OPMC\u3011-FlowBatchHandlerDomainService.queryReplaceFlowRoleHandler after dealUserEffectiveAndRemoveDuplicate :{}", (Object)resultMap.toString());
        long l = System.currentTimeMillis();
        LOG.info("queryReplaceFlowRoleHandler takes time : " + (l - start) + " ms");
        return resultMap;
    }

    private Map<Long, Function<HandlerBatchParamsBo, Map<Long, List<Long>>>> initroleTypeBatchHandlerMap() {
        HashMap<Long, Function<HandlerBatchParamsBo, Map<Long, List<Long>>>> roleTypeHandlerMap = new HashMap<Long, Function<HandlerBatchParamsBo, Map<Long, List<Long>>>>(16);
        roleTypeHandlerMap.put(RoleTypeConstants.EMP_SELF, this::getBatchSelf);
        roleTypeHandlerMap.put(RoleTypeConstants.APPOINTOR, this::getBatchAppointMulti);
        roleTypeHandlerMap.put(RoleTypeConstants.DIRECT_SUPERIOR, this::getBatchSuperior);
        roleTypeHandlerMap.put(RoleTypeConstants.INDIRECT_SUPERIOR, this::getBatchInDirectSuperior);
        roleTypeHandlerMap.put(RoleTypeConstants.ASSESSMENT_PLAN_CREATOR, this::getBatchEvaSchemaCreator);
        roleTypeHandlerMap.put(RoleTypeConstants.ASSESSMENT_ACTIVITY_CREATOR, this::getBatchEvaActivityCreator);
        roleTypeHandlerMap.put(RoleTypeConstants.ASSESSMENT_RESPONSIBLE_PERSON, this::getBatchResponsibleHandler);
        roleTypeHandlerMap.put(RoleTypeConstants.EMP_DEPHEADER, this::getBatchInCharge);
        roleTypeHandlerMap.put(RoleTypeConstants.APPOINT_POSITION, this::getBatchAppointPosMultiHandler);
        roleTypeHandlerMap.put(RoleTypeConstants.APPOINT_DEPHEADER, this::getBatchAppointAdminOrgHandler);
        return roleTypeHandlerMap;
    }

    private Map<Long, List<Long>> getBatchAppoint(HandlerBatchParamsBo handlerParamsBo) {
        long userId = 0L;
        if (handlerParamsBo.isReplace()) {
            DynamicObject defNode = handlerParamsBo.getFlowDefNode();
            userId = defNode.getLong("appointemp");
            LOG.info("\u3010OPMC\u3011-getAppoint,node replace handler is[{}]", (Object)userId);
        } else {
            DynamicObject flowDefRole = handlerParamsBo.getFlowDefRole();
            userId = flowDefRole.getLong("secondf7");
            LOG.info("\u3010OPMC\u3011-getAppoint,role appoint handler is[{}]", (Object)userId);
        }
        LOG.info("\u3010OPMC\u3011-getAppoint,userId is[{}]", (Object)userId);
        HashMap<Long, List<Long>> ret = new HashMap<Long, List<Long>>(16);
        ArrayList<Long> userList = new ArrayList<Long>(10);
        userList.add(userId);
        List<DynamicObject> ruRoles = handlerParamsBo.getFlowRuRoles();
        for (DynamicObject ruRole : ruRoles) {
            ret.put(ruRole.getLong("id"), userList);
        }
        return ret;
    }

    private Map<Long, List<Long>> getBatchAppointMulti(HandlerBatchParamsBo handlerParamsBo) {
        List<Long> userIds;
        if (handlerParamsBo.isReplace()) {
            DynamicObject defNode = handlerParamsBo.getFlowDefNode();
            userIds = this.getSecondF7Ids(defNode, "userentry", "user", "appointemp");
            LOG.info("\u3010OPMC\u3011-getBatchAppointMulti,node replace handler is[{}]", userIds);
        } else {
            DynamicObject flowDefRole = handlerParamsBo.getFlowDefRole();
            userIds = this.getSecondF7Ids(flowDefRole, "userentry", "user", "secondf7");
            LOG.info("\u3010OPMC\u3011-getBatchAppointMulti,role appoint handler is[{}]", userIds);
        }
        Map<Long, Boolean> userIsEnableMap = this.batchQueryUserIsEnable(userIds);
        List userList = userIds.stream().filter(userId -> {
            boolean userIsEnable = true;
            if (!Boolean.TRUE.equals(userIsEnableMap.get(userId))) {
                userIsEnable = false;
                LOG.info("\u3010OPMC\u3011-getMultiAppoint,user.isNotEnable [{}]", userId);
            }
            return userIsEnable;
        }).collect(Collectors.toList());
        HashMap<Long, List<Long>> ret = new HashMap<Long, List<Long>>(16);
        List<DynamicObject> ruRoles = handlerParamsBo.getFlowRuRoles();
        for (DynamicObject ruRole : ruRoles) {
            ret.put(ruRole.getLong("id"), userList);
        }
        return ret;
    }

    private Map<Long, List<Long>> getBatchInCharge(HandlerBatchParamsBo handerParamsBo) {
        HashMap<Long, List<Long>> handlerMap = new HashMap<Long, List<Long>>(16);
        ArrayList<DynamicObject> ruProcList = new ArrayList<DynamicObject>(10);
        Map<Long, DynamicObject> roleProcMap = handerParamsBo.getRuRoleProcMap();
        HashMap actobjRuRoleMap = new HashMap(16);
        for (Map.Entry<Long, DynamicObject> entry : roleProcMap.entrySet()) {
            List<Long> roleList;
            DynamicObject ruProc = entry.getValue();
            if (CollectionUtils.isEmpty((Collection)((Collection)actobjRuRoleMap.get(ruProc.getLong("actevalobj"))))) {
                roleList = new ArrayList<Long>(16);
                roleList.add(entry.getKey());
                actobjRuRoleMap.put(ruProc.getLong("actevalobj"), roleList);
            } else {
                roleList = (List)actobjRuRoleMap.get(ruProc.getLong("actevalobj"));
                roleList.add(entry.getKey());
                actobjRuRoleMap.put(ruProc.getLong("actevalobj"), roleList);
            }
            ruProcList.add(entry.getValue());
        }
        List<Long> actevalobjIdList = ruProcList.stream().map(o -> o.getLong("actevalobj")).collect(Collectors.toList());
        Map<Object, Object> actEvaObjAdminOrgMap = new HashMap(16);
        Map<Object, Object> interObjToActObjMap = new HashMap(16);
        if ("3".equals(((DynamicObject)ruProcList.get(0)).getString("workflowtype"))) {
            DynamicObject[] interviewDyns = IEPAActevalobjService.getInstance().getInterviewobjArrayById(actevalobjIdList);
            actevalobjIdList = Arrays.stream(interviewDyns).map(o -> o.getLong("evalobj.id")).collect(Collectors.toList());
            interObjToActObjMap = Arrays.stream(interviewDyns).collect(Collectors.toMap(ko -> ko.getLong("evalobj.id"), vo -> vo.getLong("id")));
            Map<Long, List<Long>> actEvaObjAdminOrgTmpMap = EPA_ROLETYPE_SERVICE.getOrgIdsByActevalobjIds(actevalobjIdList);
            for (Map.Entry<Object, Object> entry : actEvaObjAdminOrgTmpMap.entrySet()) {
                actEvaObjAdminOrgMap.put(interObjToActObjMap.get(entry.getKey()), entry.getValue());
            }
        } else {
            actEvaObjAdminOrgMap = EPA_ROLETYPE_SERVICE.getOrgIdsByActevalobjIds(actevalobjIdList);
        }
        HashMap<Object, Object> roleOrgMap = new HashMap<Object, Object>(16);
        HashSet orgSet = new HashSet(16);
        for (Map.Entry<Object, Object> entry : actEvaObjAdminOrgMap.entrySet()) {
            orgSet.addAll((Collection)entry.getValue());
            for (Object ruRoleId : (List)actobjRuRoleMap.get(entry.getKey())) {
                roleOrgMap.put(ruRoleId, entry.getValue());
            }
        }
        List<Object> handlerList = new ArrayList(10);
        try {
            handlerList = WORK_ROLE_SERVICE.getMainChargeInfoByOrg(new ArrayList<Long>(orgSet));
        }
        catch (Exception exception) {
            LOG.error("\u3010OPMC\u3011-getBatchInCharge error.", (Throwable)exception);
        }
        ArrayList<Long> arrayList = new ArrayList<Long>(10);
        HashMap orgPersonMap = new HashMap(10);
        for (Map map : handlerList) {
            Long orgId = (Long)map.get("adminorg");
            List<Long> personList = new ArrayList(10);
            if (null != orgPersonMap.get(orgId) && !((List)orgPersonMap.get(orgId)).isEmpty()) {
                personList = (List)orgPersonMap.get(orgId);
            }
            if (null != map.get("person") && !"0".equals(map.get("person").toString())) {
                personList.add((Long)map.get("person"));
                arrayList.add((Long)map.get("person"));
            }
            orgPersonMap.put(orgId, personList);
            if (personList.size() <= 100) continue;
            break;
        }
        Map<Long, Long> userMap = this.getUserIdsByPersonIds(arrayList);
        for (Map.Entry roleOrgEntry : roleOrgMap.entrySet()) {
            List orgList = (List)roleOrgEntry.getValue();
            HashSet<Long> userSet = new HashSet<Long>(16);
            for (Long orgId : orgList) {
                List personList = (List)orgPersonMap.get(orgId);
                if (CollectionUtils.isEmpty((Collection)personList)) continue;
                for (Long personId : personList) {
                    if (null == userMap.get(personId)) continue;
                    userSet.add(userMap.get(personId));
                }
            }
            handlerMap.put((Long)roleOrgEntry.getKey(), userSet.stream().collect(Collectors.toList()));
        }
        return handlerMap;
    }

    private Map<Long, List<Long>> getBatchSuperior(HandlerBatchParamsBo handerParamsBo) {
        HashMap<Long, List<Long>> resultMap = new HashMap<Long, List<Long>>(16);
        Map<Long, DynamicObject> roleProcMap = handerParamsBo.getRuRoleProcMap();
        List<Long> actEvaobjIdList = new ArrayList<Long>(10);
        HashMap<Long, Long> rolePersonMap = new HashMap<Long, Long>(16);
        String workflowType = "2";
        for (Map.Entry<Long, DynamicObject> entry : roleProcMap.entrySet()) {
            workflowType = entry.getValue().getString("workflowtype");
            actEvaobjIdList.add(entry.getValue().getLong("actevalobj"));
            rolePersonMap.put(entry.getKey(), entry.getValue().getLong("actevalobj"));
        }
        HashMap<Long, Long> inteObjActevaObjMap = new HashMap<Long, Long>(16);
        if ("3".equals(workflowType)) {
            DynamicObject[] interviewDyns = IEPAActevalobjService.getInstance().getInterviewobjArrayById(actEvaobjIdList);
            actEvaobjIdList = Arrays.stream(interviewDyns).map(o -> o.getLong("evalobj.id")).collect(Collectors.toList());
            for (DynamicObject interObj : interviewDyns) {
                inteObjActevaObjMap.put(interObj.getLong("id"), interObj.getLong("evalobj.id"));
            }
        }
        Map<Long, Map<String, Object>> perfFileInfoMap = IEPAActevalobjService.getInstance().getActevaobjPerfFileInfo(actEvaobjIdList);
        ArrayList<Long> depempIdList = new ArrayList<Long>(10);
        HashMap<Long, Long> actevaobjDepempMap = new HashMap<Long, Long>(16);
        for (Map.Entry<Long, Map<String, Object>> entry : perfFileInfoMap.entrySet()) {
            Long depempId = (Long)entry.getValue().get("depempId");
            depempIdList.add(depempId);
            actevaobjDepempMap.put(entry.getKey(), depempId);
        }
        Map<Long, List<Long>> personUserMap = this.getSuperiorIdsByPersonIds(depempIdList);
        LOG.info("\u3010OPMC\u3011-getBatchSuperior- personUserMap is [{}]", (Object)SerializationUtils.toJsonString(personUserMap));
        for (Map.Entry rolePersonEntry : rolePersonMap.entrySet()) {
            if ("3".equals(workflowType)) {
                resultMap.put((Long)rolePersonEntry.getKey(), personUserMap.get(actevaobjDepempMap.get(inteObjActevaObjMap.get(rolePersonEntry.getValue()))));
                continue;
            }
            resultMap.put((Long)rolePersonEntry.getKey(), personUserMap.get(actevaobjDepempMap.get(rolePersonEntry.getValue())));
        }
        return resultMap;
    }

    private Map<Long, List<Long>> getBatchInDirectSuperior(HandlerBatchParamsBo handerParamsBo) {
        HashMap<Long, List<Long>> resultMap = new HashMap<Long, List<Long>>(16);
        Map<Long, DynamicObject> roleProcMap = handerParamsBo.getRuRoleProcMap();
        ArrayList<Long> personIds = new ArrayList<Long>(10);
        HashMap<Long, Long> rolePersonMap = new HashMap<Long, Long>(16);
        for (Map.Entry<Long, DynamicObject> entry : roleProcMap.entrySet()) {
            personIds.add(entry.getValue().getLong("person.id"));
            rolePersonMap.put(entry.getValue().getLong("person.id"), entry.getKey());
        }
        Map<Long, List<Map<String, Object>>> personMap = WORK_ROLE_SERVICE.getInDirectSuperior(personIds);
        LOG.info("\u3010OPMC\u3011-getBatchInDirectSuperior- personMap is [{}]", (Object)SerializationUtils.toJsonString(personMap));
        HashMap indPersonIdsMap = new HashMap(16);
        ArrayList<Long> pIds = new ArrayList<Long>(10);
        for (Map.Entry<Long, List<Map<String, Object>>> indPersonIdsEntry : personMap.entrySet()) {
            List<Map<String, Object>> personIdList = indPersonIdsEntry.getValue();
            ArrayList<Long> indirectPersonIdList = new ArrayList<Long>(10);
            for (Map<String, Object> pmap : personIdList) {
                pIds.add(Long.parseLong(String.valueOf(pmap.get("person.id"))));
                indirectPersonIdList.add(Long.parseLong(String.valueOf(pmap.get("person.id"))));
            }
            indPersonIdsMap.put(indPersonIdsEntry.getKey(), indirectPersonIdList);
        }
        Map<Long, Long> superiorUserMap = this.getUserIdsByPersonIds(pIds);
        LOG.info("\u3010OPMC\u3011-getBatchInDirectSuperior-superiorUserMap, superiorUserMap is [{}],pIds : [{}]", (Object)SerializationUtils.toJsonString(superiorUserMap), (Object)SerializationUtils.toJsonString(pIds));
        for (Map.Entry entry : indPersonIdsMap.entrySet()) {
            List personIdsTmp = (List)entry.getValue();
            HashSet<Long> userIds = new HashSet<Long>(16);
            for (Long pId : personIdsTmp) {
                userIds.add(superiorUserMap.get(pId));
            }
            resultMap.put((Long)rolePersonMap.get(entry.getKey()), userIds.stream().collect(Collectors.toList()));
        }
        LOG.info("\u3010OPMC\u3011-getBatchInDirectSuperior- resultMap is [{}]", (Object)SerializationUtils.toJsonString(resultMap));
        return resultMap;
    }

    private Map<Long, List<Long>> getSuperiorIdsByPersonIds(List<Long> depempIdList) {
        HashMap<Long, List<Long>> retMap = new HashMap<Long, List<Long>>(16);
        Map<Long, List<Map<String, Object>>> directSuperior = WORK_ROLE_SERVICE.getDirectSuperiorByDepempId(depempIdList);
        LOG.info("\u3010OPMC\u3011-FlowBatchHandlerDomainService.getSuperiorIdsByPersonIds,traceId={},directSuperior={}", (Object)RequestContext.get().getTraceId(), (Object)SerializationUtils.toJsonString((Object)(directSuperior == null ? "" : directSuperior)));
        if (directSuperior != null) {
            HashMap personSuperiorMap = new HashMap(16);
            ArrayList<Long> superiorIds = new ArrayList<Long>(10);
            for (Long personId : depempIdList) {
                List<Map<String, Object>> superiorList = directSuperior.get(personId);
                if (HRObjectUtils.isEmpty(superiorList)) continue;
                ArrayList<Long> superiorListPer = new ArrayList<Long>(16);
                for (Map<String, Object> superiorInfo : superiorList) {
                    Long superiorId = (Long)superiorInfo.get("person.id");
                    if (HRObjectUtils.isEmpty((Object)superiorId)) continue;
                    superiorListPer.add(superiorId);
                    superiorIds.add(superiorId);
                }
                personSuperiorMap.put(personId, superiorListPer);
            }
            Map<Long, Long> superiorUserMap = this.getUserIdsByPersonIds(superiorIds);
            LOG.info("\u3010OPMC\u3011-getSuperiorIdsByPersonIds- getUserIdsByPersonIds,superiorUserMap is [{}],superiorIds is [{}]", (Object)SerializationUtils.toJsonString(superiorUserMap), (Object)SerializationUtils.toJsonString(superiorIds));
            for (Map.Entry personSuperiorEntry : personSuperiorMap.entrySet()) {
                List superiorPerson = (List)personSuperiorEntry.getValue();
                ArrayList<Long> superiorUser = new ArrayList<Long>(10);
                for (Long user : superiorPerson) {
                    if (!superiorUserMap.containsKey(user)) continue;
                    superiorUser.add(superiorUserMap.get(user));
                }
                retMap.put((Long)personSuperiorEntry.getKey(), (List<Long>)superiorUser);
            }
        }
        LOG.info("\u3010OPMC\u3011-getSuperiorIdsByPersonIds- retMap is [{}]", (Object)SerializationUtils.toJsonString(retMap));
        return retMap;
    }

    private Map<Long, List<Long>> getBatchSelf(HandlerBatchParamsBo handerParamsBo) {
        HashMap<Long, List<Long>> resultMap = new HashMap<Long, List<Long>>(16);
        Map<Long, DynamicObject> roleProcMap = handerParamsBo.getRuRoleProcMap();
        ArrayList<Long> personIds = new ArrayList<Long>(10);
        HashMap<Long, Long> rolePersonMap = new HashMap<Long, Long>(16);
        for (Map.Entry<Long, DynamicObject> entry : roleProcMap.entrySet()) {
            personIds.add(entry.getValue().getLong("person.id"));
            rolePersonMap.put(entry.getKey(), entry.getValue().getLong("person.id"));
        }
        Map<Long, Long> personUserMap = this.getUserIdsByPersonIds(personIds);
        for (Map.Entry rolePersonEntry : rolePersonMap.entrySet()) {
            resultMap.put((Long)rolePersonEntry.getKey(), Collections.singletonList(personUserMap.get(rolePersonEntry.getValue())));
        }
        return resultMap;
    }

    protected Map<Long, Long> getUserIdsByPersonIds(List<Long> personIds) {
        HashMap<Long, Long> retMap = new HashMap<Long, Long>(16);
        HashMap<String, List<Long>> personIdMap = new HashMap<String, List<Long>>(16);
        personIdMap.put("person", personIds);
        Map<Object, Object> userIdByPersonInfo = new HashMap(16);
        try {
            userIdByPersonInfo = PERSON_SERVICE.getUserIdByPersonInfo(personIdMap);
        }
        catch (Exception e) {
            LOG.error("\u3010OPMC\u3011-getUserIdsByPersonIds error,personIds:{}", personIds);
            LOG.error((Throwable)e);
        }
        if (userIdByPersonInfo.isEmpty()) {
            return retMap;
        }
        Boolean success = (Boolean)userIdByPersonInfo.get("success");
        if (success.booleanValue()) {
            Map userInfo = (Map)userIdByPersonInfo.get("data");
            ArrayList<Long> userIds = new ArrayList<Long>(personIds.size());
            for (Long personId : personIds) {
                Map user = (Map)userInfo.get(personId);
                if (user == null) continue;
                Long userId = (Long)user.get("user");
                userIds.add(userId);
            }
            Map<Long, Boolean> userIsEnableMap = this.batchQueryUserIsEnable(userIds);
            for (Long personId : personIds) {
                Long userId;
                Map user = (Map)userInfo.get(personId);
                if (user == null || !userIsEnableMap.getOrDefault(userId = (Long)user.get("user"), false).booleanValue()) continue;
                retMap.put(personId, userId);
            }
        }
        return retMap;
    }

    protected Map<Long, List<DynamicObject>> getUnConfirmHandler(DynamicObject[] roles, DynamicObject[] flowRuProcs) {
        List userInfo;
        int n;
        if (0 == roles.length) {
            return new HashMap<Long, List<DynamicObject>>(0);
        }
        Map<Long, DynamicObject> procMap = Arrays.stream(flowRuProcs).collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
        HashMap<Long, DynamicObject> ruRoleProcMap = new HashMap<Long, DynamicObject>(16);
        ArrayList<DynamicObject> needQueryHandlerRuRoleList = new ArrayList(10);
        needQueryHandlerRuRoleList = Arrays.stream(roles).collect(Collectors.toList());
        for (DynamicObject dynamicObject : roles) {
            ruRoleProcMap.put(dynamicObject.getLong("id"), procMap.get(dynamicObject.get("flowruproc_id")));
        }
        LOG.info("\u3010OPMC\u3011-getUnConfirmHandler- batchQueryFlowRoleHandler,needQueryHandlerRuRoleList is[{}]", (Object)SerializationUtils.toJsonString(needQueryHandlerRuRoleList));
        Map<Long, List<Long>> roleHandlerMap = this.batchQueryFlowRoleHandler(needQueryHandlerRuRoleList, ruRoleProcMap);
        LOG.info("\u3010OPMC\u3011-getUnConfirmHandler- batchQueryFlowRoleHandler,roleHandlerMap is[{}]", (Object)SerializationUtils.toJsonString(roleHandlerMap));
        ArrayList<DynamicObject> needFindReplaceRoles = new ArrayList<DynamicObject>(10);
        HashMap<Long, DynamicObject> replaceRuRoleProcMap = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject ruRole : roles) {
            if (!CollectionUtils.isEmpty((Collection)roleHandlerMap.get(ruRole.getLong("id")))) continue;
            needFindReplaceRoles.add(ruRole);
            replaceRuRoleProcMap.put(ruRole.getLong("id"), procMap.get(ruRole.get("flowruproc_id")));
        }
        LOG.info("\u3010OPMC\u3011-getUnConfirmHandler- before queryReplaceFlowRoleHandler,needFindReplaceRoles is[{}],replaceRuRoleProcMap is [{}]", (Object)SerializationUtils.toJsonString(needFindReplaceRoles), (Object)SerializationUtils.toJsonString(replaceRuRoleProcMap));
        if (needFindReplaceRoles.size() > 0) {
            roleHandlerMap.putAll(this.queryReplaceFlowRoleHandler(needFindReplaceRoles, replaceRuRoleProcMap));
        }
        if (0 == (n = roleHandlerMap.values().stream().filter(Objects::nonNull).mapToInt(List::size).sum())) {
            userInfo = new ArrayList(0);
        } else {
            List userIds = roleHandlerMap.values().stream().filter(Objects::nonNull).reduce(new ArrayList(n), (a, b) -> {
                a.addAll(b);
                return a;
            });
            userIds = userIds.stream().filter(Objects::nonNull).filter(e -> 0L < e).distinct().collect(Collectors.toList());
            userInfo = UserServiceHelper.get(userIds, (String[])new String[]{"id", "name", "number"}, null);
        }
        DynamicObjectType userType = EntityMetadataCache.getSubDataEntityType((String)"bos_user", Arrays.asList("id", "name", "number"));
        Map<Long, DynamicObject> personMap = userInfo.stream().map(e -> {
            DynamicObject aPerson = new DynamicObject(userType);
            aPerson.set("id", e.get("id"));
            aPerson.set("name", e.get("name"));
            aPerson.set("number", e.get("number"));
            return aPerson;
        }).collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
        HashMap<Long, List<DynamicObject>> retMap = new HashMap<Long, List<DynamicObject>>(roleHandlerMap.size());
        for (Map.Entry<Long, List<Long>> entry : roleHandlerMap.entrySet()) {
            List persons = entry.getValue().stream().filter(Objects::nonNull).map(e -> personMap.getOrDefault(e, new DynamicObject(userType, e))).collect(Collectors.toList());
            retMap.put(entry.getKey(), persons);
        }
        return retMap;
    }

    private Map<Long, List<Long>> getBatchResponsibleHandler(HandlerBatchParamsBo handerParamsBo) {
        return this.getUserIdsByRoleType(handerParamsBo, RoleTypeConstants.ASSESSMENT_RESPONSIBLE_PERSON);
    }

    private Map<Long, List<Long>> getBatchEvaActivityCreator(HandlerBatchParamsBo handerParamsBo) {
        return this.getUserIdsByRoleType(handerParamsBo, RoleTypeConstants.ASSESSMENT_ACTIVITY_CREATOR);
    }

    private Map<Long, List<Long>> getBatchEvaSchemaCreator(HandlerBatchParamsBo handerParamsBo) {
        return this.getUserIdsByRoleType(handerParamsBo, RoleTypeConstants.ASSESSMENT_PLAN_CREATOR);
    }

    private Map<Long, List<Long>> getUserIdsByRoleType(HandlerBatchParamsBo handerParamsBo, Long roleTypeId) {
        LOG.info("\u3010OPMC\u3011-FlowBatchHandlerDomainService.getUserIdsByRoleType traceId={},handerParamsBo={},roleTypeId={}", new Object[]{RequestContext.get().getTraceId(), handerParamsBo, roleTypeId});
        HashMap<Long, List<Long>> resultMap = new HashMap<Long, List<Long>>(16);
        Map<Long, DynamicObject> roleProcMap = handerParamsBo.getRuRoleProcMap();
        HashMap<Long, Object> roleActevaObjMap = new HashMap<Long, Object>(16);
        ArrayList<Long> interObjIdList = new ArrayList<Long>(10);
        for (Map.Entry<Long, DynamicObject> roleProcEntry : roleProcMap.entrySet()) {
            DynamicObject ruProc = roleProcEntry.getValue();
            if (!"3".equals(ruProc.getString("workflowtype"))) continue;
            interObjIdList.add(ruProc.getLong("actevalobj"));
        }
        Map<Object, Object> interviewActevaObjMap = new HashMap(16);
        Map<Object, Object> actevaInterviewObjMap = new HashMap(16);
        if (interObjIdList.size() > 0) {
            DynamicObject[] interviewObjArr = IEPAActevalobjService.getInstance().getIntObjArrayById(interObjIdList);
            interviewActevaObjMap = Arrays.stream(interviewObjArr).collect(Collectors.toMap(k -> k.getLong("id"), v -> v.getLong("evalobj.id")));
            actevaInterviewObjMap = Arrays.stream(interviewObjArr).collect(Collectors.toMap(k -> k.getLong("evalobj.id"), v -> v.getLong("id")));
        }
        HashSet<Object> actevaObjIdSet = new HashSet<Object>(16);
        for (Map.Entry<Long, DynamicObject> roleProcEntry : roleProcMap.entrySet()) {
            Object roleList;
            DynamicObject ruProc = roleProcEntry.getValue();
            if (CollectionUtils.isEmpty((Collection)((Collection)roleActevaObjMap.get(ruProc.getLong("actevalobj"))))) {
                roleList = new ArrayList<Long>(16);
                roleList.add(roleProcEntry.getKey());
                roleActevaObjMap.put(ruProc.getLong("actevalobj"), roleList);
            } else {
                roleList = (List)roleActevaObjMap.get(ruProc.getLong("actevalobj"));
                roleList.add(roleProcEntry.getKey());
                roleActevaObjMap.put(ruProc.getLong("actevalobj"), roleList);
            }
            if ("3".equals(ruProc.getString("workflowtype"))) {
                actevaObjIdSet.add(interviewActevaObjMap.get(ruProc.getLong("actevalobj")));
            } else {
                actevaObjIdSet.add(ruProc.getLong("actevalobj"));
            }
            LOG.info("invoke getUserIdsByRoleType,actevaobj is[{}],roleTypeId is [{}]", (Object)ruProc.getLong("actevalobj"), (Object)roleTypeId);
        }
        RoleTypeCustomPo roleTypeCustomPo = new RoleTypeCustomPo();
        roleTypeCustomPo.setActevalobjIdList(new ArrayList<Long>(actevaObjIdSet));
        Map<Long, List<Long>> evaObjPersonMap = EPA_ROLETYPE_SERVICE.getUserIdByRoleTypeId(roleTypeId, roleTypeCustomPo);
        LOG.info("\u3010OPMC\u3011-FlowBatchHandlerDomainService.getUserIdsByRoleType traceId={},evaObjPersonMap={}", (Object)RequestContext.get().getTraceId(), evaObjPersonMap);
        if (!actevaInterviewObjMap.isEmpty()) {
            HashMap<Long, List<Long>> evaObjPersonTmpMap = new HashMap<Long, List<Long>>(16);
            for (Map.Entry entry : evaObjPersonMap.entrySet()) {
                evaObjPersonTmpMap.put((Long)actevaInterviewObjMap.get(entry.getKey()), (List<Long>)entry.getValue());
            }
            evaObjPersonMap = evaObjPersonTmpMap;
        }
        for (Map.Entry<Long, List<Long>> entry : evaObjPersonMap.entrySet()) {
            LOG.info("invoke getUserIdByRoleTypeId,result key is :" + entry.getKey() + ",value is :" + entry.getValue());
            for (Long ruRoleId : (List)roleActevaObjMap.get(entry.getKey())) {
                resultMap.put(ruRoleId, entry.getValue());
            }
        }
        LOG.info("invoke getUserIdByRoleTypeId,handlerMap is :" + ((Object)resultMap).toString());
        return resultMap;
    }

    private Map<Long, List<Long>> getBatchAppointPosHandler(HandlerBatchParamsBo handerParamsBo) {
        HashMap<Long, List<Long>> handlerMap = new HashMap<Long, List<Long>>(16);
        Map<Long, DynamicObject> roleProcMap = handerParamsBo.getRuRoleProcMap();
        HashMap<Long, Long> rolePersonMap = new HashMap<Long, Long>(16);
        for (Map.Entry<Long, DynamicObject> entry : roleProcMap.entrySet()) {
            rolePersonMap.put(entry.getValue().getLong("person.id"), entry.getKey());
        }
        long posId = 0L;
        if (handerParamsBo.isReplace()) {
            DynamicObject defNode = handerParamsBo.getFlowDefNode();
            posId = defNode.getLong("appointemp");
        } else {
            DynamicObject flowDefRole = handerParamsBo.getFlowDefRole();
            posId = flowDefRole.getLong("secondf7");
        }
        Map<Long, Set<Long>> posPersonMap = PERSON_SERVICE.getAllUsersOfPosition("1", Collections.singletonList(posId));
        ArrayList<Long> allPersonIdList = new ArrayList<Long>(10);
        for (Map.Entry<Long, Set<Long>> personEntry : posPersonMap.entrySet()) {
            allPersonIdList.addAll((Collection<Long>)personEntry.getValue());
        }
        Map<Long, Long> personUserMap = this.getUserIdsByPersonIds(allPersonIdList);
        HashSet<Long> userSet = new HashSet<Long>(16);
        for (Map.Entry<Long, Long> entry : personUserMap.entrySet()) {
            userSet.add(entry.getValue());
            if (userSet.size() <= INT_TEN) continue;
            break;
        }
        for (Map.Entry<Long, Long> entry : rolePersonMap.entrySet()) {
            handlerMap.put(entry.getValue(), userSet.stream().collect(Collectors.toList()));
        }
        return handlerMap;
    }

    private Map<Long, List<Long>> getBatchAppointPosMultiHandler(HandlerBatchParamsBo handerParamsBo) {
        List<Long> posIds;
        HashMap<Long, List<Long>> handlerMap = new HashMap<Long, List<Long>>(16);
        Map<Long, DynamicObject> roleProcMap = handerParamsBo.getRuRoleProcMap();
        HashMap<Long, Long> rolePersonMap = new HashMap<Long, Long>(16);
        for (Map.Entry<Long, DynamicObject> entry : roleProcMap.entrySet()) {
            rolePersonMap.put(entry.getValue().getLong("person.id"), entry.getKey());
        }
        if (handerParamsBo.isReplace()) {
            DynamicObject defNode = handerParamsBo.getFlowDefNode();
            posIds = this.getSecondF7Ids(defNode, "postentry", "post", "appointemp");
        } else {
            DynamicObject flowDefRole = handerParamsBo.getFlowDefRole();
            posIds = this.getSecondF7Ids(flowDefRole, "postentry", "post", "secondf7");
        }
        Map<Long, Set<Long>> posPersonMap = PERSON_SERVICE.getAllUsersOfPosition("1", posIds);
        ArrayList<Long> allPersonIdList = new ArrayList<Long>(10);
        for (Map.Entry<Long, Set<Long>> personEntry : posPersonMap.entrySet()) {
            allPersonIdList.addAll((Collection<Long>)personEntry.getValue());
        }
        Map<Long, Long> personUserMap = this.getUserIdsByPersonIds(allPersonIdList);
        HashSet<Long> userSet = new HashSet<Long>(16);
        for (Map.Entry<Long, Long> entry : personUserMap.entrySet()) {
            userSet.add(entry.getValue());
            if (userSet.size() <= INT_TEN) continue;
            break;
        }
        for (Map.Entry<Long, Long> entry : rolePersonMap.entrySet()) {
            handlerMap.put(entry.getValue(), new ArrayList(userSet));
        }
        return handlerMap;
    }

    private Map<Long, List<Long>> getBatchAppointAdminOrgHandler(HandlerBatchParamsBo handerParamsBo) {
        HashMap<Long, List<Long>> handlerMap = new HashMap<Long, List<Long>>(16);
        Map<Long, DynamicObject> roleProcMap = handerParamsBo.getRuRoleProcMap();
        HashMap<Long, Long> rolePersonMap = new HashMap<Long, Long>(16);
        for (Map.Entry<Long, DynamicObject> entry : roleProcMap.entrySet()) {
            rolePersonMap.put(entry.getValue().getLong("person.id"), entry.getKey());
        }
        long adminOrgId = 0L;
        if (handerParamsBo.isReplace()) {
            DynamicObject defNode = handerParamsBo.getFlowDefNode();
            adminOrgId = defNode.getLong("appointemp");
        } else {
            DynamicObject flowDefRole = handerParamsBo.getFlowDefRole();
            adminOrgId = flowDefRole.getLong("secondf7");
        }
        List<Object> orgPersonList = new ArrayList(10);
        try {
            orgPersonList = WORK_ROLE_SERVICE.getMainChargeInfoByOrg(Collections.singletonList(adminOrgId));
        }
        catch (Exception ex) {
            LOG.error("\u3010OPMC\u3011-getBatchAppointAdminOrgHandler error.", (Throwable)ex);
        }
        HashSet<Long> allPersonIdSet = new HashSet<Long>(16);
        for (Map map : orgPersonList) {
            if (null != map.get("person") && !"0".equals(map.get("person").toString())) {
                allPersonIdSet.add((Long)map.get("person"));
            }
            if (allPersonIdSet.size() <= INT_TEN) continue;
            break;
        }
        ArrayList<Long> pIdList = new ArrayList<Long>(allPersonIdSet);
        Map<Long, Long> map = this.getUserIdsByPersonIds(pIdList);
        HashSet<Long> userSet = new HashSet<Long>(16);
        for (Map.Entry<Long, Long> entry : map.entrySet()) {
            userSet.add(entry.getValue());
        }
        for (Map.Entry<Long, Long> entry : rolePersonMap.entrySet()) {
            handlerMap.put(entry.getValue(), new ArrayList(userSet));
        }
        return handlerMap;
    }

    protected Map<Long, List<Long>> dealUserEffectiveAndRemoveDuplicate(Map<Long, List<Long>> handlerMap) {
        HashMap<Long, List<Long>> resultMap = new HashMap<Long, List<Long>>(16);
        if (handlerMap.isEmpty()) {
            return resultMap;
        }
        for (Map.Entry<Long, List<Long>> entry : handlerMap.entrySet()) {
            List<Long> userList = entry.getValue();
            if (CollectionUtils.isEmpty(userList)) continue;
            HashSet<Long> userSet = new HashSet<Long>(16);
            ArrayList<Long> userTmpList = new ArrayList<Long>(10);
            for (Long userId : userList) {
                if (null == userId) continue;
                userTmpList.add(userId);
            }
            Map<Long, Boolean> userEnableMap = this.batchQueryUserIsEnable(userTmpList);
            for (Map.Entry<Long, Boolean> userEntry : userEnableMap.entrySet()) {
                if (!userEntry.getValue().booleanValue()) continue;
                userSet.add(userEntry.getKey());
            }
            if (CollectionUtils.isEmpty(userSet)) continue;
            resultMap.put(entry.getKey(), new ArrayList(userSet));
        }
        return resultMap;
    }

    protected Map<Long, List<DynamicObject>> getEffectiveUser(Map<Long, List<DynamicObject>> handlerMap) {
        HashMap<Long, List<DynamicObject>> resultMap = new HashMap<Long, List<DynamicObject>>(16);
        if (handlerMap.isEmpty()) {
            return resultMap;
        }
        for (Map.Entry<Long, List<DynamicObject>> entry : handlerMap.entrySet()) {
            Set userDyList;
            if (CollectionUtils.isEmpty((Collection)entry.getValue()) || CollectionUtils.isEmpty(userDyList = entry.getValue().stream().filter(Objects::nonNull).collect(Collectors.toSet()))) continue;
            Map<Long, DynamicObject> userDyMap = userDyList.stream().collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
            HashSet<DynamicObject> userDySet = new HashSet<DynamicObject>(16);
            ArrayList<Long> userTmpList = new ArrayList<Long>(10);
            for (DynamicObject userDy : userDyList) {
                if (null == userDy) continue;
                userTmpList.add(userDy.getLong("id"));
            }
            Map<Long, Boolean> userEnableMap = this.batchQueryUserIsEnable(userTmpList);
            for (Map.Entry<Long, Boolean> userEntry : userEnableMap.entrySet()) {
                if (!userEntry.getValue().booleanValue()) continue;
                userDySet.add(userDyMap.get(userEntry.getKey()));
            }
            resultMap.put(entry.getKey(), new ArrayList(userDySet));
        }
        return resultMap;
    }

    private List<Long> getSecondF7Ids(DynamicObject defNodeOrDefRoleObj, String entryProperty, String multiProperty, String singleProperty) {
        DynamicObjectCollection secondF7Objs = defNodeOrDefRoleObj.getDynamicObjectCollection(entryProperty);
        if (secondF7Objs.size() > 0) {
            return secondF7Objs.stream().map(secondF7IdObj -> secondF7IdObj.getDynamicObject(multiProperty).getLong("id")).collect(Collectors.toList());
        }
        return Collections.singletonList(defNodeOrDefRoleObj.getLong(singleProperty));
    }

    static {
        INT_TEN = 10;
    }
}

