/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.pbs.business.domain.workflow.service;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.pbs.business.ServiceFactory;
import kd.opmc.pbs.business.domain.msg.service.MergeMsgSendService;
import kd.opmc.pbs.business.domain.workflow.dto.SendMessageDTO;
import kd.opmc.pbs.business.domain.workflow.entity.FlowMsgMergeEnumBO;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowRuNodeEntityService;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowRuProcEntityService;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowRuTaskEntityService;
import kd.opmc.pbs.business.domain.workflow.enums.FlowCooperatorEnum;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuMsgMergeEnum;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuTaskStatusEnum;
import kd.opmc.pbs.business.domain.workflow.service.FlowHandlerBatchDomainService;
import kd.opmc.pbs.business.domain.workflow.service.FlowRuSecondDomainService;
import kd.opmc.pbs.business.external.epa.IEPAActevalobjService;
import kd.opmc.pbs.business.model.CooperatorParamsBo;
import kd.opmc.pbs.common.utils.CommonResultBo;
import kd.opmc.pbs.common.utils.OpmcLogUtils;

public class FlowCooperateDomainService {
    private static final Log LOGGER = LogFactory.getLog(FlowCooperateDomainService.class);
    FlowRuTaskEntityService FLOW_RU_TASK_ENTITYSERVICE = FlowRuTaskEntityService.getInstance();
    private static final IEPAActevalobjService EPA_ACTEVAOBJ_SERVICE = IEPAActevalobjService.getInstance();
    private static final FlowRuSecondDomainService FLOW_RUSECOND_DOMAIN_SERVICE = FlowRuSecondDomainService.getInstance();
    private static final MergeMsgSendService MERGE_MSG_SEND_SERVICE = MergeMsgSendService.getInstance();
    protected static final FlowRuNodeEntityService FLOW_RU_NODE_ENTITY_SERVICE = FlowRuNodeEntityService.getInstance();
    protected static final FlowRuProcEntityService FLOW_RU_PROC_ENTITY_SERVICE = FlowRuProcEntityService.getInstance();
    protected static final FlowHandlerBatchDomainService FLOW_HANDLER_BATCH_DOMAIN_SERVICE = FlowHandlerBatchDomainService.getInstance();

    public static FlowCooperateDomainService getInstance() {
        return ServiceFactory.getService(FlowCooperateDomainService.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommonResultBo generateCooperatorTask(Map<Long, List<Long>> cooperatorMap) {
        CommonResultBo resultBo = new CommonResultBo();
        if (null == cooperatorMap) {
            resultBo.setCode(0);
            resultBo.setSumResult(ResManager.loadKDString((String)"\u5165\u53c2\u4e3a\u7a7a", (String)"FlowCooperateDomainService_0", (String)"opmc-pbs-business", (Object[])new Object[0]));
            return resultBo;
        }
        ArrayList<Long> mainTaskIdList = new ArrayList<Long>(cooperatorMap.keySet());
        DynamicObject[] mainTaskDyns = this.FLOW_RU_TASK_ENTITYSERVICE.loadTasksByIds(mainTaskIdList);
        Map<Long, DynamicObject> mainTaskMap = Arrays.stream(mainTaskDyns).collect(Collectors.toMap(task -> task.getLong("id"), task -> task));
        DynamicObject[] coopTaskDyns = this.FLOW_RU_TASK_ENTITYSERVICE.loadCoopTasksByMainTaskIds(mainTaskIdList);
        Map coopTaskMap = Arrays.stream(coopTaskDyns).collect(Collectors.groupingBy(ct -> ct.getLong("hosttask.id"), Collectors.mapping(ov -> ov, Collectors.toList())));
        HashMap erroMsgMap = new HashMap(16);
        String existCoopTaskMsg = ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u5df2\u5b58\u5728\u534f\u529e\u4efb\u52a1\u3002", (String)"FlowCooperateDomainService_1", (String)"opmc-pbs-business", (Object[])new Object[0]);
        try (TXHandle txhandle = TX.required();){
            ArrayList<DynamicObject> coopDynList = new ArrayList<DynamicObject>(10);
            ArrayList<DynamicObject> needSendMsgCoopDynList = new ArrayList<DynamicObject>(10);
            List<String> canNotAdjustCoopTaskStatusList = Arrays.asList(FlowRuTaskStatusEnum.NOT_ACTIVE.getCode(), FlowRuTaskStatusEnum.BE_WAITTING.getCode(), FlowRuTaskStatusEnum.PROCESSED.getCode(), FlowRuTaskStatusEnum.EXPIRED.getCode(), FlowRuTaskStatusEnum.RETURNED.getCode(), FlowRuTaskStatusEnum.PENDING.getCode());
            for (Map.Entry<Long, List<Long>> coopEntry : cooperatorMap.entrySet()) {
                DynamicObject mainTask = mainTaskMap.get(coopEntry.getKey());
                if (canNotAdjustCoopTaskStatusList.contains(mainTask.getString("taskstatus"))) {
                    HashMap<Long, String> unValidCoopMap = new HashMap<Long, String>(16);
                    List<Long> coopHandlerList = cooperatorMap.get(mainTask.getLong("id"));
                    for (Long coHandlerId : coopHandlerList) {
                        unValidCoopMap.put(coHandlerId, FlowRuTaskStatusEnum.getFlowRuTaskStatusByCode(mainTask.getString("taskstatus")).getText());
                    }
                    erroMsgMap.put(mainTask.getLong("id"), unValidCoopMap);
                    continue;
                }
                HashMap<Long, String> existCoopMap = new HashMap<Long, String>();
                List existCoopTaskDyns = coopTaskMap.get(mainTask.getLong("id"));
                if (CollectionUtils.isEmpty((Collection)coopEntry.getValue())) continue;
                List<Long> coopUserIdList = coopEntry.getValue();
                ArrayList<Long> needAddCoopTaskUserIdList = new ArrayList<Long>(coopUserIdList);
                if (!CollectionUtils.isEmpty(existCoopTaskDyns)) {
                    for (DynamicObject existCoopTask : existCoopTaskDyns) {
                        if (!coopUserIdList.contains(existCoopTask.getLong("handler.id"))) continue;
                        if (!existCoopTask.getString("taskstatus").equals(FlowRuTaskStatusEnum.EXPIRED.getCode())) {
                            existCoopMap.put(existCoopTask.getLong("handler.id"), existCoopTaskMsg);
                        } else {
                            this.setCoopTaskStatus(mainTask, existCoopTask);
                            coopDynList.add(existCoopTask);
                        }
                        needAddCoopTaskUserIdList.remove(existCoopTask.getLong("handler.id"));
                    }
                }
                Date now = new Date();
                for (Long coopUserId : needAddCoopTaskUserIdList) {
                    DynamicObject coopTaskDy = this.FLOW_RU_TASK_ENTITYSERVICE.generateEmptyDynamicObject();
                    HashSet<String> ignoreKeys = new HashSet<String>();
                    ignoreKeys.add("id");
                    ignoreKeys.add("hosttask");
                    ignoreKeys.add("iscotask");
                    ignoreKeys.add("iscohandlerdeal");
                    ignoreKeys.add("handler");
                    ignoreKeys.add("createtime");
                    ignoreKeys.add("modifytime");
                    HRDynamicObjectUtils.copy((DynamicObject)mainTask, (DynamicObject)coopTaskDy, ignoreKeys);
                    coopTaskDy.set("hosttask", (Object)mainTask.getLong("id"));
                    coopTaskDy.set("iscotask", (Object)Boolean.TRUE);
                    coopTaskDy.set("iscohandlerdeal", (Object)Boolean.FALSE);
                    coopTaskDy.set("handler", (Object)UserServiceHelper.getUserInfoByID((Long)coopUserId, (String)"id,name,number"));
                    coopTaskDy.set("id", (Object)ORM.create().genLongId("pbs_flowrutask"));
                    coopTaskDy.set("createtime", (Object)now);
                    coopTaskDy.set("modifytime", (Object)now);
                    coopDynList.add(coopTaskDy);
                    if (!mainTask.getString("taskstatus").equals(FlowRuTaskStatusEnum.WAITING.getCode()) && !mainTask.getString("taskstatus").equals(FlowRuTaskStatusEnum.PROCESSING.getCode())) continue;
                    needSendMsgCoopDynList.add(coopTaskDy);
                }
                if (existCoopMap.size() <= 0) continue;
                erroMsgMap.put(mainTask.getLong("id"), existCoopMap);
            }
            if (coopDynList.size() > 0) {
                this.FLOW_RU_TASK_ENTITYSERVICE.save(coopDynList.toArray(new DynamicObject[0]));
            }
            if (needSendMsgCoopDynList.size() > 0) {
                String workflowType = mainTaskDyns[0].getString("flowruproc.workflowtype");
                FlowMsgMergeEnumBO flowMsgMergeEnumBO = this.assembleFlowMsgMergeEnumBO(workflowType);
                HashMap<Long, Boolean> ret = new HashMap<Long, Boolean>();
                if (!workflowType.contains("3")) {
                    this.sendCooperatorMessageLogic(needSendMsgCoopDynList.toArray(new DynamicObject[0]), flowMsgMergeEnumBO, ret);
                }
            }
            resultBo.setCode(1);
            resultBo.setErroMsgMap(erroMsgMap);
            resultBo.setSumResult(ResManager.loadKDString((String)"\u751f\u6210\u534f\u529e\u4efb\u52a1\u6210\u529f\u3002", (String)"FlowCooperateDomainService_2", (String)"opmc-pbs-business", (Object[])new Object[0]));
        }
        return resultBo;
    }

    public CommonResultBo setCooperator(Map<Long, List<Long>> cooperatorMap, FlowCooperatorEnum cooperatorEnum) {
        CommonResultBo resultBo = new CommonResultBo();
        try {
            if (null == cooperatorMap) {
                resultBo.setCode(0);
                resultBo.setSumResult(ResManager.loadKDString((String)"\u5165\u53c2\u4e3a\u7a7a", (String)"FlowCooperateDomainService_0", (String)"opmc-pbs-business", (Object[])new Object[0]));
                return resultBo;
            }
            CooperatorParamsBo cooperatorParamsBo = new CooperatorParamsBo();
            cooperatorParamsBo.setCooperatorMap(cooperatorMap);
            cooperatorParamsBo.setCooperatorEnum(cooperatorEnum);
            Map<String, Function<CooperatorParamsBo, CommonResultBo>> cooperatorOpMap = this.initCooperatorOpMap();
            if (null != cooperatorOpMap.get(cooperatorParamsBo.getCooperatorEnum().getCode())) {
                resultBo = cooperatorOpMap.get(cooperatorParamsBo.getCooperatorEnum().getCode()).apply(cooperatorParamsBo);
            } else {
                resultBo.setCode(0);
                resultBo.setSumResult(ResManager.loadKDString((String)"\u53c2\u6570\u914d\u7f6e\u9519\u8bef\uff0c\u627e\u4e0d\u5230\u534f\u529e\u4efb\u52a1\u5904\u7406\u5668\u3002", (String)"FlowCooperateDomainService_3", (String)"opmc-pbs-business", (Object[])new Object[0]));
            }
        }
        catch (Exception e) {
            LOGGER.error("\u3010OPMC\u3011-setCooperator error,message is : {}", (Object)e.getMessage());
        }
        return resultBo;
    }

    private Map<String, Function<CooperatorParamsBo, CommonResultBo>> initCooperatorOpMap() {
        HashMap<String, Function<CooperatorParamsBo, CommonResultBo>> cooperatorOpMap = new HashMap<String, Function<CooperatorParamsBo, CommonResultBo>>(16);
        cooperatorOpMap.put(FlowCooperatorEnum.ADD_COOPERATOR.getCode(), coopParamsBo -> this.generateCooperatorTask(coopParamsBo.getCooperatorMap()));
        cooperatorOpMap.put(FlowCooperatorEnum.ADJUST_COOPERATOR.getCode(), coopParamsBo -> this.adjustCooperator(coopParamsBo.getCooperatorMap()));
        cooperatorOpMap.put(FlowCooperatorEnum.DEL_COOPERATOR.getCode(), coopParamsBo -> this.deleteCooperator(coopParamsBo.getCooperatorMap()));
        return cooperatorOpMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommonResultBo adjustCooperator(Map<Long, List<Long>> cooperatorMap) {
        CommonResultBo resultBo = new CommonResultBo();
        if (null == cooperatorMap) {
            resultBo.setCode(0);
            resultBo.setSumResult(ResManager.loadKDString((String)"\u5165\u53c2\u4e3a\u7a7a", (String)"FlowCooperateDomainService_0", (String)"opmc-pbs-business", (Object[])new Object[0]));
            return resultBo;
        }
        ArrayList<Long> mainTaskIdList = new ArrayList<Long>(cooperatorMap.keySet());
        DynamicObject[] mainTaskDyns = this.FLOW_RU_TASK_ENTITYSERVICE.loadTasksByIds(mainTaskIdList);
        Map<Long, DynamicObject> mainTaskMap = Arrays.stream(mainTaskDyns).collect(Collectors.toMap(task -> task.getLong("id"), task -> task));
        DynamicObject[] coopTaskDyns = this.FLOW_RU_TASK_ENTITYSERVICE.loadCoopTasksByMainTaskIds(mainTaskIdList);
        try (TXHandle txhandle = TX.required();){
            for (DynamicObject coopTask : coopTaskDyns) {
                coopTask.set("taskstatus", (Object)FlowRuTaskStatusEnum.EXPIRED.getCode());
            }
            this.FLOW_RU_TASK_ENTITYSERVICE.save(coopTaskDyns);
            this.generateCooperatorTask(cooperatorMap);
            resultBo.setCode(1);
            resultBo.setSumResult(ResManager.loadKDString((String)"\u8c03\u6574\u534f\u529e\u4efb\u52a1\u6210\u529f\u3002", (String)"FlowCooperateDomainService_4", (String)"opmc-pbs-business", (Object[])new Object[0]));
        }
        return resultBo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommonResultBo deleteCooperator(Map<Long, List<Long>> cooperatorMap) {
        CommonResultBo resultBo = new CommonResultBo();
        if (null == cooperatorMap) {
            resultBo.setCode(0);
            resultBo.setSumResult(ResManager.loadKDString((String)"\u5165\u53c2\u4e3a\u7a7a", (String)"FlowCooperateDomainService_0", (String)"opmc-pbs-business", (Object[])new Object[0]));
            return resultBo;
        }
        ArrayList<Long> mainTaskIdList = new ArrayList<Long>(cooperatorMap.keySet());
        DynamicObject[] coopTaskDyns = this.FLOW_RU_TASK_ENTITYSERVICE.loadCoopTasksByMainTaskIds(mainTaskIdList);
        try (TXHandle txhandle = TX.required();){
            for (DynamicObject coopTask : coopTaskDyns) {
                coopTask.set("taskstatus", (Object)FlowRuTaskStatusEnum.EXPIRED.getCode());
            }
            this.FLOW_RU_TASK_ENTITYSERVICE.save(coopTaskDyns);
            resultBo.setCode(1);
            resultBo.setSumResult(ResManager.loadKDString((String)"\u5220\u9664\u534f\u529e\u4efb\u52a1\u6210\u529f\u3002", (String)"FlowCooperateDomainService_5", (String)"opmc-pbs-business", (Object[])new Object[0]));
        }
        return resultBo;
    }

    protected void setCoopTaskStatus(DynamicObject mainTask, DynamicObject existTaskDyn) {
        if (mainTask.getString("taskstatus").equals(FlowRuTaskStatusEnum.WAITING.getCode()) || mainTask.getString("taskstatus").equals(FlowRuTaskStatusEnum.PROCESSING.getCode())) {
            existTaskDyn.set("taskstatus", (Object)FlowRuTaskStatusEnum.WAITING.getCode());
        } else if (mainTask.getString("taskstatus").equals(FlowRuTaskStatusEnum.NOT_ACTIVE.getCode())) {
            existTaskDyn.set("taskstatus", (Object)FlowRuTaskStatusEnum.NOT_ACTIVE.getCode());
        }
    }

    public Map<Long, List<DynamicObject>> getCooperatorByMainTaskIds(List<Long> mainTaskIdList) {
        DynamicObject[] coopTaskDyns = this.FLOW_RU_TASK_ENTITYSERVICE.loadCoopTasksByMainTaskIds(mainTaskIdList);
        Map<Long, List<DynamicObject>> coopTaskMap = Arrays.stream(coopTaskDyns).collect(Collectors.groupingBy(ct -> ct.getLong("hosttask.id"), Collectors.mapping(ov -> ov, Collectors.toList())));
        return coopTaskMap;
    }

    public void dealCooperateTasks(List<SendMessageDTO> msgDtoList) {
        if (CollectionUtils.isEmpty(msgDtoList)) {
            LOGGER.error("\u3010OPMC\u3011-dealCooperateTasks , param msgDtoList is null.");
            return;
        }
        try {
            ArrayList<Long> mainTaskIdList = new ArrayList<Long>(10);
            for (SendMessageDTO dto : msgDtoList) {
                if (dto.isCotaskSendMsg()) continue;
                mainTaskIdList.addAll(dto.getTasks());
            }
            if (mainTaskIdList.size() > 0) {
                DynamicObject[] mainTaskDyns = this.FLOW_RU_TASK_ENTITYSERVICE.queryTaskByPks(mainTaskIdList);
                Long activityId = mainTaskDyns[0].getLong("activity");
                String businessType = mainTaskDyns[0].getString("flowruproc.workflowtype");
                Set userIdSet = Arrays.stream(mainTaskDyns).map(mt -> mt.getLong("handler.id")).collect(Collectors.toSet());
                Map<Long, List<Long>> cooperatorMap = IEPAActevalobjService.getInstance().getCooperator(activityId, new ArrayList<Long>(userIdSet), businessType);
                HashMap<Long, List<Long>> mainTaskCoopMap = new HashMap<Long, List<Long>>(16);
                for (DynamicObject mainTask : mainTaskDyns) {
                    mainTaskCoopMap.put(mainTask.getLong("id"), cooperatorMap.get(mainTask.getLong("handler.id")));
                }
                this.generateCooperatorTask(mainTaskCoopMap);
                DynamicObject[] coopTaskDyns = this.FLOW_RU_TASK_ENTITYSERVICE.loadCoopTasksByMainTaskIds(mainTaskIdList);
                Map coopTaskMap = Arrays.stream(coopTaskDyns).collect(Collectors.groupingBy(ct -> ct.getLong("hosttask.id"), Collectors.mapping(ov -> ov, Collectors.toList())));
                String workflowType = coopTaskDyns[0].getString("flowruproc.workflowtype");
                FlowMsgMergeEnumBO flowMsgMergeEnumBO = this.assembleFlowMsgMergeEnumBO(workflowType);
                HashMap<Long, Boolean> ret = new HashMap<Long, Boolean>();
                if (!workflowType.contains("3")) {
                    this.sendCooperatorMessageLogic(coopTaskDyns, flowMsgMergeEnumBO, ret);
                }
            }
        }
        catch (Exception e) {
            OpmcLogUtils.error((String)"FlowCooperateDomainService.dealCooperateTasks", (Throwable)e);
        }
    }

    protected void sendCooperatorMessageLogic(DynamicObject[] coopTaskDyns, FlowMsgMergeEnumBO msgEnumBO, Map<Long, Boolean> ret) {
        Map<Long, String> actevalObjPerffileNames = EPA_ACTEVAOBJ_SERVICE.queryActEvalObjPerffileNamesByObjIds(Arrays.stream(coopTaskDyns).map(e -> e.getLong("flowruproc.actevalobj")).distinct().collect(Collectors.toList()));
        Map coopTaskMap = Arrays.stream(coopTaskDyns).collect(Collectors.groupingBy(tk -> tk.getLong("flowrurole.flowdefrole.id"), Collectors.mapping(task -> task, Collectors.toList())));
        ArrayList handlerBatchTasksList = new ArrayList(10);
        coopTaskMap.forEach((roleDefId, roleDefTasks) -> handlerBatchTasksList.add(roleDefTasks.stream().collect(Collectors.groupingBy(tk -> tk.getLong("handler.id"), Collectors.toList()))));
        int sum = 0;
        for (Map handlerBatchTasks : handlerBatchTasksList) {
            for (Map.Entry entry : handlerBatchTasks.entrySet()) {
                ++sum;
            }
        }
        long[] newBatchIds = ORM.create().genLongIds("pbs_batchtaskmap", sum);
        int batchIdIndex = 0;
        for (Map handlerBatchTasksMap : handlerBatchTasksList) {
            for (Map.Entry taskEntry : handlerBatchTasksMap.entrySet()) {
                List<Long> taskIdList = ((List)taskEntry.getValue()).stream().map(e -> e.getLong("id")).collect(Collectors.toList());
                long newBatchId = newBatchIds[batchIdIndex++];
                FLOW_RUSECOND_DOMAIN_SERVICE.saveBatchTaskDetails(newBatchId, taskIdList);
                ((List)taskEntry.getValue()).sort((o1, o2) -> {
                    try {
                        Date time1 = o1.getDate("createtime");
                        Date time2 = o2.getDate("createtime");
                        return time1.compareTo(time2);
                    }
                    catch (Exception e) {
                        LOGGER.error(e.getMessage(), (Throwable)e);
                        return 0;
                    }
                });
                long actevalobjId = ((DynamicObject)((List)taskEntry.getValue()).get(0)).getLong("flowruproc.actevalobj");
                ArrayList<Long> actevalobjIds = new ArrayList<Long>();
                actevalobjIds.add(actevalobjId);
                DynamicObject[] proc = FLOW_RU_PROC_ENTITY_SERVICE.queryProcByEvaObjIds(actevalobjIds);
                DynamicObject actEvaObj = EPA_ACTEVAOBJ_SERVICE.getActevalobjById(actevalobjId);
                long procCount = ((List)taskEntry.getValue()).stream().map(e -> e.getLong("flowruproc.actevalobj")).distinct().count();
                FlowRuMsgMergeEnum msgEnum = procCount > 1L ? msgEnumBO.getMultiple() : msgEnumBO.getSingle();
                HashMap urlParams = Maps.newHashMapWithExpectedSize((int)3);
                urlParams.put("formId", FLOW_HANDLER_BATCH_DOMAIN_SERVICE.getMessageFormId(msgEnum, (List)taskEntry.getValue(), FLOW_RU_NODE_ENTITY_SERVICE.queryDefNodeByTaskId(((DynamicObject)((List)taskEntry.getValue()).get(0)).getLong("id"))));
                urlParams.put("batchTaskId", String.valueOf(newBatchId));
                urlParams.put("mask", String.valueOf(actevalobjId));
                List<Long> userIds = Collections.singletonList(taskEntry.getKey());
                Map<Long, Boolean> userEnableMap = FLOW_HANDLER_BATCH_DOMAIN_SERVICE.batchQueryUserIsEnable(userIds);
                if (userEnableMap.get(taskEntry.getKey()) == null || !userEnableMap.get(taskEntry.getKey()).booleanValue()) continue;
                try {
                    urlParams.put("actevalobj", actevalObjPerffileNames.get(actevalobjId));
                    MERGE_MSG_SEND_SERVICE.sendMessageWithUrl(msgEnum.getTemplateId(), userIds, actEvaObj, urlParams, msgEnum.getTag());
                    taskIdList.forEach(e -> ret.put((Long)e, true));
                }
                catch (Exception exp) {
                    LOGGER.error(exp.getMessage(), (Throwable)exp);
                    taskIdList.forEach(e -> ret.put((Long)e, false));
                }
            }
        }
    }

    protected FlowMsgMergeEnumBO assembleFlowMsgMergeEnumBO(String workflowType) {
        FlowMsgMergeEnumBO flowMsgMergeEnumBO = new FlowMsgMergeEnumBO(FlowRuMsgMergeEnum.EPA_INDICATORFORMULATE_COOP, FlowRuMsgMergeEnum.EPA_INDICATORFORMULATE_COOP_MUL);
        if (HRStringUtils.equals((String)workflowType, (String)"1")) {
            flowMsgMergeEnumBO = new FlowMsgMergeEnumBO(FlowRuMsgMergeEnum.EPA_INDICATORFORMULATE_COOP, FlowRuMsgMergeEnum.EPA_INDICATORFORMULATE_COOP_MUL);
        }
        if (HRStringUtils.equals((String)workflowType, (String)"2")) {
            flowMsgMergeEnumBO = new FlowMsgMergeEnumBO(FlowRuMsgMergeEnum.PBS_EVALUATION_COOP, FlowRuMsgMergeEnum.PBS_EVALUATION_COOP_MUL);
        }
        return flowMsgMergeEnumBO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommonResultBo syncCooperator(Long activityId, Map<Long, List<Long>> cooperatorMap, String workflowType) {
        CommonResultBo resultBo = new CommonResultBo();
        resultBo.setCode(0);
        if (null == cooperatorMap || cooperatorMap.isEmpty()) {
            OpmcLogUtils.error((String)"syncCooperator", (String)"\u3010OPMC\u3011-dealCooperateTasks , param cooperatorMap is null.");
            return resultBo;
        }
        ArrayList<Long> mainTaskIdList = new ArrayList(10);
        try (TXHandle txhandle = TX.required();){
            ArrayList<Long> mainTaskHandlerIdList = new ArrayList<Long>(10);
            mainTaskHandlerIdList.addAll(cooperatorMap.keySet());
            if (mainTaskHandlerIdList.size() > 0) {
                DynamicObject[] mainTaskDyns = this.FLOW_RU_TASK_ENTITYSERVICE.queryMainTasks(mainTaskHandlerIdList, activityId, workflowType);
                HashMap<Long, List<Long>> mainTaskCoopMap = new HashMap<Long, List<Long>>(16);
                for (DynamicObject mainTask : mainTaskDyns) {
                    mainTaskCoopMap.put(mainTask.getLong("id"), cooperatorMap.get(mainTask.getLong("handler.id")));
                }
                resultBo = this.generateCooperatorTask(mainTaskCoopMap);
                mainTaskIdList = Arrays.stream(mainTaskDyns).map(mt -> mt.getLong("id")).collect(Collectors.toList());
                DynamicObject[] coopTaskDyns = this.FLOW_RU_TASK_ENTITYSERVICE.loadCoopTasksByMainTaskIds(mainTaskIdList);
                FlowMsgMergeEnumBO flowMsgMergeEnumBO = this.assembleFlowMsgMergeEnumBO(workflowType);
                HashMap<Long, Boolean> ret = new HashMap<Long, Boolean>();
                if (!workflowType.contains("3")) {
                    this.sendCooperatorMessageLogic(coopTaskDyns, flowMsgMergeEnumBO, ret);
                }
            }
        }
        return resultBo;
    }
}

