/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.pbs.business.domain.workflow.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.opmc.pbs.business.ServiceFactory;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowRuTaskEntityService;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuTaskStatusEnum;
import kd.opmc.pbs.business.domain.workflow.service.FlowRunSupDomainService;
import kd.opmc.pbs.common.utils.OpmcLogUtils;

public class FlowCooperateRuProcDomainService {
    private static Log LOGGER = OpmcLogUtils.getLogger(FlowCooperateRuProcDomainService.class);
    private static final FlowRuTaskEntityService FLOW_RU_TASK_ENTITY_SERVICE = FlowRuTaskEntityService.getInstance();
    private static final FlowRunSupDomainService FLOW_RUSUP_DOMAIN_SERVICE = FlowRunSupDomainService.getInstance();

    public static FlowCooperateRuProcDomainService getInstance() {
        return ServiceFactory.getService(FlowCooperateRuProcDomainService.class);
    }

    protected void dealTaskStatusForSubmit(DynamicObject task) {
        ArrayList<DynamicObject> needSaveTaskList = new ArrayList<DynamicObject>(10);
        Date currentDate = new Date();
        long currentUserId = UserServiceHelper.getCurrentUserId();
        FLOW_RUSUP_DOMAIN_SERVICE.updateTaskStatus(task, FlowRuTaskStatusEnum.PROCESSED.getCode(), currentDate, currentUserId);
        if (task.getBoolean("iscotask")) {
            needSaveTaskList.add(task);
            Long hostTaskId = task.getLong("hosttask.id");
            DynamicObject mainTask = FLOW_RU_TASK_ENTITY_SERVICE.queryTaskByPk(hostTaskId);
            FLOW_RUSUP_DOMAIN_SERVICE.updateTaskStatus(mainTask, FlowRuTaskStatusEnum.PROCESSED.getCode(), currentDate, currentUserId);
            mainTask.set("iscohandlerdeal", (Object)Boolean.TRUE);
            needSaveTaskList.add(mainTask);
            DynamicObject[] coopTasks = FLOW_RU_TASK_ENTITY_SERVICE.loadCoopTasksByMainTaskIds(Collections.singletonList(hostTaskId));
            DynamicObject[] needUpdateCoopTasks = (DynamicObject[])Arrays.stream(coopTasks).filter(ct -> ct.getLong("id") != task.getLong("id")).toArray(DynamicObject[]::new);
            if (needUpdateCoopTasks.length > 0) {
                FLOW_RUSUP_DOMAIN_SERVICE.updateTaskStatus(needUpdateCoopTasks, FlowRuTaskStatusEnum.EXPIRED.getCode());
                needSaveTaskList.addAll(Arrays.asList(needUpdateCoopTasks));
            }
        } else {
            task.set("iscohandlerdeal", (Object)Boolean.FALSE);
            FLOW_RU_TASK_ENTITY_SERVICE.saveOne(task);
            Long hostTaskId = task.getLong("id");
            DynamicObject[] coopTasks = FLOW_RU_TASK_ENTITY_SERVICE.loadCoopTasksByMainTaskIds(Collections.singletonList(hostTaskId));
            if (coopTasks.length > 0) {
                FLOW_RUSUP_DOMAIN_SERVICE.updateTaskStatus(coopTasks, FlowRuTaskStatusEnum.EXPIRED.getCode());
                needSaveTaskList.addAll(Arrays.asList(coopTasks));
            }
        }
        if (!CollectionUtils.isEmpty(needSaveTaskList)) {
            FLOW_RU_TASK_ENTITY_SERVICE.save(needSaveTaskList.toArray(new DynamicObject[0]));
        }
    }
}

