/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.pbs.business.domain.workflow.service;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.ORM;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.pbs.business.ServiceFactory;
import kd.opmc.pbs.business.domain.workflow.constants.FlowCheckConfigConstants;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowDefNodeEntityService;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowDefProcEntityService;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowDefProcWithoutEntryEntityService;
import kd.opmc.pbs.business.domain.workflow.entityservice.WorkFlowEntityService;
import kd.opmc.pbs.business.domain.workflow.model.CheckFlowBo;
import kd.opmc.pbs.business.domain.workflow.model.FlowDefNodeBo;
import kd.opmc.pbs.business.domain.workflow.model.WorkflowBo;
import kd.opmc.pbs.business.domain.workflow.utils.WorkflowUtils;
import kd.opmc.pbs.business.external.epa.IEPAPerfWorkflowService;
import kd.opmc.pbs.business.model.FlowDefProcBo;
import kd.opmc.pbs.business.model.FlowDefProcItemBo;
import kd.opmc.pbs.business.model.FlowNodeBo;
import kd.opmc.pbs.business.model.FlowNodeItemBo;
import kd.opmc.pbs.business.model.FlowUserBo;
import kd.opmc.pbs.business.model.NodeRoleBo;
import kd.opmc.pbs.common.constants.NodeTypeConstants;
import kd.opmc.pbs.common.constants.RoleTypeConstants;
import org.apache.commons.lang3.RandomStringUtils;

public class FlowDefProcDomainService {
    private static final FlowDefProcEntityService FLOW_DEF_PROC_ENTITY_SERVICE = FlowDefProcEntityService.getInstance();
    private static final FlowDefProcWithoutEntryEntityService FLOW_DEF_PROC_WITHOUT_ENTRY_ENTITY_SERVICE = FlowDefProcWithoutEntryEntityService.getInstance();
    private static final IEPAPerfWorkflowService PERFWORKFLOW_SERVICE = IEPAPerfWorkflowService.getInstance();
    private static final FlowDefNodeEntityService FLOW_DEF_NODE_ENTITY_SERVICE = FlowDefNodeEntityService.getInstance();

    public static FlowDefProcDomainService getInstance() {
        return ServiceFactory.getService(FlowDefProcDomainService.class);
    }

    public DynamicObject[] getFlowDefProc(List<Long> ids) {
        return FLOW_DEF_PROC_ENTITY_SERVICE.getFlowDefProc(ids);
    }

    public DynamicObject[] getFlowDefProcWithoutEntry(List<Long> ids) {
        return FLOW_DEF_PROC_WITHOUT_ENTRY_ENTITY_SERVICE.getFlowDefProcWithoutEntry(ids);
    }

    public Map<Long, List<DynamicObject>> getFlowDefNode(List<Long> ids) {
        DynamicObject[] flowDefNode = FLOW_DEF_NODE_ENTITY_SERVICE.getFlowDefNodeByDefProcId(ids);
        Map<Long, List<DynamicObject>> keyProcValNode = Arrays.stream(flowDefNode).collect(Collectors.groupingBy(node -> node.getLong("defproc")));
        keyProcValNode.forEach((k, v) -> v.sort(Comparator.comparing(v1 -> v1.getInt("entryseq"))));
        return keyProcValNode;
    }

    public List<Long> saveFlowDefProc(List<FlowDefProcItemBo> flowDefProcItems) {
        ArrayList<Long> procIds = new ArrayList<Long>();
        DynamicObjectCollection dynamicObjects = new DynamicObjectCollection();
        DynamicObjectCollection nodeCollection = new DynamicObjectCollection();
        long[] defProcIds = ORM.create().genLongIds("pbs_flowdefproc", flowDefProcItems.size());
        for (int i = 0; i < flowDefProcItems.size(); ++i) {
            FlowDefProcItemBo flowDefProcItem = flowDefProcItems.get(i);
            long defProcId = defProcIds[i];
            DynamicObject flowDefProcDynObj = FLOW_DEF_PROC_WITHOUT_ENTRY_ENTITY_SERVICE.generateEmptyDynamicObject("pbs_flowdefproc_new");
            flowDefProcDynObj.set("id", (Object)defProcId);
            this.buildFlowDefProcDyn(flowDefProcDynObj, flowDefProcItem);
            List<FlowNodeItemBo> nodes = flowDefProcItem.getNodes();
            DynamicObjectCollection nodeEntry = new DynamicObjectCollection();
            HashMap<Long, DynamicObject> checkNodeMap = new HashMap<Long, DynamicObject>(16);
            for (FlowNodeItemBo node : nodes) {
                DynamicObject nodeDynObj = FLOW_DEF_NODE_ENTITY_SERVICE.generateEmptyDynamicObject("pbs_flowdefnode");
                nodeDynObj.set("defproc", (Object)defProcId);
                this.buildNodeDyn(nodeDynObj, node, checkNodeMap);
                List<NodeRoleBo> nodeRoleList = node.getNodeRoleList();
                DynamicObjectCollection roleEntry = nodeDynObj.getDynamicObjectCollection("roleentry");
                HashMap<Long, DynamicObject> checkRoleMap = new HashMap<Long, DynamicObject>(16);
                for (NodeRoleBo nodeRole : nodeRoleList) {
                    DynamicObject roleDynObj = roleEntry.addNew();
                    this.buildRoleDyn(roleDynObj, nodeRole, checkRoleMap);
                }
                nodeEntry.add((Object)nodeDynObj);
            }
            nodeCollection.addAll((Collection)nodeEntry);
            dynamicObjects.add((Object)flowDefProcDynObj);
        }
        FLOW_DEF_NODE_ENTITY_SERVICE.save(nodeCollection);
        Object[] saveRet = FLOW_DEF_PROC_WITHOUT_ENTRY_ENTITY_SERVICE.save((DynamicObject[])dynamicObjects.toArray((Object[])new DynamicObject[0]));
        if (!HRObjectUtils.isEmpty((Object)saveRet)) {
            for (Object o : saveRet) {
                DynamicObject dyn = (DynamicObject)o;
                procIds.add(dyn.getLong("id"));
            }
        }
        return procIds;
    }

    private void buildFlowDefProcDyn(DynamicObject flowDefProcDynObj, FlowDefProcItemBo flowDefProcItem) {
        flowDefProcDynObj.set("number", (Object)flowDefProcItem.getFlowName());
        flowDefProcDynObj.set("name", (Object)flowDefProcItem.getFlowName());
        flowDefProcDynObj.set("ismatrixproc", (Object)flowDefProcItem.isMatrixProc());
        flowDefProcDynObj.set("ismajorproc", (Object)flowDefProcItem.isMajorProc());
        flowDefProcDynObj.set("workflowtype", (Object)flowDefProcItem.getWorkflowtype());
        flowDefProcDynObj.set("index", (Object)flowDefProcItem.getFlowSeq());
        flowDefProcDynObj.set("creator", (Object)RequestContext.get().getCurrUserId());
    }

    private void buildNodeDyn(DynamicObject nodeDynObj, FlowNodeItemBo node, Map<Long, DynamicObject> checkNodeMap) {
        nodeDynObj.set("sourcenodeid", (Object)node.getSourceNodeId());
        nodeDynObj.set("entryseq", (Object)node.getNodeSeq());
        nodeDynObj.set("ismajornode", (Object)node.isMajorNode());
        nodeDynObj.set("ismatrixnode", (Object)node.isMatrixNode());
        nodeDynObj.set("majornodeseq", (Object)node.getMajorNodeSeq());
        nodeDynObj.set("nodename", (Object)node.getNodeName());
        nodeDynObj.set("nodetype", (Object)node.getNodeType());
        nodeDynObj.set("nodeweight", (Object)node.getNodeWeight());
        nodeDynObj.set("handlertype", (Object)node.getHandlerType());
        nodeDynObj.set("appointemp", (Object)node.getAppointment());
        if (RoleTypeConstants.APPOINTOR.equals(node.getHandlerType())) {
            DynamicObjectCollection userEntry = nodeDynObj.getDynamicObjectCollection("userentry");
            userEntry.clear();
            for (Long userId : node.getMultiUserOrPost()) {
                Long depempId = this.getPersonId(userId, node.getUserBoList());
                DynamicObject userDy = userEntry.addNew();
                userDy.set("user", (Object)userId);
                userDy.set("depemp", (Object)depempId);
            }
        } else if (RoleTypeConstants.APPOINT_POSITION.equals(node.getHandlerType())) {
            DynamicObjectCollection postEntry = nodeDynObj.getDynamicObjectCollection("postentry");
            postEntry.clear();
            for (Long postId : node.getMultiUserOrPost()) {
                DynamicObject postDy = postEntry.addNew();
                postDy.set("post", (Object)postId);
            }
        }
        nodeDynObj.set("crossscore", (Object)node.isCrossScore());
        nodeDynObj.set("supporttotalscore", (Object)node.isSupportTotalScore());
        nodeDynObj.set("iscopy", (Object)node.isCopy());
        if (node.isCopy()) {
            nodeDynObj.set("copyperson", (Object)node.getCopyPerson());
            nodeDynObj.set("copyappointperson", (Object)node.getCopyAppointPerson());
        } else {
            nodeDynObj.set("copyperson", (Object)0L);
            nodeDynObj.set("copyappointperson", (Object)0L);
        }
        nodeDynObj.set("manualop", (Object)node.isManualop());
        nodeDynObj.set("sameauditjump", (Object)node.isSameauditjump());
        nodeDynObj.set("adjusetscorelowerlimit", (Object)node.getAdjusetScoreLowerlimit());
        nodeDynObj.set("adjustscoreuplimit", (Object)node.getAdjustScoreUplimit());
        checkNodeMap.put(node.getId(), nodeDynObj);
    }

    private Long getPersonId(Long userId, List<FlowUserBo> userBoList) {
        List depempId;
        if (CollectionUtils.isNotEmpty(userBoList) && 0L != userId && CollectionUtils.isNotEmpty(depempId = userBoList.stream().filter(user -> user.getUserId().equals(userId)).map(FlowUserBo::getDepempId).collect(Collectors.toList()))) {
            return (Long)depempId.get(0);
        }
        return 0L;
    }

    private void buildRoleDyn(DynamicObject roleDynObj, NodeRoleBo nodeRole, Map<Long, DynamicObject> checkRoleMap) {
        roleDynObj.set("seq", (Object)nodeRole.getRoleSeq());
        roleDynObj.set("roletype", (Object)nodeRole.getRoleType());
        roleDynObj.set("roleweight", (Object)nodeRole.getRoleWeight());
        roleDynObj.set("confjson", (Object)nodeRole.getConfjson());
        roleDynObj.set("secondtype", (Object)nodeRole.getSecondType());
        roleDynObj.set("secondf7", (Object)nodeRole.getSecondF7());
        roleDynObj.set("issameorg", (Object)nodeRole.isIssameOrg());
        roleDynObj.set("outflow", (Object)nodeRole.getOutFlow());
        roleDynObj.set("minnum", (Object)nodeRole.getMinNum());
        roleDynObj.set("turnoversort", (Object)nodeRole.getTurnoverSort());
        roleDynObj.set("rolename", (Object)("null".equals(nodeRole.getRoleName()) ? "" : nodeRole.getRoleName()));
        roleDynObj.set("reviewercanedit", (Object)nodeRole.isReviewercanedit());
        roleDynObj.set("evaviewperm", (Object)nodeRole.getEvaviewPerm());
        roleDynObj.set("ishideevaname", (Object)nodeRole.getIsHideEvaname());
        if (RoleTypeConstants.APPOINTOR.equals(nodeRole.getRoleType())) {
            DynamicObjectCollection userEntry = roleDynObj.getDynamicObjectCollection("roleuserentry");
            userEntry.clear();
            for (Long userId : nodeRole.getMultiUserOrPost()) {
                Long depempId = this.getPersonId(userId, nodeRole.getUserBoList());
                DynamicObject userDy = userEntry.addNew();
                userDy.set("roleuser", (Object)userId);
                userDy.set("roledepemp", (Object)depempId);
            }
        } else if (RoleTypeConstants.APPOINT_POSITION.equals(nodeRole.getRoleType())) {
            DynamicObjectCollection postEntry = roleDynObj.getDynamicObjectCollection("rolepostentry");
            postEntry.clear();
            for (Long postId : nodeRole.getMultiUserOrPost()) {
                DynamicObject postDy = postEntry.addNew();
                postDy.set("rolepost", (Object)postId);
            }
        }
        checkRoleMap.put(nodeRole.getId(), roleDynObj);
    }

    public boolean validatorFlowData(DynamicObject[] workflows, DynamicObject currWorkFlow, List<CheckFlowBo> checkFlowBos) {
        List names = Stream.of(workflows).map(it -> it.getString("name")).collect(Collectors.toList());
        String currName = currWorkFlow.getString("name");
        for (String name : names) {
            if (!HRStringUtils.equals((String)name, (String)currName)) continue;
            names.remove(name);
            break;
        }
        boolean flag = true;
        if (names.contains(currName)) {
            CheckFlowBo checkFlowBo = new CheckFlowBo(currName, FlowCheckConfigConstants.getCheckTypeFlow(), currName, FlowCheckConfigConstants.getCheckClassifyUnique(), FlowCheckConfigConstants.getCheckInfoFlowRepeat());
            checkFlowBos.add(checkFlowBo);
            flag = false;
        }
        DynamicObjectCollection entryentity = currWorkFlow.getDynamicObjectCollection("entryentity");
        List<Long> procIds = entryentity.stream().map(proc -> proc.getLong("flowdefproc")).collect(Collectors.toList());
        DynamicObject[] flowDefProcs = this.getFlowDefProcWithoutEntry(procIds);
        Map<Long, List<DynamicObject>> keyProcValNode = this.getFlowDefNode(procIds);
        return this.validatorFlowData(flag, currWorkFlow.getString("name"), flowDefProcs, keyProcValNode, checkFlowBos);
    }

    private boolean checkFlowName(String flowName, ArrayList<String> flowNames, List<CheckFlowBo> checkFlowBos, boolean flag) {
        if (flowNames.contains(flowName)) {
            CheckFlowBo checkFlowBo = new CheckFlowBo(flowName, FlowCheckConfigConstants.getCheckTypeFlow(), flowName, FlowCheckConfigConstants.getCheckClassifyUnique(), FlowCheckConfigConstants.getCheckInfoFlowMatrixRepeat());
            checkFlowBos.add(checkFlowBo);
            flag = false;
        }
        flowNames.add(flowName);
        return flag;
    }

    private boolean checkNodeName(String flowName, String nodeName, List<CheckFlowBo> checkFlowBos, boolean flag) {
        if (HRStringUtils.isEmpty((String)nodeName)) {
            CheckFlowBo checkFlowBo = new CheckFlowBo(flowName, FlowCheckConfigConstants.getCheckTypeNode(), nodeName, FlowCheckConfigConstants.getCheckClassifyMust(), FlowCheckConfigConstants.getCheckInfoNodeNameMust());
            checkFlowBos.add(checkFlowBo);
            flag = false;
        } else if (nodeName.length() > 60) {
            CheckFlowBo checkFlowBo = new CheckFlowBo(flowName, FlowCheckConfigConstants.getCheckTypeNode(), nodeName, FlowCheckConfigConstants.getCheckClassifyNodeConf(), FlowCheckConfigConstants.getCheckInfoNodeNameMaxLength());
            checkFlowBos.add(checkFlowBo);
            flag = false;
        }
        return flag;
    }

    private boolean checkNode(ArrayList<String> nodeNames, DynamicObject node, String flowName, List<CheckFlowBo> checkFlowBos, boolean flag) {
        CheckFlowBo checkFlowBo;
        String nodeName = node.getString("nodename");
        Long nodeType = node.getLong("nodetype.id");
        Long handlerType = node.getLong("handlertype.id");
        long appointemp = node.getLong("appointemp");
        boolean nodeTypeNotnullCheck = Boolean.TRUE;
        boolean auditNodeCheck = Boolean.TRUE;
        boolean nodeNameRepeatCheck = Boolean.TRUE;
        if (null == nodeType || nodeType.equals(0L)) {
            checkFlowBo = new CheckFlowBo(flowName, FlowCheckConfigConstants.getCheckTypeNode(), nodeName, FlowCheckConfigConstants.getCheckClassifyMust(), FlowCheckConfigConstants.getCheckInfoNodeTypeMust());
            checkFlowBos.add(checkFlowBo);
            nodeTypeNotnullCheck = false;
        } else if ((0L == handlerType || RoleTypeConstants.APPOINTOR.equals(handlerType) && 0L == appointemp) && NodeTypeConstants.EVALUATE_AUDIT.equals(nodeType)) {
            String checkInfo = FlowCheckConfigConstants.getCheckInfoNodeApproveMust();
            CheckFlowBo checkFlowBo2 = new CheckFlowBo(flowName, FlowCheckConfigConstants.getCheckTypeNode(), nodeName, FlowCheckConfigConstants.getCheckClassifyMust(), checkInfo);
            checkFlowBos.add(checkFlowBo2);
            auditNodeCheck = false;
        }
        if (nodeNames.contains(nodeName)) {
            checkFlowBo = new CheckFlowBo(flowName, FlowCheckConfigConstants.getCheckTypeNode(), nodeName, FlowCheckConfigConstants.getCheckClassifyUnique(), FlowCheckConfigConstants.getCheckInfoNodeRepeat());
            checkFlowBos.add(checkFlowBo);
            nodeNameRepeatCheck = false;
        }
        if (HRStringUtils.isNotEmpty((String)nodeName)) {
            nodeNames.add(nodeName);
        }
        flag = nodeTypeNotnullCheck && auditNodeCheck && nodeNameRepeatCheck;
        return flag;
    }

    private boolean checkRole(DynamicObject role, String flowName, String nodeName, List<CheckFlowBo> checkFlowBos, boolean flag, Long nodeType, List<String> roleNameList) {
        CheckFlowBo checkFlowBo;
        String roleName = role.getLocaleString("rolename").getLocaleValue();
        if (HRStringUtils.isEmpty((String)roleName)) {
            checkFlowBo = new CheckFlowBo(flowName, FlowCheckConfigConstants.getCheckTypeNode(), nodeName, FlowCheckConfigConstants.getCheckClassifyMust(), FlowCheckConfigConstants.getCheckInfoRoleNameIsEmpty());
            checkFlowBos.add(checkFlowBo);
            flag = false;
        } else if (roleName.length() > 60) {
            checkFlowBo = new CheckFlowBo(flowName, FlowCheckConfigConstants.getCheckTypeNode(), nodeName, FlowCheckConfigConstants.getCheckClassifyRoleConf(), FlowCheckConfigConstants.getCheckInfoRoleNameMaxLength());
            checkFlowBos.add(checkFlowBo);
            flag = false;
        }
        if (roleNameList.contains(roleName) && !HRStringUtils.isEmpty((String)roleName)) {
            checkFlowBo = new CheckFlowBo(flowName, FlowCheckConfigConstants.getCheckTypeNode(), nodeName, FlowCheckConfigConstants.getCheckClassifyUnique(), FlowCheckConfigConstants.getCheckInfoRoleRepeat(roleName));
            checkFlowBos.add(checkFlowBo);
            flag = false;
        } else {
            roleNameList.add(roleName);
        }
        if (HRStringUtils.isEmpty((String)role.getString("roletype"))) {
            checkFlowBo = new CheckFlowBo(flowName, FlowCheckConfigConstants.getCheckTypeNode(), nodeName, FlowCheckConfigConstants.getCheckClassifyMust(), FlowCheckConfigConstants.getCheckInfoRoleTypeMust());
            checkFlowBos.add(checkFlowBo);
            flag = false;
        } else {
            DynamicObjectCollection rolepost;
            Long roletype = role.getLong("roletype.id");
            if (HRStringUtils.isEmpty((String)roleName) || "null".equalsIgnoreCase(roleName)) {
                roleName = role.getDynamicObject("roletype").getString("name");
            }
            if (RoleTypeConstants.APPOINT_DEPHEADER.equals(roletype) && (null == role.get("secondf7") || role.get("secondf7").equals(0L))) {
                CheckFlowBo checkFlowBo2 = new CheckFlowBo(flowName, FlowCheckConfigConstants.getCheckClassifyRoleConf(), roleName, FlowCheckConfigConstants.getCheckClassifyMust(), FlowCheckConfigConstants.getAppointDepIsEmpty());
                checkFlowBos.add(checkFlowBo2);
                flag = false;
            }
            if (RoleTypeConstants.APPOINT_POSITION.equals(roletype) && (null == role.get("secondf7") || role.get("secondf7").equals(0L)) && (rolepost = role.getDynamicObjectCollection("rolepostentry")).isEmpty()) {
                CheckFlowBo checkFlowBo3 = new CheckFlowBo(flowName, FlowCheckConfigConstants.getCheckClassifyRoleConf(), roleName, FlowCheckConfigConstants.getCheckClassifyMust(), FlowCheckConfigConstants.getAppointPosIsEmpty());
                checkFlowBos.add(checkFlowBo3);
                flag = false;
            }
        }
        if (HRStringUtils.equals((String)"20", (String)role.getString("outflow")) && (role.getInt("minnum") < 1 || role.getInt("minnum") > 20)) {
            checkFlowBo = new CheckFlowBo(flowName, FlowCheckConfigConstants.getCheckTypeNode(), nodeName, FlowCheckConfigConstants.getCheckClassifyMust(), FlowCheckConfigConstants.getCheckInfoRoleNumMinMust());
            checkFlowBos.add(checkFlowBo);
            flag = false;
        }
        if (null != nodeType && nodeType.equals(NodeTypeConstants.EVALUATE_SCORE) && (null == role.getString("turnoversort") || "0".equals(role.getString("turnoversort")))) {
            checkFlowBo = new CheckFlowBo(flowName, FlowCheckConfigConstants.getCheckTypeNode(), nodeName, FlowCheckConfigConstants.getCheckClassifyMust(), FlowCheckConfigConstants.getCheckInfoRoleSortMust());
            checkFlowBos.add(checkFlowBo);
            flag = false;
        }
        return flag;
    }

    private boolean validatorFlowData(boolean flag, String flowName, DynamicObject[] flowDefProcs, Map<Long, List<DynamicObject>> keyProcValNode, List<CheckFlowBo> checkFlowBos) {
        ArrayList<String> flowNames = new ArrayList<String>();
        ArrayList<String> nodeNames = new ArrayList<String>();
        boolean flowNameCheckFlag = Boolean.TRUE;
        boolean nodeNumCheckFlag = Boolean.TRUE;
        boolean roleNumCheckFlag = Boolean.TRUE;
        boolean nodeNameCheckFlag = Boolean.TRUE;
        boolean nodeTypeCheckFlag = Boolean.TRUE;
        boolean weightCheckFlag = Boolean.TRUE;
        boolean subflowNameCheckFlag = Boolean.TRUE;
        boolean adjustScoreCheckFlag = Boolean.TRUE;
        boolean auditCountCheckFlag = Boolean.TRUE;
        boolean copyPersonCheckFlag = Boolean.TRUE;
        boolean substituteCheckFlag = Boolean.TRUE;
        boolean roleCheckFlag = Boolean.TRUE;
        boolean interviewFlowWriteNodeCheck = Boolean.FALSE;
        if (HRStringUtils.isEmpty((String)flowName)) {
            CheckFlowBo checkFlowBo = new CheckFlowBo(flowName, FlowCheckConfigConstants.getCheckTypeFlow(), flowName, FlowCheckConfigConstants.getCheckClassifyMust(), FlowCheckConfigConstants.getCheckInfoWorkflowNameIsEmpty());
            checkFlowBos.add(checkFlowBo);
            flowNameCheckFlag = false;
        }
        for (DynamicObject flowDefProc : flowDefProcs) {
            Object checkFlowBo;
            subflowNameCheckFlag = this.checkFlowName(flowName, flowNames, checkFlowBos, flag);
            List<DynamicObject> nodeEntry = keyProcValNode.get(flowDefProc.getLong("id"));
            if (CollectionUtils.isEmpty(nodeEntry)) {
                checkFlowBo = new CheckFlowBo(flowName, FlowCheckConfigConstants.getCheckTypeFlow(), flowName, FlowCheckConfigConstants.getCheckClassifyNodeConf(), FlowCheckConfigConstants.getCheckInfoNodeCount());
                checkFlowBos.add((CheckFlowBo)checkFlowBo);
                nodeNumCheckFlag = false;
                continue;
            }
            nodeNames.clear();
            for (DynamicObject node : nodeEntry) {
                DynamicObjectCollection userEntry;
                CheckFlowBo checkFlowBo2;
                DynamicObjectCollection postEntry;
                CheckFlowBo checkFlowBo3;
                String nodeName = node.getString("nodename");
                nodeNameCheckFlag = this.checkNodeName(flowName, nodeName, checkFlowBos, flag) && nodeNameCheckFlag;
                Long nodeType = node.getLong("nodetype.id");
                if (NodeTypeConstants.INTERVIEW_WRITE.equals(nodeType)) {
                    interviewFlowWriteNodeCheck = true;
                }
                boolean bl = nodeTypeCheckFlag = this.checkNode(nodeNames, node, flowName, checkFlowBos, flag) && nodeTypeCheckFlag;
                if (!nodeTypeCheckFlag) break;
                DynamicObjectCollection roleEntry = node.getDynamicObjectCollection("roleentry");
                if (roleEntry.isEmpty()) {
                    checkFlowBo3 = new CheckFlowBo(flowName, FlowCheckConfigConstants.getCheckTypeNode(), nodeName, FlowCheckConfigConstants.getCheckClassifyRoleConf(), FlowCheckConfigConstants.getCheckInfoRoleCount());
                    checkFlowBos.add(checkFlowBo3);
                    roleNumCheckFlag = false;
                } else {
                    ArrayList<String> roleNameList = new ArrayList<String>(10);
                    for (DynamicObject roleObj : roleEntry) {
                        roleCheckFlag = this.checkRole(roleObj, flowName, nodeName, checkFlowBos, roleCheckFlag, node.getLong("nodetype.id"), roleNameList) && roleCheckFlag;
                    }
                }
                if (!HRStringUtils.isEmpty((String)flowDefProc.getString("workflowtype")) && flowDefProc.getString("workflowtype").equals("2") && NodeTypeConstants.BATCH_ADJUSTSUMSCORE.longValue() == node.getLong("nodetype.id")) {
                    boolean bl2 = adjustScoreCheckFlag = this.checkAdjustScore(node, flowName, nodeName, checkFlowBos) && adjustScoreCheckFlag;
                }
                if (node.getBoolean("iscopy")) {
                    if (null == node.get("copyperson") || node.get("copyperson").equals(0L)) {
                        checkFlowBo3 = new CheckFlowBo(flowName, FlowCheckConfigConstants.getCheckTypeNode(), nodeName, FlowCheckConfigConstants.getCheckClassifyMust(), FlowCheckConfigConstants.getCopyPersonIsEmpty());
                        checkFlowBos.add(checkFlowBo3);
                        copyPersonCheckFlag = false;
                    } else {
                        if (RoleTypeConstants.APPOINT_DEPHEADER.equals(node.getLong("copyperson.id")) && (null == node.get("copyappointperson") || node.get("copyappointperson").equals(0L))) {
                            checkFlowBo3 = new CheckFlowBo(flowName, FlowCheckConfigConstants.getCheckTypeNode(), nodeName, FlowCheckConfigConstants.getCheckClassifyMust(), FlowCheckConfigConstants.getAppointDepIsEmpty());
                            checkFlowBos.add(checkFlowBo3);
                            copyPersonCheckFlag = false;
                        }
                        if (RoleTypeConstants.APPOINT_POSITION.equals(node.getLong("copyperson.id")) && (null == node.get("copyappointperson") || node.get("copyappointperson").equals(0L))) {
                            checkFlowBo3 = new CheckFlowBo(flowName, FlowCheckConfigConstants.getCheckTypeNode(), nodeName, FlowCheckConfigConstants.getCheckClassifyMust(), FlowCheckConfigConstants.getAppointPosIsEmpty());
                            checkFlowBos.add(checkFlowBo3);
                            copyPersonCheckFlag = false;
                        }
                    }
                }
                if (null == node.get("handlertype")) continue;
                if (RoleTypeConstants.APPOINT_DEPHEADER.equals(node.getLong("handlertype.id")) && (null == node.get("appointemp") || node.get("appointemp").equals(0L))) {
                    checkFlowBo3 = new CheckFlowBo(flowName, FlowCheckConfigConstants.getCheckTypeNode(), nodeName, FlowCheckConfigConstants.getCheckClassifyMust(), FlowCheckConfigConstants.getAppointDepIsEmpty());
                    checkFlowBos.add(checkFlowBo3);
                    substituteCheckFlag = false;
                }
                if (RoleTypeConstants.APPOINT_POSITION.equals(node.getLong("handlertype.id")) && (null == node.get("appointemp") || node.get("appointemp").equals(0L)) && (postEntry = node.getDynamicObjectCollection("postentry")).isEmpty()) {
                    checkFlowBo2 = new CheckFlowBo(flowName, FlowCheckConfigConstants.getCheckTypeNode(), nodeName, FlowCheckConfigConstants.getCheckClassifyMust(), FlowCheckConfigConstants.getAppointPosIsEmpty());
                    checkFlowBos.add(checkFlowBo2);
                    substituteCheckFlag = false;
                }
                if (!RoleTypeConstants.APPOINTOR.equals(node.getLong("handlertype.id")) || null != node.get("appointemp") && !node.get("appointemp").equals(0L) || !(userEntry = node.getDynamicObjectCollection("userentry")).isEmpty()) continue;
                checkFlowBo2 = new CheckFlowBo(flowName, FlowCheckConfigConstants.getCheckTypeNode(), nodeName, FlowCheckConfigConstants.getCheckClassifyMust(), FlowCheckConfigConstants.getSubstituteNameIsEmpty());
                checkFlowBos.add(checkFlowBo2);
                substituteCheckFlag = false;
            }
            if (!HRStringUtils.isEmpty((String)flowDefProc.getString("workflowtype"))) {
                if (flowDefProc.getString("workflowtype").equals("3")) {
                    if (!interviewFlowWriteNodeCheck) {
                        checkFlowBo = new CheckFlowBo(flowName, FlowCheckConfigConstants.getCheckTypeFlow(), flowName, FlowCheckConfigConstants.getCheckClassifyNodeConf(), FlowCheckConfigConstants.getCheckInterviewFlowWriteNodeMust());
                        checkFlowBos.add((CheckFlowBo)checkFlowBo);
                    }
                } else {
                    interviewFlowWriteNodeCheck = true;
                }
            }
            if (HRStringUtils.isEmpty((String)flowDefProc.getString("workflowtype")) || !flowDefProc.getString("workflowtype").equals("2")) continue;
            weightCheckFlag = this.checkWeight(nodeEntry, flowName, nodeNames, checkFlowBos);
            auditCountCheckFlag = this.checkAuditCount(nodeEntry, flowName, checkFlowBos);
        }
        flag = flowNameCheckFlag && nodeNumCheckFlag && roleNumCheckFlag && nodeNameCheckFlag && nodeTypeCheckFlag && weightCheckFlag && subflowNameCheckFlag && adjustScoreCheckFlag && auditCountCheckFlag && copyPersonCheckFlag && substituteCheckFlag && roleCheckFlag && interviewFlowWriteNodeCheck;
        return flag;
    }

    private boolean checkAdjustScore(DynamicObject node, String flowName, String nodeName, List<CheckFlowBo> checkFlowBos) {
        BigDecimal adjusetscorelowerlimit = node.getBigDecimal("adjusetscorelowerlimit");
        BigDecimal adjustscoreuplimit = node.getBigDecimal("adjustscoreuplimit");
        BigDecimal zeroLimit = new BigDecimal(0);
        if ((adjusetscorelowerlimit.compareTo(zeroLimit) == 0 || adjustscoreuplimit.compareTo(zeroLimit) == 0) && adjusetscorelowerlimit.compareTo(adjustscoreuplimit) == 0) {
            CheckFlowBo checkFlowBo = new CheckFlowBo(flowName, FlowCheckConfigConstants.getCheckTypeNode(), nodeName, FlowCheckConfigConstants.getCheckClassifyNodeConf(), FlowCheckConfigConstants.checkAdjustScoreLimitZero());
            checkFlowBos.add(checkFlowBo);
            return Boolean.FALSE;
        }
        if (adjustscoreuplimit.compareTo(adjusetscorelowerlimit) < 0) {
            CheckFlowBo checkFlowBo = new CheckFlowBo(flowName, FlowCheckConfigConstants.getCheckTypeNode(), nodeName, FlowCheckConfigConstants.getCheckClassifyNodeConf(), FlowCheckConfigConstants.checkAdjustScore());
            checkFlowBos.add(checkFlowBo);
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private boolean checkAuditCount(List<DynamicObject> nodeEntry, String flowName, List<CheckFlowBo> checkFlowBos) {
        ArrayList<String> auditNodeList = new ArrayList<String>();
        for (DynamicObject node : nodeEntry) {
            if (NodeTypeConstants.EVALUATE_AUDIT.longValue() != node.getLong("nodetype.id")) continue;
            String nodeName = node.getString("nodename");
            auditNodeList.add(nodeName);
        }
        if (auditNodeList.size() > 1) {
            for (String nodeName : auditNodeList) {
                CheckFlowBo checkFlowBo = new CheckFlowBo(flowName, FlowCheckConfigConstants.getCheckTypeNode(), nodeName, FlowCheckConfigConstants.getCheckClassifyNodeConf(), FlowCheckConfigConstants.checkAdjustScore());
                checkFlowBos.add(checkFlowBo);
            }
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private boolean checkWeight(List<DynamicObject> nodeEntry, String flowName, ArrayList<String> nodeNames, List<CheckFlowBo> checkFlowBos) {
        boolean flag = true;
        double nodeWeightTotal = 0.0;
        for (DynamicObject node : nodeEntry) {
            String nodeName = node.getString("nodename");
            if (!NodeTypeConstants.EVALUATE_AUDIT.equals(node.getLong("nodetype.id")) && !NodeTypeConstants.BATCH_ADJUSTSUMSCORE.equals(node.getLong("nodetype.id"))) {
                nodeWeightTotal += Double.parseDouble(node.getString("nodeweight"));
            }
            DynamicObjectCollection roleEntry = node.getDynamicObjectCollection("roleentry");
            double roleWeightTotal = 0.0;
            for (DynamicObject role : roleEntry) {
                if (NodeTypeConstants.EVALUATE_AUDIT.equals(node.getLong("nodetype.id")) || NodeTypeConstants.BATCH_ADJUSTSUMSCORE.equals(node.getLong("nodetype.id"))) continue;
                roleWeightTotal += Double.parseDouble(role.getString("roleweight"));
            }
            if (!(Math.abs(100.0 - roleWeightTotal) > 0.0) || NodeTypeConstants.EVALUATE_AUDIT.equals(node.getLong("nodetype.id")) || NodeTypeConstants.BATCH_ADJUSTSUMSCORE.equals(node.getLong("nodetype.id"))) continue;
            CheckFlowBo checkFlowBo = new CheckFlowBo(flowName, FlowCheckConfigConstants.getCheckTypeNode(), nodeName, FlowCheckConfigConstants.getCheckClassifyWeight(), FlowCheckConfigConstants.getCheckInfoRoleWeight());
            checkFlowBos.add(checkFlowBo);
            flag = false;
        }
        if (Math.abs(100.0 - nodeWeightTotal) > 0.0) {
            CheckFlowBo checkFlowBo = new CheckFlowBo(flowName, FlowCheckConfigConstants.getCheckTypeFlow(), flowName, FlowCheckConfigConstants.getCheckClassifyWeight(), FlowCheckConfigConstants.getCheckInfoNodeWeight());
            checkFlowBos.add(checkFlowBo);
            flag = false;
        }
        return flag;
    }

    public void initFlowNode(List<FlowDefProcBo> flowDefProcs, List<FlowDefProcItemBo> flowDefProcItems, List<Long> procIds) {
        DynamicObject[] defProcs = this.getFlowDefProcWithoutEntry(procIds);
        Map<Long, List<DynamicObject>> keyProcValNode = this.getFlowDefNode(procIds);
        for (DynamicObject dyn : defProcs) {
            FlowDefProcBo flowDefProc = new FlowDefProcBo();
            FlowDefProcItemBo flowDefProcItem = new FlowDefProcItemBo();
            long defProcId = dyn.getLong("id");
            flowDefProcItem.setId(defProcId);
            List<DynamicObject> nodeEntry = keyProcValNode.get(defProcId);
            LinkedList<FlowNodeBo> nodes = new LinkedList<FlowNodeBo>();
            LinkedList<FlowNodeItemBo> itemNodes = new LinkedList<FlowNodeItemBo>();
            for (DynamicObject node : nodeEntry) {
                FlowNodeBo flowNode = new FlowNodeBo();
                flowNode.setNodeSeq(node.getInt("entryseq"));
                flowNode.setNodeName(node.getString("nodename"));
                flowNode.setNodeWeight(Double.parseDouble(node.getString("nodeweight")));
                flowNode.setIsLast(nodeEntry.size() == node.getInt("entryseq"));
                flowNode.setNodeTypeName(node.getString("nodetype.name"));
                flowNode.setNodeTypeCode(node.getString("nodetype.number"));
                nodes.add(flowNode);
                FlowNodeItemBo flowNodeItem = new FlowNodeItemBo();
                flowNodeItem.setIsLast(nodeEntry.size() == node.getInt("entryseq"));
                flowNodeItem.setId(node.getLong("id"));
                flowNodeItem.setSourceNodeId(node.getLong("sourcenodeid"));
                flowNodeItem.setNodeName(flowNode.getNodeName());
                long nodetype = node.getLong("nodetype.id");
                flowNodeItem.setNodeType(nodetype);
                flowNodeItem.setNodeWeight(flowNode.getNodeWeight());
                flowNodeItem.setNodeSeq(flowNode.getNodeSeq());
                flowNodeItem.setHandlerType(node.getLong("handlertype.id"));
                flowNodeItem.setIsMajorNode(node.getBoolean("ismajornode"));
                flowNodeItem.setIsMatrixNode(node.getBoolean("ismatrixnode"));
                flowNodeItem.setAppointment(node.getLong("appointemp"));
                ArrayList<Long> ids = new ArrayList<Long>(10);
                if (RoleTypeConstants.APPOINTOR.equals(flowNodeItem.getHandlerType())) {
                    ArrayList<FlowUserBo> userBos = new ArrayList<FlowUserBo>(10);
                    DynamicObjectCollection userEntry = node.getDynamicObjectCollection("userentry");
                    Iterator iterator = userEntry.iterator();
                    while (iterator.hasNext()) {
                        DynamicObject user = (DynamicObject)iterator.next();
                        DynamicObject dataUser = user.getDynamicObject("user");
                        if (HRObjectUtils.isEmpty((Object)dataUser)) continue;
                        long depempId = user.getLong("depemp.id");
                        FlowUserBo userBo = new FlowUserBo();
                        long userId = dataUser.getLong("id");
                        ids.add(userId);
                        userBo.setUserId(userId);
                        userBo.setDepempId(depempId);
                        userBos.add(userBo);
                    }
                    flowNodeItem.setMultiUserOrPost(ids);
                    flowNodeItem.setUserBoList(userBos);
                } else if (RoleTypeConstants.APPOINT_POSITION.equals(flowNodeItem.getHandlerType())) {
                    DynamicObjectCollection postEntry = node.getDynamicObjectCollection("postentry");
                    for (DynamicObject post : postEntry) {
                        ids.add(post.getLong("post.id"));
                    }
                    flowNodeItem.setMultiUserOrPost(ids);
                } else {
                    flowNodeItem.setMultiUserOrPost(ids);
                }
                flowNodeItem.setCrossScore(node.getBoolean("crossscore"));
                flowNodeItem.setSupportTotalScore(node.getBoolean("supporttotalscore"));
                flowNodeItem.setCopy(node.getBoolean("iscopy"));
                if (node.getBoolean("iscopy")) {
                    flowNodeItem.setCopyPerson(node.getLong("copyperson.id"));
                    flowNodeItem.setCopyAppointPerson(node.getLong("copyappointperson"));
                } else {
                    node.set("copyperson", (Object)0L);
                    node.set("copyappointperson", (Object)0L);
                    flowNodeItem.setCopyPerson(0L);
                    flowNodeItem.setCopyAppointPerson(0L);
                }
                flowNodeItem.setManualop(node.getBoolean("manualop"));
                flowNodeItem.setSameauditjump(node.getBoolean("sameauditjump"));
                flowNodeItem.setAdjusetScoreLowerlimit(node.getBigDecimal("adjusetscorelowerlimit"));
                flowNodeItem.setAdjustScoreUplimit(node.getBigDecimal("adjustscoreuplimit"));
                DynamicObjectCollection roleEntry = node.getDynamicObjectCollection("roleentry");
                LinkedList<NodeRoleBo> nodeRoleList = new LinkedList<NodeRoleBo>();
                for (DynamicObject dynamicObject : roleEntry) {
                    this.initNodeRole(nodeRoleList, dynamicObject, nodetype);
                }
                flowNodeItem.setNodeRoleList(nodeRoleList);
                itemNodes.add(flowNodeItem);
            }
            flowDefProc.setFlowSeq(dyn.getInt("index"));
            flowDefProc.setNodes(nodes);
            flowDefProc.setIsMajorProc(dyn.getBoolean("ismajorproc"));
            flowDefProc.setIsMatrixProc(dyn.getBoolean("ismatrixproc"));
            flowDefProc.setFlowName(dyn.getString("name"));
            flowDefProc.setWorkflowType(dyn.getString("workflowtype"));
            flowDefProcs.add(flowDefProc);
            flowDefProcItem.setFlowName(flowDefProc.getFlowName());
            flowDefProcItem.setFlowSeq(flowDefProc.getFlowSeq());
            flowDefProcItem.setIsMajorProc(flowDefProc.isMajorProc());
            flowDefProcItem.setIsMatrixProc(flowDefProc.isMatrixProc());
            flowDefProcItem.setNodes(itemNodes);
            flowDefProcItem.setWorkflowtype(dyn.getString("workflowtype"));
            flowDefProcItems.add(flowDefProcItem);
        }
    }

    private void initNodeRole(LinkedList<NodeRoleBo> nodeRoleList, DynamicObject dynamicObject, Long nodeType) {
        NodeRoleBo nodeRoleBo = new NodeRoleBo();
        nodeRoleBo.setFlag(RandomStringUtils.randomAlphanumeric((int)6));
        nodeRoleBo.setConfjson(JSONObject.parseObject((String)dynamicObject.getString("confjson")));
        nodeRoleBo.setOutFlow(dynamicObject.getString("outflow"));
        nodeRoleBo.setMinNum(dynamicObject.getInt("minnum"));
        nodeRoleBo.setRoleSeq(dynamicObject.getInt("seq"));
        nodeRoleBo.setRoleType(dynamicObject.getLong("roletype.id"));
        nodeRoleBo.setSecondType(dynamicObject.getString("secondtype"));
        nodeRoleBo.setRoleWeight(Double.parseDouble(dynamicObject.getString("roleweight")));
        nodeRoleBo.setSecondF7(dynamicObject.getLong("secondf7"));
        nodeRoleBo.setIssameOrg(dynamicObject.getBoolean("issameorg"));
        nodeRoleBo.setId(dynamicObject.getLong("id"));
        nodeRoleBo.setTurnoverSort(dynamicObject.getInt("turnoversort"));
        nodeRoleBo.setRoleName(dynamicObject.getString("rolename"));
        if (NodeTypeConstants.BATCH_ADJUSTSUMSCORE.equals(nodeType)) {
            nodeRoleBo.setEvaviewPerm(dynamicObject.getInt("evaviewperm"));
        }
        nodeRoleBo.setIsHideEvaname(dynamicObject.getInt("ishideevaname"));
        nodeRoleBo.setReviewercanedit(dynamicObject.getBoolean("reviewercanedit"));
        ArrayList<Long> ids = new ArrayList<Long>(10);
        if (RoleTypeConstants.APPOINTOR.equals(nodeRoleBo.getRoleType())) {
            ArrayList<FlowUserBo> userBos = new ArrayList<FlowUserBo>(10);
            DynamicObjectCollection userEntry = dynamicObject.getDynamicObjectCollection("roleuserentry");
            for (DynamicObject user : userEntry) {
                DynamicObject roleuser = user.getDynamicObject("roleuser");
                if (HRObjectUtils.isEmpty((Object)roleuser)) continue;
                long depempId = user.getLong("roledepemp.id");
                long userId = roleuser.getLong("id");
                ids.add(userId);
                FlowUserBo userBo = new FlowUserBo();
                userBo.setUserId(userId);
                userBo.setDepempId(depempId);
                userBos.add(userBo);
            }
            nodeRoleBo.setMultiUserOrPost(ids);
            nodeRoleBo.setUserBoList(userBos);
        } else if (RoleTypeConstants.APPOINT_POSITION.equals(nodeRoleBo.getRoleType())) {
            DynamicObjectCollection postEntry = dynamicObject.getDynamicObjectCollection("rolepostentry");
            for (DynamicObject post : postEntry) {
                ids.add(post.getLong("rolepost.id"));
            }
            nodeRoleBo.setMultiUserOrPost(ids);
        } else {
            nodeRoleBo.setMultiUserOrPost(ids);
        }
        nodeRoleList.add(nodeRoleBo);
    }

    public List<WorkflowBo> getWorkflowDefByID(Map<Long, Long> flowIdMap) {
        ArrayList<WorkflowBo> workflowBoList = new ArrayList<WorkflowBo>(10);
        ArrayList<Long> pbsflowIds = new ArrayList<Long>(10);
        HashSet<Long> perfWorkflowIds = new HashSet<Long>(16);
        for (Map.Entry<Long, Long> entry : flowIdMap.entrySet()) {
            pbsflowIds.add(entry.getKey());
            perfWorkflowIds.add(entry.getValue());
        }
        DynamicObject[] workflowDynColl = WorkFlowEntityService.getInstance().getWorkflowsByVid(pbsflowIds);
        DynamicObject[] perfWorkflowDynColl = PERFWORKFLOW_SERVICE.getPerfWorkflowsByVid(perfWorkflowIds.stream().collect(Collectors.toList()));
        HashMap perfWorkflowMap = new HashMap(16);
        String SET_INDICATOR = "1";
        String EVALUATE_PERF = "4";
        for (DynamicObject dyn : perfWorkflowDynColl) {
            HashMap<String, String> handlerMap = new HashMap<String, String>(16);
            DynamicObjectCollection passnodeSettingColl = dyn.getDynamicObjectCollection("entryentity");
            for (DynamicObject passnodeDyn : passnodeSettingColl) {
                if (passnodeDyn.getString("node.id").equals(SET_INDICATOR)) {
                    handlerMap.put("1", passnodeDyn.getString("settingmode"));
                    continue;
                }
                if (!passnodeDyn.getString("node.id").equals(EVALUATE_PERF)) continue;
                handlerMap.put("2", passnodeDyn.getString("settingmode"));
            }
            perfWorkflowMap.put(dyn.getLong("id"), handlerMap);
        }
        for (DynamicObject workflowDyn : workflowDynColl) {
            Long flowDefId = ((DynamicObject)workflowDyn.getDynamicObjectCollection("entryentity").get(0)).getLong("flowdefproc");
            DynamicObject flowdefDyn = FLOW_DEF_PROC_ENTITY_SERVICE.loadSingle(flowDefId);
            WorkflowBo workflowBo = new WorkflowBo();
            workflowBo.setWorkflowDyn(workflowDyn);
            workflowBo.setFlowdefDyn(flowdefDyn);
            DynamicObjectCollection nodeDefColl = flowdefDyn.getDynamicObjectCollection("nodeentry");
            ArrayList<FlowDefNodeBo> flowdefNodeBoList = new ArrayList<FlowDefNodeBo>(10);
            for (DynamicObject nodeDefDyn : nodeDefColl) {
                FlowDefNodeBo flowDefNodeBo = new FlowDefNodeBo();
                flowDefNodeBo.setFlowdefNodeDyn(nodeDefDyn);
                DynamicObjectCollection roleDefColl = nodeDefDyn.getDynamicObjectCollection("roleentry");
                flowDefNodeBo.setFlowdefRoleDynColl(roleDefColl);
                flowdefNodeBoList.add(flowDefNodeBo);
            }
            workflowBo.setFlowdefNodeBoList(flowdefNodeBoList);
            String workflowType = workflowDyn.getString("workflowtype");
            Map handsettingMap = (Map)perfWorkflowMap.get(flowIdMap.get(workflowDyn.getLong("id")));
            if (workflowType.equals("1")) {
                workflowBo.setSettingMode((String)handsettingMap.get("1"));
            } else if (workflowType.equals("2")) {
                workflowBo.setSettingMode((String)handsettingMap.get("2"));
            }
            workflowBoList.add(workflowBo);
        }
        return workflowBoList;
    }

    public String getHandlerSettingMode(Long perfworkflowId, String passNode) {
        String settingmode = "";
        DynamicObject[] perfWorkflowDynColl = PERFWORKFLOW_SERVICE.getPerfWorkflowsByVid(Collections.singletonList(perfworkflowId));
        if (perfWorkflowDynColl.length > 0) {
            HashMap<String, String> handlerMap = new HashMap<String, String>(16);
            DynamicObjectCollection passnodeSettingColl = perfWorkflowDynColl[0].getDynamicObjectCollection("entryentity");
            for (DynamicObject passnodeDyn : passnodeSettingColl) {
                handlerMap.put(passnodeDyn.getString("node.id"), passnodeDyn.getString("settingmode"));
            }
            settingmode = (String)handlerMap.get(passNode);
        }
        return settingmode;
    }

    public DynamicObjectCollection getAllNodeDefByWorkflowId(Long workflowId) {
        return FLOW_DEF_NODE_ENTITY_SERVICE.getAllNodeDefByWorkflowId(workflowId);
    }

    public DynamicObject generateDefProcEmptyDynamicObject() {
        return FLOW_DEF_PROC_WITHOUT_ENTRY_ENTITY_SERVICE.generateEmptyDynamicObject();
    }

    public DynamicObject generateDefNodeEmptyDynamicObject() {
        return FLOW_DEF_NODE_ENTITY_SERVICE.generateEmptyDynamicObject();
    }

    public void saveProcAndNode(DynamicObjectCollection newFlowDefs, DynamicObjectCollection newNodes) {
        FLOW_DEF_PROC_WITHOUT_ENTRY_ENTITY_SERVICE.save(newFlowDefs);
        FLOW_DEF_NODE_ENTITY_SERVICE.save(newNodes);
    }

    public List<WorkflowBo> getPbsWorkflowCollByIds(List<Long> pbsflowIds) {
        DynamicObject[] workflowDynColl;
        ArrayList<WorkflowBo> workflowBoList = new ArrayList<WorkflowBo>(10);
        for (DynamicObject workflowDyn : workflowDynColl = WorkFlowEntityService.getInstance().getWorkflowsByVid(pbsflowIds)) {
            Long flowDefId = ((DynamicObject)workflowDyn.getDynamicObjectCollection("entryentity").get(0)).getLong("flowdefproc");
            DynamicObject flowdefDyn = FLOW_DEF_PROC_ENTITY_SERVICE.loadSingle(flowDefId);
            WorkflowBo workflowBo = new WorkflowBo();
            workflowBo.setWorkflowDyn(workflowDyn);
            workflowBo.setFlowdefDyn(flowdefDyn);
            DynamicObjectCollection nodeDefColl = flowdefDyn.getDynamicObjectCollection("nodeentry");
            ArrayList<FlowDefNodeBo> flowdefNodeBoList = new ArrayList<FlowDefNodeBo>(10);
            for (DynamicObject nodeDefDyn : nodeDefColl) {
                FlowDefNodeBo flowDefNodeBo = new FlowDefNodeBo();
                flowDefNodeBo.setFlowdefNodeDyn(nodeDefDyn);
                DynamicObjectCollection roleDefColl = nodeDefDyn.getDynamicObjectCollection("roleentry");
                flowDefNodeBo.setFlowdefRoleDynColl(roleDefColl);
                flowdefNodeBoList.add(flowDefNodeBo);
            }
            workflowBo.setFlowdefNodeBoList(flowdefNodeBoList);
            workflowBoList.add(workflowBo);
        }
        return workflowBoList;
    }

    public Map<Long, Long> getUserIdsByPersonIds(List<Long> personIds) {
        return WorkflowUtils.getUserIdsByPersonIds(personIds);
    }
}

