/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.pbs.business.domain.workflow.service;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.ais.util.CollectionUtil;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.extplugin.PluginFilter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRMapUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.pbs.business.ServiceFactory;
import kd.opmc.pbs.business.domain.common.service.CustomTerminologyDomainService;
import kd.opmc.pbs.business.domain.msg.service.MergeMsgSendService;
import kd.opmc.pbs.business.domain.msg.service.RollbackMsgSendService;
import kd.opmc.pbs.business.domain.workflow.dto.AssignHandlerParamDTO;
import kd.opmc.pbs.business.domain.workflow.dto.SendMessageDTO;
import kd.opmc.pbs.business.domain.workflow.entity.FlowMsgMergeEnumBO;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowRuTaskIndEntryService;
import kd.opmc.pbs.business.domain.workflow.enums.FlowDefRoleOutEnum;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuMsgMergeEnum;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuNodeStatusEnum;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuProcStatusEnum;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuRoleStatusEnum;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuTaskStatusEnum;
import kd.opmc.pbs.business.domain.workflow.outService.IWorkFlowOutService;
import kd.opmc.pbs.business.domain.workflow.service.FlowHandlerDomainService;
import kd.opmc.pbs.business.domain.workflow.utils.WorkflowUtils;
import kd.opmc.pbs.business.domain.workflow.vo.AssignHandlerVO;
import kd.opmc.pbs.business.domain.workflow.vo.CrossTaskHandleVo;
import kd.opmc.pbs.business.external.epa.IEPAActEvalRecordService;
import kd.opmc.pbs.business.external.epa.IEPAActevalobjService;
import kd.opmc.pbs.common.constants.NodeTypeConstants;

public class FlowHandlerBatchDomainService
extends FlowHandlerDomainService {
    private static final Log LOG = LogFactory.getLog(FlowHandlerBatchDomainService.class);
    private static final String ADD_HANDLER = "addHandler";
    private static final String DEL_HANDLER = "delHandler";
    private static final String DEL_HANDLER_CROSS = "delHandlerCross";
    private static final RollbackMsgSendService ROLLBACK_MSG_SEND_SERVICE = RollbackMsgSendService.getInstance();
    private static final MergeMsgSendService MERGE_MSG_SEND_SERVICE = MergeMsgSendService.getInstance();
    private static final IEPAActevalobjService EPA_ACTEVAOBJ_SERVICE = IEPAActevalobjService.getInstance();
    private static final IEPAActEvalRecordService EPA_ACT_EVAL_RECORD_SERVICE = IEPAActEvalRecordService.getInstance();
    private static final IWorkFlowOutService I_WORK_FLOW_OUT_SERVICE = IWorkFlowOutService.getInstance();
    private static final FlowRuTaskIndEntryService FLOW_RU_TASK_IND_ENTRY_SERVICE = FlowRuTaskIndEntryService.getInstance();
    private static final CustomTerminologyDomainService CUSTOM_TERMINOLOGY_DOMAIN_SERVICE = CustomTerminologyDomainService.getInstance();
    private static final HashSet<FlowRuMsgMergeEnum> evalMsgs = new HashSet<FlowRuMsgMergeEnum>(Arrays.asList(FlowRuMsgMergeEnum.START_EVALUATE_MUL, FlowRuMsgMergeEnum.START_EVALUATE_SIN, FlowRuMsgMergeEnum.URG_EVALUATE_MUL, FlowRuMsgMergeEnum.URG_EVALUATE_SIN, FlowRuMsgMergeEnum.RETURN_EVALUATE_MUL, FlowRuMsgMergeEnum.RETURN_EVALUATE_SIN, FlowRuMsgMergeEnum.COPY_EVALUATE_MUL, FlowRuMsgMergeEnum.COPY_EVALUATE_SIN, FlowRuMsgMergeEnum.PBS_EVALUATION_COOP_MUL, FlowRuMsgMergeEnum.PBS_EVALUATION_COOP));
    private static final HashSet<FlowRuMsgMergeEnum> formulateMsgs = new HashSet<FlowRuMsgMergeEnum>(Arrays.asList(FlowRuMsgMergeEnum.START_FORMULATE_MUL, FlowRuMsgMergeEnum.START_FORMULATE_SIN, FlowRuMsgMergeEnum.URG_FORMULATE_MUL, FlowRuMsgMergeEnum.URG_FORMULATE_SIN, FlowRuMsgMergeEnum.RETURN_FORMULATE_MUL, FlowRuMsgMergeEnum.RETURN_FORMULATE_SIN, FlowRuMsgMergeEnum.COPY_FORMULATE_MUL, FlowRuMsgMergeEnum.COPY_FORMULATE_SIN));
    private static final HashSet<FlowRuMsgMergeEnum> rollBackCopyMsgs = new HashSet<FlowRuMsgMergeEnum>(Arrays.asList(FlowRuMsgMergeEnum.RETURN_FORMULATE_MUL, FlowRuMsgMergeEnum.RETURN_FORMULATE_SIN, FlowRuMsgMergeEnum.RETURN_EVALUATE_MUL, FlowRuMsgMergeEnum.RETURN_EVALUATE_SIN, FlowRuMsgMergeEnum.RETURN_INTERVIEW_MUL, FlowRuMsgMergeEnum.RETURN_INTERVIEW_SIN));
    private static final HashSet<Long> indicatorWorkflowFlowOutNodeType = new HashSet<Long>(Arrays.asList(NodeTypeConstants.INDICATOR_FORMULATE, NodeTypeConstants.INDICATOR_CONFIRM));
    private static final Map<String, FlowMsgMergeEnumBO> flowMsgEnumBoMap = new HashMap<String, FlowMsgMergeEnumBO>();

    public static FlowHandlerBatchDomainService getInstance() {
        return ServiceFactory.getService(FlowHandlerBatchDomainService.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AssignHandlerVO> addHandlerCrossAfterStartProcess(List<AssignHandlerParamDTO> dtos) {
        ArrayList<AssignHandlerVO> errorInfos = new ArrayList<AssignHandlerVO>();
        Set roleIds = dtos.stream().map(e -> e.getRoleId()).collect(Collectors.toSet());
        Set<Long> actevaObjs = dtos.stream().map(e -> e.getActevaObj()).collect(Collectors.toSet());
        Set<String> workflowType = dtos.stream().map(e -> e.getWorkFlowType()).collect(Collectors.toSet());
        Map<Long, Map<Long, Long>> evaObjIndMap = EPA_ACTEVAOBJ_SERVICE.queryIndicatorByObjIds(actevaObjs.stream().collect(Collectors.toList()));
        Map<Long, List<AssignHandlerParamDTO>> roleDtoMap = dtos.stream().collect(Collectors.groupingBy(k -> k.getRoleId(), Collectors.toList()));
        DynamicObject[] roles = this.queryRolesByIds(roleIds.stream().collect(Collectors.toList()));
        Map<Long, DynamicObject> roleIdMap = Arrays.stream(roles).collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
        String properties = "id, taskstatus, updatestatustime, modifier, modifytime, flowrurole_id, handler,entryentity, entryentity.indicatorid, entryentity.arearegid, activity, flowruproc.workflowtype,hosttask.id";
        DynamicObject[] tasks = FLOW_RU_TASK_ENTITY_SERVICE.query(properties, new QFilter("flowrurole_id", "in", roleIds).toArray());
        List<Long> taskIds = Arrays.stream(tasks).map(e -> e.getLong("id")).collect(Collectors.toList());
        DynamicObject[] indTasks = FLOW_RU_TASK_IND_ENTRY_SERVICE.queryRuTaskIndEntrysByTaskIds(taskIds);
        Map<Long, List<DynamicObject>> indIdTasksMap = Arrays.stream(indTasks).collect(Collectors.groupingBy(k -> k.getLong("indicator"), Collectors.toList()));
        Map<Long, List<DynamicObject>> roleIdAllTaskMap = Arrays.stream(tasks).collect(Collectors.groupingBy(k -> k.getLong("flowrurole_id"), Collectors.toList()));
        Long activityId = Arrays.stream(tasks).map(task -> task.getLong("activity")).findFirst().orElse(0L);
        String workflowtype = Arrays.stream(tasks).map(task -> task.getString("flowruproc.workflowtype")).findFirst().orElse("");
        Map<Long, DynamicObject> roleActevalObjOp = this.getActevalObjByPks(actevaObjs);
        Map<Long, String> roleDefOp = this.getRoleDefOp(Arrays.asList(roles));
        List<CrossTaskHandleVo> handleCrossTasks = this.getAddHandlerCrossTasks(roleDtoMap, roleIdAllTaskMap, indIdTasksMap, roleIdMap, roleActevalObjOp, roleDefOp, errorInfos);
        handleCrossTasks.stream().forEach(crossTask -> {
            if (crossTask.getTask().getLong("id") == 0L || !HRStringUtils.equals((String)FlowRuTaskStatusEnum.PENDING.getCode(), (String)crossTask.getTask().getString("taskstatus"))) {
                DynamicObjectCollection taskIndCollection = crossTask.getTask().getDynamicObjectCollection("entryentity");
                crossTask.getNeedAddIndSet().stream().forEach(indicator -> {
                    Long areaRegId = (Long)((Map)evaObjIndMap.get(crossTask.getEvalObj())).get(indicator);
                    DynamicObject taskIndDy = taskIndCollection.addNew();
                    taskIndDy.set("indicatorid", indicator);
                    taskIndDy.set("arearegid", (Object)areaRegId);
                });
            }
        });
        List<Long> handlerIds = dtos.stream().flatMap(dto -> dto.getHandlerIds().stream()).collect(Collectors.toList());
        Map<Long, List<Long>> coOperatorMap = EPA_ACTEVAOBJ_SERVICE.getCooperator(activityId, handlerIds, workflowtype);
        List<DynamicObject> handlerTask = handleCrossTasks.stream().map(e -> e.getTask()).collect(Collectors.toList());
        this.dealCoOperatorTasks(handlerTask, coOperatorMap);
        Set handRoleIds = handlerTask.stream().map(e -> e.getLong("flowrurole_id")).collect(Collectors.toSet());
        DynamicObject[] handRoles = (DynamicObject[])Arrays.stream(roles).filter(e -> handRoleIds.contains(e.getLong("id"))).toArray(DynamicObject[]::new);
        ArrayList<DynamicObject> handleNodes = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> handleProcs = new ArrayList<DynamicObject>();
        this.assembleStatus((DynamicObject[])handlerTask.stream().toArray(DynamicObject[]::new), roleIdAllTaskMap, handRoles, handleNodes, handleProcs, null, roleActevalObjOp, roleDefOp, ADD_HANDLER, null, workflowType, errorInfos);
        FLOW_RU_ROLE_ENTITY_SERVICE.setRoleIsSetHander(handRoles);
        FLOW_RU_TASK_ENTITY_SERVICE.setTaskModifyStatus((DynamicObject[])handlerTask.stream().toArray(DynamicObject[]::new));
        try (TXHandle required = TX.required();){
            DynamicObject[] updateTask = (DynamicObject[])handlerTask.stream().filter(e -> 0L != e.getLong("id")).toArray(DynamicObject[]::new);
            FLOW_RU_TASK_ENTITY_SERVICE.save(updateTask);
            DynamicObject[] addTask = (DynamicObject[])handlerTask.stream().filter(e -> 0L == e.getLong("id")).toArray(DynamicObject[]::new);
            FLOW_RU_TASK_ENTITY_SERVICE.save(addTask);
            FLOW_RU_ROLE_ENTITY_SERVICE.update(handRoles);
            FLOW_RU_NODE_ENTITY_SERVICE.update((DynamicObject[])handleNodes.stream().toArray(DynamicObject[]::new));
            FLOW_RU_PROC_ENTITY_SERVICE.update((DynamicObject[])handleProcs.stream().toArray(DynamicObject[]::new));
        }
        this.sendMessageAfterHandler(handlerTask, handleProcs);
        this.runProcessAfterHandler(handleProcs, handleNodes, Arrays.stream(handRoles).collect(Collectors.toList()));
        return errorInfos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AssignHandlerVO> deleteHandlerCrossAfterStartProcess(List<AssignHandlerParamDTO> dtos) {
        ArrayList<AssignHandlerVO> errorInfos = new ArrayList<AssignHandlerVO>();
        Map<Long, List<AssignHandlerParamDTO>> handlerParamDTOMap = dtos.stream().collect(Collectors.groupingBy(k -> k.getTaskId(), Collectors.toList()));
        Set taskIds = dtos.stream().map(e -> e.getTaskId()).collect(Collectors.toSet());
        List<Long> indicators = dtos.stream().map(e -> e.getIndicatorId()).collect(Collectors.toSet()).stream().collect(Collectors.toList());
        Set<String> workflowType = dtos.stream().map(e -> e.getWorkFlowType()).collect(Collectors.toSet());
        Map<Long, DynamicObject> indicatorMap = IEPAActevalobjService.getInstance().queryObjIndicatorAreaEntry(indicators, indicators);
        DynamicObject[] handleTasks = FLOW_RU_TASK_ENTITY_SERVICE.queryTasksByIds(taskIds.stream().collect(Collectors.toList()));
        Set handRoleIds = Arrays.stream(handleTasks).map(e -> e.getLong("flowrurole_id")).collect(Collectors.toSet());
        DynamicObject[] roles = FLOW_RU_ROLE_ENTITY_SERVICE.queryByRuRoleIds(handRoleIds.stream().collect(Collectors.toList()));
        ArrayList<DynamicObject> handleNodes = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> handleProcs = new ArrayList<DynamicObject>();
        Map<Long, DynamicObject> roleActevalObjOp = this.getActevalObjByPks(dtos.stream().map(e -> e.getActevaObj()).collect(Collectors.toSet()));
        Map<Long, String> roleDefOp = this.getRoleDefOp(Arrays.asList(roles));
        Map<Long, Map<String, String>> taskHandlerNames = this.getTaskHandlerNames(Arrays.stream(handleTasks).map(e -> e.getLong("handler_id")).collect(Collectors.toSet()));
        DynamicObject[] roleTasks = FLOW_RU_TASK_ENTITY_SERVICE.queryOriginalSpecifyTaskByRoleIds(handRoleIds.stream().collect(Collectors.toList()));
        DynamicObject[] indTasks = FLOW_RU_TASK_IND_ENTRY_SERVICE.queryRuTaskIndEntrysByTaskIds(Arrays.stream(roleTasks).filter(e -> !HRStringUtils.equals((String)e.getString("taskstatus"), (String)FlowRuTaskStatusEnum.PENDING.getCode())).collect(Collectors.toList()).stream().map(k -> k.getLong("id")).collect(Collectors.toList()));
        DynamicObject[] indAllTasks = FLOW_RU_TASK_IND_ENTRY_SERVICE.queryRuTaskIndEntrysByTaskIds(Arrays.stream(roleTasks).map(k -> k.getLong("id")).collect(Collectors.toList()));
        Map roleIdIndTasksMap = Arrays.stream(indAllTasks).collect(Collectors.groupingBy(e -> e.getLong("rutask.flowrurole.id"), Collectors.toList()));
        HashMap<Long, Map<Long, List<DynamicObject>>> roleIdIndicatorIndTaskMap = new HashMap<Long, Map<Long, List<DynamicObject>>>(roleIdIndTasksMap.size());
        roleIdIndTasksMap.forEach((K, V) -> roleIdIndicatorIndTaskMap.put((Long)K, V.stream().collect(Collectors.groupingBy(k -> k.getLong("indicator"), Collectors.toList()))));
        Map<Long, List<DynamicObject>> taskIdIndicatorMap = Arrays.stream(indAllTasks).collect(Collectors.groupingBy(k -> k.getLong("rutask_id"), Collectors.toList()));
        Map<Long, List<DynamicObject>> roleIdAllTaskMap = Arrays.stream(roleTasks).collect(Collectors.groupingBy(k -> k.getLong("flowrurole.id"), Collectors.toList()));
        this.assembleStatus(handleTasks, indicatorMap, roleIdAllTaskMap, roles, handleNodes, handleProcs, handlerParamDTOMap, taskIdIndicatorMap, roleIdIndicatorIndTaskMap, roleActevalObjOp, roleDefOp, DEL_HANDLER_CROSS, taskHandlerNames, workflowType, errorInfos);
        Set handleTaskIds = errorInfos.stream().filter(e -> e.isSucess()).collect(Collectors.toList()).stream().map(e -> e.getTaskId()).collect(Collectors.toSet());
        HashMap<Long, List<Long>> handleTaskIndEntryMap = new HashMap<Long, List<Long>>(16);
        handlerParamDTOMap.forEach((K, V) -> {
            if (handleTaskIds.contains(K)) {
                handleTaskIndEntryMap.put((Long)K, V.stream().map(e -> e.getIndicatorId()).collect(Collectors.toList()));
            }
        });
        FLOW_RU_TASK_ENTITY_SERVICE.setTaskModifyStatus(handleTasks);
        List<Long> hostTaskIds = Arrays.stream(handleTasks).filter(task -> HRStringUtils.equals((String)task.getString("taskstatus"), (String)FlowRuTaskStatusEnum.EXPIRED.getCode())).map(task -> task.getLong("id")).collect(Collectors.toList());
        DynamicObject[] coTasks = FLOW_RU_TASK_ENTITY_SERVICE.queryCoTasksByIds(hostTaskIds);
        WorkflowUtils.updateTaskStatus(coTasks, FlowRuTaskStatusEnum.EXPIRED.getCode());
        Arrays.stream(coTasks).forEach(task -> {
            long hostTaskId = task.getLong("hosttask.id");
            List hostTaskIndicatorIds = (List)handleTaskIndEntryMap.get(hostTaskId);
            handleTaskIndEntryMap.put(task.getLong("id"), hostTaskIndicatorIds);
        });
        try (TXHandle required = TX.required();){
            FLOW_RU_TASK_ENTITY_SERVICE.save(handleTasks);
            FLOW_RU_TASK_ENTITY_SERVICE.save(coTasks);
            handleTaskIndEntryMap.forEach((k, v) -> FLOW_RU_TASK_IND_ENTRY_SERVICE.deleteRuTaskIndEntryByTaskAndIndicator((Long)k, (List<Long>)v));
            EPA_ACT_EVAL_RECORD_SERVICE.updateEvalRecordForAdjustEvalPer(handleTaskIndEntryMap);
            FLOW_RU_ROLE_ENTITY_SERVICE.update(roles);
            FLOW_RU_NODE_ENTITY_SERVICE.update((DynamicObject[])handleNodes.stream().toArray(DynamicObject[]::new));
            FLOW_RU_PROC_ENTITY_SERVICE.update((DynamicObject[])handleProcs.stream().toArray(DynamicObject[]::new));
        }
        this.runProcessAfterHandler(handleProcs, handleNodes, Arrays.stream(roles).collect(Collectors.toList()));
        return errorInfos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AssignHandlerVO> modifyHandlerCrossAfterStartProcess(List<AssignHandlerParamDTO> dtos) {
        ArrayList<AssignHandlerVO> errorInfos = new ArrayList<AssignHandlerVO>();
        Set taskIds = dtos.stream().map(e -> e.getTaskId()).collect(Collectors.toSet());
        DynamicObject[] handleTasks = FLOW_RU_TASK_ENTITY_SERVICE.queryOriginalTasksByIds(taskIds.stream().collect(Collectors.toList()));
        Map<Long, DynamicObject> taskIdMap = Arrays.stream(handleTasks).collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
        Set handRoleIds = Arrays.stream(handleTasks).map(e -> e.getLong("flowrurole.id")).collect(Collectors.toSet());
        Set<Long> actevaObjs = dtos.stream().map(e -> e.getActevaObj()).collect(Collectors.toSet());
        Set<String> workflowType = dtos.stream().map(e -> e.getWorkFlowType()).collect(Collectors.toSet());
        List indicators = dtos.stream().map(e -> e.getIndicatorId()).collect(Collectors.toSet()).stream().collect(Collectors.toList());
        Map<Long, Map<Long, Long>> evaObjIndMap = EPA_ACTEVAOBJ_SERVICE.queryIndicatorByObjIds(actevaObjs.stream().collect(Collectors.toList()));
        Map<Long, List<AssignHandlerParamDTO>> taskDtoMap = dtos.stream().collect(Collectors.groupingBy(k -> k.getTaskId(), Collectors.toList()));
        DynamicObject[] roles = this.queryRolesByIds(handRoleIds.stream().collect(Collectors.toList()));
        Map<Long, DynamicObject> roleIdMap = Arrays.stream(roles).collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
        String properties = "id, taskstatus, updatestatustime, modifier, modifytime, flowrurole_id, handler,entryentity, entryentity.indicatorid, entryentity.arearegid, activity, flowruproc.workflowtype,hosttask.id";
        DynamicObject[] tasks = FLOW_RU_TASK_ENTITY_SERVICE.query(properties, new QFilter("flowrurole_id", "in", handRoleIds).toArray());
        DynamicObject[] indTasks = FLOW_RU_TASK_IND_ENTRY_SERVICE.queryRuTaskIndEntrysByTaskIds(Arrays.stream(tasks).map(e -> e.getLong("id")).collect(Collectors.toList()));
        Map<Long, List<DynamicObject>> indIdTasksMap = Arrays.stream(indTasks).collect(Collectors.groupingBy(k -> k.getLong("indicator"), Collectors.toList()));
        Map<Long, List<DynamicObject>> roleIdAllTaskMap = Arrays.stream(tasks).collect(Collectors.groupingBy(k -> k.getLong("flowrurole_id"), Collectors.toList()));
        Long activityId = Arrays.stream(tasks).map(task -> task.getLong("activity")).findFirst().orElse(0L);
        String workflowtype = Arrays.stream(tasks).map(task -> task.getString("flowruproc.workflowtype")).findFirst().orElse("");
        Map<Long, DynamicObject> roleActevalObjOp = this.getActevalObjByPks(actevaObjs);
        Map<Long, String> roleDefOp = this.getRoleDefOp(Arrays.asList(roles));
        List<CrossTaskHandleVo> handleCrossTasks = this.getModifyHandlerCrossTasks(dtos, taskDtoMap, roleIdAllTaskMap, taskIdMap, indIdTasksMap, roleIdMap, roleActevalObjOp, roleDefOp, errorInfos);
        handleCrossTasks.stream().forEach(crossTask -> {
            if (crossTask.getTask().getLong("id") == 0L || !HRStringUtils.equals((String)FlowRuTaskStatusEnum.PENDING.getCode(), (String)crossTask.getTask().getString("taskstatus"))) {
                DynamicObjectCollection taskIndCollection = crossTask.getTask().getDynamicObjectCollection("entryentity");
                crossTask.getNeedAddIndSet().stream().forEach(indicator -> {
                    Long areaRegId = (Long)((Map)evaObjIndMap.get(crossTask.getEvalObj())).get(indicator);
                    DynamicObject taskIndDy = taskIndCollection.addNew();
                    taskIndDy.set("indicatorid", indicator);
                    taskIndDy.set("arearegid", (Object)areaRegId);
                });
            }
        });
        List<Long> handlerIds = dtos.stream().flatMap(dto -> dto.getHandlerIds().stream()).collect(Collectors.toList());
        Map<Long, List<Long>> coOperatorMap = EPA_ACTEVAOBJ_SERVICE.getCooperator(activityId, handlerIds, workflowtype);
        List<DynamicObject> handlerTask = handleCrossTasks.stream().map(e -> e.getTask()).collect(Collectors.toList());
        this.dealCoOperatorTasks(handlerTask, coOperatorMap);
        Set handleRoleIds = handlerTask.stream().map(e -> e.getLong("flowrurole_id")).collect(Collectors.toSet());
        DynamicObject[] handRoles = (DynamicObject[])Arrays.stream(roles).filter(e -> handleRoleIds.contains(e.getLong("id"))).toArray(DynamicObject[]::new);
        ArrayList<DynamicObject> handleNodes = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> handleProcs = new ArrayList<DynamicObject>();
        this.assembleStatus((DynamicObject[])handlerTask.stream().toArray(DynamicObject[]::new), roleIdAllTaskMap, handRoles, handleNodes, handleProcs, null, roleActevalObjOp, roleDefOp, ADD_HANDLER, null, workflowType, errorInfos);
        FLOW_RU_ROLE_ENTITY_SERVICE.setRoleIsSetHander(handRoles);
        FLOW_RU_TASK_ENTITY_SERVICE.setTaskModifyStatus((DynamicObject[])handlerTask.stream().toArray(DynamicObject[]::new));
        try (TXHandle required = TX.required();){
            DynamicObject[] updateTask = (DynamicObject[])handlerTask.stream().filter(e -> 0L != e.getLong("id")).toArray(DynamicObject[]::new);
            FLOW_RU_TASK_ENTITY_SERVICE.save(updateTask);
            DynamicObject[] addTask = (DynamicObject[])handlerTask.stream().filter(e -> 0L == e.getLong("id")).toArray(DynamicObject[]::new);
            FLOW_RU_TASK_ENTITY_SERVICE.save(addTask);
            FLOW_RU_ROLE_ENTITY_SERVICE.update(handRoles);
            FLOW_RU_NODE_ENTITY_SERVICE.update((DynamicObject[])handleNodes.stream().toArray(DynamicObject[]::new));
            FLOW_RU_PROC_ENTITY_SERVICE.update((DynamicObject[])handleProcs.stream().toArray(DynamicObject[]::new));
        }
        this.deleteHandlerCrossAfterStartProcess(dtos);
        Set hasErrorInfoSet = errorInfos.stream().map(e -> e.getId()).collect(Collectors.toSet());
        dtos.stream().forEach(dto -> {
            if (!hasErrorInfoSet.contains(dto.getId())) {
                AssignHandlerVO retVo = new AssignHandlerVO();
                retVo.setId(dto.getId());
                retVo.setIndicatorId(dto.getIndicatorId());
                retVo.setErrorMessage("");
                retVo.setTaskId(dto.getTaskId());
                retVo.setSucess(Boolean.TRUE);
                retVo.setRoleId(dto.getRoleId());
                errorInfos.add(retVo);
            }
        });
        this.sendMessageAfterHandler(handlerTask, handleProcs);
        this.runProcessAfterHandler(handleProcs, handleNodes, Arrays.stream(handRoles).collect(Collectors.toList()));
        return errorInfos;
    }

    private Set<Long> getNeedExpriedTaskSet(List<DynamicObject> tasks, Map<Long, List<AssignHandlerParamDTO>> handlerParamDTOMap, Map<Long, List<DynamicObject>> taskIdIndicatorMap) {
        HashSet<Long> expriedTaskIdSet = new HashSet<Long>();
        for (DynamicObject task : tasks) {
            List<DynamicObject> taskIndEntry = taskIdIndicatorMap.get(task.getLong("id"));
            if (taskIndEntry == null) continue;
            Set taskHasIndicator = taskIndEntry.stream().map(e -> e.getLong("indicator")).collect(Collectors.toSet());
            List<AssignHandlerParamDTO> dtos = handlerParamDTOMap.get(task.getLong("id"));
            Set taskDtoIndicator = dtos.stream().map(e -> e.getIndicatorId()).collect(Collectors.toSet());
            taskHasIndicator.removeAll(taskDtoIndicator);
            if (taskHasIndicator.size() != 0) continue;
            expriedTaskIdSet.add(task.getLong("id"));
        }
        return expriedTaskIdSet;
    }

    private void assembleStatus(DynamicObject[] handlerTasks, Map<Long, DynamicObject> indicatorMap, Map<Long, List<DynamicObject>> roleIdAllTaskMap, DynamicObject[] roles, List<DynamicObject> handleNodes, List<DynamicObject> handleProcs, Map<Long, List<AssignHandlerParamDTO>> handlerParamDTOMap, Map<Long, List<DynamicObject>> taskIdIndicatorMap, Map<Long, Map<Long, List<DynamicObject>>> roleIdIndicatorIndTaskMap, Map<Long, DynamicObject> roleActevalObjOp, Map<Long, String> roleDefOp, String operation, Map<Long, Map<String, String>> taskHandlerNames, Set<String> workflowType, List<AssignHandlerVO> errorInfos) {
        Map roleIdHandleTaskMap = Arrays.stream(handlerTasks).collect(Collectors.groupingBy(k -> k.getLong("flowrurole_id"), Collectors.toList()));
        Map nodeIdRoleMap = Arrays.stream(roles).collect(Collectors.groupingBy(r -> r.getLong("flowrunode_id"), Collectors.toList()));
        List<Long> nodeIds = Arrays.stream(roles).map(role -> role.getLong("flowrunode_id")).collect(Collectors.toList());
        Map<Long, Boolean> manualopMap = this.getManualOpMapByRoles(Arrays.stream(roles).collect(Collectors.toList()));
        DynamicObject[] nodes = FLOW_RU_NODE_ENTITY_SERVICE.queryByRuNodeIds(nodeIds);
        Map handleProcNodesMap = Arrays.stream(nodes).collect(Collectors.groupingBy(r -> r.getLong("flowruproc_id"), Collectors.toList()));
        DynamicObject[] nodeRoles = FLOW_RU_ROLE_ENTITY_SERVICE.queryRolesByNodeIds((Long[])nodeIds.stream().toArray(Long[]::new));
        Map nodeRoleMap = Arrays.stream(nodeRoles).collect(Collectors.groupingBy(k -> k.getLong("flowrunode_id"), Collectors.toList()));
        List<Long> procIds = Arrays.stream(nodes).map(node -> node.getLong("flowruproc_id")).collect(Collectors.toList());
        DynamicObject[] procs = FLOW_RU_PROC_ENTITY_SERVICE.queryProcByPkIds(procIds);
        DynamicObject[] procNodes = FLOW_RU_NODE_ENTITY_SERVICE.queryAllNodeByProcIds((Long[])procIds.stream().toArray(Long[]::new));
        Map procNodesMap = Arrays.stream(procNodes).collect(Collectors.groupingBy(k -> k.getLong("flowruproc_id"), Collectors.toList()));
        Arrays.stream(procs).forEach(proc -> {
            String workFlowType = proc.getString("workflowtype");
            List currProcHandleNodes = (List)handleProcNodesMap.get(proc.getLong("id"));
            currProcHandleNodes.stream().forEach(node -> {
                List currNodeHandleRoles = (List)nodeIdRoleMap.get(node.getLong("id"));
                for (DynamicObject currRole : currNodeHandleRoles) {
                    List tasks = (List)roleIdHandleTaskMap.get(currRole.getLong("id"));
                    Set<Long> needExpriedTaskIdSet = this.getNeedExpriedTaskSet(tasks, handlerParamDTOMap, taskIdIndicatorMap);
                    for (DynamicObject task : tasks) {
                        if (!HRStringUtils.equals((String)DEL_HANDLER_CROSS, (String)operation)) continue;
                        List taskIndDtos = (List)handlerParamDTOMap.get(task.getLong("id"));
                        for (AssignHandlerParamDTO dto : taskIndDtos) {
                            if (dto.getHandType() == 2) {
                                AssignHandlerVO retVo;
                                Object[] args;
                                Map indDtoMap = (Map)roleIdIndicatorIndTaskMap.get(currRole.getLong("id"));
                                Set currRoleIndTaskSet = CollectionUtil.newSet((int)16);
                                int needExpriedCount = 0;
                                if (indDtoMap != null) {
                                    currRoleIndTaskSet = ((List)indDtoMap.get(dto.getIndicatorId())).stream().map(e -> e.getLong("rutask_id")).collect(Collectors.toSet());
                                    for (Long indTask : currRoleIndTaskSet) {
                                        if (!needExpriedTaskIdSet.contains(indTask)) continue;
                                        ++needExpriedCount;
                                    }
                                }
                                if (task.getBoolean("iscotask")) {
                                    args = this.getArgs(roleActevalObjOp, dto);
                                    this.checkCoTask(args, errorInfos, task, dto, null);
                                    continue;
                                }
                                if (!this.getCanRoleStatus().contains(currRole.getString("rolestatus"))) {
                                    DynamicObject actEvaObj = (DynamicObject)roleActevalObjOp.get(dto.getActevaObj());
                                    Object[] args2 = new Object[]{actEvaObj != null ? actEvaObj.getString("person.name") : "", actEvaObj != null ? actEvaObj.getString("person.number") : "", roleDefOp.get(currRole.getLong("id")), FlowRuRoleStatusEnum.getFlowRuRoleStatusByCode(currRole.getString("rolestatus")).getText()};
                                    String errMessage = CUSTOM_TERMINOLOGY_DOMAIN_SERVICE.getCusTerminology(ResManager.loadKDString((String)"\u5236\u5b9a\u5bf9\u8c61{0}\uff08\u5de5\u53f7\uff1a{1}\uff09\uff1a\u5f53\u524d\u8282\u70b9\u4e0b\u89d2\u8272\u201c{2}\u201d\u7684\u72b6\u6001\u4e3a\u201c{3}\u201d\uff0c\u4e0d\u652f\u6301\u5220\u9664\u5236\u5b9a\u4eba\u3002", (String)"FlowHandlerBatchDomainService_23", (String)"opmc-pbs-business", (Object[])args2));
                                    if (HRStringUtils.equals((String)dto.getWorkFlowType(), (String)"2")) {
                                        errMessage = ResManager.loadKDString((String)"\u8bc4\u4f30\u5bf9\u8c61{0}\uff08\u5de5\u53f7\uff1a{1}\uff09\uff1a\u5f53\u524d\u8282\u70b9\u4e0b\u7684\u89d2\u8272\u201c{2}\u201d\u72b6\u6001\u4e3a{3}\uff0c\u4e0d\u652f\u6301\u5220\u9664\u8bc4\u4f30\u4eba\u3002", (String)"FlowHandlerBatchDomainService_24", (String)"opmc-pbs-business", (Object[])args2);
                                    }
                                    retVo = new AssignHandlerVO();
                                    retVo.setId(dto.getId());
                                    retVo.setTaskId(task.getLong("id"));
                                    retVo.setRoleId(currRole.getLong("id"));
                                    retVo.setIndicatorId(dto.getIndicatorId());
                                    retVo.setSucess(Boolean.FALSE);
                                    retVo.setErrorMessage(errMessage);
                                    errorInfos.add(retVo);
                                    continue;
                                }
                                if (this.getNotDeleteTaskStatus().contains(task.getString("taskstatus"))) {
                                    args = new Object[]{taskHandlerNames.get(task.getLong("handler_id")) != null ? ((Map)taskHandlerNames.get(task.getLong("handler_id"))).get("name") : "", taskHandlerNames.get(task.getLong("handler_id")) != null ? ((Map)taskHandlerNames.get(task.getLong("handler_id"))).get("number") : "", FlowRuTaskStatusEnum.getFlowRuTaskStatusByCode(task.getString("taskstatus")).getText()};
                                    String errMessage = CUSTOM_TERMINOLOGY_DOMAIN_SERVICE.getCusTerminology(ResManager.loadKDString((String)"\u5236\u5b9a\u4eba{0}\uff08\u5de5\u53f7\uff1a{1}\uff09\uff1a:\u5f53\u524d\u5236\u5b9a\u4efb\u52a1\u72b6\u6001\u4e3a\u201c{2}\u201d\uff0c\u4e0d\u652f\u6301\u5220\u9664\u3002", (String)"FlowHandlerBatchDomainService_25", (String)"opmc-pbs-business", (Object[])args));
                                    if (HRStringUtils.equals((String)dto.getWorkFlowType(), (String)"2")) {
                                        errMessage = ResManager.loadKDString((String)"\u8bc4\u4f30\u4eba{0}\uff08\u5de5\u53f7\uff1a{1}\uff09\uff1a\u5f53\u524d\u8bc4\u4f30\u4efb\u52a1\u72b6\u6001\u4e3a\u201c{2}\u201d\uff0c\u4e0d\u652f\u6301\u5220\u9664\u8bc4\u4f30\u4eba\u3002", (String)"FlowHandlerBatchDomainService_26", (String)"opmc-pbs-business", (Object[])args);
                                    }
                                    AssignHandlerVO retVo2 = new AssignHandlerVO();
                                    retVo2.setId(dto.getId());
                                    retVo2.setIndicatorId(dto.getIndicatorId());
                                    retVo2.setRoleId(currRole.getLong("id"));
                                    retVo2.setHandlerId(task.getLong("handler_id"));
                                    retVo2.setTaskId(task.getLong("id"));
                                    retVo2.setSucess(Boolean.FALSE);
                                    retVo2.setErrorMessage(errMessage);
                                    errorInfos.add(retVo2);
                                    continue;
                                }
                                if (needExpriedCount == currRoleIndTaskSet.size() || needExpriedTaskIdSet.size() == 0 && currRoleIndTaskSet.size() == 1) {
                                    String errMessage = "";
                                    DynamicObject actEvaObj = (DynamicObject)roleActevalObjOp.get(dto.getActevaObj());
                                    Object[] args3 = new Object[]{taskHandlerNames.get(task.getLong("handler_id")) != null ? ((Map)taskHandlerNames.get(task.getLong("handler_id"))).get("name") : "", taskHandlerNames.get(task.getLong("handler_id")) != null ? ((Map)taskHandlerNames.get(task.getLong("handler_id"))).get("number") : "", actEvaObj != null ? actEvaObj.getString("person.name") : "", indicatorMap.get(dto.getIndicatorId()) != null ? ((DynamicObject)indicatorMap.get(dto.getIndicatorId())).getString("indctrname") : "", roleDefOp.get(currRole.getLong("id"))};
                                    if (HRStringUtils.equals((String)workFlowType, (String)"1")) {
                                        errMessage = CUSTOM_TERMINOLOGY_DOMAIN_SERVICE.getCusTerminology(ResManager.loadKDString((String)"\u5236\u5b9a\u4eba-{0} {1}\uff1a\u4e3a{2}\u6307\u6807\u3010{3}\u3011\u5728\u89d2\u8272\u3010{4}\u3011\u5bf9\u5e94\u5236\u5b9a\u4efb\u52a1\u7684\u552f\u4e00\u6709\u6548\u5904\u7406\u4eba\uff0c\u4e0d\u53ef\u5220\u9664", (String)"FlowHandlerBatchDomainService_4", (String)"opmc-pbs-business", (Object[])args3));
                                    }
                                    if (HRStringUtils.equals((String)workFlowType, (String)"2")) {
                                        errMessage = ResManager.loadKDString((String)"\u8bc4\u4f30\u4eba{0}\uff08\u5de5\u53f7\uff1a{1}\uff09\u662f{2}\u201c{3}\u201d\u6307\u6807\u5728\u89d2\u8272\u201c{4}\u201d\u4e0b\u552f\u4e00\u6709\u6548\u7684\u5904\u7406\u4eba\uff0c\u4e0d\u652f\u6301\u5220\u9664\u8bc4\u4f30\u4eba\u3002", (String)"FlowHandlerBatchDomainService_27", (String)"opmc-pbs-business", (Object[])args3);
                                    }
                                    retVo = new AssignHandlerVO();
                                    retVo.setId(dto.getId());
                                    retVo.setIndicatorId(dto.getIndicatorId());
                                    retVo.setRoleId(currRole.getLong("id"));
                                    retVo.setHandlerId(task.getLong("handler_id"));
                                    retVo.setTaskId(task.getLong("id"));
                                    retVo.setSucess(Boolean.FALSE);
                                    retVo.setErrorMessage(errMessage);
                                    errorInfos.add(retVo);
                                    continue;
                                }
                                AssignHandlerVO retVo3 = new AssignHandlerVO();
                                retVo3.setId(dto.getId());
                                retVo3.setIndicatorId(dto.getIndicatorId());
                                retVo3.setTaskId(task.getLong("id"));
                                retVo3.setRoleId(((AssignHandlerParamDTO)((List)handlerParamDTOMap.get(task.getLong("id"))).get(0)).getRoleId());
                                retVo3.setSucess(Boolean.TRUE);
                                retVo3.setErrorMessage("");
                                errorInfos.add(retVo3);
                            } else {
                                AssignHandlerVO retVo = new AssignHandlerVO();
                                retVo.setId(dto.getId());
                                retVo.setIndicatorId(dto.getIndicatorId());
                                retVo.setTaskId(task.getLong("id"));
                                retVo.setRoleId(((AssignHandlerParamDTO)((List)handlerParamDTOMap.get(task.getLong("id"))).get(0)).getRoleId());
                                retVo.setSucess(Boolean.TRUE);
                                retVo.setErrorMessage("");
                                errorInfos.add(retVo);
                            }
                            if (node.getBoolean("iscrossnode")) {
                                Map setnoRoleMap = ((List)nodeRoleMap.get(node.getLong("id"))).stream().collect(Collectors.groupingBy(k -> k.getString("setno"), Collectors.toList()));
                                this.assembleRoleTaskStatus((DynamicObject)proc, currRole, setnoRoleMap.get(currRole.getString("setno")), (DynamicObject)node, task, tasks, roleIdAllTaskMap, needExpriedTaskIdSet, manualopMap, workflowType, operation);
                                continue;
                            }
                            this.assembleRoleTaskStatus((DynamicObject)proc, currRole, (List)nodeRoleMap.get(node.getLong("id")), (DynamicObject)node, task, tasks, roleIdAllTaskMap, needExpriedTaskIdSet, manualopMap, workflowType, operation);
                        }
                    }
                }
                this.assembleNodeStatus((DynamicObject)node, currNodeHandleRoles, (List)nodeRoleMap.get(node.getLong("id")));
            });
            this.assembleProcStatus((DynamicObject)proc, currProcHandleNodes, (List)procNodesMap.get(proc.getLong("id")));
        });
        handleNodes.addAll(Arrays.asList(nodes));
        handleProcs.addAll(Arrays.asList(procs));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AssignHandlerVO> addHandlerAfterStartProcess(List<AssignHandlerParamDTO> dtos) {
        ArrayList<AssignHandlerVO> errorInfos = new ArrayList<AssignHandlerVO>();
        List<Long> roleIds = dtos.stream().map(r -> r.getRoleId()).collect(Collectors.toList());
        Set<Long> actevaObjs = dtos.stream().map(e -> e.getActevaObj()).collect(Collectors.toSet());
        Map<Long, AssignHandlerParamDTO> handlerParamDTOMap = dtos.stream().collect(Collectors.toMap(k -> k.getRoleId(), v -> v));
        Set<String> workflowType = dtos.stream().map(e -> e.getWorkFlowType()).collect(Collectors.toSet());
        DynamicObject[] roles = this.queryRolesByIds(roleIds);
        String properties = "id, taskstatus, updatestatustime, modifier, modifytime, flowrurole_id, handler, activity, flowruproc.workflowtype,hosttask.id";
        DynamicObject[] tasks = FLOW_RU_TASK_ENTITY_SERVICE.query(properties, new QFilter("flowrurole_id", "in", roleIds).toArray());
        Map<Long, List<DynamicObject>> roleIdAllTaskMap = Arrays.stream(tasks).collect(Collectors.groupingBy(k -> k.getLong("flowrurole_id"), Collectors.toList()));
        Long activityId = Arrays.stream(tasks).map(task -> task.getLong("activity")).findFirst().orElse(0L);
        String workflowtype = Arrays.stream(tasks).map(task -> task.getString("flowruproc.workflowtype")).findFirst().orElse("");
        Map<Long, DynamicObject> roleActevalObjOp = this.getActevalObjByPks(actevaObjs);
        Map<Long, String> roleDefOp = this.getRoleDefOp(Arrays.asList(roles));
        List<Long> handlerIds = dtos.stream().flatMap(dto -> dto.getHandlerIds().stream()).collect(Collectors.toList());
        Map<Long, List<Long>> coOperatorMap = EPA_ACTEVAOBJ_SERVICE.getCooperator(activityId, handlerIds, workflowtype);
        List coOperatorList = coOperatorMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        handlerIds.addAll(coOperatorList);
        Map<Long, Map<String, String>> handlerNames = this.getHandlerNames(handlerIds);
        List<DynamicObject> handlerTask = this.getAddHandlerTasks(handlerParamDTOMap, roles, roleIdAllTaskMap, roleActevalObjOp, roleDefOp, handlerNames, errorInfos);
        this.dealCoOperatorTasks(handlerTask, coOperatorMap);
        Set handRoleIds = handlerTask.stream().map(e -> e.getLong("flowrurole_id")).collect(Collectors.toSet());
        DynamicObject[] handRoles = (DynamicObject[])Arrays.stream(roles).filter(e -> handRoleIds.contains(e.getLong("id"))).toArray(DynamicObject[]::new);
        ArrayList<DynamicObject> handleNodes = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> handleProcs = new ArrayList<DynamicObject>();
        this.assembleStatus((DynamicObject[])handlerTask.stream().toArray(DynamicObject[]::new), roleIdAllTaskMap, handRoles, handleNodes, handleProcs, handlerParamDTOMap, roleActevalObjOp, roleDefOp, ADD_HANDLER, handlerNames, workflowType, errorInfos);
        FLOW_RU_ROLE_ENTITY_SERVICE.setRoleIsSetHander(handRoles);
        FLOW_RU_TASK_ENTITY_SERVICE.setTaskModifyStatus((DynamicObject[])handlerTask.stream().toArray(DynamicObject[]::new));
        try (TXHandle required = TX.required();){
            DynamicObject[] updateTask = (DynamicObject[])handlerTask.stream().filter(e -> 0L != e.getLong("id")).toArray(DynamicObject[]::new);
            FLOW_RU_TASK_ENTITY_SERVICE.save(updateTask);
            DynamicObject[] addTask = (DynamicObject[])handlerTask.stream().filter(e -> 0L == e.getLong("id")).toArray(DynamicObject[]::new);
            FLOW_RU_TASK_ENTITY_SERVICE.save(addTask);
            FLOW_RU_ROLE_ENTITY_SERVICE.update(handRoles);
            FLOW_RU_NODE_ENTITY_SERVICE.update((DynamicObject[])handleNodes.stream().toArray(DynamicObject[]::new));
            FLOW_RU_PROC_ENTITY_SERVICE.update((DynamicObject[])handleProcs.stream().toArray(DynamicObject[]::new));
        }
        this.sendMessageAfterHandler(handlerTask, handleProcs);
        this.runProcessAfterHandler(handleProcs, handleNodes, Arrays.stream(handRoles).collect(Collectors.toList()));
        return errorInfos;
    }

    private void dealCoOperatorTasks(List<DynamicObject> handlerTask, Map<Long, List<Long>> coOperatorMap) {
        List newAddTasks = handlerTask.stream().filter(task -> 0L == task.getLong("id")).collect(Collectors.toList());
        handlerTask.removeAll(newAddTasks);
        List<Long> hostTaskIds = handlerTask.stream().map(task -> task.getLong("id")).collect(Collectors.toList());
        List coTasks = Arrays.stream(FLOW_RU_TASK_ENTITY_SERVICE.queryHostTaskAndCoTaskByIds(hostTaskIds)).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(coTasks)) {
            handlerTask.clear();
            handlerTask.addAll(coTasks);
        }
        handlerTask.addAll(newAddTasks);
        Map<Long, DynamicObject> handlerTaskMap = handlerTask.stream().collect(Collectors.toMap(a -> {
            Object handler = a.get("handler");
            long handlerId = 0L;
            if (handler instanceof Long) {
                handlerId = (Long)handler;
            } else if (handler instanceof DynamicObject) {
                handlerId = ((DynamicObject)handler).getLong("id");
            }
            return handlerId;
        }, v -> v, (oldValue, newValue) -> oldValue));
        HashSet<String> ignoreKeys = new HashSet<String>(Arrays.asList("id", "hosttask", "handler", "isreplace", "isdeleteop", "batchno"));
        ArrayList newCoTasks = new ArrayList(10);
        coOperatorMap.forEach((userId, coOperatorIds) -> {
            if (handlerTaskMap.containsKey(userId)) {
                DynamicObject hostTask = (DynamicObject)handlerTaskMap.get(userId);
                coOperatorIds.forEach(coUserId -> {
                    DynamicObject coTask = (DynamicObject)handlerTaskMap.get(coUserId);
                    if (HRObjectUtils.isEmpty((Object)coTask)) {
                        coTask = FLOW_RU_TASK_ENTITY_SERVICE.generateEmptyDynamicObject();
                        HRDynamicObjectUtils.copy((DynamicObject)hostTask, (DynamicObject)coTask, (Set)ignoreKeys);
                        coTask.set("handler", coUserId);
                        coTask.set("hosttask", (Object)hostTask);
                        coTask.set("iscotask", (Object)Boolean.TRUE);
                        newCoTasks.add(coTask);
                    }
                });
            }
        });
        handlerTask.addAll(newCoTasks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AssignHandlerVO> deleteHandlerAfterStartProcess(List<AssignHandlerParamDTO> dtos) {
        ArrayList<AssignHandlerVO> errorInfos = new ArrayList<AssignHandlerVO>();
        List<Long> taskIds = dtos.stream().map(e -> e.getTaskId()).collect(Collectors.toList());
        Set<Long> actevaObjs = dtos.stream().map(e -> e.getActevaObj()).collect(Collectors.toSet());
        Set<String> workflowType = dtos.stream().map(e -> e.getWorkFlowType()).collect(Collectors.toSet());
        Map<Long, AssignHandlerParamDTO> handlerParamDTOMap = dtos.stream().collect(Collectors.toMap(k -> k.getTaskId(), v -> v));
        DynamicObject[] handleTasks = FLOW_RU_TASK_ENTITY_SERVICE.queryTasksByIds(taskIds);
        Set handRoleIds = Arrays.stream(handleTasks).map(e -> e.getLong("flowrurole_id")).collect(Collectors.toSet());
        DynamicObject[] roles = FLOW_RU_ROLE_ENTITY_SERVICE.queryByRuRoleIds(handRoleIds.stream().collect(Collectors.toList()));
        ArrayList<DynamicObject> handleNodes = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> handleProcs = new ArrayList<DynamicObject>();
        Map<Long, DynamicObject> roleActevalObjOp = workflowType.contains("3") ? this.getInterviewObjByPks(actevaObjs) : this.getActevalObjByPks(actevaObjs);
        Map<Long, String> roleDefOp = this.getRoleDefOp(Arrays.asList(roles));
        Map<Long, Map<String, String>> taskHandlerNames = this.getTaskHandlerNames(Arrays.stream(handleTasks).map(e -> e.getLong("handler_id")).collect(Collectors.toSet()));
        DynamicObject[] roleTasks = FLOW_RU_TASK_ENTITY_SERVICE.queryOriginalSpecifyTaskByRoleIds(handRoleIds.stream().collect(Collectors.toList()));
        Map<Long, List<DynamicObject>> roleIdAllTaskMap = Arrays.stream(roleTasks).collect(Collectors.groupingBy(k -> k.getLong("flowrurole.id"), Collectors.toList()));
        this.assembleStatus(handleTasks, roleIdAllTaskMap, roles, handleNodes, handleProcs, handlerParamDTOMap, roleActevalObjOp, roleDefOp, DEL_HANDLER, taskHandlerNames, workflowType, errorInfos);
        FLOW_RU_TASK_ENTITY_SERVICE.setTaskModifyStatus(handleTasks);
        List<Long> hostTaskIds = Arrays.stream(handleTasks).filter(task -> HRStringUtils.equals((String)task.getString("taskstatus"), (String)FlowRuTaskStatusEnum.EXPIRED.getCode())).map(task -> task.getLong("id")).collect(Collectors.toList());
        DynamicObject[] coTasks = FLOW_RU_TASK_ENTITY_SERVICE.queryCoTasksByIds(hostTaskIds);
        WorkflowUtils.updateTaskStatus(coTasks, FlowRuTaskStatusEnum.EXPIRED.getCode());
        try (TXHandle required = TX.required();){
            FLOW_RU_TASK_ENTITY_SERVICE.save(handleTasks);
            FLOW_RU_TASK_ENTITY_SERVICE.save(coTasks);
            FLOW_RU_ROLE_ENTITY_SERVICE.update(roles);
            FLOW_RU_NODE_ENTITY_SERVICE.update((DynamicObject[])handleNodes.stream().toArray(DynamicObject[]::new));
            FLOW_RU_PROC_ENTITY_SERVICE.update((DynamicObject[])handleProcs.stream().toArray(DynamicObject[]::new));
        }
        this.runProcessAfterHandler(handleProcs, handleNodes, Arrays.stream(roles).collect(Collectors.toList()));
        return errorInfos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AssignHandlerVO> modifyHandlerAfterStartProcess(List<AssignHandlerParamDTO> dtos) {
        ArrayList<AssignHandlerVO> errorInfos = new ArrayList<AssignHandlerVO>();
        Map<Long, AssignHandlerParamDTO> handlerParamDTOMap = dtos.stream().collect(Collectors.toMap(k -> k.getTaskId(), v -> v));
        Set roleIds = dtos.stream().map(r -> r.getRoleId()).collect(Collectors.toSet());
        Set<Long> actevaObjs = dtos.stream().map(e -> e.getActevaObj()).collect(Collectors.toSet());
        Set<String> workflowType = dtos.stream().map(e -> e.getWorkFlowType()).collect(Collectors.toSet());
        List<Long> handleTaskIds = dtos.stream().map(e -> e.getTaskId()).collect(Collectors.toList());
        DynamicObject[] handleTasks = FLOW_RU_TASK_ENTITY_SERVICE.queryOriginalTasksByIds(handleTaskIds);
        DynamicObject[] roles = this.queryRolesByIds(roleIds.stream().collect(Collectors.toList()));
        Map<Long, DynamicObject> roleIdMap = Arrays.stream(roles).collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
        String properties = "id, taskstatus, updatestatustime, modifier, modifytime, flowrurole_id, handler, activity, flowruproc.workflowtype,hosttask.id";
        DynamicObject[] roleAlltasks = FLOW_RU_TASK_ENTITY_SERVICE.query(properties, new QFilter("flowrurole_id", "in", roleIds).toArray());
        Map<Long, List<DynamicObject>> roleIdAllTaskMap = Arrays.stream(roleAlltasks).collect(Collectors.groupingBy(k -> k.getLong("flowrurole_id"), Collectors.toList()));
        Map<Long, DynamicObject> roleActevalObjOp = workflowType.contains("3") ? this.getInterviewObjByPks(actevaObjs) : this.getActevalObjByPks(actevaObjs);
        Long activityId = Arrays.stream(roleAlltasks).map(task -> task.getLong("activity")).findFirst().orElse(0L);
        String workflowtype = Arrays.stream(roleAlltasks).map(task -> task.getString("flowruproc.workflowtype")).findFirst().orElse("");
        Map<Long, String> roleDefOp = this.getRoleDefOp(Arrays.asList(roles));
        List<Long> handlerIds = dtos.stream().flatMap(dto -> dto.getHandlerIds().stream()).collect(Collectors.toList());
        Map<Long, List<Long>> coOperatorMap = EPA_ACTEVAOBJ_SERVICE.getCooperator(activityId, handlerIds, workflowtype);
        List coOperatorList = coOperatorMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        handlerIds.addAll(coOperatorList);
        Map<Long, Map<String, String>> handlerNames = this.getHandlerNames(handlerIds);
        Map<Long, Map<String, String>> taskHandlerNames = this.getTaskHandlerNames(Arrays.stream(handleTasks).map(e -> e.getLong("handler.id")).collect(Collectors.toSet()));
        List<DynamicObject> handlerTasks = this.getModifyHandlerTasks(handlerParamDTOMap, dtos, handleTasks, roleIdMap, roleIdAllTaskMap, roleActevalObjOp, roleDefOp, handlerNames, taskHandlerNames, errorInfos);
        this.dealCoOperatorTasks(handlerTasks, coOperatorMap);
        Set handRoleIds = handlerTasks.stream().map(e -> e.getLong("flowrurole_id")).collect(Collectors.toSet());
        DynamicObject[] handRoles = (DynamicObject[])Arrays.stream(roles).filter(e -> handRoleIds.contains(e.getLong("id"))).toArray(DynamicObject[]::new);
        ArrayList<DynamicObject> handleNodes = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> handleProcs = new ArrayList<DynamicObject>();
        this.assembleStatus((DynamicObject[])handlerTasks.stream().toArray(DynamicObject[]::new), roleIdAllTaskMap, handRoles, handleNodes, handleProcs, handlerParamDTOMap, roleActevalObjOp, roleDefOp, ADD_HANDLER, taskHandlerNames, workflowType, errorInfos);
        FLOW_RU_ROLE_ENTITY_SERVICE.setRoleIsSetHander(handRoles);
        FLOW_RU_TASK_ENTITY_SERVICE.setTaskModifyStatus((DynamicObject[])handlerTasks.stream().toArray(DynamicObject[]::new));
        try (TXHandle required = TX.required();){
            DynamicObject[] updateTask = (DynamicObject[])handlerTasks.stream().filter(e -> 0L != e.getLong("id")).toArray(DynamicObject[]::new);
            FLOW_RU_TASK_ENTITY_SERVICE.save(updateTask);
            DynamicObject[] addTask = (DynamicObject[])handlerTasks.stream().filter(e -> 0L == e.getLong("id")).toArray(DynamicObject[]::new);
            FLOW_RU_TASK_ENTITY_SERVICE.save(addTask);
            FLOW_RU_ROLE_ENTITY_SERVICE.update(handRoles);
            FLOW_RU_NODE_ENTITY_SERVICE.update((DynamicObject[])handleNodes.stream().toArray(DynamicObject[]::new));
            FLOW_RU_PROC_ENTITY_SERVICE.update((DynamicObject[])handleProcs.stream().toArray(DynamicObject[]::new));
        }
        this.deleteHandlerAfterStartProcess(dtos);
        dtos.stream().forEach(dto -> {
            AssignHandlerVO retVo = new AssignHandlerVO();
            retVo.setErrorMessage("");
            retVo.setTaskId(dto.getTaskId());
            retVo.setSucess(Boolean.TRUE);
            retVo.setRoleId(dto.getRoleId());
            errorInfos.add(retVo);
        });
        this.sendMessageAfterHandler(handlerTasks, handleProcs);
        this.runProcessAfterHandler(handleProcs, handleNodes, Arrays.stream(handRoles).collect(Collectors.toList()));
        return errorInfos;
    }

    private void assembleStatus(DynamicObject[] handlerTasks, Map<Long, List<DynamicObject>> roleIdAllTaskMap, DynamicObject[] roles, List<DynamicObject> handleNodes, List<DynamicObject> handleProcs, Map<Long, AssignHandlerParamDTO> handlerParamDTOMap, Map<Long, DynamicObject> roleActevalObjOp, Map<Long, String> roleDefOp, String operation, Map<Long, Map<String, String>> taskHandlerNames, Set<String> workflowType, List<AssignHandlerVO> errorInfos) {
        Map roleIdHandleTaskMap = Arrays.stream(handlerTasks).collect(Collectors.groupingBy(k -> k.getLong("flowrurole_id"), Collectors.toList()));
        Map nodeIdRoleMap = Arrays.stream(roles).collect(Collectors.groupingBy(r -> r.getLong("flowrunode_id"), Collectors.toList()));
        List<Long> nodeIds = Arrays.stream(roles).map(role -> role.getLong("flowrunode_id")).collect(Collectors.toList());
        Map<Long, Boolean> manualopMap = this.getManualOpMapByRoles(Arrays.stream(roles).collect(Collectors.toList()));
        DynamicObject[] nodes = FLOW_RU_NODE_ENTITY_SERVICE.queryByRuNodeIds(nodeIds);
        Map handleProcNodesMap = Arrays.stream(nodes).collect(Collectors.groupingBy(r -> r.getLong("flowruproc_id"), Collectors.toList()));
        DynamicObject[] nodeRoles = FLOW_RU_ROLE_ENTITY_SERVICE.queryOriginalRolesByNodeIds((Long[])nodeIds.stream().toArray(Long[]::new));
        Map nodeRoleMap = Arrays.stream(nodeRoles).collect(Collectors.groupingBy(k -> k.getLong("flowrunode.id"), Collectors.toList()));
        List<Long> procIds = Arrays.stream(nodes).map(node -> node.getLong("flowruproc_id")).collect(Collectors.toList());
        DynamicObject[] procs = FLOW_RU_PROC_ENTITY_SERVICE.queryProcByPkIds(procIds);
        DynamicObject[] procNodes = FLOW_RU_NODE_ENTITY_SERVICE.queryOriginalAllNodeByProcIds((Long[])procIds.stream().toArray(Long[]::new));
        Map procNodesMap = Arrays.stream(procNodes).collect(Collectors.groupingBy(k -> k.getLong("flowruproc.id"), Collectors.toList()));
        Arrays.stream(procs).forEach(proc -> {
            List currProcHandleNodes = (List)handleProcNodesMap.get(proc.getLong("id"));
            currProcHandleNodes.stream().forEach(node -> {
                List currNodeHandleRoles = (List)nodeIdRoleMap.get(node.getLong("id"));
                for (DynamicObject currRole : currNodeHandleRoles) {
                    List tasks = (List)roleIdHandleTaskMap.get(currRole.getLong("id"));
                    for (DynamicObject task : tasks) {
                        if (HRStringUtils.equals((String)DEL_HANDLER, (String)operation)) {
                            AssignHandlerParamDTO dto = (AssignHandlerParamDTO)handlerParamDTOMap.get(task.getLong("id"));
                            String workFlowType = dto.getWorkFlowType();
                            if (dto.getHandType() == 2) {
                                String errMessage;
                                Object[] args;
                                DynamicObject actEvaObj;
                                AssignHandlerVO retVo;
                                if (task.getBoolean("iscotask")) {
                                    Object[] args2 = this.getArgs(roleActevalObjOp, dto);
                                    this.checkCoTask(args2, errorInfos, task, dto, null);
                                    continue;
                                }
                                Set roleTaskIds = ((List)roleIdAllTaskMap.get(currRole.getLong("id"))).stream().filter(e -> !this.getUnNormalTaskStatus().contains(e.getString("taskstatus"))).collect(Collectors.toSet()).stream().map(v -> v.getLong("id")).collect(Collectors.toSet());
                                Set handleTaskIds = tasks.stream().map(t -> t.getLong("id")).collect(Collectors.toSet());
                                roleTaskIds.removeAll(handleTaskIds);
                                if (!this.getCanRoleStatus().contains(currRole.getString("rolestatus"))) {
                                    retVo = new AssignHandlerVO();
                                    actEvaObj = (DynamicObject)roleActevalObjOp.get(dto.getActevaObj());
                                    args = new Object[]{actEvaObj != null ? actEvaObj.getString("person.name") : "", actEvaObj != null ? actEvaObj.getString("person.number") : "", roleDefOp.get(currRole.getLong("id")), FlowRuRoleStatusEnum.getFlowRuRoleStatusByCode(currRole.getString("rolestatus")).getText()};
                                    errMessage = CUSTOM_TERMINOLOGY_DOMAIN_SERVICE.getCusTerminology(ResManager.loadKDString((String)"\u5236\u5b9a\u5bf9\u8c61{0}\uff08\u5de5\u53f7\uff1a{1}\uff09\uff1a\u5f53\u524d\u8282\u70b9\u4e0b\u89d2\u8272\u201c{2}\u201d\u7684\u72b6\u6001\u4e3a\u201c{3}\u201d\uff0c\u4e0d\u652f\u6301\u5220\u9664\u5236\u5b9a\u4eba\u3002", (String)"FlowHandlerBatchDomainService_23", (String)"opmc-pbs-business", (Object[])args));
                                    if (HRStringUtils.equals((String)workFlowType, (String)"2")) {
                                        errMessage = ResManager.loadKDString((String)"\u8bc4\u4f30\u5bf9\u8c61{0}\uff08\u5de5\u53f7\uff1a{1}\uff09\uff1a\u5f53\u524d\u8282\u70b9\u4e0b\u7684\u89d2\u8272\u201c{2}\u201d\u72b6\u6001\u4e3a{3}\uff0c\u4e0d\u652f\u6301\u5220\u9664\u8bc4\u4f30\u4eba\u3002", (String)"FlowHandlerBatchDomainService_24", (String)"opmc-pbs-business", (Object[])args);
                                    } else if (HRStringUtils.equals((String)workFlowType, (String)"3")) {
                                        errMessage = ResManager.loadKDString((String)"\u9762\u8c08\u5bf9\u8c61-{0}\uff08\u5de5\u53f7\uff1a{1}\uff09\uff1a\u5f53\u524d\u8282\u70b9\u4e0b\u7684\u89d2\u8272\u201c{2}\u201d\u72b6\u6001\u4e3a{3}\uff0c\u4e0d\u53ef\u5220\u9664\u5904\u7406\u4eba\u3002", (String)"FlowHandlerBatchDomainService_46", (String)"opmc-pbs-business", (Object[])args);
                                    }
                                    retVo.setId(dto.getId());
                                    retVo.setTaskId(task.getLong("id"));
                                    retVo.setRoleId(currRole.getLong("id"));
                                    retVo.setSucess(Boolean.FALSE);
                                    retVo.setErrorMessage(errMessage);
                                    errorInfos.add(retVo);
                                    continue;
                                }
                                if (this.getNotDeleteTaskStatus().contains(task.getString("taskstatus"))) {
                                    retVo = new AssignHandlerVO();
                                    Object[] args3 = new Object[]{taskHandlerNames.get(task.getLong("handler_id")) != null ? ((Map)taskHandlerNames.get(task.getLong("handler_id"))).get("name") : "", taskHandlerNames.get(task.getLong("handler_id")) != null ? ((Map)taskHandlerNames.get(task.getLong("handler_id"))).get("number") : "", FlowRuTaskStatusEnum.getFlowRuTaskStatusByCode(task.getString("taskstatus")).getText()};
                                    String errMessage2 = CUSTOM_TERMINOLOGY_DOMAIN_SERVICE.getCusTerminology(ResManager.loadKDString((String)"\u5236\u5b9a\u4eba{0}\uff08\u5de5\u53f7\uff1a{1}\uff09\uff1a:\u5f53\u524d\u5236\u5b9a\u4efb\u52a1\u72b6\u6001\u4e3a\u201c{2}\u201d\uff0c\u4e0d\u652f\u6301\u5220\u9664\u3002", (String)"FlowHandlerBatchDomainService_25", (String)"opmc-pbs-business", (Object[])args3));
                                    if (HRStringUtils.equals((String)workFlowType, (String)"2")) {
                                        errMessage2 = ResManager.loadKDString((String)"\u8bc4\u4f30\u4eba{0}\uff08\u5de5\u53f7\uff1a{1}\uff09\uff1a\u5f53\u524d\u8bc4\u4f30\u4efb\u52a1\u72b6\u6001\u4e3a\u201c{2}\u201d\uff0c\u4e0d\u652f\u6301\u5220\u9664\u8bc4\u4f30\u4eba\u3002", (String)"FlowHandlerBatchDomainService_26", (String)"opmc-pbs-business", (Object[])args3);
                                    } else if (HRStringUtils.equals((String)workFlowType, (String)"3")) {
                                        errMessage2 = ResManager.loadKDString((String)"\u5904\u7406\u4eba-{0}\uff08\u5de5\u53f7\uff1a{1}:\u5f53\u524d\u9762\u8c08\u4efb\u52a1\u72b6\u6001\u4e3a\u201c{2}\u201d\uff0c\u4e0d\u53ef\u5220\u9664\u5904\u7406\u4eba\u3002", (String)"FlowHandlerBatchDomainService_45", (String)"opmc-pbs-business", (Object[])args3);
                                    }
                                    retVo.setId(dto.getId());
                                    retVo.setRoleId(currRole.getLong("id"));
                                    retVo.setHandlerId(task.getLong("handler_id"));
                                    retVo.setTaskId(task.getLong("id"));
                                    retVo.setSucess(Boolean.FALSE);
                                    retVo.setErrorMessage(errMessage2);
                                    errorInfos.add(retVo);
                                    continue;
                                }
                                if (roleTaskIds.size() < 1) {
                                    retVo = new AssignHandlerVO();
                                    actEvaObj = (DynamicObject)roleActevalObjOp.get(dto.getActevaObj());
                                    args = new Object[]{taskHandlerNames.get(task.getLong("handler_id")) != null ? ((Map)taskHandlerNames.get(task.getLong("handler_id"))).get("name") : "", taskHandlerNames.get(task.getLong("handler_id")) != null ? ((Map)taskHandlerNames.get(task.getLong("handler_id"))).get("number") : "", actEvaObj != null ? actEvaObj.getString("person.name") : ""};
                                    errMessage = CUSTOM_TERMINOLOGY_DOMAIN_SERVICE.getCusTerminology(ResManager.loadKDString((String)"\u5236\u5b9a\u4eba{0}\uff08\u5de5\u53f7\uff1a{1}\uff09\uff1a\u4e3a{2}\u5f53\u524d\u5236\u5b9a\u4efb\u52a1\u7684\u552f\u4e00\u6709\u6548\u5904\u7406\u4eba\uff0c\u4e0d\u652f\u6301\u5220\u9664\u3002", (String)"FlowHandlerBatchDomainService_28", (String)"opmc-pbs-business", (Object[])args));
                                    if (HRStringUtils.equals((String)workFlowType, (String)"2")) {
                                        errMessage = ResManager.loadKDString((String)"\u8bc4\u4f30\u4eba{0}\uff08\u5de5\u53f7\uff1a{1}\uff09\u4e3a{2}\u5f53\u524d\u8bc4\u4f30\u4efb\u52a1\u7684\u552f\u4e00\u6709\u6548\u5904\u7406\u4eba\uff0c\u4e0d\u652f\u6301\u5220\u9664\u8bc4\u4f30\u4eba\u3002", (String)"FlowHandlerBatchDomainService_29", (String)"opmc-pbs-business", (Object[])args);
                                    } else if (HRStringUtils.equals((String)workFlowType, (String)"3")) {
                                        errMessage = ResManager.loadKDString((String)"\u5904\u7406\u4eba{0}\uff08\u5de5\u53f7\uff1a{1}\uff09\uff1a\u4e3a{2}\u5f53\u524d\u9762\u8c08\u4efb\u52a1\u7684\u552f\u4e00\u6709\u6548\u5904\u7406\u4eba\uff0c\u4e0d\u652f\u6301\u5220\u9664\u3002", (String)"FlowHandlerBatchDomainService_44", (String)"opmc-pbs-business", (Object[])args);
                                    }
                                    retVo.setId(dto.getId());
                                    retVo.setRoleId(currRole.getLong("id"));
                                    retVo.setHandlerId(task.getLong("handler_id"));
                                    retVo.setTaskId(task.getLong("id"));
                                    retVo.setSucess(Boolean.FALSE);
                                    retVo.setErrorMessage(errMessage);
                                    errorInfos.add(retVo);
                                    continue;
                                }
                                retVo = new AssignHandlerVO();
                                retVo.setId(dto.getId());
                                retVo.setTaskId(task.getLong("id"));
                                retVo.setRoleId(dto.getRoleId());
                                retVo.setSucess(Boolean.TRUE);
                                retVo.setErrorMessage("");
                                errorInfos.add(retVo);
                            }
                        }
                        if (node.getBoolean("iscrossnode")) {
                            Map setnoRoleMap = ((List)nodeRoleMap.get(node.getLong("id"))).stream().collect(Collectors.groupingBy(k -> k.getString("setno"), Collectors.toList()));
                            this.assembleRoleTaskStatus((DynamicObject)proc, currRole, setnoRoleMap.get(currRole.getString("setno")), (DynamicObject)node, task, tasks, roleIdAllTaskMap, null, manualopMap, workflowType, operation);
                            continue;
                        }
                        this.assembleRoleTaskStatus((DynamicObject)proc, currRole, (List)nodeRoleMap.get(node.getLong("id")), (DynamicObject)node, task, tasks, roleIdAllTaskMap, null, manualopMap, workflowType, operation);
                    }
                }
                this.assembleNodeStatus((DynamicObject)node, currNodeHandleRoles, (List)nodeRoleMap.get(node.getLong("id")));
            });
            this.assembleProcStatus((DynamicObject)proc, currProcHandleNodes, (List)procNodesMap.get(proc.getLong("id")));
        });
        handleNodes.addAll(Arrays.asList(nodes));
        handleProcs.addAll(Arrays.asList(procs));
    }

    private void assembleRoleTaskStatus(DynamicObject proc, DynamicObject currRole, List<DynamicObject> currNodeRoles, DynamicObject node, DynamicObject task, List<DynamicObject> tasks, Map<Long, List<DynamicObject>> roleIdAllTaskMap, Set<Long> needExpriedTaskIdSet, Map<Long, Boolean> manualopMap, Set<String> workflowType, String operation) {
        switch (FlowRuRoleStatusEnum.getFlowRuRoleStatusByCode(currRole.getString("rolestatus"))) {
            case PENDING: {
                boolean isCurrentRoleStatusNormal = this.isCurrentRoleStatusNormal(currRole, roleIdAllTaskMap, tasks, Boolean.TRUE);
                if (this.isTurntoCurrentRole(currRole, proc)) {
                    if (HRStringUtils.equals((String)DEL_HANDLER_CROSS, (String)operation) && !needExpriedTaskIdSet.contains(task.getLong("id"))) {
                        isCurrentRoleStatusNormal = this.isCurrentRoleStatusNormal(currRole, roleIdAllTaskMap, tasks, Boolean.FALSE);
                    }
                    if (isCurrentRoleStatusNormal) {
                        currRole.set("rolestatus", (Object)FlowRuRoleStatusEnum.RUNNING.getCode());
                    } else {
                        currRole.set("rolestatus", (Object)FlowRuRoleStatusEnum.PENDING.getCode());
                    }
                    if (HRStringUtils.equals((String)ADD_HANDLER, (String)operation)) {
                        if (this.isManualopNode(manualopMap, node)) {
                            task.set("taskstatus", (Object)FlowRuTaskStatusEnum.BE_WAITTING.getCode());
                        } else {
                            task.set("taskstatus", (Object)FlowRuTaskStatusEnum.WAITING.getCode());
                        }
                        if (!node.getBoolean("iscrossnode") && !workflowType.contains("2")) {
                            this.assembleIndicatorAuditNodeTaskStaus(roleIdAllTaskMap, node, currRole, task);
                        }
                    }
                    if (HRStringUtils.equals((String)DEL_HANDLER, (String)operation)) {
                        task.set("taskstatus", (Object)FlowRuTaskStatusEnum.EXPIRED.getCode());
                        task.set("isdeleteop", (Object)Boolean.TRUE);
                    }
                    if (!HRStringUtils.equals((String)DEL_HANDLER_CROSS, (String)operation) || !needExpriedTaskIdSet.contains(task.getLong("id"))) break;
                    task.set("taskstatus", (Object)FlowRuTaskStatusEnum.EXPIRED.getCode());
                    task.set("isdeleteop", (Object)Boolean.TRUE);
                    break;
                }
                if (HRStringUtils.equals((String)DEL_HANDLER_CROSS, (String)operation) && !needExpriedTaskIdSet.contains(task.getLong("id"))) {
                    isCurrentRoleStatusNormal = this.isCurrentRoleStatusNormal(currRole, roleIdAllTaskMap, tasks, Boolean.FALSE);
                }
                if (isCurrentRoleStatusNormal) {
                    currRole.set("rolestatus", (Object)FlowRuRoleStatusEnum.NOT_ACTIVE.getCode());
                } else {
                    currRole.set("rolestatus", (Object)FlowRuRoleStatusEnum.PENDING.getCode());
                }
                if (HRStringUtils.equals((String)ADD_HANDLER, (String)operation)) {
                    task.set("taskstatus", (Object)FlowRuTaskStatusEnum.NOT_ACTIVE.getCode());
                    if (!node.getBoolean("iscrossnode") && !workflowType.contains("2")) {
                        this.assembleIndicatorAuditNodeTaskStaus(roleIdAllTaskMap, node, currRole, task);
                    }
                }
                if (HRStringUtils.equals((String)DEL_HANDLER, (String)operation)) {
                    task.set("taskstatus", (Object)FlowRuTaskStatusEnum.EXPIRED.getCode());
                    task.set("isdeleteop", (Object)Boolean.TRUE);
                }
                if (!HRStringUtils.equals((String)DEL_HANDLER_CROSS, (String)operation) || !needExpriedTaskIdSet.contains(task.getLong("id"))) break;
                task.set("taskstatus", (Object)FlowRuTaskStatusEnum.EXPIRED.getCode());
                task.set("isdeleteop", (Object)Boolean.TRUE);
                break;
            }
            case RUNNING: {
                if (HRStringUtils.equals((String)ADD_HANDLER, (String)operation)) {
                    if (this.isManualopNode(manualopMap, node)) {
                        task.set("taskstatus", (Object)FlowRuTaskStatusEnum.BE_WAITTING.getCode());
                    } else {
                        task.set("taskstatus", (Object)FlowRuTaskStatusEnum.WAITING.getCode());
                    }
                    if (!node.getBoolean("iscrossnode") && !workflowType.contains("2")) {
                        this.assembleIndicatorAuditNodeTaskStaus(roleIdAllTaskMap, node, currRole, task);
                    }
                }
                if (HRStringUtils.equals((String)DEL_HANDLER, (String)operation)) {
                    task.set("taskstatus", (Object)FlowRuTaskStatusEnum.EXPIRED.getCode());
                    task.set("isdeleteop", (Object)Boolean.TRUE);
                }
                if (HRStringUtils.equals((String)DEL_HANDLER_CROSS, (String)operation) && needExpriedTaskIdSet.contains(task.getLong("id"))) {
                    task.set("taskstatus", (Object)FlowRuTaskStatusEnum.EXPIRED.getCode());
                    task.set("isdeleteop", (Object)Boolean.TRUE);
                }
                currRole.set("rolestatus", (Object)FlowRuRoleStatusEnum.RUNNING.getCode());
                break;
            }
            case NOT_ACTIVE: {
                if (HRStringUtils.equals((String)ADD_HANDLER, (String)operation)) {
                    task.set("taskstatus", (Object)FlowRuTaskStatusEnum.NOT_ACTIVE.getCode());
                    if (!node.getBoolean("iscrossnode") && !workflowType.contains("2")) {
                        this.assembleIndicatorAuditNodeTaskStaus(roleIdAllTaskMap, node, currRole, task);
                    }
                }
                if (HRStringUtils.equals((String)DEL_HANDLER, (String)operation)) {
                    task.set("taskstatus", (Object)FlowRuTaskStatusEnum.EXPIRED.getCode());
                    task.set("isdeleteop", (Object)Boolean.TRUE);
                }
                if (HRStringUtils.equals((String)DEL_HANDLER_CROSS, (String)operation) && needExpriedTaskIdSet.contains(task.getLong("id"))) {
                    task.set("taskstatus", (Object)FlowRuTaskStatusEnum.EXPIRED.getCode());
                    task.set("isdeleteop", (Object)Boolean.TRUE);
                }
                currRole.set("rolestatus", (Object)FlowRuRoleStatusEnum.NOT_ACTIVE.getCode());
                break;
            }
        }
    }

    private Map<Long, Map<String, String>> getHandlerNames(List<Long> handlerIds) {
        HashMap<Long, Map<String, String>> handlerMap = new HashMap<Long, Map<String, String>>(16);
        List handlers = UserServiceHelper.getUserInfoByID(handlerIds);
        handlers.forEach(handler -> {
            HashMap handlerInfo = HRMapUtils.newHashMap();
            handlerInfo.put("name", String.valueOf(handler.get("name")));
            handlerInfo.put("number", String.valueOf(handler.get("number")));
            handlerMap.put((Long)handler.get("id"), handlerInfo);
        });
        return handlerMap;
    }

    private Map<Long, Map<String, String>> getTaskHandlerNames(Set<Long> taskHandlers) {
        HashMap<Long, Map<String, String>> handlerMap = new HashMap<Long, Map<String, String>>(16);
        List handlers = UserServiceHelper.getUserInfoByID(taskHandlers.stream().collect(Collectors.toList()));
        handlers.stream().forEach(handler -> {
            HashMap handlerInfo = HRMapUtils.newHashMap();
            handlerInfo.put("name", String.valueOf(handler.get("name")));
            handlerInfo.put("number", String.valueOf(handler.get("number")));
            handlerMap.put((Long)handler.get("id"), handlerInfo);
        });
        return handlerMap;
    }

    private Map<Long, DynamicObject> getInterviewObjByPks(Set<Long> interObjs) {
        DynamicObject[] interViewObjs = IEPAActevalobjService.getInstance().getInterviewobjArrayById(interObjs.stream().collect(Collectors.toList()));
        Map<Long, DynamicObject> interViewObjOp = Arrays.stream(interViewObjs).collect(Collectors.toMap(a -> a.getLong("id"), v -> v));
        return interViewObjOp;
    }

    private Map<Long, DynamicObject> getActevalObjByPks(Set<Long> actevaObjs) {
        DynamicObject[] actEvaObjs = IEPAActevalobjService.getInstance().getActevalobjArrayById(actevaObjs.stream().collect(Collectors.toList()));
        Map<Long, DynamicObject> actEvaObjOp = Arrays.stream(actEvaObjs).collect(Collectors.toMap(a -> a.getLong("id"), v -> v));
        return actEvaObjOp;
    }

    private Map<Long, String> getRoleDefOp(Collection<DynamicObject> roles) {
        if (CollectionUtils.isEmpty(roles)) {
            return Collections.emptyMap();
        }
        List roleDefIds = roles.stream().map(r -> r.getLong("flowdefrole_id")).collect(Collectors.toList());
        DynamicObject[] roleDefs = FLOW_DEF_ROLE_ENTITY_SERVICE.queryRoleDefByPks((Long[])roleDefIds.stream().toArray(Long[]::new));
        Map<Long, String> roleDefOp = Arrays.stream(roleDefs).collect(Collectors.toMap(k -> k.getLong("id"), v -> v.getString("rolename")));
        return roles.stream().collect(Collectors.toMap(k -> k.getLong("id"), v -> (String)roleDefOp.get(v.getLong("flowdefrole_id"))));
    }

    private boolean isTurntoCurrentRole(DynamicObject currRole, List<DynamicObject> currNodeRoles) {
        List preRoles = currNodeRoles.stream().map(role -> {
            if (Integer.compare(role.getInt("turnoversort"), currRole.getInt("turnoversort")) < 0) {
                return role;
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        long noFinishRolesCount = preRoles.stream().filter(role -> !HRStringUtils.equals((String)role.getString("rolestatus"), (String)FlowRuRoleStatusEnum.FINISHED.getCode())).count();
        return noFinishRolesCount > 0L ? Boolean.FALSE : Boolean.TRUE;
    }

    private boolean isTurntoCurrentRole(DynamicObject currRole, DynamicObject proc) {
        DynamicObjectCollection entrys = proc.getDynamicObjectCollection("entryentity");
        Set currRoleIdSet = entrys.stream().map(e -> e.getDynamicObject("ruroleid").getLong("id")).collect(Collectors.toSet());
        return currRoleIdSet.contains(currRole.getLong("id"));
    }

    private boolean isCurrentRoleStatusNormal(DynamicObject currRole, Map<Long, List<DynamicObject>> roleIdAllTaskMap, List<DynamicObject> tasks, boolean isNeedRemove) {
        List<DynamicObject> currRoleTasks = roleIdAllTaskMap.get(currRole.getLong("id"));
        Set pendingTaskIds = tasks.stream().map(e -> {
            if (0L != e.getLong("id") && HRStringUtils.equals((String)FlowRuTaskStatusEnum.PENDING.getCode(), (String)e.getString("taskstatus"))) {
                return e.getLong("id");
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toSet());
        Set pendingRoleTaskIds = currRoleTasks.stream().map(e -> {
            if (HRStringUtils.equals((String)FlowRuTaskStatusEnum.PENDING.getCode(), (String)e.getString("taskstatus"))) {
                return e.getLong("id");
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toSet());
        if (isNeedRemove) {
            pendingRoleTaskIds.removeAll(pendingTaskIds);
        }
        return pendingRoleTaskIds.size() > 0 ? Boolean.FALSE : Boolean.TRUE;
    }

    private boolean isManualopNode(Map<Long, Boolean> manualopMap, DynamicObject node) {
        return manualopMap.get(node.getLong("id"));
    }

    private boolean isCurrentNodeStatusNormal(List<DynamicObject> currNodeRoles) {
        long abnormalRoleCount = currNodeRoles.stream().filter(role -> HRStringUtils.equals((String)FlowRuRoleStatusEnum.PENDING.getCode(), (String)role.getString("rolestatus"))).count();
        return abnormalRoleCount > 0L ? Boolean.FALSE : Boolean.TRUE;
    }

    private boolean isProcStatusNormal(DynamicObject[] procNodes) {
        return Arrays.stream(procNodes).filter(node -> HRStringUtils.equals((String)FlowRuNodeStatusEnum.PENDING.getCode(), (String)node.getString("nodestatus"))).count() > 0L ? Boolean.FALSE : Boolean.TRUE;
    }

    private boolean isCurrentNodeStatusNoActive(List<DynamicObject> currNodeRoles) {
        return (long)currNodeRoles.size() == currNodeRoles.stream().filter(role -> HRStringUtils.equals((String)FlowRuRoleStatusEnum.NOT_ACTIVE.getCode(), (String)role.getString("rolestatus"))).count() ? Boolean.TRUE : Boolean.FALSE;
    }

    private boolean isTaskJump(Long procId, Long handler) {
        return FLOW_RU_TASK_ENTITY_SERVICE.countAuditNodeHandlerProceedOrRollBackTasks(procId, handler) > 0 ? Boolean.TRUE : Boolean.FALSE;
    }

    private void assembleIndicatorAuditNodeTaskStaus(Map<Long, List<DynamicObject>> roleIdAllTaskMap, DynamicObject node, DynamicObject currRole, DynamicObject task) {
        if (indicatorWorkflowFlowOutNodeType.contains(node.getLong("flownodedef.nodetype.id")) && roleIdAllTaskMap.get(currRole.getLong("id")).stream().filter(e -> HRStringUtils.equals((String)FlowRuTaskStatusEnum.PROCESSED.getCode(), (String)e.getString("taskstatus"))).count() > 0L) {
            task.set("taskstatus", (Object)FlowRuTaskStatusEnum.EXPIRED.getCode());
        }
        if (NodeTypeConstants.INDICATOR_AUDIT.equals(node.getLong("flownodedef.nodetype.id"))) {
            switch (FlowDefRoleOutEnum.getOutEnumByCode(currRole.getString("flowdefrole.outflow"))) {
                case FIRST_SUBMIT: {
                    if (roleIdAllTaskMap.get(currRole.getLong("id")).stream().filter(e -> HRStringUtils.equals((String)FlowRuTaskStatusEnum.PROCESSED.getCode(), (String)e.getString("taskstatus"))).count() <= 0L) break;
                    task.set("taskstatus", (Object)FlowRuTaskStatusEnum.EXPIRED.getCode());
                    break;
                }
                case SET_OUT_NUM: {
                    if (roleIdAllTaskMap.get(currRole.getLong("id")).stream().filter(e -> HRStringUtils.equals((String)FlowRuTaskStatusEnum.PROCESSED.getCode(), (String)e.getString("taskstatus"))).count() < (long)currRole.getInt("flowdefrole.minnum")) break;
                    task.set("taskstatus", (Object)FlowRuTaskStatusEnum.EXPIRED.getCode());
                    break;
                }
                case ALL_HANDLER: {
                    break;
                }
            }
            if (node.getBoolean("flownodedef.sameauditjump") && this.isTaskJump(node.getLong("flowruproc_id"), task.getLong("handler.id") == 0L ? task.getLong("handler") : task.getLong("handler.id"))) {
                task.set("taskstatus", (Object)FlowRuTaskStatusEnum.PROCESSED.getCode());
            }
        }
    }

    private void assembleNodeStatus(DynamicObject node, List<DynamicObject> currNodeHandleRoles, List<DynamicObject> currNodeRoles) {
        Set currNodeHandleRoleIds = currNodeHandleRoles.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
        Map<Long, DynamicObject> currNodeHandleRoleMap = currNodeHandleRoles.stream().collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
        ArrayList delList = new ArrayList();
        ArrayList addList = new ArrayList();
        currNodeRoles.stream().forEach(r -> {
            if (currNodeHandleRoleIds.contains(r.getLong("id"))) {
                delList.add(r);
                addList.add(currNodeHandleRoleMap.get(r.getLong("id")));
            }
        });
        currNodeRoles.removeAll(delList);
        currNodeRoles.addAll(addList);
        switch (FlowRuNodeStatusEnum.getFlowRuNodeStatusByCode(node.getString("nodestatus"))) {
            case PENDING: {
                if (!this.isCurrentNodeStatusNormal(currNodeRoles)) break;
                node.set("nodestatus", (Object)FlowRuNodeStatusEnum.RUNNING.getCode());
                if (!this.isCurrentNodeStatusNoActive(currNodeRoles)) break;
                node.set("nodestatus", (Object)FlowRuNodeStatusEnum.NOT_ACTIVE.getCode());
                break;
            }
            case RUNNING: {
                break;
            }
            case NOT_ACTIVE: {
                if (this.isCurrentNodeStatusNormal(currNodeRoles)) {
                    if (this.isCurrentNodeStatusNoActive(currNodeRoles)) break;
                    node.set("nodestatus", (Object)FlowRuNodeStatusEnum.RUNNING.getCode());
                    break;
                }
                node.set("nodestatus", (Object)FlowRuNodeStatusEnum.PENDING.getCode());
            }
        }
    }

    private void assembleProcStatus(DynamicObject proc, List<DynamicObject> currProcHandleNodes, List<DynamicObject> currProcNodes) {
        Set currProcHandleNodeIds = currProcHandleNodes.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
        Map<Long, DynamicObject> currProcHandleNodeMap = currProcHandleNodes.stream().collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
        ArrayList delList = new ArrayList();
        ArrayList addList = new ArrayList();
        currProcNodes.stream().forEach(r -> {
            if (currProcHandleNodeIds.contains(r.getLong("id"))) {
                delList.add(r);
                addList.add(currProcHandleNodeMap.get(r.getLong("id")));
            }
        });
        currProcNodes.removeAll(delList);
        currProcNodes.addAll(addList);
        switch (FlowRuProcStatusEnum.getFlowRuProcStatusByCode(proc.getString("procstatus"))) {
            case PENDING: {
                if (!this.isProcStatusNormal((DynamicObject[])currProcNodes.stream().toArray(DynamicObject[]::new))) break;
                proc.set("procstatus", (Object)FlowRuProcStatusEnum.RUNNING.getCode());
                break;
            }
        }
    }

    private HashSet<String> getValidTaskStatus() {
        return new HashSet<String>(Arrays.asList(FlowRuTaskStatusEnum.NOT_ACTIVE.getCode(), FlowRuTaskStatusEnum.WAITING.getCode(), FlowRuTaskStatusEnum.PROCESSING.getCode(), FlowRuTaskStatusEnum.BE_WAITTING.getCode(), FlowRuTaskStatusEnum.PROCESSED.getCode(), FlowRuTaskStatusEnum.RETURNED.getCode(), FlowRuTaskStatusEnum.REJECTED.getCode()));
    }

    private HashSet<String> getCanRoleStatus() {
        return new HashSet<String>(Arrays.asList(FlowRuRoleStatusEnum.RUNNING.getCode(), FlowRuRoleStatusEnum.PENDING.getCode(), FlowRuRoleStatusEnum.NOT_ACTIVE.getCode()));
    }

    private HashSet<String> getNotDeleteTaskStatus() {
        return new HashSet<String>(Arrays.asList(FlowRuTaskStatusEnum.PROCESSED.getCode(), FlowRuTaskStatusEnum.RETURNED.getCode()));
    }

    private HashSet<String> getNotModifyTaskStatus() {
        return new HashSet<String>(Arrays.asList(FlowRuTaskStatusEnum.PROCESSED.getCode(), FlowRuTaskStatusEnum.EXPIRED.getCode(), FlowRuTaskStatusEnum.REJECTED.getCode(), FlowRuTaskStatusEnum.RETURNED.getCode()));
    }

    private HashSet<String> getUnNormalTaskStatus() {
        return new HashSet<String>(Arrays.asList(FlowRuTaskStatusEnum.EXPIRED.getCode(), FlowRuTaskStatusEnum.REJECTED.getCode(), FlowRuTaskStatusEnum.PENDING.getCode()));
    }

    private HashSet<String> getCanNotRunNodeStatus() {
        return new HashSet<String>(Arrays.asList(FlowRuNodeStatusEnum.FINISHED.getCode(), FlowRuNodeStatusEnum.EXPIRED.getCode()));
    }

    private HashSet<String> getCanRunProcStatus() {
        return new HashSet<String>(Arrays.asList(FlowRuProcStatusEnum.RUNNING.getCode(), FlowRuProcStatusEnum.PENDING.getCode()));
    }

    private HashSet<String> getCanRunRoleStatus() {
        return new HashSet<String>(Collections.singletonList(FlowRuRoleStatusEnum.RUNNING.getCode()));
    }

    private List<DynamicObject> getModifyHandlerTasks(Map<Long, AssignHandlerParamDTO> handlerParamDTOMap, List<AssignHandlerParamDTO> modifyHandlerDtos, DynamicObject[] handleTasks, Map<Long, DynamicObject> roleIdMap, Map<Long, List<DynamicObject>> roleIdAllTaskMap, Map<Long, DynamicObject> roleActevalObjOp, Map<Long, String> roleDefOp, Map<Long, Map<String, String>> handlerNames, Map<Long, Map<String, String>> taskHandlerNames, List<AssignHandlerVO> errorInfos) {
        ArrayList<DynamicObject> retHandlerTask = new ArrayList<DynamicObject>();
        ArrayList<AssignHandlerParamDTO> delTaskDtos = new ArrayList<AssignHandlerParamDTO>();
        for (DynamicObject task : handleTasks) {
            Object[] args;
            AssignHandlerVO retVo;
            AssignHandlerParamDTO dto = handlerParamDTOMap.get(task.getLong("id"));
            String workFlowType = dto.getWorkFlowType();
            HashSet<Long> handlerIdSet = new HashSet<Long>(dto.getHandlerIds());
            DynamicObject role = roleIdMap.get(dto.getRoleId());
            if (task.getBoolean("iscotask")) {
                Object[] args2 = new Object[]{taskHandlerNames.get(task.getLong("handler_id")).get("name"), taskHandlerNames.get(task.getLong("handler_id")).get("number"), FlowRuTaskStatusEnum.getFlowRuTaskStatusByCode(task.getString("taskstatus")).getText()};
                this.checkCoTask(args2, errorInfos, task, dto, delTaskDtos);
                continue;
            }
            if (!this.getCanRoleStatus().contains(role.getString("rolestatus"))) {
                retVo = new AssignHandlerVO();
                DynamicObject actEvaObj = roleActevalObjOp.get(dto.getActevaObj());
                args = new Object[]{actEvaObj != null ? actEvaObj.getString("person.name") : "", actEvaObj != null ? actEvaObj.getString("person.number") : "", roleDefOp.get(role.getLong("id")), FlowRuRoleStatusEnum.getFlowRuRoleStatusByCode(role.getString("rolestatus")).getText()};
                String errMessage = CUSTOM_TERMINOLOGY_DOMAIN_SERVICE.getCusTerminology(ResManager.loadKDString((String)"\u5236\u5b9a\u5bf9\u8c61{0}\uff08\u5de5\u53f7\uff1a{1}\uff09\uff1a\u5f53\u524d\u8282\u70b9\u4e0b\u89d2\u8272\u201c{2}\u201d\u7684\u72b6\u6001\u4e3a\u201c{3}\u201d\uff0c\u4e0d\u652f\u6301\u8c03\u6574\u5236\u5b9a\u4eba\u3002", (String)"FlowHandlerBatchDomainService_30", (String)"opmc-pbs-business", (Object[])args));
                if (HRStringUtils.equals((String)workFlowType, (String)"2")) {
                    errMessage = ResManager.loadKDString((String)"\u8bc4\u4f30\u5bf9\u8c61{0}\uff08\u5de5\u53f7\uff1a{1}\uff09\uff1a\u5f53\u524d\u8282\u70b9\u4e0b\u7684\u89d2\u8272\u201c{2}\u201d\u72b6\u6001\u4e3a{3}\uff0c\u4e0d\u652f\u6301\u4fee\u6539\u8bc4\u4f30\u4eba\u3002", (String)"FlowHandlerBatchDomainService_31", (String)"opmc-pbs-business", (Object[])args);
                }
                if (HRStringUtils.equals((String)workFlowType, (String)"3")) {
                    errMessage = ResManager.loadKDString((String)"\u9762\u8c08\u5bf9\u8c61{0}\uff08\u5de5\u53f7\uff1a{1}\uff09\uff1a\u5f53\u524d\u8282\u70b9\u4e0b\u7684\u89d2\u8272\u201c{2}\u201d\u72b6\u6001\u4e3a{3}\uff0c\u4e0d\u652f\u6301\u8c03\u6574\u5904\u7406\u4eba\u3002", (String)"FlowHandlerBatchDomainService_32", (String)"opmc-pbs-business", (Object[])args);
                }
                retVo.setId(dto.getId());
                retVo.setRoleId(dto.getRoleId());
                retVo.setSucess(Boolean.FALSE);
                retVo.setErrorMessage(errMessage);
                retVo.setTaskId(dto.getTaskId());
                errorInfos.add(retVo);
                delTaskDtos.add(dto);
                continue;
            }
            if (this.getNotModifyTaskStatus().contains(task.getString("taskstatus"))) {
                retVo = new AssignHandlerVO();
                String errMessage = "";
                if (HRStringUtils.equals((String)FlowRuTaskStatusEnum.REJECTED.getCode(), (String)task.getString("taskstatus"))) {
                    DynamicObject actEvaObj = roleActevalObjOp.get(dto.getActevaObj());
                    Object[] args3 = new Object[]{actEvaObj != null ? actEvaObj.getString("person.name") : "", actEvaObj != null ? actEvaObj.getString("person.number") : "", taskHandlerNames.get(task.getLong("handler.id")).get("name")};
                    errMessage = CUSTOM_TERMINOLOGY_DOMAIN_SERVICE.getCusTerminology(ResManager.loadKDString((String)"{0}\uff08\u5de5\u53f7\uff1a{1}\uff09\uff1a{2}\u4efb\u52a1\u72b6\u6001\u4e3a\u201c\u5df2\u62d2\u7edd\u201d\uff0c\u65e0\u6cd5\u8c03\u6574\u8bc4\u4f30\u4eba\u3002", (String)"FlowHandlerBatchDomainService_33", (String)"opmc-pbs-business", (Object[])args3));
                    if (HRStringUtils.equals((String)workFlowType, (String)"2")) {
                        errMessage = ResManager.loadKDString((String)"{0}\uff08\u5de5\u53f7\uff1a{1}\uff09\uff1a{2}\u4efb\u52a1\u72b6\u6001\u4e3a\u201c\u5df2\u62d2\u7edd\u201d\uff0c\u65e0\u6cd5\u8c03\u6574\u5236\u5b9a\u4eba\u3002", (String)"FlowHandlerBatchDomainService_34", (String)"opmc-pbs-business", (Object[])args3);
                    }
                    if (HRStringUtils.equals((String)workFlowType, (String)"3")) {
                        errMessage = ResManager.loadKDString((String)"{0}\uff08\u5de5\u53f7\uff1a{1}\uff09\uff1a{2}\u4efb\u52a1\u72b6\u6001\u4e3a\u201c\u5df2\u62d2\u7edd\u201d\uff0c\u65e0\u6cd5\u8c03\u6574\u5904\u7406\u4eba\u3002", (String)"FlowHandlerBatchDomainService_35", (String)"opmc-pbs-business", (Object[])args3);
                    }
                } else {
                    args = new Object[]{taskHandlerNames.get(task.getLong("handler.id")).get("name"), taskHandlerNames.get(task.getLong("handler.id")).get("number"), FlowRuTaskStatusEnum.getFlowRuTaskStatusByCode(task.getString("taskstatus")).getText()};
                    errMessage = CUSTOM_TERMINOLOGY_DOMAIN_SERVICE.getCusTerminology(ResManager.loadKDString((String)"\u5236\u5b9a\u4eba{0}\uff08\u5de5\u53f7\uff1a{1}\uff09\uff1a:\u5f53\u524d\u5236\u5b9a\u4efb\u52a1\u72b6\u6001\u4e3a\u201c{2}\u201d\uff0c\u4e0d\u652f\u6301\u8c03\u6574\u3002", (String)"FlowHandlerBatchDomainService_36", (String)"opmc-pbs-business", (Object[])args));
                    if (HRStringUtils.equals((String)workFlowType, (String)"2")) {
                        errMessage = ResManager.loadKDString((String)"\u8bc4\u4f30\u4eba{0}\uff08\u5de5\u53f7\uff1a{1}\uff09\uff1a\u5f53\u524d\u8bc4\u4f30\u4efb\u52a1\u72b6\u6001\u4e3a\u201c{2}\u201d\uff0c\u4e0d\u652f\u6301\u8c03\u6574\u8bc4\u4f30\u4eba\u3002", (String)"FlowHandlerBatchDomainService_37", (String)"opmc-pbs-business", (Object[])args);
                    }
                    if (HRStringUtils.equals((String)workFlowType, (String)"3")) {
                        errMessage = ResManager.loadKDString((String)"\u5904\u7406\u4eba{0}\uff08\u5de5\u53f7\uff1a{1}\uff09:\u5f53\u524d\u9762\u8c08\u4efb\u52a1\u72b6\u6001\u4e3a{2}\uff0c\u4e0d\u652f\u6301\u4fee\u6539\u5904\u7406\u4eba\u3002", (String)"FlowHandlerBatchDomainService_38", (String)"opmc-pbs-business", (Object[])args);
                    }
                }
                retVo.setId(dto.getId());
                retVo.setRoleId(dto.getRoleId());
                retVo.setHandlerId(task.getLong("handler.id"));
                retVo.setTaskId(dto.getTaskId());
                retVo.setSucess(Boolean.FALSE);
                retVo.setErrorMessage(errMessage);
                errorInfos.add(retVo);
                delTaskDtos.add(dto);
                continue;
            }
            List<DynamicObject> aTasks = roleIdAllTaskMap.get(role.getLong("id"));
            retHandlerTask.addAll(this.modifyHandlerExistTasks(aTasks, handlerIdSet, roleActevalObjOp, roleDefOp, dto, modifyHandlerDtos, role, handlerNames, errorInfos));
            Set hasTaskHandlers = aTasks.stream().map(e -> e.getLong("handler_id")).collect(Collectors.toSet());
            List<Long> noTaskHanders = handlerIdSet.stream().filter(e -> !hasTaskHandlers.contains(e)).collect(Collectors.toList());
            List<DynamicObject> tasks = FLOW_RU_TASK_ENTITY_SERVICE.generateTaskByRuRole(role, noTaskHanders, false);
            retHandlerTask.addAll(tasks);
        }
        if (!CollectionUtils.isEmpty(delTaskDtos)) {
            modifyHandlerDtos.removeAll(delTaskDtos);
        }
        return retHandlerTask;
    }

    private void checkCoTask(Object[] args, List<AssignHandlerVO> errorInfos, DynamicObject task, AssignHandlerParamDTO dto, List<AssignHandlerParamDTO> delTaskDtos) {
        AssignHandlerVO retVo = new AssignHandlerVO();
        String errMessage = CUSTOM_TERMINOLOGY_DOMAIN_SERVICE.getCusTerminology(ResManager.loadKDString((String)"\u8bc4\u4f30\u4eba-{0} \uff08\u5de5\u53f7\uff1a{1}\uff09\uff1a\u5f53\u524d\u8bc4\u4f30\u4efb\u52a1\u4e3a\u534f\u529e\u4efb\u52a1\uff0c\u8bf7\u4f7f\u7528\u201c\u8bbe\u7f6e\u534f\u529e\u4eba\u201d\u64cd\u4f5c\u3002", (String)"FlowHandlerBatchDomainService_17", (String)"opmc-pbs-business", (Object[])args));
        retVo.setId(dto.getId());
        retVo.setRoleId(dto.getRoleId());
        retVo.setHandlerId(task.getLong("handler_id"));
        retVo.setTaskId(dto.getTaskId());
        retVo.setSucess(Boolean.FALSE);
        retVo.setErrorMessage(errMessage);
        errorInfos.add(retVo);
        if (delTaskDtos != null) {
            delTaskDtos.add(dto);
        }
    }

    private List<DynamicObject> getAddHandlerTasks(Map<Long, AssignHandlerParamDTO> handlerParamDTOMap, DynamicObject[] roles, Map<Long, List<DynamicObject>> roleIdTaskMap, Map<Long, DynamicObject> roleActevalObjOp, Map<Long, String> roleDefOp, Map<Long, Map<String, String>> handlerNames, List<AssignHandlerVO> errorInfos) {
        ArrayList<DynamicObject> retHandlerTask = new ArrayList<DynamicObject>();
        for (DynamicObject role : roles) {
            AssignHandlerParamDTO dto = handlerParamDTOMap.get(role.getLong("id"));
            HashSet<Long> handlerIdSet = new HashSet<Long>(dto.getHandlerIds());
            if (!this.getCanRoleStatus().contains(role.getString("rolestatus"))) {
                AssignHandlerVO retVo = new AssignHandlerVO();
                DynamicObject actEvaObj = roleActevalObjOp.get(dto.getActevaObj());
                Object[] args = new Object[]{actEvaObj != null ? actEvaObj.getString("person_name") : "", actEvaObj != null ? actEvaObj.getString("person_number") : "", roleDefOp.get(role.getLong("id")), FlowRuRoleStatusEnum.getFlowRuRoleStatusByCode(role.getString("rolestatus")).getText()};
                String errMessage = CUSTOM_TERMINOLOGY_DOMAIN_SERVICE.getCusTerminology(ResManager.loadKDString((String)"\u5236\u5b9a\u5bf9\u8c61{0}\uff08\u5de5\u53f7\uff1a{1}\uff09\uff1a\u5f53\u524d\u8282\u70b9\u4e0b\u89d2\u8272\u201c{2}\u201d\u7684\u72b6\u6001\u4e3a\u201c{3}\u201d\uff0c\u4e0d\u652f\u6301\u6dfb\u52a0\u5236\u5b9a\u4eba\u3002", (String)"FlowHandlerBatchDomainService_39", (String)"opmc-pbs-business", (Object[])args));
                if (HRStringUtils.equals((String)dto.getWorkFlowType(), (String)"2")) {
                    errMessage = ResManager.loadKDString((String)"\u8bc4\u4f30\u5bf9\u8c61{0}\uff08\u5de5\u53f7\uff1a{1}\uff09\uff1a\u5f53\u524d\u8282\u70b9\u4e0b\u7684\u89d2\u8272\u201c{2}\u201d\u72b6\u6001\u4e3a{3}\uff0c\u4e0d\u652f\u6301\u6dfb\u52a0\u8bc4\u4f30\u4eba\u3002", (String)"FlowHandlerBatchDomainService_40", (String)"opmc-pbs-business", (Object[])args);
                }
                retVo.setRoleId(dto.getRoleId());
                retVo.setId(dto.getId());
                retVo.setSucess(Boolean.FALSE);
                retVo.setErrorMessage(errMessage);
                errorInfos.add(retVo);
                continue;
            }
            List<DynamicObject> aTasks = roleIdTaskMap.get(role.getLong("id"));
            if (CollectionUtils.isEmpty(aTasks)) {
                List<DynamicObject> tasks = FLOW_RU_TASK_ENTITY_SERVICE.generateTaskByRuRole(role, dto.getHandlerIds(), false);
                retHandlerTask.addAll(tasks);
                continue;
            }
            retHandlerTask.addAll(this.addHandlerExistTasks(aTasks, handlerIdSet, roleActevalObjOp, roleDefOp, dto, role, handlerNames, errorInfos));
            Set hasTaskHandlers = aTasks.stream().map(e -> e.getLong("handler_id")).collect(Collectors.toSet());
            List<Long> noTaskHanders = handlerIdSet.stream().filter(e -> !hasTaskHandlers.contains(e)).collect(Collectors.toList());
            List<DynamicObject> tasks = FLOW_RU_TASK_ENTITY_SERVICE.generateTaskByRuRole(role, noTaskHanders, false);
            retHandlerTask.addAll(tasks);
        }
        return retHandlerTask;
    }

    private List<CrossTaskHandleVo> getAddHandlerCrossTasks(Map<Long, List<AssignHandlerParamDTO>> roleDtoMap, Map<Long, List<DynamicObject>> roleIdTaskMap, Map<Long, List<DynamicObject>> indIdTasksMap, Map<Long, DynamicObject> roleIdMap, Map<Long, DynamicObject> roleActevalObjOp, Map<Long, String> roleDefOp, List<AssignHandlerVO> errorInfos) {
        ArrayList<CrossTaskHandleVo> retHandlerTask = new ArrayList<CrossTaskHandleVo>(10);
        for (Map.Entry<Long, List<AssignHandlerParamDTO>> entry : roleDtoMap.entrySet()) {
            DynamicObject currRole = null;
            List<DynamicObject> handleTasks = roleIdTaskMap.get(entry.getKey());
            HashMap<Long, Set<Long>> indTaskIdSetMap = new HashMap<Long, Set<Long>>(16);
            HashSet<Long> unionHandlerSet = new HashSet<Long>(16);
            for (AssignHandlerParamDTO dto : entry.getValue()) {
                DynamicObject task;
                currRole = roleIdMap.get(dto.getRoleId());
                if (null != dto.getTaskId() && null != (task = (DynamicObject)handleTasks.stream().filter(htask -> htask.getLong("id") == dto.getTaskId().longValue()).findFirst().orElse(null)) && task.getBoolean("iscotask")) {
                    Object[] args = this.getArgs(roleActevalObjOp, dto);
                    this.checkCoTask(args, errorInfos, task, dto, null);
                    continue;
                }
                if (!this.getCanRoleStatus().contains(currRole.getString("rolestatus"))) {
                    AssignHandlerVO retVo = new AssignHandlerVO();
                    DynamicObject actEvaObj = roleActevalObjOp.get(dto.getActevaObj());
                    Object[] args = new Object[]{actEvaObj != null ? actEvaObj.getString("person_name") : "", actEvaObj != null ? actEvaObj.getString("person_number") : "", roleDefOp.get(currRole.getLong("id")), FlowRuRoleStatusEnum.getFlowRuRoleStatusByCode(currRole.getString("rolestatus")).getText()};
                    String errMessage = CUSTOM_TERMINOLOGY_DOMAIN_SERVICE.getCusTerminology(ResManager.loadKDString((String)"\u5236\u5b9a\u5bf9\u8c61{0}\uff08\u5de5\u53f7\uff1a{1}\uff09\uff1a\u5f53\u524d\u8282\u70b9\u4e0b\u89d2\u8272\u201c{2}\u201d\u7684\u72b6\u6001\u4e3a\u201c{3}\u201d\uff0c\u4e0d\u652f\u6301\u6dfb\u52a0\u5236\u5b9a\u4eba\u3002", (String)"FlowHandlerBatchDomainService_39", (String)"opmc-pbs-business", (Object[])args));
                    if (HRStringUtils.equals((String)dto.getWorkFlowType(), (String)"2")) {
                        errMessage = ResManager.loadKDString((String)"\u8bc4\u4f30\u5bf9\u8c61{0}\uff08\u5de5\u53f7\uff1a{1}\uff09\uff1a\u5f53\u524d\u8282\u70b9\u4e0b\u7684\u89d2\u8272\u201c{2}\u201d\u72b6\u6001\u4e3a{3}\uff0c\u4e0d\u652f\u6301\u6dfb\u52a0\u8bc4\u4f30\u4eba\u3002", (String)"FlowHandlerBatchDomainService_40", (String)"opmc-pbs-business", (Object[])args);
                    }
                    retVo.setId(dto.getId());
                    retVo.setRoleId(dto.getRoleId());
                    retVo.setSucess(Boolean.FALSE);
                    retVo.setErrorMessage(errMessage);
                    retVo.setIndicatorId(dto.getIndicatorId());
                    errorInfos.add(retVo);
                    continue;
                }
                List<DynamicObject> indTasks = indIdTasksMap.get(dto.getIndicatorId());
                indTaskIdSetMap.put(dto.getIndicatorId(), indTasks.stream().map(e -> e.getLong("rutask_id")).collect(Collectors.toSet()));
                unionHandlerSet.addAll(dto.getHandlerIds());
            }
            retHandlerTask.addAll(this.addHandlerCrossExistTasks(handleTasks, entry.getValue(), currRole, indTaskIdSetMap, errorInfos));
            Set hasTaskHandlers = handleTasks.stream().map(e -> e.getLong("handler_id")).collect(Collectors.toSet());
            List<Long> noTaskHanders = unionHandlerSet.stream().filter(e -> !hasTaskHandlers.contains(e)).collect(Collectors.toList());
            List<DynamicObject> newTasks = FLOW_RU_TASK_ENTITY_SERVICE.generateCrossTaskByRuRole(currRole, noTaskHanders, false);
            retHandlerTask.addAll(this.assembleNewCrossTaskHandleVos(entry.getValue(), newTasks));
        }
        return retHandlerTask;
    }

    private List<CrossTaskHandleVo> assembleNewCrossTaskHandleVos(List<AssignHandlerParamDTO> dtos, List<DynamicObject> newTasks) {
        ArrayList<CrossTaskHandleVo> retHandleCrossTaskHandleVos = new ArrayList<CrossTaskHandleVo>();
        newTasks.stream().forEach(task -> {
            HashSet<Long> taskNeedAddIndSet = new HashSet<Long>(16);
            dtos.stream().forEach(dto -> {
                if (dto.getHandlerIds().contains(task.getLong("handler"))) {
                    taskNeedAddIndSet.add(dto.getIndicatorId());
                }
            });
            retHandleCrossTaskHandleVos.add(CrossTaskHandleVo.newInstance(task, taskNeedAddIndSet, ((AssignHandlerParamDTO)dtos.get(0)).getActevaObj()));
        });
        return retHandleCrossTaskHandleVos;
    }

    private List<CrossTaskHandleVo> getModifyHandlerCrossTasks(List<AssignHandlerParamDTO> dtos, Map<Long, List<AssignHandlerParamDTO>> taskDtoMap, Map<Long, List<DynamicObject>> roleIdTaskMap, Map<Long, DynamicObject> taskIdMap, Map<Long, List<DynamicObject>> indIdTasksMap, Map<Long, DynamicObject> roleIdMap, Map<Long, DynamicObject> roleActevalObjOp, Map<Long, String> roleDefOp, List<AssignHandlerVO> errorInfos) {
        ArrayList<CrossTaskHandleVo> retHandlerTask = new ArrayList<CrossTaskHandleVo>(10);
        for (Map.Entry<Long, List<AssignHandlerParamDTO>> entry : taskDtoMap.entrySet()) {
            DynamicObject currRole = roleIdMap.get(taskIdMap.get(entry.getKey()).getLong("flowrurole.id"));
            HashMap<Long, Set<Long>> indTaskIdSetMap = new HashMap<Long, Set<Long>>(16);
            HashSet<Long> unionHandlerSet = new HashSet<Long>(16);
            ArrayList<AssignHandlerParamDTO> delTaskDtos = new ArrayList<AssignHandlerParamDTO>();
            for (AssignHandlerParamDTO dto : entry.getValue()) {
                DynamicObject task = taskIdMap.get(dto.getTaskId());
                if (!HRObjectUtils.isEmpty((Object)task) && task.getBoolean("iscotask")) {
                    Object[] args = this.getArgs(roleActevalObjOp, dto);
                    this.checkCoTask(args, errorInfos, task, dto, null);
                    continue;
                }
                if (!this.getCanRoleStatus().contains(currRole.getString("rolestatus"))) {
                    AssignHandlerVO retVo = new AssignHandlerVO();
                    DynamicObject actEvaObj = roleActevalObjOp.get(dto.getActevaObj());
                    Object[] args = new Object[]{actEvaObj != null ? actEvaObj.getString("person_name") : "", actEvaObj != null ? actEvaObj.getString("person_number") : "", roleDefOp.get(currRole.getLong("id")), FlowRuRoleStatusEnum.getFlowRuRoleStatusByCode(currRole.getString("rolestatus")).getText()};
                    String errMessage = CUSTOM_TERMINOLOGY_DOMAIN_SERVICE.getCusTerminology(ResManager.loadKDString((String)"\u5236\u5b9a\u5bf9\u8c61{0}\uff08\u5de5\u53f7\uff1a{1}\uff09\uff1a\u5f53\u524d\u8282\u70b9\u4e0b\u89d2\u8272\u201c{2}\u201d\u7684\u72b6\u6001\u4e3a\u201c{3}\u201d\uff0c\u4e0d\u652f\u6301\u8c03\u6574\u5236\u5b9a\u4eba\u3002", (String)"FlowHandlerBatchDomainService_30", (String)"opmc-pbs-business", (Object[])args));
                    if (HRStringUtils.equals((String)dto.getWorkFlowType(), (String)"2")) {
                        errMessage = ResManager.loadKDString((String)"\u8bc4\u4f30\u5bf9\u8c61{0}\uff08\u5de5\u53f7\uff1a{1}\uff09\uff1a\u5f53\u524d\u8282\u70b9\u4e0b\u7684\u89d2\u8272\u201c{2}\u201d\u72b6\u6001\u4e3a{3}\uff0c\u4e0d\u652f\u6301\u4fee\u6539\u8bc4\u4f30\u4eba\u3002", (String)"FlowHandlerBatchDomainService_31", (String)"opmc-pbs-business", (Object[])args);
                    }
                    retVo.setId(dto.getId());
                    retVo.setRoleId(dto.getRoleId());
                    retVo.setSucess(Boolean.FALSE);
                    retVo.setErrorMessage(errMessage);
                    retVo.setIndicatorId(dto.getIndicatorId());
                    errorInfos.add(retVo);
                    delTaskDtos.add(dto);
                    continue;
                }
                List<DynamicObject> indTasks = indIdTasksMap.get(dto.getIndicatorId());
                indTaskIdSetMap.put(dto.getIndicatorId(), indTasks.stream().map(e -> e.getLong("rutask_id")).collect(Collectors.toSet()));
                unionHandlerSet.addAll(dto.getHandlerIds());
            }
            if (!CollectionUtils.isEmpty(delTaskDtos)) {
                dtos.removeAll(delTaskDtos);
            }
            List<DynamicObject> handleTasks = roleIdTaskMap.get(currRole.getLong("id"));
            retHandlerTask.addAll(this.modifyHandlerCrossExistTasks(handleTasks, entry.getValue(), indTaskIdSetMap, currRole, dtos, errorInfos));
            Set hasTaskHandlers = handleTasks.stream().map(e -> e.getLong("handler_id")).collect(Collectors.toSet());
            List<Long> noTaskHanders = unionHandlerSet.stream().filter(e -> !hasTaskHandlers.contains(e)).collect(Collectors.toList());
            List<DynamicObject> newTasks = FLOW_RU_TASK_ENTITY_SERVICE.generateCrossTaskByRuRole(currRole, noTaskHanders, false);
            retHandlerTask.addAll(this.assembleNewCrossTaskHandleVos(entry.getValue(), newTasks));
        }
        return retHandlerTask;
    }

    private Object[] getArgs(Map<Long, DynamicObject> roleActevalObjOp, AssignHandlerParamDTO dto) {
        DynamicObject actEvaObj = roleActevalObjOp.get(dto.getActevaObj());
        return new Object[]{actEvaObj != null ? actEvaObj.getString("person.name") : "", actEvaObj != null ? actEvaObj.getString("person.number") : ""};
    }

    private List<DynamicObject> modifyHandlerExistTasks(List<DynamicObject> tasks, Set<Long> handlerIdSet, Map<Long, DynamicObject> roleActevalObjOp, Map<Long, String> roleDefOp, AssignHandlerParamDTO dto, List<AssignHandlerParamDTO> modifyHandlerDtos, DynamicObject currRole, Map<Long, Map<String, String>> handlerNames, List<AssignHandlerVO> errorInfos) {
        ArrayList delDtos = new ArrayList();
        List<DynamicObject> retHandlerTask = tasks.stream().map(task -> {
            if (handlerIdSet.contains(task.getLong("handler_id")) && (HRStringUtils.equals((String)task.getString("taskstatus"), (String)FlowRuTaskStatusEnum.EXPIRED.getCode()) || HRStringUtils.equals((String)task.getString("taskstatus"), (String)FlowRuTaskStatusEnum.PENDING.getCode()))) {
                if (dto.getTaskId().longValue() == task.getLong("id")) {
                    delDtos.add(dto);
                }
                return task;
            }
            if (handlerIdSet.contains(task.getLong("handler_id")) && this.getValidTaskStatus().contains(task.getString("taskstatus"))) {
                AssignHandlerVO retVo = new AssignHandlerVO();
                DynamicObject actEvaObj = (DynamicObject)roleActevalObjOp.get(dto.getActevaObj());
                Object[] args = new Object[]{actEvaObj != null ? actEvaObj.getString("person.name") : "", actEvaObj != null ? actEvaObj.getString("person.number") : "", ((Map)handlerNames.get(task.getLong("handler_id"))).get("name"), roleDefOp.get(currRole.getLong("id"))};
                String errMessage = CUSTOM_TERMINOLOGY_DOMAIN_SERVICE.getCusTerminology(ResManager.loadKDString((String)"\u5236\u5b9a\u5bf9\u8c61{0}\uff08\u5de5\u53f7\uff1a{1}\uff09\uff1a\u5236\u5b9a\u4eba\u201c{2}\u201d\u5df2\u662f\u89d2\u8272\u201c{3}\u201d\u7684\u5904\u7406\u4eba\uff0c\u4e0d\u652f\u6301\u91cd\u590d\u8bbe\u7f6e\u3002", (String)"FlowHandlerBatchDomainService_41", (String)"opmc-pbs-business", (Object[])args));
                if (HRStringUtils.equals((String)dto.getWorkFlowType(), (String)"2")) {
                    errMessage = ResManager.loadKDString((String)"\u8bc4\u4f30\u5bf9\u8c61{0}\uff08\u5de5\u53f7\uff1a{1}\uff09\uff1a\u201c{2}\u201d\u5df2\u662f\u89d2\u8272\u201c{3}\u201d\u7684\u8bc4\u4f30\u4eba\uff0c\u4e0d\u652f\u6301\u91cd\u590d\u8bbe\u7f6e\u3002", (String)"FlowHandlerBatchDomainService_42", (String)"opmc-pbs-business", (Object[])args);
                }
                if (HRStringUtils.equals((String)dto.getWorkFlowType(), (String)"3")) {
                    errMessage = ResManager.loadKDString((String)"\u9762\u8c08\u5bf9\u8c61{0}\uff08\u5de5\u53f7\uff1a{1}\uff09\uff1a\u201c{2}\u201d\u5df2\u662f\u89d2\u8272\u201c{3}\u201d\u7684\u5904\u7406\u4eba\uff0c\u4e0d\u652f\u6301\u91cd\u590d\u8bbe\u7f6e\u3002", (String)"FlowHandlerBatchDomainService_43", (String)"opmc-pbs-business", (Object[])args);
                }
                retVo.setRoleId(dto.getRoleId());
                retVo.setHandlerId(task.getLong("handler_id"));
                retVo.setTaskId(dto.getTaskId());
                retVo.setSucess(Boolean.FALSE);
                retVo.setErrorMessage(errMessage);
                errorInfos.add(retVo);
                delDtos.add(dto);
                return null;
            }
            if (dto.getTaskId().longValue() == task.getLong("id") && HRStringUtils.equals((String)task.getString("taskstatus"), (String)FlowRuTaskStatusEnum.PENDING.getCode())) {
                return task;
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        if (delDtos.size() > 0) {
            modifyHandlerDtos.removeAll(delDtos);
        }
        return retHandlerTask;
    }

    private List<CrossTaskHandleVo> modifyHandlerCrossExistTasks(List<DynamicObject> tasks, List<AssignHandlerParamDTO> taskDtos, Map<Long, Set<Long>> indTaskIdSetMap, DynamicObject currRole, List<AssignHandlerParamDTO> modifyHandlerDtos, List<AssignHandlerVO> errorInfos) {
        ArrayList<CrossTaskHandleVo> retHandleTasks = new ArrayList<CrossTaskHandleVo>(10);
        Map handlerTaskMap = tasks.stream().collect(Collectors.groupingBy(k -> k.getLong("handler_id"), Collectors.toList()));
        Set hasTaskHandlers = tasks.stream().map(e -> e.getLong("handler_id")).collect(Collectors.toSet());
        List validTasks = tasks.stream().filter(e -> !HRStringUtils.equals((String)FlowRuTaskStatusEnum.EXPIRED.getCode(), (String)e.getString("taskstatus"))).collect(Collectors.toList());
        Set validTaskHandlerSet = validTasks.stream().map(v -> v.getLong("handler_id")).collect(Collectors.toSet());
        HashSet needAddTaskHandlerSet = new HashSet(16);
        HashSet taskNeedAddIndSet = new HashSet(16);
        for (AssignHandlerParamDTO dto : taskDtos) {
            HashSet<Long> handlerIdSet = new HashSet<Long>(dto.getHandlerIds());
            Set<Long> indTaskIdSet = indTaskIdSetMap.get(dto.getIndicatorId());
            ArrayList delTaskDtos = new ArrayList();
            handlerIdSet.stream().forEach(handler -> {
                if (hasTaskHandlers.contains(handler)) {
                    List hasTasks = (List)handlerTaskMap.get(handler);
                    hasTasks.stream().forEach(hasTask -> {
                        if (indTaskIdSet.contains(hasTask.getLong("id"))) {
                            if (this.getValidTaskStatus().contains(hasTask.getString("taskstatus"))) {
                                if (dto.getTaskId().longValue() != hasTask.getLong("id")) {
                                    AssignHandlerVO retVo = new AssignHandlerVO();
                                    retVo.setId(dto.getId());
                                    retVo.setRoleId(dto.getRoleId());
                                    retVo.setHandlerId(hasTask.getLong("handler_id"));
                                    retVo.setTaskId(hasTask.getLong("id"));
                                    retVo.setIndicatorId(dto.getIndicatorId());
                                    retVo.setSucess(Boolean.TRUE);
                                    retVo.setErrorMessage("");
                                    errorInfos.add(retVo);
                                } else {
                                    AssignHandlerVO retVo = new AssignHandlerVO();
                                    retVo.setId(dto.getId());
                                    retVo.setIndicatorId(dto.getIndicatorId());
                                    retVo.setErrorMessage("");
                                    retVo.setTaskId(dto.getTaskId());
                                    retVo.setSucess(Boolean.TRUE);
                                    retVo.setRoleId(dto.getRoleId());
                                    errorInfos.add(retVo);
                                    delTaskDtos.add(dto);
                                }
                            } else if (HRStringUtils.equals((String)FlowRuTaskStatusEnum.PENDING.getCode(), (String)hasTask.getString("taskstatus"))) {
                                retHandleTasks.add(CrossTaskHandleVo.newInstance(hasTask, new HashSet<Long>(Collections.singleton(dto.getIndicatorId())), ((AssignHandlerParamDTO)taskDtos.get(0)).getActevaObj()));
                                if (dto.getTaskId().longValue() == hasTask.getLong("id")) {
                                    AssignHandlerVO retVo = new AssignHandlerVO();
                                    retVo.setId(dto.getId());
                                    retVo.setIndicatorId(dto.getIndicatorId());
                                    retVo.setErrorMessage("");
                                    retVo.setTaskId(dto.getTaskId());
                                    retVo.setSucess(Boolean.TRUE);
                                    retVo.setRoleId(dto.getRoleId());
                                    errorInfos.add(retVo);
                                    delTaskDtos.add(dto);
                                }
                            }
                        } else {
                            boolean hasValidTaskIndFlag = Boolean.FALSE;
                            for (DynamicObject task : hasTasks) {
                                if (!indTaskIdSet.contains(task.getLong("id"))) continue;
                                hasValidTaskIndFlag = Boolean.TRUE;
                            }
                            if (!validTaskHandlerSet.contains(hasTask.getLong("handler_id")) || !hasValidTaskIndFlag) {
                                needAddTaskHandlerSet.add(hasTask.getLong("handler_id"));
                                taskNeedAddIndSet.add(dto.getIndicatorId());
                            }
                        }
                    });
                }
            });
            if (CollectionUtils.isEmpty(delTaskDtos)) continue;
            modifyHandlerDtos.removeAll(delTaskDtos);
        }
        needAddTaskHandlerSet.stream().forEach(handler -> {
            DynamicObject newTask = FLOW_RU_TASK_ENTITY_SERVICE.generateCrossTaskByRuRole(currRole, Collections.singletonList(handler), false).get(0);
            retHandleTasks.add(CrossTaskHandleVo.newInstance(newTask, taskNeedAddIndSet, ((AssignHandlerParamDTO)taskDtos.get(0)).getActevaObj()));
        });
        return retHandleTasks;
    }

    private List<CrossTaskHandleVo> addHandlerCrossExistTasks(List<DynamicObject> tasks, List<AssignHandlerParamDTO> roleDtos, DynamicObject currRole, Map<Long, Set<Long>> indTaskIdSetMap, List<AssignHandlerVO> errorInfos) {
        ArrayList<CrossTaskHandleVo> retHandleTasks = new ArrayList<CrossTaskHandleVo>(10);
        Map handlerTaskMap = tasks.stream().collect(Collectors.groupingBy(k -> k.getLong("handler_id"), Collectors.toList()));
        Set hasTaskHandlers = tasks.stream().map(e -> e.getLong("handler_id")).collect(Collectors.toSet());
        List validTasks = tasks.stream().filter(e -> !HRStringUtils.equals((String)FlowRuTaskStatusEnum.EXPIRED.getCode(), (String)e.getString("taskstatus"))).collect(Collectors.toList());
        Set validTaskHandlerSet = validTasks.stream().map(v -> v.getLong("handler_id")).collect(Collectors.toSet());
        Set validTaskIdSet = validTasks.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
        HashSet needAddTaskHandlerSet = new HashSet(16);
        for (AssignHandlerParamDTO dto : roleDtos) {
            HashSet<Long> handlerIdSet = new HashSet<Long>(dto.getHandlerIds());
            Set<Long> indTaskIdSet = indTaskIdSetMap.get(dto.getIndicatorId());
            handlerIdSet.stream().forEach(handler -> {
                if (hasTaskHandlers.contains(handler)) {
                    List hasTasks = (List)handlerTaskMap.get(handler);
                    hasTasks.stream().forEach(hasTask -> {
                        if (indTaskIdSet.contains(hasTask.getLong("id"))) {
                            if (this.getValidTaskStatus().contains(hasTask.getString("taskstatus"))) {
                                AssignHandlerVO retVo = new AssignHandlerVO();
                                retVo.setId(dto.getId());
                                retVo.setRoleId(dto.getRoleId());
                                retVo.setHandlerId(hasTask.getLong("handler_id"));
                                retVo.setTaskId(hasTask.getLong("id"));
                                retVo.setIndicatorId(dto.getIndicatorId());
                                retVo.setSucess(Boolean.TRUE);
                                retVo.setErrorMessage("");
                                errorInfos.add(retVo);
                            } else if (HRStringUtils.equals((String)FlowRuTaskStatusEnum.PENDING.getCode(), (String)hasTask.getString("taskstatus"))) {
                                retHandleTasks.add(CrossTaskHandleVo.newInstance(hasTask, new HashSet<Long>(Collections.singleton(dto.getIndicatorId())), ((AssignHandlerParamDTO)roleDtos.get(0)).getActevaObj()));
                            }
                        } else {
                            boolean hasValidTaskIndFlag = Boolean.FALSE;
                            for (DynamicObject task : hasTasks) {
                                if (!indTaskIdSet.contains(task.getLong("id"))) continue;
                                hasValidTaskIndFlag = Boolean.TRUE;
                            }
                            if (!validTaskHandlerSet.contains(hasTask.getLong("handler_id")) || !hasValidTaskIndFlag) {
                                needAddTaskHandlerSet.add(hasTask.getLong("handler_id"));
                            }
                        }
                    });
                }
            });
        }
        needAddTaskHandlerSet.stream().forEach(handler -> {
            DynamicObject newTask = FLOW_RU_TASK_ENTITY_SERVICE.generateCrossTaskByRuRole(currRole, Collections.singletonList(handler), false).get(0);
            HashSet<Long> taskNeedAddIndSet = new HashSet<Long>(16);
            roleDtos.stream().forEach(dto -> {
                Set indTaskIdSet = (Set)indTaskIdSetMap.get(dto.getIndicatorId());
                if (hasTaskHandlers.contains(handler)) {
                    List hasTasks = (List)handlerTaskMap.get(handler);
                    boolean hasValidTaskIndFlag = Boolean.FALSE;
                    for (DynamicObject task : hasTasks) {
                        if (!indTaskIdSet.contains(task.getLong("id"))) continue;
                        hasValidTaskIndFlag = Boolean.TRUE;
                    }
                    if (dto.getHandlerIds().contains(newTask.getLong("handler")) && !hasValidTaskIndFlag) {
                        taskNeedAddIndSet.add(dto.getIndicatorId());
                    }
                }
            });
            retHandleTasks.add(CrossTaskHandleVo.newInstance(newTask, taskNeedAddIndSet, ((AssignHandlerParamDTO)roleDtos.get(0)).getActevaObj()));
        });
        return retHandleTasks;
    }

    private List<DynamicObject> addHandlerExistTasks(List<DynamicObject> tasks, Set<Long> handlerIdSet, Map<Long, DynamicObject> roleActevalObjOp, Map<Long, String> roleDefOp, AssignHandlerParamDTO dto, DynamicObject currRole, Map<Long, Map<String, String>> handlerNames, List<AssignHandlerVO> errorInfos) {
        List<DynamicObject> retHandlerTask = tasks.stream().map(task -> {
            if (handlerIdSet.contains(task.getLong("handler_id")) && (HRStringUtils.equals((String)task.getString("taskstatus"), (String)FlowRuTaskStatusEnum.EXPIRED.getCode()) || HRStringUtils.equals((String)task.getString("taskstatus"), (String)FlowRuTaskStatusEnum.PENDING.getCode()))) {
                return task;
            }
            if (handlerIdSet.contains(task.getLong("handler_id")) && this.getValidTaskStatus().contains(task.getString("taskstatus"))) {
                AssignHandlerVO retVo = new AssignHandlerVO();
                DynamicObject actEvaObj = (DynamicObject)roleActevalObjOp.get(dto.getActevaObj());
                Object[] args = new Object[]{actEvaObj != null ? actEvaObj.getString("person.name") : "", actEvaObj != null ? actEvaObj.getString("person.number") : "", ((Map)handlerNames.get(task.getLong("handler_id"))).get("name"), roleDefOp.get(currRole.getLong("id"))};
                String errMessage = CUSTOM_TERMINOLOGY_DOMAIN_SERVICE.getCusTerminology(ResManager.loadKDString((String)"\u5236\u5b9a\u5bf9\u8c61{0}\uff08\u5de5\u53f7\uff1a{1}\uff09\uff1a\u5236\u5b9a\u4eba\u201c{2}\u201d\u5df2\u662f\u89d2\u8272\u201c{3}\u201d\u7684\u5904\u7406\u4eba\uff0c\u4e0d\u652f\u6301\u91cd\u590d\u8bbe\u7f6e\u3002", (String)"FlowHandlerBatchDomainService_41", (String)"opmc-pbs-business", (Object[])args));
                if (HRStringUtils.equals((String)dto.getWorkFlowType(), (String)"2")) {
                    errMessage = ResManager.loadKDString((String)"\u8bc4\u4f30\u5bf9\u8c61{0}\uff08\u5de5\u53f7\uff1a{1}\uff09\uff1a\u201c{2}\u201d\u5df2\u662f\u89d2\u8272\u201c{3}\u201d\u7684\u8bc4\u4f30\u4eba\uff0c\u4e0d\u652f\u6301\u91cd\u590d\u8bbe\u7f6e\u3002", (String)"FlowHandlerBatchDomainService_42", (String)"opmc-pbs-business", (Object[])args);
                }
                retVo.setId(dto.getId());
                retVo.setRoleId(currRole.getLong("id"));
                retVo.setHandlerId(task.getLong("handler_id"));
                retVo.setTaskId(task.getLong("id"));
                retVo.setSucess(Boolean.FALSE);
                retVo.setErrorMessage(errMessage);
                errorInfos.add(retVo);
                return null;
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        return retHandlerTask;
    }

    public void sendMessageAfterHandler(List<DynamicObject> handlerTask, List<DynamicObject> handleProcs) {
        List wattingTasks = handlerTask.stream().filter(task -> HRStringUtils.equals((String)task.getString("taskstatus"), (String)FlowRuTaskStatusEnum.WAITING.getCode())).collect(Collectors.toList());
        List<Long> wantToSendMessageTasks = wattingTasks.stream().map(e -> e.getLong("id")).collect(Collectors.toList());
        Set workflowtype = handleProcs.stream().map(e -> e.getString("workflowtype")).collect(Collectors.toSet());
        FlowMsgMergeEnumBO flowMsgMergeEnumBO = flowMsgEnumBoMap.get("1");
        if (!workflowtype.isEmpty()) {
            switch ((String)workflowtype.iterator().next()) {
                case "1": {
                    flowMsgMergeEnumBO = flowMsgEnumBoMap.get("1");
                    break;
                }
                case "2": {
                    flowMsgMergeEnumBO = flowMsgEnumBoMap.get("2");
                    break;
                }
                case "3": {
                    flowMsgMergeEnumBO = flowMsgEnumBoMap.get("3");
                }
            }
        }
        SendMessageDTO sendMessageDTO = new SendMessageDTO(wantToSendMessageTasks, flowMsgMergeEnumBO);
        sendMessageDTO.setCotaskSendMsg(Boolean.TRUE);
        this.sendMessageMerge(Collections.singletonList(sendMessageDTO));
    }

    public Map<Long, Boolean> sendMessageMerge(List<SendMessageDTO> dtos) {
        HRPluginProxy proxy = new HRPluginProxy((Object)I_WORK_FLOW_OUT_SERVICE, IWorkFlowOutService.class, "kd.opmc.pbs.business.domain.workflow.outService.IWorkFlowOutService#sendMessageMerge", (PluginFilter)null);
        List results = proxy.callReplaceIfPresent(p -> p.sendMessageMerge(dtos));
        return CollectionUtils.isEmpty((Collection)results) ? null : (Map)results.get(0);
    }

    public Map<Long, Boolean> sendMessageMergeLogic(List<SendMessageDTO> dtos) {
        HashMap<Long, Boolean> ret = new HashMap<Long, Boolean>();
        dtos.stream().forEach(dto -> {
            ArrayList<Map<Long, List<DynamicObject>>> handlerBatchTasksList = new ArrayList<Map<Long, List<DynamicObject>>>();
            DynamicObject[] tasks = null;
            FlowMsgMergeEnumBO msgEnumBO = dto.getMsgEnumBO();
            tasks = dto.getHandleType() == 0 ? FLOW_RU_TASK_ENTITY_SERVICE.queryTasksByBatchNo(dto.getBatchNo()) : FLOW_RU_TASK_ENTITY_SERVICE.queryMergerMsgTasksByIds(dto.getTasks());
            Set workflowType = Arrays.stream(tasks).map(task -> task.getString("flowruproc.workflowtype")).collect(Collectors.toSet());
            List<DynamicObject> taskList = Arrays.stream(tasks).collect(Collectors.toList());
            taskList.removeAll(this.pendingInvalidUsers(taskList));
            if (!CollectionUtils.isEmpty(taskList)) {
                dto.setTasks(taskList.stream().map(e -> e.getLong("id")).collect(Collectors.toList()));
                if (workflowType.contains("3")) {
                    this.sendInterviewMessageLogic(taskList, msgEnumBO, (SendMessageDTO)dto, (Map<Long, Boolean>)ret);
                } else {
                    this.sendFormulateEvalMessageLogic(taskList, tasks, (List<Map<Long, List<DynamicObject>>>)handlerBatchTasksList, msgEnumBO, (SendMessageDTO)dto, (Map<Long, Boolean>)ret);
                }
            }
        });
        return ret;
    }

    private void sendFormulateEvalMessageLogic(List<DynamicObject> taskList, DynamicObject[] tasks, List<Map<Long, List<DynamicObject>>> handlerBatchTasksList, FlowMsgMergeEnumBO msgEnumBO, SendMessageDTO dto, Map<Long, Boolean> ret) {
        Map<Long, String> actevalObjPerffileNames = EPA_ACTEVAOBJ_SERVICE.queryActEvalObjPerffileNamesByObjIds(taskList.stream().map(e -> e.getLong("flowruproc.actevalobj")).distinct().collect(Collectors.toList()));
        Map<Long, DynamicObject> nodeIdNodeMap = this.getHandlerMergeTasks(tasks, handlerBatchTasksList);
        int sum = 0;
        for (Map<Long, List<DynamicObject>> handlerBatchTasks : handlerBatchTasksList) {
            for (Map.Entry entry : handlerBatchTasks.entrySet()) {
                ++sum;
            }
        }
        long[] newBatchIds = ORM.create().genLongIds("pbs_batchtaskmap", sum);
        int batchIdIndex = 0;
        for (Map map : handlerBatchTasksList) {
            for (Map.Entry aHandlerEntry : map.entrySet()) {
                List<Long> aTaskIds = ((List)aHandlerEntry.getValue()).stream().map(e -> e.getLong("id")).collect(Collectors.toList());
                long newBatchId = newBatchIds[batchIdIndex++];
                FLOW_RUSECOND_DOMAIN_SERVICE.saveBatchTaskDetails(newBatchId, aTaskIds);
                Collections.sort((List)aHandlerEntry.getValue(), new SortByCreatetime());
                long actevalobjId = ((DynamicObject)((List)aHandlerEntry.getValue()).get(0)).getLong("flowruproc.actevalobj");
                ArrayList<Long> actevalobjIds = new ArrayList<Long>();
                actevalobjIds.add(actevalobjId);
                DynamicObject[] proc = FLOW_RU_PROC_ENTITY_SERVICE.queryProcByEvaObjIds(actevalobjIds);
                DynamicObject actEvaObj = (DynamicObject)HRMServiceHelper.invokeBizService((String)"opmc", (String)"epa", (String)"IEPAActevalobjService", (String)"getActevalobjById", (Object[])new Object[]{actevalobjId});
                long procCount = ((List)aHandlerEntry.getValue()).stream().map(e -> e.getLong("flowruproc.actevalobj")).distinct().count();
                FlowRuMsgMergeEnum msgEnum = procCount > 1L ? msgEnumBO.getMultiple() : msgEnumBO.getSingle();
                HashMap urlParams = Maps.newHashMapWithExpectedSize((int)3);
                urlParams.put("formId", this.getMessageFormId(msgEnum, (List)aHandlerEntry.getValue(), FLOW_RU_NODE_ENTITY_SERVICE.queryDefNodeByTaskId(((DynamicObject)((List)aHandlerEntry.getValue()).get(0)).getLong("id"))));
                urlParams.put("batchTaskId", String.valueOf(newBatchId));
                urlParams.put("mask", String.valueOf(actevalobjId));
                List<Long> userIds = Collections.singletonList(aHandlerEntry.getKey());
                Map<Long, Boolean> userEnableMap = this.batchQueryUserIsEnable(userIds);
                if (userEnableMap.get(aHandlerEntry.getKey()) == null || !userEnableMap.get(aHandlerEntry.getKey()).booleanValue()) continue;
                try {
                    if (rollBackCopyMsgs.contains((Object)msgEnum)) {
                        urlParams.put("actevalobj", actevalObjPerffileNames.get(actevalobjId));
                        urlParams.put("reason", dto.getReason());
                        urlParams.put("modifyer", UserServiceHelper.getCurrentUser((String)"name").getString("name"));
                        ROLLBACK_MSG_SEND_SERVICE.sendMessageWithUrl(msgEnum.getTemplateId(), userIds, proc[0], urlParams, msgEnum.getTag());
                    } else {
                        urlParams.put("actevalobj", actevalObjPerffileNames.get(actevalobjId));
                        MERGE_MSG_SEND_SERVICE.sendMessageWithUrl(msgEnum.getTemplateId(), userIds, actEvaObj, urlParams, msgEnum.getTag());
                    }
                    aTaskIds.forEach(e -> ret.put((Long)e, true));
                }
                catch (Exception exp) {
                    LOG.error(exp.getMessage(), (Throwable)exp);
                    aTaskIds.forEach(e -> ret.put((Long)e, false));
                }
            }
        }
    }

    public void sendInterviewMessageLogic(List<DynamicObject> taskList, FlowMsgMergeEnumBO msgEnumBO, SendMessageDTO dto, Map<Long, Boolean> ret) {
        List<Long> aTaskIds = taskList.stream().map(v -> v.getLong("id")).collect(Collectors.toList());
        Map<Long, Map<String, String>> interviewObjPerffileNames = EPA_ACTEVAOBJ_SERVICE.queryInterViewObjPerffilePersonInfo(taskList.stream().map(e -> e.getLong("flowruproc.actevalobj")).distinct().collect(Collectors.toList()));
        for (DynamicObject task : taskList) {
            long interobjId = task.getLong("flowruproc.actevalobj");
            ArrayList<Long> interobjIds = new ArrayList<Long>();
            interobjIds.add(interobjId);
            DynamicObject[] proc = FLOW_RU_PROC_ENTITY_SERVICE.queryProcByEvaObjIds(interobjIds);
            DynamicObject interObj = (DynamicObject)HRMServiceHelper.invokeBizService((String)"opmc", (String)"epa", (String)"IEPAActevalobjService", (String)"getInterViewobjById", (Object[])new Object[]{interobjId});
            FlowRuMsgMergeEnum msgEnum = msgEnumBO.getSingle();
            HashMap urlParams = Maps.newHashMapWithExpectedSize((int)3);
            urlParams.put("formId", "epa_intertaskprocess");
            urlParams.put("taskId", String.valueOf(task.getLong("id")));
            urlParams.put("pkId", String.valueOf(interobjId));
            List<Long> userIds = Collections.singletonList(task.getLong("handler.id"));
            Map<Long, Boolean> userEnableMap = this.batchQueryUserIsEnable(userIds);
            if (userEnableMap.get(task.getLong("handler.id")) == null || !userEnableMap.get(task.getLong("handler.id")).booleanValue()) continue;
            try {
                Map<String, String> interObjInfo = interviewObjPerffileNames.get(interobjId);
                if (rollBackCopyMsgs.contains((Object)msgEnum)) {
                    urlParams.put("actevalobj", interObjInfo != null ? interObjInfo.get("name") : "");
                    urlParams.put("billno", interObjInfo != null ? interObjInfo.get("billno") : "");
                    urlParams.put("reason", dto.getReason());
                    urlParams.put("modifyer", UserServiceHelper.getCurrentUser((String)"name").getString("name"));
                    ROLLBACK_MSG_SEND_SERVICE.sendMessageWithUrl(msgEnum.getTemplateId(), userIds, proc[0], urlParams, msgEnum.getTag());
                } else {
                    urlParams.put("actevalobj", interObjInfo != null ? interObjInfo.get("name") : "");
                    MERGE_MSG_SEND_SERVICE.sendMessageWithUrl(msgEnum.getTemplateId(), userIds, interObj, urlParams, msgEnum.getTag());
                }
                aTaskIds.forEach(e -> ret.put((Long)e, true));
            }
            catch (Exception exp) {
                LOG.error(exp.getMessage(), (Throwable)exp);
                aTaskIds.forEach(e -> ret.put((Long)e, false));
            }
        }
    }

    private void getHandlerMergeTasks(List<Map<Long, List<DynamicObject>>> handlerBatchTasksList, Map<Long, List<DynamicObject>> groupMap, String[] groupField, int index) {
        if (++index == 4) {
            return;
        }
        String field = groupField[index];
        for (Map.Entry<Long, List<DynamicObject>> entry : groupMap.entrySet()) {
            Map<Long, List<DynamicObject>> messageMap = entry.getValue().stream().collect(Collectors.groupingBy(e -> e.getLong(field), Collectors.toList()));
            if (index == 3) {
                handlerBatchTasksList.add(messageMap);
            }
            this.getHandlerMergeTasks(handlerBatchTasksList, messageMap, groupField, index);
        }
    }

    private Map<Long, DynamicObject> getHandlerMergeTasks(DynamicObject[] tasks, List<Map<Long, List<DynamicObject>>> handlerBatchTasksList) {
        Map procIdTasksMap = Arrays.stream(tasks).collect(Collectors.groupingBy(e -> e.getLong("flowruproc_id"), Collectors.toList()));
        Set procIds = Arrays.stream(tasks).map(e -> e.getLong("flowruproc_id")).collect(Collectors.toSet());
        Set nodeIds = Arrays.stream(tasks).map(e -> e.getLong("flowrunode_id")).collect(Collectors.toSet());
        Set roleIds = Arrays.stream(tasks).map(e -> e.getLong("flowrurole_id")).collect(Collectors.toSet());
        DynamicObject[] procs = FLOW_RU_PROC_ENTITY_SERVICE.queryProcByPkIds(procIds.stream().collect(Collectors.toList()));
        DynamicObject[] nodes = FLOW_RU_NODE_ENTITY_SERVICE.queryByRuNodeIds(nodeIds.stream().collect(Collectors.toList()));
        DynamicObject[] roles = FLOW_RU_ROLE_ENTITY_SERVICE.queryByRuRoleIds(roleIds.stream().collect(Collectors.toList()));
        Map procDefIdProcsMap = Arrays.stream(procs).collect(Collectors.groupingBy(e -> e.getLong("defproc_id"), Collectors.toList()));
        Map<Long, DynamicObject> nodeIdNodeMap = Arrays.stream(nodes).collect(Collectors.toMap(e -> e.getLong("id"), v -> v));
        Map<Long, DynamicObject> roleIdRoleMap = Arrays.stream(roles).collect(Collectors.toMap(e -> e.getLong("id"), v -> v));
        procDefIdProcsMap.forEach((K, V) -> {
            ArrayList procDefTasks = new ArrayList();
            for (DynamicObject proc : V) {
                procDefTasks.addAll((Collection)procIdTasksMap.get(proc.getLong("id")));
            }
            procDefIdProcsMap.put((Long)K, procDefTasks);
        });
        procDefIdProcsMap.forEach((K, V) -> {
            Map nodeIdTasksMap = V.stream().collect(Collectors.groupingBy(e -> e.getLong("flowrunode_id"), Collectors.toList()));
            Set entryNodeIds = V.stream().map(e -> e.getLong("flowrunode_id")).collect(Collectors.toSet());
            ArrayList entryNodes = new ArrayList();
            entryNodeIds.stream().forEach(nodeId -> entryNodes.add(nodeIdNodeMap.get(nodeId)));
            Map nodeDefIdNodesMap = entryNodes.stream().collect(Collectors.groupingBy(e -> e.getLong("flownodedef_id"), Collectors.toList()));
            nodeDefIdNodesMap.forEach((key, val) -> {
                ArrayList nodeDefTasks = new ArrayList();
                for (DynamicObject node : val) {
                    nodeDefTasks.addAll((Collection)nodeIdTasksMap.get(node.getLong("id")));
                }
                nodeDefIdNodesMap.put((Long)key, nodeDefTasks);
            });
            nodeDefIdNodesMap.forEach((k, v) -> {
                Map<Long, List<DynamicObject>> roleIdTasksMap = v.stream().collect(Collectors.groupingBy(e -> e.getLong("flowrurole_id")));
                Set entryRoleIds = v.stream().map(e -> e.getLong("flowrurole_id")).collect(Collectors.toSet());
                ArrayList entryRoles = new ArrayList();
                entryRoleIds.stream().forEach(roleId -> entryRoles.add(roleIdRoleMap.get(roleId)));
                Map roleDefIdTasksMap = entryRoles.stream().collect(Collectors.groupingBy(e -> e.getLong("flowdefrole_id"), Collectors.toList()));
                roleDefIdTasksMap.forEach((roleDefId, roleDefRoles) -> {
                    ArrayList roleDefTasks = new ArrayList();
                    for (DynamicObject role : roleDefRoles) {
                        roleDefTasks.addAll((Collection)roleIdTasksMap.get(role.getLong("id")));
                    }
                    roleDefIdTasksMap.put((Long)roleDefId, roleDefTasks);
                });
                roleDefIdTasksMap.forEach((roleDefId, roleDefTasks) -> handlerBatchTasksList.add(roleDefTasks.stream().collect(Collectors.groupingBy(e -> e.getLong("handler_id"), Collectors.toList()))));
            });
        });
        return nodeIdNodeMap;
    }

    protected String getMessageFormId(FlowRuMsgMergeEnum msgType, List<DynamicObject> abatchTasks, Long nodeType) {
        String formId = "epa_actevalobj_evalmsg";
        if (evalMsgs.contains((Object)msgType)) {
            formId = NodeTypeConstants.BATCH_EVALUSUMSCORE.equals(nodeType) ? "epa_evaloverall" : (NodeTypeConstants.BATCH_ADJUSTSUMSCORE.equals(nodeType) ? "epa_evaladjustment" : "epa_actevalobj_evalmsg");
        }
        if (formulateMsgs.contains((Object)msgType)) {
            formId = "epa_indicatormsg";
        }
        return formId;
    }

    private void runProcessAfterHandler(List<DynamicObject> handleProcs, List<DynamicObject> handleNodes, List<DynamicObject> handRoles) {
        Map handleProcNodesMap = handleNodes.stream().filter(e -> !this.getCanNotRunNodeStatus().contains(e.getString("nodestatus"))).collect(Collectors.toList()).stream().collect(Collectors.groupingBy(k -> k.getLong("flowruproc_id"), Collectors.toList()));
        Map handleNodeRolesMap = handRoles.stream().filter(e -> this.getCanRunRoleStatus().contains(e.getString("rolestatus"))).collect(Collectors.toList()).stream().collect(Collectors.groupingBy(k -> k.getLong("flowrunode_id"), Collectors.toList()));
        handleProcs.stream().filter(e -> this.getCanRunProcStatus().contains(e.getString("procstatus"))).collect(Collectors.toList()).stream().forEach(proc -> {
            for (DynamicObject node : handleProcNodesMap.get(proc.getLong("id")) != null ? (List)handleProcNodesMap.get(proc.getLong("id")) : new ArrayList()) {
                for (DynamicObject role : handleNodeRolesMap.get(node.getLong("id")) != null ? (List)handleNodeRolesMap.get(node.getLong("id")) : new ArrayList()) {
                    boolean isRunNext = FLOW_RU_PROC_DOMAIN_SERVICE.runProcess(role.getLong("id"), node.getLong("id"), proc.getLong("id"), proc.getLong("actevalobj"));
                    if (!isRunNext) continue;
                    try {
                        FLOW_RU_PROC_DOMAIN_SERVICE.submitTaskMessage(Arrays.stream(FLOW_RU_TASK_ENTITY_SERVICE.queryAllTaskByRoleId(role.getLong("id"))).collect(Collectors.toList()));
                    }
                    catch (Exception exp) {
                        LOG.error("runProcessAfterHandler SendMessage Error:" + exp.getMessage(), (Throwable)exp);
                    }
                }
            }
        });
    }

    static {
        flowMsgEnumBoMap.put("1", new FlowMsgMergeEnumBO(FlowRuMsgMergeEnum.START_FORMULATE_SIN, FlowRuMsgMergeEnum.START_FORMULATE_MUL));
        flowMsgEnumBoMap.put("2", new FlowMsgMergeEnumBO(FlowRuMsgMergeEnum.START_EVALUATE_SIN, FlowRuMsgMergeEnum.START_EVALUATE_MUL));
        flowMsgEnumBoMap.put("3", new FlowMsgMergeEnumBO(FlowRuMsgMergeEnum.START_INTERVIEW_SIN, FlowRuMsgMergeEnum.START_INTERVIEW_MUL));
    }

    private static class SortByCreatetime
    implements Comparator<DynamicObject> {
        private SortByCreatetime() {
        }

        @Override
        public int compare(DynamicObject o1, DynamicObject o2) {
            try {
                Date a = o1.getDate("createtime");
                Date b = o2.getDate("createtime");
                return a.compareTo(b);
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
                return 0;
            }
        }
    }
}

