/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.pbs.business.domain.workflow.service;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.toolkit.utils.SerializationUtils;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.pbs.business.ServiceFactory;
import kd.opmc.pbs.business.domain.msg.service.MergeMsgSendService;
import kd.opmc.pbs.business.domain.msg.service.MsgSendDomainService;
import kd.opmc.pbs.business.domain.workflow.dto.AssignHandlerDTO;
import kd.opmc.pbs.business.domain.workflow.dto.SendMessageDTO;
import kd.opmc.pbs.business.domain.workflow.entity.FlowMsgMergeEnumBO;
import kd.opmc.pbs.business.domain.workflow.entityservice.CrossRoleSetEntityService;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowDefNodeEntityService;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowDefRoleEntityService;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowRuNodeEntityService;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowRuProcEntityService;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowRuRoleEntityService;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowRuTaskEntityService;
import kd.opmc.pbs.business.domain.workflow.entityservice.WorkFlowEntityService;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuMsgEnum;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuMsgMergeEnum;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuNodeStatusEnum;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuProcStatusEnum;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuRoleStatusEnum;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuTaskStatusEnum;
import kd.opmc.pbs.business.domain.workflow.service.CrossScoreDomainService;
import kd.opmc.pbs.business.domain.workflow.service.FlowBatchHandlerDomainService;
import kd.opmc.pbs.business.domain.workflow.service.FlowHandlerBatchDomainService;
import kd.opmc.pbs.business.domain.workflow.service.FlowRuProcDomainService;
import kd.opmc.pbs.business.domain.workflow.service.FlowRuSecondDomainService;
import kd.opmc.pbs.business.domain.workflow.service.FlowRunSupDomainService;
import kd.opmc.pbs.business.domain.workflow.utils.WorkflowUtils;
import kd.opmc.pbs.business.domain.workflow.vo.AssignHandlerVO;
import kd.opmc.pbs.business.domain.workflow.vo.ReminderVO;
import kd.opmc.pbs.business.external.epa.IEPAActevalobjService;
import kd.opmc.pbs.business.external.epa.IEPAAssessActivityService;
import kd.opmc.pbs.business.external.epa.IEPARoleTypeService;
import kd.opmc.pbs.business.external.epa.po.RoleTypeCustomPo;
import kd.opmc.pbs.business.external.hrpi.IHRPIPersonService;
import kd.opmc.pbs.business.external.hrpi.IHRPIWorkRoleService;
import kd.opmc.pbs.business.model.HandlerParamsBo;
import kd.opmc.pbs.common.constants.RoleTypeConstants;

public class FlowHandlerDomainService {
    private static final Log LOG = LogFactory.getLog(FlowHandlerDomainService.class);
    protected static final FlowRuProcEntityService FLOW_RU_PROC_ENTITY_SERVICE = FlowRuProcEntityService.getInstance();
    protected static final IHRPIPersonService PERSON_SERVICE = IHRPIPersonService.getInstance();
    protected static final IHRPIWorkRoleService WORK_ROLE_SERVICE = IHRPIWorkRoleService.getInstance();
    protected static final FlowDefRoleEntityService FLOW_DEF_ROLE_ENTITY_SERVICE = FlowDefRoleEntityService.getInstance();
    protected static final FlowDefNodeEntityService FLOW_DEF_NODE_ENTITY_SERVICE = FlowDefNodeEntityService.getInstance();
    protected static final IEPAAssessActivityService ACTIVITY_SERVICE = IEPAAssessActivityService.getInstance();
    protected static final FlowRuNodeEntityService FLOW_RU_NODE_ENTITY_SERVICE = FlowRuNodeEntityService.getInstance();
    protected static final FlowRuRoleEntityService FLOW_RU_ROLE_ENTITY_SERVICE = FlowRuRoleEntityService.getInstance();
    protected static final FlowRuTaskEntityService FLOW_RU_TASK_ENTITY_SERVICE = FlowRuTaskEntityService.getInstance();
    protected static final FlowRunSupDomainService FLOW_RUSUP_DOMAIN_SERVICE = FlowRunSupDomainService.getInstance();
    protected static final MsgSendDomainService MSG_SEND_DOMAIN_SERVICE = MsgSendDomainService.getInstance();
    protected static final MergeMsgSendService MERGE_MSG_SEND_SERVICE = MergeMsgSendService.getInstance();
    protected static final FlowRuSecondDomainService FLOW_RUSECOND_DOMAIN_SERVICE = FlowRuSecondDomainService.getInstance();
    protected static final IEPARoleTypeService EPA_ROLETYPE_SERVICE = IEPARoleTypeService.getInstance();
    protected static final FlowRuProcDomainService FLOW_RU_PROC_DOMAIN_SERVICE = FlowRuProcDomainService.getInstance();
    private static final CrossRoleSetEntityService CROSS_ROLESET_ENTITYSERVICE = CrossRoleSetEntityService.getInstance();
    private static final FlowBatchHandlerDomainService FLOW_BATCH_HANDLER_DOMAIN_SERVICE = FlowBatchHandlerDomainService.getInstance();
    private static final CrossScoreDomainService CROSS_SCORE_DOMAIN_SERVICE = CrossScoreDomainService.getInstance();
    private static final IEPAActevalobjService EPA_ACTEVAOBJ_SERVICE = IEPAActevalobjService.getInstance();
    private static Map<Long, Function<HandlerParamsBo, Map<Long, List<Long>>>> roleTypeHandlerMap;
    private static final ThreadPool THREAD_POOL;
    private static final Semaphore SEMAPHORE;
    private static final String ISFORBIDDEN = "isforbidden";

    public static FlowHandlerDomainService getInstance() {
        return ServiceFactory.getService(FlowHandlerDomainService.class);
    }

    public List<Long> queryReplaceFlowRoleHandler(Long ruProcId, Long handlerType, DynamicObject ruRole) {
        DynamicObject[] ruProcDyns;
        long start = System.currentTimeMillis();
        HandlerParamsBo handerParamsBo = new HandlerParamsBo();
        ArrayList<Long> ruProcIdList = new ArrayList<Long>(10);
        ruProcIdList.add(ruProcId);
        handerParamsBo.setFlowRuProcIds(ruProcIdList);
        handerParamsBo.setReplace(Boolean.TRUE);
        DynamicObject flowDefRole = FLOW_DEF_ROLE_ENTITY_SERVICE.queryRoleDefByPk(ruRole.getLong("flowdefrole_id"));
        handerParamsBo.setFlowDefRole(flowDefRole);
        Long ruNodeId = 0L;
        try {
            ruNodeId = ruRole.getLong("flowrunode.flownodedef");
        }
        catch (Exception e) {
            ruNodeId = ruRole.getLong("flowrunode.flownodedef.id");
        }
        DynamicObject flowDefNode = FLOW_DEF_NODE_ENTITY_SERVICE.getFlowDefNode(ruNodeId);
        handerParamsBo.setFlowDefNode(flowDefNode);
        if (null == roleTypeHandlerMap || roleTypeHandlerMap.isEmpty()) {
            roleTypeHandlerMap = this.initroleTypeHandlerMap();
        }
        if (null == roleTypeHandlerMap.get(handlerType) && null != (ruProcDyns = FLOW_RU_PROC_ENTITY_SERVICE.loadRuProcByIds(Collections.singletonList(ruProcId))) && ruProcDyns.length > 0) {
            Map<Long, List<Long>> cusHandlerMap = WorkflowUtils.getUserIdByUserDefRoleType(handlerType, ruProcDyns[0]);
            if (null != cusHandlerMap) {
                return cusHandlerMap.get(ruProcId);
            }
            return new ArrayList<Long>(10);
        }
        LOG.info("\u3010OPMC\u3011- before queryReplaceFlowRoleHandler ruProcId is [{}],handlerType is [{}]", (Object)ruProcId, (Object)handlerType);
        Map<Long, List<Long>> handlerMap = roleTypeHandlerMap.get(handlerType).apply(handerParamsBo);
        Map<Long, List<Long>> resultMap = this.dealUserEffectiveAndRemoveDuplicate(handlerMap);
        long end = System.currentTimeMillis();
        LOG.info("queryReplaceFlowRoleHandler takes time : " + (end - start) + " ms");
        if (null != resultMap) {
            if (null != resultMap.get(ruProcId)) {
                LOG.info("\u3010OPMC\u3011-after queryReplaceFlowRoleHandler,handler is[{}]", (Object)SerializationUtils.toJsonString(handlerMap.get(ruProcId)));
            }
            return resultMap.get(ruProcId);
        }
        return new ArrayList<Long>(10);
    }

    public boolean queryUserIsEnable(Long appointId) {
        List userInfo = UserServiceHelper.get(Collections.singletonList(appointId), (String[])new String[]{ISFORBIDDEN, "enable"}, null);
        if (CollectionUtils.isEmpty((Collection)userInfo)) {
            return false;
        }
        Map userInfoMap = (Map)userInfo.get(0);
        String enable = (String)userInfoMap.get("enable");
        return (Boolean)userInfoMap.get(ISFORBIDDEN) == false && "1".equals(enable);
    }

    public Map<Long, Boolean> batchQueryUserIsEnable(List<Long> userIds) {
        List userInfo = UserServiceHelper.get(userIds, (String[])new String[]{"id", ISFORBIDDEN, "enable"}, null);
        HashMap<Long, Boolean> ret = new HashMap<Long, Boolean>(16);
        if (CollectionUtils.isEmpty((Collection)userInfo)) {
            return ret;
        }
        for (Map user : userInfo) {
            ret.put((Long)user.get("id"), (Boolean)user.get(ISFORBIDDEN) == false && "1".equals(user.get("enable")));
        }
        return ret;
    }

    public Map<Long, List<Long>> batchQueryFlowRoleHandler(List<Long> flowRuProcIds, Long roleDefId, DynamicObject ruProc) {
        long start = System.currentTimeMillis();
        DynamicObject flowDefRole = FLOW_DEF_ROLE_ENTITY_SERVICE.queryRoleDefByPk(roleDefId);
        if (HRObjectUtils.isEmpty((Object)flowDefRole)) {
            return new HashMap<Long, List<Long>>(16);
        }
        HandlerParamsBo handerParamsBo = new HandlerParamsBo();
        handerParamsBo.setFlowRuProcIds(flowRuProcIds);
        handerParamsBo.setFlowDefRole(flowDefRole);
        handerParamsBo.setReplace(Boolean.FALSE);
        if (null != ruProc) {
            DynamicObject[] ruProcDyns = new DynamicObject[]{ruProc};
            handerParamsBo.setRuProcDyns(ruProcDyns);
        }
        if (null == roleTypeHandlerMap || roleTypeHandlerMap.isEmpty()) {
            roleTypeHandlerMap = this.initroleTypeHandlerMap();
        }
        if (null == roleTypeHandlerMap.get(flowDefRole.getLong("roletype.id"))) {
            return WorkflowUtils.getUserIdByUserDefRoleType(flowDefRole.getLong("roletype.id"), ruProc);
        }
        LOG.info("\u3010OPMC\u3011-before batchQueryFlowRoleHandler,flowRuProcIds is[{}],roleDefId is[{}]", (Object)SerializationUtils.toJsonString(flowRuProcIds), (Object)roleDefId);
        Map<Long, List<Long>> handlerMap = roleTypeHandlerMap.get(flowDefRole.getLong("roletype.id")).apply(handerParamsBo);
        Map<Long, List<Long>> resultMap = this.dealUserEffectiveAndRemoveDuplicate(handlerMap);
        if (!resultMap.isEmpty()) {
            LOG.info("\u3010OPMC\u3011-after batchQueryFlowRoleHandler,handlerMap is[{}]", (Object)SerializationUtils.toJsonString(resultMap));
        } else {
            LOG.info("\u3010OPMC\u3011-after batchQueryFlowRoleHandler,can not found handler.flowRuProcIds is[{}],roleDefId is[{}]", (Object)SerializationUtils.toJsonString(flowRuProcIds), (Object)roleDefId);
        }
        long end = System.currentTimeMillis();
        LOG.info("batchQueryFlowRoleHandler takes time : " + (end - start) + " ms");
        return resultMap;
    }

    private Map<Long, Function<HandlerParamsBo, Map<Long, List<Long>>>> initroleTypeHandlerMap() {
        HashMap<Long, Function<HandlerParamsBo, Map<Long, List<Long>>>> roleTypeHandlerMap = new HashMap<Long, Function<HandlerParamsBo, Map<Long, List<Long>>>>(16);
        roleTypeHandlerMap.put(RoleTypeConstants.EMP_SELF, handerParamsBo -> this.getSelf((HandlerParamsBo)handerParamsBo));
        roleTypeHandlerMap.put(RoleTypeConstants.APPOINTOR, handerParamsBo -> this.getAppointMulti((HandlerParamsBo)handerParamsBo));
        roleTypeHandlerMap.put(RoleTypeConstants.DIRECT_SUPERIOR, handerParamsBo -> this.getSuperior((HandlerParamsBo)handerParamsBo));
        roleTypeHandlerMap.put(RoleTypeConstants.INDIRECT_SUPERIOR, handerParamsBo -> this.getInDirectSuperior((HandlerParamsBo)handerParamsBo));
        roleTypeHandlerMap.put(RoleTypeConstants.ASSESSMENT_PLAN_CREATOR, handerParamsBo -> this.getEvaSchemaCreator((HandlerParamsBo)handerParamsBo));
        roleTypeHandlerMap.put(RoleTypeConstants.ASSESSMENT_ACTIVITY_CREATOR, handerParamsBo -> this.getEvaActivityCreator((HandlerParamsBo)handerParamsBo));
        roleTypeHandlerMap.put(RoleTypeConstants.ASSESSMENT_RESPONSIBLE_PERSON, handerParamsBo -> this.getResponsibleHandler((HandlerParamsBo)handerParamsBo));
        roleTypeHandlerMap.put(RoleTypeConstants.EMP_DEPHEADER, handerParamsBo -> this.getInCharge((HandlerParamsBo)handerParamsBo));
        roleTypeHandlerMap.put(RoleTypeConstants.APPOINT_POSITION, handerParamsBo -> this.getAppointPosMultiHandler((HandlerParamsBo)handerParamsBo));
        roleTypeHandlerMap.put(RoleTypeConstants.APPOINT_DEPHEADER, handerParamsBo -> this.getAppointAdminOrgHandler((HandlerParamsBo)handerParamsBo));
        return roleTypeHandlerMap;
    }

    private Map<Long, List<Long>> getAppoint(HandlerParamsBo handlerParamsBo) {
        List<Long> flowRuProcIds = handlerParamsBo.getFlowRuProcIds();
        DynamicObject flowDefRole = handlerParamsBo.getFlowDefRole();
        long userId = 0L;
        if (handlerParamsBo.isReplace()) {
            DynamicObject defNode = FLOW_DEF_NODE_ENTITY_SERVICE.getFlowDefNode(flowDefRole.getLong("defnode"));
            userId = defNode.getLong("appointemp");
            LOG.info("\u3010OPMC\u3011-getAppoint,node replace handler is[{}]", (Object)userId);
        } else {
            userId = flowDefRole.getLong("secondf7");
            LOG.info("\u3010OPMC\u3011-getAppoint,role appoint handler is[{}]", (Object)userId);
        }
        LOG.info("\u3010OPMC\u3011-getAppoint,userId is[{}]", (Object)userId);
        boolean isEnable = this.queryUserIsEnable(userId);
        LOG.info("\u3010OPMC\u3011-getAppoint,user.isEnable [{}]", (Object)isEnable);
        if (!isEnable) {
            return new HashMap<Long, List<Long>>(10);
        }
        HashMap<Long, List<Long>> ret = new HashMap<Long, List<Long>>(16);
        ArrayList<Long> userList = new ArrayList<Long>(10);
        userList.add(userId);
        flowRuProcIds.forEach(id -> ret.put((Long)id, (List<Long>)userList));
        return ret;
    }

    private Map<Long, List<Long>> getAppointMulti(HandlerParamsBo handlerParamsBo) {
        List<Long> userIds;
        List<Long> flowRuProcIds = handlerParamsBo.getFlowRuProcIds();
        DynamicObject flowDefRole = handlerParamsBo.getFlowDefRole();
        if (handlerParamsBo.isReplace()) {
            DynamicObject defNode = FLOW_DEF_NODE_ENTITY_SERVICE.getFlowDefNode(flowDefRole.getLong("defnode"));
            userIds = this.getSecondF7Ids(defNode, "userentry", "user", "appointemp");
            LOG.info("\u3010OPMC\u3011-getMultiAppoint,node replace handler is[{}]", userIds);
        } else {
            userIds = this.getSecondF7Ids(flowDefRole, "userentry", "user", "secondf7");
            LOG.info("\u3010OPMC\u3011-getMultiAppoint,role appoint handler is[{}]", userIds);
        }
        Map<Long, Boolean> userIsEnableMap = this.batchQueryUserIsEnable(userIds);
        List userList = userIds.stream().filter(userId -> {
            boolean userIsEnable = true;
            if (!Boolean.TRUE.equals(userIsEnableMap.get(userId))) {
                userIsEnable = false;
                LOG.info("\u3010OPMC\u3011-getMultiAppoint,user.isNotEnable [{}]", userId);
            }
            return userIsEnable;
        }).collect(Collectors.toList());
        HashMap<Long, List<Long>> ret = new HashMap<Long, List<Long>>(16);
        flowRuProcIds.forEach(id -> ret.put((Long)id, userList));
        return ret;
    }

    private Map<Long, List<Long>> getInCharge(HandlerParamsBo handerParamsBo) {
        HashMap<Long, List<Long>> handlerMap = new HashMap<Long, List<Long>>(16);
        List<Long> ruProcIds = handerParamsBo.getFlowRuProcIds();
        HashMap<Long, Long> procActevaObjMap = new HashMap<Long, Long>(16);
        DynamicObject[] ruProcDyns = handerParamsBo.getRuProcDyns();
        if (null == ruProcDyns || ruProcDyns.length < 1) {
            ruProcDyns = FLOW_RU_PROC_ENTITY_SERVICE.queryProcByPkIds(ruProcIds);
        }
        for (DynamicObject ruProc : ruProcDyns) {
            procActevaObjMap.put(ruProc.getLong("actevalobj"), ruProc.getLong("id"));
        }
        List<Long> actevalobjIdList = Arrays.stream(ruProcDyns).map(o -> o.getLong("actevalobj")).collect(Collectors.toList());
        Map<Object, Object> actEvaObjAdminOrgMap = new HashMap(16);
        Map<Object, Object> interObjToActObjMap = new HashMap(16);
        if ("3".equals(ruProcDyns[0].getString("workflowtype"))) {
            DynamicObject[] interviewDyns = IEPAActevalobjService.getInstance().getInterviewobjArrayById(actevalobjIdList);
            actevalobjIdList = Arrays.stream(interviewDyns).map(o -> o.getLong("evalobj.id")).collect(Collectors.toList());
            interObjToActObjMap = Arrays.stream(interviewDyns).collect(Collectors.toMap(ko -> ko.getLong("evalobj.id"), vo -> vo.getLong("id")));
            Map<Long, List<Long>> actEvaObjAdminOrgTmpMap = EPA_ROLETYPE_SERVICE.getOrgIdsByActevalobjIds(actevalobjIdList);
            for (Map.Entry<Long, List<Long>> adminOrgEntry : actEvaObjAdminOrgTmpMap.entrySet()) {
                actEvaObjAdminOrgMap.put(interObjToActObjMap.get(adminOrgEntry.getKey()), adminOrgEntry.getValue());
            }
        } else {
            actEvaObjAdminOrgMap = EPA_ROLETYPE_SERVICE.getOrgIdsByActevalobjIds(actevalobjIdList);
        }
        for (Map.Entry<Object, Object> entry : actEvaObjAdminOrgMap.entrySet()) {
            LOG.info("actevaobj key is [{}],adminorg is [{}]", entry.getKey(), entry.getValue());
            List<Object> handlerList = new ArrayList(10);
            try {
                handlerList = WORK_ROLE_SERVICE.getMainChargeInfoByOrg((List)entry.getValue());
            }
            catch (Exception ex) {
                LOG.error("\u3010OPMC\u3011-getInCharge error.", (Throwable)ex);
            }
            ArrayList<Long> personList = new ArrayList<Long>(10);
            for (Map map : handlerList) {
                personList.add((Long)map.get("person"));
            }
            Map<Long, Long> userMap = this.getUserIdsByPersonIds(personList);
            ArrayList<Long> arrayList = new ArrayList<Long>(10);
            for (Long personId : personList) {
                arrayList.add(userMap.get(personId));
            }
            handlerMap.put((Long)procActevaObjMap.get(entry.getKey()), (List<Long>)arrayList);
            LOG.info("actevaobj key is [{}],got handler is [{}]", entry.getKey(), (Object)((Object)arrayList).toString());
        }
        return handlerMap;
    }

    private Map<Long, List<Long>> getSuperior(HandlerParamsBo handerParamsBo) {
        DynamicObject[] flowRuProcs = handerParamsBo.getRuProcDyns();
        if (null == flowRuProcs || flowRuProcs.length < 1) {
            flowRuProcs = FLOW_RU_PROC_ENTITY_SERVICE.queryProcByPkIds(handerParamsBo.getFlowRuProcIds());
        }
        List<Long> actEvaobjIdList = Arrays.stream(flowRuProcs).map(pro -> pro.getLong("actevalobj")).distinct().collect(Collectors.toList());
        String workflowType = flowRuProcs[0].getString("workflowtype");
        HashMap<Long, Long> inteObjActevaObjMap = new HashMap<Long, Long>(16);
        if ("3".equals(workflowType)) {
            DynamicObject[] interviewDyns = IEPAActevalobjService.getInstance().getInterviewobjArrayById(actEvaobjIdList);
            actEvaobjIdList = Arrays.stream(interviewDyns).map(o -> o.getLong("evalobj.id")).collect(Collectors.toList());
            for (DynamicObject interObj : interviewDyns) {
                inteObjActevaObjMap.put(interObj.getLong("id"), interObj.getLong("evalobj.id"));
            }
        }
        Map<Long, Long> personProcMap = Arrays.stream(flowRuProcs).collect(Collectors.toMap(x -> x.getLong("id"), y -> y.getLong("actevalobj"), (e1, e2) -> e1));
        Map<Long, Map<String, Object>> perfFileInfoMap = IEPAActevalobjService.getInstance().getActevaobjPerfFileInfo(actEvaobjIdList);
        ArrayList<Long> depempIdList = new ArrayList<Long>(10);
        HashMap actevaobjDepempMap = new HashMap(16);
        for (Map.Entry entry : perfFileInfoMap.entrySet()) {
            Long depempId = (Long)((Map)entry.getValue()).get("depempId");
            depempIdList.add(depempId);
            actevaobjDepempMap.put(entry.getKey(), depempId);
        }
        Map<Long, List<Long>> personUserMap = this.getSuperiorIdsByPersonIds(depempIdList);
        HashMap<Long, List<Long>> hashMap = new HashMap<Long, List<Long>>(16);
        for (Map.Entry<Long, Long> personProcEntry : personProcMap.entrySet()) {
            if ("3".equals(workflowType)) {
                hashMap.put(personProcEntry.getKey(), personUserMap.get(actevaobjDepempMap.get(inteObjActevaObjMap.get(personProcEntry.getValue()))));
                continue;
            }
            hashMap.put(personProcEntry.getKey(), personUserMap.get(actevaobjDepempMap.get(personProcEntry.getValue())));
        }
        return hashMap;
    }

    private Map<Long, List<Long>> getInDirectSuperior(HandlerParamsBo handerParamsBo) {
        List<Long> flowRuProcIds = handerParamsBo.getFlowRuProcIds();
        DynamicObject[] flowRuProcs = handerParamsBo.getRuProcDyns();
        if (null == flowRuProcs || flowRuProcs.length < 1) {
            flowRuProcs = FLOW_RU_PROC_ENTITY_SERVICE.queryProcByPkIds(flowRuProcIds);
        }
        List<Long> personIds = Arrays.stream(flowRuProcs).map(pro -> pro.getLong("person.id")).distinct().collect(Collectors.toList());
        Map<Long, Long> personProcMap = Arrays.stream(flowRuProcs).collect(Collectors.toMap(y -> y.getLong("person.id"), x -> x.getLong("id"), (e1, e2) -> e1));
        Map<Long, List<Map<String, Object>>> personMap = WORK_ROLE_SERVICE.getInDirectSuperior(personIds);
        LOG.info("\u3010OPMC\u3011-getInDirectSuperior,personMap is[{}]", (Object)SerializationUtils.toJsonString(personMap));
        HashMap indPersonIdsMap = new HashMap(16);
        for (Map.Entry<Long, List<Map<String, Object>>> indPersonIdsEntry : personMap.entrySet()) {
            List<Map<String, Object>> personIdList = indPersonIdsEntry.getValue();
            ArrayList<Long> pIds = new ArrayList<Long>(10);
            for (Map<String, Object> pmap : personIdList) {
                pIds.add(Long.parseLong(String.valueOf(pmap.get("person.id"))));
            }
            Map<Long, Long> superiorUserMap = this.getUserIdsByPersonIds(pIds);
            HashSet<Long> userIds = new HashSet<Long>(16);
            for (Map.Entry<Long, Long> userMap : superiorUserMap.entrySet()) {
                userIds.add(userMap.getValue());
            }
            indPersonIdsMap.put(indPersonIdsEntry.getKey(), userIds.stream().collect(Collectors.toList()));
        }
        HashMap<Long, List<Long>> ret = new HashMap<Long, List<Long>>(16);
        for (Map.Entry personUserEntry : indPersonIdsMap.entrySet()) {
            if (!personProcMap.containsKey(personUserEntry.getKey())) continue;
            ret.put(personProcMap.get(personUserEntry.getKey()), (List<Long>)personUserEntry.getValue());
        }
        LOG.info("\u3010OPMC\u3011-getInDirectSuperior,ret is[{}]", (Object)SerializationUtils.toJsonString(ret));
        return ret;
    }

    private Map<Long, List<Long>> getSuperiorIdsByPersonIds(List<Long> depempIdList) {
        LOG.info("\u3010OPMC\u3011-getSuperiorIdsByPersonIds,personIds is[{}]", (Object)SerializationUtils.toJsonString(depempIdList));
        HashMap<Long, List<Long>> retMap = new HashMap<Long, List<Long>>(16);
        Map<Long, List<Map<String, Object>>> directSuperior = WORK_ROLE_SERVICE.getDirectSuperiorByDepempId(depempIdList);
        if (directSuperior != null) {
            HashMap personSuperiorMap = new HashMap(16);
            ArrayList<Long> superiorIds = new ArrayList<Long>(10);
            for (Long personId : depempIdList) {
                List<Map<String, Object>> superiorList = directSuperior.get(personId);
                if (HRObjectUtils.isEmpty(superiorList)) continue;
                ArrayList<Long> superiorListPer = new ArrayList<Long>(16);
                for (Map<String, Object> superiorInfo : superiorList) {
                    Long superiorId = (Long)superiorInfo.get("person.id");
                    if (HRObjectUtils.isEmpty((Object)superiorId)) continue;
                    superiorListPer.add(superiorId);
                    superiorIds.add(superiorId);
                }
                personSuperiorMap.put(personId, superiorListPer);
            }
            LOG.info("\u3010OPMC\u3011-getSuperiorIdsByPersonIds,superiorIds is[{}]", (Object)SerializationUtils.toJsonString(superiorIds));
            Map<Long, Long> superiorUserMap = this.getUserIdsByPersonIds(superiorIds);
            LOG.info("\u3010OPMC\u3011-getSuperiorIdsByPersonIds- getUserIdsByPersonIds,superiorUserMap is[{}]", (Object)SerializationUtils.toJsonString(superiorUserMap));
            for (Map.Entry personSuperiorEntry : personSuperiorMap.entrySet()) {
                List superiorPerson = (List)personSuperiorEntry.getValue();
                ArrayList<Long> superiorUser = new ArrayList<Long>(10);
                for (Long user : superiorPerson) {
                    if (!superiorUserMap.containsKey(user)) continue;
                    superiorUser.add(superiorUserMap.get(user));
                }
                retMap.put((Long)personSuperiorEntry.getKey(), (List<Long>)superiorUser);
            }
        }
        LOG.info("\u3010OPMC\u3011-getSuperiorIdsByPersonIds ,retMap is : {}", (Object)SerializationUtils.toJsonString(retMap));
        return retMap;
    }

    private Map<Long, List<Long>> getSelf(HandlerParamsBo handerParamsBo) {
        DynamicObject[] flowRuProcs = handerParamsBo.getRuProcDyns();
        if (null == flowRuProcs || flowRuProcs.length < 1) {
            flowRuProcs = FLOW_RU_PROC_ENTITY_SERVICE.queryProcByPkIds(handerParamsBo.getFlowRuProcIds());
        }
        List<Long> personIds = Arrays.stream(flowRuProcs).map(pro -> pro.getLong("person.id")).distinct().collect(Collectors.toList());
        Map<Long, Long> personUserMap = this.getUserIdsByPersonIds(personIds);
        Map<Long, Long> personProcMap = Arrays.stream(flowRuProcs).collect(Collectors.toMap(dy -> dy.getLong("person.id"), dy -> dy.getLong("id"), (e1, e2) -> e1));
        HashMap<Long, List<Long>> ret = new HashMap<Long, List<Long>>(16);
        for (Map.Entry<Long, Long> personUserEntry : personUserMap.entrySet()) {
            ret.put(personProcMap.get(personUserEntry.getKey()), Collections.singletonList(personUserEntry.getValue()));
        }
        return ret;
    }

    private Map<Long, Long> getUserIdsByPersonIds(List<Long> personIds) {
        HashMap<Long, Long> retMap = new HashMap<Long, Long>(16);
        HashMap<String, List<Long>> personIdMap = new HashMap<String, List<Long>>(16);
        personIdMap.put("person", personIds);
        Map<Object, Object> userIdByPersonInfo = new HashMap(16);
        try {
            userIdByPersonInfo = PERSON_SERVICE.getUserIdByPersonInfo(personIdMap);
        }
        catch (Exception e) {
            LOG.error("\u3010OPMC\u3011-getUserIdsByPersonIds error,personIds:{}", personIds);
            LOG.error((Throwable)e);
        }
        LOG.info("\u3010OPMC\u3011-getUserIdsByPersonIds,param personIds : {},userIdByPersonInfo : {}", personIds, userIdByPersonInfo);
        if (userIdByPersonInfo.isEmpty()) {
            return retMap;
        }
        Boolean success = (Boolean)userIdByPersonInfo.get("success");
        if (success.booleanValue()) {
            Map userInfo = (Map)userIdByPersonInfo.get("data");
            ArrayList<Long> userIds = new ArrayList<Long>(personIds.size());
            for (Long personId : personIds) {
                Map user = (Map)userInfo.get(personId);
                if (user == null) continue;
                Long userId = (Long)user.get("user");
                userIds.add(userId);
            }
            Map<Long, Boolean> userIsEnableMap = this.batchQueryUserIsEnable(userIds);
            for (Long personId : personIds) {
                Long userId;
                Map user = (Map)userInfo.get(personId);
                if (user == null || !userIsEnableMap.getOrDefault(userId = (Long)user.get("user"), false).booleanValue()) continue;
                retMap.put(personId, userId);
            }
        }
        return retMap;
    }

    public Map<Long, List<DynamicObject>> queryHandlerByRuleIds(List<Long> roleIds) {
        long start = System.currentTimeMillis();
        ConcurrentHashMap<Long, List<DynamicObject>> retMap = new ConcurrentHashMap<Long, List<DynamicObject>>(16);
        ArrayList roleIdGroupList = new ArrayList(10);
        int roleSize = roleIds.size();
        ArrayList<Long> roleTmpList = new ArrayList<Long>(10);
        for (int i = 0; i < roleSize; ++i) {
            roleTmpList.add(roleIds.get(i));
            if (roleTmpList.size() % 100 == 0) {
                roleIdGroupList.add(roleTmpList);
                roleTmpList = new ArrayList(10);
                continue;
            }
            if (i != roleSize - 1 || roleTmpList.size() <= 0) continue;
            roleIdGroupList.add(roleTmpList);
        }
        int count = roleIdGroupList.size();
        CountDownLatch atomicInteger = new CountDownLatch(count);
        for (int j = 0; j < count; ++j) {
            List roleList = (List)roleIdGroupList.get(j);
            try {
                Thread.sleep(30L);
            }
            catch (InterruptedException e) {
                LOG.error((Throwable)e);
            }
            try {
                SEMAPHORE.acquire();
                THREAD_POOL.execute(() -> {
                    try {
                        Map<Long, List<DynamicObject>> handlerMap = this.executeQueryHandlerByRuleIds(roleList);
                        for (Map.Entry<Long, List<DynamicObject>> entry : handlerMap.entrySet()) {
                            retMap.put(entry.getKey(), entry.getValue());
                        }
                    }
                    catch (Exception exception) {
                        LOG.error((Throwable)exception);
                    }
                    finally {
                        SEMAPHORE.release();
                        atomicInteger.countDown();
                    }
                }, RequestContext.get());
                continue;
            }
            catch (InterruptedException interruptedException) {
                LOG.error((Throwable)interruptedException);
            }
        }
        try {
            atomicInteger.await();
        }
        catch (InterruptedException e) {
            LOG.error((Throwable)e);
        }
        long end = System.currentTimeMillis();
        LOG.info("\u3010OPMC\u3011-FlowHandlerDomainService.queryHandlerByRuleIds({}) takes time :{}", roleIds, (Object)(end - start + "ms"));
        return retMap;
    }

    public Map<Long, List<DynamicObject>> executeQueryHandlerByRuleIds(List<Long> roleIds) {
        long start = System.currentTimeMillis();
        String properties = "id, issethandler, iscrossrole, flowrunode.handlertype, flowrunode.appointemp, flowruproc_id, flowdefrole_id,flowdefrole,flowrunode.id,flowruproc.actevaobj,flowrunode.flownodedef.id";
        DynamicObject[] roles = FLOW_RU_ROLE_ENTITY_SERVICE.query(properties, new QFilter("id", "in", roleIds).toArray());
        Set<Long> hasTaskRuroleIdSet = this.getHasTaskRuroleIds(roleIds);
        List flowRuProcIds = Arrays.stream(roles).filter(e -> !e.getBoolean("issethandler")).map(e -> e.getLong("flowruproc_id")).collect(Collectors.toList());
        List<DynamicObject> autoQueryHandlerRoles = Arrays.stream(roles).filter(e -> !e.getBoolean("issethandler") && !hasTaskRuroleIdSet.contains(e.getLong("id"))).collect(Collectors.toList());
        DynamicObject[] flowRuProcs = FLOW_RU_PROC_ENTITY_SERVICE.query("id, procstatus, settingmode,person,actevalobj,flowv,defproc,workflowtype", new QFilter("id", "in", flowRuProcIds).toArray());
        Map<Long, List<DynamicObject>> retMap = FLOW_BATCH_HANDLER_DOMAIN_SERVICE.getUnConfirmHandler(autoQueryHandlerRoles.toArray(new DynamicObject[0]), flowRuProcs);
        List setHadlerflowRuProcIds = Arrays.stream(roles).filter(e -> e.getBoolean("issethandler") || hasTaskRuroleIdSet.contains(e.getLong("id"))).map(e -> e.getLong("flowruproc_id")).collect(Collectors.toList());
        List<DynamicObject> hasSetHandlerRoles = Arrays.stream(roles).filter(e -> e.getBoolean("issethandler") || hasTaskRuroleIdSet.contains(e.getLong("id"))).collect(Collectors.toList());
        DynamicObject[] hasSetHandlerRuProcs = FLOW_RU_PROC_ENTITY_SERVICE.query("id, procstatus, settingmode,person,actevalobj", new QFilter("id", "in", setHadlerflowRuProcIds).toArray());
        Map<Long, List<DynamicObject>> map = this.getConfirmHandler(hasSetHandlerRoles.toArray(new DynamicObject[0]), hasSetHandlerRuProcs);
        retMap.putAll(map);
        Set noActiveProcIds = Arrays.stream(flowRuProcs).filter(e -> FlowRuProcStatusEnum.NOTACTIVE.getCode().equals(e.getString("procstatus"))).map(e -> e.getLong("id")).collect(Collectors.toSet());
        List<DynamicObject> crossNoActRoles = Arrays.stream(roles).filter(e -> e.getBoolean("iscrossrole") && noActiveProcIds.contains(e.getLong("flowruproc_id"))).collect(Collectors.toList());
        retMap.putAll(this.getCrocssUnActiveRolesHandlers(crossNoActRoles));
        long end = System.currentTimeMillis();
        LOG.info("\u3010OPMC\u3011-FlowHandlerDomainService.queryHandlerByRuleIds({}) takes time :{}", roleIds, (Object)(end - start + "ms"));
        return retMap;
    }

    protected Set<Long> getHasTaskRuroleIds(List<Long> roleIds) {
        DynamicObject[] taskDynsTmp;
        HashSet<Long> hasTaskRuroleIdSet = new HashSet<Long>(16);
        for (DynamicObject taskDyn : taskDynsTmp = FLOW_RU_TASK_ENTITY_SERVICE.queryTasksByRunRoleIds(roleIds)) {
            hasTaskRuroleIdSet.add(taskDyn.getLong("flowrurole.id"));
        }
        return hasTaskRuroleIdSet;
    }

    private Map<Long, List<DynamicObject>> getCrocssUnActiveRolesHandlers(List<DynamicObject> crossNoActRoles) {
        if (CollectionUtils.isEmpty(crossNoActRoles)) {
            return new HashMap<Long, List<DynamicObject>>(0);
        }
        List<Long> defRoleIds = crossNoActRoles.stream().map(e -> e.getLong("flowdefrole_id")).collect(Collectors.toList());
        DynamicObject[] roleConfig = CROSS_ROLESET_ENTITYSERVICE.queryByDefRoleIds(defRoleIds);
        Map<Long, DynamicObjectCollection> defMap = Arrays.stream(roleConfig).collect(Collectors.groupingBy(k -> k.getLong("defroleid_id"), Collectors.mapping(e -> e.getDynamicObjectCollection("entryentity"), Collectors.reducing(new DynamicObjectCollection(), (k1, k2) -> {
            k1.addAll((Collection)k2);
            return k1;
        }))));
        Map<Long, List> defHandlerMap = defMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, v -> ((DynamicObjectCollection)v.getValue()).stream().map(e -> e.getDynamicObject("handlerid")).collect(Collectors.toList())));
        return crossNoActRoles.stream().filter(e -> !CollectionUtils.isEmpty((Collection)((Collection)defHandlerMap.get(e.getLong("flowdefrole_id"))))).collect(Collectors.toMap(k -> k.getLong("id"), v -> (List)defHandlerMap.get(v.getLong("flowdefrole_id"))));
    }

    private Map<Long, List<DynamicObject>> getConfirmHandler(DynamicObject[] roles, DynamicObject[] flowRuProcs) {
        if (0 == roles.length) {
            return new HashMap<Long, List<DynamicObject>>(0);
        }
        List aRoleIds = Arrays.stream(roles).map(e -> e.getLong("id")).collect(Collectors.toList());
        DynamicObject[] tasks = FLOW_RU_TASK_ENTITY_SERVICE.query("id, flowrurole_id, handler.id, handler.name, handler.number,taskstatus", new QFilter("flowrurole", "in", aRoleIds).toArray());
        Map<Long, List<DynamicObject>> resultMap = Arrays.stream(tasks).filter(e -> !e.getString("taskstatus").equals(FlowRuTaskStatusEnum.EXPIRED.getCode()) && !e.getString("taskstatus").equals(FlowRuTaskStatusEnum.PROCESSED.getCode())).collect(Collectors.groupingBy(k -> k.getLong("flowrurole_id"), Collectors.mapping(v -> v.getDynamicObject("handler"), Collectors.toList())));
        Map completedHandlerMap = Arrays.stream(tasks).filter(e -> e.getString("taskstatus").equals(FlowRuTaskStatusEnum.PROCESSED.getCode())).collect(Collectors.groupingBy(k -> k.getLong("flowrurole_id"), Collectors.mapping(v -> v.getDynamicObject("handler"), Collectors.toList())));
        for (Map.Entry entry : completedHandlerMap.entrySet()) {
            List<DynamicObject> userList = resultMap.get(entry.getKey());
            if (!CollectionUtils.isEmpty(userList) && !CollectionUtils.isEmpty((Collection)entry.getValue())) {
                userList.addAll(entry.getValue());
                resultMap.put(entry.getKey(), userList);
                continue;
            }
            if (CollectionUtils.isEmpty((Collection)entry.getValue())) continue;
            resultMap.put(entry.getKey(), entry.getValue());
        }
        return resultMap;
    }

    protected Map<Long, List<DynamicObject>> getUnConfirmHandler(DynamicObject[] roles, DynamicObject[] flowRuProcs) {
        List userInfo;
        if (0 == roles.length) {
            return new HashMap<Long, List<DynamicObject>>(0);
        }
        Set autoIds = Arrays.stream(flowRuProcs).filter(e -> "10".equals(e.getString("settingmode"))).map(e -> e.getLong("id")).collect(Collectors.toSet());
        if (0 == autoIds.size()) {
            return new HashMap<Long, List<DynamicObject>>(0);
        }
        Map roleDefMap = Arrays.stream(roles).filter(e -> autoIds.contains(e.getLong("flowruproc_id"))).collect(Collectors.groupingBy(k -> k.getLong("flowdefrole_id"), Collectors.toList()));
        Map<Long, DynamicObject> procMap = Arrays.stream(flowRuProcs).collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
        HashMap<Long, List> roleHandleMap = new HashMap<Long, List>(roleDefMap.size());
        for (Map.Entry entry : roleDefMap.entrySet()) {
            Long roleDefId = entry.getKey();
            List autoRoles = entry.getValue();
            List proIds = autoRoles.stream().map(e -> e.getLong("flowruproc_id")).distinct().collect(Collectors.toList());
            HashMap<Long, List<Long>> procHandlerMap = new HashMap<Long, List<Long>>(proIds.size());
            for (Long procId : proIds) {
                procHandlerMap.putAll(this.batchQueryFlowRoleHandler(Collections.singletonList(procId), roleDefId, procMap.get(procId)));
            }
            for (DynamicObject ruRole : autoRoles) {
                List handlers;
                DynamicObject ruNode = ruRole.getDynamicObject("flowrunode");
                List handlerIds = (List)procHandlerMap.get(ruRole.getLong("flowruproc_id"));
                if (CollectionUtils.isEmpty((Collection)handlerIds)) {
                    List<Long> nodeHandlerList = this.queryReplaceFlowRoleHandler(ruRole.getLong("flowruproc_id"), ruNode.getLong("handlertype_id"), ruRole);
                    procHandlerMap.put(ruRole.getLong("flowruproc_id"), nodeHandlerList);
                }
                handlers = null == (handlers = (List)procHandlerMap.get(ruRole.getLong("flowruproc_id"))) ? new ArrayList(0) : handlers;
                roleHandleMap.put(ruRole.getLong("id"), handlers);
            }
        }
        int personSize = roleHandleMap.values().stream().filter(Objects::nonNull).mapToInt(List::size).sum();
        if (0 == personSize) {
            userInfo = new ArrayList(0);
        } else {
            List userIds = roleHandleMap.values().stream().filter(Objects::nonNull).reduce(new ArrayList(personSize), (a, b) -> {
                a.addAll(b);
                return a;
            });
            userIds = userIds.stream().filter(Objects::nonNull).filter(e -> 0L < e).distinct().collect(Collectors.toList());
            userInfo = UserServiceHelper.get(userIds, (String[])new String[]{"id", "name", "number"}, null);
        }
        DynamicObjectType userType = EntityMetadataCache.getSubDataEntityType((String)"bos_user", Arrays.asList("id", "name", "number"));
        Map<Long, DynamicObject> personMap = userInfo.stream().map(e -> {
            DynamicObject aPerson = new DynamicObject(userType);
            aPerson.set("id", e.get("id"));
            aPerson.set("name", e.get("name"));
            aPerson.set("number", e.get("number"));
            return aPerson;
        }).collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
        HashMap<Long, List<DynamicObject>> retMap = new HashMap<Long, List<DynamicObject>>(roleHandleMap.size());
        for (Map.Entry entry : roleHandleMap.entrySet()) {
            List persons = ((List)entry.getValue()).stream().filter(Objects::nonNull).map(e -> personMap.getOrDefault(e, new DynamicObject(userType, e))).collect(Collectors.toList());
            retMap.put((Long)entry.getKey(), persons);
        }
        return retMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AssignHandlerVO> assignHandlerBeforeStartProcess(List<Long> roleIds, List<Long> handlerIds) {
        if (CollectionUtils.isEmpty(roleIds) || CollectionUtils.isEmpty(handlerIds)) {
            return new ArrayList<AssignHandlerVO>(0);
        }
        DynamicObject[] roles = this.queryRolesByIds(roleIds);
        ArrayList<DynamicObject> tasks = new ArrayList<DynamicObject>(roles.length * handlerIds.size());
        for (DynamicObject role : roles) {
            tasks.addAll(FLOW_RU_TASK_ENTITY_SERVICE.generateTaskByRuRole(role, handlerIds, false));
        }
        FLOW_RU_ROLE_ENTITY_SERVICE.setRoleIsSetHander(roles);
        for (DynamicObject task : tasks) {
            task.set("taskstatus", (Object)FlowRuTaskStatusEnum.NOT_ACTIVE.getCode());
        }
        try (TXHandle required = TX.required();){
            FLOW_RU_TASK_ENTITY_SERVICE.deleteByFilter(new QFilter("flowrurole_id", "in", roleIds).toArray());
            FLOW_RU_TASK_ENTITY_SERVICE.save(tasks.toArray(new DynamicObject[0]));
            FLOW_RU_ROLE_ENTITY_SERVICE.update(roles);
            this.activeRolesIfPending(tasks);
        }
        return tasks.stream().map(e -> {
            AssignHandlerVO vo = new AssignHandlerVO();
            vo.setRoleId(e.getLong("flowrurole.id"));
            vo.setHandlerId(e.getLong("handler_id"));
            vo.setTaskId(e.getLong("id"));
            vo.setSucess(true);
            return vo;
        }).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AssignHandlerVO> assignHandlerAfterStartProcess(List<Long> roleIds, List<Long> handlerIds) {
        if (CollectionUtils.isEmpty(roleIds) || CollectionUtils.isEmpty(handlerIds)) {
            return new ArrayList<AssignHandlerVO>(0);
        }
        DynamicObject[] roles = this.queryRolesByIds(roleIds);
        String properties = "id, taskstatus, updatestatustime, modifier, modifytime, flowrurole, flowrunode, flowruproc, handler";
        DynamicObject[] tasks = FLOW_RU_TASK_ENTITY_SERVICE.query(properties, new QFilter("flowrurole_id", "in", roleIds).toArray());
        Map<Long, List<DynamicObject>> roleIdTaskMap = Arrays.stream(tasks).collect(Collectors.groupingBy(k -> k.getLong("flowrurole_id"), Collectors.toList()));
        HashSet<String> canTaskStatus = this.getCanTaskStatus();
        List<DynamicObject> handlerTask = this.getHandTasks(handlerIds, roles, roleIdTaskMap, canTaskStatus);
        Set handRoleIds = handlerTask.stream().map(e -> e.getLong("flowrurole_id")).collect(Collectors.toSet());
        DynamicObject[] handRoles = (DynamicObject[])Arrays.stream(roles).filter(e -> handRoleIds.contains(e.getLong("id"))).toArray(DynamicObject[]::new);
        FLOW_RU_ROLE_ENTITY_SERVICE.setRoleIsSetHander(handRoles);
        try (TXHandle required = TX.required();){
            DynamicObject[] updateTask = (DynamicObject[])handlerTask.stream().filter(e -> 0L != e.getLong("id")).toArray(DynamicObject[]::new);
            FLOW_RU_TASK_ENTITY_SERVICE.save(updateTask);
            DynamicObject[] addTask = (DynamicObject[])handlerTask.stream().filter(e -> 0L == e.getLong("id")).toArray(DynamicObject[]::new);
            FLOW_RU_TASK_ENTITY_SERVICE.save(addTask);
            FLOW_RU_ROLE_ENTITY_SERVICE.update(handRoles);
            this.activeRolesIfPending(handlerTask);
        }
        return this.buildRes(roles, roleIdTaskMap, canTaskStatus, handlerTask);
    }

    protected HashSet<String> getCanTaskStatus() {
        return new HashSet<String>(Arrays.asList(FlowRuTaskStatusEnum.NOT_ACTIVE.getCode(), FlowRuTaskStatusEnum.WAITING.getCode(), FlowRuTaskStatusEnum.PROCESSING.getCode(), FlowRuTaskStatusEnum.BE_WAITTING.getCode()));
    }

    protected DynamicObject[] queryRolesByIds(List<Long> roleIds) {
        String properties = "rolestatus,flowruproc,flowrunode,flowdefrole.id,assessyear,assessperiod,activity,perforg,updatestatustime,issethandler,crossroleset.id,turnoversort,setno,iscrossrole,modifier,modifytime,flowdefrole.outflow,flowdefrole.minnum";
        return FLOW_RU_ROLE_ENTITY_SERVICE.query(properties, new QFilter("id", "in", roleIds).toArray());
    }

    protected List<DynamicObject> getHandTasks(List<Long> handlerIds, DynamicObject[] roles, Map<Long, List<DynamicObject>> roleIdTaskMap, HashSet<String> canTaskStatus) {
        ArrayList<DynamicObject> retHandlerTask = new ArrayList<DynamicObject>(roles.length * handlerIds.size());
        HashSet<Long> handlerIdSet = new HashSet<Long>(handlerIds);
        Map<Long, Boolean> manualopMap = this.getManualOpMapByRoles(Arrays.stream(roles).collect(Collectors.toList()));
        for (DynamicObject role : roles) {
            List<DynamicObject> aTasks = roleIdTaskMap.get(role.getLong("id"));
            if (CollectionUtils.isEmpty(aTasks)) {
                List<DynamicObject> tasks = FLOW_RU_TASK_ENTITY_SERVICE.generateTaskByRuRole(role, handlerIds, false);
                this.updateTaskStatus(tasks, manualopMap);
                retHandlerTask.addAll(tasks);
                continue;
            }
            retHandlerTask.addAll(this.handlerExistTasks(aTasks, handlerIdSet, canTaskStatus));
            Set hasTaskHandlers = aTasks.stream().map(e -> e.getLong("handler_id")).collect(Collectors.toSet());
            List<Long> noTaskHanders = handlerIdSet.stream().filter(e -> !hasTaskHandlers.contains(e)).collect(Collectors.toList());
            List<DynamicObject> tasks = FLOW_RU_TASK_ENTITY_SERVICE.generateTaskByRuRole(role, noTaskHanders, false);
            this.updateTaskStatus(tasks, manualopMap);
            retHandlerTask.addAll(tasks);
        }
        return retHandlerTask;
    }

    private void updateTaskStatus(List<DynamicObject> tasks, Map<Long, Boolean> manualopMap) {
        Map<Long, Long> procCurNodeMap = this.getProcCurNodeMap(tasks);
        for (DynamicObject task : tasks) {
            if (manualopMap.get(task.getLong("flowrunode_id")).booleanValue()) {
                task.set("taskstatus", (Object)FlowRuTaskStatusEnum.BE_WAITTING.getCode());
                continue;
            }
            if (procCurNodeMap.getOrDefault(task.getLong("flowruproc_id"), 0L).longValue() == task.getLong("flowrunode_id")) {
                task.set("taskstatus", (Object)FlowRuTaskStatusEnum.WAITING.getCode());
                continue;
            }
            task.set("taskstatus", (Object)FlowRuTaskStatusEnum.NOT_ACTIVE.getCode());
        }
    }

    protected List<AssignHandlerVO> buildRes(DynamicObject[] roles, Map<Long, List<DynamicObject>> roleIdTaskMap, HashSet<String> canTaskStatus, List<DynamicObject> handlerTask) {
        ArrayList<AssignHandlerVO> ret = new ArrayList<AssignHandlerVO>(handlerTask.size());
        for (DynamicObject aTask : handlerTask) {
            AssignHandlerVO vo = new AssignHandlerVO();
            vo.setRoleId(aTask.getLong("flowrurole_id"));
            vo.setTaskId(aTask.getLong("id"));
            vo.setHandlerId(aTask.getLong("handler_id"));
            vo.setSucess(true);
            ret.add(vo);
        }
        for (DynamicObject role : roles) {
            List<DynamicObject> aTasks = roleIdTaskMap.get(role.getLong("id"));
            if (CollectionUtils.isEmpty(aTasks)) continue;
            for (DynamicObject aTask : aTasks) {
                if (canTaskStatus.contains(aTask.getString("taskstatus"))) continue;
                AssignHandlerVO vo = new AssignHandlerVO();
                vo.setRoleId(aTask.getLong("flowrurole_id"));
                vo.setTaskId(aTask.getLong("id"));
                vo.setHandlerId(aTask.getLong("handler_id"));
                vo.setSucess(false);
                vo.setErrorMessage(this.getReSultMessage(aTask, ResManager.loadKDString((String)"\u5236\u5b9a\u4eba", (String)"FlowHandlerDomainService_0", (String)"opmc-pbs-business", (Object[])new Object[0])));
                ret.add(vo);
            }
        }
        return ret;
    }

    protected List<DynamicObject> handlerExistTasks(List<DynamicObject> tasks, Set<Long> handlerIdSet, HashSet<String> canTaskStatus) {
        ArrayList<DynamicObject> retHandlerTask = new ArrayList<DynamicObject>(tasks.size());
        for (DynamicObject task : tasks) {
            if (!canTaskStatus.contains(task.getString("taskstatus"))) continue;
            if (handlerIdSet.contains(task.getLong("handler_id"))) {
                FLOW_RUSUP_DOMAIN_SERVICE.updateTaskStatus(new DynamicObject[]{task}, FlowRuTaskStatusEnum.WAITING.getCode());
            } else {
                FLOW_RUSUP_DOMAIN_SERVICE.updateTaskStatus(new DynamicObject[]{task}, FlowRuTaskStatusEnum.EXPIRED.getCode());
            }
            retHandlerTask.add(task);
        }
        return retHandlerTask;
    }

    protected String getReSultMessage(DynamicObject task, String personType) {
        String taskStatus = task.getString("taskstatus");
        DynamicObject handler = task.getDynamicObject("handler");
        String handlerStatus = ResManager.loadKDString((String)"\u5df2\u5904\u7406", (String)"FlowHandlerDomainService_1", (String)"opmc-pbs-business", (Object[])new Object[0]);
        if (FlowRuTaskStatusEnum.PROCESSED.getCode().equals(taskStatus)) {
            handlerStatus = ResManager.loadKDString((String)"\u5df2\u5904\u7406", (String)"FlowHandlerDomainService_1", (String)"opmc-pbs-business", (Object[])new Object[0]);
        } else if (FlowRuTaskStatusEnum.RETURNED.getCode().equals(taskStatus)) {
            handlerStatus = ResManager.loadKDString((String)"\u5df2\u9000\u56de", (String)"FlowHandlerDomainService_2", (String)"opmc-pbs-business", (Object[])new Object[0]);
        } else if (FlowRuTaskStatusEnum.EXPIRED.getCode().equals(taskStatus)) {
            handlerStatus = ResManager.loadKDString((String)"\u5df2\u5931\u6548", (String)"FlowHandlerDomainService_3", (String)"opmc-pbs-business", (Object[])new Object[0]);
        } else if (FlowRuTaskStatusEnum.REJECTED.getCode().equals(taskStatus)) {
            handlerStatus = ResManager.loadKDString((String)"\u5df2\u62d2\u7edd", (String)"FlowHandlerDomainService_4", (String)"opmc-pbs-business", (Object[])new Object[0]);
        } else if (FlowRuTaskStatusEnum.PENDING.getCode().equals(taskStatus)) {
            handlerStatus = ResManager.loadKDString((String)"\u5df2\u6302\u8d77", (String)"FlowHandlerDomainService_5", (String)"opmc-pbs-business", (Object[])new Object[0]);
        }
        Object[] args = new Object[]{handler.getString("name"), handler.getString("number"), handlerStatus, personType};
        return ResManager.loadKDString((String)"{0}\uff08\u5de5\u53f7\uff1a{1}\uff09\uff1a\u201c{2}\u201d\u6570\u636e\u4e0d\u80fd\u4fee\u6539{3}\u3002", (String)"FlowHandlerDomainService_6", (String)"opmc-pbs-business", (Object[])args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AssignHandlerVO> assignHandlerAfterStartProcess(List<AssignHandlerDTO> dtos) {
        if (CollectionUtils.isEmpty(dtos)) {
            return new ArrayList<AssignHandlerVO>(0);
        }
        List<Long> roleIds = dtos.stream().map(AssignHandlerDTO::getRoleId).collect(Collectors.toList());
        DynamicObject[] roles = this.queryRolesByIds(roleIds);
        Map<Long, DynamicObject> roleIdMap = Arrays.stream(roles).collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
        List taskIds = dtos.stream().map(AssignHandlerDTO::getTaskId).filter(Objects::nonNull).collect(Collectors.toList());
        String properties = "id, taskstatus, updatestatustime, modifier, modifytime, flowrurole, flowrunode, flowruproc, handler";
        DynamicObject[] tasks = FLOW_RU_TASK_ENTITY_SERVICE.query(properties, new QFilter("id", "in", taskIds).toArray());
        HashSet<String> canTaskStatus = this.getCanTaskStatus();
        Map<Boolean, List<DynamicObject>> handTypeTasks = Arrays.stream(tasks).collect(Collectors.groupingBy(k -> canTaskStatus.contains(k.getString("taskstatus"))));
        List<DynamicObject> handlerTask = this.handTask(dtos, roleIdMap, handTypeTasks.getOrDefault(true, new ArrayList(0)));
        Set handRoleIds = handlerTask.stream().map(e -> e.getLong("flowrurole_id")).collect(Collectors.toSet());
        DynamicObject[] handRoles = (DynamicObject[])Arrays.stream(roles).filter(e -> handRoleIds.contains(e.getLong("id"))).toArray(DynamicObject[]::new);
        FLOW_RU_ROLE_ENTITY_SERVICE.setRoleIsSetHander(handRoles);
        List<DynamicObject> errorTask = this.getRoleOnlyErrorTasks(handlerTask);
        try (TXHandle required = TX.required();){
            DynamicObject[] updateTask = (DynamicObject[])handlerTask.stream().filter(e -> 0L != e.getLong("id")).toArray(DynamicObject[]::new);
            FLOW_RU_TASK_ENTITY_SERVICE.save(updateTask);
            DynamicObject[] addTask = (DynamicObject[])handlerTask.stream().filter(e -> 0L == e.getLong("id")).toArray(DynamicObject[]::new);
            FLOW_RU_TASK_ENTITY_SERVICE.save(addTask);
            FLOW_RU_ROLE_ENTITY_SERVICE.update(handRoles);
            this.activeRolesIfPending(handlerTask);
            List deleteTasks = handlerTask.stream().filter(e -> FlowRuTaskStatusEnum.EXPIRED.getCode().equals(e.getString("taskstatus"))).collect(Collectors.toList());
            for (DynamicObject task : deleteTasks) {
                FLOW_RU_PROC_DOMAIN_SERVICE.runProcess(task.getLong("flowrurole_id"), task.getLong("flowrunode_id"), task.getLong("flowruproc_id"), task.getLong("flowruproc.actevalobj"));
            }
        }
        return this.buildRes(dtos, handTypeTasks.getOrDefault(false, new ArrayList(0)), errorTask);
    }

    protected List<DynamicObject> getRoleOnlyErrorTasks(List<DynamicObject> handlerTask) {
        ArrayList<DynamicObject> retTasks = new ArrayList<DynamicObject>(0);
        Set<Long> handRoleIds = handlerTask.stream().filter(e -> FlowRuTaskStatusEnum.EXPIRED.getCode().equals(e.getString("taskstatus"))).map(e -> e.getLong("flowrurole_id")).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(handRoleIds)) {
            return retTasks;
        }
        DynamicObject[] effectTasks = FLOW_RU_TASK_ENTITY_SERVICE.queryEffectTasksByRoleIds(handRoleIds);
        if (0 == effectTasks.length) {
            return retTasks;
        }
        Set deleteTaskIds = handlerTask.stream().filter(e -> FlowRuTaskStatusEnum.EXPIRED.getCode().equals(e.getString("taskstatus"))).map(e -> e.getLong("id")).collect(Collectors.toSet());
        List addTasks = handlerTask.stream().filter(e -> 0L == e.getLong("id")).collect(Collectors.toList());
        addTasks.addAll(Arrays.asList(effectTasks));
        Map<Long, Long> roleCounts = addTasks.stream().filter(e -> !deleteTaskIds.contains(e.getLong("id"))).collect(Collectors.groupingBy(k -> k.getLong("flowrurole_id"), Collectors.counting()));
        for (Long handRoleId : handRoleIds) {
            if (0L != roleCounts.getOrDefault(handRoleId, 0L)) continue;
            retTasks.addAll(handlerTask.stream().filter(e -> handRoleId.longValue() == e.getLong("flowrurole_id")).collect(Collectors.toList()));
            handlerTask.removeIf(e -> handRoleId.longValue() == e.getLong("flowrurole_id"));
        }
        return retTasks;
    }

    public List<DynamicObject> pendingInvalidUsers(List<DynamicObject> tasks) {
        List<DynamicObject> unableTask = this.checkInvalidUsers(tasks);
        this.pendingByTasks(unableTask);
        return unableTask;
    }

    public List<DynamicObject> checkInvalidUsers(List<DynamicObject> tasks) {
        List<Long> userIds = tasks.stream().map(e -> e.getLong("handler_id")).filter(e -> 0L < e).collect(Collectors.toList());
        Map<Long, Boolean> enableMap = this.batchQueryUserIsEnable(userIds);
        Predicate<DynamicObject> unablePre = e -> enableMap.getOrDefault(e.getLong("handler_id"), true) == false;
        return tasks.stream().filter(unablePre).collect(Collectors.toList());
    }

    public void activeRolesIfPending(List<DynamicObject> tasks) {
        if (CollectionUtils.isEmpty(tasks)) {
            return;
        }
        List<Long> roleIds = tasks.stream().map(e -> e.getLong("flowrurole_id")).collect(Collectors.toList());
        DynamicObject[] pendingRoles = FLOW_RU_ROLE_ENTITY_SERVICE.queryPendingRoleByIds(roleIds);
        if (0 == pendingRoles.length) {
            return;
        }
        Set pendingRolesIds = Arrays.stream(pendingRoles).map(e -> e.getLong("id")).collect(Collectors.toSet());
        QFilter filter = new QFilter("flowrurole", "in", pendingRolesIds);
        filter.and("taskstatus", "=", (Object)FlowRuTaskStatusEnum.PENDING.getCode());
        DynamicObject[] pendingTask = FLOW_RU_TASK_ENTITY_SERVICE.query("id,flowrurole_id", filter.toArray());
        Set handTaskIds = tasks.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
        Map<Long, Long> roleCount = Arrays.stream(pendingTask).filter(e -> !handTaskIds.contains(e.getLong("id"))).collect(Collectors.groupingBy(k -> k.getLong("flowrurole_id"), Collectors.counting()));
        List<DynamicObject> updateRoles = Arrays.stream(pendingRoles).filter(e -> 0L == roleCount.getOrDefault(e.getLong("id"), 0L)).collect(Collectors.toList());
        Map<Long, Set<Long>> procCurRoleMap = this.getProcCurRolesMap(updateRoles);
        Map<Boolean, List<DynamicObject>> roles = updateRoles.stream().collect(Collectors.groupingBy(e -> procCurRoleMap.getOrDefault(e.getLong("flowruproc_id"), Collections.emptySet()).contains(e.getLong("id"))));
        WorkflowUtils.updateRoleStatus(roles.getOrDefault(true, Collections.emptyList()), FlowRuRoleStatusEnum.RUNNING.getCode());
        WorkflowUtils.updateRoleStatus(roles.getOrDefault(false, Collections.emptyList()), FlowRuRoleStatusEnum.NOT_ACTIVE.getCode());
        FLOW_RU_ROLE_ENTITY_SERVICE.update(updateRoles.toArray(new DynamicObject[0]));
        this.activeNodesIfPending(updateRoles);
    }

    public void activeNodesIfPending(List<DynamicObject> roles) {
        if (CollectionUtils.isEmpty(roles)) {
            return;
        }
        Set<Long> nodeIds = roles.stream().map(e -> e.getLong("flowrunode_id")).collect(Collectors.toSet());
        DynamicObject[] pendingNodes = FLOW_RU_NODE_ENTITY_SERVICE.queryPendingNodeByIds(nodeIds);
        if (0 == pendingNodes.length) {
            return;
        }
        List<Long> pendingNodeIds = Arrays.stream(pendingNodes).map(e -> e.getLong("id")).collect(Collectors.toList());
        DynamicObject[] pendingRoles = FLOW_RU_ROLE_ENTITY_SERVICE.queryPendingRoleByNodeIds(pendingNodeIds);
        Set handRoleIds = roles.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
        Map<Long, Long> nodeCount = Arrays.stream(pendingRoles).filter(e -> !handRoleIds.contains(e.getLong("id"))).collect(Collectors.groupingBy(k -> k.getLong("flowrunode_id"), Collectors.counting()));
        List<DynamicObject> updateNodes = Arrays.stream(pendingNodes).filter(e -> 0L == nodeCount.getOrDefault(e.getLong("id"), 0L)).collect(Collectors.toList());
        Map<Long, Long> procCurNodeMap = this.getProcCurNodeMap(updateNodes);
        Map<Boolean, List<DynamicObject>> nodes = updateNodes.stream().collect(Collectors.groupingBy(e -> procCurNodeMap.getOrDefault(e.getLong("flowruproc_id"), 0L).longValue() == e.getLong("id")));
        WorkflowUtils.updateNodeStatus(nodes.getOrDefault(true, Collections.emptyList()), FlowRuNodeStatusEnum.RUNNING.getCode());
        WorkflowUtils.updateNodeStatus(nodes.getOrDefault(false, Collections.emptyList()), FlowRuNodeStatusEnum.NOT_ACTIVE.getCode());
        FLOW_RU_NODE_ENTITY_SERVICE.update(updateNodes.toArray(new DynamicObject[0]));
        this.activeProcIfPending(updateNodes);
    }

    private Map<Long, Long> getProcCurNodeMap(List<DynamicObject> dycs) {
        List<Long> procIds = dycs.stream().map(e -> e.getLong("flowruproc_id")).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(procIds)) {
            return Collections.emptyMap();
        }
        DynamicObject[] procs = FLOW_RU_PROC_ENTITY_SERVICE.queryProcByPkIds(procIds);
        return Arrays.stream(procs).collect(Collectors.toMap(k -> k.getLong("id"), v -> v.getLong("currentnode_id")));
    }

    private Map<Long, Set<Long>> getProcCurRolesMap(List<DynamicObject> dycs) {
        List<Long> procIds = dycs.stream().map(e -> e.getLong("flowruproc_id")).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(procIds)) {
            return Collections.emptyMap();
        }
        DynamicObject[] procs = FLOW_RU_PROC_ENTITY_SERVICE.queryProcByPkIds(procIds);
        return Arrays.stream(procs).collect(Collectors.toMap(k -> k.getLong("id"), v -> v.getDynamicObjectCollection("entryentity").stream().map(e -> e.getLong("ruroleid_id")).collect(Collectors.toSet())));
    }

    public void activeProcIfPending(List<DynamicObject> nodes) {
        if (CollectionUtils.isEmpty(nodes)) {
            return;
        }
        Set<Long> procIds = nodes.stream().map(e -> e.getLong("flowruproc_id")).collect(Collectors.toSet());
        DynamicObject[] pendingProcs = FLOW_RU_PROC_ENTITY_SERVICE.queryPendingProcByIds(procIds);
        if (0 == pendingProcs.length) {
            return;
        }
        Set<Long> pendingProcIds = Arrays.stream(pendingProcs).map(e -> e.getLong("id")).collect(Collectors.toSet());
        DynamicObject[] pendingNodes = FLOW_RU_NODE_ENTITY_SERVICE.queryPendingNodeByProcIds(pendingProcIds);
        Set handNodeIds = nodes.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
        Map<Long, Long> procCount = Arrays.stream(pendingNodes).filter(e -> !handNodeIds.contains(e.getLong("id"))).collect(Collectors.groupingBy(k -> k.getLong("flowruproc_id"), Collectors.counting()));
        List<DynamicObject> updateProcs = Arrays.stream(pendingProcs).filter(e -> 0L == procCount.getOrDefault(e.getLong("id"), 0L)).collect(Collectors.toList());
        WorkflowUtils.updateProcStatus(updateProcs, FlowRuProcStatusEnum.RUNNING.getCode());
        FLOW_RU_PROC_ENTITY_SERVICE.update(updateProcs.toArray(new DynamicObject[0]));
    }

    protected List<AssignHandlerVO> buildRes(List<AssignHandlerDTO> dtos, List<DynamicObject> errorTasks, List<DynamicObject> errorTask) {
        ArrayList<AssignHandlerVO> ret = new ArrayList<AssignHandlerVO>(dtos.size());
        Map<Long, DynamicObject> errorTaskMap = errorTasks.stream().collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
        Map<Long, DynamicObject> errorRoleTaskMap = errorTask.stream().collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
        List<Long> procIds = errorRoleTaskMap.values().stream().map(e -> e.getLong("flowruproc_id")).collect(Collectors.toList());
        DynamicObject[] procs = FLOW_RU_PROC_ENTITY_SERVICE.queryPersonByPkIds(procIds);
        Map<Long, DynamicObject> procMap = Arrays.stream(procs).collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
        for (AssignHandlerDTO dto : dtos) {
            AssignHandlerVO vo = new AssignHandlerVO();
            ret.add(vo);
            vo.setHandlerId(dto.getHandlerId());
            vo.setTaskId(dto.getTaskId());
            vo.setRoleId(dto.getRoleId());
            if (null != errorTaskMap.get(dto.getTaskId())) {
                vo.setSucess(false);
                vo.setErrorMessage(this.getReSultMessage(errorTaskMap.get(dto.getTaskId()), ResManager.loadKDString((String)"\u8bc4\u4f30\u4eba", (String)"FlowHandlerDomainService_7", (String)"opmc-pbs-business", (Object[])new Object[0])));
                continue;
            }
            if (null != errorRoleTaskMap.get(dto.getTaskId())) {
                vo.setSucess(false);
                DynamicObject task = errorRoleTaskMap.get(dto.getTaskId());
                DynamicObject proc = procMap.get(task.getLong("flowruproc_id"));
                DynamicObject person = proc.getDynamicObject("person");
                Object[] args = new Object[]{person.getString("name"), person.getString("number"), task.getString("flowrurole.name")};
                vo.setErrorMessage(ResManager.loadKDString((String)"\u8bc4\u4f30\u5bf9\u8c61-{0}\uff08\u5de5\u53f7\uff1a{1}\uff09\uff1a\u89d2\u8272 {2} \u81f3\u5c11\u4fdd\u7559\u4e00\u4e2a\u8bc4\u4f30\u4eba\u3002", (String)"FlowHandlerDomainService_8", (String)"opmc-pbs-business", (Object[])args));
                continue;
            }
            vo.setSucess(true);
        }
        return ret;
    }

    protected List<DynamicObject> handTask(List<AssignHandlerDTO> dtos, Map<Long, DynamicObject> roleIdMap, List<DynamicObject> handlerTasks) {
        Set canHandTasksIds = handlerTasks.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
        Map markType = dtos.stream().filter(e -> 0 == e.getHandType() || (1 == e.getHandType() || 2 == e.getHandType()) && canHandTasksIds.contains(e.getTaskId())).collect(Collectors.groupingBy(AssignHandlerDTO::getHandType, Collectors.toList()));
        Map<Long, Boolean> manualopMap = this.getManualOpMapByRoles(roleIdMap.values());
        ArrayList<DynamicObject> retHandlerTask = new ArrayList<DynamicObject>(handlerTasks.size());
        Date date = new Date();
        long userId = UserServiceHelper.getCurrentUserId();
        for (Map.Entry entry : markType.entrySet()) {
            Map<Long, DynamicObject> handTaskMap;
            if (0 == entry.getKey()) {
                Map roleHanderMap = entry.getValue().stream().collect(Collectors.groupingBy(AssignHandlerDTO::getRoleId, Collectors.mapping(AssignHandlerDTO::getHandlerId, Collectors.toList())));
                for (Map.Entry entry2 : roleHanderMap.entrySet()) {
                    DynamicObject role = roleIdMap.get(entry2.getKey());
                    List<DynamicObject> tasks = FLOW_RU_TASK_ENTITY_SERVICE.generateTaskByRuRole(role, entry2.getValue(), false);
                    this.updateTaskStatus(tasks, manualopMap);
                    retHandlerTask.addAll(tasks);
                }
                continue;
            }
            if (1 == entry.getKey()) {
                handTaskMap = handlerTasks.stream().collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
                List<DynamicObject> tasks = entry.getValue().stream().map(e -> (DynamicObject)handTaskMap.get(e.getTaskId())).collect(Collectors.toList());
                this.updateTaskStatus(tasks, manualopMap);
                for (AssignHandlerDTO dto : entry.getValue()) {
                    DynamicObject task = handTaskMap.get(dto.getTaskId());
                    if (null == task) continue;
                    task.set("handler", (Object)dto.getHandlerId());
                    task.set("modifier", (Object)userId);
                    task.set("modifytime", (Object)date);
                    task.set("updatestatustime", (Object)date);
                    retHandlerTask.add(task);
                }
                continue;
            }
            if (2 != entry.getKey()) continue;
            handTaskMap = handlerTasks.stream().collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
            for (AssignHandlerDTO assignHandlerDTO : entry.getValue()) {
                DynamicObject task = handTaskMap.get(assignHandlerDTO.getTaskId());
                if (null == task) continue;
                task.set("taskstatus", (Object)FlowRuTaskStatusEnum.EXPIRED.getCode());
                task.set("modifier", (Object)userId);
                task.set("modifytime", (Object)date);
                task.set("updatestatustime", (Object)date);
                retHandlerTask.add(task);
            }
        }
        return retHandlerTask;
    }

    protected Map<Long, Boolean> getManualOpMapByRoles(Collection<DynamicObject> nodes) {
        if (CollectionUtils.isEmpty(nodes)) {
            return Collections.emptyMap();
        }
        List<Long> nodeDefIds = nodes.stream().map(e -> e.getLong("flowrunode.flownodedef_id")).collect(Collectors.toList());
        DynamicObject[] flowDefNodes = FLOW_DEF_NODE_ENTITY_SERVICE.getFlowDefNode(nodeDefIds);
        Map<Long, Boolean> manualop = Arrays.stream(flowDefNodes).collect(Collectors.toMap(k -> k.getLong("id"), v -> v.getBoolean("manualop")));
        return nodes.stream().collect(Collectors.toMap(k -> k.getLong("flowrunode_id"), v -> manualop.getOrDefault(v.getLong("flowrunode.flownodedef_id"), false), (a, b) -> a));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, Boolean> startProcessAfterWaiting(List<Long> taskIds) {
        if (taskIds.isEmpty()) {
            return Collections.emptyMap();
        }
        String selectFields = "id, taskstatus, updatestatustime, modifier, modifytime, flowrunode, handler_id, flowruproc,flowrunode.id,flowrurole.id";
        QFilter qFilter = new QFilter("id", "in", taskIds);
        qFilter.and("taskstatus", "=", (Object)FlowRuTaskStatusEnum.BE_WAITTING.getCode());
        DynamicObject[] tasks = FLOW_RU_TASK_ENTITY_SERVICE.query(selectFields, qFilter.toArray());
        if (0 == tasks.length) {
            return taskIds.stream().collect(Collectors.toMap(k -> k, v -> false));
        }
        Map<Long, Boolean> ret = taskIds.stream().collect(Collectors.toMap(k -> k, v -> false));
        try (TXHandle required = TX.required();){
            List<Long> handlerIds = Arrays.stream(tasks).map(e -> e.getLong("handler_id")).filter(e -> 0L < e).distinct().collect(Collectors.toList());
            Map<Long, Boolean> userEnable = this.batchQueryUserIsEnable(handlerIds);
            Map<Boolean, List<DynamicObject>> groupTasks = Arrays.stream(tasks).collect(Collectors.groupingBy(k -> userEnable.getOrDefault(k.getLong("handler_id"), false)));
            this.pendingByTasks(groupTasks.get(false));
            ret.putAll(this.startProcess(groupTasks.get(true)));
        }
        return ret;
    }

    protected Map<Long, Boolean> startProcess(List<DynamicObject> tasks) {
        if (CollectionUtils.isEmpty(tasks)) {
            return new HashMap<Long, Boolean>(0);
        }
        HashSet<Long> ruNodeSet = new HashSet<Long>(16);
        HashSet<Long> ruRoleSet = new HashSet<Long>(16);
        for (DynamicObject task : tasks) {
            ruNodeSet.add(task.getLong("flowrunode.id"));
            ruRoleSet.add(task.getLong("flowrurole.id"));
        }
        WorkflowUtils.updateTaskStatus(tasks, FlowRuTaskStatusEnum.WAITING.getCode());
        FLOW_RU_TASK_ENTITY_SERVICE.save(tasks.toArray(new DynamicObject[0]));
        DynamicObject[] unActivetasks = FLOW_RU_TASK_ENTITY_SERVICE.queryAllTaskByRoleIds(new ArrayList<Long>(ruRoleSet));
        HashSet<Long> unActiveRuRoleSet = new HashSet<Long>(16);
        HashSet<Long> unActiveRuNodSet = new HashSet<Long>(16);
        for (DynamicObject unActiveTask : unActivetasks) {
            unActiveRuRoleSet.add(unActiveTask.getLong("flowrurole.id"));
            unActiveRuNodSet.add(unActiveTask.getLong("flowrunode.id"));
        }
        ruRoleSet.removeAll(unActiveRuRoleSet);
        ruNodeSet.removeAll(unActiveRuNodSet);
        DynamicObject[] updateRuRoles = FLOW_RU_ROLE_ENTITY_SERVICE.queryByRuRoleIds(new ArrayList<Long>(ruRoleSet));
        WorkflowUtils.updateRoleStatus(updateRuRoles, FlowRuRoleStatusEnum.RUNNING.getCode());
        FLOW_RU_ROLE_ENTITY_SERVICE.save(updateRuRoles);
        DynamicObject[] updateRuNodes = FLOW_RU_NODE_ENTITY_SERVICE.queryByRuNodeIds(new ArrayList<Long>(ruNodeSet));
        WorkflowUtils.updateNodeStatus(updateRuNodes, FlowRuNodeStatusEnum.RUNNING.getCode());
        FLOW_RU_NODE_ENTITY_SERVICE.save(updateRuNodes);
        List<Long> taskIds = tasks.stream().map(e -> e.getLong("id")).collect(Collectors.toList());
        FlowMsgMergeEnumBO bo = this.getFlowRuMsgEnum(tasks.get(0));
        SendMessageDTO dto = new SendMessageDTO(taskIds, bo);
        FlowHandlerBatchDomainService FLOW_HANDLER_BATCH_DOMAIN_SERVICE = new FlowHandlerBatchDomainService();
        return FLOW_HANDLER_BATCH_DOMAIN_SERVICE.sendMessageMerge(Collections.singletonList(dto));
    }

    protected FlowMsgMergeEnumBO getFlowRuMsgEnum(DynamicObject task) {
        DynamicObject proc = FLOW_RU_PROC_ENTITY_SERVICE.queryRuProcByPk(task.getLong("flowruproc_id"));
        String flowType = proc.getString("workflowtype");
        FlowMsgMergeEnumBO ret = "1".equals(flowType) ? new FlowMsgMergeEnumBO(FlowRuMsgMergeEnum.START_FORMULATE_SIN, FlowRuMsgMergeEnum.START_FORMULATE_MUL) : new FlowMsgMergeEnumBO(FlowRuMsgMergeEnum.START_EVALUATE_SIN, FlowRuMsgMergeEnum.START_EVALUATE_MUL);
        return ret;
    }

    public Map<Long, ReminderVO> reminderProcess(List<Long> taskIds) {
        if (CollectionUtils.isEmpty(taskIds)) {
            return new HashMap<Long, ReminderVO>(0);
        }
        String properties = "id, taskstatus, updatestatustime, modifier, modifytime, flowrurole_id, flowrunode_id, flowruproc, handler,iscotask";
        QFilter qFilter = new QFilter("id", "in", taskIds);
        qFilter.or("hosttask.id", "in", taskIds);
        qFilter.and("taskstatus", "in", Arrays.asList(FlowRuTaskStatusEnum.WAITING.getCode(), FlowRuTaskStatusEnum.PROCESSING.getCode()));
        DynamicObject[] tasks = FLOW_RU_TASK_ENTITY_SERVICE.query(properties, qFilter.toArray());
        Map<Long, ReminderVO> msgMap = this.sendRemindMessage(tasks);
        return taskIds.stream().collect(Collectors.toMap(k -> k, v -> msgMap.getOrDefault(v, new ReminderVO((long)v, 1))));
    }

    private Map<Long, ReminderVO> sendRemindMessage(DynamicObject[] tasks) {
        List<DynamicObject> remindTasks;
        if (0 >= tasks.length) {
            return new HashMap<Long, ReminderVO>(0);
        }
        Map<Long, ReminderVO> ret = Arrays.stream(tasks).map(e -> e.getLong("id")).collect(Collectors.toMap(k -> k, v -> new ReminderVO((long)v, 1)));
        List<Long> handlerIds = Arrays.stream(tasks).map(e -> e.getLong("handler_id")).filter(e -> 0L < e).distinct().collect(Collectors.toList());
        Map<Long, Boolean> userEnable = this.batchQueryUserIsEnable(handlerIds);
        Map<Boolean, List<DynamicObject>> groupTasks = Arrays.stream(tasks).collect(Collectors.groupingBy(k -> userEnable.getOrDefault(k.getLong("handler_id"), false)));
        List<DynamicObject> pendingTasks = groupTasks.get(false);
        this.pendingByTasks(pendingTasks);
        if (!CollectionUtils.isEmpty(pendingTasks)) {
            for (DynamicObject pendingTask : pendingTasks) {
                ret.get(pendingTask.getLong("id")).setErrorType((short)2);
            }
        }
        if (!CollectionUtils.isEmpty(remindTasks = groupTasks.get(true))) {
            List<DynamicObject> mainRemindTaskList = remindTasks.stream().filter(e -> !e.getBoolean("iscotask")).collect(Collectors.toList());
            List<DynamicObject> coopRemindTaskList = remindTasks.stream().filter(e -> e.getBoolean("iscotask")).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(mainRemindTaskList)) {
                this.sendRemindMessage(mainRemindTaskList, ret);
            }
            if (!CollectionUtils.isEmpty(coopRemindTaskList)) {
                this.sendRemindMessage(coopRemindTaskList, ret);
            }
        }
        return ret;
    }

    protected void sendRemindMessage(List<DynamicObject> remindTasks, Map<Long, ReminderVO> ret) {
        List<Long> taskIds = remindTasks.stream().map(e -> e.getLong("id")).collect(Collectors.toList());
        FlowMsgMergeEnumBO bo = this.getReminderFlowRuMsgEnum(remindTasks.get(0));
        SendMessageDTO dto = new SendMessageDTO(taskIds, bo);
        dto.setCotaskSendMsg(Boolean.TRUE);
        FlowHandlerBatchDomainService FLOW_HANDLER_BATCH_DOMAIN_SERVICE = new FlowHandlerBatchDomainService();
        Map<Long, Boolean> msgResMap = FLOW_HANDLER_BATCH_DOMAIN_SERVICE.sendMessageMerge(Collections.singletonList(dto));
        for (Map.Entry<Long, Boolean> entry : msgResMap.entrySet()) {
            ret.get(entry.getKey()).setErrorType(entry.getValue() != false ? (short)0 : 1);
        }
    }

    public Map<Long, Boolean> reminderProcessByActevalObj(List<Long> actevalObjIds) {
        if (CollectionUtils.isEmpty(actevalObjIds)) {
            return new HashMap<Long, Boolean>(0);
        }
        DynamicObject[] procs = FLOW_RU_PROC_ENTITY_SERVICE.queryRunProcByEvaObjIds(actevalObjIds);
        if (0 >= procs.length) {
            return new HashMap<Long, Boolean>(0);
        }
        String properties = "id, taskstatus, updatestatustime, modifier, modifytime, flowrurole_id, flowrunode_id, flowruproc, handler";
        Map<Long, Long> procObjMap = Arrays.stream(procs).collect(Collectors.toMap(k -> k.getLong("id"), v -> v.getLong("actevalobj")));
        QFilter qFilter = new QFilter("flowruproc_id", "in", procObjMap.keySet());
        qFilter.and("taskstatus", "in", Arrays.asList(FlowRuTaskStatusEnum.WAITING.getCode(), FlowRuTaskStatusEnum.PROCESSING.getCode()));
        DynamicObject[] tasks = FLOW_RU_TASK_ENTITY_SERVICE.query(properties, qFilter.toArray());
        Map<Long, ReminderVO> sendResult = this.sendRemindMessage(tasks);
        Set successTaskIds = sendResult.entrySet().stream().filter(e -> ((ReminderVO)e.getValue()).isSucess()).map(Map.Entry::getKey).collect(Collectors.toSet());
        Set successProcIds = Arrays.stream(tasks).filter(e -> successTaskIds.contains(e.getLong("id"))).map(e -> e.getLong("flowruproc_id")).collect(Collectors.toSet());
        Map<Long, Boolean> sucessRet = successProcIds.stream().collect(Collectors.toMap(procObjMap::get, v -> true));
        return actevalObjIds.stream().collect(Collectors.toMap(k -> k, v -> sucessRet.getOrDefault(v, false)));
    }

    protected FlowMsgMergeEnumBO getReminderFlowRuMsgEnum(DynamicObject task) {
        DynamicObject flowruProc = task.getDynamicObject("flowruproc");
        String workFlowType = flowruProc.getString("workflowtype");
        FlowMsgMergeEnumBO ret = new FlowMsgMergeEnumBO();
        switch (workFlowType) {
            case "1": {
                ret.setSingle(FlowRuMsgMergeEnum.URG_FORMULATE_SIN);
                ret.setMultiple(FlowRuMsgMergeEnum.URG_FORMULATE_MUL);
                break;
            }
            case "2": {
                ret.setSingle(FlowRuMsgMergeEnum.URG_EVALUATE_SIN);
                ret.setMultiple(FlowRuMsgMergeEnum.URG_EVALUATE_MUL);
                break;
            }
            case "3": {
                ret.setSingle(FlowRuMsgMergeEnum.URG_INTERVIEW_SIN);
                ret.setMultiple(FlowRuMsgMergeEnum.URG_INTERVIEW_MUL);
                break;
            }
        }
        return ret;
    }

    public void pendingByTasks(List<DynamicObject> tasks) {
        if (CollectionUtils.isEmpty(tasks)) {
            return;
        }
        WorkflowUtils.updateTaskStatus(tasks, FlowRuTaskStatusEnum.PENDING.getCode());
        FLOW_RU_TASK_ENTITY_SERVICE.save(tasks.toArray(new DynamicObject[0]));
        List<Long> roleIds = tasks.stream().map(e -> e.getLong("flowrurole_id")).distinct().collect(Collectors.toList());
        DynamicObject[] roles = FLOW_RU_ROLE_ENTITY_SERVICE.queryByRuRoleIds(roleIds);
        WorkflowUtils.updateRoleStatus(roles, FlowRuRoleStatusEnum.PENDING.getCode());
        FLOW_RU_ROLE_ENTITY_SERVICE.save(roles);
        List<Long> nodeIds = tasks.stream().map(e -> e.getLong("flowrunode_id")).distinct().collect(Collectors.toList());
        DynamicObject[] nodes = FLOW_RU_NODE_ENTITY_SERVICE.queryByRuNodeIds(nodeIds);
        WorkflowUtils.updateNodeStatus(nodes, FlowRuNodeStatusEnum.PENDING.getCode());
        FLOW_RU_NODE_ENTITY_SERVICE.save(nodes);
        List<Long> procIds = tasks.stream().map(e -> e.getLong("flowruproc_id")).distinct().collect(Collectors.toList());
        DynamicObject[] procs = FLOW_RU_PROC_ENTITY_SERVICE.queryProcByPkIds(procIds);
        WorkflowUtils.updateProcStatus(procs, FlowRuProcStatusEnum.PENDING.getCode());
        FLOW_RU_PROC_ENTITY_SERVICE.save(procs);
        for (DynamicObject aProc : procs) {
            if (HRStringUtils.equals((String)"3", (String)aProc.getString("workflowtype"))) continue;
            this.sendPendingMsg(aProc);
        }
    }

    protected void sendPendingMsg(DynamicObject ruProc) {
        Map<Object, Object> objPerffileNames = Maps.newHashMapWithExpectedSize((int)1);
        HashMap urlParams = Maps.newHashMapWithExpectedSize((int)2);
        DynamicObject[] workflows = WorkFlowEntityService.getInstance().getWorkFlowsByDefProcId(new HashSet<Long>(Collections.singleton(ruProc.getLong("defproc.id"))));
        urlParams.put("formId", "pbs_flowrumonitor");
        urlParams.put("pkId", ruProc.getPkValue().toString());
        long userId = ruProc.getLong("creator_id");
        objPerffileNames = HRStringUtils.equals((String)ruProc.getString("workflowtype"), (String)"3") ? EPA_ACTEVAOBJ_SERVICE.queryInterViewObjPerffileNamesByObjIds(Collections.singletonList(ruProc.getLong("actevalobj"))) : EPA_ACTEVAOBJ_SERVICE.queryActEvalObjPerffileNamesByObjIds(Collections.singletonList(ruProc.getLong("actevalobj")));
        if (userId == 0L) {
            userId = ruProc.getLong("creator");
        }
        urlParams.put("actevalobj", HRStringUtils.isEmpty((String)((String)objPerffileNames.get(ruProc.getLong("actevalobj")))) ? "" : (String)objPerffileNames.get(ruProc.getLong("actevalobj")));
        urlParams.put("procname", HRStringUtils.isEmpty((String)((String)objPerffileNames.get(ruProc.getLong("actevalobj")))) ? "" : (String)objPerffileNames.get(ruProc.getLong("actevalobj")) + (workflows.length != 0 ? workflows[0].getString("name") : ruProc.getString("defproc.name")));
        MERGE_MSG_SEND_SERVICE.sendMessageWithUrl(FlowRuMsgEnum.PENDING.getTemplateId(), Collections.singletonList(userId), ruProc, urlParams, FlowRuMsgEnum.PENDING.getTag());
    }

    public Map<Long, DynamicObject> queryEvalIdsByTaskIds(List<Long> taskIds) {
        if (CollectionUtils.isEmpty(taskIds)) {
            return new HashMap<Long, DynamicObject>(0);
        }
        String properties = "id, taskstatus, updatestatustime, flowruproc,handler.name,handler.number";
        QFilter qFilter = new QFilter("id", "in", taskIds);
        qFilter.and("taskstatus", "in", this.getCanTaskStatus());
        DynamicObject[] tasks = FLOW_RU_TASK_ENTITY_SERVICE.query(properties, qFilter.toArray());
        Map<Long, DynamicObject> ret = Arrays.stream(tasks).collect(Collectors.toMap(task -> task.getLong("id"), task -> task));
        return ret;
    }

    private Map<Long, List<Long>> getResponsibleHandler(HandlerParamsBo handerParamsBo) {
        return this.getUserIdsByRoleType(handerParamsBo, RoleTypeConstants.ASSESSMENT_RESPONSIBLE_PERSON);
    }

    private Map<Long, List<Long>> getEvaActivityCreator(HandlerParamsBo handerParamsBo) {
        return this.getUserIdsByRoleType(handerParamsBo, RoleTypeConstants.ASSESSMENT_ACTIVITY_CREATOR);
    }

    private Map<Long, List<Long>> getEvaSchemaCreator(HandlerParamsBo handerParamsBo) {
        return this.getUserIdsByRoleType(handerParamsBo, RoleTypeConstants.ASSESSMENT_PLAN_CREATOR);
    }

    private Map<Long, List<Long>> getUserIdsByRoleType(HandlerParamsBo handerParamsBo, Long roleTypeId) {
        HashMap<Long, List<Long>> handlerMap = new HashMap<Long, List<Long>>(16);
        DynamicObject[] ruProcDyns = handerParamsBo.getRuProcDyns();
        if (null == ruProcDyns || ruProcDyns.length < 1) {
            ruProcDyns = FLOW_RU_PROC_ENTITY_SERVICE.queryProcByPkIds(handerParamsBo.getFlowRuProcIds());
        }
        LOG.info("\u3010OPMC\u3011-getUserIdsByRoleType,ruProcDyns is[{}],roleTypeId is: {} ", (Object)SerializationUtils.toJsonString((Object)ruProcDyns), (Object)roleTypeId);
        HashMap<Long, Long> procActevaObjMap = new HashMap<Long, Long>(16);
        ArrayList<Long> actevaObjIdList = new ArrayList<Long>(10);
        ArrayList<Long> interObjIdList = new ArrayList<Long>(10);
        for (DynamicObject ruProcTmp : ruProcDyns) {
            if (!"3".equals(ruProcTmp.getString("workflowtype"))) continue;
            interObjIdList.add(ruProcTmp.getLong("actevalobj"));
        }
        DynamicObject[] interviewObjArr = IEPAActevalobjService.getInstance().getIntObjArrayById(interObjIdList);
        Map<Long, Long> interviewActevaObjMap = Arrays.stream(interviewObjArr).collect(Collectors.toMap(k -> k.getLong("id"), v -> v.getLong("evalobj.id")));
        for (DynamicObject ruProc : ruProcDyns) {
            if ("3".equals(ruProc.getString("workflowtype"))) {
                procActevaObjMap.put(interviewActevaObjMap.get(ruProc.getLong("actevalobj")), ruProc.getLong("id"));
                actevaObjIdList.add(interviewActevaObjMap.get(ruProc.getLong("actevalobj")));
            } else {
                procActevaObjMap.put(ruProc.getLong("actevalobj"), ruProc.getLong("id"));
                actevaObjIdList.add(ruProc.getLong("actevalobj"));
            }
            LOG.info("invoke getUserIdsByRoleType,actevaobj is[{}],roleTypeId is [{}]", (Object)ruProc.getLong("actevalobj"), (Object)roleTypeId);
        }
        RoleTypeCustomPo roleTypeCustomPo = new RoleTypeCustomPo();
        roleTypeCustomPo.setActevalobjIdList(actevaObjIdList);
        Map<Long, List<Long>> evaObjPersonMap = EPA_ROLETYPE_SERVICE.getUserIdByRoleTypeId(roleTypeId, roleTypeCustomPo);
        for (Map.Entry<Long, List<Long>> entry : evaObjPersonMap.entrySet()) {
            LOG.info("invoke getUserIdByRoleTypeId,result key is :" + entry.getKey() + ",value is :" + entry.getValue());
            handlerMap.put((Long)procActevaObjMap.get(entry.getKey()), entry.getValue());
        }
        LOG.info("invoke getUserIdByRoleTypeId,handlerMap is :" + ((Object)handlerMap).toString());
        return handlerMap;
    }

    private Map<Long, List<Long>> getAppointPosHandler(HandlerParamsBo handerParamsBo) {
        HashMap<Long, List<Long>> handlerMap = new HashMap<Long, List<Long>>(16);
        DynamicObject[] ruProcDyns = handerParamsBo.getRuProcDyns();
        if (null == ruProcDyns || ruProcDyns.length < 1) {
            ruProcDyns = FLOW_RU_PROC_ENTITY_SERVICE.queryProcByPkIds(handerParamsBo.getFlowRuProcIds());
        }
        long posId = 0L;
        if (handerParamsBo.isReplace()) {
            DynamicObject defNode = handerParamsBo.getFlowDefNode();
            posId = defNode.getLong("appointemp");
        } else {
            DynamicObject flowDefRole = handerParamsBo.getFlowDefRole();
            posId = flowDefRole.getLong("secondf7");
        }
        Map<Long, Set<Long>> posPersonMap = PERSON_SERVICE.getAllUsersOfPosition("1", Collections.singletonList(posId));
        ArrayList<Long> allPersonIdList = new ArrayList<Long>(10);
        for (Map.Entry<Long, Set<Long>> personEntry : posPersonMap.entrySet()) {
            allPersonIdList.addAll((Collection<Long>)personEntry.getValue());
        }
        Map<Long, Long> personUserMap = this.getUserIdsByPersonIds(allPersonIdList);
        ArrayList<Long> userIdList = new ArrayList<Long>(10);
        for (Map.Entry<Long, Long> entry : personUserMap.entrySet()) {
            userIdList.add(entry.getValue());
        }
        handlerMap.put(ruProcDyns[0].getLong("id"), userIdList);
        return handlerMap;
    }

    private Map<Long, List<Long>> getAppointPosMultiHandler(HandlerParamsBo handerParamsBo) {
        List<Long> posIds;
        HashMap<Long, List<Long>> handlerMap = new HashMap<Long, List<Long>>(16);
        DynamicObject[] ruProcDyns = handerParamsBo.getRuProcDyns();
        if (null == ruProcDyns || ruProcDyns.length < 1) {
            ruProcDyns = FLOW_RU_PROC_ENTITY_SERVICE.queryProcByPkIds(handerParamsBo.getFlowRuProcIds());
        }
        if (handerParamsBo.isReplace()) {
            DynamicObject defNode = handerParamsBo.getFlowDefNode();
            posIds = this.getSecondF7Ids(defNode, "postentry", "post", "appointemp");
        } else {
            DynamicObject flowDefRole = handerParamsBo.getFlowDefRole();
            posIds = this.getSecondF7Ids(flowDefRole, "postentry", "post", "secondf7");
        }
        Map<Long, Set<Long>> posPersonMap = PERSON_SERVICE.getAllUsersOfPosition("1", posIds);
        ArrayList<Long> allPersonIdList = new ArrayList<Long>(10);
        for (Map.Entry<Long, Set<Long>> personEntry : posPersonMap.entrySet()) {
            allPersonIdList.addAll((Collection<Long>)personEntry.getValue());
        }
        Map<Long, Long> personUserMap = this.getUserIdsByPersonIds(allPersonIdList);
        ArrayList<Long> userIdList = new ArrayList<Long>(10);
        for (Map.Entry<Long, Long> entry : personUserMap.entrySet()) {
            userIdList.add(entry.getValue());
        }
        handlerMap.put(ruProcDyns[0].getLong("id"), userIdList);
        return handlerMap;
    }

    private Map<Long, List<Long>> getAppointAdminOrgHandler(HandlerParamsBo handerParamsBo) {
        HashMap<Long, List<Long>> handlerMap = new HashMap<Long, List<Long>>(16);
        DynamicObject[] ruProcDyns = handerParamsBo.getRuProcDyns();
        if (null == ruProcDyns || ruProcDyns.length < 1) {
            ruProcDyns = FLOW_RU_PROC_ENTITY_SERVICE.queryProcByPkIds(handerParamsBo.getFlowRuProcIds());
        }
        long adminOrgId = 0L;
        if (handerParamsBo.isReplace()) {
            DynamicObject defNode = handerParamsBo.getFlowDefNode();
            adminOrgId = defNode.getLong("appointemp");
        } else {
            DynamicObject flowDefRole = handerParamsBo.getFlowDefRole();
            adminOrgId = flowDefRole.getLong("secondf7");
        }
        List<Object> orgPersonList = new ArrayList(10);
        try {
            orgPersonList = WORK_ROLE_SERVICE.getMainChargeInfoByOrg(Collections.singletonList(adminOrgId));
        }
        catch (Exception e) {
            LOG.error("\u3010OPMC\u3011-getAppointAdminOrgHandler error.", (Throwable)e);
        }
        HashSet<Long> allPersonIdSet = new HashSet<Long>(16);
        for (Map map : orgPersonList) {
            allPersonIdSet.add((Long)map.get("person"));
        }
        List<Long> pIdList = allPersonIdSet.stream().collect(Collectors.toList());
        Map<Long, Long> map = this.getUserIdsByPersonIds(pIdList);
        ArrayList<Long> userIdList = new ArrayList<Long>(10);
        for (Map.Entry<Long, Long> entry : map.entrySet()) {
            userIdList.add(entry.getValue());
        }
        LOG.info("\u3010OPMC\u3011-getAppointAdminOrgHandler,userIdList : {}", (Object)((Object)userIdList).toString());
        handlerMap.put(ruProcDyns[0].getLong("id"), userIdList);
        return handlerMap;
    }

    protected Map<Long, List<Long>> dealUserEffectiveAndRemoveDuplicate(Map<Long, List<Long>> handlerMap) {
        HashMap<Long, List<Long>> resultMap = new HashMap<Long, List<Long>>(16);
        if (handlerMap.isEmpty()) {
            return resultMap;
        }
        for (Map.Entry<Long, List<Long>> entry : handlerMap.entrySet()) {
            List<Long> userList = entry.getValue();
            if (CollectionUtils.isEmpty(userList)) continue;
            HashSet<Long> userSet = new HashSet<Long>(16);
            ArrayList<Long> userTmpList = new ArrayList<Long>(10);
            for (Long userId : userList) {
                if (null == userId) continue;
                userTmpList.add(userId);
            }
            Map<Long, Boolean> userEnableMap = this.batchQueryUserIsEnable(userTmpList);
            for (Map.Entry<Long, Boolean> userEntry : userEnableMap.entrySet()) {
                if (!userEntry.getValue().booleanValue()) continue;
                userSet.add(userEntry.getKey());
            }
            if (CollectionUtils.isEmpty(userSet)) continue;
            resultMap.put(entry.getKey(), new ArrayList(userSet));
        }
        return resultMap;
    }

    public Map<Long, String> getActEvaObjProcessInfo(List<Long> procIdList) {
        DynamicObject[] ruprocDyns = FLOW_RU_PROC_ENTITY_SERVICE.queryProcByPkIds(procIdList);
        if (null == procIdList || procIdList.isEmpty()) {
            return new HashMap<Long, String>(16);
        }
        procIdList = Arrays.stream(ruprocDyns).filter(e -> !e.getString("procstatus").equals(FlowRuProcStatusEnum.DEPRECATED.getCode())).map(rp -> rp.getLong("id")).collect(Collectors.toList());
        HashMap<Long, String> processMap = new HashMap<Long, String>(procIdList.size());
        QFilter ruNodeFilter = new QFilter("flowruproc", "in", procIdList);
        DynamicObject[] ruNodeDyns = FLOW_RU_NODE_ENTITY_SERVICE.queryOriginalArray("id,name,flowruproc.id,iscrossnode,flowruproc.actevalobj,flownodedef.id,nodestatus", new QFilter[]{ruNodeFilter}, "index ASC");
        List ruNodeIdList = Arrays.stream(ruNodeDyns).filter(e -> !e.getString("nodestatus").equals(FlowRuNodeStatusEnum.EXPIRED.getCode())).map(v -> v.getLong("id")).collect(Collectors.toList());
        Map procNodeMap = Arrays.stream(ruNodeDyns).collect(Collectors.groupingBy(e -> e.getLong("flowruproc.id"), Collectors.mapping(e -> e.getLong("id"), Collectors.toList())));
        Map<Long, String> ruNodeMap = Arrays.stream(ruNodeDyns).collect(Collectors.toMap(k -> k.getLong("id"), v -> v.getString("name")));
        Map<Long, DynamicObject> ruNodeDynMap = Arrays.stream(ruNodeDyns).collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
        List<DynamicObject> crossRunodeList = Arrays.stream(ruNodeDyns).filter(e -> e.getBoolean("iscrossnode")).collect(Collectors.toList());
        Map<Long, List<DynamicObject>> crossRuNodeHandlerMap = CROSS_SCORE_DOMAIN_SERVICE.queryCrossNodeHandlerByRuNodes(crossRunodeList);
        QFilter ruRoleFilter = new QFilter("flowrunode", "in", ruNodeIdList);
        DynamicObject[] ruRoleDyns = FLOW_RU_ROLE_ENTITY_SERVICE.queryOriginalArray("id,flowrunode.id", new QFilter[]{ruRoleFilter});
        List<Long> ruRoleIdList = Arrays.stream(ruRoleDyns).map(v -> v.getLong("id")).collect(Collectors.toList());
        Map ruNodeRoleMap = Arrays.stream(ruRoleDyns).collect(Collectors.groupingBy(e -> e.getLong("flowrunode.id"), Collectors.mapping(e -> e.getLong("id"), Collectors.toList())));
        Map<Long, List<DynamicObject>> roleHandlerMap = this.queryHandlerByRuleIds(ruRoleIdList);
        for (Map.Entry procNodeEntry : procNodeMap.entrySet()) {
            List nodeIdList = procNodeEntry.getValue();
            StringBuilder processInfoSb = new StringBuilder();
            int nodeSize = nodeIdList.size();
            for (int k2 = 0; k2 < nodeSize; ++k2) {
                processInfoSb.append(ruNodeMap.get(nodeIdList.get(k2)));
                processInfoSb.append("\uff08");
                if (ruNodeDynMap.get(nodeIdList.get(k2)).getBoolean("iscrossnode")) {
                    List<DynamicObject> crossNodeHandlerList = crossRuNodeHandlerMap.get(nodeIdList.get(k2));
                    if (!CollectionUtils.isEmpty(crossNodeHandlerList)) {
                        int crossHandlerSize = crossNodeHandlerList.size();
                        for (int ci = 0; ci < crossHandlerSize; ++ci) {
                            if (ci == 0) {
                                if (null == crossNodeHandlerList.get(ci) || null == crossNodeHandlerList.get(ci).getString("name")) continue;
                                processInfoSb.append(crossNodeHandlerList.get(ci).getString("name"));
                                continue;
                            }
                            if (null == crossNodeHandlerList.get(ci) || null == crossNodeHandlerList.get(ci).getString("name")) continue;
                            processInfoSb.append("\uff0c").append(crossNodeHandlerList.get(ci).getString("name"));
                        }
                    }
                } else {
                    List roleIdList = ruNodeRoleMap.get(nodeIdList.get(k2));
                    if (CollectionUtils.isEmpty(roleIdList)) {
                        if (k2 < nodeSize - 1) {
                            processInfoSb.append("\uff09->");
                            continue;
                        }
                        processInfoSb.append("\uff09");
                        continue;
                    }
                    int roleSize = roleIdList.size();
                    if (roleSize > 0) {
                        for (int i = 0; i < roleSize; ++i) {
                            int handlerSize;
                            List<DynamicObject> handlerList = roleHandlerMap.get(roleIdList.get(i));
                            if (CollectionUtils.isEmpty(handlerList) || (handlerSize = handlerList.size()) <= 0) continue;
                            for (int j = 0; j < handlerSize; ++j) {
                                if (null == handlerList.get(j)) continue;
                                if (i == 0 && j == 0) {
                                    processInfoSb.append(handlerList.get(j).getString("name"));
                                    continue;
                                }
                                processInfoSb.append("\uff0c").append(handlerList.get(j).getString("name"));
                            }
                        }
                    }
                }
                if (k2 < nodeSize - 1) {
                    processInfoSb.append("\uff09->");
                    continue;
                }
                processInfoSb.append("\uff09");
            }
            processMap.put(procNodeEntry.getKey(), processInfoSb.toString());
        }
        return processMap;
    }

    private List<Long> getSecondF7Ids(DynamicObject defNodeOrDefRoleObj, String entryProperty, String multiProperty, String singleProperty) {
        DynamicObjectCollection secondF7Objs = defNodeOrDefRoleObj.getDynamicObjectCollection(entryProperty);
        if (secondF7Objs.size() > 0) {
            return secondF7Objs.stream().filter(secondF7IdObj -> !HRObjectUtils.isEmpty((Object)secondF7IdObj.getDynamicObject(multiProperty))).map(secondF7IdObj -> secondF7IdObj.getDynamicObject(multiProperty).getLong("id")).collect(Collectors.toList());
        }
        return Collections.singletonList(defNodeOrDefRoleObj.getLong(singleProperty));
    }

    static {
        THREAD_POOL = ThreadPools.newCachedThreadPool((String)"FlowHandlerDomainService#&", (int)2, (int)6);
        SEMAPHORE = new Semaphore(6);
    }
}

