/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.pbs.business.domain.workflow.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.opmc.pbs.business.ServiceFactory;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowRuNodeEntityService;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowRuRoleEntityService;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowRuTaskEntityService;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuTaskStatusEnum;
import kd.opmc.pbs.business.external.epa.IEPAAssessActivityService;

public class FlowRuMonitorDomainService {
    private static final FlowRuNodeEntityService FLOW_RU_NODE_ENTITY_SERVICE = FlowRuNodeEntityService.getInstance();
    private static final FlowRuRoleEntityService FLOW_RU_ROLE_ENTITY_SERVICE = FlowRuRoleEntityService.getInstance();
    private static final FlowRuTaskEntityService FLOW_RU_TASK_ENTITY_SERVICE = FlowRuTaskEntityService.getInstance();
    private static final IEPAAssessActivityService EPA_ASSESS_ACTIVITY_SERVICE = IEPAAssessActivityService.getInstance();
    private static final Log LOG = LogFactory.getLog(FlowRuMonitorDomainService.class);

    public static FlowRuMonitorDomainService getInstance() {
        return ServiceFactory.getService(FlowRuMonitorDomainService.class);
    }

    public Map<Long, String> queryActivityNameByIds(List<Long> ids) {
        return EPA_ASSESS_ACTIVITY_SERVICE.queryActivityNameByIds(ids);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSet queryFlowNodeReportDataSet(Long procRuId) {
        Object[] dynamicObjects = FLOW_RU_NODE_ENTITY_SERVICE.queryOriginalArray("id", new QFilter[]{new QFilter("flowruproc", "=", (Object)procRuId)});
        List<Object> ids = new ArrayList(16);
        if (HRArrayUtils.isNotEmpty((Object[])dynamicObjects)) {
            ids = Arrays.stream(dynamicObjects).map(dyc -> dyc.getLong("id")).collect(Collectors.toList());
        }
        LOG.info("=======================flowrunode filter:{}=================", ids);
        try (DataSet nodeRuntime = null;){
            QFilter[] qFilterArray;
            nodeRuntime = FLOW_RU_NODE_ENTITY_SERVICE.queryDataSet("pbs_flowrunode", "id as runodebasedata, name as nodename, nodeweight, nodestatus, index, iscrossnode", new QFilter[]{new QFilter("flowruproc", "=", (Object)procRuId)}, "index");
            if (ids.isEmpty()) {
                qFilterArray = null;
            } else {
                QFilter[] qFilterArray2 = new QFilter[1];
                qFilterArray = qFilterArray2;
                qFilterArray2[0] = new QFilter("flowrunode", "in", ids);
            }
            DataSet dataSet = nodeRuntime.leftJoin(FLOW_RU_ROLE_ENTITY_SERVICE.queryDataSet("pbs_flowrurole", "id as rurolebasedata, roletype, roleweight, rolestatus, flowrunode", qFilterArray, "turnoversort")).on("runodebasedata", "flowrunode").select(new String[]{"runodebasedata", "nodename", "nodestatus", "nodeweight", "iscrossnode", "roleweight", "rurolebasedata", "roletype", "rolestatus"}).finish();
            return dataSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSet queryFlowRuntimeReportDataSet(Long procRuId) {
        DataSet nodeRuntime = null;
        DataSet roleRuntime = null;
        try {
            nodeRuntime = FLOW_RU_NODE_ENTITY_SERVICE.queryDataSet("pbs_flowrunode", "id as runodebasedata, name as nodename, nodeweight, nodestatus, index, iscrossnode", new QFilter[]{new QFilter("flowruproc", "=", (Object)procRuId)}, "index");
            roleRuntime = nodeRuntime.leftJoin(FLOW_RU_ROLE_ENTITY_SERVICE.queryDataSet("pbs_flowrurole", "id as rurolebasedata, name, roletype, roleweight, rolestatus, flowrunode", new QFilter[]{new QFilter("flowruproc", "=", (Object)procRuId)}, "turnoversort")).on("runodebasedata", "flowrunode").select(new String[]{"runodebasedata", "nodename", "nodestatus", "nodeweight", "iscrossnode", "roleweight", "rurolebasedata", "roletype", "rolestatus"}).finish();
            DataSet dataSet = roleRuntime.leftJoin(FLOW_RU_TASK_ENTITY_SERVICE.queryDataSet("pbs_flowrutask", "id as rutaskbasedata, handler as taskhandler, taskstatus, updatestatustime, flowrurole,iscotask,hosttask.id", new QFilter[]{new QFilter("iscotask", "!=", (Object)"1")}, "taskstatus")).on("rurolebasedata", "flowrurole").select(new String[]{"runodebasedata", "nodename", "nodestatus", "nodeweight", "iscrossnode", "rurolebasedata", "roletype", "rolestatus", "roleweight", "rutaskbasedata", "taskhandler", "taskstatus", "updatestatustime", "iscotask", "hosttask.id"}).finish();
            return dataSet;
        }
        finally {
            if (nodeRuntime != null) {
                nodeRuntime.close();
            }
            if (roleRuntime != null) {
                roleRuntime.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSet queryFlowRuntimeNodeReportDataSet(Long nodeRuId) {
        DataSet nodeRuntime = null;
        DataSet roleRuntime = null;
        try {
            nodeRuntime = FLOW_RU_NODE_ENTITY_SERVICE.queryDataSet("pbs_flowrunode", "id as runodebasedata, name as nodename, nodeweight, nodestatus, index, iscrossnode", new QFilter[]{new QFilter("id", "=", (Object)nodeRuId)}, "index");
            roleRuntime = nodeRuntime.leftJoin(FLOW_RU_ROLE_ENTITY_SERVICE.queryDataSet("pbs_flowrurole", "id as rurolebasedata, name, roletype, roleweight, rolestatus, turnoversort, flowrunode", new QFilter[]{new QFilter("flowrunode.id", "=", (Object)nodeRuId)}, "turnoversort")).on("runodebasedata", "flowrunode").select(new String[]{"runodebasedata", "nodename", "nodestatus", "nodeweight", "iscrossnode", "roleweight", "rurolebasedata", "roletype", "rolestatus", "turnoversort"}).finish();
            DataSet dataSet = roleRuntime.leftJoin(FLOW_RU_TASK_ENTITY_SERVICE.queryDataSet("pbs_flowrutask", "id as rutaskbasedata, handler as taskhandler, taskstatus, updatestatustime, flowrurole", new QFilter[]{new QFilter("iscotask", "!=", (Object)"1")}, "taskstatus")).on("rurolebasedata", "flowrurole").select(new String[]{"runodebasedata", "nodename", "nodestatus", "nodeweight", "iscrossnode", "rurolebasedata", "roletype", "rolestatus", "roleweight", "turnoversort", "rutaskbasedata", "taskhandler", "taskstatus", "updatestatustime"}).finish();
            return dataSet;
        }
        finally {
            if (nodeRuntime != null) {
                nodeRuntime.close();
            }
            if (roleRuntime != null) {
                roleRuntime.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSet queryFlowTaskReportDataSet(Long procRuId) {
        Object[] dynamicObjects = FLOW_RU_NODE_ENTITY_SERVICE.queryOriginalArray("id", new QFilter[]{new QFilter("flowruproc", "=", (Object)procRuId)});
        List<Object> ids = new ArrayList(16);
        if (HRArrayUtils.isNotEmpty((Object[])dynamicObjects)) {
            ids = Arrays.stream(dynamicObjects).map(dyc -> dyc.getLong("id")).collect(Collectors.toList());
        }
        LOG.info("=======================flowrunode filter:{}=================", ids);
        DataSet nodeRuntime = null;
        DataSet roleRuntime = null;
        try {
            QFilter[] qFilterArray;
            nodeRuntime = FLOW_RU_NODE_ENTITY_SERVICE.queryDataSet("pbs_flowrunode", "id as runodebasedata, name as nodename, nodeweight, nodestatus, index, iscrossnode", new QFilter[]{new QFilter("flowruproc", "=", (Object)procRuId)}, "index");
            if (ids.isEmpty()) {
                qFilterArray = null;
            } else {
                QFilter[] qFilterArray2 = new QFilter[1];
                qFilterArray = qFilterArray2;
                qFilterArray2[0] = new QFilter("flowrunode", "in", ids);
            }
            roleRuntime = nodeRuntime.leftJoin(FLOW_RU_ROLE_ENTITY_SERVICE.queryDataSet("pbs_flowrurole", "id as rurolebasedata, name, roletype, roleweight, rolestatus, flowrunode", qFilterArray, "turnoversort")).on("runodebasedata", "flowrunode").select(new String[]{"runodebasedata", "nodename", "nodestatus", "nodeweight", "iscrossnode", "roleweight", "rurolebasedata", "roletype", "rolestatus"}).finish();
            DataSet dataSet = roleRuntime.leftJoin(FLOW_RU_TASK_ENTITY_SERVICE.queryDataSet("pbs_flowrutask", "id as rutaskbasedata, handler as taskhandler, taskstatus, updatestatustime, flowrurole", new QFilter[]{new QFilter("taskstatus", "!=", (Object)FlowRuTaskStatusEnum.EXPIRED.getCode())}, "taskstatus")).on("rurolebasedata", "flowrurole").select(new String[]{"runodebasedata", "nodename", "nodestatus", "nodeweight", "iscrossnode", "rurolebasedata", "roletype", "rolestatus", "roleweight", "rutaskbasedata", "taskhandler", "taskstatus", "updatestatustime"}).finish();
            return dataSet;
        }
        finally {
            if (nodeRuntime != null) {
                nodeRuntime.close();
            }
            if (roleRuntime != null) {
                roleRuntime.close();
            }
        }
    }
}

