/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.pbs.business.domain.workflow.service;

import com.bes.mq.util.CollectionUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.pbs.business.ServiceFactory;
import kd.opmc.pbs.business.domain.workflow.entity.FlowRuProcBo;
import kd.opmc.pbs.business.domain.workflow.entity.FlowRuResultBo;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowDefProcEntityService;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowRuNodeEntityService;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowRuProcEntityService;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowRuRoleEntityService;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowRuTaskEntityService;
import kd.opmc.pbs.business.domain.workflow.entityservice.WorkFlowEntityService;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuNodeStatusEnum;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuRoleStatusEnum;
import kd.opmc.pbs.business.domain.workflow.service.FlowBatchHandlerDomainService;
import kd.opmc.pbs.business.domain.workflow.service.FlowRuProcDomainService;
import kd.opmc.pbs.common.constants.WorkFlowRuConstants;
import kd.opmc.pbs.common.enums.FLowOpEnum;
import kd.opmc.pbs.common.utils.CommonResultBo;
import kd.opmc.pbs.common.utils.CommonWorkflowCacheBo;
import kd.opmc.pbs.common.utils.FlowControlUtils;
import kd.opmc.pbs.common.utils.WorkFlowStack;

public class FlowRuProcBatchDomainService {
    private static final Log LOG = LogFactory.getLog(FlowRuProcBatchDomainService.class);
    private static final FlowRuProcEntityService FLOW_RU_PROC_ENTITY_SERVICE = FlowRuProcEntityService.getInstance();
    private static final FlowRuNodeEntityService FLOW_RU_NODE_ENTITY_SERVICE = FlowRuNodeEntityService.getInstance();
    private static final FlowRuRoleEntityService FLOW_RU_ROLE_ENTITY_SERVICE = FlowRuRoleEntityService.getInstance();
    private static final FlowRuTaskEntityService FLOW_RU_TASK_ENTITY_SERVICE = FlowRuTaskEntityService.getInstance();
    private static final WorkFlowEntityService WORK_FLOW_ENTITY_SERVICE = WorkFlowEntityService.getInstance();
    private static final FlowDefProcEntityService FLOW_DEF_PROC_ENTITY_SERVICE = FlowDefProcEntityService.getInstance();
    private static final FlowBatchHandlerDomainService FLOW_BATCH_HANDLER_DOMAIN_SERVICE = FlowBatchHandlerDomainService.getInstance();
    private static final ThreadPool THREAD_POOL = ThreadPools.newCachedThreadPool((String)"FlowRuProcBatchDomainService#&", (int)2, (int)6);
    private static final Semaphore SEMAPHORE = new Semaphore(6);

    public static FlowRuProcBatchDomainService getInstance() {
        return ServiceFactory.getService(FlowRuProcBatchDomainService.class);
    }

    public CommonResultBo preCreateProcessInstance(List<FlowRuProcBo> flowRuProcBoList, String flowOpType) {
        CommonResultBo commonResultBo = new CommonResultBo();
        try (TXHandle txHandle = TX.required();){
            try {
                commonResultBo = this.preCreateProcessInstanceNoTx(flowRuProcBoList, flowOpType);
            }
            catch (Exception ex) {
                LOG.error("\u3010OPMC\u3011-FlowRuProcBatchDomainService.preCreateProcessInstance error,message is {},traceId is {}\u3002", (Object)ex.getMessage(), (Object)RequestContext.get().getTraceId());
                txHandle.markRollback();
            }
        }
        return commonResultBo;
    }

    public CommonResultBo preCreateProcessInstanceNoTx(List<FlowRuProcBo> flowRuProcBoList, String flowOpType) {
        LOG.error("begin preCreateProcessInstanceNoTx,traceId is [{}]", (Object)RequestContext.get().getTraceId());
        long preCreateStart = System.currentTimeMillis();
        CommonResultBo commonResultBo = new CommonResultBo();
        ArrayList<DynamicObject> ruProcResultList = new ArrayList<DynamicObject>(10);
        HashMap<Long, FlowRuProcBo> flowRuProcBoMap = new HashMap<Long, FlowRuProcBo>(flowRuProcBoList.size());
        ArrayList<Long> procIdList = new ArrayList<Long>(flowRuProcBoList.size());
        ArrayList<Long> actEvalObjIdList = new ArrayList<Long>(flowRuProcBoList.size());
        ArrayList<Long> flowDefIdList = new ArrayList<Long>(flowRuProcBoList.size());
        ArrayList<FlowRuProcBo> needPreInstanceFlowRuProcBoList = new ArrayList<FlowRuProcBo>(10);
        HashMap<Long, DynamicObject> workflowMap = new HashMap<Long, DynamicObject>(16);
        this.initializWorkflowMap(flowRuProcBoList, workflowMap);
        for (FlowRuProcBo flowRuProcBo : flowRuProcBoList) {
            actEvalObjIdList.add(flowRuProcBo.getActEvalObjId());
            needPreInstanceFlowRuProcBoList.add(flowRuProcBo);
            flowDefIdList.add(flowRuProcBo.getFlowDefId());
            flowRuProcBoMap.put(flowRuProcBo.getActEvalObjId(), flowRuProcBo);
        }
        if (!HRStringUtils.equals((String)FLowOpEnum.RESET.getValue(), (String)flowOpType)) {
            DynamicObject[] runProcDyns = FLOW_RU_PROC_ENTITY_SERVICE.queryOriginalProcByEvaObjAndDefprocIdList(actEvalObjIdList, flowDefIdList);
            for (FlowRuProcBo ruProcBo : flowRuProcBoList) {
                for (DynamicObject ruProcDyn : runProcDyns) {
                    if (!ruProcBo.getActEvalObjId().equals(ruProcDyn.getLong("actevalobj")) || !ruProcBo.getFlowDefId().equals(ruProcDyn.getLong("defproc.id"))) continue;
                    needPreInstanceFlowRuProcBoList.remove(ruProcBo);
                    procIdList.add(ruProcDyn.getLong("id"));
                    ruProcResultList.add(ruProcDyn);
                }
            }
        }
        List<DynamicObject> ruProcList = this.batchGenerateRuProcess(needPreInstanceFlowRuProcBoList);
        Map<Long, DynamicObject> map = ruProcList.stream().collect(Collectors.toMap(proc -> proc.getLong("id"), proc -> proc));
        List<DynamicObject> ruNodeList = this.batchGenerateRuNode(ruProcList, workflowMap);
        Map<Long, DynamicObject> ruNodeMap = ruNodeList.stream().collect(Collectors.toMap(node -> node.getLong("id"), node -> node));
        List<DynamicObject> ruRoleList = this.batchGenerateRuRole(ruNodeList, workflowMap, flowRuProcBoMap, Boolean.TRUE);
        Set handModeProcIdSet = ruProcList.stream().filter(proc -> proc.getString("settingmode").equals("20")).map(proc -> proc.getLong("id")).collect(Collectors.toSet());
        ArrayList<DynamicObject> handModeRuRoleList = new ArrayList<DynamicObject>(10);
        if (!CollectionUtils.isEmpty(handModeProcIdSet)) {
            for (DynamicObject ruRole : ruRoleList) {
                if (!handModeProcIdSet.contains(ruRole.getLong("flowruproc.id"))) continue;
                handModeRuRoleList.add(ruRole);
            }
        }
        if (HRStringUtils.equals((String)FLowOpEnum.RESET.getValue(), (String)flowOpType)) {
            this.batchGenerateRuTask(flowRuProcBoMap, ruRoleList, map, ruNodeMap, Boolean.TRUE);
        } else {
            this.batchGenerateRuTask(flowRuProcBoMap, handModeRuRoleList, map, ruNodeMap, Boolean.TRUE);
        }
        FLOW_RU_ROLE_ENTITY_SERVICE.save(ruRoleList.toArray(new DynamicObject[0]));
        commonResultBo.setCode(1);
        commonResultBo.setIdList(procIdList);
        ruProcResultList.addAll(ruProcList);
        commonResultBo.setResultMap(ruProcResultList.stream().collect(Collectors.toMap(proc -> proc.getLong("actevalobj"), proc -> proc.getLong("id"))));
        long preCreateEnd = System.currentTimeMillis();
        LOG.info("\u3010OPMC\u3011-FlowRuProcBatchDomainService.preCreateProcessInstanceNoTx,deal [{}] data, takes time [{}] ms\u3002", (Object)flowRuProcBoList.size(), (Object)(preCreateEnd - preCreateStart));
        return commonResultBo;
    }

    protected List<DynamicObject> batchGenerateRuProcess(List<FlowRuProcBo> flowRuProcBoList) {
        if (CollectionUtils.isEmpty(flowRuProcBoList)) {
            return new ArrayList<DynamicObject>(10);
        }
        List<DynamicObject> ruProcList = FLOW_RU_PROC_ENTITY_SERVICE.batchGenerateRuProcess(flowRuProcBoList);
        FLOW_RU_PROC_ENTITY_SERVICE.save(ruProcList.toArray(new DynamicObject[0]));
        return ruProcList;
    }

    protected List<DynamicObject> batchGenerateRuNode(List<DynamicObject> ruProcList, Map<Long, DynamicObject> workflowMap) {
        if (CollectionUtils.isEmpty(ruProcList)) {
            return new ArrayList<DynamicObject>(10);
        }
        List<DynamicObject> ruNodeList = FLOW_RU_NODE_ENTITY_SERVICE.batchGenerateRuNode(ruProcList, workflowMap);
        FLOW_RU_NODE_ENTITY_SERVICE.save(ruNodeList.toArray(new DynamicObject[0]));
        return ruNodeList;
    }

    protected List<DynamicObject> batchGenerateRuRole(List<DynamicObject> ruNodeList, Map<Long, DynamicObject> workflowMap, Map<Long, FlowRuProcBo> flowRuProcBoMap, Boolean isPreInstance) {
        if (CollectionUtils.isEmpty(ruNodeList)) {
            return new ArrayList<DynamicObject>(10);
        }
        List<DynamicObject> ruRoleList = FLOW_RU_ROLE_ENTITY_SERVICE.batchGenerateRuRole(ruNodeList, workflowMap, flowRuProcBoMap, isPreInstance);
        return ruRoleList;
    }

    protected List<DynamicObject> batchGenerateRuTask(Map<Long, FlowRuProcBo> flowRuProcBoMap, List<DynamicObject> ruRoleList, Map<Long, DynamicObject> procMap, Map<Long, DynamicObject> ruNodeMap, Boolean isPreInstance) {
        DynamicObject[] pendRuNodes;
        DynamicObject[] dynamicObjectArray;
        if (CollectionUtils.isEmpty(ruRoleList)) {
            return new ArrayList<DynamicObject>(10);
        }
        ArrayList<DynamicObject> ruTaskList = new ArrayList<DynamicObject>(10);
        HashMap<Long, DynamicObject> ruRoleProcMap = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject ruRole : ruRoleList) {
            ruRoleProcMap.put(ruRole.getLong("id"), procMap.get(ruRole.get("flowruproc_id")));
        }
        ArrayList<DynamicObject> pendingRoleList = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> pendingNodeList = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> needQueryReplaceHandlerRoleList = new ArrayList<DynamicObject>(10);
        HashMap<Long, DynamicObject> needQueryReplaceProcMap = new HashMap<Long, DynamicObject>(16);
        Map<Long, List<Long>> roleHandlerMap = this.batchConcurrentQueryFlowRoleHandler(ruRoleList, ruRoleProcMap, Boolean.FALSE);
        for (DynamicObject dynamicObject : ruRoleList) {
            boolean isNeedPreInstHandler = Boolean.TRUE;
            FlowRuProcBo flowRuProcBo = flowRuProcBoMap.get(procMap.get(dynamicObject.get("flowruproc_id")).getLong("actevalobj"));
            List<Long> handlerList = roleHandlerMap.get(dynamicObject.getLong("id"));
            LOG.info("\u3010OPMC\u3011-FlowRuProcBatchDomainService.batchGenerateRuTask,traceId is {},ruroleId={},handlerList={}", new Object[]{RequestContext.get().getTraceId(), dynamicObject.getLong("id"), handlerList});
            if (flowRuProcBo.getRawRoles() != null) {
                Map rawRoleDefTaskMap;
                Map rawRoleDefRoleMap = flowRuProcBo.getRawRoles().stream().filter(e -> !e.getBoolean("iscrossrole")).collect(Collectors.groupingBy(k -> k.getLong("flowdefrole.id"), Collectors.toList()));
                if ((flowRuProcBo.getSettingMode().equals("20") || rawRoleDefRoleMap.get(dynamicObject.getLong("flowdefrole.id")) != null && !rawRoleDefRoleMap.get(dynamicObject.getLong("flowdefrole.id")).isEmpty() && ((DynamicObject)rawRoleDefRoleMap.get(dynamicObject.getLong("flowdefrole.id")).get(0)).getBoolean("issethandler")) && (rawRoleDefTaskMap = flowRuProcBo.getRawTasks().stream().filter(e -> !e.getBoolean("flowrunode.iscrossnode")).collect(Collectors.groupingBy(k -> k.getLong("flowrurole.flowdefrole.id"), Collectors.toList()))).get(dynamicObject.getLong("flowdefrole.id")) != null) {
                    handlerList = rawRoleDefTaskMap.get(dynamicObject.getLong("flowdefrole.id")).stream().map(k -> k.getLong("handler_id")).collect(Collectors.toList());
                }
                if (flowRuProcBo.getSettingMode().equals("10") && (rawRoleDefRoleMap.get(dynamicObject.getLong("flowdefrole.id")) == null || rawRoleDefRoleMap.get(dynamicObject.getLong("flowdefrole.id")).isEmpty() || !((DynamicObject)rawRoleDefRoleMap.get(dynamicObject.getLong("flowdefrole.id")).get(0)).getBoolean("issethandler"))) {
                    isNeedPreInstHandler = Boolean.FALSE;
                }
                if (flowRuProcBo.getSettingMode().equals("10") && rawRoleDefRoleMap.get(dynamicObject.getLong("flowdefrole.id")) != null && !rawRoleDefRoleMap.get(dynamicObject.getLong("flowdefrole.id")).isEmpty() && ((DynamicObject)rawRoleDefRoleMap.get(dynamicObject.getLong("flowdefrole.id")).get(0)).getBoolean("issethandler")) {
                    dynamicObject.set("issethandler", (Object)1);
                }
            }
            if (!CollectionUtils.isEmpty(handlerList) && isNeedPreInstHandler) {
                List<DynamicObject> tasks = FLOW_RU_TASK_ENTITY_SERVICE.generateTaskByRuRole(dynamicObject.getDynamicObject("flowrunode"), dynamicObject, handlerList, Boolean.FALSE);
                ruTaskList.addAll(tasks);
                continue;
            }
            if (!CollectionUtils.isEmpty(handlerList) || !isNeedPreInstHandler) continue;
            needQueryReplaceHandlerRoleList.add(dynamicObject);
            needQueryReplaceProcMap.put(dynamicObject.getLong("id"), procMap.get(dynamicObject.get("flowruproc_id")));
        }
        Map<Long, List<Long>> nodeReplaceHandlerMap = this.batchConcurrentQueryFlowRoleHandler(needQueryReplaceHandlerRoleList, needQueryReplaceProcMap, Boolean.TRUE);
        for (DynamicObject ruRole : needQueryReplaceHandlerRoleList) {
            List<Long> replaceHandlerList = nodeReplaceHandlerMap.get(ruRole.getLong("id"));
            LOG.info("\u3010OPMC\u3011-FlowRuProcBatchDomainService.batchGenerateRuTask,traceId is {},ruroleId={},replaceHandlerList={}", new Object[]{RequestContext.get().getTraceId(), ruRole.getLong("id"), replaceHandlerList});
            if (!CollectionUtils.isEmpty(replaceHandlerList)) {
                List<DynamicObject> tasks = FLOW_RU_TASK_ENTITY_SERVICE.generateTaskByRuRole(ruRole.getDynamicObject("flowrunode"), ruRole, replaceHandlerList, Boolean.TRUE);
                ruTaskList.addAll(tasks);
                continue;
            }
            ArrayList<Long> defaultHandlerList = new ArrayList<Long>(1);
            defaultHandlerList.add(0L);
            ruTaskList.addAll(FLOW_RU_TASK_ENTITY_SERVICE.generateTaskByRuRole(ruRole.getDynamicObject("flowrunode"), ruRole, defaultHandlerList, Boolean.TRUE));
            pendingRoleList.add(ruRole);
            pendingNodeList.add(ruNodeMap.get(ruRole.getLong("flowrunode.id")));
        }
        FLOW_RU_TASK_ENTITY_SERVICE.save(ruTaskList.toArray(new DynamicObject[0]));
        for (DynamicObject ruRole : dynamicObjectArray = FLOW_RU_ROLE_ENTITY_SERVICE.loadRuRoleByIds(pendingRoleList.stream().map(role -> role.getLong("id")).collect(Collectors.toList()))) {
            ruRole.set("rolestatus", (Object)FlowRuRoleStatusEnum.PENDING.getCode());
        }
        if (!HRObjectUtils.isEmpty((Object)dynamicObjectArray)) {
            FLOW_RU_ROLE_ENTITY_SERVICE.save(dynamicObjectArray);
        }
        for (DynamicObject ruNode : pendRuNodes = FLOW_RU_NODE_ENTITY_SERVICE.loadRuNodeByIds(pendingNodeList.stream().map(rn -> rn.getLong("id")).collect(Collectors.toList()))) {
            ruNode.set("nodestatus", (Object)FlowRuNodeStatusEnum.NOT_ACTIVE.getCode());
        }
        if (!HRObjectUtils.isEmpty((Object)pendRuNodes)) {
            FLOW_RU_NODE_ENTITY_SERVICE.save(pendRuNodes);
        }
        return ruTaskList;
    }

    protected void initializWorkflowMap(List<FlowRuProcBo> flowRuProcBoList, Map<Long, DynamicObject> workflowMap) {
        DynamicObject[] flowDefProcDyns;
        DynamicObject[] workflowDyns;
        ArrayList<Long> unCachedFlowVidList = new ArrayList<Long>(10);
        ArrayList<Long> unCachedDefprocIdList = new ArrayList<Long>(10);
        HashMap<Long, Long> flowDefWorkflowMap = new HashMap<Long, Long>(16);
        for (FlowRuProcBo flowRuProcBo : flowRuProcBoList) {
            if (null != WorkFlowRuConstants.WORKFLOW_MAP.get(flowRuProcBo.getFlowVid())) {
                DynamicObject[] workflow = ((CommonWorkflowCacheBo)WorkFlowRuConstants.WORKFLOW_MAP.get(flowRuProcBo.getFlowVid())).getWorkflow();
                workflowMap.put(flowRuProcBo.getFlowVid(), (DynamicObject)workflow);
                Long flowDefId = ((DynamicObject)workflow.getDynamicObjectCollection("entryentity").get(0)).getLong("flowdefproc");
                flowRuProcBo.setFlowDefId(flowDefId);
                DynamicObject flowDef = ((CommonWorkflowCacheBo)WorkFlowRuConstants.WORKFLOW_MAP.get(flowRuProcBo.getFlowVid())).getFlowDef();
                workflowMap.put(flowDefId, flowDef);
                continue;
            }
            unCachedFlowVidList.add(flowRuProcBo.getFlowVid());
        }
        QFilter filter = new QFilter("id", "in", unCachedFlowVidList);
        for (DynamicObject workflow : workflowDyns = WORK_FLOW_ENTITY_SERVICE.loadDynamicObjectArray(new QFilter[]{filter})) {
            CommonWorkflowCacheBo workflowCacheBo = new CommonWorkflowCacheBo();
            workflowCacheBo.setWorkflow(workflow);
            workflowMap.put(workflow.getLong("id"), workflow);
            Long flowDefId = ((DynamicObject)workflow.getDynamicObjectCollection("entryentity").get(0)).getLong("flowdefproc");
            unCachedDefprocIdList.add(flowDefId);
            flowDefWorkflowMap.put(flowDefId, workflow.getLong("id"));
            WorkFlowRuConstants.WORKFLOW_MAP.put(workflow.getLong("id"), workflowCacheBo);
            for (FlowRuProcBo flowRuProcBo : flowRuProcBoList) {
                if (!flowRuProcBo.getFlowVid().equals(workflow.getLong("id"))) continue;
                flowRuProcBo.setFlowDefId(flowDefId);
            }
        }
        QFilter defProcFilter = new QFilter("id", "in", unCachedDefprocIdList);
        for (DynamicObject flowDefProc : flowDefProcDyns = FLOW_DEF_PROC_ENTITY_SERVICE.loadDynamicObjectArray(new QFilter[]{defProcFilter})) {
            workflowMap.put(flowDefProc.getLong("id"), flowDefProc);
            CommonWorkflowCacheBo workflowCacheBo = (CommonWorkflowCacheBo)WorkFlowRuConstants.WORKFLOW_MAP.get(flowDefWorkflowMap.get(flowDefProc.getLong("id")));
            workflowCacheBo.setFlowDef(flowDefProc);
            workflowCacheBo.setLastVistedTime(Long.valueOf(System.currentTimeMillis()));
            WorkFlowRuConstants.WORKFLOW_MAP.put(flowDefWorkflowMap.get(flowDefProc.getLong("id")), workflowCacheBo);
        }
    }

    protected void initializWorkflowDefRoleMap(DynamicObject[] roleDefDyns, Map<Long, Long> roleDefWorkflowMap) {
        for (DynamicObject roleDef : roleDefDyns) {
            HashMap<Long, DynamicObject> roleDefCacheMap;
            Long workflowId = roleDefWorkflowMap.get(roleDef.getLong("id"));
            CommonWorkflowCacheBo comWorkflowCacheBo = (CommonWorkflowCacheBo)WorkFlowRuConstants.WORKFLOW_MAP.get(workflowId);
            if (null == comWorkflowCacheBo) {
                comWorkflowCacheBo = new CommonWorkflowCacheBo();
            }
            if (null == (roleDefCacheMap = comWorkflowCacheBo.getFlowRoleDefMap())) {
                roleDefCacheMap = new HashMap<Long, DynamicObject>(16);
            }
            roleDefCacheMap.put(roleDef.getLong("id"), roleDef);
            comWorkflowCacheBo.setFlowRoleDefMap(roleDefCacheMap);
            WorkFlowRuConstants.WORKFLOW_MAP.put(workflowId, comWorkflowCacheBo);
        }
    }

    public Map<Long, List<Long>> batchConcurrentQueryFlowRoleHandler(List<DynamicObject> ruRoleList, Map<Long, DynamicObject> ruRoleProcMap, boolean isNodeReplace) {
        ConcurrentHashMap<Long, List<Long>> retMap = new ConcurrentHashMap<Long, List<Long>>(16);
        ArrayList roleGroupList = new ArrayList(10);
        int roleSize = ruRoleList.size();
        ArrayList<DynamicObject> roleTmpList = new ArrayList<DynamicObject>(10);
        for (int i = 0; i < roleSize; ++i) {
            roleTmpList.add(ruRoleList.get(i));
            if (roleTmpList.size() % 20 == 0) {
                roleGroupList.add(roleTmpList);
                roleTmpList = new ArrayList(10);
                continue;
            }
            if (i != roleSize - 1 || roleTmpList.size() <= 0) continue;
            roleGroupList.add(roleTmpList);
        }
        int count = roleGroupList.size();
        CountDownLatch atomicInteger = new CountDownLatch(count);
        for (int j = 0; j < count; ++j) {
            List roleList = (List)roleGroupList.get(j);
            try {
                Thread.sleep(30L);
            }
            catch (InterruptedException e) {
                LOG.error((Throwable)e);
            }
            try {
                SEMAPHORE.acquire();
                THREAD_POOL.execute(() -> {
                    try {
                        HashMap<Long, DynamicObject> roleProcTmpMap = new HashMap<Long, DynamicObject>(roleList.size());
                        for (DynamicObject ruRole : roleList) {
                            roleProcTmpMap.put(ruRole.getLong("id"), (DynamicObject)ruRoleProcMap.get(ruRole.getLong("id")));
                        }
                        Map<Object, Object> handlerMap = new HashMap(10);
                        if (isNodeReplace) {
                            handlerMap = FLOW_BATCH_HANDLER_DOMAIN_SERVICE.queryReplaceFlowRoleHandler(roleList, roleProcTmpMap);
                            LOG.info("\u3010OPMC\u3011-FlowBatchHandlerDomainService.queryReplaceFlowRoleHandler,traceId is {},handlerMap={}", (Object)RequestContext.get().getTraceId(), handlerMap);
                        } else {
                            handlerMap = FLOW_BATCH_HANDLER_DOMAIN_SERVICE.batchQueryFlowRoleHandler(roleList, roleProcTmpMap);
                            LOG.info("\u3010OPMC\u3011-FlowBatchHandlerDomainService.batchQueryFlowRoleHandler,traceId is {},handlerMap={}", (Object)RequestContext.get().getTraceId(), handlerMap);
                        }
                        for (Map.Entry<Object, Object> entry : handlerMap.entrySet()) {
                            retMap.put((Long)entry.getKey(), (List<Long>)entry.getValue());
                        }
                    }
                    catch (Exception exception) {
                        LOG.error((Throwable)exception);
                    }
                    finally {
                        SEMAPHORE.release();
                        atomicInteger.countDown();
                    }
                }, RequestContext.get());
                continue;
            }
            catch (InterruptedException interruptedException) {
                LOG.error((Throwable)interruptedException);
            }
        }
        try {
            atomicInteger.await();
        }
        catch (InterruptedException e) {
            LOG.error((Throwable)e);
        }
        return retMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommonResultBo startBatchProcess(List<FlowRuProcBo> flowRuProcBoList) {
        CommonResultBo commonResultBo = new CommonResultBo();
        HashMap<Long, String> detailMap = new HashMap<Long, String>(16);
        HashMap<Long, Long> resultMap = new HashMap<Long, Long>(16);
        WorkFlowStack flowStack = FlowControlUtils.initializeFlowStackMap();
        long recentFiveAvgtime = FlowControlUtils.calcuteRecentFiveAvgTime((WorkFlowStack)flowStack);
        long preAvgTime = 0L;
        if (!flowStack.isEmpty()) {
            preAvgTime = (Long)flowStack.peek();
        }
        long secondToLastAvgTime = 0L;
        if (!flowStack.isEmpty() && flowStack.getSize() >= 2) {
            secondToLastAvgTime = (Long)flowStack.get(1);
        }
        if (preAvgTime > recentFiveAvgtime * 2L || preAvgTime > secondToLastAvgTime * 2L) {
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                LOG.error("\u3010OPMC\u3011-FlowRuProcBatchDomainService.startBatchProcess,Thread.sleep error.{}", (Object)e.getMessage());
            }
        }
        long startTime = System.currentTimeMillis();
        FlowRuProcDomainService FLOW_RU_PROC_DOMAIN_SERVICE = new FlowRuProcDomainService();
        for (FlowRuProcBo flowRuProcBo : flowRuProcBoList) {
            try (TXHandle txHandle = TX.required();){
                FlowRuResultBo flowResultBo = FLOW_RU_PROC_DOMAIN_SERVICE.startProcess(flowRuProcBo);
                detailMap.put(flowRuProcBo.getActEvalObjId(), String.valueOf(flowResultBo.isPending()));
                resultMap.put(flowRuProcBo.getActEvalObjId(), flowResultBo.getRuProcId());
            }
        }
        long endTime = System.currentTimeMillis();
        long currentAvgTime = new BigDecimal(endTime - startTime).divide(BigDecimal.valueOf(flowRuProcBoList.size()), 2, RoundingMode.HALF_UP).longValue();
        FlowControlUtils.pushStack((WorkFlowStack)flowStack, (long)currentAvgTime);
        commonResultBo.setCode(1);
        commonResultBo.setIdList(flowRuProcBoList.stream().map(bo -> bo.getActEvalObjId()).collect(Collectors.toList()));
        commonResultBo.setDetailMap(detailMap);
        commonResultBo.setResultMap(resultMap);
        return commonResultBo;
    }

    public CommonWorkflowCacheBo getWorkflowMap(Long workflowId) {
        this.setWorkflowCacheLock(workflowId, "1");
        CommonWorkflowCacheBo comWorkflowCacheBo = (CommonWorkflowCacheBo)WorkFlowRuConstants.WORKFLOW_MAP.get(workflowId);
        if (null != comWorkflowCacheBo) {
            comWorkflowCacheBo.setLastVistedTime(Long.valueOf(System.currentTimeMillis()));
            WorkFlowRuConstants.WORKFLOW_MAP.put(workflowId, comWorkflowCacheBo);
        } else {
            this.initializWorkflowMapByWorkflowId(Collections.singletonList(workflowId));
            comWorkflowCacheBo = (CommonWorkflowCacheBo)WorkFlowRuConstants.WORKFLOW_MAP.get(workflowId);
        }
        this.setWorkflowCacheLock(workflowId, "0");
        return comWorkflowCacheBo;
    }

    protected void initializWorkflowMapByWorkflowId(List<Long> workflowIdList) {
        DynamicObject[] flowDefProcDyns;
        DynamicObject[] workflowDyns;
        ArrayList<Long> unCachedFlowVidList = new ArrayList<Long>(10);
        ArrayList<Long> unCachedDefprocIdList = new ArrayList<Long>(10);
        HashMap<Long, Long> flowDefWorkflowMap = new HashMap<Long, Long>(16);
        for (Long workflowId : workflowIdList) {
            if (null != WorkFlowRuConstants.WORKFLOW_MAP.get(workflowId)) continue;
            unCachedFlowVidList.add(workflowId);
        }
        QFilter filter = new QFilter("id", "in", unCachedFlowVidList);
        for (DynamicObject workflow : workflowDyns = WORK_FLOW_ENTITY_SERVICE.loadDynamicObjectArray(new QFilter[]{filter})) {
            CommonWorkflowCacheBo workflowCacheBo = new CommonWorkflowCacheBo();
            workflowCacheBo.setWorkflow(workflow);
            workflowCacheBo.setLastVistedTime(Long.valueOf(System.currentTimeMillis()));
            Long flowDefId = ((DynamicObject)workflow.getDynamicObjectCollection("entryentity").get(0)).getLong("flowdefproc");
            unCachedDefprocIdList.add(flowDefId);
            flowDefWorkflowMap.put(flowDefId, workflow.getLong("id"));
            WorkFlowRuConstants.WORKFLOW_MAP.put(workflow.getLong("id"), workflowCacheBo);
        }
        QFilter defProcFilter = new QFilter("id", "in", unCachedDefprocIdList);
        for (DynamicObject flowDefProc : flowDefProcDyns = FLOW_DEF_PROC_ENTITY_SERVICE.loadDynamicObjectArray(new QFilter[]{defProcFilter})) {
            CommonWorkflowCacheBo workflowCacheBo = (CommonWorkflowCacheBo)WorkFlowRuConstants.WORKFLOW_MAP.get(flowDefWorkflowMap.get(flowDefProc.getLong("id")));
            workflowCacheBo.setFlowDef(flowDefProc);
            WorkFlowRuConstants.WORKFLOW_MAP.put(flowDefWorkflowMap.get(flowDefProc.getLong("id")), workflowCacheBo);
        }
    }

    public Boolean getWorkflowCacheLock(Long workflowId) {
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("opmcworkflow");
        if ("1".equals(cache.get("FLOWLOCK" + workflowId))) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public void setWorkflowCacheLock(Long workflowId, String isLock) {
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("opmcworkflow");
        cache.put("FLOWLOCK" + workflowId, (Object)isLock, 600);
    }
}

