/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.pbs.business.domain.workflow.service;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.extplugin.PluginFilter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.pbs.business.ServiceFactory;
import kd.opmc.pbs.business.application.impl.mq.SubmitTaskPublisher;
import kd.opmc.pbs.business.domain.extpoint.IJumpTaskForNoAuditorService;
import kd.opmc.pbs.business.domain.extpoint.IWorkflowSupportCopyService;
import kd.opmc.pbs.business.domain.workflow.dto.SendMessageDTO;
import kd.opmc.pbs.business.domain.workflow.entity.FlowCommonResultBo;
import kd.opmc.pbs.business.domain.workflow.entity.FlowMsgMergeEnumBO;
import kd.opmc.pbs.business.domain.workflow.entity.FlowRuProcBo;
import kd.opmc.pbs.business.domain.workflow.entity.FlowRuResultBo;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowDefNodeEntityService;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowDefProcEntityService;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowRuNodeEntityService;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowRuOpEntityService;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowRuProcEntityService;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowRuRoleEntityService;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowRuTaskEntityService;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowRuTaskProcLogEntityService;
import kd.opmc.pbs.business.domain.workflow.entityservice.WorkFlowEntityService;
import kd.opmc.pbs.business.domain.workflow.enums.FlowDefRoleOutEnum;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuMsgEnum;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuMsgMergeEnum;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuNodeStatusEnum;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuProcStatusEnum;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuRoleStatusEnum;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuTaskStatusEnum;
import kd.opmc.pbs.business.domain.workflow.model.FlowParamBo;
import kd.opmc.pbs.business.domain.workflow.service.CrossScoreDomainService;
import kd.opmc.pbs.business.domain.workflow.service.FlowCooperateRuProcDomainService;
import kd.opmc.pbs.business.domain.workflow.service.FlowHandlerBatchDomainService;
import kd.opmc.pbs.business.domain.workflow.service.FlowRuProcBatchDomainService;
import kd.opmc.pbs.business.domain.workflow.service.FlowRuSecondDomainService;
import kd.opmc.pbs.business.domain.workflow.service.FlowRunSupDomainService;
import kd.opmc.pbs.business.domain.workflow.utils.WorkflowUtils;
import kd.opmc.pbs.business.external.epa.IEPAActEvalRecordService;
import kd.opmc.pbs.business.external.epa.IEPAActevalobjService;
import kd.opmc.pbs.business.external.epa.IEPAEvalResultCalcService;
import kd.opmc.pbs.common.constants.NodeTypeConstants;
import kd.opmc.pbs.common.enums.FLowOpEnum;

public class FlowRuProcDomainService {
    private static final Log LOG = LogFactory.getLog(FlowRuProcDomainService.class);
    private static final FlowRuProcEntityService FLOW_RU_PROC_ENTITY_SERVICE = FlowRuProcEntityService.getInstance();
    private static final FlowRuNodeEntityService FLOW_RU_NODE_ENTITY_SERVICE = FlowRuNodeEntityService.getInstance();
    private static final FlowRuRoleEntityService FLOW_RU_ROLE_ENTITY_SERVICE = FlowRuRoleEntityService.getInstance();
    private static final FlowRuTaskEntityService FLOW_RU_TASK_ENTITY_SERVICE = FlowRuTaskEntityService.getInstance();
    private static final FlowRuOpEntityService FLOW_RU_OP_ENTITY_SERVICE = FlowRuOpEntityService.getInstance();
    private static final WorkFlowEntityService WORK_FLOW_ENTITY_SERVICE = WorkFlowEntityService.getInstance();
    private static final FlowDefProcEntityService FLOW_DEF_PROC_ENTITY_SERVICE = FlowDefProcEntityService.getInstance();
    private static final IEPAEvalResultCalcService IEPA_EVAL_RESULT_CALC_SERVICE = IEPAEvalResultCalcService.getInstance();
    private static final FlowRunSupDomainService FLOW_RUSUP_DOMAIN_SERVICE = FlowRunSupDomainService.getInstance();
    private static final FlowRuSecondDomainService FLOW_RUSECOND_DOMAIN_SERVICE = FlowRuSecondDomainService.getInstance();
    private static final CrossScoreDomainService CROSS_SCORE_DOMAIN_SERVICE = CrossScoreDomainService.getInstance();
    private static final FlowHandlerBatchDomainService FLOW_HANDLER_BATCH_DOMAIN_SERVICE = FlowHandlerBatchDomainService.getInstance();
    private static final IEPAActevalobjService IEPA_ACTEVALOBJ_SERVICE = IEPAActevalobjService.getInstance();
    private static final FlowDefNodeEntityService FLOW_DEF_NODE_ENTITY_SERVICE = FlowDefNodeEntityService.getInstance();
    private static final FlowRuTaskProcLogEntityService FLOW_RUTASK_LOG_SERVICE = FlowRuTaskProcLogEntityService.getInstance();
    private static final FlowCooperateRuProcDomainService FLOW_COOPERATE_RU_PROC_DOMAIN_SERVICE = FlowCooperateRuProcDomainService.getInstance();
    private static final IJumpTaskForNoAuditorService I_JUMP_TASK_FOR_NO_AUDITOR_SERVICE = IJumpTaskForNoAuditorService.getInstance();
    private static final IWorkflowSupportCopyService I_WORKFLOW_SUPPORT_COPY_SERVICE = IWorkflowSupportCopyService.getInstance();

    public static FlowRuProcDomainService getInstance() {
        return ServiceFactory.getService(FlowRuProcDomainService.class);
    }

    public FlowRuResultBo startProcess(FlowRuProcBo flowRuProcBo) {
        DynamicObject[] ruTaskDyns;
        LOG.error("begin startProcess,actevaObjId is [{}],flowvid is [{}],traceId is [{}]", new Object[]{flowRuProcBo.getActEvalObjId(), flowRuProcBo.getFlowVid(), RequestContext.get().getTraceId()});
        long procStart = System.currentTimeMillis();
        FlowRuResultBo resultBo = new FlowRuResultBo();
        HashMap<Long, DynamicObject> workflowMap = new HashMap<Long, DynamicObject>(16);
        FlowRuProcBatchDomainService FLOW_RU_PROC_BATCH_DOMAIN_SERVICE = new FlowRuProcBatchDomainService();
        FLOW_RU_PROC_BATCH_DOMAIN_SERVICE.initializWorkflowMap(Collections.singletonList(flowRuProcBo), workflowMap);
        Long flowDefId = flowRuProcBo.getFlowDefId();
        DynamicObject workflow = (DynamicObject)workflowMap.get(flowRuProcBo.getFlowVid());
        DynamicObject flowDef = (DynamicObject)workflowMap.get(flowDefId);
        DynamicObject ruProc = FLOW_RU_PROC_ENTITY_SERVICE.generateEmptyDynamicObject();
        ArrayList<DynamicObject> ruNodeList = new ArrayList(10);
        DynamicObject[] runProcDyns = FLOW_RU_PROC_ENTITY_SERVICE.queryProcByEvaObjIdAndDefprocId(flowRuProcBo.getActEvalObjId(), flowDefId);
        if (runProcDyns.length < 1) {
            ruProc = FLOW_RU_PROC_ENTITY_SERVICE.generateRuProcess(flowRuProcBo, flowDef, workflow.getString("name"), Boolean.TRUE);
            ruNodeList = FLOW_RU_NODE_ENTITY_SERVICE.generateRuNode(ruProc, flowDef, Boolean.FALSE);
            FLOW_RU_ROLE_ENTITY_SERVICE.generateRuRole(ruNodeList, flowDef, false, flowRuProcBo, Boolean.FALSE);
        } else {
            ruProc = runProcDyns[0];
            Collections.addAll(ruNodeList, FLOW_RUSUP_DOMAIN_SERVICE.queryAllNodeByProcId(ruProc.getLong("id")));
        }
        CROSS_SCORE_DOMAIN_SERVICE.dealCrossNodeForStartProc(flowRuProcBo, ruProc, ruNodeList);
        DynamicObject ruNode = (DynamicObject)ruNodeList.get(0);
        Long ruProcId = (Long)ruProc.getPkValue();
        DynamicObject updateProc = FLOW_RU_PROC_ENTITY_SERVICE.queryRuProcByPk(ruProcId);
        updateProc.set("majorproc", (Object)ruProcId);
        updateProc.set("currentnode", (Object)ruNode);
        updateProc.set("updatestatustime", (Object)new Date());
        boolean isPending = FLOW_RUSUP_DOMAIN_SERVICE.activeRuNode(ruNode, ruProc);
        if (isPending) {
            updateProc.set("procstatus", (Object)FlowRuProcStatusEnum.PENDING.getCode());
        } else {
            updateProc.set("procstatus", (Object)FlowRuProcStatusEnum.RUNNING.getCode());
        }
        this.setCurrentRunRole(updateProc, ruNode);
        FLOW_RU_PROC_ENTITY_SERVICE.saveOne(updateProc);
        for (DynamicObject ruTask : ruTaskDyns = FLOW_RU_TASK_ENTITY_SERVICE.queryAllTasksByProcId(ruProcId)) {
            ruTask.set("batchno", (Object)flowRuProcBo.getBatchNo());
        }
        FLOW_RU_TASK_ENTITY_SERVICE.save(ruTaskDyns);
        resultBo.setRuProcId(ruProcId);
        resultBo.setHandlerGetMode(flowRuProcBo.getSettingMode());
        resultBo.setPending(isPending);
        long procEnd = System.currentTimeMillis();
        LOG.info("procEnd-procStart takes time : {} ms", (Object)(procEnd - procStart));
        return resultBo;
    }

    public List<Long> preCreateProcessInstance(FlowRuProcBo flowRuProcBo) {
        return FLOW_RUSECOND_DOMAIN_SERVICE.preCreateProcessInstance(flowRuProcBo);
    }

    public void resetProcess() {
    }

    public boolean endProcess(Long ruProcId) {
        if (null == ruProcId || ruProcId.equals(0L)) {
            return Boolean.FALSE;
        }
        DynamicObject ruProc = FLOW_RU_PROC_ENTITY_SERVICE.queryRuProcByPk(ruProcId);
        Date date = new Date();
        long userId = UserServiceHelper.getCurrentUserId();
        ruProc.set("procstatus", (Object)FlowRuProcStatusEnum.DEPRECATED.getCode());
        ruProc.set("updatestatustime", (Object)date);
        ruProc.set("modifier", (Object)userId);
        ruProc.set("modifytime", (Object)date);
        FLOW_RU_PROC_ENTITY_SERVICE.saveOne(ruProc);
        DynamicObject[] taskArray = FLOW_RU_TASK_ENTITY_SERVICE.loadTasksByProcIds(Collections.singletonList(ruProcId));
        FLOW_RUSUP_DOMAIN_SERVICE.updateTaskStatus(taskArray, FlowRuTaskStatusEnum.EXPIRED.getCode());
        FLOW_RU_TASK_ENTITY_SERVICE.save(taskArray);
        return true;
    }

    public void pauseProcess(List<Long> ruProcIds, String pauseType, String describe) {
        DynamicObject[] ruProcs = FLOW_RU_PROC_ENTITY_SERVICE.queryProcByPkIds(ruProcIds);
        ArrayList<Long> ruNodeIds = new ArrayList<Long>(ruProcs.length);
        ArrayList<DynamicObject> opRecords = new ArrayList<DynamicObject>(ruProcs.length);
        Date date = new Date();
        long userId = UserServiceHelper.getCurrentUserId();
        for (DynamicObject ruProc : ruProcs) {
            ruNodeIds.add(ruProc.getLong("currentnode.id"));
            ruProc.set("procstatus", (Object)FlowRuProcStatusEnum.STOP.getCode());
            ruProc.set("updatestatustime", (Object)date);
            ruProc.set("modifier", (Object)userId);
            ruProc.set("modifytime", (Object)date);
            DynamicObject opRecord = FLOW_RU_OP_ENTITY_SERVICE.generateOpRecord(ruProc);
            opRecord.set("pausetype", (Object)pauseType);
            opRecord.set("optype", (Object)FLowOpEnum.PAUSE.getValue());
            opRecord.set("description", (Object)describe);
            opRecords.add(opRecord);
        }
        FLOW_RU_PROC_ENTITY_SERVICE.save(ruProcs);
        FLOW_RU_OP_ENTITY_SERVICE.save(opRecords.toArray(new DynamicObject[0]));
        DynamicObject[] ruNodes = FLOW_RU_NODE_ENTITY_SERVICE.queryRunningNodeByPks(ruNodeIds);
        if (ruNodes.length != ruProcs.length) {
            String msg = String.format("pauseProcess: runtime node status is invalid, ruNodeIds:%s", ruNodeIds);
            LOG.error(msg);
            throw new KDException(new ErrorCode("pauseProcess", msg), new Object[0]);
        }
        for (DynamicObject ruNode : ruNodes) {
            ruNode.set("nodestatus", (Object)FlowRuNodeStatusEnum.STOP.getCode());
            ruNode.set("updatestatustime", (Object)date);
            ruNode.set("modifier", (Object)userId);
            ruNode.set("modifytime", (Object)date);
        }
        FLOW_RU_NODE_ENTITY_SERVICE.save(ruNodes);
    }

    public void restartProcess(List<Long> ruProcIds) {
        DynamicObject[] dynamicObjectArray;
        DynamicObject[] ruProcs = FLOW_RU_PROC_ENTITY_SERVICE.queryProcByPkIds(ruProcIds);
        ArrayList<Long> ruNodeIds = new ArrayList<Long>(ruProcs.length);
        ArrayList<DynamicObject> opRecords = new ArrayList<DynamicObject>(ruProcs.length);
        Date date = new Date();
        long userId = UserServiceHelper.getCurrentUserId();
        HashMap procMap = Maps.newHashMapWithExpectedSize((int)ruProcs.length);
        for (DynamicObject dynamicObject : ruProcs) {
            procMap.put((Long)dynamicObject.getPkValue(), dynamicObject);
            ruNodeIds.add(dynamicObject.getLong("currentnode.id"));
            dynamicObject.set("procstatus", (Object)FlowRuProcStatusEnum.RUNNING.getCode());
            dynamicObject.set("updatestatustime", (Object)date);
            dynamicObject.set("modifier", (Object)userId);
            dynamicObject.set("modifytime", (Object)date);
            DynamicObject opRecord = FLOW_RU_OP_ENTITY_SERVICE.generateOpRecord(dynamicObject);
            opRecord.set("optype", (Object)FLowOpEnum.START.getValue());
            opRecords.add(opRecord);
        }
        FLOW_RU_PROC_ENTITY_SERVICE.save(ruProcs);
        FLOW_RU_OP_ENTITY_SERVICE.save(opRecords.toArray(new DynamicObject[0]));
        DynamicObject[] ruNodes = FLOW_RU_NODE_ENTITY_SERVICE.queryPendingOrStopNodeByPks(ruNodeIds);
        if (ruNodes.length != ruNodeIds.size()) {
            String msg = String.format("restartProcess: runtime node status is invalid, ruNodeIds:%s", ruNodeIds);
            LOG.error(msg);
            throw new KDException(new ErrorCode("restartProcess", msg), new Object[0]);
        }
        ArrayList<Long> pendingNodeIds = new ArrayList<Long>();
        ArrayList<Long> stopNodeIds = new ArrayList<Long>(ruNodeIds.size());
        for (DynamicObject ruNode : ruNodes) {
            if (FlowRuNodeStatusEnum.PENDING.getCode().equals(ruNode.getString("nodestatus"))) {
                pendingNodeIds.add((Long)ruNode.getPkValue());
            } else {
                stopNodeIds.add((Long)ruNode.getPkValue());
            }
            ruNode.set("nodestatus", (Object)FlowRuNodeStatusEnum.RUNNING.getCode());
            ruNode.set("updatestatustime", (Object)date);
            ruNode.set("modifier", (Object)userId);
            ruNode.set("modifytime", (Object)date);
        }
        FLOW_RU_NODE_ENTITY_SERVICE.save(ruNodes);
        if (pendingNodeIds.size() > 0) {
            this.restartPendingNode(procMap, pendingNodeIds);
        }
        if (stopNodeIds.size() > 0 && (dynamicObjectArray = FLOW_RU_TASK_ENTITY_SERVICE.queryTaskHandlersByNodeIds(stopNodeIds)).length > 0) {
            for (DynamicObject task : dynamicObjectArray) {
                FLOW_RUSUP_DOMAIN_SERVICE.notifyHandler((DynamicObject)procMap.get(task.getLong("flowruproc.id")), task, FlowRuMsgEnum.RESTART);
            }
        }
    }

    public boolean notPrepareRestart(Long ruProcId) {
        return FLOW_RUSECOND_DOMAIN_SERVICE.notPrepareRestart(ruProcId);
    }

    private void restartPendingNode(Map<Long, DynamicObject> procMap, List<Long> pendingNodeIds) {
        FLOW_RUSECOND_DOMAIN_SERVICE.restartPendingNode(procMap, pendingNodeIds);
    }

    public boolean processTask(Long taskId) {
        DynamicObject task = FLOW_RU_TASK_ENTITY_SERVICE.queryTaskByPk(taskId);
        if (FlowRuTaskStatusEnum.WAITING.getCode().equals(task.getString("taskstatus"))) {
            FLOW_RUSUP_DOMAIN_SERVICE.updateTaskStatus(task, FlowRuTaskStatusEnum.PROCESSING.getCode(), new Date(), UserServiceHelper.getCurrentUserId());
            FLOW_RU_TASK_ENTITY_SERVICE.saveOne(task);
            return true;
        }
        return false;
    }

    public boolean resetRollBackedMark(List<Long> taskIds) {
        List<DynamicObject> resetRollBackTasks;
        DynamicObject[] taskObjs = FLOW_RU_TASK_ENTITY_SERVICE.queryTaskByPks(taskIds);
        if (taskObjs != null && taskObjs.length > 0 && !(resetRollBackTasks = Arrays.stream(taskObjs).filter(taskObj -> {
            String taskStatus = taskObj.getString("taskstatus");
            return FlowRuTaskStatusEnum.WAITING.getCode().equals(taskStatus) || FlowRuTaskStatusEnum.PROCESSING.getCode().equals(taskStatus);
        }).collect(Collectors.toList())).isEmpty()) {
            Long userId = UserServiceHelper.getCurrentUserId();
            Date date = new Date();
            for (DynamicObject taskObj2 : resetRollBackTasks) {
                taskObj2.set("isrollbacked", (Object)1);
                taskObj2.set("modifier", (Object)userId);
                taskObj2.set("modifytime", (Object)date);
            }
            FLOW_RU_TASK_ENTITY_SERVICE.save(resetRollBackTasks.toArray(new DynamicObject[0]));
            return true;
        }
        return false;
    }

    public DynamicObject processTaskAndGetTask(Long taskId) {
        DynamicObject task = FLOW_RU_TASK_ENTITY_SERVICE.queryTaskByPk(taskId);
        if (FlowRuTaskStatusEnum.WAITING.getCode().equals(task.getString("taskstatus"))) {
            FLOW_RUSUP_DOMAIN_SERVICE.updateTaskStatus(task, FlowRuTaskStatusEnum.PROCESSING.getCode(), new Date(), UserServiceHelper.getCurrentUserId());
            FLOW_RU_TASK_ENTITY_SERVICE.saveOne(task);
        }
        return task;
    }

    public DynamicObject getTaskProcDynamicObj(Long taskId) {
        if (taskId == null) {
            return null;
        }
        DynamicObject task = FLOW_RU_TASK_ENTITY_SERVICE.queryTaskByPk(taskId);
        if (task != null) {
            return task.getDynamicObject("flowruproc");
        }
        return null;
    }

    public DynamicObject getTaskById(Long taskId) {
        return FLOW_RU_TASK_ENTITY_SERVICE.queryTaskByPk(taskId);
    }

    public Map<Long, String> getSubmitTaskStatus(List<Long> taskIds) {
        return FLOW_RU_TASK_ENTITY_SERVICE.getSubmitTaskStatus(taskIds);
    }

    public boolean submitTask(Long taskId) {
        return this.submitTask(Collections.singletonList(taskId)).get(taskId);
    }

    protected FlowMsgMergeEnumBO getFlowRuMsgEnum(DynamicObject task) {
        DynamicObject proc = FLOW_RU_PROC_ENTITY_SERVICE.queryRuProcByPk(task.getLong("flowruproc_id"));
        String flowType = proc.getString("workflowtype");
        FlowMsgMergeEnumBO ret = null;
        if ("1".equals(flowType)) {
            ret = new FlowMsgMergeEnumBO(FlowRuMsgMergeEnum.START_FORMULATE_SIN, FlowRuMsgMergeEnum.START_FORMULATE_MUL);
        } else if ("2".equals(flowType)) {
            ret = new FlowMsgMergeEnumBO(FlowRuMsgMergeEnum.START_EVALUATE_SIN, FlowRuMsgMergeEnum.START_EVALUATE_MUL);
        } else if ("3".equals(flowType)) {
            ret = new FlowMsgMergeEnumBO(FlowRuMsgMergeEnum.START_INTERVIEW_SIN, FlowRuMsgMergeEnum.START_INTERVIEW_MUL);
        }
        return ret;
    }

    public Map<Long, Boolean> submitTask(List<Long> taskIds) {
        return this.submitTaskToMQ(taskIds);
    }

    public Map<Long, Boolean> submitTaskToMQ(List<Long> taskIds) {
        LOG.info("submitTaskToMQ start taskIds={}", taskIds);
        if (CollectionUtils.isEmpty(taskIds)) {
            return new HashMap<Long, Boolean>(0);
        }
        DynamicObject[] tasks = FLOW_RU_TASK_ENTITY_SERVICE.loadTasksByIds(taskIds);
        List<Long> procIds = Arrays.stream(tasks).map(e -> e.getLong("flowruproc.id")).distinct().collect(Collectors.toList());
        DynamicObject[] ruProcs = FLOW_RU_PROC_ENTITY_SERVICE.queryProcByPkIds(procIds);
        Map<Long, DynamicObject> procMap = Arrays.stream(ruProcs).collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
        List<DynamicObject> submitTasks = this.getValidSubmitTasks(tasks, procMap);
        FLOW_RUTASK_LOG_SERVICE.generateRuTaskLog(submitTasks);
        for (DynamicObject submitTask : submitTasks) {
            FLOW_RUSUP_DOMAIN_SERVICE.updateTaskStatus(submitTask, FlowRuTaskStatusEnum.PROCESSED.getCode(), new Date(), UserServiceHelper.getCurrentUserId());
        }
        FLOW_RU_TASK_ENTITY_SERVICE.save(submitTasks.toArray(new DynamicObject[0]));
        Map<Long, Boolean> resultMap = submitTasks.stream().map(o -> o.getLong("id")).collect(Collectors.toMap(k -> k, v -> Boolean.TRUE));
        for (Long taskId : taskIds) {
            if (null != resultMap.get(taskId)) continue;
            resultMap.put(taskId, Boolean.FALSE);
        }
        SubmitTaskPublisher.publish(submitTasks.stream().map(k -> k.getLong("id")).collect(Collectors.toList()));
        return resultMap;
    }

    public Map<Long, Boolean> dealSubmitTask(List<Long> taskIds, Boolean isAutoSubmit) {
        LOG.info("submitTask start taskIds={}", taskIds);
        if (CollectionUtils.isEmpty(taskIds)) {
            return new HashMap<Long, Boolean>(0);
        }
        DynamicObject[] tasks = FLOW_RU_TASK_ENTITY_SERVICE.queryTaskByPks(taskIds);
        List<Long> procIds = Arrays.stream(tasks).map(e -> e.getLong("flowruproc.id")).distinct().collect(Collectors.toList());
        DynamicObject[] ruProcs = FLOW_RU_PROC_ENTITY_SERVICE.queryProcByPkIds(procIds);
        Map<Long, DynamicObject> procMap = Arrays.stream(ruProcs).collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
        List<DynamicObject> submitTasks = Arrays.stream(tasks).collect(Collectors.toList());
        ConcurrentHashMap<Long, Boolean> submitResult = new ConcurrentHashMap<Long, Boolean>(16);
        List<DynamicObject> runNextTaskAll = Collections.synchronizedList(new ArrayList(10));
        int count = submitTasks.size();
        CopyOnWriteArrayList<DynamicObject> runNextTasks = new CopyOnWriteArrayList<DynamicObject>();
        for (int j = 0; j < count; ++j) {
            try {
                submitResult.putAll(this.doSubmitTasks(procMap, submitTasks, runNextTasks));
                if (isAutoSubmit.booleanValue()) continue;
                runNextTaskAll.addAll(runNextTasks);
                continue;
            }
            catch (Exception exception) {
                LOG.error((Throwable)exception);
            }
        }
        HashMap<Long, Long> soureOfJumpTaskMap = new HashMap<Long, Long>(16);
        List<Long> needAutoSubmitTaskIds = this.queryJumpTasks(ruProcs, ruProcs[0].getString("workflowtype"), soureOfJumpTaskMap);
        LOG.info("\u3010OPMC\u3011-dealSubmitTask-queryJumpTasks,traceId={},taskIds={},needAutoSubmitTaskIds={}", new Object[]{RequestContext.get().getTraceId(), taskIds, needAutoSubmitTaskIds});
        if (needAutoSubmitTaskIds.size() > 0) {
            if ("2".equals(ruProcs[0].getString("workflowtype"))) {
                QFilter taskFilter = new QFilter("id", "in", needAutoSubmitTaskIds);
                DynamicObject[] jumpTaskDyns = FLOW_RU_TASK_ENTITY_SERVICE.queryOriginalArray("id,flowrunode.id,handler.id,flowruproc.id", new QFilter[]{taskFilter});
                Map jumpProcTaskMap = Arrays.stream(jumpTaskDyns).collect(Collectors.groupingBy(e -> e.getLong("flowruproc.id"), Collectors.mapping(e -> e.getLong("id"), Collectors.toList())));
                for (Map.Entry jumpProcTaskEntry : jumpProcTaskMap.entrySet()) {
                    Long procTmpId = jumpProcTaskEntry.getKey();
                    List jumpTaskValues = jumpProcTaskEntry.getValue();
                    for (Long jumpTaskId : jumpTaskValues) {
                        try {
                            boolean genEvaRecordResult = IEPAActEvalRecordService.getInstance().genEvalRecordForJump((Long)soureOfJumpTaskMap.get(jumpTaskId), procMap.get(procTmpId).getLong("actevalobj"), Collections.singletonList(jumpTaskId));
                            if (genEvaRecordResult) continue;
                            needAutoSubmitTaskIds.remove(jumpTaskId);
                        }
                        catch (Exception e2) {
                            needAutoSubmitTaskIds.remove(jumpTaskId);
                            LOG.error("\u3010OPMC\u3011-genEvalRecordForJump error,message is {0}", (Throwable)e2);
                        }
                    }
                }
            }
            this.dealSubmitTask(needAutoSubmitTaskIds, Boolean.TRUE);
        }
        long startProcessMsg = System.currentTimeMillis();
        this.submitTaskMessage(runNextTaskAll);
        long endProcessMsg = System.currentTimeMillis();
        LOG.info("dealSubmitTask process msg :{} ms,task size is :{}", (Object)(endProcessMsg - startProcessMsg), (Object)taskIds.size());
        return taskIds.stream().collect(Collectors.toMap(k -> k, v -> submitResult.getOrDefault(v, false)));
    }

    protected List<DynamicObject> getValidSubmitTasks(DynamicObject[] submitTasks, Map<Long, DynamicObject> procMap) {
        ArrayList<DynamicObject> retTasks = new ArrayList<DynamicObject>(submitTasks.length);
        for (DynamicObject task : submitTasks) {
            boolean isTaskStatusValid;
            DynamicObject ruProc = procMap.get(task.getLong("flowruproc.id"));
            String procStatus = ruProc.getString("procstatus");
            boolean isProcStatusValid = FlowRuProcStatusEnum.RUNNING.getCode().equals(procStatus) || FlowRuProcStatusEnum.PENDING.getCode().equals(procStatus);
            String taskStatus = task.getString("taskstatus");
            boolean bl = isTaskStatusValid = FlowRuTaskStatusEnum.WAITING.getCode().equals(taskStatus) || FlowRuTaskStatusEnum.PROCESSING.getCode().equals(taskStatus) || FlowRuTaskStatusEnum.BE_WAITTING.getCode().equals(taskStatus);
            if (!isProcStatusValid || !isTaskStatusValid) continue;
            retTasks.add(task);
        }
        return retTasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<Long, Boolean> doSubmitTasks(Map<Long, DynamicObject> procMap, List<DynamicObject> submitTasks, List<DynamicObject> runNextTasks) {
        if (CollectionUtils.isEmpty(submitTasks)) {
            return new HashMap<Long, Boolean>(0);
        }
        Map<Long, Boolean> result = submitTasks.stream().collect(Collectors.toMap(k -> k.getLong("id"), v -> true));
        LOG.info("doSubmitTasks start");
        long start = System.currentTimeMillis();
        for (DynamicObject task : submitTasks) {
            long submitStart = System.currentTimeMillis();
            DynamicObject ruProc = procMap.get(task.getLong("flowruproc.id"));
            LOG.info("doSubmitTasks start taskId={},traceId={}", (Object)task.getLong("id"), (Object)RequestContext.get().getTraceId());
            long updateTaskStart = System.currentTimeMillis();
            try (TXHandle txhandle = TX.required();){
                Boolean canJump;
                Map jumpTaskMap;
                FLOW_COOPERATE_RU_PROC_DOMAIN_SERVICE.dealTaskStatusForSubmit(task);
                long updateTaskStartEnd = System.currentTimeMillis();
                LOG.info("doSubmitTasks-updateTask takes time :" + (updateTaskStartEnd - updateTaskStart) + "ms");
                Long nodeDefId = task.getLong("flowrunode.flownodedef.id");
                QFilter nodeFilter = new QFilter("id", "=", (Object)nodeDefId);
                DynamicObject nodeDefDyn = FLOW_DEF_NODE_ENTITY_SERVICE.queryOne("nodetype.id", new QFilter[]{nodeFilter});
                if ("1".equals(ruProc.getString("workflowtype")) && !NodeTypeConstants.INDICATOR_AUDIT.equals(nodeDefDyn.get("nodetype.id")) || "3".equals(ruProc.getString("workflowtype")) && NodeTypeConstants.INTERVIEW_WRITE.equals(nodeDefDyn.get("nodetype.id"))) {
                    DynamicObject[] taskDynArr = FLOW_RU_TASK_ENTITY_SERVICE.queryTasksByRunRoleId(task.getLong("flowrurole.id"));
                    ArrayList<DynamicObject> taskList = new ArrayList<DynamicObject>(10);
                    for (DynamicObject taskObj : taskDynArr) {
                        if (task.getLong("id") == taskObj.getLong("id") || FlowRuTaskStatusEnum.PENDING.getCode().equals(taskObj.getString("taskstatus"))) continue;
                        taskObj.set("taskstatus", (Object)FlowRuTaskStatusEnum.EXPIRED.getCode());
                        taskList.add(taskObj);
                    }
                    if (taskList.size() > 0) {
                        FLOW_RU_TASK_ENTITY_SERVICE.save(taskList.toArray(new DynamicObject[0]));
                    }
                }
                boolean isRunNext = this.runProcess(task.getLong("flowrurole.id"), task.getLong("flowrunode.id"), task.getLong("flowruproc.id"), ruProc.getLong("actevalobj"));
                HRPluginProxy pluginProxy = HRPlugInProxyFactory.create((Object)I_JUMP_TASK_FOR_NO_AUDITOR_SERVICE, IJumpTaskForNoAuditorService.class, (String)"kd.opmc.pbs.business.domain.extpoint.IJumpTaskForNoAuditorService#needJumpTasks", (PluginFilter)null);
                List needJumpTasks = pluginProxy.callReplaceIfPresent(p -> p.needJumpTasks(task));
                if (CollectionUtils.isNotEmpty((Collection)needJumpTasks) && !(jumpTaskMap = (Map)needJumpTasks.get(0)).isEmpty() && Boolean.TRUE.equals(canJump = jumpTaskMap.keySet().stream().findFirst().orElse(Boolean.FALSE))) {
                    DynamicObject jumpTask = (DynamicObject)jumpTaskMap.get(true);
                    isRunNext = this.runProcess(jumpTask.getLong("flowrurole.id"), jumpTask.getLong("flowrunode.id"), jumpTask.getLong("flowruproc.id"), ruProc.getLong("actevalobj"));
                }
                if (isRunNext) {
                    runNextTasks.add(task);
                }
            }
            long submitEnd = System.currentTimeMillis();
            LOG.info("doSubmitTasks takes time :" + (submitEnd - submitStart) + "ms");
        }
        long processTasks = System.currentTimeMillis();
        LOG.info("doSubmitTasks process tasks :{}", (Object)(processTasks - start + "ms"));
        return result;
    }

    protected void submitTaskMessage(List<DynamicObject> runNextTasks) {
        if (CollectionUtils.isEmpty(runNextTasks)) {
            return;
        }
        Set<Long> sendProcIds = runNextTasks.stream().map(e -> e.getLong("flowruproc.id")).collect(Collectors.toSet());
        DynamicObject[] waitingTasks = FLOW_RU_TASK_ENTITY_SERVICE.queryWaittingTasksByProcIds(sendProcIds);
        this.sendMessageMerge(waitingTasks);
    }

    protected void sendMessageMerge(DynamicObject[] waitingTasks) {
        if (null == waitingTasks || waitingTasks.length == 0) {
            return;
        }
        List<Long> waitingTaskIds = Arrays.stream(waitingTasks).map(e -> e.getLong("id")).collect(Collectors.toList());
        FlowMsgMergeEnumBO bo = this.getFlowRuMsgEnum(waitingTasks[0]);
        SendMessageDTO dto = new SendMessageDTO(waitingTaskIds, bo);
        FLOW_HANDLER_BATCH_DOMAIN_SERVICE.sendMessageMerge(Collections.singletonList(dto));
    }

    protected List<DynamicObject> submitCorssTasks(List<DynamicObject> submitRunNextTasks, DynamicObject[] waitingTasks) {
        List<DynamicObject> msgTasks = Arrays.stream(waitingTasks).collect(Collectors.toList());
        Map crossNodeRoleIdsMap = submitRunNextTasks.stream().filter(e -> e.getBoolean("iscrossevaluate")).collect(Collectors.groupingBy(e -> e.getLong("flowrunode.id"), Collectors.mapping(e -> e.getLong("flowrurole.id"), Collectors.toSet())));
        List waitingCrossTasks = Arrays.stream(waitingTasks).filter(e -> e.getBoolean("iscrossevaluate") && crossNodeRoleIdsMap.containsKey(e.getLong("flowrunode.id"))).collect(Collectors.toList());
        Set roleIds = submitRunNextTasks.stream().map(e -> e.getLong("flowrurole.id")).collect(Collectors.toSet());
        roleIds.addAll(waitingCrossTasks.stream().map(e -> e.getLong("flowrurole.id")).collect(Collectors.toSet()));
        DynamicObject[] roles = FLOW_RU_ROLE_ENTITY_SERVICE.loadRuRoleByIds(new ArrayList<Long>(roleIds));
        Map<Long, String> roleSetNoMap = Arrays.stream(roles).collect(Collectors.toMap(k -> k.getLong("id"), v -> v.getString("setno")));
        for (DynamicObject crossTask : waitingCrossTasks) {
            if (!crossNodeRoleIdsMap.containsKey(crossTask.getLong("flowrunode.id"))) continue;
            String crossRoleSetNo = roleSetNoMap.get(crossTask.getLong("flowrurole.id"));
            Set nodeRoleIds = crossNodeRoleIdsMap.get(crossTask.getLong("flowrunode.id"));
            boolean setNoEquals = nodeRoleIds.stream().anyMatch(e -> crossRoleSetNo.equals(roleSetNoMap.get(e)));
            if (setNoEquals) continue;
            msgTasks.removeIf(e -> e == crossTask);
        }
        return msgTasks;
    }

    protected boolean runProcess(Long ruRoleId, Long ruNodeId, Long ruProcId, Long actEvalObjId) {
        DynamicObject ruNode = FLOW_RU_NODE_ENTITY_SERVICE.queryRuNodeByPk(ruNodeId);
        DynamicObject ruRole = FLOW_RU_ROLE_ENTITY_SERVICE.queryRuRoleByPk(ruRoleId);
        if (this.checkAndRunRole(ruRoleId, ruRole)) {
            return false;
        }
        boolean isExistUnHandleTask = FLOW_RUSUP_DOMAIN_SERVICE.isExistUnHandleTask(ruRole, ruNode, ruProcId);
        boolean isAllConcurrentRoleFinshed = Boolean.TRUE;
        DynamicObject[] concurrentRuRoles = FLOW_RU_ROLE_ENTITY_SERVICE.queryConcurrentRuRole(ruNodeId, ruRoleId, ruRole.getInt("turnoversort"));
        isAllConcurrentRoleFinshed = this.judgeIsAllConcurrentRuRolesFinshed(concurrentRuRoles);
        if (!isAllConcurrentRoleFinshed) {
            return false;
        }
        boolean isPending = Boolean.FALSE;
        DynamicObject[] nextRoles = FLOW_RU_ROLE_ENTITY_SERVICE.queryNextNeedActiveRunRole(ruNodeId, ruRole.getInt("turnoversort"), "");
        if (nextRoles.length > 0 && !isExistUnHandleTask) {
            DynamicObject ruProc = FLOW_RU_PROC_ENTITY_SERVICE.queryRuProcByPk(ruProcId);
            ArrayList<DynamicObject> nextToActiveRoleList = new ArrayList<DynamicObject>(nextRoles.length);
            for (DynamicObject nextRole : nextRoles) {
                if (FlowRuRoleStatusEnum.PENDING.getCode().equals(nextRole.getString("rolestatus"))) continue;
                nextToActiveRoleList.add(nextRole);
            }
            if (nextToActiveRoleList.size() > 0) {
                isPending = FLOW_RUSUP_DOMAIN_SERVICE.activeRuRole(ruNode, ruProc, nextToActiveRoleList.toArray(new DynamicObject[0]));
            }
            if (isPending) {
                WorkflowUtils.updateStatus(ruNode, "nodestatus", FlowRuNodeStatusEnum.PENDING.getCode());
                FLOW_RU_NODE_ENTITY_SERVICE.saveOne(ruNode);
                WorkflowUtils.updateStatus(ruProc, "procstatus", FlowRuProcStatusEnum.PENDING.getCode());
            }
            this.setCurrentRunRole(ruProc, ruNode);
            FLOW_RU_PROC_ENTITY_SERVICE.saveOne(ruProc);
            return true;
        }
        if (this.checkAndRunNode(ruNodeId, ruNode)) {
            return false;
        }
        DynamicObject ruProc = FLOW_RU_PROC_ENTITY_SERVICE.queryRuProcByPk(ruProcId);
        if ("2".equals(ruProc.getString("workflowtype")) && this.judgeCurNodeIsEvaNodeNotLast(ruProcId, ruNodeId)) {
            long calcNodeResultStart = System.currentTimeMillis();
            try {
                IEPA_EVAL_RESULT_CALC_SERVICE.calcRuNodeResult(ruNodeId, actEvalObjId);
            }
            catch (Exception e) {
                LOG.error("calcRuNodeResult error:", (Throwable)e);
            }
            long calcNodeResultEnd = System.currentTimeMillis();
            LOG.info("calcRuNodeResult takes time :" + (calcNodeResultEnd - calcNodeResultStart) + "ms");
        }
        if ("2".equals(ruProc.getString("workflowtype")) && this.judgeCurrentNodeIsLastEvaNode(ruProcId, ruNodeId)) {
            long calcRuProcResultStart = System.currentTimeMillis();
            try {
                IEPA_EVAL_RESULT_CALC_SERVICE.calcRuProcResult(ruNodeId, ruProcId, actEvalObjId);
            }
            catch (Exception e) {
                LOG.error("calcRuProcResult error:", (Throwable)e);
            }
            long calcRuProcResultEnd = System.currentTimeMillis();
            LOG.info("calcRuProcResult takes time :" + (calcRuProcResultEnd - calcRuProcResultStart) + "ms");
        }
        if (!isExistUnHandleTask) {
            this.checkAndRunProcess(ruProcId, ruProc);
        }
        return true;
    }

    private boolean judgeIsAllConcurrentRuRolesFinshed(DynamicObject[] concurrentRuRoles) {
        boolean isAllConcurrentRoleFinshed = Boolean.TRUE;
        for (DynamicObject concurrentRole : concurrentRuRoles) {
            if (FlowRuRoleStatusEnum.FINISHED.getCode().equals(concurrentRole.getString("rolestatus")) || FlowRuRoleStatusEnum.EXPIRED.getCode().equals(concurrentRole.getString("rolestatus"))) continue;
            isAllConcurrentRoleFinshed = Boolean.FALSE;
        }
        return isAllConcurrentRoleFinshed;
    }

    private boolean judgeCurrentNodeIsLastEvaNode(Long ruProcId, Long ruNodeId) {
        DynamicObject ruProc = FLOW_RU_PROC_ENTITY_SERVICE.queryRuProcByPk(ruProcId);
        int currentNodeIndex = ruProc.getInt("currentnode.index");
        DynamicObject currentRuNode = FLOW_RU_NODE_ENTITY_SERVICE.queryRuNodeByPk(ruNodeId);
        if (ruProc.getInt("nodenum") > currentNodeIndex) {
            DynamicObject nextRuNode = FLOW_RU_NODE_ENTITY_SERVICE.queryRuNodeByIndex(ruProcId, currentNodeIndex + 1);
            if ((NodeTypeConstants.EVALUATE_SCORE.equals(currentRuNode.getLong("flownodedef.nodetype.id")) || NodeTypeConstants.BATCH_EVALUSUMSCORE.equals(currentRuNode.getLong("flownodedef.nodetype.id"))) && !NodeTypeConstants.EVALUATE_SCORE.equals(nextRuNode.getLong("flownodedef.nodetype.id")) && !NodeTypeConstants.BATCH_EVALUSUMSCORE.equals(nextRuNode.getLong("flownodedef.nodetype.id"))) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (NodeTypeConstants.EVALUATE_SCORE.equals(currentRuNode.getLong("flownodedef.nodetype.id")) || NodeTypeConstants.BATCH_EVALUSUMSCORE.equals(currentRuNode.getLong("flownodedef.nodetype.id"))) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private boolean judgeCurNodeIsEvaNodeNotLast(Long ruProcId, Long ruNodeId) {
        DynamicObject ruProc = FLOW_RU_PROC_ENTITY_SERVICE.queryRuProcByPk(ruProcId);
        int currentNodeIndex = ruProc.getInt("currentnode.index");
        DynamicObject currentRuNode = FLOW_RU_NODE_ENTITY_SERVICE.queryRuNodeByPk(ruNodeId);
        if ((NodeTypeConstants.EVALUATE_SCORE.equals(currentRuNode.getLong("flownodedef.nodetype.id")) || NodeTypeConstants.BATCH_EVALUSUMSCORE.equals(currentRuNode.getLong("flownodedef.nodetype.id"))) && ruProc.getInt("nodenum") > currentNodeIndex) {
            DynamicObject nextRuNode = FLOW_RU_NODE_ENTITY_SERVICE.queryRuNodeByIndex(ruProcId, currentNodeIndex + 1);
            if (NodeTypeConstants.EVALUATE_SCORE.equals(nextRuNode.getLong("flownodedef.nodetype.id")) || NodeTypeConstants.BATCH_EVALUSUMSCORE.equals(nextRuNode.getLong("flownodedef.nodetype.id"))) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        return Boolean.FALSE;
    }

    private boolean checkAndRunRole(long ruRoleId, DynamicObject ruRole) {
        Boolean isRoleCanRun = Boolean.FALSE;
        if (FlowRuRoleStatusEnum.FINISHED.getCode().equals(ruRole.getString("rolestatus")) || FlowRuRoleStatusEnum.EXPIRED.getCode().equals(ruRole.getString("rolestatus")) || FlowRuRoleStatusEnum.PENDING.getCode().equals(ruRole.getString("rolestatus")) || FlowRuRoleStatusEnum.NOT_ACTIVE.getCode().equals(ruRole.getString("rolestatus"))) {
            String msg = String.format("checkAndRunRole: runtime role status is invalid, ruRoleId:%s", ruRoleId);
            LOG.error(msg);
            isRoleCanRun = Boolean.TRUE;
        }
        String outFlow = ruRole.getString("flowdefrole.outflow");
        FlowDefRoleOutEnum outEnum = FlowDefRoleOutEnum.getOutEnumByCode(outFlow);
        if (ruRole.getBoolean("iscrossrole")) {
            outEnum = FlowDefRoleOutEnum.ALL_HANDLER;
        }
        switch (outEnum) {
            case FIRST_SUBMIT: {
                if (!this.runSetOutNumRole(ruRoleId, 1)) break;
                return true;
            }
            case SET_OUT_NUM: {
                int minNum = ruRole.getInt("flowdefrole.minnum");
                if (!this.runSetOutNumRole(ruRoleId, minNum)) break;
                return true;
            }
            case ALL_HANDLER: {
                if (FLOW_RU_TASK_ENTITY_SERVICE.countUnhandTaskByRoleId(ruRoleId) <= 0) break;
                return true;
            }
        }
        if (!isRoleCanRun.booleanValue()) {
            Date date = new Date();
            ruRole.set("rolestatus", (Object)FlowRuRoleStatusEnum.FINISHED.getCode());
            ruRole.set("updatestatustime", (Object)date);
            ruRole.set("modifier", (Object)UserServiceHelper.getCurrentUserId());
            ruRole.set("modifytime", (Object)date);
            FLOW_RU_ROLE_ENTITY_SERVICE.saveOne(ruRole);
        }
        return isRoleCanRun;
    }

    private boolean runSetOutNumRole(Long ruRoleId, int minNum) {
        DynamicObject[] tasks = FLOW_RU_TASK_ENTITY_SERVICE.queryValidTaskByRoleId(ruRoleId);
        int processedCount = 0;
        ArrayList<DynamicObject> needExpiredTasks = new ArrayList<DynamicObject>();
        Date date = new Date();
        for (DynamicObject task : tasks) {
            if (FlowRuTaskStatusEnum.PROCESSED.getCode().equals(task.getString("taskstatus"))) {
                ++processedCount;
                continue;
            }
            if (FlowRuTaskStatusEnum.PENDING.getCode().equals(task.getString("taskstatus"))) continue;
            FLOW_RUSUP_DOMAIN_SERVICE.updateTaskStatus(task, FlowRuTaskStatusEnum.EXPIRED.getCode(), date, UserServiceHelper.getCurrentUserId());
            needExpiredTasks.add(task);
        }
        if (processedCount == tasks.length || processedCount >= minNum) {
            DynamicObject[] coopTaskDyns;
            List<Long> needExpiredMainTaskIdList = needExpiredTasks.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
            for (DynamicObject coopTask : coopTaskDyns = FLOW_RU_TASK_ENTITY_SERVICE.loadCoopTasksByMainTaskIds(needExpiredMainTaskIdList)) {
                if (coopTask.getString("taskstatus").equals(FlowRuTaskStatusEnum.PROCESSED.getCode())) continue;
                FLOW_RUSUP_DOMAIN_SERVICE.updateTaskStatus(coopTask, FlowRuTaskStatusEnum.EXPIRED.getCode(), date, UserServiceHelper.getCurrentUserId());
                needExpiredTasks.add(coopTask);
            }
            if (needExpiredTasks.size() > 0) {
                FLOW_RU_TASK_ENTITY_SERVICE.save(needExpiredTasks.toArray(new DynamicObject[0]));
            }
            return false;
        }
        return true;
    }

    private boolean checkAndRunNode(Long ruNodeId, DynamicObject ruNode) {
        boolean isNodeStatusValid;
        String nodeStatus = ruNode.getString("nodestatus");
        boolean bl = isNodeStatusValid = FlowRuNodeStatusEnum.FINISHED.getCode().equals(nodeStatus) || FlowRuNodeStatusEnum.EXPIRED.getCode().equals(nodeStatus);
        if (isNodeStatusValid) {
            String msg = String.format("checkAndRunNode: runtime node status is invalid, ruNodeId:%s", ruNodeId);
            LOG.error(msg);
            throw new KDException(new ErrorCode("checkAndRunNode", msg), new Object[0]);
        }
        if (FLOW_RU_ROLE_ENTITY_SERVICE.countUnhandRoleByNodeId(ruNodeId) > 0) {
            return true;
        }
        Date date = new Date();
        ruNode.set("nodestatus", (Object)FlowRuNodeStatusEnum.FINISHED.getCode());
        ruNode.set("updatestatustime", (Object)date);
        ruNode.set("modifier", (Object)UserServiceHelper.getCurrentUserId());
        ruNode.set("modifytime", (Object)date);
        FLOW_RU_NODE_ENTITY_SERVICE.saveOne(ruNode);
        return false;
    }

    private boolean checkAndRunProcess(Long ruProcId, DynamicObject ruProc) {
        boolean isProcFinished;
        if (!FlowRuProcStatusEnum.RUNNING.getCode().equals(ruProc.getString("procstatus")) && !FlowRuProcStatusEnum.PENDING.getCode().equals(ruProc.getString("procstatus"))) {
            String msg = String.format("checkAndRunProcess: runtime process status is invalid, ruProcId:%s", ruProcId);
            LOG.error(msg);
            throw new KDException(new ErrorCode("checkAndRunProcess", msg), new Object[0]);
        }
        Date date = new Date();
        long userId = UserServiceHelper.getCurrentUserId();
        int currentNodeIndex = ruProc.getInt("currentnode.index");
        if (ruProc.getInt("nodenum") > currentNodeIndex) {
            isProcFinished = false;
            LOG.info("**************flow checkAndRunProcess: ruProcId {} actevalobj {} **************", (Object)ruProcId, (Object)ruProc.getLong("actevalobj"));
            DynamicObject ruNode = FLOW_RU_NODE_ENTITY_SERVICE.queryRuNodeByIndex(ruProcId, currentNodeIndex + 1);
            ruNode = this.checkNodeStatus(ruProc, ruNode, currentNodeIndex + 2);
            ruProc.set("currentnode", (Object)ruNode);
            if (FLOW_RUSUP_DOMAIN_SERVICE.activeRuNode(ruNode, ruProc)) {
                ruProc.set("procstatus", (Object)FlowRuProcStatusEnum.PENDING.getCode());
                ruProc.set("updatestatustime", (Object)date);
            }
            this.setCurrentRunRole(ruProc, ruNode);
        } else {
            LOG.info("=============flow checkAndRunProcess: ruProcId {} actevalobj {} ==============", (Object)ruProcId, (Object)ruProc.getLong("actevalobj"));
            isProcFinished = true;
            ruProc.set("procstatus", (Object)FlowRuProcStatusEnum.FINISHED.getCode());
            ruProc.set("currentnode", null);
            ruProc.set("entryentity", null);
            ruProc.set("updatestatustime", (Object)date);
            if (HRStringUtils.equals((String)ruProc.getString("workflowtype"), (String)"2")) {
                IEPA_ACTEVALOBJ_SERVICE.completeEvaluate(ruProc.getLong("actevalobj"));
            }
            if (HRStringUtils.equals((String)ruProc.getString("workflowtype"), (String)"1")) {
                IEPA_ACTEVALOBJ_SERVICE.finishIndicator(Collections.singletonList(ruProc.getLong("actevalobj")));
            }
            if (HRStringUtils.equals((String)ruProc.getString("workflowtype"), (String)"3")) {
                IEPA_ACTEVALOBJ_SERVICE.finishIntview(Collections.singletonList(ruProc.getLong("actevalobj")));
            }
        }
        ruProc.set("modifier", (Object)userId);
        ruProc.set("modifytime", (Object)date);
        FLOW_RU_PROC_ENTITY_SERVICE.saveOne(ruProc);
        if (HRStringUtils.equals((String)ruProc.getString("workflowtype"), (String)"2") || HRStringUtils.equals((String)ruProc.getString("workflowtype"), (String)"1")) {
            HRPluginProxy pluginProxy = HRPlugInProxyFactory.create((Object)I_WORKFLOW_SUPPORT_COPY_SERVICE, IWorkflowSupportCopyService.class, (String)"kd.opmc.pbs.business.domain.extpoint.IWorkflowSupportCopyService#supportCopy", (PluginFilter)null);
            pluginProxy.callReplaceIfPresent(p -> {
                p.supportCopy(ruProc, isProcFinished);
                return null;
            });
        }
        return isProcFinished;
    }

    private DynamicObject checkNodeStatus(DynamicObject ruProc, DynamicObject ruNode, int nextNodeIndex) {
        if (HRStringUtils.equals((String)FlowRuNodeStatusEnum.FINISHED.getCode(), (String)ruNode.getString("nodestatus"))) {
            int nodenum = ruProc.getInt("nodenum");
            long ruProcId = ruProc.getLong("id");
            for (int i = nextNodeIndex; i <= nodenum; ++i) {
                DynamicObject tempRuNode = FLOW_RU_NODE_ENTITY_SERVICE.queryRuNodeByIndex(ruProcId, i);
                if (HRStringUtils.equals((String)FlowRuNodeStatusEnum.FINISHED.getCode(), (String)tempRuNode.getString("nodestatus"))) continue;
                return tempRuNode;
            }
        }
        return ruNode;
    }

    public boolean isAllowedChangeHandler(Long ruTaskId) {
        DynamicObject task = FLOW_RU_TASK_ENTITY_SERVICE.queryTaskByPk(ruTaskId);
        String taskStatus = task.getString("taskstatus");
        return FlowRuTaskStatusEnum.WAITING.getCode().equals(taskStatus) || FlowRuTaskStatusEnum.PROCESSING.getCode().equals(taskStatus);
    }

    public void pauseProcessForChangeHandler(Long ruProcId) {
        FLOW_RUSECOND_DOMAIN_SERVICE.pauseProcessForChangeHandler(ruProcId);
    }

    public boolean isFormulateLastTask(Long taskId) {
        return FLOW_RUSECOND_DOMAIN_SERVICE.isFormulateLastTask(taskId);
    }

    public boolean changeHandler(Long ruTaskId, Long newHandlerId) {
        return FLOW_RUSUP_DOMAIN_SERVICE.changeHandler(ruTaskId, newHandlerId);
    }

    public FlowCommonResultBo verifyHandlerBeforeStartProcess(List<Long> actEvalObjIds) {
        return FLOW_RUSUP_DOMAIN_SERVICE.verifyHandlerBeforeStartProcess(actEvalObjIds);
    }

    public DynamicObject[] queryProcByEvaObjIds(List<Long> actEvalObjIds) {
        return FLOW_RU_PROC_ENTITY_SERVICE.queryProcByEvaObjIds(actEvalObjIds);
    }

    public FlowCommonResultBo exitProcess(Long ruProcId, String reason) {
        FlowParamBo flowParamBo = new FlowParamBo();
        String remark = ResManager.loadKDString((String)"\u9000\u51fa\u6d41\u7a0b", (String)"FlowRuProcDomainService_0", (String)"opmc-pbs-business", (Object[])new Object[0]);
        flowParamBo.setRemark(remark);
        flowParamBo.setRuProcId(ruProcId);
        flowParamBo.setOpType(FLowOpEnum.EXIT.getValue());
        flowParamBo.setProcStatus(FlowRuProcStatusEnum.DEPRECATED.getCode());
        flowParamBo.setNodeStatus(FlowRuNodeStatusEnum.EXPIRED.getCode());
        flowParamBo.setRoleStatus(FlowRuRoleStatusEnum.EXPIRED.getCode());
        flowParamBo.setTaskStatus(FlowRuTaskStatusEnum.EXPIRED.getCode());
        return this.dealProcessStatus(Collections.singletonList(flowParamBo), reason, FLowOpEnum.EXIT.getValue()).get(0);
    }

    public List<FlowCommonResultBo> stopProcess(List<Long> ruProcIdList, String reason) {
        ArrayList<FlowParamBo> flowParamBoList = new ArrayList<FlowParamBo>(10);
        for (Long ruProcId : ruProcIdList) {
            FlowParamBo flowParamBo = new FlowParamBo();
            String remark = ResManager.loadKDString((String)"\u7ed3\u675f\u6d41\u7a0b", (String)"FlowRuProcDomainService_1", (String)"opmc-pbs-business", (Object[])new Object[0]);
            flowParamBo.setRemark(remark);
            flowParamBo.setRuProcId(ruProcId);
            flowParamBo.setOpType(FLowOpEnum.STOP.getValue());
            flowParamBo.setProcStatus(FlowRuProcStatusEnum.FINISHED.getCode());
            flowParamBo.setNodeStatus(FlowRuNodeStatusEnum.FINISHED.getCode());
            flowParamBo.setRoleStatus(FlowRuRoleStatusEnum.FINISHED.getCode());
            flowParamBo.setTaskStatus(FlowRuTaskStatusEnum.EXPIRED.getCode());
            flowParamBoList.add(flowParamBo);
        }
        return this.dealProcessStatus(flowParamBoList, reason, FLowOpEnum.STOP.getValue());
    }

    private List<FlowCommonResultBo> dealProcessStatus(List<FlowParamBo> flowParamBoList, String reason, String opType) {
        String message;
        FlowCommonResultBo resultBo;
        ArrayList<FlowCommonResultBo> resultBoList = new ArrayList<FlowCommonResultBo>(10);
        List<Long> ruProcIdList = flowParamBoList.stream().filter(e -> null != e.getRuProcId() && 0L != e.getRuProcId()).map(FlowParamBo::getRuProcId).collect(Collectors.toList());
        DynamicObject[] ruProcDyns = FLOW_RU_PROC_ENTITY_SERVICE.queryProcByPkIds(ruProcIdList);
        ArrayList<DynamicObject> needUpdateProcList = new ArrayList<DynamicObject>(flowParamBoList.size());
        ArrayList<DynamicObject> needUpdateFlowRuNodeList = new ArrayList<DynamicObject>(10);
        ArrayList needUpdateRuRoleList = new ArrayList(10);
        ArrayList needUpdateRuTaskList = new ArrayList(10);
        ArrayList<DynamicObject> needUpdateOpRecordList = new ArrayList<DynamicObject>(10);
        Map<Long, DynamicObject> ruProcMap = Arrays.stream(ruProcDyns).collect(Collectors.toMap(rp -> rp.getLong("id"), proc -> proc));
        List<Long> currentRuNodeIdList = Arrays.stream(ruProcDyns).filter(proc -> !HRObjectUtils.isEmpty((Object)proc.getDynamicObject("currentnode"))).map(dy -> dy.getDynamicObject("currentnode").getLong("id")).collect(Collectors.toList());
        DynamicObject[] currentRuNodeDyns = FLOW_RU_NODE_ENTITY_SERVICE.loadRuNodeByIds(currentRuNodeIdList);
        Map<Long, DynamicObject> ruNodeMap = Arrays.stream(currentRuNodeDyns).collect(Collectors.toMap(rn -> rn.getLong("id"), runode -> runode));
        DynamicObject[] ruRoles = FLOW_RU_ROLE_ENTITY_SERVICE.queryRolesByNodeIds(currentRuNodeIdList.toArray(new Long[0]));
        Map ruRoleListMap = Arrays.stream(ruRoles).collect(Collectors.groupingBy(role -> role.getLong("flowrunode.id"), Collectors.mapping(role -> role, Collectors.toList())));
        List<Long> ruRoleIdList = Arrays.stream(ruRoles).map(dy -> dy.getLong("id")).collect(Collectors.toList());
        DynamicObject[] ruTaskDyns = FLOW_RU_TASK_ENTITY_SERVICE.loadTasksByRoleIds(ruRoleIdList);
        Map ruTaskListMap = Arrays.stream(ruTaskDyns).collect(Collectors.groupingBy(rt -> rt.getLong("flowrurole.id"), Collectors.mapping(task -> task, Collectors.toList())));
        Map<Long, Boolean> evaObjStartedMap = this.judgeWorkflowFlowIsStarted(ruProcIdList);
        for (FlowParamBo flowParamBo : flowParamBoList) {
            resultBo = new FlowCommonResultBo();
            Long ruProcId = flowParamBo.getRuProcId();
            if (null == ruProcId || 0L == ruProcId) {
                message = ResManager.loadKDString((String)"\u6d41\u7a0b\u5b9e\u4f8bID\u201c{0}\u201d\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u786e\u8ba4\u6570\u636e\u3002", (String)"FlowRuProcDomainService_2", (String)"opmc-pbs-business", (Object[])new Object[]{ruProcId});
                resultBo.setMessage(message);
                resultBo.setCode("-1");
                resultBo.setDataId(ruProcId);
                resultBoList.add(resultBo);
                continue;
            }
            DynamicObject ruProc = ruProcMap.get(ruProcId);
            if (HRObjectUtils.isEmpty((Object)ruProc)) {
                this.getFlowCommonResultBo(ResManager.loadKDString((String)"\u6d41\u7a0b\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"FlowRuProcDomainService_3", (String)"opmc-pbs-business", (Object[])new Object[0]), resultBo);
                resultBoList.add(resultBo);
                continue;
            }
            if (!evaObjStartedMap.get(ruProc.getLong("actevalobj")).booleanValue()) {
                String message2 = ResManager.loadKDString((String)"\u8bc4\u4f30\u5bf9\u8c61\u6d41\u7a0b\u5c1a\u672a\u542f\u52a8\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"FlowRuProcDomainService_4", (String)"opmc-pbs-business", (Object[])new Object[0]);
                resultBo.setMessage(message2);
                resultBo.setCode("-1");
                resultBo.setDataId(ruProcId);
                resultBoList.add(resultBo);
                continue;
            }
            ruProc.set("remark", (Object)flowParamBo.getRemark());
            DynamicObject opRecord = FLOW_RU_OP_ENTITY_SERVICE.generateOpRecord(ruProc);
            opRecord.set("optype", (Object)flowParamBo.getOpType());
            opRecord.set("description", (Object)reason);
            if (HRObjectUtils.isEmpty((Object)ruProc.getDynamicObject("currentnode"))) {
                String message3 = ResManager.loadKDString((String)"\u6d41\u7a0b\u201c\u5df2\u542f\u52a8\u201d\u6216\u201c\u5df2\u7ed3\u675f\u201d\uff0c\u5f53\u524d\u8282\u70b9\u5df2\u5931\u6548\u3002", (String)"FlowRuProcDomainService_5", (String)"opmc-pbs-business", (Object[])new Object[0]);
                resultBo.setMessage(message3);
                resultBo.setCode("-1");
                resultBo.setDataId(ruProcId);
                resultBoList.add(resultBo);
                continue;
            }
            long currentNodeId = ruProc.getDynamicObject("currentnode").getLong("id");
            String procStatus = ruProc.getString("procstatus");
            if (FlowRuProcStatusEnum.DEPRECATED.getCode().equals(procStatus) || FlowRuProcStatusEnum.FINISHED.getCode().equals(procStatus)) {
                String message4 = ResManager.loadKDString((String)"\u65e0\u6cd5\u64cd\u4f5c\u201c\u5df2\u5e9f\u5f03\u201d\u6216\u201c\u5df2\u5b8c\u6210\u201d\u7684\u6d41\u7a0b\u3002", (String)"FlowRuProcDomainService_6", (String)"opmc-pbs-business", (Object[])new Object[0]);
                resultBo.setMessage(message4);
                resultBo.setCode("-1");
                resultBo.setDataId(ruProcId);
                resultBoList.add(resultBo);
                continue;
            }
            needUpdateOpRecordList.add(opRecord);
            WorkflowUtils.updateStatus(ruProc, "procstatus", flowParamBo.getProcStatus());
            DynamicObject flowRuNode = ruNodeMap.get(currentNodeId);
            WorkflowUtils.updateStatus(flowRuNode, "nodestatus", flowParamBo.getNodeStatus());
            ArrayList<Long> currentRoleIds = new ArrayList<Long>(10);
            DynamicObjectCollection curRunRoleColl = ruProc.getDynamicObjectCollection("entryentity");
            for (DynamicObject entity : curRunRoleColl) {
                currentRoleIds.add(entity.getDynamicObject("ruroleid").getLong("id"));
            }
            List ruRoleList = ruRoleListMap.get(currentNodeId);
            ArrayList<DynamicObject> needToUpdateStatusTaskList = new ArrayList<DynamicObject>(10);
            for (DynamicObject ruRole : ruRoleList) {
                if (!currentRoleIds.contains(ruRole.getLong("id"))) continue;
                WorkflowUtils.updateStatus(ruRole, "rolestatus", flowParamBo.getRoleStatus());
                flowParamBo.getRuRoleColl().add((Object)ruRole);
                if (!HRStringUtils.equals((String)FLowOpEnum.STOP.getValue(), (String)opType)) continue;
                List flowRuTaskList = ruTaskListMap.get(ruRole.getLong("id"));
                for (DynamicObject tempTask : flowRuTaskList) {
                    if (tempTask.getString("taskstatus").equals(FlowRuTaskStatusEnum.PROCESSED.getCode())) continue;
                    needToUpdateStatusTaskList.add(tempTask);
                }
                WorkflowUtils.updateTaskStatus(needToUpdateStatusTaskList, flowParamBo.getTaskStatus());
                flowParamBo.getRuTaskColl().addAll(needToUpdateStatusTaskList);
                needToUpdateStatusTaskList.clear();
            }
            if (HRStringUtils.equals((String)FLowOpEnum.EXIT.getValue(), (String)opType)) {
                DynamicObject[] ruTasks = FLOW_RU_TASK_ENTITY_SERVICE.loadTasksByProcIds(Collections.singletonList(ruProcId));
                WorkflowUtils.updateTaskStatus(ruTasks, FlowRuTaskStatusEnum.EXPIRED.getCode());
                flowParamBo.getRuTaskColl().addAll((Collection)Arrays.stream(ruTasks).collect(Collectors.toList()));
            }
            if (HRStringUtils.equals((String)FLowOpEnum.STOP.getValue(), (String)opType)) {
                DynamicObject[] ruNodeDyns;
                QFilter qFilter = new QFilter("flowruproc", "in", Collections.singletonList(ruProcId));
                qFilter.and("taskstatus", "!=", (Object)FlowRuTaskStatusEnum.PROCESSED.getCode());
                DynamicObject[] toBeExpiredTasks = FLOW_RU_TASK_ENTITY_SERVICE.loadTasksByCusFilter(qFilter);
                WorkflowUtils.updateTaskStatus(toBeExpiredTasks, FlowRuTaskStatusEnum.EXPIRED.getCode());
                flowParamBo.getRuTaskColl().addAll(Arrays.asList(toBeExpiredTasks));
                for (DynamicObject ruNode : ruNodeDyns = FLOW_RU_NODE_ENTITY_SERVICE.loadAllRuNodeByProcIds(Collections.singletonList(ruProcId))) {
                    if (HRObjectUtils.equals((Object)ruNode.getLong("id"), (Object)currentNodeId) || ruNode.getString("nodestatus").equals(FlowRuNodeStatusEnum.FINISHED.getCode())) continue;
                    WorkflowUtils.updateStatus(ruNode, "nodestatus", FlowRuNodeStatusEnum.EXPIRED.getCode());
                    needUpdateFlowRuNodeList.add(ruNode);
                }
            }
            needUpdateProcList.add(ruProc);
            needUpdateFlowRuNodeList.add(flowRuNode);
            DynamicObjectCollection ruRoleColl = flowParamBo.getRuRoleColl();
            needUpdateRuRoleList.addAll(ruRoleColl);
            DynamicObjectCollection ruTaskColl = flowParamBo.getRuTaskColl();
            needUpdateRuTaskList.addAll(ruTaskColl);
        }
        try {
            FLOW_RU_PROC_ENTITY_SERVICE.save(needUpdateProcList.toArray(new DynamicObject[0]));
            FLOW_RU_NODE_ENTITY_SERVICE.save(needUpdateFlowRuNodeList.toArray(new DynamicObject[0]));
            FLOW_RU_ROLE_ENTITY_SERVICE.save(needUpdateRuRoleList.toArray(new DynamicObject[0]));
            FLOW_RU_TASK_ENTITY_SERVICE.save(needUpdateRuTaskList.toArray(new DynamicObject[0]));
            FLOW_RU_OP_ENTITY_SERVICE.save(needUpdateOpRecordList.toArray(new DynamicObject[0]));
            for (DynamicObject ruProc : needUpdateProcList) {
                resultBo = new FlowCommonResultBo();
                resultBo.setMessage("success");
                resultBo.setCode("1");
                resultBo.setDataId(ruProc.getLong("id"));
                resultBoList.add(resultBo);
            }
        }
        catch (Exception exc) {
            LOG.error("dealProcessStatus fail: message is {0}", (Throwable)exc);
            for (DynamicObject ruProc : needUpdateProcList) {
                FlowCommonResultBo resultBo2 = new FlowCommonResultBo();
                message = ResManager.loadKDString((String)"\u201c{0}\u201d\u64cd\u4f5c\u51fa\u73b0\u9519\u8bef\u3002", (String)"FlowRuProcDomainService_7", (String)"opmc-pbs-business", (Object[])new Object[]{ruProc.get("remark")});
                resultBo2.setMessage(message);
                resultBo2.setCode("-1");
                resultBo2.setDataId(ruProc.getLong("id"));
                resultBoList.add(resultBo2);
            }
        }
        return resultBoList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FlowRuResultBo reStartProcess(FlowRuProcBo flowRuProcBo) {
        try (TXHandle txhandle = TX.required();){
            DynamicObject[] runProcDyns = FLOW_RU_PROC_ENTITY_SERVICE.queryNoDeprecatedProcByEvaObjIds(Collections.singletonList(flowRuProcBo.getActEvalObjId()));
            this.expiredAllProcStatus(runProcDyns);
            FlowRuResultBo flowRuResultBo = this.startProcess(flowRuProcBo);
            return flowRuResultBo;
        }
        return null;
    }

    protected void expiredAllProcStatus(DynamicObject[] runProcDyns) {
        DynamicObject[] tasks;
        DynamicObject[] ruRoles;
        DynamicObject[] ruNodes;
        if (runProcDyns.length == 0) {
            return;
        }
        DynamicObject ruProc = runProcDyns[0];
        Date date = new Date();
        long userId = UserServiceHelper.getCurrentUserId();
        ruProc.set("modifier", (Object)userId);
        ruProc.set("modifytime", (Object)date);
        ruProc.set("updatestatustime", (Object)date);
        ruProc.set("procstatus", (Object)FlowRuProcStatusEnum.DEPRECATED.getCode());
        FLOW_RU_PROC_ENTITY_SERVICE.saveOne(ruProc);
        Long procId = ruProc.getLong("id");
        List<Long> procIdList = Collections.singletonList(procId);
        QFilter filter = new QFilter("flowruproc", "=", (Object)procId);
        for (DynamicObject ruNode : ruNodes = FLOW_RU_NODE_ENTITY_SERVICE.queryByProcIds(procIdList)) {
            ruNode.set("nodestatus", (Object)FlowRuNodeStatusEnum.EXPIRED.getCode());
            ruNode.set("updatestatustime", (Object)date);
            ruNode.set("modifier", (Object)userId);
            ruNode.set("modifytime", (Object)date);
        }
        FLOW_RU_NODE_ENTITY_SERVICE.save(ruNodes);
        for (DynamicObject ruRole : ruRoles = FLOW_RU_ROLE_ENTITY_SERVICE.queryByRuProcIds(procIdList)) {
            ruRole.set("rolestatus", (Object)FlowRuRoleStatusEnum.EXPIRED.getCode());
            ruRole.set("updatestatustime", (Object)date);
            ruRole.set("modifier", (Object)userId);
            ruRole.set("modifytime", (Object)date);
        }
        FLOW_RU_ROLE_ENTITY_SERVICE.save(ruRoles);
        for (DynamicObject task : tasks = FLOW_RU_TASK_ENTITY_SERVICE.queryTasksByProcId(procId)) {
            task.set("taskstatus", (Object)FlowRuTaskStatusEnum.EXPIRED.getCode());
            task.set("updatestatustime", (Object)date);
            task.set("modifier", (Object)userId);
            task.set("modifytime", (Object)date);
        }
        FLOW_RU_TASK_ENTITY_SERVICE.save(tasks);
    }

    public DynamicObject getEvalTask(long taskId) {
        return FLOW_RU_TASK_ENTITY_SERVICE.queryTaskByPk(taskId);
    }

    public DynamicObject[] getEvalTasks(List<Long> taskIds) {
        return FLOW_RU_TASK_ENTITY_SERVICE.queryTaskByPks(taskIds);
    }

    public Long queryDefNodeByTaskId(Long taskId) {
        return FLOW_RU_NODE_ENTITY_SERVICE.queryDefNodeByTaskId(taskId);
    }

    public DynamicObjectCollection setCurrentRunRole(DynamicObject ruProc, DynamicObject curNode) {
        DynamicObject[] runRoleArr;
        DynamicObjectCollection curRunRoleColl = ruProc.getDynamicObjectCollection("entryentity");
        curRunRoleColl.clear();
        QFilter qFilter = new QFilter("flowrunode", "=", (Object)curNode.getLong("id"));
        qFilter.and(new QFilter("rolestatus", "in", Arrays.asList(FlowRuRoleStatusEnum.PENDING.getCode(), FlowRuRoleStatusEnum.RUNNING.getCode())));
        for (DynamicObject ruRole : runRoleArr = FLOW_RU_ROLE_ENTITY_SERVICE.queryRuRoleByCusFilter(qFilter)) {
            DynamicObject roleDy = curRunRoleColl.addNew();
            roleDy.set("ruroleid", (Object)ruRole);
        }
        return curRunRoleColl;
    }

    public Integer getIndexByRUNodeId(Long nodeId) {
        ArrayList<Long> nodeIds = new ArrayList<Long>();
        nodeIds.add(nodeId);
        DynamicObject[] dynamicObjects = FLOW_RU_NODE_ENTITY_SERVICE.loadRuNodeByIds(nodeIds);
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            return dynamicObjects[0].getInt("index");
        }
        return 0;
    }

    public String getTaskStateCode(Long taskId) {
        DynamicObject dynamicObject = FLOW_RU_TASK_ENTITY_SERVICE.queryTaskByPk(taskId);
        if (dynamicObject != null) {
            return dynamicObject.getString("taskstatus");
        }
        return null;
    }

    public DynamicObject[] queryNoOperateTasksById(List<Long> ids) {
        return FLOW_RU_TASK_ENTITY_SERVICE.queryNoOperateTasksById(ids);
    }

    public Map<Long, String> queryRoleStatusByIds(List<Long> taskIds) {
        return FLOW_RU_TASK_ENTITY_SERVICE.queryRoleStatusByIds(taskIds);
    }

    public Map<Long, Integer> getTaskIdIndexMap(List<Long> taskIds) {
        DynamicObject[] taskDys = FLOW_RU_TASK_ENTITY_SERVICE.loadTasksByIds(taskIds);
        Map<Long, Long> taskIdNodeIdMap = Arrays.stream(taskDys).collect(Collectors.toMap(task -> task.getLong("id"), task -> task.getLong("flowrunode.id")));
        List<Long> nodeIds = Arrays.stream(taskDys).map(dy -> dy.getLong("flowrunode.id")).collect(Collectors.toList());
        DynamicObject[] ruNodes = FLOW_RU_NODE_ENTITY_SERVICE.loadRuNodeByIds(nodeIds);
        Map<Long, Integer> nodeIdIndexMap = Arrays.stream(ruNodes).collect(Collectors.toMap(node -> node.getLong("id"), node -> node.getInt("index")));
        HashMap<Long, Integer> taskIdIndexMap = new HashMap<Long, Integer>();
        taskIdNodeIdMap.forEach((taskId, nodeId) -> taskIdIndexMap.put((Long)taskId, (Integer)nodeIdIndexMap.get(nodeId)));
        return taskIdIndexMap;
    }

    protected List<Long> queryJumpTasks(DynamicObject[] ruProcs, String workflowType, Map<Long, Long> soureOfJumpTaskMap) {
        ArrayList<Long> needAutoSubmitTaskIds;
        block6: {
            DynamicObject[] taskDyns;
            Map<Long, DynamicObject> ruNodeMap;
            block5: {
                needAutoSubmitTaskIds = new ArrayList<Long>(10);
                List procIds = Arrays.stream(ruProcs).filter(e -> e.getString("workflowtype").equals(workflowType)).map(v -> v.getLong("id")).collect(Collectors.toList());
                String selectedFields = "id,flownodedef.id,flownodedef.nodetype.id,flownodedef.sameauditjump,flowruproc.id,index";
                QFilter filter = new QFilter("flowruproc", "in", procIds);
                if (workflowType.equals("1")) {
                    filter.and("flownodedef.nodetype.id", "=", (Object)NodeTypeConstants.INDICATOR_AUDIT);
                } else if (workflowType.equals("2")) {
                    filter.and("flownodedef.nodetype.id", "in", Arrays.asList(NodeTypeConstants.EVALUATE_SCORE, NodeTypeConstants.BATCH_EVALUSUMSCORE));
                }
                DynamicObject[] ruNodeDyns = FLOW_RU_NODE_ENTITY_SERVICE.queryOriginalArray(selectedFields, new QFilter[]{filter});
                ruNodeMap = Arrays.stream(ruNodeDyns).collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
                List ruNodeIdList = Arrays.stream(ruNodeDyns).map(v -> v.getLong("id")).collect(Collectors.toList());
                QFilter taskFilter = new QFilter("flowrunode.id", "in", ruNodeIdList);
                taskFilter.and("taskstatus", "in", Arrays.asList(FlowRuTaskStatusEnum.WAITING.getCode(), FlowRuTaskStatusEnum.BE_WAITTING.getCode(), FlowRuTaskStatusEnum.RETURNED.getCode()));
                taskDyns = FLOW_RU_TASK_ENTITY_SERVICE.queryOriginalArray("id,flowrunode.id,handler.id,flowrurole.id,flowrurole.turnoversort", new QFilter[]{taskFilter});
                if (!workflowType.equals("1")) break block5;
                for (DynamicObject runTask : taskDyns) {
                    boolean isPreAuditorHandled;
                    DynamicObject ruNode = ruNodeMap.get(runTask.getLong("flowrunode.id"));
                    if (!NodeTypeConstants.INDICATOR_AUDIT.equals(ruNode.getLong("flownodedef.nodetype.id")) || !ruNode.getBoolean("flownodedef.sameauditjump") || !(isPreAuditorHandled = FLOW_RU_TASK_ENTITY_SERVICE.queryHasSameHandlerCompleteTask(ruNode, runTask.getLong("handler.id")))) continue;
                    needAutoSubmitTaskIds.add(runTask.getLong("id"));
                }
                break block6;
            }
            if (!workflowType.equals("2")) break block6;
            for (DynamicObject runTask : taskDyns) {
                boolean isPreSameHandled;
                DynamicObject ruNode = ruNodeMap.get(runTask.getLong("flowrunode.id"));
                if (!NodeTypeConstants.EVALUATE_SCORE.equals(ruNode.getLong("flownodedef.nodetype.id")) && !NodeTypeConstants.BATCH_EVALUSUMSCORE.equals(ruNode.getLong("flownodedef.nodetype.id")) || !ruNode.getBoolean("flownodedef.sameauditjump") || !(isPreSameHandled = FLOW_RU_TASK_ENTITY_SERVICE.queryHasSameHandlerCompleteTaskForEvalWorkflow(ruNode, runTask, soureOfJumpTaskMap))) continue;
                needAutoSubmitTaskIds.add(runTask.getLong("id"));
            }
        }
        return needAutoSubmitTaskIds;
    }

    public Map<Long, Boolean> judgeWorkflowFlowIsStarted(List<Long> procIdList) {
        HashMap<Long, Boolean> evaObjStartedMap = new HashMap<Long, Boolean>(16);
        DynamicObject[] ruProDyns = FlowRuProcEntityService.getInstance().loadRuProcByIds(procIdList);
        Map<Long, String> actEvaObjProcStatusMap = Arrays.stream(ruProDyns).collect(Collectors.toMap(k -> k.getLong("actevalobj"), v -> v.getString("procstatus")));
        for (Map.Entry<Long, String> evaObjProcEntry : actEvaObjProcStatusMap.entrySet()) {
            if (FlowRuProcStatusEnum.NOTACTIVE.getCode().equals(evaObjProcEntry.getValue())) {
                evaObjStartedMap.put(evaObjProcEntry.getKey(), Boolean.FALSE);
                continue;
            }
            evaObjStartedMap.put(evaObjProcEntry.getKey(), Boolean.TRUE);
        }
        return evaObjStartedMap;
    }

    private FlowCommonResultBo getFlowCommonResultBo(String message, FlowCommonResultBo resultBo) {
        resultBo.setMessage(message);
        resultBo.setCode("-1");
        return resultBo;
    }

    public DynamicObject[] procsProgressingOrFinishByProdefActivity(Long activityId, Long procDefId) {
        return FLOW_RU_PROC_ENTITY_SERVICE.procsProgressingOrFinishByProdefActivity(activityId, procDefId);
    }
}

