/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.pbs.business.domain.workflow.service;

import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.pbs.business.ServiceFactory;
import kd.opmc.pbs.business.domain.msg.service.RollbackMsgSendService;
import kd.opmc.pbs.business.domain.workflow.constants.FlowRuntimeConstants;
import kd.opmc.pbs.business.domain.workflow.dto.SendMessageDTO;
import kd.opmc.pbs.business.domain.workflow.entity.FlowMsgMergeEnumBO;
import kd.opmc.pbs.business.domain.workflow.entity.FlowRollbackResultBo;
import kd.opmc.pbs.business.domain.workflow.entity.FlowRuProcBo;
import kd.opmc.pbs.business.domain.workflow.entity.FlowValidateResultBo;
import kd.opmc.pbs.business.domain.workflow.entityservice.BatchTaskmapEntityService;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowDefProcEntityService;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowRuNodeEntityService;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowRuOpEntityService;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowRuProcEntityService;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowRuRoleEntityService;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowRuTaskEntityService;
import kd.opmc.pbs.business.domain.workflow.entityservice.WorkFlowEntityService;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuMsgEnum;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuMsgMergeEnum;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuNodeStatusEnum;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuProcStatusEnum;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuRoleStatusEnum;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuTaskStatusEnum;
import kd.opmc.pbs.business.domain.workflow.model.BatchFlowParamBo;
import kd.opmc.pbs.business.domain.workflow.model.FlowParamBo;
import kd.opmc.pbs.business.domain.workflow.model.FlowRuNodeBo;
import kd.opmc.pbs.business.domain.workflow.model.FlowRuRoleBo;
import kd.opmc.pbs.business.domain.workflow.model.RollbackParamBo;
import kd.opmc.pbs.business.domain.workflow.service.CrossScoreDomainService;
import kd.opmc.pbs.business.domain.workflow.service.FlowHandlerBatchDomainService;
import kd.opmc.pbs.business.domain.workflow.service.FlowHandlerDomainService;
import kd.opmc.pbs.business.domain.workflow.service.FlowRuProcBatchDomainService;
import kd.opmc.pbs.business.domain.workflow.service.FlowRunSupDomainService;
import kd.opmc.pbs.business.domain.workflow.utils.WorkflowUtils;
import kd.opmc.pbs.business.domain.workflow.vo.NodeIdAndTaskIdMapVO;
import kd.opmc.pbs.business.external.epa.IEPAActEvalRecordService;
import kd.opmc.pbs.business.external.epa.IEPAActevalobjService;
import kd.opmc.pbs.common.constants.NodeTypeConstants;
import kd.opmc.pbs.common.enums.FLowOpEnum;
import kd.opmc.pbs.common.utils.CommonResultBo;

public class FlowRuSecondDomainService {
    private static final Log LOG = LogFactory.getLog(FlowRuSecondDomainService.class);
    private static final FlowRuNodeEntityService FLOW_RU_NODE_ENTITY_SERVICE = FlowRuNodeEntityService.getInstance();
    private static final FlowRuRoleEntityService FLOW_RU_ROLE_ENTITY_SERVICE = FlowRuRoleEntityService.getInstance();
    private static final FlowRuTaskEntityService FLOW_RU_TASK_ENTITY_SERVICE = FlowRuTaskEntityService.getInstance();
    private static final FlowRuProcEntityService FLOW_RU_PROC_ENTITY_SERVICE = FlowRuProcEntityService.getInstance();
    private static final WorkFlowEntityService WORK_FLOW_ENTITY_SERVICE = WorkFlowEntityService.getInstance();
    private static final FlowDefProcEntityService FLOW_DEF_PROC_ENTITY_SERVICE = FlowDefProcEntityService.getInstance();
    private static final FlowRunSupDomainService FLOW_RUSUP_DOMAIN_SERVICE = FlowRunSupDomainService.getInstance();
    private static final FlowRuOpEntityService FLOW_RU_OP_ENTITY_SERVICE = FlowRuOpEntityService.getInstance();
    private static final RollbackMsgSendService ROLLBACK_MSG_SEND_SERVICE = RollbackMsgSendService.getInstance();
    private static final FlowHandlerBatchDomainService FLOW_HANDLER_BATCH_DOMAIN_SERVICE = FlowHandlerBatchDomainService.getInstance();
    private static final CrossScoreDomainService CROSS_SCORE_DOMAIN_SERVICE = CrossScoreDomainService.getInstance();
    private static final IEPAActevalobjService EPA_ACTEVAOBJ_SERVICE = IEPAActevalobjService.getInstance();
    private static final BatchTaskmapEntityService BATCH_TASKMAP_ENTITY_SERVICE = BatchTaskmapEntityService.getInstance();

    public static FlowRuSecondDomainService getInstance() {
        return ServiceFactory.getService(FlowRuSecondDomainService.class);
    }

    public List<Long> preCreateProcessInstance(FlowRuProcBo flowRuProcBo, String flowOpType) {
        LOG.error("begin preCreateProcessInstance,actevaObjId is [{}],flowvid is [{}],traceId is [{}]", new Object[]{flowRuProcBo.getActEvalObjId(), flowRuProcBo.getFlowVid(), RequestContext.get().getTraceId()});
        long preCreateStart = System.currentTimeMillis();
        HashMap<Long, DynamicObject> workflowMap = new HashMap<Long, DynamicObject>(16);
        FlowRuProcBatchDomainService FLOW_RU_PROC_BATCH_DOMAIN_SERVICE = new FlowRuProcBatchDomainService();
        FLOW_RU_PROC_BATCH_DOMAIN_SERVICE.initializWorkflowMap(Collections.singletonList(flowRuProcBo), workflowMap);
        Long flowDefId = flowRuProcBo.getFlowDefId();
        DynamicObject workflow = (DynamicObject)workflowMap.get(flowRuProcBo.getFlowVid());
        DynamicObject flowDef = (DynamicObject)workflowMap.get(flowDefId);
        try {
            DynamicObject[] runProcDyns;
            if (!HRStringUtils.equals((String)FLowOpEnum.RESET.getValue(), (String)flowOpType) && (runProcDyns = FLOW_RU_PROC_ENTITY_SERVICE.queryProcByEvaObjIdAndDefprocId(flowRuProcBo.getActEvalObjId(), flowDefId)).length > 0) {
                return Collections.singletonList(runProcDyns[0].getLong("id"));
            }
            DynamicObject ruProc = FLOW_RU_PROC_ENTITY_SERVICE.generateRuProcess(flowRuProcBo, flowDef, workflow.getString("name"), Boolean.TRUE);
            List<DynamicObject> ruNodeList = FLOW_RU_NODE_ENTITY_SERVICE.generateRuNode(ruProc, flowDef, Boolean.FALSE);
            List<DynamicObject> ruRoleList = FLOW_RU_ROLE_ENTITY_SERVICE.generateRuRole(ruNodeList, flowDef, true, flowRuProcBo, Boolean.FALSE);
            ArrayList<DynamicObject> taskList = new ArrayList<DynamicObject>(10);
            HashMap<Long, List<DynamicObject>> ruRoleMap = new HashMap(16);
            ruRoleMap = ruRoleList.stream().collect(Collectors.groupingBy(k -> k.getLong("flowrunode.id"), Collectors.mapping(v -> v, Collectors.toList())));
            ArrayList<DynamicObject> toSaveRuRoleList = new ArrayList<DynamicObject>(10);
            if (flowRuProcBo.getSettingMode().equals("20")) {
                this.assemblePreInstanceCreateData(ruNodeList, ruRoleMap, ruProc, flowOpType, flowRuProcBo, taskList, toSaveRuRoleList);
            } else if (HRStringUtils.equals((String)FLowOpEnum.RESET.getValue(), (String)flowOpType)) {
                this.assemblePreInstanceCreateData(ruNodeList, ruRoleMap, ruProc, flowOpType, flowRuProcBo, taskList, toSaveRuRoleList);
            } else {
                toSaveRuRoleList.addAll(ruRoleList);
            }
            FLOW_RU_ROLE_ENTITY_SERVICE.save(toSaveRuRoleList.toArray(new DynamicObject[0]));
            FLOW_RU_NODE_ENTITY_SERVICE.save(ruNodeList.toArray(new DynamicObject[0]));
            if (taskList.size() > 0) {
                FLOW_RU_TASK_ENTITY_SERVICE.save(taskList.toArray(new DynamicObject[0]));
            }
            Long ruProcId = (Long)ruProc.getPkValue();
            DynamicObject updateProc = FLOW_RU_PROC_ENTITY_SERVICE.queryRuProcByPk(ruProcId);
            updateProc.set("majorproc", (Object)ruProcId);
            updateProc.set("procstatus", (Object)FlowRuProcStatusEnum.NOTACTIVE.getCode());
            FLOW_RU_PROC_ENTITY_SERVICE.saveOne(updateProc);
            long preCreateEnd = System.currentTimeMillis();
            LOG.info("preCreateProcessInstance takes time : " + (preCreateEnd - preCreateStart) + " ms");
            return Collections.singletonList(ruProcId);
        }
        catch (Exception exc) {
            LOG.error("preCreateProcessInstance fail:" + flowRuProcBo.toString(), (Throwable)exc);
            return Collections.singletonList(0L);
        }
    }

    private void assemblePreInstanceCreateData(List<DynamicObject> ruNodeList, Map<Long, List<DynamicObject>> ruRoleMap, DynamicObject ruProc, String flowOpType, FlowRuProcBo flowRuProcBo, List<DynamicObject> taskList, List<DynamicObject> toSaveRuRoleList) {
        for (DynamicObject ruNode : ruNodeList) {
            Long ruNodeId = (Long)ruNode.getPkValue();
            List ruRolesList = new ArrayList(10);
            ruRolesList = ruRoleMap.getOrDefault(ruNodeId, ruRolesList);
            for (DynamicObject ruRole : ruRolesList) {
                boolean isNeedPreInstHandler = Boolean.TRUE;
                List<Long> handlerList = FLOW_RUSUP_DOMAIN_SERVICE.getHandlerList(ruNode.getLong("flowruproc.id"), ruNode, ruRole, ruProc);
                if (HRStringUtils.equals((String)FLowOpEnum.RESET.getValue(), (String)flowOpType) && flowRuProcBo.getRawRoles() != null) {
                    Map rawRoleDefTaskMap;
                    Map rawRoleDefRoleMap = flowRuProcBo.getRawRoles().stream().filter(e -> !e.getBoolean("iscrossrole")).collect(Collectors.groupingBy(k -> k.getLong("flowdefrole.id"), Collectors.toList()));
                    if ((flowRuProcBo.getSettingMode().equals("20") || rawRoleDefRoleMap.get(ruRole.getLong("flowdefrole.id")) != null && !rawRoleDefRoleMap.get(ruRole.getLong("flowdefrole.id")).isEmpty() && ((DynamicObject)rawRoleDefRoleMap.get(ruRole.getLong("flowdefrole.id")).get(0)).getBoolean("issethandler")) && (rawRoleDefTaskMap = flowRuProcBo.getRawTasks().stream().filter(e -> !e.getBoolean("flowrunode.iscrossnode")).collect(Collectors.groupingBy(k -> k.getLong("flowrurole.flowdefrole.id"), Collectors.toList()))).get(ruRole.getLong("flowdefrole.id")) != null) {
                        handlerList = rawRoleDefTaskMap.get(ruRole.getLong("flowdefrole.id")).stream().map(k -> k.getLong("handler_id")).collect(Collectors.toList());
                    }
                    if (flowRuProcBo.getSettingMode().equals("10") && (rawRoleDefRoleMap.get(ruRole.getLong("flowdefrole.id")) == null || rawRoleDefRoleMap.get(ruRole.getLong("flowdefrole.id")).isEmpty() || !((DynamicObject)rawRoleDefRoleMap.get(ruRole.getLong("flowdefrole.id")).get(0)).getBoolean("issethandler"))) {
                        isNeedPreInstHandler = Boolean.FALSE;
                    }
                    if (flowRuProcBo.getSettingMode().equals("10") && rawRoleDefRoleMap.get(ruRole.getLong("flowdefrole.id")) != null && !rawRoleDefRoleMap.get(ruRole.getLong("flowdefrole.id")).isEmpty() && ((DynamicObject)rawRoleDefRoleMap.get(ruRole.getLong("flowdefrole.id")).get(0)).getBoolean("issethandler")) {
                        ruRole.set("issethandler", (Object)1);
                    }
                }
                boolean isPending = Boolean.FALSE;
                if (CollectionUtils.isEmpty(handlerList) && isNeedPreInstHandler) {
                    handlerList.add(0L);
                    isPending = Boolean.TRUE;
                }
                FlowHandlerDomainService FLOW_HANDLER_DOMAIN_SERVICE = new FlowHandlerDomainService();
                Map<Long, Boolean> userValidMap = FLOW_HANDLER_DOMAIN_SERVICE.batchQueryUserIsEnable(handlerList);
                for (Long handler : handlerList) {
                    try {
                        if (userValidMap.isEmpty() || null == userValidMap.get(handler) || userValidMap.get(handler).booleanValue() || !isNeedPreInstHandler) continue;
                        isPending = Boolean.TRUE;
                        break;
                    }
                    catch (Exception e2) {
                        LOG.error("UserServiceHelper.isUserEnable(handler) fail,handler is :" + handler, (Throwable)e2);
                    }
                }
                ruNode.set("nodestatus", (Object)FlowRuNodeStatusEnum.NOT_ACTIVE.getCode());
                ruRole.set("rolestatus", (Object)FlowRuRoleStatusEnum.NOT_ACTIVE.getCode());
                if (isNeedPreInstHandler) {
                    List<DynamicObject> tasks = FLOW_RU_TASK_ENTITY_SERVICE.generateTaskByRuRole(ruNode, ruRole, handlerList, false);
                    for (DynamicObject task : tasks) {
                        if (!task.getString("taskstatus").equals(FlowRuTaskStatusEnum.PENDING.getCode())) {
                            task.set("taskstatus", (Object)FlowRuTaskStatusEnum.NOT_ACTIVE.getCode());
                        }
                        taskList.add(task);
                    }
                }
                toSaveRuRoleList.add(ruRole);
            }
        }
    }

    public List<Long> preCreateProcessInstance(FlowRuProcBo flowRuProcBo) {
        return this.preCreateProcessInstance(flowRuProcBo, null);
    }

    public boolean notPrepareRestart(Long ruProcId) {
        DynamicObject[] ruRoles;
        FlowHandlerDomainService FLOW_HANDLER_DOMAIN_SERVICE = new FlowHandlerDomainService();
        for (DynamicObject ruRole : ruRoles = FLOW_RU_ROLE_ENTITY_SERVICE.queryPendingRoleByProcId(ruProcId)) {
            DynamicObject ruNode;
            List<Long> nodeHandlerList;
            Map<Long, List<Long>> procHandlerMap = FLOW_HANDLER_DOMAIN_SERVICE.batchQueryFlowRoleHandler(Collections.singletonList(ruProcId), ruRole.getLong("flowdefrole.id"), null);
            List<Long> handlerIds = procHandlerMap.get(ruProcId);
            if (!CollectionUtils.isEmpty(handlerIds) || !CollectionUtils.isEmpty(nodeHandlerList = FLOW_HANDLER_DOMAIN_SERVICE.queryReplaceFlowRoleHandler(ruProcId, (ruNode = ruRole.getDynamicObject("flowrunode")).getDynamicObject("handlertype").getLong("id"), ruRole))) continue;
            return true;
        }
        return false;
    }

    protected void restartPendingNode(Map<Long, DynamicObject> procMap, List<Long> pendingNodeIds) {
        FlowHandlerDomainService FLOW_HANDLER_DOMAIN_SERVICE = new FlowHandlerDomainService();
        DynamicObject[] ruRoles = FLOW_RU_ROLE_ENTITY_SERVICE.queryPendingRoleByNodeIds(pendingNodeIds);
        if (ruRoles.length < pendingNodeIds.size()) {
            String msg = String.format("restartPendingNode: runtime role status is invalid, pendingNodeIds:%s", pendingNodeIds);
            LOG.error(msg);
            throw new KDException(new ErrorCode("restartPendingNode", msg), new Object[0]);
        }
        ArrayList<DynamicObject> ruRoleList = new ArrayList<DynamicObject>(pendingNodeIds.size());
        ArrayList<DynamicObject> taskList = new ArrayList<DynamicObject>(pendingNodeIds.size());
        Date date = new Date();
        long userId = UserServiceHelper.getCurrentUserId();
        for (DynamicObject ruRole : ruRoles) {
            Long ruProcId = ruRole.getLong("flowruproc.id");
            Map<Long, List<Long>> procHandlerMap = FLOW_HANDLER_DOMAIN_SERVICE.batchQueryFlowRoleHandler(Collections.singletonList(ruProcId), ruRole.getLong("flowdefrole.id"), null);
            List<Long> handlerIds = procHandlerMap.get(ruProcId);
            DynamicObject ruNode = ruRole.getDynamicObject("flowrunode");
            if (CollectionUtils.isEmpty(handlerIds)) {
                List<Long> nodeHandlerList = FLOW_HANDLER_DOMAIN_SERVICE.queryReplaceFlowRoleHandler(ruProcId, ruNode.getDynamicObject("handlertype").getLong("id"), ruRole);
                if (CollectionUtils.isEmpty(nodeHandlerList)) {
                    String msg = String.format("restartPendingNode: runtime role can not find handler, ruRoleId:%s", ruRole.getPkValue());
                    LOG.error(msg);
                    throw new KDException(new ErrorCode("restartPendingNode", msg), new Object[0]);
                }
                taskList.addAll(FLOW_RU_TASK_ENTITY_SERVICE.generateTaskByRuRole(ruNode, ruRole, nodeHandlerList, true));
            } else {
                taskList.addAll(FLOW_RU_TASK_ENTITY_SERVICE.generateTaskByRuRole(ruNode, ruRole, handlerIds, false));
            }
            ruRole.set("rolestatus", (Object)FlowRuRoleStatusEnum.RUNNING.getCode());
            ruRole.set("updatestatustime", (Object)date);
            ruRole.set("modifier", (Object)userId);
            ruRole.set("modifytime", (Object)date);
            ruRoleList.add(ruRole);
        }
        FLOW_RU_ROLE_ENTITY_SERVICE.save(ruRoleList.toArray(new DynamicObject[0]));
        FLOW_RU_TASK_ENTITY_SERVICE.save(taskList.toArray(new DynamicObject[0]));
        Iterator iterator = taskList.iterator();
        while (iterator.hasNext()) {
            DynamicObject task;
            FLOW_RUSUP_DOMAIN_SERVICE.notifyHandler(procMap.get(task.getLong("flowruproc.id")), task, (task = (DynamicObject)iterator.next()).getBoolean("isreplace") ? FlowRuMsgEnum.REPLACE : FlowRuMsgEnum.START);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseProcessForChangeHandler(Long ruProcId) {
        DynamicObject ruProc = FLOW_RU_PROC_ENTITY_SERVICE.queryRuProcByPk(ruProcId);
        String procStatus = ruProc.getString("procstatus");
        if (!FlowRuProcStatusEnum.RUNNING.getCode().equals(procStatus)) {
            return;
        }
        Date date = new Date();
        long userId = UserServiceHelper.getCurrentUserId();
        ruProc.set("procstatus", (Object)FlowRuProcStatusEnum.STOP.getCode());
        ruProc.set("updatestatustime", (Object)date);
        ruProc.set("modifier", (Object)userId);
        ruProc.set("modifytime", (Object)date);
        DynamicObject ruNode = FLOW_RU_NODE_ENTITY_SERVICE.queryRuNodeByPk(ruProc.getLong("currentnode.id"));
        ruNode.set("nodestatus", (Object)FlowRuNodeStatusEnum.STOP.getCode());
        ruNode.set("updatestatustime", (Object)date);
        ruNode.set("modifier", (Object)userId);
        ruNode.set("modifytime", (Object)date);
        try (TXHandle txhandle = TX.required();){
            FLOW_RU_PROC_ENTITY_SERVICE.saveOne(ruProc);
            FLOW_RU_NODE_ENTITY_SERVICE.saveOne(ruNode);
        }
    }

    public boolean isFormulateLastTask(Long taskId) {
        DynamicObject taskDyn = FlowRuTaskEntityService.getInstance().queryOriginalTaskByPk(taskId);
        Long procDefId = taskDyn.getLong("flowruproc.defproc");
        DynamicObject flowDefDyn = FlowDefProcEntityService.getInstance().getFlowDefProcByPkValue(procDefId);
        DynamicObjectCollection nodeDyns = flowDefDyn.getDynamicObjectCollection("nodeentry");
        int lastFormulateIndex = 0;
        for (DynamicObject node : nodeDyns) {
            if (!NodeTypeConstants.INDICATOR_FORMULATE.equals(node.getLong("nodetype.id")) || node.getInt("seq") <= lastFormulateIndex) continue;
            lastFormulateIndex = node.getInt("seq");
        }
        if (taskDyn.getInt("flowrunode.index") == lastFormulateIndex) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Map<Long, List<Map<String, Long>>> queryBatchTaskByFitlers(QFilter qfilter) {
        DynamicObject[] batchTaskDyns;
        HashMap<Long, List<Map<String, Long>>> taskListMap = new HashMap<Long, List<Map<String, Long>>>(16);
        for (DynamicObject batchTask : batchTaskDyns = BATCH_TASKMAP_ENTITY_SERVICE.queryBatchTaskByFilter(qfilter)) {
            HashMap<String, Long> taskMap;
            if (null != taskListMap.get(batchTask.getLong("batchtask")) && !((List)taskListMap.get(batchTask.getLong("batchtask"))).isEmpty()) {
                taskMap = new HashMap(16);
                taskMap.put("taskId", batchTask.getLong("rutask.id"));
                taskMap.put("actEvaObjId", batchTask.getLong("actevaobj.id"));
                ((List)taskListMap.get(batchTask.getLong("batchtask"))).add(taskMap);
                continue;
            }
            taskMap = new HashMap<String, Long>(16);
            taskMap.put("taskId", batchTask.getLong("rutask.id"));
            taskMap.put("actEvaObjId", batchTask.getLong("actevaobj.id"));
            ArrayList<HashMap<String, Long>> taskList = new ArrayList<HashMap<String, Long>>(10);
            taskList.add(taskMap);
            taskListMap.put(batchTask.getLong("batchtask"), taskList);
        }
        return taskListMap;
    }

    public List<Map<String, Object>> getBatchTaskDetails(Long taskId, QFilter cusFilter) {
        DynamicObject taskDyo;
        ArrayList<Map<String, Object>> taskListMap = new ArrayList<Map<String, Object>>(10);
        DynamicObject[] batchTaskDyns = BATCH_TASKMAP_ENTITY_SERVICE.queryEffectTaskByBatchTaskIds(Collections.singletonList(taskId), null);
        if (batchTaskDyns.length > 0) {
            taskId = batchTaskDyns[0].getLong("rutask.id");
        }
        if (null == (taskDyo = FLOW_RU_TASK_ENTITY_SERVICE.queryTaskByPk(taskId))) {
            return taskListMap;
        }
        if (taskDyo.getString("taskstatus").equals(FlowRuTaskStatusEnum.EXPIRED.getCode())) {
            return taskListMap;
        }
        QFilter taskFilter = new QFilter("handler", "=", (Object)taskDyo.getDynamicObject("handler").getLong("id"));
        taskFilter.and("activity", "=", (Object)taskDyo.getLong("activity"));
        taskFilter.and("iscotask", "=", (Object)(taskDyo.getBoolean("iscotask") ? "1" : "0"));
        if (taskDyo.getBoolean("iscrossevaluate")) {
            taskFilter.and("flowrunode.flownodedef.id", "=", (Object)taskDyo.getLong("flowrunode.flownodedef.id"));
            taskFilter.and("flowrurole.flowdefrole.id", "=", (Object)taskDyo.getLong("flowrurole.flowdefrole.id"));
        } else {
            taskFilter.and("flowrurole.flowdefrole.id", "=", (Object)taskDyo.getLong("flowrurole.flowdefrole.id"));
        }
        if (null != cusFilter) {
            taskFilter.and(cusFilter);
        }
        DynamicObject[] taskDyns = FLOW_RU_TASK_ENTITY_SERVICE.loadTasksByCusFilter(taskFilter);
        Map sameHandleTaskMap = Arrays.stream(taskDyns).collect(Collectors.groupingBy(e -> e.getLong("flowruproc.actevalobj"), Collectors.mapping(e -> e.getLong("id"), Collectors.toSet())));
        HashMap<Long, String> taskUnicodeMap = new HashMap<Long, String>(taskDyns.length);
        for (Map.Entry entry : sameHandleTaskMap.entrySet()) {
            String unicode = "T" + ORM.create().genLongId("pbs_flowrutask");
            for (Long task : entry.getValue()) {
                taskUnicodeMap.put(task, unicode);
            }
        }
        for (DynamicObject task : taskDyns) {
            HashMap<String, Object> taskMap = new HashMap<String, Object>(16);
            taskMap.put("taskId", task.getLong("id"));
            if (null == task.get("flowruproc") || FlowRuProcStatusEnum.DEPRECATED.getCode().equals(task.getString("flowruproc.procstatus"))) continue;
            taskMap.put("actEvaObjId", task.getLong("flowruproc.actevalobj"));
            taskMap.put("taskStatus", task.getString("taskstatus"));
            taskMap.put("indicatorColl", task.getDynamicObjectCollection("entryentity"));
            taskMap.put("iscrossevaluate", task.getBoolean("iscrossevaluate"));
            taskMap.put("activity", task.getLong("activity"));
            taskMap.put("flowrunode", task.getLong("flowrunode.id"));
            taskMap.put("flowrurole", task.getLong("flowrurole.id"));
            taskMap.put("handler", task.getLong("handler.id"));
            taskMap.put("isrollbacked", task.getBoolean("isrollbacked"));
            taskMap.put("iscotask", task.getBoolean("iscotask"));
            taskMap.put("iscohandlerdeal", task.getBoolean("iscohandlerdeal"));
            taskMap.put("hosttask", task.getLong("hosttask.id"));
            if (task.getBoolean("iscrossevaluate")) {
                taskMap.put("taskUnicode", taskUnicodeMap.get(task.getLong("id")));
            } else {
                taskMap.put("taskUnicode", "T" + task.getLong("id"));
            }
            taskListMap.add(taskMap);
        }
        return taskListMap;
    }

    public Map<String, List<Map<String, Object>>> getBatchTaskMergeDetails(Long taskId, QFilter cusFilter) {
        List<Map<String, Object>> taskListMap = this.getBatchTaskDetails(taskId, cusFilter);
        Map<String, List<Map<String, Object>>> mergeTaskMap = taskListMap.stream().collect(Collectors.groupingBy(e -> e.get("taskUnicode") == null ? "" : e.get("taskUnicode").toString(), Collectors.mapping(e -> e, Collectors.toList())));
        return mergeTaskMap;
    }

    public Map<Long, List<Map<String, Object>>> getAllBatchTaskDetails(List<Long> batchTaskIdList) {
        DynamicObject[] batchTaskDyns;
        HashMap<Long, List<Map<String, Object>>> taskListMap = new HashMap<Long, List<Map<String, Object>>>(16);
        for (DynamicObject batchTask : batchTaskDyns = BATCH_TASKMAP_ENTITY_SERVICE.queryTaskByBatchTaskIds(batchTaskIdList)) {
            HashMap<String, Object> taskMap;
            if (null != taskListMap.get(batchTask.getLong("batchtask")) && !((List)taskListMap.get(batchTask.getLong("batchtask"))).isEmpty()) {
                taskMap = new HashMap(16);
                taskMap.put("taskId", batchTask.getLong("rutask.id"));
                taskMap.put("taskStatus", batchTask.getString("rutask.taskstatus"));
                taskMap.put("actEvaObjId", batchTask.getLong("actevaobj.id"));
                ((List)taskListMap.get(batchTask.getLong("batchtask"))).add(taskMap);
                continue;
            }
            taskMap = new HashMap<String, Object>(16);
            taskMap.put("taskId", batchTask.getLong("rutask.id"));
            taskMap.put("taskStatus", batchTask.getString("rutask.taskstatus"));
            taskMap.put("actEvaObjId", batchTask.getLong("actevaobj.id"));
            ArrayList<HashMap<String, Object>> taskList = new ArrayList<HashMap<String, Object>>(10);
            taskList.add(taskMap);
            taskListMap.put(batchTask.getLong("batchtask"), taskList);
        }
        return taskListMap;
    }

    public boolean saveBatchTaskDetails(Long batchTaskId, List<Long> taskIdList) {
        BATCH_TASKMAP_ENTITY_SERVICE.generateBatchTask(batchTaskId, taskIdList);
        return Boolean.TRUE;
    }

    public Map<Long, String> queryTasksStatusByIds(List<Long> taskIds) {
        return FLOW_RU_TASK_ENTITY_SERVICE.queryTasksStatusByIds(taskIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public FlowRollbackResultBo rollbackTask(List<Long> taskIds, String reason) {
        DynamicObject[] tasks = FLOW_RU_TASK_ENTITY_SERVICE.queryTasksByIds(taskIds);
        FlowRollbackResultBo result = this.verificationTasks(taskIds, tasks);
        if (result != null && HRStringUtils.equals((String)result.getCode(), (String)"-1")) {
            return result;
        }
        FlowParamBo flowParamBo = new FlowParamBo();
        DynamicObject rollbackTask = tasks[0];
        FlowRollbackResultBo resultBo = new FlowRollbackResultBo();
        if (HRObjectUtils.isEmpty((Object)rollbackTask.getDynamicObject("flowrurole"))) {
            resultBo.setCode("-1");
            String message = MessageFormat.format(ResManager.loadKDString((String)"\u4efb\u52a1\uff1a\u201c{0}\u201d\u7ed1\u5b9a\u7684\u89d2\u8272\u5b9e\u4f8b\u4e0d\u5b58\u5728\u3002", (String)"FlowRuSecondDomainService_23", (String)"opmc-pbs-business", (Object[])new Object[0]), rollbackTask.getLong("id"));
            resultBo.setMessage(message);
            resultBo.setFailList(taskIds);
            return resultBo;
        }
        long ruRoleId = rollbackTask.getDynamicObject("flowrurole").getLong("id");
        flowParamBo.setRuRoleId(ruRoleId);
        if (HRObjectUtils.isEmpty((Object)rollbackTask.getDynamicObject("flowrunode"))) {
            resultBo.setCode("-1");
            String message = MessageFormat.format(ResManager.loadKDString((String)"\u4efb\u52a1\uff1a\u201c{0}\u201d\u7ed1\u5b9a\u7684\u8282\u70b9\u5b9e\u4f8b\u4e0d\u5b58\u5728\u3002", (String)"FlowRuSecondDomainService_24", (String)"opmc-pbs-business", (Object[])new Object[0]), rollbackTask.getLong("id"));
            resultBo.setMessage(message);
            resultBo.setFailList(taskIds);
            return resultBo;
        }
        DynamicObject rollbackNode = rollbackTask.getDynamicObject("flowrunode");
        long rollbackNodeIndex = rollbackNode.getInt("index");
        long rollbackNodeId = rollbackNode.getLong("id");
        if (HRObjectUtils.isEmpty((Object)rollbackTask.getDynamicObject("flowruproc"))) {
            resultBo.setCode("-1");
            String message = MessageFormat.format(ResManager.loadKDString((String)"\u4efb\u52a1\uff1a\u201c{0}\u201d\u7ed1\u5b9a\u7684\u6d41\u7a0b\u5b9e\u4f8b\u4e0d\u5b58\u5728\u3002", (String)"FlowRuSecondDomainService_25", (String)"opmc-pbs-business", (Object[])new Object[0]), rollbackTask.getLong("id"));
            resultBo.setMessage(message);
            resultBo.setFailList(taskIds);
            return resultBo;
        }
        long ruProcId = rollbackTask.getDynamicObject("flowruproc").getLong("id");
        DynamicObject ruProc = FLOW_RU_PROC_ENTITY_SERVICE.loadSingle(ruProcId);
        if (HRStringUtils.equals((String)FlowRuProcStatusEnum.PENDING.getCode(), (String)ruProc.getString("procstatus")) || HRStringUtils.equals((String)FlowRuProcStatusEnum.DEPRECATED.getCode(), (String)ruProc.getString("procstatus")) || HRStringUtils.equals((String)FlowRuProcStatusEnum.FINISHED.getCode(), (String)ruProc.getString("procstatus"))) {
            resultBo.setCode("-1");
            String message = ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u9000\u56de\u201c\u5df2\u6302\u8d77\u201d\u3001\u201c\u5df2\u5e9f\u5f03\u201d\u6216\u201c\u5df2\u5b8c\u6210\u201d\u7684\u6d41\u7a0b\u3002", (String)"FlowRuSecondDomainService_3", (String)"opmc-pbs-business", (Object[])new Object[0]);
            resultBo.setMessage(message);
            resultBo.setFailList(taskIds);
            return resultBo;
        }
        if (HRObjectUtils.isEmpty((Object)ruProc.getDynamicObject("currentnode"))) {
            resultBo.setCode("-1");
            String message = ResManager.loadKDString((String)"\u5f53\u524d\u6d41\u7a0b\u201c\u5df2\u5e9f\u5f03\u201d\u6216\u8005\u201c\u5df2\u5b8c\u6210\u201d\uff0c\u64cd\u4f5c\u5931\u8d25\u3002", (String)"FlowRuSecondDomainService_4", (String)"opmc-pbs-business", (Object[])new Object[0]);
            resultBo.setMessage(message);
            resultBo.setFailList(taskIds);
            return resultBo;
        }
        DynamicObject currentNode = ruProc.getDynamicObject("currentnode");
        long currentNodeIndex = currentNode.getInt("index");
        ruProc.set("currentnode", (Object)rollbackNodeId);
        DynamicObject opRecord = FLOW_RU_OP_ENTITY_SERVICE.generateOpRecord(ruProc);
        opRecord.set("optype", (Object)FLowOpEnum.ROLLBACK.getValue());
        opRecord.set("description", (Object)reason);
        this.dealEachNodes(taskIds, flowParamBo, rollbackNodeIndex, ruProcId, currentNodeIndex);
        try (TXHandle txhandle = TX.required();){
            if (rollbackNodeIndex < currentNodeIndex) {
                FLOW_RU_PROC_ENTITY_SERVICE.saveOne(ruProc);
            }
            if (!flowParamBo.getRuNodeColl().isEmpty()) {
                FLOW_RU_NODE_ENTITY_SERVICE.save(flowParamBo.getRuNodeColl());
            }
            if (!flowParamBo.getRuRoleColl().isEmpty()) {
                FLOW_RU_ROLE_ENTITY_SERVICE.save(flowParamBo.getRuRoleColl());
            }
            if (!flowParamBo.getRuTaskColl().isEmpty()) {
                FLOW_RU_TASK_ENTITY_SERVICE.save(flowParamBo.getRuTaskColl());
            }
            FLOW_RU_OP_ENTITY_SERVICE.saveOne(opRecord);
            resultBo.setCode("1");
        }
        if ("2".equals(ruProc.getString("workflowtype"))) {
            this.notifyHandler(ruProc, tasks, reason);
        }
        return resultBo;
    }

    private void dealEachNodes(List<Long> taskIds, FlowParamBo flowParamBo, long rollbackNodeIndex, long ruProcId, long currentNodeIndex) {
        DynamicObject[] ruNodes;
        for (DynamicObject ruNode : ruNodes = FLOW_RU_NODE_ENTITY_SERVICE.queryAllNodeByProcId(ruProcId)) {
            int index = ruNode.getInt("index");
            long currentNodeId = ruNode.getLong("id");
            String nodeStatus = ruNode.getString("nodestatus");
            if (HRStringUtils.equals((String)nodeStatus, (String)FlowRuNodeStatusEnum.NOT_ACTIVE.getCode()) || HRStringUtils.equals((String)nodeStatus, (String)FlowRuNodeStatusEnum.RETURNED.getCode())) continue;
            flowParamBo.setRoleStatus(FlowRuRoleStatusEnum.RETURNED.getCode());
            flowParamBo.setTaskStatus(FlowRuTaskStatusEnum.RETURNED.getCode());
            flowParamBo.setCurrentNodeId(currentNodeId);
            if ((long)index == currentNodeIndex) {
                flowParamBo.setCurrentNode(Boolean.TRUE);
            }
            if ((long)index > rollbackNodeIndex) {
                flowParamBo.setNodeStatus(FlowRuNodeStatusEnum.RETURNED.getCode());
                flowParamBo.setRollbackNode(Boolean.FALSE);
            } else {
                if ((long)index != rollbackNodeIndex && currentNodeIndex != rollbackNodeIndex) continue;
                flowParamBo.setNodeStatus(FlowRuNodeStatusEnum.RUNNING.getCode());
                flowParamBo.setTaskIds(taskIds);
                flowParamBo.setRollbackNode(Boolean.TRUE);
            }
            this.collectAllStatus(flowParamBo);
        }
    }

    private void notifyHandler(DynamicObject ruProc, DynamicObject[] tasks, String reason) {
        String actEvalObjId = ruProc.getString("actevalobj");
        for (DynamicObject task : tasks) {
            if (task.getDynamicObject("handler") != null) {
                long handlerId = task.getDynamicObject("handler").getLong("id");
                HashMap urlParams = Maps.newHashMapWithExpectedSize((int)4);
                urlParams.put("formId", "epa_actevalobj_evalmsg");
                urlParams.put("pkId", actEvalObjId);
                urlParams.put("taskId", task.getPkValue().toString());
                urlParams.put("batchTaskId", task.getPkValue().toString());
                urlParams.put("reason", reason);
                ROLLBACK_MSG_SEND_SERVICE.sendMessageWithUrl(FlowRuMsgEnum.EVALUATION_ROLLBACK.getTemplateId(), Collections.singletonList(handlerId), ruProc, urlParams, FlowRuMsgEnum.EVALUATION_ROLLBACK.getTag());
                continue;
            }
            String message = MessageFormat.format(ResManager.loadKDString((String)"\u4efb\u52a1\uff1a\u201c{0}\u201d\u5904\u7406\u4eba\u4e0d\u5b58\u5728\u3002", (String)"FlowRuSecondDomainService_26", (String)"opmc-pbs-business", (Object[])new Object[0]), task.getLong("id"));
            LOG.error(message);
        }
    }

    private FlowRollbackResultBo verificationTasks(List<Long> taskIds, DynamicObject[] tasks) {
        if (null == taskIds || taskIds.isEmpty()) {
            FlowRollbackResultBo resultBo = new FlowRollbackResultBo();
            resultBo.setCode("-1");
            String message = ResManager.loadKDString((String)"\u5165\u53c2\u4efb\u52a1ID\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u786e\u8ba4\u3002", (String)"FlowRuSecondDomainService_6", (String)"opmc-pbs-business", (Object[])new Object[0]);
            resultBo.setMessage(message);
            resultBo.setFailList(taskIds);
            return resultBo;
        }
        if (null == tasks || tasks.length == 0) {
            FlowRollbackResultBo resultBo = new FlowRollbackResultBo();
            resultBo.setCode("-1");
            String message = ResManager.loadKDString((String)"\u5f53\u524d\u65e0\u53ef\u56de\u9000\u7684\u4efb\u52a1\uff0c\u8bf7\u91cd\u65b0\u786e\u8ba4\u3002", (String)"FlowRuSecondDomainService_7", (String)"opmc-pbs-business", (Object[])new Object[0]);
            resultBo.setMessage(message);
            resultBo.setFailList(taskIds);
            return resultBo;
        }
        List<Long> failIds = Arrays.stream(tasks).filter(task -> HRStringUtils.equals((String)FlowRuTaskStatusEnum.EXPIRED.getCode(), (String)task.getString("taskstatus")) || HRStringUtils.equals((String)FlowRuTaskStatusEnum.RETURNED.getCode(), (String)task.getString("taskstatus"))).map(task -> task.getLong("id")).collect(Collectors.toList());
        if (!failIds.isEmpty()) {
            FlowRollbackResultBo resultBo = new FlowRollbackResultBo();
            resultBo.setCode("-1");
            String message = ResManager.loadKDString((String)"\u5b58\u5728\u201c\u5df2\u5931\u6548\u201d\u6216\u201c\u5df2\u9000\u56de\u201d\u7684\u4efb\u52a1\u3002", (String)"FlowRuSecondDomainService_8", (String)"opmc-pbs-business", (Object[])new Object[0]);
            resultBo.setMessage(message);
            resultBo.setFailList(failIds);
            return resultBo;
        }
        List taskRoleIds = Arrays.stream(tasks).filter(task -> !HRObjectUtils.isEmpty((Object)task.getDynamicObject("flowrurole"))).map(task -> task.getDynamicObject("flowrurole").getLong("id")).distinct().collect(Collectors.toList());
        if (!taskRoleIds.isEmpty() && taskRoleIds.size() > 1) {
            FlowRollbackResultBo resultBo = new FlowRollbackResultBo();
            resultBo.setCode("-1");
            String message = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5c5e\u4e8e\u540c\u4e00\u89d2\u8272\u7684\u4efb\u52a1\u9000\u56de\u3002", (String)"FlowRuSecondDomainService_9", (String)"opmc-pbs-business", (Object[])new Object[0]);
            resultBo.setMessage(message);
            resultBo.setFailList(taskIds);
            return resultBo;
        }
        return null;
    }

    private void collectAllStatus(FlowParamBo flowParamBo) {
        block9: {
            boolean istCurrentNode;
            List<FlowRuRoleBo> flowRuRoleBoList;
            block8: {
                FlowRuNodeBo ruNodeInstance = FLOW_RUSUP_DOMAIN_SERVICE.getRuNodeInstance(flowParamBo.getCurrentNodeId());
                DynamicObject flowRuNode = ruNodeInstance.getFlowRuNode();
                WorkflowUtils.updateStatus(flowRuNode, "nodestatus", flowParamBo.getNodeStatus());
                flowParamBo.getRuNodeColl().add((Object)flowRuNode);
                flowRuRoleBoList = ruNodeInstance.getFlowRuRoleBoList();
                boolean isRollbackNode = flowParamBo.getRollbackNode();
                istCurrentNode = flowParamBo.getCurrentNode();
                if (!isRollbackNode) break block8;
                long ruRoleId = flowParamBo.getRuRoleId();
                Optional<FlowRuRoleBo> optional = flowRuRoleBoList.stream().filter(flowRuRoleBo -> ruRoleId == flowRuRoleBo.getFlowRuRole().getLong("id")).findFirst();
                if (!optional.isPresent()) break block9;
                FlowRuRoleBo rollbackRole = optional.get();
                DynamicObject flowDefRole = rollbackRole.getFlowDefRole();
                int turnOverSort = flowDefRole.getInt("turnoversort");
                for (FlowRuRoleBo flowRuRoleBo2 : flowRuRoleBoList) {
                    DynamicObject defRole = flowRuRoleBo2.getFlowDefRole();
                    int turnOverNo = defRole.getInt("turnoversort");
                    if (turnOverNo > turnOverSort) {
                        flowParamBo.setRollbackNode(Boolean.FALSE);
                        flowParamBo.setRoleStatus(FlowRuRoleStatusEnum.RETURNED.getCode());
                        flowParamBo.setTaskStatus(FlowRuTaskStatusEnum.RETURNED.getCode());
                        this.dealRoleAndTasks(flowParamBo, flowRuRoleBo2);
                        continue;
                    }
                    if (turnOverNo != turnOverSort) continue;
                    flowParamBo.setRollbackNode(Boolean.TRUE);
                    flowParamBo.setRoleStatus(FlowRuRoleStatusEnum.RUNNING.getCode());
                    flowParamBo.setTaskStatus(FlowRuTaskStatusEnum.WAITING.getCode());
                    this.dealRoleAndTasks(flowParamBo, flowRuRoleBo2);
                    List<Long> rollbackTaskIds = flowParamBo.getTaskIds();
                    List<DynamicObject> taskList = flowRuRoleBo2.getFlowRuTaskList().stream().filter(task -> !HRStringUtils.equals((String)task.getString("taskstatus"), (String)FlowRuTaskStatusEnum.NOT_ACTIVE.getCode()) && !HRStringUtils.equals((String)task.getString("taskstatus"), (String)FlowRuTaskStatusEnum.REJECTED.getCode()) && !HRStringUtils.equals((String)task.getString("taskstatus"), (String)FlowRuTaskStatusEnum.EXPIRED.getCode())).filter(task -> rollbackTaskIds.contains(task.getLong("id"))).collect(Collectors.toList());
                    if (taskList.isEmpty()) continue;
                    WorkflowUtils.updateRollbackTaskStatus(taskList, flowParamBo.getTaskStatus());
                    flowParamBo.getRuTaskColl().addAll(taskList);
                }
                break block9;
            }
            if (istCurrentNode) {
                List flowRuRoleBos = flowRuRoleBoList.stream().filter(flowRuRoleBo -> !HRStringUtils.equals((String)FlowRuRoleStatusEnum.RETURNED.getCode(), (String)flowRuRoleBo.getFlowRuRole().getString("rolestatus")) || !HRStringUtils.equals((String)FlowRuRoleStatusEnum.EXPIRED.getCode(), (String)flowRuRoleBo.getFlowRuRole().getString("rolestatus")) || !HRStringUtils.equals((String)FlowRuRoleStatusEnum.PENDING.getCode(), (String)flowRuRoleBo.getFlowRuRole().getString("rolestatus"))).collect(Collectors.toList());
                for (FlowRuRoleBo flowRuRoleBo3 : flowRuRoleBos) {
                    String roleStatus = flowRuRoleBo3.getFlowRuRole().getString("rolestatus");
                    if (HRStringUtils.equals((String)FlowRuRoleStatusEnum.RETURNED.getCode(), (String)roleStatus) || HRStringUtils.equals((String)FlowRuRoleStatusEnum.BE_WAITTING.getCode(), (String)roleStatus)) {
                        flowParamBo.setCurrentNode(Boolean.TRUE);
                    } else {
                        flowParamBo.setCurrentNode(Boolean.FALSE);
                    }
                    this.dealRoleAndTasks(flowParamBo, flowRuRoleBo3);
                }
                flowParamBo.setCurrentNode(Boolean.FALSE);
            } else {
                for (FlowRuRoleBo flowRuRoleBo4 : flowRuRoleBoList) {
                    this.dealRoleAndTasks(flowParamBo, flowRuRoleBo4);
                }
            }
        }
    }

    private void dealRoleAndTasks(FlowParamBo flowParamBo, FlowRuRoleBo flowRuRoleBo) {
        DynamicObject flowRuRole = flowRuRoleBo.getFlowRuRole();
        String roleStatus = flowRuRole.getString("rolestatus");
        if (!HRStringUtils.equals((String)roleStatus, (String)FlowRuRoleStatusEnum.NOT_ACTIVE.getCode())) {
            WorkflowUtils.updateStatus(flowRuRole, "rolestatus", flowParamBo.getRoleStatus());
            flowParamBo.getRuRoleColl().add((Object)flowRuRole);
            boolean isRollbackNode = flowParamBo.getRollbackNode();
            if (!isRollbackNode) {
                boolean istCurrentNode = flowParamBo.getCurrentNode();
                List<DynamicObject> tasks = flowRuRoleBo.getFlowRuTaskList();
                for (DynamicObject task : tasks) {
                    if (istCurrentNode) {
                        if (HRStringUtils.equals((String)task.getString("taskstatus"), (String)FlowRuTaskStatusEnum.NOT_ACTIVE.getCode()) || HRStringUtils.equals((String)task.getString("taskstatus"), (String)FlowRuTaskStatusEnum.REJECTED.getCode()) || HRStringUtils.equals((String)task.getString("taskstatus"), (String)FlowRuTaskStatusEnum.PROCESSED.getCode()) || HRStringUtils.equals((String)task.getString("taskstatus"), (String)FlowRuTaskStatusEnum.EXPIRED.getCode())) continue;
                        WorkflowUtils.updateStatus(task, "taskstatus", flowParamBo.getTaskStatus());
                        flowParamBo.getRuTaskColl().add((Object)task);
                        continue;
                    }
                    if (HRStringUtils.equals((String)task.getString("taskstatus"), (String)FlowRuTaskStatusEnum.NOT_ACTIVE.getCode()) || HRStringUtils.equals((String)task.getString("taskstatus"), (String)FlowRuTaskStatusEnum.REJECTED.getCode()) || HRStringUtils.equals((String)task.getString("taskstatus"), (String)FlowRuTaskStatusEnum.EXPIRED.getCode())) continue;
                    WorkflowUtils.updateStatus(task, "taskstatus", flowParamBo.getTaskStatus());
                    flowParamBo.getRuTaskColl().add((Object)task);
                }
            }
        }
    }

    public boolean deleteRunProc(List<Long> procList) {
        DynamicObject[] procs = FLOW_RU_PROC_ENTITY_SERVICE.queryProcByPkIds(procList);
        List<Long> actEvalObjIds = Arrays.stream(procs).map(e -> e.getLong("actevalobj")).collect(Collectors.toList());
        try {
            FLOW_RU_TASK_ENTITY_SERVICE.deleteAllTaskByProcInstId(procList);
            FLOW_RU_ROLE_ENTITY_SERVICE.deleteAllRoleByProcInstId(procList);
            FLOW_RU_NODE_ENTITY_SERVICE.deleteAllNodeByProcInstId(procList);
            FLOW_RU_PROC_ENTITY_SERVICE.deleteProcByPk(procList);
            CROSS_SCORE_DOMAIN_SERVICE.deleteSetByActEvalObjs(actEvalObjIds);
            BATCH_TASKMAP_ENTITY_SERVICE.deleteByActevalObjs(actEvalObjIds);
        }
        catch (Exception exc) {
            LOG.error("delete operation fail", (Throwable)exc);
        }
        return Boolean.TRUE;
    }

    public FlowValidateResultBo skipTask(List<Long> taskIds) {
        DynamicObject[] tasks = FLOW_RU_TASK_ENTITY_SERVICE.queryTasksByIds(taskIds);
        HashMap<Long, String> resultMap = new HashMap<Long, String>(16);
        List skipTasks = Arrays.stream(tasks).filter(task -> HRStringUtils.equals((String)FlowRuTaskStatusEnum.EXPIRED.getCode(), (String)task.getString("taskstatus")) || HRStringUtils.equals((String)FlowRuTaskStatusEnum.RETURNED.getCode(), (String)task.getString("taskstatus"))).map(task -> task.getLong("id")).collect(Collectors.toList());
        Iterator iterator = skipTasks.iterator();
        while (iterator.hasNext()) {
            long taskId = (Long)iterator.next();
            String message = ResManager.loadKDString((String)"\u4efb\u52a1\u201c\u5df2\u5931\u6548\u201d\u6216\u201c\u5df2\u9000\u56de\u201d\u3002", (String)"FlowRuSecondDomainService_27", (String)"opmc-pbs-business", (Object[])new Object[0]);
            resultMap.put(taskId, message);
        }
        Map<Long, List<DynamicObject>> skipTasksMap = Arrays.stream(tasks).filter(task -> !HRStringUtils.equals((String)FlowRuTaskStatusEnum.EXPIRED.getCode(), (String)task.getString("taskstatus")) && !HRStringUtils.equals((String)FlowRuTaskStatusEnum.RETURNED.getCode(), (String)task.getString("taskstatus"))).collect(Collectors.groupingBy(task -> task.getDynamicObject("flowrurole").getLong("id")));
        DynamicObjectCollection needSkipTasks = new DynamicObjectCollection();
        for (Map.Entry<Long, List<DynamicObject>> entry : skipTasksMap.entrySet()) {
            FlowRuRoleBo ruRoleInstance = FLOW_RUSUP_DOMAIN_SERVICE.getRuRoleInstance(entry.getKey());
            List<DynamicObject> flowRuTaskList = ruRoleInstance.getFlowRuTaskList();
            List ruTasks = flowRuTaskList.stream().filter(task -> !HRStringUtils.equals((String)FlowRuTaskStatusEnum.EXPIRED.getCode(), (String)task.getString("taskstatus")) && !HRStringUtils.equals((String)FlowRuTaskStatusEnum.RETURNED.getCode(), (String)task.getString("taskstatus"))).collect(Collectors.toList());
            if (ruTasks.size() == 1) {
                String message = ResManager.loadKDString((String)"\u4efb\u52a1\u53ea\u6709\u4e00\u4e2a\u5904\u7406\u4eba\uff0c\u4e0d\u652f\u6301\u8df3\u8fc7\u3002", (String)"FlowRuSecondDomainService_11", (String)"opmc-pbs-business", (Object[])new Object[0]);
                long taskId = ((DynamicObject)ruTasks.get(0)).getLong("id");
                resultMap.put(taskId, message);
                continue;
            }
            String tabStr = ResManager.loadKDString((String)"\u8df3\u8fc7", (String)"FlowRuSecondDomainService_12", (String)"opmc-pbs-business", (Object[])new Object[0]);
            List<DynamicObject> dynamicObjectList = entry.getValue();
            if (ruTasks.size() == dynamicObjectList.size()) {
                for (int i = 0; i < ruTasks.size() - 1; ++i) {
                    DynamicObject task2 = (DynamicObject)ruTasks.get(i);
                    WorkflowUtils.updateStatus(task2, "taskstatus", FlowRuTaskStatusEnum.EXPIRED.getCode());
                    task2.set("description", (Object)tabStr);
                    needSkipTasks.add((Object)task2);
                }
                continue;
            }
            for (DynamicObject shipTask : dynamicObjectList) {
                for (DynamicObject ruTask : ruTasks) {
                    if (!HRObjectUtils.equals((Object)shipTask, (Object)ruTask)) continue;
                    WorkflowUtils.updateStatus(ruTask, "taskstatus", FlowRuTaskStatusEnum.EXPIRED.getCode());
                    ruTask.set("description", (Object)tabStr);
                    needSkipTasks.add((Object)ruTask);
                }
            }
        }
        if (!needSkipTasks.isEmpty()) {
            FLOW_RU_TASK_ENTITY_SERVICE.save(needSkipTasks);
        }
        FlowValidateResultBo resultBo = new FlowValidateResultBo();
        resultBo.setCode(resultMap.size() > 0 ? "-1" : "1");
        resultBo.setValidateMap(resultMap);
        return resultBo;
    }

    public FlowValidateResultBo restoreTask(List<Long> taskIds) {
        DynamicObject[] tasks = FLOW_RU_TASK_ENTITY_SERVICE.queryTasksByIds(taskIds);
        DynamicObjectCollection needRestoreProc = new DynamicObjectCollection();
        DynamicObjectCollection opRecordColl = new DynamicObjectCollection();
        FlowParamBo flowParamBo = new FlowParamBo();
        HashMap<Long, String> resultMap = new HashMap<Long, String>(16);
        Map<Long, List<DynamicObject>> restoreTasksMap = Arrays.stream(tasks).filter(task -> HRStringUtils.equals((String)FlowRuTaskStatusEnum.EXPIRED.getCode(), (String)task.getString("taskstatus"))).collect(Collectors.groupingBy(task -> task.getDynamicObject("flowrurole").getLong("id")));
        List restoreTaskList = Arrays.stream(tasks).filter(task -> HRStringUtils.equals((String)FlowRuTaskStatusEnum.EXPIRED.getCode(), (String)task.getString("taskstatus"))).collect(Collectors.toList());
        List<Long> ruProcIds = restoreTaskList.stream().map(task -> task.getDynamicObject("flowruproc").getLong("id")).distinct().collect(Collectors.toList());
        List nodes = restoreTaskList.stream().map(task -> task.getDynamicObject("flowrunode")).distinct().collect(Collectors.toList());
        List nodeIndexs = nodes.stream().map(node -> node.getInt("index")).distinct().collect(Collectors.toList());
        List<Integer> nextIndexs = nodeIndexs.stream().map(index -> index + 1).distinct().collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(nextIndexs)) {
            List nextRuNodes = Arrays.stream(FLOW_RU_NODE_ENTITY_SERVICE.loadRuNodeByProcIdsAndIndexs(ruProcIds, nextIndexs)).collect(Collectors.toList());
            nodes.addAll(nextRuNodes);
        }
        List<Long> nodeIds = nodes.stream().map(node -> node.getLong("id")).distinct().collect(Collectors.toList());
        DynamicObject[] dynamicObjects = FLOW_RU_ROLE_ENTITY_SERVICE.loadRuRoleByNodeIds(nodeIds);
        Map<Long, List<DynamicObject>> keyNodeValRoles = Arrays.stream(dynamicObjects).collect(Collectors.groupingBy(role -> role.getDynamicObject("flowrunode").getLong("id")));
        for (Map.Entry<Long, List<DynamicObject>> entry : restoreTasksMap.entrySet()) {
            DynamicObject flowRuNode;
            String message;
            long ruRoleId = entry.getKey();
            DynamicObject ruRole = FLOW_RU_ROLE_ENTITY_SERVICE.loadSingle(ruRoleId);
            if (HRObjectUtils.isEmpty((Object)ruRole.getDynamicObject("flowrunode"))) continue;
            long ruNodeId = ruRole.getDynamicObject("flowrunode").getLong("id");
            FlowRuNodeBo flowRuNodeBo = FLOW_RUSUP_DOMAIN_SERVICE.querySpecifyRoles(ruNodeId, ruRole.getInt("turnoversort") + 1);
            List<FlowRuRoleBo> specifyRoles = flowRuNodeBo.getFlowRuRoleBoList();
            if (specifyRoles.isEmpty()) {
                if (!HRObjectUtils.isEmpty((Object)ruRole.getDynamicObject("flowruproc"))) {
                    long ruProcId = ruRole.getDynamicObject("flowruproc").getLong("id");
                    DynamicObject ruProc = FLOW_RU_PROC_ENTITY_SERVICE.loadSingle(ruProcId);
                    if (HRStringUtils.equals((String)FlowRuProcStatusEnum.FINISHED.getCode(), (String)ruProc.getString("procstatus"))) {
                        ruProc.set("currentnode", (Object)ruNodeId);
                        WorkflowUtils.updateStatus(ruProc, "procstatus", FlowRuProcStatusEnum.RUNNING.getCode());
                        needRestoreProc.add((Object)ruProc);
                        DynamicObject opRecord = FLOW_RU_OP_ENTITY_SERVICE.generateOpRecord(ruProc);
                        opRecord.set("optype", (Object)FLowOpEnum.RESTORE.getValue());
                        String message2 = ResManager.loadKDString((String)"\u6062\u590d\u670d\u52a1", (String)"FlowRuSecondDomainService_13", (String)"opmc-pbs-business", (Object[])new Object[0]);
                        opRecord.set("description", (Object)message2);
                        opRecordColl.add((Object)opRecord);
                    }
                }
                DynamicObject flowRuNode2 = flowRuNodeBo.getFlowRuNode();
                if (HRStringUtils.equals((String)FlowRuNodeStatusEnum.FINISHED.getCode(), (String)flowRuNode2.getString("nodestatus"))) {
                    WorkflowUtils.updateStatus(flowRuNode2, "nodestatus", FlowRuNodeStatusEnum.RUNNING.getCode());
                    flowParamBo.getRuNodeColl().add((Object)flowRuNode2);
                }
                if (HRStringUtils.equals((String)FlowRuRoleStatusEnum.FINISHED.getCode(), (String)ruRole.getString("rolestatus"))) {
                    WorkflowUtils.updateStatus(ruRole, "rolestatus", FlowRuRoleStatusEnum.RUNNING.getCode());
                    flowParamBo.getRuRoleColl().add((Object)flowRuNode2);
                }
                List<DynamicObject> restoreTasks = entry.getValue();
                WorkflowUtils.updateTaskStatus(restoreTasks, FlowRuTaskStatusEnum.WAITING.getCode());
                flowParamBo.getRuTaskColl().addAll(restoreTasks);
                continue;
            }
            List<FlowRuRoleBo> waitingRoles = specifyRoles.stream().filter(role -> HRStringUtils.equals((String)FlowRuRoleStatusEnum.NOT_ACTIVE.getCode(), (String)role.getFlowRuRole().getString("rolestatus")) || HRStringUtils.equals((String)FlowRuRoleStatusEnum.BE_WAITTING.getCode(), (String)role.getFlowRuRole().getString("rolestatus")) || HRStringUtils.equals((String)FlowRuRoleStatusEnum.RETURNED.getCode(), (String)role.getFlowRuRole().getString("rolestatus"))).collect(Collectors.toList());
            if (waitingRoles.size() == specifyRoles.size()) {
                this.updateNextRoleAndTasksStatus(flowParamBo, waitingRoles, entry.getValue());
            } else {
                specifyRoles.removeAll(waitingRoles);
                List allTasks = specifyRoles.stream().filter(role -> !HRStringUtils.equals((String)FlowRuRoleStatusEnum.NOT_ACTIVE.getCode(), (String)role.getFlowRuRole().getString("rolestatus")) && !HRStringUtils.equals((String)FlowRuRoleStatusEnum.BE_WAITTING.getCode(), (String)role.getFlowRuRole().getString("rolestatus")) && !HRStringUtils.equals((String)FlowRuRoleStatusEnum.RETURNED.getCode(), (String)role.getFlowRuRole().getString("rolestatus"))).map(FlowRuRoleBo::getFlowRuTaskList).flatMap(Collection::stream).collect(Collectors.toList());
                List notWaitingTasks = allTasks.stream().filter(task -> !HRStringUtils.equals((String)FlowRuTaskStatusEnum.NOT_ACTIVE.getCode(), (String)task.getString("taskstatus")) && !HRStringUtils.equals((String)FlowRuTaskStatusEnum.WAITING.getCode(), (String)task.getString("taskstatus")) && !HRStringUtils.equals((String)FlowRuTaskStatusEnum.BE_WAITTING.getCode(), (String)task.getString("taskstatus")) && !HRStringUtils.equals((String)FlowRuTaskStatusEnum.RETURNED.getCode(), (String)task.getString("taskstatus")) && !HRStringUtils.equals((String)FlowRuTaskStatusEnum.PENDING.getCode(), (String)task.getString("taskstatus"))).collect(Collectors.toList());
                if (notWaitingTasks.isEmpty()) {
                    this.updateNextRoleAndTasksStatus(flowParamBo, specifyRoles, entry.getValue());
                } else {
                    List<DynamicObject> restoreTasks = entry.getValue();
                    for (DynamicObject task2 : restoreTasks) {
                        message = ResManager.loadKDString((String)"\u4e0b\u4e00\u8282\u70b9\u89d2\u8272\u6216\u8282\u70b9\u5904\u7406\u4eba\u4e0d\u662f\u201c\u5f85\u5904\u7406\u201d\u72b6\u6001\uff0c\u4e0d\u652f\u6301\u6062\u590d\u4efb\u52a1\u3002", (String)"FlowRuSecondDomainService_28", (String)"opmc-pbs-business", (Object[])new Object[0]);
                        long taskId = task2.getLong("id");
                        resultMap.put(taskId, message);
                    }
                    continue;
                }
            }
            if ((flowRuNode = flowRuNodeBo.getFlowRuNode()).getLong("id") == ruNodeId) continue;
            if (!HRObjectUtils.isEmpty((Object)ruRole.getDynamicObject("flowruproc"))) {
                long ruProcId = ruRole.getDynamicObject("flowruproc").getLong("id");
                DynamicObject ruProc = FLOW_RU_PROC_ENTITY_SERVICE.loadSingle(ruProcId);
                ruProc.set("currentnode", (Object)ruNodeId);
                needRestoreProc.add((Object)ruProc);
                DynamicObject opRecord = FLOW_RU_OP_ENTITY_SERVICE.generateOpRecord(ruProc);
                opRecord.set("optype", (Object)FLowOpEnum.RESTORE.getValue());
                message = ResManager.loadKDString((String)"\u6062\u590d\u670d\u52a1", (String)"FlowRuSecondDomainService_13", (String)"opmc-pbs-business", (Object[])new Object[0]);
                opRecord.set("description", (Object)message);
                opRecordColl.add((Object)opRecord);
            }
            WorkflowUtils.updateStatus(flowRuNode, "nodestatus", FlowRuNodeStatusEnum.NOT_ACTIVE.getCode());
            flowParamBo.getRuNodeColl().add((Object)flowRuNode);
            DynamicObject ruNode = FLOW_RU_NODE_ENTITY_SERVICE.loadSingle(ruNodeId);
            WorkflowUtils.updateStatus(ruNode, "nodestatus", FlowRuNodeStatusEnum.RUNNING.getCode());
            flowParamBo.getRuNodeColl().add((Object)ruNode);
            WorkflowUtils.updateStatus(ruRole, "rolestatus", FlowRuRoleStatusEnum.RUNNING.getCode());
            flowParamBo.getRuRoleColl().add((Object)flowRuNode);
        }
        if (!needRestoreProc.isEmpty()) {
            FLOW_RU_PROC_ENTITY_SERVICE.save(needRestoreProc);
        }
        if (!flowParamBo.getRuNodeColl().isEmpty()) {
            FLOW_RU_NODE_ENTITY_SERVICE.save(flowParamBo.getRuNodeColl());
        }
        if (!flowParamBo.getRuRoleColl().isEmpty()) {
            FLOW_RU_ROLE_ENTITY_SERVICE.save(flowParamBo.getRuRoleColl());
        }
        if (!flowParamBo.getRuTaskColl().isEmpty()) {
            FLOW_RU_TASK_ENTITY_SERVICE.save(flowParamBo.getRuTaskColl());
        }
        if (!opRecordColl.isEmpty()) {
            FLOW_RU_OP_ENTITY_SERVICE.save(opRecordColl);
        }
        FlowValidateResultBo resultBo = new FlowValidateResultBo();
        resultBo.setCode(resultMap.size() > 0 ? "-1" : "1");
        resultBo.setValidateMap(resultMap);
        return resultBo;
    }

    private void updateNextRoleAndTasksStatus(FlowParamBo flowParamBo, List<FlowRuRoleBo> specifyRoles, List<DynamicObject> restoreTasks) {
        WorkflowUtils.updateTaskStatus(restoreTasks, FlowRuTaskStatusEnum.WAITING.getCode());
        flowParamBo.getRuTaskColl().addAll(restoreTasks);
        for (FlowRuRoleBo roleBo : specifyRoles) {
            DynamicObject flowRuRole = roleBo.getFlowRuRole();
            WorkflowUtils.updateStatus(flowRuRole, "rolestatus", FlowRuRoleStatusEnum.NOT_ACTIVE.getCode());
            flowParamBo.getRuRoleColl().add((Object)flowRuRole);
            List<DynamicObject> flowRuTaskList = roleBo.getFlowRuTaskList();
            WorkflowUtils.updateTaskStatus(flowRuTaskList, FlowRuTaskStatusEnum.EXPIRED.getCode());
            flowParamBo.getRuTaskColl().addAll(flowRuTaskList);
        }
    }

    public FlowValidateResultBo batchRollbackTasks(List<Long> taskIds, String reason) {
        if (CollectionUtils.isEmpty(taskIds)) {
            return this.getFlowValidateResultBo(ResManager.loadKDString((String)"\u5f53\u524d\u65e0\u53ef\u56de\u9000\u7684\u4efb\u52a1\uff0c\u8bf7\u91cd\u65b0\u786e\u8ba4\u3002", (String)"FlowRuSecondDomainService_7", (String)"opmc-pbs-business", (Object[])new Object[0]), "FlowRuSecondDomainService_7");
        }
        BatchFlowParamBo flowParamBo = new BatchFlowParamBo();
        flowParamBo.setReason(WorkflowUtils.getReason(reason));
        List wantToRollbackTasks = Arrays.stream(FLOW_RU_TASK_ENTITY_SERVICE.loadTasksByIds(taskIds)).collect(Collectors.toList());
        List<Long> procIds = wantToRollbackTasks.stream().map(task -> task.getDynamicObject("flowruproc").getLong("id")).distinct().collect(Collectors.toList());
        List<DynamicObject> ruProcs = Arrays.stream(FLOW_RU_PROC_ENTITY_SERVICE.loadRuProcByIds(procIds)).collect(Collectors.toList());
        List<DynamicObject> canNotRollbackRuprocs = ruProcs.stream().filter(proc -> !HRStringUtils.equals((String)proc.getString("procstatus"), (String)FlowRuProcStatusEnum.RUNNING.getCode()) && !HRStringUtils.equals((String)proc.getString("procstatus"), (String)FlowRuProcStatusEnum.PENDING.getCode())).collect(Collectors.toList());
        List canNotRollbackRuprocIds = canNotRollbackRuprocs.stream().map(proc -> proc.getLong("id")).distinct().collect(Collectors.toList());
        List canRollbackTasks = wantToRollbackTasks.stream().filter(task -> !canNotRollbackRuprocIds.contains(task.getDynamicObject("flowruproc").getLong("id"))).collect(Collectors.toList());
        wantToRollbackTasks.removeAll(canRollbackTasks);
        Map<Long, List<DynamicObject>> keyProcIdValCanNotRollbackTask = wantToRollbackTasks.stream().collect(Collectors.groupingBy(task -> task.getDynamicObject("flowruproc").getLong("id")));
        ruProcs.removeAll(canNotRollbackRuprocs);
        flowParamBo.setAllRuProcs(ruProcs);
        List<Long> ruNodeIds = canRollbackTasks.stream().map(task -> task.getDynamicObject("flowrunode").getLong("id")).distinct().collect(Collectors.toList());
        List<Long> currentNodeIds = ruProcs.stream().filter(proc -> !HRObjectUtils.isEmpty((Object)proc.getDynamicObject("currentnode"))).map(proc -> proc.getDynamicObject("currentnode").getLong("id")).distinct().collect(Collectors.toList());
        currentNodeIds.retainAll(ruNodeIds);
        if (!canRollbackTasks.isEmpty()) {
            List<DynamicObject> crossNodeLeftTasks;
            List<DynamicObject> backToLastTasks = canRollbackTasks.stream().filter(task -> currentNodeIds.contains(task.getDynamicObject("flowrunode").getLong("id"))).collect(Collectors.toList());
            Map<Long, DynamicObject> keyIdValProc = ruProcs.stream().collect(Collectors.toMap(key -> key.getLong("id"), value -> value));
            if (!currentNodeIds.isEmpty()) {
                BatchFlowParamBo backToLastParamBo = new BatchFlowParamBo();
                backToLastParamBo.setKeyIdValProc(keyIdValProc);
                backToLastParamBo.setReason(reason);
                if (!backToLastTasks.isEmpty()) {
                    List<Long> backToLastProcIds = backToLastTasks.stream().map(task -> task.getDynamicObject("flowruproc").getLong("id")).distinct().collect(Collectors.toList());
                    if (CollectionUtils.isNotEmpty(backToLastProcIds)) {
                        this.rollbackToLastNodeOrRole(backToLastParamBo, backToLastTasks, backToLastProcIds, currentNodeIds);
                    }
                    this.integrateBos(flowParamBo, backToLastParamBo);
                }
            }
            ruNodeIds.removeAll(currentNodeIds);
            if (!ruNodeIds.isEmpty()) {
                canRollbackTasks.removeAll(backToLastTasks);
                BatchFlowParamBo backToTargetParamBo = new BatchFlowParamBo();
                backToTargetParamBo.setKeyIdValProc(keyIdValProc);
                backToTargetParamBo.setReason(reason);
                List<DynamicObject> backToTargetTasks = canRollbackTasks.stream().filter(task -> HRStringUtils.equals((String)task.getString("taskstatus"), (String)FlowRuTaskStatusEnum.PROCESSED.getCode())).collect(Collectors.toList());
                canRollbackTasks.removeAll(backToTargetTasks);
                backToTargetParamBo.getValidateTargetTaskColl().addAll(canRollbackTasks);
                if (!backToTargetTasks.isEmpty()) {
                    List<Long> backToTargetProcIds = backToTargetTasks.stream().map(task -> task.getDynamicObject("flowruproc").getLong("id")).distinct().collect(Collectors.toList());
                    this.rollbackToTargetTask(backToTargetParamBo, backToTargetTasks, backToTargetProcIds, ruNodeIds);
                    this.integrateBos(flowParamBo, backToTargetParamBo);
                    canRollbackTasks.clear();
                }
            }
            if (CollectionUtils.isNotEmpty(crossNodeLeftTasks = canRollbackTasks.stream().filter(task -> task.getDynamicObject("flowrunode").getBoolean("iscrossnode") && HRStringUtils.equals((String)task.getDynamicObject("flowrunode").getString("nodestatus"), (String)FlowRuNodeStatusEnum.RETURNED.getCode())).collect(Collectors.toList()))) {
                BatchFlowParamBo crossNodeLeftParamBo = new BatchFlowParamBo();
                crossNodeLeftParamBo.setKeyIdValProc(keyIdValProc);
                this.dealCrossNodeLeftSetNoTask(crossNodeLeftTasks, crossNodeLeftParamBo);
                this.integrateBos(flowParamBo, crossNodeLeftParamBo);
            }
        }
        FlowValidateResultBo resultBo = new FlowValidateResultBo();
        Map<Long, String> resultMap = this.buildValidateMap(canNotRollbackRuprocs, keyProcIdValCanNotRollbackTask, flowParamBo);
        this.findPendingTasks(flowParamBo);
        String updateResult = this.updateRollbackTasksStatus(flowParamBo);
        if (HRStringUtils.isNotEmpty((String)updateResult)) {
            HashMap<Long, String> errortMap = new HashMap<Long, String>(16);
            resultBo.setCode("-1");
            errortMap.put(1L, updateResult);
            resultBo.setValidateMap(errortMap);
            resultBo.setMessage(updateResult);
            return resultBo;
        }
        this.sendMessageMerge(flowParamBo, "0");
        this.sendPendingMessage(flowParamBo);
        this.updateEvaluatorFlowIndicatorEditStatus(flowParamBo);
        resultBo.setCode(resultMap.size() > 0 ? "-1" : "1");
        resultBo.setValidateMap(resultMap);
        return resultBo;
    }

    private void updateEvaluatorFlowIndicatorEditStatus(BatchFlowParamBo flowParamBo) {
        if (CollectionUtils.isNotEmpty(flowParamBo.getAllRuProcs())) {
            Map<Long, Long> keyTaskValProc = flowParamBo.getRuTaskColl().stream().filter(task -> HRStringUtils.equals((String)task.getString("taskstatus"), (String)FlowRuTaskStatusEnum.WAITING.getCode()) || HRStringUtils.equals((String)task.getString("taskstatus"), (String)FlowRuTaskStatusEnum.PENDING.getCode())).collect(Collectors.toMap(x -> x.getLong("id"), y -> y.getDynamicObject("flowruproc").getLong("id")));
            Map<Long, List<DynamicObject>> keyProcIdValBackTask = flowParamBo.getRuTaskColl().stream().collect(Collectors.groupingBy(task -> task.getDynamicObject("flowruproc").getLong("id")));
            Map<String, List<DynamicObject>> keyTypeValProc = flowParamBo.getAllRuProcs().stream().filter(proc -> keyProcIdValBackTask.containsKey(proc.getLong("id"))).collect(Collectors.groupingBy(proc -> proc.getString("workflowtype")));
            ArrayList<Map<String, Object>> paramList = new ArrayList<Map<String, Object>>(10);
            Map<Long, List<Long>> taskAndIndicatorMap = flowParamBo.getTaskAndIndicatorMap();
            HashMap<Long, List> procAndIndicatorMap = new HashMap<Long, List>(16);
            if (taskAndIndicatorMap != null && !taskAndIndicatorMap.entrySet().isEmpty()) {
                for (Map.Entry entry : taskAndIndicatorMap.entrySet()) {
                    Long taskId = (Long)entry.getKey();
                    Long procId = keyTaskValProc.get(taskId);
                    List indicatorIds = (List)entry.getValue();
                    if (procAndIndicatorMap.containsKey(procId)) {
                        List indIds = (List)procAndIndicatorMap.get(procId);
                        indIds.addAll(indicatorIds);
                        procAndIndicatorMap.put(procId, indIds);
                        continue;
                    }
                    procAndIndicatorMap.put(procId, indicatorIds);
                }
            } else {
                for (Long l : keyTaskValProc.values()) {
                    procAndIndicatorMap.put(l, new ArrayList(10));
                }
            }
            for (Map.Entry entry : keyTypeValProc.entrySet()) {
                String flowType = (String)entry.getKey();
                if (!HRStringUtils.equals((String)"2", (String)flowType)) continue;
                List procIds = ((List)entry.getValue()).stream().map(proc -> proc.getLong("id")).distinct().collect(Collectors.toList());
                for (Long procId : procIds) {
                    List<DynamicObject> tasks = keyProcIdValBackTask.get(procId);
                    List indicIds = (List)procAndIndicatorMap.get(procId);
                    for (DynamicObject task2 : tasks) {
                        HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
                        Long taskId = task2.getLong("id");
                        boolean isCrossNode = task2.getDynamicObject("flowrunode").getBoolean("iscrossnode");
                        paramMap.put("taskId", taskId);
                        paramMap.put("type", isCrossNode ? "2" : "1");
                        List<Long> indicIdsByTask = this.getIndicIds(task2);
                        if (CollectionUtils.isNotEmpty((Collection)indicIds)) {
                            if (CollectionUtils.isNotEmpty(indicIdsByTask)) {
                                indicIdsByTask.retainAll(indicIds);
                                paramMap.put("indicatorIds", indicIdsByTask);
                            } else {
                                paramMap.put("indicatorIds", indicIds);
                            }
                        } else {
                            paramMap.put("indicatorIds", indicIdsByTask);
                        }
                        paramList.add(paramMap);
                    }
                }
                String rollbackType = flowParamBo.getRollbackType();
                Map<Long, List<DynamicObject>> keyProcValTask = flowParamBo.getKeyProcValTask();
                if (!HRStringUtils.equals((String)rollbackType, (String)"1") || keyProcValTask.isEmpty()) continue;
                for (Long procId : procIds) {
                    List<DynamicObject> tasks = keyProcValTask.get(procId);
                    for (DynamicObject task3 : tasks) {
                        HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
                        Long taskId = task3.getLong("id");
                        boolean isCrossNode = task3.getDynamicObject("flowrunode").getBoolean("iscrossnode");
                        paramMap.put("taskId", taskId);
                        paramMap.put("type", isCrossNode ? "2" : "1");
                        List<Long> indicIdsByTask = this.getIndicIds(task3);
                        paramMap.put("indicatorIds", indicIdsByTask);
                        paramList.add(paramMap);
                    }
                }
            }
            if (CollectionUtils.isNotEmpty(paramList)) {
                IEPAActEvalRecordService.getInstance().updateGenAreaIndicatorCanEdit(paramList);
            }
        }
    }

    private List<Long> getIndicIds(DynamicObject task) {
        DynamicObjectCollection indicatorColl = task.getDynamicObjectCollection("entryentity");
        return indicatorColl.stream().map(dym -> dym.getLong("indicatorid")).collect(Collectors.toList());
    }

    private void dealCrossNodeLeftSetNoTask(List<DynamicObject> crossNodeLeftTasks, BatchFlowParamBo flowParamBo) {
        List<Long> ruProcIds = crossNodeLeftTasks.stream().map(task -> task.getDynamicObject("flowruproc").getLong("id")).distinct().collect(Collectors.toList());
        List<Long> ruNodeIds = crossNodeLeftTasks.stream().map(task -> task.getDynamicObject("flowrunode").getLong("id")).distinct().collect(Collectors.toList());
        List currentNodes = Arrays.stream(FLOW_RU_NODE_ENTITY_SERVICE.loadRuNodeByIds(ruNodeIds)).collect(Collectors.toList());
        List nodeIndexs = currentNodes.stream().map(node -> node.getInt("index")).distinct().collect(Collectors.toList());
        List<Integer> preIndexs = nodeIndexs.stream().map(index -> index - 1).filter(index -> index > 0).distinct().collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(preIndexs)) {
            List preRuNodes = Arrays.stream(FLOW_RU_NODE_ENTITY_SERVICE.loadRuNodeByProcIdsAndIndexs(ruProcIds, preIndexs)).collect(Collectors.toList());
            currentNodes.addAll(preRuNodes);
        }
        Map<Long, List<DynamicObject>> keyProcValNode = currentNodes.stream().collect(Collectors.groupingBy(node -> node.getDynamicObject("flowruproc").getLong("id")));
        List<Long> allRuNodeIds = currentNodes.stream().map(node -> node.getLong("id")).distinct().collect(Collectors.toList());
        List allRuRoles = Arrays.stream(FLOW_RU_ROLE_ENTITY_SERVICE.loadRuRoleByNodeIds(allRuNodeIds)).collect(Collectors.toList());
        Map<Long, List<DynamicObject>> keyNodeValRole = allRuRoles.stream().collect(Collectors.groupingBy(role -> role.getDynamicObject("flowrunode").getLong("id")));
        List ruRoleIds = crossNodeLeftTasks.stream().map(task -> task.getDynamicObject("flowrurole").getLong("id")).distinct().collect(Collectors.toList());
        List setNos = crossNodeLeftTasks.stream().map(task -> task.getDynamicObject("flowrurole").getString("setno")).distinct().collect(Collectors.toList());
        for (Long nodeId : ruNodeIds) {
            Optional<DynamicObject> nodeOptional = currentNodes.stream().filter(node -> node.getLong("id") == nodeId.longValue()).findFirst();
            if (!nodeOptional.isPresent()) continue;
            DynamicObject currentNode = nodeOptional.get();
            List ruRoles = keyNodeValRole.get(nodeId).stream().filter(role -> setNos.contains(role.getString("setno"))).collect(Collectors.toList());
            List<DynamicObject> currentRoles = ruRoles.stream().filter(role -> ruRoleIds.contains(role.getLong("id"))).collect(Collectors.toList());
            WorkflowUtils.updateRoleStatus(currentRoles, FlowRuRoleStatusEnum.RETURNED.getCode());
            flowParamBo.getRuRoleColl().addAll(currentRoles);
            Map<String, List<DynamicObject>> keySetNoValRole = currentRoles.stream().sorted(Comparator.comparing(role -> role.getInt("turnoversort"), Comparator.nullsLast(Comparator.reverseOrder()))).collect(Collectors.groupingBy(role -> role.getString("setno")));
            for (Map.Entry<String, List<DynamicObject>> entry : keySetNoValRole.entrySet()) {
                List<DynamicObject> rolesGroupBySetNo = entry.getValue();
                HashSet<Integer> sortSet = new HashSet<Integer>(16);
                String setNo = entry.getKey();
                for (DynamicObject currentRole : rolesGroupBySetNo) {
                    DynamicObject lessThanCurrentRoleSortAndGetMax;
                    int turnSort = currentRole.getInt("turnoversort");
                    if (sortSet.contains(turnSort)) {
                        WorkflowUtils.updateStatus(currentRole, "rolestatus", FlowRuRoleStatusEnum.RETURNED.getCode());
                        flowParamBo.getRuRoleColl().add((Object)currentRole);
                        continue;
                    }
                    sortSet.add(turnSort);
                    List<DynamicObject> sameSortRoles = ruRoles.stream().filter(role -> HRStringUtils.equals((String)setNo, (String)role.getString("setno"))).filter(role -> !flowParamBo.getRuRoleColl().contains(role)).filter(role -> role.getInt("turnoversort") == currentRole.getInt("turnoversort")).collect(Collectors.toList());
                    if (CollectionUtils.isNotEmpty(sameSortRoles)) {
                        WorkflowUtils.updateRoleStatus(sameSortRoles, FlowRuRoleStatusEnum.RETURNED.getCode());
                        flowParamBo.getRuRoleColl().addAll(sameSortRoles);
                    }
                    if (null != (lessThanCurrentRoleSortAndGetMax = (DynamicObject)ruRoles.stream().filter(role -> role.getInt("turnoversort") < currentRole.getInt("turnoversort")).max(Comparator.comparing(role -> role.getInt("turnoversort"))).orElse(null))) {
                        List<DynamicObject> needRollbackRole = ruRoles.stream().filter(role -> HRStringUtils.equals((String)role.getString("setno"), (String)lessThanCurrentRoleSortAndGetMax.getString("setno"))).filter(role -> lessThanCurrentRoleSortAndGetMax.getInt("turnoversort") == role.getInt("turnoversort")).collect(Collectors.toList());
                        if (needRollbackRole.isEmpty()) continue;
                        WorkflowUtils.updateRoleStatus(needRollbackRole, FlowRuRoleStatusEnum.RUNNING.getCode());
                        flowParamBo.getRuRoleColl().addAll(needRollbackRole);
                        Set rollbackRoleIds = needRollbackRole.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
                        flowParamBo.getBackRoleIds().addAll(rollbackRoleIds);
                        continue;
                    }
                    List<DynamicObject> needGetIndicatorTasks = crossNodeLeftTasks.stream().filter(task -> nodeId.longValue() == task.getDynamicObject("flowrunode").getLong("id")).collect(Collectors.toList());
                    Set<Long> taskIndicatorIds = this.getRollbackTaskIndicatorIds(needGetIndicatorTasks, nodeId);
                    int preNodeIndex = currentNode.getInt("index") - 1;
                    if (HRObjectUtils.isEmpty((Object)currentNode.getDynamicObject("flowruproc"))) continue;
                    long procId = currentNode.getDynamicObject("flowruproc").getLong("id");
                    List<DynamicObject> nodes = keyProcValNode.get(procId);
                    List preNodes = nodes.stream().filter(whichNode -> whichNode.getInt("index") == preNodeIndex).collect(Collectors.toList());
                    for (DynamicObject preNode : preNodes) {
                        if (HRObjectUtils.isEmpty((Object)currentNode.getDynamicObject("flowruproc"))) continue;
                        List<DynamicObject> preNodeRoles = keyNodeValRole.get(preNode.getLong("id"));
                        boolean isCrossPreNode = preNode.getBoolean("iscrossnode");
                        if (!isCrossPreNode) continue;
                        Map<String, List<DynamicObject>> preNodeKeySetNoValRole = preNodeRoles.stream().collect(Collectors.groupingBy(role -> role.getString("setno")));
                        ArrayList allLastRole = new ArrayList(10);
                        ArrayList<Long> needRollbackRoleIds = new ArrayList<Long>(10);
                        for (Map.Entry<String, List<DynamicObject>> preNodeEntry : preNodeKeySetNoValRole.entrySet()) {
                            List<DynamicObject> preNodeRolesGroupBySetNo = preNodeEntry.getValue();
                            DynamicObject maxSortRole = preNodeRolesGroupBySetNo.stream().max(Comparator.comparing(role -> role.getInt("turnoversort"))).orElse(null);
                            if (HRObjectUtils.isEmpty((Object)maxSortRole)) continue;
                            List needRollbackRole = preNodeRolesGroupBySetNo.stream().filter(role -> role.getInt("turnoversort") == maxSortRole.getInt("turnoversort")).collect(Collectors.toList());
                            allLastRole.addAll(needRollbackRole);
                        }
                        List<Long> allLastRoleIds = allLastRole.stream().map(role -> role.getLong("id")).collect(Collectors.toList());
                        List allLastRoleTasks = Arrays.stream(FLOW_RU_TASK_ENTITY_SERVICE.loadTasksByRoleIds(allLastRoleIds)).collect(Collectors.toList());
                        block5: for (DynamicObject task2 : allLastRoleTasks) {
                            DynamicObjectCollection indicatorColl = task2.getDynamicObjectCollection("entryentity");
                            Set indicIds = indicatorColl.stream().map(dym -> dym.getLong("indicatorid")).collect(Collectors.toSet());
                            for (Long indicId : indicIds) {
                                if (!taskIndicatorIds.contains(indicId)) continue;
                                needRollbackRoleIds.add(task2.getDynamicObject("flowrurole").getLong("id"));
                                continue block5;
                            }
                        }
                        List<DynamicObject> needRollbackRole = allLastRole.stream().filter(role -> !HRStringUtils.equals((String)FlowRuRoleStatusEnum.RETURNED.getCode(), (String)role.getString("rolestatus"))).filter(role -> needRollbackRoleIds.contains(role.getLong("id"))).collect(Collectors.toList());
                        WorkflowUtils.updateRoleStatus(needRollbackRole, FlowRuRoleStatusEnum.RUNNING.getCode());
                        flowParamBo.getRuRoleColl().addAll(needRollbackRole);
                        if (HRStringUtils.equals((String)preNode.getString("nodestatus"), (String)FlowRuNodeStatusEnum.RUNNING.getCode())) {
                            List<DynamicObject> setCurrentRoleEntry = preNodeRoles.stream().filter(role -> HRStringUtils.equals((String)role.getString("rolestatus"), (String)FlowRuNodeStatusEnum.RUNNING.getCode())).collect(Collectors.toList());
                            DynamicObject ruProc = flowParamBo.getKeyIdValProc().get(procId);
                            WorkflowUtils.setCurrentRunRole(ruProc, setCurrentRoleEntry);
                            flowParamBo.getRuProcColl().add((Object)ruProc);
                        }
                        Set rollbackRoleIds = needRollbackRole.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
                        flowParamBo.getBackRoleIds().addAll(rollbackRoleIds);
                    }
                }
            }
        }
        this.dealTaskStatus(flowParamBo);
    }

    private void sendPendingMessage(BatchFlowParamBo flowParamBo) {
        List pendingTaskProcIds = flowParamBo.getRuTaskColl().stream().filter(task -> HRStringUtils.equals((String)task.getString("taskstatus"), (String)FlowRuTaskStatusEnum.PENDING.getCode())).map(task -> task.getLong("flowruproc.id")).distinct().collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(pendingTaskProcIds)) {
            List pendingProcs = flowParamBo.getRuProcColl().stream().filter(proc -> pendingTaskProcIds.contains(proc.getLong("id"))).filter(proc -> HRStringUtils.equals((String)FlowRuProcStatusEnum.PENDING.getCode(), (String)proc.getString("procstatus"))).collect(Collectors.toList());
            for (DynamicObject pendingProc : pendingProcs) {
                FLOW_RUSUP_DOMAIN_SERVICE.sendPendingMsg(pendingProc);
            }
        }
    }

    private void findPendingTasks(BatchFlowParamBo flowParamBo) {
        FlowHandlerDomainService FLOW_HANDLER_DOMAIN_SERVICE = new FlowHandlerDomainService();
        List<DynamicObject> waitingTasks = flowParamBo.getRuTaskColl().stream().filter(task -> HRStringUtils.equals((String)task.getString("taskstatus"), (String)FlowRuTaskStatusEnum.WAITING.getCode())).collect(Collectors.toList());
        List<DynamicObject> pendingTasks = FLOW_HANDLER_DOMAIN_SERVICE.checkInvalidUsers(waitingTasks);
        if (CollectionUtils.isNotEmpty(pendingTasks)) {
            flowParamBo.getRuTaskColl().removeAll(pendingTasks);
            WorkflowUtils.updateTaskStatus(pendingTasks, FlowRuTaskStatusEnum.PENDING.getCode());
            flowParamBo.getRuTaskColl().addAll(pendingTasks);
            this.dealPendingProcAndNodeStatus(flowParamBo, pendingTasks);
            List roleIds = pendingTasks.stream().map(task -> task.getDynamicObject("flowrurole").getLong("id")).distinct().collect(Collectors.toList());
            List<DynamicObject> pendingRoles = flowParamBo.getRuRoleColl().stream().filter(role -> roleIds.contains(role.getLong("id"))).collect(Collectors.toList());
            flowParamBo.getRuRoleColl().removeAll(pendingRoles);
            WorkflowUtils.updateRoleStatus(pendingRoles, FlowRuRoleStatusEnum.PENDING.getCode());
            flowParamBo.getRuRoleColl().addAll(pendingRoles);
        } else {
            List<DynamicObject> pendingRoles = flowParamBo.getRuRoleColl().stream().filter(role -> HRStringUtils.equals((String)role.getString("rolestatus"), (String)FlowRuRoleStatusEnum.PENDING.getCode())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(pendingRoles)) {
                this.dealPendingProcAndNodeStatus(flowParamBo, pendingRoles);
            }
        }
    }

    private void dealPendingProcAndNodeStatus(BatchFlowParamBo flowParamBo, List<DynamicObject> pendingRoleOrTasks) {
        List procIds = pendingRoleOrTasks.stream().map(roleOrTask -> roleOrTask.getDynamicObject("flowruproc").getLong("id")).distinct().collect(Collectors.toList());
        List<DynamicObject> pendingProcs = flowParamBo.getRuProcColl().stream().filter(proc -> procIds.contains(proc.getLong("id"))).collect(Collectors.toList());
        flowParamBo.getRuProcColl().removeAll(pendingProcs);
        WorkflowUtils.updateProcStatus(pendingProcs, FlowRuProcStatusEnum.PENDING.getCode());
        flowParamBo.getRuProcColl().addAll(pendingProcs);
        List nodeIds = pendingRoleOrTasks.stream().map(roleOrTask -> roleOrTask.getDynamicObject("flowrunode").getLong("id")).distinct().collect(Collectors.toList());
        List<DynamicObject> pendingNodes = flowParamBo.getRuNodeColl().stream().filter(node -> nodeIds.contains(node.getLong("id"))).collect(Collectors.toList());
        flowParamBo.getRuNodeColl().removeAll(pendingNodes);
        WorkflowUtils.updateNodeStatus(pendingNodes, FlowRuNodeStatusEnum.PENDING.getCode());
        flowParamBo.getRuNodeColl().addAll(pendingNodes);
    }

    private Map<Long, String> buildValidateMap(List<DynamicObject> ruProcs, Map<Long, List<DynamicObject>> keyProcIdValCanNotRollbackTask, BatchFlowParamBo flowParamBo) {
        HashMap<Long, String> resultMap = new HashMap<Long, String>(16);
        List procActObjIds = ruProcs.stream().map(proc -> proc.getLong("actevalobj")).distinct().collect(Collectors.toList());
        DynamicObjectCollection validateCollect = new DynamicObjectCollection();
        validateCollect.addAll((Collection)flowParamBo.getValidateTargetTaskColl());
        validateCollect.addAll((Collection)flowParamBo.getValidateLastRoleTaskColl());
        validateCollect.addAll((Collection)flowParamBo.getValidateFirstTaskColl());
        List procIds = validateCollect.stream().map(task -> task.getDynamicObject("flowruproc").getLong("id")).distinct().collect(Collectors.toList());
        Map<Long, Long> keyEvalIdValProcId = flowParamBo.getAllRuProcs().stream().filter(proc -> procIds.contains(proc.getLong("id"))).collect(Collectors.toMap(proc -> proc.getLong("actevalobj"), val -> val.getLong("id")));
        ArrayList<Long> allActObjIds = new ArrayList<Long>(10);
        allActObjIds.addAll(procActObjIds);
        allActObjIds.addAll(keyEvalIdValProcId.keySet());
        if (!allActObjIds.isEmpty()) {
            DynamicObject[] actEvalObjArray = EPA_ACTEVAOBJ_SERVICE.getActevalobjArrayById(allActObjIds);
            Map<Long, DynamicObject> keyEvalIdValProc = ruProcs.stream().collect(Collectors.toMap(key -> key.getLong("actevalobj"), value -> value));
            Map<Long, List<DynamicObject>> keyProcIdValNotProcessedTask = flowParamBo.getValidateTargetTaskColl().stream().collect(Collectors.groupingBy(task -> task.getDynamicObject("flowruproc").getLong("id")));
            Map<Long, List<DynamicObject>> keyProcIdValNotProcessingTask = flowParamBo.getValidateLastRoleTaskColl().stream().collect(Collectors.groupingBy(task -> task.getDynamicObject("flowruproc").getLong("id")));
            Map<Long, List<DynamicObject>> keyProcIdValFirstTask = flowParamBo.getValidateFirstTaskColl().stream().collect(Collectors.groupingBy(task -> task.getDynamicObject("flowruproc").getLong("id")));
            for (DynamicObject evaluationObj : actEvalObjArray) {
                List<DynamicObject> list;
                List<DynamicObject> firstTasks;
                String message;
                String taskStatusText;
                Long procId;
                long actObjId = evaluationObj.getLong("id");
                DynamicObject person = evaluationObj.getDynamicObject("person");
                String name = person.getString("name");
                String number = person.getString("number");
                DynamicObject proc2 = keyEvalIdValProc.get(actObjId);
                if (!HRObjectUtils.isEmpty((Object)proc2)) {
                    String procStatus = proc2.getString("procstatus");
                    String procStatusText = FlowRuProcStatusEnum.getFlowRuProcStatusByCode(procStatus).getText();
                    String message2 = MessageFormat.format(ResManager.loadKDString((String)"\u8bc4\u4f30\u5bf9\u8c61{0}\uff08\u5de5\u53f7\uff1a{1}\uff09\uff1a\u5f53\u524d\u6d41\u7a0b\u72b6\u6001\u4e3a\u201c{2}\u201d\uff0c\u4e0d\u652f\u6301\u201c\u9000\u56de\u201d\u64cd\u4f5c\u3002", (String)"FlowRuSecondDomainService_29", (String)"opmc-pbs-business", (Object[])new Object[0]), name, number, procStatusText);
                    List<DynamicObject> list2 = keyProcIdValCanNotRollbackTask.get(proc2.getLong("id"));
                    for (DynamicObject task2 : list2) {
                        resultMap.putIfAbsent(task2.getLong("id"), message2);
                    }
                }
                if ((procId = keyEvalIdValProcId.get(actObjId)) == null || procId == 0L) continue;
                List<DynamicObject> notProcessedTasks = keyProcIdValNotProcessedTask.get(procId);
                if (CollectionUtils.isNotEmpty(notProcessedTasks)) {
                    for (DynamicObject dynamicObject : notProcessedTasks) {
                        DynamicObject handler = dynamicObject.getDynamicObject("handler");
                        String handlerName = handler.getString("name");
                        String handlerNumber = handler.getString("number");
                        taskStatusText = FlowRuntimeConstants.getFlowRuProcFinishedText();
                        message = MessageFormat.format(ResManager.loadKDString((String)"\u8bc4\u4f30\u5bf9\u8c61{0}\uff08\u5de5\u53f7\uff1a{1}\uff09\uff1a\u8bc4\u4f30\u4eba{2}\uff08\u5de5\u53f7\uff1a{3}\uff09\u72b6\u6001\u4e0d\u662f\u201c{4}\u201d\uff0c\u4e0d\u652f\u6301\u9000\u56de\u3002", (String)"FlowRuSecondDomainService_30", (String)"opmc-pbs-business", (Object[])new Object[0]), name, number, handlerName, handlerNumber, taskStatusText);
                        resultMap.putIfAbsent(dynamicObject.getLong("id"), message);
                    }
                }
                if (CollectionUtils.isNotEmpty(firstTasks = keyProcIdValFirstTask.get(procId))) {
                    for (DynamicObject firstTask : firstTasks) {
                        String message3 = ResManager.loadKDString((String)"\u7ee9\u6548\u8bc4\u4f30/\u6307\u6807\u5236\u5b9a\u6d41\u7a0b\u7684\u9996\u4f4d\u4efb\u52a1\u5904\u7406\u4eba\uff0c\u4e0d\u652f\u6301\u9000\u56de\u3002", (String)"FlowRuSecondDomainService_31", (String)"opmc-pbs-business", (Object[])new Object[0]);
                        resultMap.putIfAbsent(firstTask.getLong("id"), message3);
                    }
                }
                if (!CollectionUtils.isNotEmpty(list = keyProcIdValNotProcessingTask.get(procId))) continue;
                for (DynamicObject notProcessingTask : list) {
                    String taskStatus = notProcessingTask.getString("taskstatus");
                    taskStatusText = FlowRuTaskStatusEnum.getFlowRuTaskStatusByCode(taskStatus).getText();
                    message = MessageFormat.format(ResManager.loadKDString((String)"\u8bc4\u4f30\u5bf9\u8c61{0}\uff08\u5de5\u53f7\uff1a{1}\uff09\uff1a\u5f53\u524d\u5904\u7406\u72b6\u6001\u4e3a\u201c{2}\u201d\uff0c\u4e0d\u652f\u6301\u201c\u9000\u56de\u201d\u64cd\u4f5c\u3002", (String)"FlowRuSecondDomainService_32", (String)"opmc-pbs-business", (Object[])new Object[0]), name, number, taskStatusText);
                    resultMap.putIfAbsent(notProcessingTask.getLong("id"), message);
                }
            }
        }
        return resultMap;
    }

    private String updateRollbackTasksStatus(BatchFlowParamBo flowParamBo) {
        try {
            if (!flowParamBo.getRuProcColl().isEmpty()) {
                WorkflowUtils.mergeCurrentRunRole(flowParamBo);
                FLOW_RU_PROC_ENTITY_SERVICE.save(flowParamBo.getRuProcColl());
            }
            if (!flowParamBo.getRuNodeColl().isEmpty()) {
                FLOW_RU_NODE_ENTITY_SERVICE.save(flowParamBo.getRuNodeColl());
            }
            if (!flowParamBo.getRuRoleColl().isEmpty()) {
                FLOW_RU_ROLE_ENTITY_SERVICE.save(flowParamBo.getRuRoleColl());
            }
            if (!flowParamBo.getRuTaskColl().isEmpty()) {
                flowParamBo.getRuTaskColl().stream().filter(task -> HRStringUtils.equals((String)FlowRuTaskStatusEnum.WAITING.getCode(), (String)task.getString("taskstatus")) || HRStringUtils.equals((String)FlowRuTaskStatusEnum.PENDING.getCode(), (String)task.getString("taskstatus"))).collect(Collectors.toList()).forEach(backTask -> backTask.set("isrollbacked", (Object)1));
                FLOW_RU_TASK_ENTITY_SERVICE.save(flowParamBo.getRuTaskColl());
            }
            if (!flowParamBo.getOpRecordColl().isEmpty()) {
                FLOW_RU_OP_ENTITY_SERVICE.save(flowParamBo.getOpRecordColl());
            }
        }
        catch (Exception exc) {
            LOG.error("rollbackTasks-updateRollbackTasksStatus fail:", (Throwable)exc);
            return ResManager.loadKDString((String)"\u4efb\u52a1\u9000\u56de\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"FlowRuSecondDomainService_33", (String)"opmc-pbs-business", (Object[])new Object[0]);
        }
        return null;
    }

    private void sendMessageMerge(BatchFlowParamBo flowParamBo, String rollbackType) {
        if (CollectionUtils.isNotEmpty(flowParamBo.getAllRuProcs())) {
            ArrayList<SendMessageDTO> rollbackMsgs = new ArrayList<SendMessageDTO>(10);
            Map<Long, List<DynamicObject>> keyProcIdValTask = flowParamBo.getRuTaskColl().stream().filter(task -> HRStringUtils.equals((String)task.getString("taskstatus"), (String)FlowRuTaskStatusEnum.WAITING.getCode())).collect(Collectors.groupingBy(task -> task.getDynamicObject("flowruproc").getLong("id")));
            Map<String, List<DynamicObject>> keyTypeValProc = flowParamBo.getAllRuProcs().stream().filter(proc -> keyProcIdValTask.containsKey(proc.getLong("id"))).collect(Collectors.groupingBy(proc -> proc.getString("workflowtype")));
            Map<Long, String> taskAndReason = flowParamBo.getTaskAndReason();
            LOG.info("message send task size\uff1a" + keyProcIdValTask.size());
            for (Map.Entry<String, List<DynamicObject>> entry : keyTypeValProc.entrySet()) {
                String flowType = entry.getKey();
                ArrayList tasks = new ArrayList(10);
                List<DynamicObject> procs = entry.getValue();
                procs.forEach(proc -> tasks.addAll((Collection)keyProcIdValTask.get(proc.getLong("id"))));
                FlowMsgMergeEnumBO flowMsgMergeEnumBO = new FlowMsgMergeEnumBO();
                if (HRStringUtils.equals((String)"1", (String)flowType)) {
                    flowMsgMergeEnumBO.setSingle(FlowRuMsgMergeEnum.RETURN_FORMULATE_SIN);
                    flowMsgMergeEnumBO.setMultiple(FlowRuMsgMergeEnum.RETURN_FORMULATE_MUL);
                } else if (HRStringUtils.equals((String)"2", (String)flowType)) {
                    flowMsgMergeEnumBO.setSingle(FlowRuMsgMergeEnum.RETURN_EVALUATE_SIN);
                    flowMsgMergeEnumBO.setMultiple(FlowRuMsgMergeEnum.RETURN_EVALUATE_MUL);
                } else if (HRStringUtils.equals((String)"3", (String)flowType)) {
                    flowMsgMergeEnumBO.setSingle(FlowRuMsgMergeEnum.RETURN_INTERVIEW_SIN);
                    flowMsgMergeEnumBO.setMultiple(FlowRuMsgMergeEnum.RETURN_INTERVIEW_MUL);
                }
                if (HRStringUtils.equals((String)"0", (String)rollbackType)) {
                    List<Long> taskIds = tasks.stream().map(task -> task.getLong("id")).distinct().collect(Collectors.toList());
                    SendMessageDTO sendMessageDTO = new SendMessageDTO(taskIds, flowMsgMergeEnumBO);
                    sendMessageDTO.setCotaskSendMsg(Boolean.TRUE);
                    sendMessageDTO.setReason(flowParamBo.getReason());
                    rollbackMsgs.add(sendMessageDTO);
                    continue;
                }
                if (HRStringUtils.equals((String)"1", (String)rollbackType)) {
                    Map<Long, List<DynamicObject>> keyNodeValTask = tasks.stream().collect(Collectors.groupingBy(task -> task.getDynamicObject("flowrunode").getLong("id")));
                    for (Map.Entry<Long, List<DynamicObject>> taskEntry : keyNodeValTask.entrySet()) {
                        Long nodeId = taskEntry.getKey();
                        List<DynamicObject> nodeTasks = taskEntry.getValue();
                        List<Long> nodeTaskIds = nodeTasks.stream().map(task -> task.getLong("id")).distinct().collect(Collectors.toList());
                        SendMessageDTO sendMessageDTO = new SendMessageDTO(nodeTaskIds, flowMsgMergeEnumBO);
                        sendMessageDTO.setCotaskSendMsg(Boolean.TRUE);
                        sendMessageDTO.setReason(taskAndReason.get(nodeId));
                        rollbackMsgs.add(sendMessageDTO);
                    }
                    continue;
                }
                if (!HRStringUtils.equals((String)"2", (String)rollbackType)) continue;
                tasks.forEach(task -> {
                    SendMessageDTO sendMessageDTO = new SendMessageDTO(Collections.singletonList(task.getLong("id")), flowMsgMergeEnumBO);
                    sendMessageDTO.setCotaskSendMsg(Boolean.TRUE);
                    sendMessageDTO.setReason((String)taskAndReason.get(task.getLong("id")));
                    rollbackMsgs.add(sendMessageDTO);
                });
            }
            if (!rollbackMsgs.isEmpty()) {
                FLOW_HANDLER_BATCH_DOMAIN_SERVICE.sendMessageMerge(rollbackMsgs);
            }
        }
    }

    private void integrateBos(BatchFlowParamBo flowParamBo, BatchFlowParamBo newParamBo) {
        flowParamBo.getRuProcColl().addAll((Collection)newParamBo.getRuProcColl());
        flowParamBo.getRuNodeColl().addAll((Collection)newParamBo.getRuNodeColl());
        flowParamBo.getRuRoleColl().addAll((Collection)newParamBo.getRuRoleColl());
        flowParamBo.getRuTaskColl().addAll((Collection)newParamBo.getRuTaskColl());
        flowParamBo.getOpRecordColl().addAll((Collection)newParamBo.getOpRecordColl());
        flowParamBo.getValidateTargetTaskColl().addAll((Collection)newParamBo.getValidateTargetTaskColl());
        flowParamBo.getValidateLastRoleTaskColl().addAll((Collection)newParamBo.getValidateLastRoleTaskColl());
        flowParamBo.getValidateFirstTaskColl().addAll((Collection)newParamBo.getValidateFirstTaskColl());
        flowParamBo.getTaskAndIndicatorMap().putAll(newParamBo.getTaskAndIndicatorMap());
        flowParamBo.getTaskAndReason().putAll(newParamBo.getTaskAndReason());
        flowParamBo.getAllRuProcs().addAll(newParamBo.getAllRuProcs());
    }

    private void rollbackToTargetTask(BatchFlowParamBo flowParamBo, List<DynamicObject> targetTasks, List<Long> ruProcIds, List<Long> targetNodeIds) {
        Map<Long, DynamicObject> keyIdValProc = flowParamBo.getKeyIdValProc();
        ArrayList<DynamicObject> ruProcs = new ArrayList<DynamicObject>(keyIdValProc.values());
        List currentNodeIds = ruProcs.stream().filter(proc -> ruProcIds.contains(proc.getLong("id"))).filter(proc -> !HRObjectUtils.isEmpty((Object)proc.getDynamicObject("currentnode"))).map(proc -> proc.getDynamicObject("currentnode").getLong("id")).collect(Collectors.toList());
        List allNodes = Arrays.stream(FLOW_RU_NODE_ENTITY_SERVICE.loadRuNodeByProcIdsAndIndexs(ruProcIds, new ArrayList<Integer>())).collect(Collectors.toList());
        Map<Long, List<DynamicObject>> keyProcValCurrentAndTargetNode = allNodes.stream().filter(node -> currentNodeIds.contains(node.getLong("id")) || targetNodeIds.contains(node.getLong("id"))).sorted(Comparator.comparing(node -> node.getInt("index"))).collect(Collectors.groupingBy(node -> node.getDynamicObject("flowruproc").getLong("id")));
        Map<Long, List<DynamicObject>> keyProcValNode = allNodes.stream().collect(Collectors.groupingBy(node -> node.getDynamicObject("flowruproc").getLong("id")));
        ArrayList<Long> needToRollBackNodeIds = new ArrayList<Long>();
        for (Long ruProcId : ruProcIds) {
            DynamicObject ruProc2 = keyIdValProc.get(ruProcId);
            List<DynamicObject> ruNodes = keyProcValNode.get(ruProcId);
            List<DynamicObject> currentAndTargetNode = keyProcValCurrentAndTargetNode.get(ruProcId);
            if (currentAndTargetNode.size() > 1) {
                DynamicObject targetNode = currentAndTargetNode.get(0);
                DynamicObject currentNode = currentAndTargetNode.get(1);
                ruProc2.set("currentnode", (Object)targetNode.getLong("id"));
                WorkflowUtils.updateStatus(targetNode, "nodestatus", FlowRuNodeStatusEnum.RUNNING.getCode());
                flowParamBo.getRuNodeColl().add((Object)targetNode);
                List<DynamicObject> exceptTargetNodes = ruNodes.stream().filter(node -> node.getInt("index") > targetNode.getInt("index") && node.getInt("index") <= currentNode.getInt("index")).collect(Collectors.toList());
                WorkflowUtils.updateNodeStatus(exceptTargetNodes, FlowRuNodeStatusEnum.RETURNED.getCode());
                flowParamBo.getRuNodeColl().addAll(exceptTargetNodes);
                List ruNodeIds = flowParamBo.getRuNodeColl().stream().map(node -> node.getLong("id")).collect(Collectors.toList());
                needToRollBackNodeIds.addAll(ruNodeIds);
            } else if (currentAndTargetNode.size() == 1) {
                DynamicObject node2 = currentAndTargetNode.get(0);
                WorkflowUtils.updateStatus(node2, "nodestatus", FlowRuNodeStatusEnum.RUNNING.getCode());
                flowParamBo.getRuNodeColl().add((Object)node2);
                needToRollBackNodeIds.add(node2.getLong("id"));
            }
            WorkflowUtils.updateStatus(ruProc2, "procstatus", FlowRuProcStatusEnum.RUNNING.getCode());
            flowParamBo.getRuProcColl().add((Object)ruProc2);
            DynamicObject opRecord = FLOW_RU_OP_ENTITY_SERVICE.generateOpRecord(ruProc2);
            opRecord.set("optype", (Object)FLowOpEnum.ROLLBACK.getValue());
            opRecord.set("description", (Object)flowParamBo.getReason());
            flowParamBo.getOpRecordColl().add((Object)opRecord);
        }
        List<DynamicObject> ruRoles = Arrays.stream(FLOW_RU_ROLE_ENTITY_SERVICE.loadRuRoleByNodeIds(needToRollBackNodeIds)).collect(Collectors.toList());
        Map<Long, List<DynamicObject>> keyNodeValRole = ruRoles.stream().collect(Collectors.groupingBy(role -> role.getDynamicObject("flowrunode").getLong("id")));
        List targetRoleIds = targetTasks.stream().map(task -> task.getDynamicObject("flowrurole").getLong("id")).collect(Collectors.toList());
        Map<Long, List<DynamicObject>> keyNodeValTargetRole = ruRoles.stream().filter(role -> targetRoleIds.contains(role.getLong("id"))).collect(Collectors.groupingBy(role -> role.getDynamicObject("flowrunode").getLong("id")));
        for (Long targetNodeId : targetNodeIds) {
            List<DynamicObject> targetNodeAllRoles = keyNodeValRole.get(targetNodeId);
            List<DynamicObject> targetRole = keyNodeValTargetRole.get(targetNodeId);
            for (DynamicObject role2 : targetRole) {
                if (HRStringUtils.equals((String)role2.getString("rolestatus"), (String)FlowRuRoleStatusEnum.RUNNING.getCode()) || HRStringUtils.equals((String)role2.getString("rolestatus"), (String)FlowRuRoleStatusEnum.PENDING.getCode())) continue;
                WorkflowUtils.updateStatus(role2, "rolestatus", FlowRuRoleStatusEnum.RUNNING.getCode());
            }
            flowParamBo.getRuRoleColl().addAll(targetRole);
            List ruProcList = flowParamBo.getRuProcColl().stream().filter(ruProc -> ruProc.getLong("id") == ((DynamicObject)targetRole.get(0)).getDynamicObject("flowruproc").getLong("id")).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(ruProcList)) {
                WorkflowUtils.setCurrentRunRole((DynamicObject)ruProcList.get(0), targetRole);
            }
            List noNeedToDealRoles = targetNodeAllRoles.stream().filter(role -> role.getInt("turnoversort") <= ((DynamicObject)targetRole.get(0)).getInt("turnoversort")).collect(Collectors.toList());
            ruRoles.removeAll(noNeedToDealRoles);
        }
        WorkflowUtils.updateRoleStatus(ruRoles, FlowRuRoleStatusEnum.RETURNED.getCode());
        flowParamBo.getRuRoleColl().addAll(ruRoles);
        List<Long> ruRoleIds = ruRoles.stream().map(role -> role.getLong("id")).collect(Collectors.toList());
        List<DynamicObject> needRollbackTasks = Arrays.stream(FLOW_RU_TASK_ENTITY_SERVICE.loadTasksByRoleIds(ruRoleIds)).collect(Collectors.toList());
        WorkflowUtils.updateTaskStatus(targetTasks, FlowRuTaskStatusEnum.WAITING.getCode());
        flowParamBo.getRuTaskColl().addAll(targetTasks);
        WorkflowUtils.updateTaskStatus(needRollbackTasks, FlowRuTaskStatusEnum.RETURNED.getCode());
        flowParamBo.getRuTaskColl().addAll(needRollbackTasks);
    }

    private void rollbackToLastNodeOrRole(BatchFlowParamBo flowParamBo, List<DynamicObject> canRollbackTasks, List<Long> ruProcIds, List<Long> ruNodeIds) {
        List<DynamicObject> currentNodes = Arrays.stream(FLOW_RU_NODE_ENTITY_SERVICE.loadRuNodeByIds(ruNodeIds)).collect(Collectors.toList());
        List nodeIndexs = currentNodes.stream().map(node -> node.getInt("index")).distinct().collect(Collectors.toList());
        List<Integer> preIndexs = nodeIndexs.stream().map(index -> index - 1).filter(index -> index > 0).distinct().collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(preIndexs)) {
            List preRuNodes = Arrays.stream(FLOW_RU_NODE_ENTITY_SERVICE.loadRuNodeByProcIdsAndIndexs(ruProcIds, preIndexs)).collect(Collectors.toList());
            currentNodes.addAll(preRuNodes);
        }
        Map<Long, List<DynamicObject>> keyProcValNode = currentNodes.stream().collect(Collectors.groupingBy(node -> node.getDynamicObject("flowruproc").getLong("id")));
        List<Long> allRuNodeIds = currentNodes.stream().map(node -> node.getLong("id")).distinct().collect(Collectors.toList());
        List<DynamicObject> ruRoles = Arrays.stream(FLOW_RU_ROLE_ENTITY_SERVICE.loadRuRoleByNodeIds(allRuNodeIds)).collect(Collectors.toList());
        Map<Long, List<DynamicObject>> keyNodeValRole = ruRoles.stream().collect(Collectors.groupingBy(role -> role.getDynamicObject("flowrunode").getLong("id")));
        List ruRoleIds = canRollbackTasks.stream().map(task -> task.getDynamicObject("flowrurole").getLong("id")).distinct().collect(Collectors.toList());
        List wantToRollbackRoles = ruRoles.stream().filter(role -> ruRoleIds.contains(role.getLong("id"))).collect(Collectors.toList());
        List runningRoles = wantToRollbackRoles.stream().filter(role -> HRStringUtils.equals((String)FlowRuRoleStatusEnum.RUNNING.getCode(), (String)role.getString("rolestatus"))).collect(Collectors.toList());
        List runningRoleIds = runningRoles.stream().map(role -> role.getLong("id")).distinct().collect(Collectors.toList());
        List rollbackToLastRoleIds = canRollbackTasks.stream().filter(task -> HRStringUtils.equals((String)task.getString("taskstatus"), (String)FlowRuTaskStatusEnum.PROCESSING.getCode()) || HRStringUtils.equals((String)task.getString("taskstatus"), (String)FlowRuTaskStatusEnum.WAITING.getCode())).filter(task -> runningRoleIds.contains(task.getDynamicObject("flowrurole").getLong("id"))).map(task -> task.getDynamicObject("flowrurole").getLong("id")).distinct().collect(Collectors.toList());
        List<DynamicObject> rollbackToLastRole = runningRoles.stream().filter(role -> rollbackToLastRoleIds.contains(role.getLong("id"))).collect(Collectors.toList());
        wantToRollbackRoles.removeAll(rollbackToLastRole);
        if (!wantToRollbackRoles.isEmpty()) {
            List targetRoleIds = wantToRollbackRoles.stream().map(role -> role.getLong("id")).distinct().collect(Collectors.toList());
            List targetRoleNodeIds = wantToRollbackRoles.stream().map(role -> role.getDynamicObject("flowrunode").getLong("id")).distinct().collect(Collectors.toList());
            List rollbackToTargetTasks = canRollbackTasks.stream().filter(task -> targetRoleIds.contains(task.getDynamicObject("flowrurole").getLong("id"))).collect(Collectors.toList());
            canRollbackTasks.removeAll(rollbackToTargetTasks);
            ruNodeIds.removeAll(targetRoleNodeIds);
            List<DynamicObject> backToTargetTasks = rollbackToTargetTasks.stream().filter(task -> HRStringUtils.equals((String)task.getString("taskstatus"), (String)FlowRuTaskStatusEnum.PROCESSED.getCode())).collect(Collectors.toList());
            rollbackToTargetTasks.removeAll(backToTargetTasks);
            flowParamBo.getValidateTargetTaskColl().addAll(rollbackToTargetTasks);
            if (!backToTargetTasks.isEmpty()) {
                List<Long> targetProcIds = backToTargetTasks.stream().map(task -> task.getDynamicObject("flowruproc").getLong("id")).distinct().collect(Collectors.toList());
                List<Long> targetNodeIds = backToTargetTasks.stream().map(task -> task.getDynamicObject("flowrunode").getLong("id")).distinct().collect(Collectors.toList());
                this.rollbackToTargetTask(flowParamBo, backToTargetTasks, targetProcIds, targetNodeIds);
            }
        }
        List<DynamicObject> rollbackToLastRoleTasks = canRollbackTasks.stream().filter(task -> HRStringUtils.equals((String)task.getString("taskstatus"), (String)FlowRuTaskStatusEnum.PROCESSING.getCode()) || HRStringUtils.equals((String)task.getString("taskstatus"), (String)FlowRuTaskStatusEnum.WAITING.getCode())).collect(Collectors.toList());
        canRollbackTasks.removeAll(rollbackToLastRoleTasks);
        flowParamBo.getValidateLastRoleTaskColl().addAll(canRollbackTasks);
        if (CollectionUtils.isNotEmpty(rollbackToLastRoleTasks)) {
            Set notProcessingTaskRoleIds = canRollbackTasks.stream().map(task -> task.getDynamicObject("flowrurole").getLong("id")).collect(Collectors.toSet());
            rollbackToLastRole = rollbackToLastRole.stream().filter(role -> !notProcessingTaskRoleIds.contains(role.getLong("id"))).collect(Collectors.toList());
            WorkflowUtils.updateRoleStatus(rollbackToLastRole, FlowRuRoleStatusEnum.RETURNED.getCode());
            flowParamBo.getRuRoleColl().addAll(rollbackToLastRole);
            Map<Boolean, List<DynamicObject>> sortRoles = rollbackToLastRole.stream().collect(Collectors.partitioningBy(role -> role.getInt("turnoversort") == 1));
            Map<Long, Integer> keyRoleValSort = rollbackToLastRole.stream().collect(Collectors.toMap(x -> x.getLong("id"), y -> y.getInt("turnoversort")));
            List needBackPreNodeIds = sortRoles.get(Boolean.TRUE).stream().map(role -> role.getDynamicObject("flowrunode").getLong("id")).collect(Collectors.toList());
            List<Long> currentNodeRoleIds = sortRoles.get(Boolean.FALSE).stream().map(role -> role.getLong("id")).collect(Collectors.toList());
            Map<Long, List<DynamicObject>> keyNodeValTask = rollbackToLastRoleTasks.stream().collect(Collectors.groupingBy(task -> task.getDynamicObject("flowrunode").getLong("id")));
            flowParamBo.setCurrentNodes(currentNodes);
            flowParamBo.setKeyProcValNode(keyProcValNode);
            flowParamBo.setKeyNodeValRole(keyNodeValRole);
            flowParamBo.setKeyNodeValTask(keyNodeValTask);
            ruNodeIds.removeAll(needBackPreNodeIds);
            for (Long nodeId : ruNodeIds) {
                List sameSortRoles;
                Optional<DynamicObject> nodeOptional = flowParamBo.getCurrentNodes().stream().filter(node -> node.getLong("id") == nodeId.longValue()).findFirst();
                if (!nodeOptional.isPresent()) continue;
                Set<Long> taskIndicatorIds = this.getRollbackTaskIndicatorIds(rollbackToLastRoleTasks, nodeId);
                DynamicObject currentNode = nodeOptional.get();
                List<DynamicObject> currentNodeRoles = keyNodeValRole.get(nodeId);
                boolean isCrossNode = currentNode.getBoolean("iscrossnode");
                if (isCrossNode) {
                    Map<String, List<DynamicObject>> keySetNoValRole = currentNodeRoles.stream().filter(role -> currentNodeRoleIds.contains(role.getLong("id"))).sorted(Comparator.comparing(role -> role.getInt("turnoversort"), Comparator.nullsLast(Comparator.reverseOrder()))).collect(Collectors.groupingBy(role -> role.getString("setno")));
                    for (Map.Entry<String, List<DynamicObject>> entry : keySetNoValRole.entrySet()) {
                        String setNo = entry.getKey();
                        List<DynamicObject> rolesGroupBySetNo = entry.getValue();
                        HashSet<Integer> sortSet = new HashSet<Integer>(16);
                        for (DynamicObject currentRole : rolesGroupBySetNo) {
                            int turnSort = currentRole.getInt("turnoversort");
                            if (sortSet.contains(turnSort)) {
                                WorkflowUtils.updateStatus(currentRole, "rolestatus", FlowRuRoleStatusEnum.RETURNED.getCode());
                                flowParamBo.getRuRoleColl().add((Object)currentRole);
                                continue;
                            }
                            sortSet.add(turnSort);
                            DynamicObject lessThanCurrentRoleSortAndGetMax = currentNodeRoles.stream().filter(role -> HRStringUtils.equals((String)setNo, (String)role.getString("setno"))).filter(role -> role.getInt("turnoversort") < currentRole.getInt("turnoversort")).max(Comparator.comparing(role -> role.getInt("turnoversort"))).orElse(null);
                            List<DynamicObject> sameSortRoles2 = currentNodeRoles.stream().filter(role -> HRStringUtils.equals((String)setNo, (String)role.getString("setno"))).filter(role -> !flowParamBo.getRuRoleColl().contains(role)).filter(role -> role.getInt("turnoversort") == currentRole.getInt("turnoversort")).collect(Collectors.toList());
                            if (CollectionUtils.isNotEmpty(sameSortRoles2)) {
                                WorkflowUtils.updateRoleStatus(sameSortRoles2, FlowRuRoleStatusEnum.RETURNED.getCode());
                                flowParamBo.getRuRoleColl().addAll(sameSortRoles2);
                            }
                            this.dealCurrentRoleRollback(flowParamBo, currentNodeRoleIds, currentNode, currentNodeRoles, lessThanCurrentRoleSortAndGetMax, taskIndicatorIds);
                        }
                    }
                    continue;
                }
                List curNodeRoleIds = currentNodeRoles.stream().map(role -> role.getLong("id")).filter(currentNodeRoleIds::contains).collect(Collectors.toList());
                DynamicObject lessThanCurrentRoleSortAndGetMax = curNodeRoleIds.size() == 0 ? null : (DynamicObject)currentNodeRoles.stream().filter(role -> role.getInt("turnoversort") < (Integer)keyRoleValSort.get(curNodeRoleIds.get(0))).max(Comparator.comparing(role -> role.getInt("turnoversort"))).orElse(null);
                List list = sameSortRoles = curNodeRoleIds.size() <= 0 ? null : currentNodeRoles.stream().filter(role -> !flowParamBo.getRuRoleColl().contains(role)).filter(role -> role.getInt("turnoversort") == ((Integer)keyRoleValSort.get(curNodeRoleIds.get(0))).intValue()).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(sameSortRoles)) {
                    WorkflowUtils.updateRoleStatus(sameSortRoles, FlowRuRoleStatusEnum.RETURNED.getCode());
                    flowParamBo.getRuRoleColl().addAll(sameSortRoles);
                }
                this.dealCurrentRoleRollback(flowParamBo, currentNodeRoleIds, currentNode, currentNodeRoles, lessThanCurrentRoleSortAndGetMax, taskIndicatorIds);
            }
            for (Long nodeId : needBackPreNodeIds) {
                Set<Long> taskIndicatorIds = this.getRollbackTaskIndicatorIds(rollbackToLastRoleTasks, nodeId);
                this.dealPreNode(flowParamBo, nodeId, taskIndicatorIds);
            }
            this.checkTaskIsFirst(flowParamBo, currentNodes, ruRoles, rollbackToLastRoleTasks);
            this.dealTaskStatus(flowParamBo);
        }
    }

    private Set<Long> getRollbackTaskIndicatorIds(List<DynamicObject> rollbackToLastRoleTasks, Long nodeId) {
        HashSet<Long> indicatorIdSet = new HashSet<Long>(16);
        List toLastRoleTasks = rollbackToLastRoleTasks.stream().filter(task -> nodeId.longValue() == task.getDynamicObject("flowrunode").getLong("id")).collect(Collectors.toList());
        for (DynamicObject task2 : toLastRoleTasks) {
            DynamicObjectCollection indicatorColl = task2.getDynamicObjectCollection("entryentity");
            Set indicIds = indicatorColl.stream().map(dym -> dym.getLong("indicatorid")).collect(Collectors.toSet());
            indicatorIdSet.addAll(indicIds);
        }
        return indicatorIdSet;
    }

    private Set<Long> getRollbackTaskIndicatorIds(List<DynamicObject> toLastRoleTasks) {
        HashSet<Long> indicatorIdSet = new HashSet<Long>(16);
        for (DynamicObject task : toLastRoleTasks) {
            DynamicObjectCollection indicatorColl = task.getDynamicObjectCollection("entryentity");
            Set indicIds = indicatorColl.stream().map(dym -> dym.getLong("indicatorid")).collect(Collectors.toSet());
            indicatorIdSet.addAll(indicIds);
        }
        return indicatorIdSet;
    }

    private void dealTaskStatus(BatchFlowParamBo flowParamBo) {
        List<Long> needRollbackRoleIds = flowParamBo.getRuRoleColl().stream().map(role -> role.getLong("id")).collect(Collectors.toList());
        List needRollbackTasks = Arrays.stream(FLOW_RU_TASK_ENTITY_SERVICE.loadTasksByRoleIds(needRollbackRoleIds)).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(needRollbackTasks)) {
            Map<Long, List<DynamicObject>> keyRoleValTask = needRollbackTasks.stream().collect(Collectors.groupingBy(role -> role.getDynamicObject("flowrurole").getLong("id")));
            List<DynamicObject> backTasks = flowParamBo.getBackRoleIds().stream().filter(id -> null != keyRoleValTask.get(id)).flatMap(id -> ((List)keyRoleValTask.get(id)).stream()).filter(task -> !HRStringUtils.equals((String)FlowRuTaskStatusEnum.EXPIRED.getCode(), (String)task.getString("taskstatus"))).collect(Collectors.toList());
            WorkflowUtils.updateTaskStatus(backTasks, FlowRuTaskStatusEnum.WAITING.getCode());
            flowParamBo.getRuTaskColl().addAll(backTasks);
            needRollbackTasks.removeAll(backTasks);
            List<DynamicObject> currentTasks = needRollbackTasks.stream().filter(task -> !HRStringUtils.equals((String)FlowRuTaskStatusEnum.EXPIRED.getCode(), (String)task.getString("taskstatus"))).collect(Collectors.toList());
            WorkflowUtils.updateTaskStatus(currentTasks, FlowRuTaskStatusEnum.RETURNED.getCode());
            flowParamBo.getRuTaskColl().addAll(currentTasks);
        }
    }

    private void dealCurrentRoleRollback(BatchFlowParamBo flowParamBo, List<Long> currentNodeRoleIds, DynamicObject currentNode, List<DynamicObject> currentNodeRoles, DynamicObject lessThanCurrentRoleSortAndGetMax, Set<Long> taskIndicatorIds) {
        if (HRObjectUtils.isEmpty((Object)lessThanCurrentRoleSortAndGetMax) && CollectionUtils.isNotEmpty(currentNodeRoleIds)) {
            this.dealPreNode(flowParamBo, currentNode.getLong("id"), taskIndicatorIds);
        } else if (!HRObjectUtils.isEmpty((Object)lessThanCurrentRoleSortAndGetMax)) {
            boolean isCrossNode = currentNode.getBoolean("iscrossnode");
            List<Object> needRollbackRole = currentNodeRoles.stream().filter(role -> lessThanCurrentRoleSortAndGetMax.getInt("turnoversort") == role.getInt("turnoversort")).collect(Collectors.toList());
            if (isCrossNode) {
                needRollbackRole = currentNodeRoles.stream().filter(role -> HRStringUtils.equals((String)role.getString("setno"), (String)lessThanCurrentRoleSortAndGetMax.getString("setno"))).filter(role -> lessThanCurrentRoleSortAndGetMax.getInt("turnoversort") == role.getInt("turnoversort")).collect(Collectors.toList());
            }
            if (needRollbackRole.isEmpty()) {
                this.dealPreNode(flowParamBo, currentNode.getLong("id"), taskIndicatorIds);
            } else {
                if (!HRObjectUtils.isEmpty((Object)currentNode)) {
                    WorkflowUtils.updateStatus(currentNode, "nodestatus", FlowRuNodeStatusEnum.RUNNING.getCode());
                    flowParamBo.getRuNodeColl().add((Object)currentNode);
                }
                WorkflowUtils.updateRoleStatus(needRollbackRole, FlowRuRoleStatusEnum.RUNNING.getCode());
                flowParamBo.getRuRoleColl().addAll(needRollbackRole);
                Set rollbackRoleIds = needRollbackRole.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
                flowParamBo.getBackRoleIds().addAll(rollbackRoleIds);
                if (!HRObjectUtils.isEmpty((Object)((DynamicObject)needRollbackRole.get(0)).getDynamicObject("flowruproc"))) {
                    DynamicObject currentRole = (DynamicObject)needRollbackRole.get(0);
                    DynamicObject ruProc = flowParamBo.getKeyIdValProc().get(currentRole.getDynamicObject("flowruproc").getLong("id"));
                    if (!HRStringUtils.equals((String)ruProc.getString("procstatus"), (String)FlowRuProcStatusEnum.RUNNING.getCode())) {
                        WorkflowUtils.updateStatus(ruProc, "procstatus", FlowRuProcStatusEnum.RUNNING.getCode());
                    }
                    List<DynamicObject> setCurrentRoleEntry = currentNodeRoles.stream().filter(role -> HRStringUtils.equals((String)role.getString("rolestatus"), (String)FlowRuNodeStatusEnum.RUNNING.getCode())).collect(Collectors.toList());
                    WorkflowUtils.setCurrentRunRole(ruProc, setCurrentRoleEntry);
                    flowParamBo.getRuProcColl().add((Object)ruProc);
                    DynamicObject opRecord = FLOW_RU_OP_ENTITY_SERVICE.generateOpRecord(ruProc);
                    opRecord.set("optype", (Object)FLowOpEnum.ROLLBACK.getValue());
                    opRecord.set("description", (Object)flowParamBo.getReason());
                    flowParamBo.getOpRecordColl().add((Object)opRecord);
                }
            }
        }
    }

    private void checkTaskIsFirst(BatchFlowParamBo flowParamBo, List<DynamicObject> currentNodes, List<DynamicObject> ruRoles, List<DynamicObject> rollbackToLastRoleTasks) {
        Map<Long, List<DynamicObject>> keyProcIdValNode = currentNodes.stream().collect(Collectors.groupingBy(node -> node.getDynamicObject("flowruproc").getLong("id")));
        Map<Long, List<DynamicObject>> keyNodeIdValRole = ruRoles.stream().collect(Collectors.groupingBy(role -> role.getDynamicObject("flowrunode").getLong("id")));
        for (DynamicObject task : rollbackToLastRoleTasks) {
            List minRole;
            List<DynamicObject> firstNodeRoles;
            DynamicObject minRoleSort;
            long procId = task.getDynamicObject("flowruproc").getLong("id");
            long nodeId = task.getDynamicObject("flowrunode").getLong("id");
            long roleId = task.getDynamicObject("flowrurole").getLong("id");
            List<DynamicObject> nodes = keyProcIdValNode.get(procId);
            List firstNode = nodes.stream().filter(node -> nodeId == node.getLong("id") && 1 == node.getInt("index")).collect(Collectors.toList());
            if (!CollectionUtils.isNotEmpty(firstNode) || HRObjectUtils.isEmpty((Object)(minRoleSort = (DynamicObject)(firstNodeRoles = keyNodeIdValRole.get(nodeId)).stream().min(Comparator.comparing(role -> role.getInt("turnoversort"))).orElse(null))) || !CollectionUtils.isNotEmpty(minRole = firstNodeRoles.stream().filter(role -> role.getLong("id") == roleId && role.getInt("turnoversort") == minRoleSort.getInt("turnoversort")).collect(Collectors.toList()))) continue;
            flowParamBo.getRuNodeColl().removeAll(firstNode);
            flowParamBo.getRuRoleColl().removeAll(minRole);
            flowParamBo.getBackRoleIds().remove(roleId);
            List opRecord = flowParamBo.getOpRecordColl().stream().filter(op -> op.getLong("flowruproc") == procId).collect(Collectors.toList());
            flowParamBo.getOpRecordColl().removeAll(opRecord);
            flowParamBo.getValidateFirstTaskColl().add((Object)task);
        }
    }

    private void dealPreNode(BatchFlowParamBo flowParamBo, Long nodeId, Set<Long> taskIndicatorIds) {
        Optional<DynamicObject> nodeOptional = flowParamBo.getCurrentNodes().stream().filter(node -> node.getLong("id") == nodeId.longValue()).findFirst();
        if (nodeOptional.isPresent()) {
            List<DynamicObject> currentNodeRoles;
            DynamicObject currentNode = nodeOptional.get();
            boolean isCrossNode = currentNode.getBoolean("iscrossnode");
            boolean needToUpdateCurrentRole = true;
            if (!HRStringUtils.equals((String)currentNode.getString("nodestatus"), (String)FlowRuNodeStatusEnum.RETURNED.getCode())) {
                WorkflowUtils.updateStatus(currentNode, "nodestatus", FlowRuNodeStatusEnum.RETURNED.getCode());
                flowParamBo.getRuNodeColl().add((Object)currentNode);
            } else {
                needToUpdateCurrentRole = false;
            }
            if (isCrossNode) {
                currentNodeRoles = flowParamBo.getKeyNodeValRole().get(nodeId);
                List<DynamicObject> currentNodeTasks = flowParamBo.getKeyNodeValTask().get(nodeId);
                List currentNodeRoleIds = currentNodeTasks.stream().map(task -> task.getLong("flowrurole.id")).distinct().collect(Collectors.toList());
                Map<String, List<DynamicObject>> keySetNoValRole = currentNodeRoles.stream().filter(role -> currentNodeRoleIds.contains(role.getLong("id"))).sorted(Comparator.comparing(role -> role.getInt("turnoversort"), Comparator.nullsLast(Comparator.reverseOrder()))).collect(Collectors.groupingBy(role -> role.getString("setno")));
                for (Map.Entry<String, List<DynamicObject>> entry : keySetNoValRole.entrySet()) {
                    String setNo = entry.getKey();
                    List<DynamicObject> rolesGroupBySetNo = entry.getValue();
                    HashSet<Integer> sortSet = new HashSet<Integer>(16);
                    for (DynamicObject currentRole : rolesGroupBySetNo) {
                        int turnSort = currentRole.getInt("turnoversort");
                        if (sortSet.contains(turnSort)) {
                            WorkflowUtils.updateStatus(currentRole, "rolestatus", FlowRuRoleStatusEnum.RETURNED.getCode());
                            flowParamBo.getRuRoleColl().add((Object)currentRole);
                            continue;
                        }
                        sortSet.add(turnSort);
                        List<DynamicObject> sameSortRoles = currentNodeRoles.stream().filter(role -> HRStringUtils.equals((String)setNo, (String)role.getString("setno"))).filter(role -> !flowParamBo.getRuRoleColl().contains(role)).filter(role -> role.getInt("turnoversort") == currentRole.getInt("turnoversort")).collect(Collectors.toList());
                        if (!CollectionUtils.isNotEmpty(sameSortRoles)) continue;
                        WorkflowUtils.updateRoleStatus(sameSortRoles, FlowRuRoleStatusEnum.RETURNED.getCode());
                        flowParamBo.getRuRoleColl().addAll(sameSortRoles);
                    }
                }
            } else {
                currentNodeRoles = flowParamBo.getKeyNodeValRole().get(nodeId);
                List<DynamicObject> currentRoles = currentNodeRoles.stream().filter(role -> !flowParamBo.getRuRoleColl().contains(role)).filter(role -> !HRStringUtils.equals((String)role.getString("rolestatus"), (String)FlowRuRoleStatusEnum.RETURNED.getCode())).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(currentRoles)) {
                    WorkflowUtils.updateRoleStatus(currentRoles, FlowRuRoleStatusEnum.RETURNED.getCode());
                    flowParamBo.getRuRoleColl().addAll(currentRoles);
                }
            }
            int preNodeIndex = currentNode.getInt("index") - 1;
            if (!HRObjectUtils.isEmpty((Object)currentNode.getDynamicObject("flowruproc"))) {
                long procId = currentNode.getDynamicObject("flowruproc").getLong("id");
                List<DynamicObject> nodes = flowParamBo.getKeyProcValNode().get(procId);
                List preNodes = nodes.stream().filter(whichNode -> whichNode.getInt("index") == preNodeIndex).collect(Collectors.toList());
                for (DynamicObject preNode : preNodes) {
                    ArrayList<DynamicObject> curRoles;
                    if (HRObjectUtils.isEmpty((Object)currentNode.getDynamicObject("flowruproc"))) continue;
                    DynamicObject ruProc = flowParamBo.getKeyIdValProc().get(preNode.getDynamicObject("flowruproc").getLong("id"));
                    ruProc.set("currentnode", (Object)preNode.getLong("id"));
                    WorkflowUtils.updateStatus(ruProc, "procstatus", FlowRuProcStatusEnum.RUNNING.getCode());
                    DynamicObject opRecord = FLOW_RU_OP_ENTITY_SERVICE.generateOpRecord(ruProc);
                    opRecord.set("optype", (Object)FLowOpEnum.ROLLBACK.getValue());
                    opRecord.set("description", (Object)flowParamBo.getReason());
                    flowParamBo.getRuProcColl().add((Object)ruProc);
                    flowParamBo.getOpRecordColl().add((Object)opRecord);
                    WorkflowUtils.updateStatus(preNode, "nodestatus", FlowRuNodeStatusEnum.RUNNING.getCode());
                    flowParamBo.getRuNodeColl().add((Object)preNode);
                    List<DynamicObject> roles = flowParamBo.getKeyNodeValRole().get(preNode.getLong("id"));
                    boolean isCrossPreNode = preNode.getBoolean("iscrossnode");
                    if (isCrossNode && isCrossPreNode) {
                        Map<String, List<DynamicObject>> keySetNoValRole = roles.stream().collect(Collectors.groupingBy(role -> role.getString("setno")));
                        ArrayList allLastRole = new ArrayList(10);
                        ArrayList needRollbackRoleIds = new ArrayList(10);
                        for (Map.Entry<String, List<DynamicObject>> entry : keySetNoValRole.entrySet()) {
                            List<DynamicObject> rolesGroupBySetNo = entry.getValue();
                            DynamicObject maxSortRole = rolesGroupBySetNo.stream().max(Comparator.comparing(role -> role.getInt("turnoversort"))).orElse(null);
                            if (HRObjectUtils.isEmpty((Object)maxSortRole)) continue;
                            List needRollbackRole = rolesGroupBySetNo.stream().filter(role -> role.getInt("turnoversort") == maxSortRole.getInt("turnoversort")).collect(Collectors.toList());
                            allLastRole.addAll(needRollbackRole);
                        }
                        List<Long> list = allLastRole.stream().map(role -> role.getLong("id")).collect(Collectors.toList());
                        List allLastRoleTasks = Arrays.stream(FLOW_RU_TASK_ENTITY_SERVICE.loadTasksByRoleIds(list)).collect(Collectors.toList());
                        block4: for (DynamicObject task2 : allLastRoleTasks) {
                            DynamicObjectCollection indicatorColl = task2.getDynamicObjectCollection("entryentity");
                            Set indicIds = indicatorColl.stream().map(dym -> dym.getLong("indicatorid")).collect(Collectors.toSet());
                            for (Long indicId : indicIds) {
                                if (!taskIndicatorIds.contains(indicId)) continue;
                                needRollbackRoleIds.add(task2.getDynamicObject("flowrurole").getLong("id"));
                                continue block4;
                            }
                        }
                        List<DynamicObject> needRollbackRole = allLastRole.stream().filter(role -> needRollbackRoleIds.contains(role.getLong("id"))).collect(Collectors.toList());
                        WorkflowUtils.updateRoleStatus(needRollbackRole, FlowRuRoleStatusEnum.RUNNING.getCode());
                        flowParamBo.getRuRoleColl().addAll(needRollbackRole);
                        if (needToUpdateCurrentRole) {
                            WorkflowUtils.setCurrentRunRole(ruProc, needRollbackRole);
                        }
                        Set rollbackRoleIds = needRollbackRole.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
                        flowParamBo.getBackRoleIds().addAll(rollbackRoleIds);
                        continue;
                    }
                    if (isCrossPreNode) {
                        curRoles = new ArrayList<DynamicObject>(10);
                        Map<String, List<DynamicObject>> keySetNoValRole = roles.stream().collect(Collectors.groupingBy(role -> role.getString("setno")));
                        for (Map.Entry entry : keySetNoValRole.entrySet()) {
                            List rolesGroupBySetNo = (List)entry.getValue();
                            this.dealMaxSortRolesStatus(flowParamBo, rolesGroupBySetNo, curRoles);
                        }
                        WorkflowUtils.setCurrentRunRole(ruProc, curRoles);
                        Set rollbackRoleIds = curRoles.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
                        flowParamBo.getBackRoleIds().addAll(rollbackRoleIds);
                        continue;
                    }
                    curRoles = new ArrayList(10);
                    this.dealMaxSortRolesStatus(flowParamBo, roles, curRoles);
                    WorkflowUtils.setCurrentRunRole(ruProc, curRoles);
                    Set rollbackRoleIds = curRoles.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
                    flowParamBo.getBackRoleIds().addAll(rollbackRoleIds);
                }
            }
        }
    }

    private void dealMaxSortRolesStatus(BatchFlowParamBo flowParamBo, List<DynamicObject> roles, List<DynamicObject> curRoles) {
        DynamicObject maxSortRole = roles.stream().max(Comparator.comparing(role -> role.getInt("turnoversort"))).orElse(null);
        if (!HRObjectUtils.isEmpty((Object)maxSortRole)) {
            List<DynamicObject> needRollbackRole = roles.stream().filter(role -> role.getInt("turnoversort") == maxSortRole.getInt("turnoversort")).collect(Collectors.toList());
            WorkflowUtils.updateRoleStatus(needRollbackRole, FlowRuRoleStatusEnum.RUNNING.getCode());
            flowParamBo.getRuRoleColl().addAll(needRollbackRole);
            curRoles.addAll(needRollbackRole);
        }
    }

    private void dealMinSortRolesStatus(DynamicObject ruProc, BatchFlowParamBo flowParamBo, List<DynamicObject> roles, List<DynamicObject> curRoles) {
        DynamicObject minSortRole;
        if (CollectionUtils.isNotEmpty(roles) && !HRObjectUtils.isEmpty((Object)(minSortRole = (DynamicObject)roles.stream().min(Comparator.comparing(role -> role.getInt("turnoversort"))).orElse(null)))) {
            List<DynamicObject> needRollbackRole = roles.stream().filter(role -> role.getInt("turnoversort") == minSortRole.getInt("turnoversort")).collect(Collectors.toList());
            WorkflowUtils.updateRoleStatus(needRollbackRole, FlowRuRoleStatusEnum.RUNNING.getCode());
            flowParamBo.getRuRoleColl().addAll(needRollbackRole);
            curRoles.addAll(needRollbackRole);
            roles.removeAll(needRollbackRole);
            WorkflowUtils.updateRoleStatus(roles, FlowRuRoleStatusEnum.RETURNED.getCode());
            flowParamBo.getRuRoleColl().addAll(roles);
        }
    }

    @Deprecated
    public FlowValidateResultBo rollbackToSpecifiedNode(Map<String, Object> rollbackMap) {
        BatchFlowParamBo flowParamBo = new BatchFlowParamBo();
        Long nodeDefId = (Long)rollbackMap.get("nodeDefId");
        Long activityId = (Long)rollbackMap.get("activityId");
        List actevalobjIds = (List)rollbackMap.get("actevalobj");
        String workflowType = (String)rollbackMap.get("workflowType");
        String reason = (String)rollbackMap.get("reason");
        if (CollectionUtils.isEmpty((Collection)actevalobjIds) || HRStringUtils.isEmpty((String)workflowType) || nodeDefId == null || nodeDefId == 0L || activityId == null || activityId == 0L) {
            return this.getFlowValidateResultBo(ResManager.loadKDString((String)"\u9000\u56de\u5230\u6307\u5b9a\u8282\u70b9\u7f3a\u5c11\u5fc5\u586b\u53c2\u6570\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u786e\u8ba4\u3002", (String)"FlowRuSecondDomainService_20", (String)"opmc-pbs-business", (Object[])new Object[0]), "FlowRuSecondDomainService_20");
        }
        flowParamBo.setReason(WorkflowUtils.getReason(reason));
        LOG.info("rollbackToSpecifiedNode load loadRuProcByActEvalObjIds :" + rollbackMap.size());
        DynamicObject[] ruProcs = FLOW_RU_PROC_ENTITY_SERVICE.loadRuProcByActEvalObjIds(activityId, actevalobjIds, workflowType);
        List<Long> ruProcIds = Arrays.stream(ruProcs).map(proc -> proc.getLong("id")).collect(Collectors.toList());
        LOG.info("rollbackToSpecifiedNode load loadRuNodeByProcIds :" + ruProcIds.size());
        DynamicObject[] ruNodes = FLOW_RU_NODE_ENTITY_SERVICE.loadRuNodeByProcIds(ruProcIds);
        List<DynamicObject> currentNodes = Arrays.stream(ruNodes).filter(node -> nodeDefId.equals(node.getDynamicObject("flownodedef").getLong("id"))).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(currentNodes)) {
            ArrayList<DynamicObject> newNodes = new ArrayList<DynamicObject>(10);
            DynamicObject currentNode = (DynamicObject)currentNodes.get(0);
            int nodeIndex = currentNode.getInt("index");
            List<DynamicObject> lastNodes = Arrays.stream(ruNodes).filter(node -> node.getInt("index") > nodeIndex).collect(Collectors.toList());
            newNodes.addAll(currentNodes);
            newNodes.addAll(lastNodes);
            Map<Long, List<DynamicObject>> keyProcValCurnodes = currentNodes.stream().collect(Collectors.groupingBy(node -> node.getLong("flowruproc.id")));
            List<Long> ruNodeIds = newNodes.stream().map(node -> node.getLong("id")).collect(Collectors.toList());
            LOG.info("rollbackToSpecifiedNode load loadRuRoleByNodeIds :" + ruNodeIds.size());
            DynamicObject[] ruRoles = FLOW_RU_ROLE_ENTITY_SERVICE.loadRuRoleByNodeIds(ruNodeIds);
            Map<Long, List<DynamicObject>> keyNodeValRoles = Arrays.stream(ruRoles).collect(Collectors.groupingBy(role -> role.getLong("flowrunode.id")));
            List<Long> ruRoleIds = Arrays.stream(ruRoles).map(role -> role.getLong("id")).collect(Collectors.toList());
            LOG.info("rollbackToSpecifiedNode load loadTasksByRoleIds :" + ruNodeIds.size());
            DynamicObject[] ruTasks = FLOW_RU_TASK_ENTITY_SERVICE.loadTasksByRoleIds(ruRoleIds);
            Map<Long, List<DynamicObject>> keyRoleValTasks = Arrays.stream(ruTasks).collect(Collectors.groupingBy(task -> task.getLong("flowrurole.id")));
            WorkflowUtils.updateProcStatus(ruProcs, FlowRuProcStatusEnum.RUNNING.getCode());
            flowParamBo.getRuProcColl().addAll(Arrays.asList(ruProcs));
            flowParamBo.setAllRuProcs(Arrays.asList(ruProcs));
            WorkflowUtils.updateNodeStatus(currentNodes, FlowRuNodeStatusEnum.RUNNING.getCode());
            flowParamBo.getRuNodeColl().addAll(currentNodes);
            WorkflowUtils.updateNodeStatus(lastNodes, FlowRuNodeStatusEnum.RETURNED.getCode());
            flowParamBo.getRuNodeColl().addAll(lastNodes);
            for (DynamicObject ruProc : ruProcs) {
                List<DynamicObject> roles;
                DynamicObject opRecord = FLOW_RU_OP_ENTITY_SERVICE.generateOpRecord(ruProc);
                opRecord.set("optype", (Object)FLowOpEnum.ROLLBACK.getValue());
                opRecord.set("description", (Object)reason);
                flowParamBo.getOpRecordColl().add((Object)opRecord);
                long procId = ruProc.getLong("id");
                List<DynamicObject> curNodes = keyProcValCurnodes.get(procId);
                for (DynamicObject curNode : curNodes) {
                    ruProc.set("currentnode", (Object)curNode);
                    long curNodeId = curNode.getLong("id");
                    roles = keyNodeValRoles.get(curNodeId);
                    ArrayList<DynamicObject> curRoles = new ArrayList<DynamicObject>(10);
                    boolean isCrossNode = curNode.getBoolean("iscrossnode");
                    if (isCrossNode) {
                        Iterator<DynamicObject> keySetNoValRole = roles.stream().collect(Collectors.groupingBy(role -> role.getString("setno")));
                        for (Map.Entry<String, List<DynamicObject>> entry : keySetNoValRole.entrySet()) {
                            List<DynamicObject> rolesGroupBySetNo = entry.getValue();
                            this.dealMinSortRolesStatus(ruProc, flowParamBo, rolesGroupBySetNo, curRoles);
                        }
                        WorkflowUtils.setCurrentRunRole(ruProc, curRoles);
                    } else {
                        this.dealMinSortRolesStatus(ruProc, flowParamBo, roles, curRoles);
                        WorkflowUtils.setCurrentRunRole(ruProc, curRoles);
                    }
                    for (DynamicObject curRole : curRoles) {
                        long curRoleId = curRole.getLong("id");
                        List<DynamicObject> curTasks = keyRoleValTasks.get(curRoleId);
                        WorkflowUtils.updateTaskStatus(curTasks, FlowRuTaskStatusEnum.WAITING.getCode());
                        flowParamBo.getRuTaskColl().addAll(curTasks);
                    }
                    roles.removeAll(curRoles);
                    for (DynamicObject role2 : roles) {
                        long roleId = role2.getLong("id");
                        List<DynamicObject> tasks = keyRoleValTasks.get(roleId);
                        WorkflowUtils.updateTaskStatus(tasks, FlowRuTaskStatusEnum.RETURNED.getCode());
                        flowParamBo.getRuTaskColl().addAll(tasks);
                    }
                }
                for (DynamicObject lastNode : lastNodes) {
                    long lastNodeId = lastNode.getLong("id");
                    roles = keyNodeValRoles.get(lastNodeId);
                    if (CollectionUtils.isEmpty(roles)) continue;
                    WorkflowUtils.updateRoleStatus(roles, FlowRuRoleStatusEnum.RETURNED.getCode());
                    flowParamBo.getRuRoleColl().addAll(roles);
                    for (DynamicObject role3 : roles) {
                        long roleId = role3.getLong("id");
                        List<DynamicObject> tasks = keyRoleValTasks.get(roleId);
                        WorkflowUtils.updateTaskStatus(tasks, FlowRuTaskStatusEnum.RETURNED.getCode());
                        flowParamBo.getRuTaskColl().addAll(tasks);
                    }
                }
            }
        }
        FlowValidateResultBo resultBo = new FlowValidateResultBo();
        HashMap<Long, String> resultMap = new HashMap<Long, String>(16);
        LOG.info("rollbackToSpecifiedNode findPendingTasks ");
        this.findPendingTasks(flowParamBo);
        LOG.info("rollbackToSpecifiedNode updateRollbackTasksStatus ");
        String updateResult = this.updateRollbackTasksStatus(flowParamBo);
        if (HRStringUtils.isNotEmpty((String)updateResult)) {
            HashMap<Long, String> errortMap = new HashMap<Long, String>(16);
            resultBo.setCode("-1");
            errortMap.put(1L, updateResult);
            resultBo.setValidateMap(errortMap);
            resultBo.setMessage(updateResult);
            return resultBo;
        }
        LOG.info("rollbackToSpecifiedNode sendMessageMerge ");
        this.sendMessageMerge(flowParamBo, "0");
        LOG.info("rollbackToSpecifiedNode sendPendingMessage ");
        this.sendPendingMessage(flowParamBo);
        LOG.info("rollbackToSpecifiedNode updateEvaluatorFlowIndicatorEditStatus ");
        this.updateEvaluatorFlowIndicatorEditStatus(flowParamBo);
        LOG.info("rollbackToSpecifiedNode updateEvaluatorFlowIndicatorEditStatus end");
        resultBo.setCode(resultMap.size() > 0 ? "-1" : "1");
        resultBo.setValidateMap(resultMap);
        return resultBo;
    }

    public FlowValidateResultBo rollbackToSpecifiedNode(List<RollbackParamBo> rollbackParamBos) {
        BatchFlowParamBo flowParamBo = new BatchFlowParamBo();
        Map<Long, String> keyProcValReason = this.getReasonMap(rollbackParamBos, "procId");
        Map<Long, String> taskAndReason = this.getReasonMap(rollbackParamBos, "nodeId");
        flowParamBo.setTaskAndReason(taskAndReason);
        List<Long> ruProcIds = rollbackParamBos.stream().map(RollbackParamBo::getRuProcId).collect(Collectors.toList());
        List ruNodeIds = rollbackParamBos.stream().map(RollbackParamBo::getRuNodeId).collect(Collectors.toList());
        List<DynamicObject> ruProcs = Arrays.stream(FLOW_RU_PROC_ENTITY_SERVICE.loadRuProcByIds(ruProcIds)).collect(Collectors.toList());
        DynamicObject[] ruNodes = FLOW_RU_NODE_ENTITY_SERVICE.loadRuNodeByProcIds(ruProcIds);
        List<DynamicObject> currentNodes = Arrays.stream(ruNodes).filter(node -> ruNodeIds.contains(node.getLong("id"))).collect(Collectors.toList());
        Map<Long, List<DynamicObject>> keyProcValNodes = Arrays.stream(ruNodes).collect(Collectors.groupingBy(node -> node.getLong("flowruproc.id")));
        ArrayList<DynamicObject> newNodes = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> lastNodes = new ArrayList<DynamicObject>(10);
        for (RollbackParamBo paramBo : rollbackParamBos) {
            List<DynamicObject> nodes = keyProcValNodes.get(paramBo.getRuProcId());
            Optional<DynamicObject> first = nodes.stream().filter(node -> paramBo.getRuNodeId().longValue() == node.getLong("id")).findFirst();
            if (!first.isPresent()) continue;
            DynamicObject currentNode = first.get();
            List nextNodes = nodes.stream().filter(node -> node.getInt("index") > currentNode.getInt("index")).collect(Collectors.toList());
            lastNodes.addAll(nextNodes);
        }
        Map<Long, DynamicObject> keyProcValCurrentNode = currentNodes.stream().collect(Collectors.toMap(nodeX -> nodeX.getLong("flowruproc.id"), nodeY -> nodeY));
        Map<Long, List<DynamicObject>> keyProcValLastNodes = lastNodes.stream().collect(Collectors.groupingBy(node -> node.getLong("flowruproc.id")));
        WorkflowUtils.updateProcStatus(ruProcs, FlowRuProcStatusEnum.RUNNING.getCode());
        flowParamBo.setAllRuProcs(ruProcs);
        WorkflowUtils.updateNodeStatus(currentNodes, FlowRuNodeStatusEnum.RUNNING.getCode());
        flowParamBo.getRuNodeColl().addAll(currentNodes);
        WorkflowUtils.updateNodeStatus(lastNodes, FlowRuNodeStatusEnum.RETURNED.getCode());
        flowParamBo.getRuNodeColl().addAll(lastNodes);
        newNodes.addAll(currentNodes);
        newNodes.addAll(lastNodes);
        List<Long> allNodeIds = newNodes.stream().map(node -> node.getLong("id")).collect(Collectors.toList());
        DynamicObject[] ruRoles = FLOW_RU_ROLE_ENTITY_SERVICE.loadRuRoleByNodeIds(allNodeIds);
        Map<Long, List<DynamicObject>> keyNodeValRoles = Arrays.stream(ruRoles).collect(Collectors.groupingBy(role -> role.getLong("flowrunode.id")));
        List<Long> ruRoleIds = Arrays.stream(ruRoles).map(role -> role.getLong("id")).collect(Collectors.toList());
        DynamicObject[] ruTasks = FLOW_RU_TASK_ENTITY_SERVICE.loadTasksByRoleIds(ruRoleIds);
        Map<Long, List<DynamicObject>> keyRoleValTasks = Arrays.stream(ruTasks).collect(Collectors.groupingBy(task -> task.getLong("flowrurole.id")));
        for (DynamicObject ruProc : ruProcs) {
            long procId = ruProc.getLong("id");
            DynamicObject opRecord = FLOW_RU_OP_ENTITY_SERVICE.generateOpRecord(ruProc);
            opRecord.set("optype", (Object)FLowOpEnum.ROLLBACK.getValue());
            opRecord.set("description", (Object)keyProcValReason.get(procId));
            flowParamBo.getOpRecordColl().add((Object)opRecord);
            DynamicObject curNode = keyProcValCurrentNode.get(procId);
            ruProc.set("currentnode", (Object)curNode);
            long curNodeId = curNode.getLong("id");
            List<DynamicObject> roles = keyNodeValRoles.get(curNodeId);
            ArrayList<DynamicObject> curRoles = new ArrayList<DynamicObject>(10);
            boolean isCrossNode = curNode.getBoolean("iscrossnode");
            if (isCrossNode) {
                Iterator<DynamicObject> keySetNoValRole = roles.stream().collect(Collectors.groupingBy(role -> role.getString("setno")));
                for (Map.Entry<String, List<DynamicObject>> entry : keySetNoValRole.entrySet()) {
                    List<DynamicObject> rolesGroupBySetNo = entry.getValue();
                    this.dealMinSortRolesStatus(ruProc, flowParamBo, rolesGroupBySetNo, curRoles);
                }
                WorkflowUtils.setCurrentRunRole(ruProc, curRoles);
            } else {
                this.dealMinSortRolesStatus(ruProc, flowParamBo, roles, curRoles);
                WorkflowUtils.setCurrentRunRole(ruProc, curRoles);
            }
            for (DynamicObject curRole : curRoles) {
                long curRoleId = curRole.getLong("id");
                List<DynamicObject> curTasks = keyRoleValTasks.get(curRoleId);
                WorkflowUtils.updateTaskStatus(curTasks, FlowRuTaskStatusEnum.WAITING.getCode());
                flowParamBo.getRuTaskColl().addAll(curTasks);
            }
            roles.removeAll(curRoles);
            for (DynamicObject role2 : roles) {
                long roleId = role2.getLong("id");
                List<DynamicObject> tasks = keyRoleValTasks.get(roleId);
                WorkflowUtils.updateTaskStatus(tasks, FlowRuTaskStatusEnum.RETURNED.getCode());
                flowParamBo.getRuTaskColl().addAll(tasks);
            }
            List<DynamicObject> nextNodes = keyProcValLastNodes.get(procId);
            if (CollectionUtils.isNotEmpty(nextNodes)) {
                for (DynamicObject lastNode : nextNodes) {
                    long lastNodeId = lastNode.getLong("id");
                    List<DynamicObject> lastNodeRoles = keyNodeValRoles.get(lastNodeId);
                    if (CollectionUtils.isEmpty(lastNodeRoles)) continue;
                    WorkflowUtils.updateRoleStatus(lastNodeRoles, FlowRuRoleStatusEnum.RETURNED.getCode());
                    flowParamBo.getRuRoleColl().addAll(lastNodeRoles);
                    for (DynamicObject role3 : lastNodeRoles) {
                        long roleId = role3.getLong("id");
                        List<DynamicObject> tasks = keyRoleValTasks.get(roleId);
                        if (CollectionUtils.isEmpty(tasks)) continue;
                        WorkflowUtils.updateTaskStatus(tasks, FlowRuTaskStatusEnum.RETURNED.getCode());
                        flowParamBo.getRuTaskColl().addAll(tasks);
                    }
                }
            }
            flowParamBo.getRuProcColl().add((Object)ruProc);
        }
        FlowValidateResultBo resultBo = new FlowValidateResultBo();
        HashMap<Long, String> resultMap = new HashMap<Long, String>(16);
        this.findPendingTasks(flowParamBo);
        String updateResult = this.updateRollbackTasksStatus(flowParamBo);
        if (HRStringUtils.isNotEmpty((String)updateResult)) {
            HashMap<Long, String> errortMap = new HashMap<Long, String>(16);
            resultBo.setCode("-1");
            errortMap.put(1L, updateResult);
            resultBo.setValidateMap(errortMap);
            resultBo.setMessage(updateResult);
            return resultBo;
        }
        this.sendMessageMerge(flowParamBo, "1");
        this.sendPendingMessage(flowParamBo);
        this.updateEvaluatorFlowIndicatorEditStatus(flowParamBo);
        resultBo.setCode(resultMap.size() > 0 ? "-1" : "1");
        resultBo.setValidateMap(resultMap);
        return resultBo;
    }

    public FlowValidateResultBo rollbackToSpecifiedRole(Map<String, Object> rollbackMap) {
        BatchFlowParamBo flowParamBo = new BatchFlowParamBo();
        Long nodeDefId = (Long)rollbackMap.get("nodeDefId");
        Long activityId = (Long)rollbackMap.get("activityId");
        List actevalobjIds = (List)rollbackMap.get("actevalobj");
        String workflowType = (String)rollbackMap.get("workflowType");
        String reason = (String)rollbackMap.get("reason");
        flowParamBo.setReason(reason);
        DynamicObject[] ruProcs = FLOW_RU_PROC_ENTITY_SERVICE.loadRuProcByActEvalObjIds(activityId, actevalobjIds, workflowType);
        List<Long> ruProcIds = Arrays.stream(ruProcs).map(proc -> proc.getLong("id")).collect(Collectors.toList());
        DynamicObject[] ruNodes = FLOW_RU_NODE_ENTITY_SERVICE.loadRuNodeByProcIds(ruProcIds);
        List<DynamicObject> currentNodes = Arrays.stream(ruNodes).filter(node -> nodeDefId.equals(node.getDynamicObject("flownodedef").getLong("id"))).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(currentNodes)) {
            ArrayList<DynamicObject> newNodes = new ArrayList<DynamicObject>(10);
            DynamicObject currentNode = (DynamicObject)currentNodes.get(0);
            int nodeIndex = currentNode.getInt("index");
            List<DynamicObject> lastNodes = Arrays.stream(ruNodes).filter(node -> node.getInt("index") > nodeIndex).collect(Collectors.toList());
            newNodes.addAll(currentNodes);
            newNodes.addAll(lastNodes);
            Map<Long, List<DynamicObject>> keyProcValCurnodes = currentNodes.stream().collect(Collectors.groupingBy(node -> node.getLong("flowruproc.id")));
            List<Long> ruNodeIds = newNodes.stream().map(node -> node.getLong("id")).collect(Collectors.toList());
            DynamicObject[] ruRoles = FLOW_RU_ROLE_ENTITY_SERVICE.loadRuRoleByNodeIds(ruNodeIds);
            Map<Long, List<DynamicObject>> keyNodeValRoles = Arrays.stream(ruRoles).collect(Collectors.groupingBy(role -> role.getLong("flowrunode.id")));
            List<Long> ruRoleIds = Arrays.stream(ruRoles).map(role -> role.getLong("id")).collect(Collectors.toList());
            DynamicObject[] ruTasks = FLOW_RU_TASK_ENTITY_SERVICE.loadTasksByRoleIds(ruRoleIds);
            Map<Long, List<DynamicObject>> keyRoleValTasks = Arrays.stream(ruTasks).collect(Collectors.groupingBy(task -> task.getLong("flowrurole.id")));
            WorkflowUtils.updateProcStatus(ruProcs, FlowRuProcStatusEnum.RUNNING.getCode());
            flowParamBo.getRuProcColl().addAll(Arrays.asList(ruProcs));
            WorkflowUtils.updateNodeStatus(currentNodes, FlowRuNodeStatusEnum.RUNNING.getCode());
            flowParamBo.getRuNodeColl().addAll(currentNodes);
            WorkflowUtils.updateNodeStatus(lastNodes, FlowRuNodeStatusEnum.RETURNED.getCode());
            flowParamBo.getRuNodeColl().addAll(currentNodes);
            for (DynamicObject ruProc : ruProcs) {
                List<DynamicObject> roles;
                DynamicObject opRecord = FLOW_RU_OP_ENTITY_SERVICE.generateOpRecord(ruProc);
                opRecord.set("optype", (Object)FLowOpEnum.ROLLBACK.getValue());
                opRecord.set("description", (Object)reason);
                flowParamBo.getOpRecordColl().add((Object)opRecord);
                long procId = ruProc.getLong("id");
                List<DynamicObject> curNodes = keyProcValCurnodes.get(procId);
                for (DynamicObject curNode : curNodes) {
                    ruProc.set("currentnode", (Object)curNode);
                    long curNodeId = curNode.getLong("id");
                    roles = keyNodeValRoles.get(curNodeId);
                    ArrayList<DynamicObject> curRoles = new ArrayList<DynamicObject>(10);
                    boolean isCrossNode = curNode.getBoolean("iscrossnode");
                    if (isCrossNode) {
                        Iterator<DynamicObject> keySetNoValRole = roles.stream().collect(Collectors.groupingBy(role -> role.getString("setno")));
                        for (Map.Entry<String, List<DynamicObject>> entry : keySetNoValRole.entrySet()) {
                            List<DynamicObject> rolesGroupBySetNo = entry.getValue();
                            this.dealMinSortRolesStatus(ruProc, flowParamBo, rolesGroupBySetNo, curRoles);
                        }
                    } else {
                        this.dealMinSortRolesStatus(ruProc, flowParamBo, roles, curRoles);
                    }
                    for (DynamicObject curRole : curRoles) {
                        long curRoleId = curRole.getLong("id");
                        List<DynamicObject> curTasks = keyRoleValTasks.get(curRoleId);
                        WorkflowUtils.updateTaskStatus(curTasks, FlowRuTaskStatusEnum.WAITING.getCode());
                        flowParamBo.getRuTaskColl().addAll(curTasks);
                    }
                    roles.removeAll(curRoles);
                    for (DynamicObject role2 : roles) {
                        long roleId = role2.getLong("id");
                        List<DynamicObject> tasks = keyRoleValTasks.get(roleId);
                        WorkflowUtils.updateTaskStatus(tasks, FlowRuTaskStatusEnum.RETURNED.getCode());
                        flowParamBo.getRuTaskColl().addAll(tasks);
                    }
                }
                for (DynamicObject lastNode : lastNodes) {
                    long lastNodeId = lastNode.getLong("id");
                    roles = keyNodeValRoles.get(lastNodeId);
                    WorkflowUtils.updateRoleStatus(roles, FlowRuRoleStatusEnum.RETURNED.getCode());
                    flowParamBo.getRuRoleColl().addAll(roles);
                    for (DynamicObject role3 : roles) {
                        long roleId = role3.getLong("id");
                        List<DynamicObject> tasks = keyRoleValTasks.get(roleId);
                        WorkflowUtils.updateTaskStatus(tasks, FlowRuTaskStatusEnum.RETURNED.getCode());
                        flowParamBo.getRuTaskColl().addAll(tasks);
                    }
                }
            }
        }
        FlowValidateResultBo resultBo = new FlowValidateResultBo();
        HashMap<Long, String> resultMap = new HashMap<Long, String>(16);
        this.findPendingTasks(flowParamBo);
        String updateResult = this.updateRollbackTasksStatus(flowParamBo);
        if (HRStringUtils.isNotEmpty((String)updateResult)) {
            HashMap<Long, String> errortMap = new HashMap<Long, String>(16);
            resultBo.setCode("-1");
            errortMap.put(1L, updateResult);
            resultBo.setValidateMap(errortMap);
            resultBo.setMessage(updateResult);
            return resultBo;
        }
        this.sendMessageMerge(flowParamBo, "0");
        this.sendPendingMessage(flowParamBo);
        resultBo.setCode(resultMap.size() > 0 ? "-1" : "1");
        resultBo.setValidateMap(resultMap);
        return resultBo;
    }

    public FlowValidateResultBo rollbackToLastNodeOrRole(List<RollbackParamBo> rollbackParamBos) {
        BatchFlowParamBo flowParamBo = new BatchFlowParamBo();
        Map<String, List<RollbackParamBo>> boByType = rollbackParamBos.stream().collect(Collectors.groupingBy(RollbackParamBo::getRollbackType));
        List<RollbackParamBo> evaluatorRollbackTasks = boByType.get("2");
        if (CollectionUtils.isNotEmpty(evaluatorRollbackTasks)) {
            BatchFlowParamBo evaluatorFlowParamBo = new BatchFlowParamBo();
            List<Long> taskIds = this.getTaskIds(evaluatorRollbackTasks);
            if (CollectionUtils.isEmpty(taskIds)) {
                return this.getFlowValidateResultBo(ResManager.loadKDString((String)"\u5f53\u524d\u65e0\u53ef\u56de\u9000\u7684\u4efb\u52a1\uff0c\u8bf7\u91cd\u65b0\u786e\u8ba4\u3002", (String)"FlowRuSecondDomainService_7", (String)"opmc-pbs-business", (Object[])new Object[0]), "FlowRuSecondDomainService_7");
            }
            Map<Long, String> keyProcValReason = this.getReasonMap(evaluatorRollbackTasks, "procId");
            evaluatorFlowParamBo.setTaskAndReason(keyProcValReason);
            this.evaluatorRollbackToLastNodeOrRole(evaluatorRollbackTasks, evaluatorFlowParamBo);
            if (CollectionUtils.isNotEmpty(keyProcValReason.values())) {
                String reason = keyProcValReason.values().stream().findFirst().orElseGet(() -> WorkflowUtils.getReason(""));
                flowParamBo.setReason(reason);
            }
            this.integrateBos(flowParamBo, evaluatorFlowParamBo);
            flowParamBo.setRollbackType("1");
            flowParamBo.setKeyProcValTask(evaluatorFlowParamBo.getKeyProcValTask());
        }
        FlowValidateResultBo resultBo = new FlowValidateResultBo();
        HashMap<Long, String> resultMap = new HashMap<Long, String>(16);
        this.findPendingTasks(flowParamBo);
        String updateResult = this.updateRollbackTasksStatus(flowParamBo);
        if (HRStringUtils.isNotEmpty((String)updateResult)) {
            HashMap<Long, String> errortMap = new HashMap<Long, String>(16);
            resultBo.setCode("-1");
            errortMap.put(1L, updateResult);
            resultBo.setValidateMap(errortMap);
            resultBo.setMessage(updateResult);
            return resultBo;
        }
        this.sendMessageMerge(flowParamBo, "0");
        this.sendPendingMessage(flowParamBo);
        this.updateEvaluatorFlowIndicatorEditStatus(flowParamBo);
        resultBo.setCode(resultMap.size() > 0 ? "-1" : "1");
        resultBo.setValidateMap(resultMap);
        return resultBo;
    }

    private List<Long> getTaskIds(List<RollbackParamBo> evaluatorRollbackTasks) {
        List<Long> taskIds = evaluatorRollbackTasks.stream().filter(bo -> null != bo.getRuTaskId() && 0L != bo.getRuTaskId()).map(RollbackParamBo::getRuTaskId).collect(Collectors.toList());
        taskIds.addAll(evaluatorRollbackTasks.stream().filter(bo -> CollectionUtils.isNotEmpty(bo.getMergeTaskIds())).flatMap(bo -> bo.getMergeTaskIds().stream()).collect(Collectors.toList()));
        return taskIds;
    }

    private void evaluatorRollbackToLastNodeOrRole(List<RollbackParamBo> evaluatorRollbackTasks, BatchFlowParamBo flowParamBo) {
        List<Long> ruProcIds = evaluatorRollbackTasks.stream().filter(bo -> null != bo.getRuProcId() && 0L != bo.getRuProcId()).map(RollbackParamBo::getRuProcId).distinct().collect(Collectors.toList());
        List currentNodeIds = evaluatorRollbackTasks.stream().filter(bo -> null != bo.getRuNodeId() && 0L != bo.getRuNodeId()).map(RollbackParamBo::getRuNodeId).distinct().collect(Collectors.toList());
        DynamicObject[] ruProcs = FLOW_RU_PROC_ENTITY_SERVICE.loadRuProcByIds(ruProcIds);
        flowParamBo.setAllRuProcs(Arrays.asList(ruProcs));
        List ruNodes = Arrays.stream(FLOW_RU_NODE_ENTITY_SERVICE.loadRuNodeByProcIds(ruProcIds)).collect(Collectors.toList());
        Map<Long, List<DynamicObject>> keyProcValNodes = ruNodes.stream().collect(Collectors.groupingBy(node -> node.getLong("flowruproc.id")));
        List currentNodes = ruNodes.stream().filter(node -> currentNodeIds.contains(node.getLong("id"))).collect(Collectors.toList());
        Map<Long, DynamicObject> keyProcValCurrentNode = currentNodes.stream().collect(Collectors.toMap(nodeX -> nodeX.getLong("flowruproc.id"), nodeY -> nodeY));
        ArrayList<Object> newNodes = new ArrayList<Object>(10);
        ArrayList preNodes = new ArrayList(10);
        ArrayList preNodeToLastActiveNodes = new ArrayList(10);
        for (Long ruProcId : ruProcIds) {
            List<DynamicObject> nodes = keyProcValNodes.get(ruProcId);
            DynamicObject currentNode = keyProcValCurrentNode.get(ruProcId);
            if (HRObjectUtils.isEmpty((Object)currentNode)) continue;
            List preNodeList = nodes.stream().filter(node -> node.getInt("index") == currentNode.getInt("index") - 1).collect(Collectors.toList());
            preNodes.addAll(preNodeList);
            List preNodeToLastActiveNodeList = nodes.stream().filter(node -> node.getInt("index") >= currentNode.getInt("index") - 1).collect(Collectors.toList());
            preNodeToLastActiveNodes.addAll(preNodeToLastActiveNodeList);
        }
        newNodes.addAll(currentNodes);
        newNodes.addAll(preNodes);
        List<Long> preNodeToLastActiveNodeIds = preNodeToLastActiveNodes.stream().map(node -> node.getLong("id")).distinct().collect(Collectors.toList());
        List allRuNodeIds = newNodes.stream().map(node -> node.getLong("id")).distinct().collect(Collectors.toList());
        DynamicObject[] allRuRoles = FLOW_RU_ROLE_ENTITY_SERVICE.queryRuRolesByNodeIds(preNodeToLastActiveNodeIds);
        Map<Long, List<DynamicObject>> keyNodeValRoles = Arrays.stream(allRuRoles).filter(role -> allRuNodeIds.contains(role.getLong("flowrunode.id"))).filter(role -> !HRStringUtils.equals((String)FlowRuRoleStatusEnum.RETURNED.getCode(), (String)role.getString("rolestatus"))).collect(Collectors.groupingBy(role -> role.getLong("flowrunode.id")));
        List<Long> ruRoleIds = Arrays.stream(allRuRoles).map(role -> role.getLong("id")).collect(Collectors.toList());
        List ruTasks = Arrays.stream(FLOW_RU_TASK_ENTITY_SERVICE.loadTasksByRoleIds(ruRoleIds)).collect(Collectors.toList());
        List rollbackedTasks = ruTasks.stream().filter(task -> HRStringUtils.equals((String)FlowRuTaskStatusEnum.RETURNED.getCode(), (String)task.getString("taskstatus"))).collect(Collectors.toList());
        Map<Long, List<DynamicObject>> keyProcValTasks = rollbackedTasks.stream().collect(Collectors.groupingBy(task -> task.getLong("flowruproc.id")));
        flowParamBo.setKeyProcValTask(keyProcValTasks);
        ruTasks.removeAll(rollbackedTasks);
        Map<Long, List<DynamicObject>> keyNodeValTasks = ruTasks.stream().collect(Collectors.groupingBy(task -> task.getLong("flowrunode.id")));
        Map<Long, List<DynamicObject>> keyRoleValTasks = ruTasks.stream().collect(Collectors.groupingBy(task -> task.getLong("flowrurole.id")));
        if (CollectionUtils.isNotEmpty(ruTasks)) {
            flowParamBo.setKeyProcValNode(keyProcValNodes);
            flowParamBo.setKeyNodeValRole(keyNodeValRoles);
            flowParamBo.setKeyRoleValTask(keyRoleValTasks);
            flowParamBo.setKeyNodeValTask(keyNodeValTasks);
            for (DynamicObject ruProc : ruProcs) {
                List<DynamicObject> realCurrentNodeRoles;
                long ruProcId = ruProc.getLong("id");
                DynamicObject currentNode = keyProcValCurrentNode.get(ruProcId);
                String nodeStatus = currentNode.getString("nodestatus");
                DynamicObject opRecord = FLOW_RU_OP_ENTITY_SERVICE.generateOpRecord(ruProc);
                opRecord.set("optype", (Object)FLowOpEnum.ROLLBACK.getValue());
                opRecord.set("description", (Object)flowParamBo.getTaskAndReason().get(ruProcId));
                flowParamBo.getOpRecordColl().add((Object)opRecord);
                if (!HRStringUtils.equals((String)FlowRuNodeStatusEnum.RETURNED.getCode(), (String)nodeStatus)) {
                    ruProc.set("currentnode", (Object)currentNode);
                }
                if (!HRStringUtils.equals((String)ruProc.getString("procstatus"), (String)FlowRuProcStatusEnum.RUNNING.getCode())) {
                    WorkflowUtils.updateStatus(ruProc, "procstatus", FlowRuProcStatusEnum.RUNNING.getCode());
                }
                long currentNodeId = currentNode.getLong("id");
                List paramBos = evaluatorRollbackTasks.stream().filter(bo -> bo.getRuNodeId() == currentNodeId).collect(Collectors.toList());
                Map<Boolean, List<RollbackParamBo>> groupTasks = paramBos.stream().collect(Collectors.groupingBy(RollbackParamBo::getMergeTask));
                List<RollbackParamBo> mergeTasksBos = groupTasks.get(Boolean.TRUE);
                List<RollbackParamBo> normalTasksBos = groupTasks.get(Boolean.FALSE);
                if (CollectionUtils.isNotEmpty(mergeTasksBos)) {
                    this.dealMergeTaskPreNodeOrRole(flowParamBo, ruProc, currentNode, mergeTasksBos);
                } else if (CollectionUtils.isNotEmpty(normalTasksBos)) {
                    this.dealNormalTaskPreNodeOrRole(flowParamBo, ruProc, currentNode, normalTasksBos);
                }
                DynamicObject realCurrentNode = ruProc.getDynamicObject("currentnode");
                if (!HRObjectUtils.isEmpty((Object)realCurrentNode) && !HRStringUtils.equals((String)FlowRuNodeStatusEnum.RETURNED.getCode(), (String)realCurrentNode.getString("nodestatus")) && CollectionUtils.isNotEmpty(realCurrentNodeRoles = keyNodeValRoles.get(realCurrentNode.getLong("id")))) {
                    List<DynamicObject> setCurrentRoleEntry = realCurrentNodeRoles.stream().filter(role -> HRStringUtils.equals((String)FlowRuRoleStatusEnum.PENDING.getCode(), (String)role.getString("rolestatus")) || HRStringUtils.equals((String)FlowRuRoleStatusEnum.RUNNING.getCode(), (String)role.getString("rolestatus"))).collect(Collectors.toList());
                    WorkflowUtils.setCurrentRunRole(ruProc, setCurrentRoleEntry);
                }
                flowParamBo.getRuProcColl().add((Object)ruProc);
            }
        }
    }

    private void dealNormalTaskPreNodeOrRole(BatchFlowParamBo flowParamBo, DynamicObject ruProc, DynamicObject currentNode, List<RollbackParamBo> normalTasksBos) {
        List normalTaskIds = normalTasksBos.stream().filter(bo -> null != bo.getRuTaskId() && 0L != bo.getRuTaskId()).map(RollbackParamBo::getRuTaskId).collect(Collectors.toList());
        long currentNodeId = currentNode.getLong("id");
        List<DynamicObject> currentNodeTasks = flowParamBo.getKeyNodeValTask().get(currentNodeId);
        List<DynamicObject> currentNodeRoles = flowParamBo.getKeyNodeValRole().get(currentNodeId);
        List currentTaskRoleIds = currentNodeTasks.stream().filter(task -> normalTaskIds.contains(task.getLong("id"))).map(task -> task.getLong("flowrurole.id")).distinct().collect(Collectors.toList());
        List<DynamicObject> normalTasks = currentNodeTasks.stream().filter(task -> normalTaskIds.contains(task.getLong("id"))).collect(Collectors.toList());
        Set<Long> taskIndicatorIds = this.getRollbackTaskIndicatorIds(normalTasks);
        boolean isCrossNode = currentNode.getBoolean("iscrossnode");
        if (isCrossNode) {
            Map<String, List<DynamicObject>> keySetNoValRole = currentNodeRoles.stream().filter(role -> currentTaskRoleIds.contains(role.getLong("id"))).sorted(Comparator.comparing(role -> role.getInt("turnoversort"), Comparator.nullsLast(Comparator.reverseOrder()))).collect(Collectors.groupingBy(role -> role.getString("setno")));
            for (Map.Entry<String, List<DynamicObject>> entry : keySetNoValRole.entrySet()) {
                String setNo = entry.getKey();
                List<DynamicObject> sameSetNoCurrentNodeRoles = currentNodeRoles.stream().filter(role -> HRStringUtils.equals((String)setNo, (String)role.getString("setno"))).collect(Collectors.toList());
                List<DynamicObject> rolesGroupBySetNo = entry.getValue();
                for (DynamicObject currentRole : rolesGroupBySetNo) {
                    int turnSort = currentRole.getInt("turnoversort");
                    this.dealCurrentNodeRoleRollback(flowParamBo, currentNode, ruProc, taskIndicatorIds, sameSetNoCurrentNodeRoles, turnSort);
                }
            }
        } else {
            List currentTaskRoles = currentNodeRoles.stream().filter(role -> currentTaskRoleIds.contains(role.getLong("id"))).sorted(Comparator.comparing(role -> role.getInt("turnoversort"), Comparator.nullsLast(Comparator.reverseOrder()))).collect(Collectors.toList());
            for (DynamicObject currentTaskRole : currentTaskRoles) {
                int turnSort = currentTaskRole.getInt("turnoversort");
                this.dealCurrentNodeRoleRollback(flowParamBo, currentNode, ruProc, taskIndicatorIds, currentNodeRoles, turnSort);
            }
        }
    }

    private void dealCurrentNodeRoleRollback(BatchFlowParamBo flowParamBo, DynamicObject currentNode, DynamicObject ruProc, Set<Long> taskIndicatorIds, List<DynamicObject> sameSetNoCurrentNodeRoles, int turnSort) {
        DynamicObject lessThanCurrentRoleSortAndGetMax;
        String nodeStatus = currentNode.getString("nodestatus");
        List<DynamicObject> sameSortRoles = sameSetNoCurrentNodeRoles.stream().filter(role -> !flowParamBo.getRuRoleColl().contains(role)).filter(role -> role.getInt("turnoversort") == turnSort).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(sameSortRoles)) {
            WorkflowUtils.updateRoleStatus(sameSortRoles, FlowRuRoleStatusEnum.RETURNED.getCode());
            flowParamBo.getRuRoleColl().addAll(sameSortRoles);
            for (DynamicObject sameSortRole : sameSortRoles) {
                List<DynamicObject> sameSortRoleTasks = flowParamBo.getKeyRoleValTask().get(sameSortRole.getLong("id"));
                if (!CollectionUtils.isNotEmpty(sameSortRoleTasks)) continue;
                List<DynamicObject> processingTasks = sameSortRoleTasks.stream().filter(task -> !HRStringUtils.equals((String)FlowRuTaskStatusEnum.RETURNED.getCode(), (String)task.getString("taskstatus"))).collect(Collectors.toList());
                WorkflowUtils.updateTaskStatus(processingTasks, FlowRuTaskStatusEnum.RETURNED.getCode());
                flowParamBo.getRuTaskColl().addAll(processingTasks);
            }
        }
        if (HRObjectUtils.isEmpty((Object)(lessThanCurrentRoleSortAndGetMax = (DynamicObject)sameSetNoCurrentNodeRoles.stream().filter(role -> role.getInt("turnoversort") < turnSort).max(Comparator.comparing(role -> role.getInt("turnoversort"))).orElse(null)))) {
            this.dealPreNodeRoleRollback(flowParamBo, currentNode, ruProc, taskIndicatorIds);
        } else {
            List<DynamicObject> needRollbackRoles = sameSetNoCurrentNodeRoles.stream().filter(role -> lessThanCurrentRoleSortAndGetMax.getInt("turnoversort") == role.getInt("turnoversort")).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(needRollbackRoles)) {
                this.dealPreNodeRoleRollback(flowParamBo, currentNode, ruProc, taskIndicatorIds);
            } else {
                if (!HRStringUtils.equals((String)FlowRuNodeStatusEnum.RETURNED.getCode(), (String)nodeStatus) && !HRStringUtils.equals((String)FlowRuNodeStatusEnum.PENDING.getCode(), (String)nodeStatus)) {
                    WorkflowUtils.updateStatus(currentNode, "nodestatus", FlowRuNodeStatusEnum.RUNNING.getCode());
                }
                flowParamBo.getRuNodeColl().add((Object)currentNode);
                WorkflowUtils.updateRoleStatus(needRollbackRoles, FlowRuRoleStatusEnum.RUNNING.getCode());
                flowParamBo.getRuRoleColl().addAll(needRollbackRoles);
                this.dealRollbackTaskStatus(flowParamBo, needRollbackRoles);
            }
        }
    }

    private void dealPreNodeRoleRollback(BatchFlowParamBo flowParamBo, DynamicObject currentNode, DynamicObject ruProc, Set<Long> taskIndicatorIds) {
        String nodeStatus = currentNode.getString("nodestatus");
        int currentNodeIndex = currentNode.getInt("index");
        boolean isCrossNode = currentNode.getBoolean("iscrossnode");
        if (!HRStringUtils.equals((String)FlowRuNodeStatusEnum.RETURNED.getCode(), (String)nodeStatus)) {
            WorkflowUtils.updateStatus(currentNode, "nodestatus", FlowRuNodeStatusEnum.RETURNED.getCode());
        }
        flowParamBo.getRuNodeColl().add((Object)currentNode);
        List<DynamicObject> currentPreNodes = flowParamBo.getKeyProcValNode().get(ruProc.getLong("id")).stream().filter(node -> node.getInt("index") == currentNodeIndex - 1).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(currentPreNodes)) {
            this.actualDealPreNodeLogic(flowParamBo, ruProc, taskIndicatorIds, isCrossNode, currentPreNodes);
        }
    }

    private void actualDealPreNodeLogic(BatchFlowParamBo flowParamBo, DynamicObject ruProc, Set<Long> taskIndicatorIds, boolean isCrossNode, List<DynamicObject> currentPreNodes) {
        for (DynamicObject currentPreNode : currentPreNodes) {
            long preNodeId = currentPreNode.getLong("id");
            List<DynamicObject> preNodeRoles = flowParamBo.getKeyNodeValRole().get(preNodeId);
            if (!CollectionUtils.isNotEmpty(preNodeRoles)) continue;
            if (!HRStringUtils.equals((String)FlowRuNodeStatusEnum.RETURNED.getCode(), (String)currentPreNode.getString("nodestatus"))) {
                WorkflowUtils.updateStatus(currentPreNode, "nodestatus", FlowRuNodeStatusEnum.RUNNING.getCode());
            }
            flowParamBo.getRuNodeColl().add((Object)currentPreNode);
            ruProc.set("currentnode", (Object)currentPreNode);
            boolean isCrossPreNode = currentPreNode.getBoolean("iscrossnode");
            if (isCrossNode && isCrossPreNode) {
                Map<String, List<DynamicObject>> keySetNoValRole = preNodeRoles.stream().collect(Collectors.groupingBy(role -> role.getString("setno")));
                ArrayList allLastRole = new ArrayList(10);
                ArrayList<Long> needRollbackRoleIds = new ArrayList<Long>(10);
                for (Map.Entry<String, List<DynamicObject>> entry : keySetNoValRole.entrySet()) {
                    List<DynamicObject> rolesGroupBySetNo = entry.getValue();
                    DynamicObject maxSortRole = rolesGroupBySetNo.stream().max(Comparator.comparing(role -> role.getInt("turnoversort"))).orElse(null);
                    if (HRObjectUtils.isEmpty((Object)maxSortRole)) continue;
                    List needRollbackRole = rolesGroupBySetNo.stream().filter(role -> role.getInt("turnoversort") == maxSortRole.getInt("turnoversort")).collect(Collectors.toList());
                    allLastRole.addAll(needRollbackRole);
                }
                List<Long> allLastRoleIds = allLastRole.stream().map(role -> role.getLong("id")).collect(Collectors.toList());
                ArrayList allLastRoleTasks = new ArrayList(10);
                allLastRoleIds.forEach(preRoleId -> allLastRoleTasks.addAll(flowParamBo.getKeyRoleValTask().get(preRoleId)));
                block2: for (DynamicObject task : allLastRoleTasks) {
                    DynamicObjectCollection indicatorColl = task.getDynamicObjectCollection("entryentity");
                    Set indicIds = indicatorColl.stream().map(dym -> dym.getLong("indicatorid")).collect(Collectors.toSet());
                    for (Long indicId : indicIds) {
                        if (!taskIndicatorIds.contains(indicId)) continue;
                        needRollbackRoleIds.add(task.getDynamicObject("flowrurole").getLong("id"));
                        continue block2;
                    }
                }
                DynamicObject needRollbackMaxRole = allLastRole.stream().filter(role -> needRollbackRoleIds.contains(role.getLong("id"))).max(Comparator.comparing(role -> role.getInt("turnoversort"))).orElse(null);
                if (HRObjectUtils.isEmpty((Object)needRollbackMaxRole)) continue;
                List<DynamicObject> needRollbackRoles = allLastRole.stream().filter(role -> needRollbackRoleIds.contains(role.getLong("id"))).filter(role -> role.getInt("turnoversort") == needRollbackMaxRole.getInt("turnoversort")).collect(Collectors.toList());
                this.dealPreMaxSortRoleStatus(flowParamBo, needRollbackRoles);
                continue;
            }
            if (isCrossPreNode) {
                DynamicObject needRollbackMaxRole = preNodeRoles.stream().max(Comparator.comparing(role -> role.getInt("turnoversort"))).orElse(null);
                if (HRObjectUtils.isEmpty((Object)needRollbackMaxRole)) continue;
                List<DynamicObject> needRollbackRoles = preNodeRoles.stream().filter(role -> role.getInt("turnoversort") == needRollbackMaxRole.getInt("turnoversort")).collect(Collectors.toList());
                this.dealPreMaxSortRoleStatus(flowParamBo, needRollbackRoles);
                continue;
            }
            this.dealPreMaxSortRoleStatus(flowParamBo, preNodeRoles);
        }
    }

    private void dealPreMaxSortRoleStatus(BatchFlowParamBo flowParamBo, List<DynamicObject> preNodeRoles) {
        List<DynamicObject> needRollbackRoles;
        DynamicObject maxSortRole = preNodeRoles.stream().max(Comparator.comparing(role -> role.getInt("turnoversort"))).orElse(null);
        if (!HRObjectUtils.isEmpty((Object)maxSortRole) && CollectionUtils.isNotEmpty(needRollbackRoles = preNodeRoles.stream().filter(role -> role.getInt("turnoversort") == maxSortRole.getInt("turnoversort")).collect(Collectors.toList()))) {
            WorkflowUtils.updateRoleStatus(needRollbackRoles, FlowRuRoleStatusEnum.RUNNING.getCode());
            flowParamBo.getRuRoleColl().addAll(needRollbackRoles);
            this.dealRollbackTaskStatus(flowParamBo, needRollbackRoles);
        }
    }

    private void dealRollbackTaskStatus(BatchFlowParamBo flowParamBo, List<DynamicObject> needRollbackRoles) {
        for (DynamicObject preRole : needRollbackRoles) {
            List<DynamicObject> preRoleTasks = flowParamBo.getKeyRoleValTask().get(preRole.getLong("id"));
            if (!CollectionUtils.isNotEmpty(preRoleTasks)) continue;
            List<DynamicObject> processedTasks = preRoleTasks.stream().filter(task -> !HRStringUtils.equals((String)FlowRuTaskStatusEnum.WAITING.getCode(), (String)task.getString("taskstatus")) && !HRStringUtils.equals((String)FlowRuTaskStatusEnum.PROCESSING.getCode(), (String)task.getString("taskstatus"))).collect(Collectors.toList());
            WorkflowUtils.updateTaskStatus(processedTasks, FlowRuTaskStatusEnum.WAITING.getCode());
            flowParamBo.getRuTaskColl().addAll(processedTasks);
        }
    }

    private void dealMergeTaskPreNodeOrRole(BatchFlowParamBo flowParamBo, DynamicObject ruProc, DynamicObject currentNode, List<RollbackParamBo> mergeTasksBos) {
        List mergeTaskIds = mergeTasksBos.stream().filter(bo -> CollectionUtils.isNotEmpty(bo.getMergeTaskIds())).flatMap(bo -> bo.getMergeTaskIds().stream()).collect(Collectors.toList());
        long currentNodeId = currentNode.getLong("id");
        int currentNodeIndex = currentNode.getInt("index");
        String nodeStatus = currentNode.getString("nodestatus");
        List<DynamicObject> currentNodeTasks = flowParamBo.getKeyNodeValTask().get(currentNodeId);
        List<DynamicObject> currentNodeRoles = flowParamBo.getKeyNodeValRole().get(currentNodeId);
        List<DynamicObject> mergeTasks = currentNodeTasks.stream().filter(task -> mergeTaskIds.contains(task.getLong("id"))).collect(Collectors.toList());
        Set<Long> taskIndicatorIds = this.getRollbackTaskIndicatorIds(mergeTasks);
        boolean isCrossNode = currentNode.getBoolean("iscrossnode");
        List mergeTaskRoleIds = currentNodeTasks.stream().filter(task -> mergeTaskIds.contains(task.getLong("id"))).map(task -> task.getLong("flowrurole.id")).collect(Collectors.toList());
        List mergeTaskRoles = currentNodeRoles.stream().filter(role -> mergeTaskRoleIds.contains(role.getLong("id"))).collect(Collectors.toList());
        List mergeTaskRoleSetNos = mergeTaskRoles.stream().map(role -> role.getString("setno")).collect(Collectors.toList());
        DynamicObject maxRole = mergeTaskRoles.stream().max(Comparator.comparing(role -> role.getInt("turnoversort"))).orElse(null);
        if (!HRObjectUtils.isEmpty((Object)maxRole)) {
            int maxTurnoverSort = maxRole.getInt("turnoversort");
            List<DynamicObject> sameMaxSortRoles = currentNodeRoles.stream().filter(role -> mergeTaskRoleSetNos.contains(role.getString("setno"))).filter(role -> role.getInt("turnoversort") == maxTurnoverSort).collect(Collectors.toList());
            WorkflowUtils.updateRoleStatus(sameMaxSortRoles, FlowRuRoleStatusEnum.RETURNED.getCode());
            flowParamBo.getRuRoleColl().addAll(sameMaxSortRoles);
            for (DynamicObject sameMaxSortRole : sameMaxSortRoles) {
                List<DynamicObject> sameMaxSortRoleTasks = flowParamBo.getKeyRoleValTask().get(sameMaxSortRole.getLong("id"));
                WorkflowUtils.updateTaskStatus(sameMaxSortRoleTasks, FlowRuTaskStatusEnum.RETURNED.getCode());
                flowParamBo.getRuTaskColl().addAll(sameMaxSortRoleTasks);
            }
            DynamicObject lessThanCurrentRoleSortAndGetMax = currentNodeRoles.stream().filter(role -> mergeTaskRoleSetNos.contains(role.getString("setno"))).filter(role -> role.getInt("turnoversort") < maxTurnoverSort).max(Comparator.comparing(role -> role.getInt("turnoversort"))).orElse(null);
            if (!HRObjectUtils.isEmpty((Object)lessThanCurrentRoleSortAndGetMax)) {
                if (!HRStringUtils.equals((String)FlowRuNodeStatusEnum.RETURNED.getCode(), (String)nodeStatus)) {
                    WorkflowUtils.updateStatus(currentNode, "nodestatus", FlowRuNodeStatusEnum.RUNNING.getCode());
                }
                flowParamBo.getRuNodeColl().add((Object)currentNode);
                int lessThanMaxSort = lessThanCurrentRoleSortAndGetMax.getInt("turnoversort");
                List<DynamicObject> preRoles = currentNodeRoles.stream().filter(role -> mergeTaskRoleSetNos.contains(role.getString("setno"))).filter(role -> role.getInt("turnoversort") == lessThanMaxSort).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(preRoles)) {
                    WorkflowUtils.updateRoleStatus(preRoles, FlowRuRoleStatusEnum.RUNNING.getCode());
                    flowParamBo.getRuRoleColl().addAll(preRoles);
                    this.dealRollbackTaskStatus(flowParamBo, preRoles);
                }
            } else {
                if (!HRStringUtils.equals((String)FlowRuNodeStatusEnum.RETURNED.getCode(), (String)nodeStatus)) {
                    WorkflowUtils.updateStatus(currentNode, "nodestatus", FlowRuNodeStatusEnum.RETURNED.getCode());
                }
                flowParamBo.getRuNodeColl().add((Object)currentNode);
                List<DynamicObject> currentPreNodes = flowParamBo.getKeyProcValNode().get(ruProc.getLong("id")).stream().filter(node -> node.getInt("index") == currentNodeIndex - 1).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(currentPreNodes)) {
                    this.actualDealPreNodeLogic(flowParamBo, ruProc, taskIndicatorIds, isCrossNode, currentPreNodes);
                }
            }
        }
    }

    public FlowValidateResultBo rollbackToSpecifiedTask(List<RollbackParamBo> rollbackParamBos) {
        List<RollbackParamBo> evaluatorRollbackTasks;
        List<RollbackParamBo> interviewRollbackTasks;
        BatchFlowParamBo flowParamBo = new BatchFlowParamBo();
        Map<String, List<RollbackParamBo>> boByType = rollbackParamBos.stream().collect(Collectors.groupingBy(RollbackParamBo::getRollbackType));
        List<RollbackParamBo> indicatorRollbackTasks = boByType.get("1");
        if (CollectionUtils.isNotEmpty(indicatorRollbackTasks)) {
            BatchFlowParamBo indicatorFlowParamBo = new BatchFlowParamBo();
            List<Long> taskIds = indicatorRollbackTasks.stream().filter(bo -> null != bo.getRuTaskId() && 0L != bo.getRuTaskId()).map(RollbackParamBo::getRuTaskId).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(taskIds)) {
                return this.getFlowValidateResultBo(ResManager.loadKDString((String)"\u5f53\u524d\u65e0\u53ef\u56de\u9000\u7684\u4efb\u52a1\uff0c\u8bf7\u91cd\u65b0\u786e\u8ba4\u3002", (String)"FlowRuSecondDomainService_7", (String)"opmc-pbs-business", (Object[])new Object[0]), "FlowRuSecondDomainService_7");
            }
            Map<Long, String> keyProcValReason = this.getReasonMap(indicatorRollbackTasks, "procId");
            indicatorFlowParamBo.setTaskAndReason(keyProcValReason);
            this.interviewOrIndicatorRollbackToSpecifiedTask(taskIds, indicatorFlowParamBo);
            Map<Long, String> taskAndReason = this.getReasonMap(indicatorRollbackTasks, "taskId");
            indicatorFlowParamBo.setTaskAndReason(taskAndReason);
            this.integrateBos(flowParamBo, indicatorFlowParamBo);
        }
        if (CollectionUtils.isNotEmpty(interviewRollbackTasks = boByType.get("3"))) {
            BatchFlowParamBo interviewFlowParamBo = new BatchFlowParamBo();
            List<Long> taskIds = interviewRollbackTasks.stream().filter(bo -> null != bo.getRuTaskId() && 0L != bo.getRuTaskId()).map(RollbackParamBo::getRuTaskId).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(taskIds)) {
                return this.getFlowValidateResultBo(ResManager.loadKDString((String)"\u5f53\u524d\u65e0\u53ef\u56de\u9000\u7684\u4efb\u52a1\uff0c\u8bf7\u91cd\u65b0\u786e\u8ba4\u3002", (String)"FlowRuSecondDomainService_7", (String)"opmc-pbs-business", (Object[])new Object[0]), "FlowRuSecondDomainService_7");
            }
            Map<Long, String> keyProcValReason = this.getReasonMap(interviewRollbackTasks, "procId");
            interviewFlowParamBo.setTaskAndReason(keyProcValReason);
            this.interviewOrIndicatorRollbackToSpecifiedTask(taskIds, interviewFlowParamBo);
            Map<Long, String> taskAndReason = this.getReasonMap(interviewRollbackTasks, "taskId");
            interviewFlowParamBo.setTaskAndReason(taskAndReason);
            this.integrateBos(flowParamBo, interviewFlowParamBo);
        }
        if (CollectionUtils.isNotEmpty(evaluatorRollbackTasks = boByType.get("2"))) {
            BatchFlowParamBo evaluatorFlowParamBo = new BatchFlowParamBo();
            List taskIds = evaluatorRollbackTasks.stream().filter(bo -> null != bo.getRuTaskId() && 0L != bo.getRuTaskId()).map(RollbackParamBo::getRuTaskId).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(taskIds)) {
                return this.getFlowValidateResultBo(ResManager.loadKDString((String)"\u5f53\u524d\u65e0\u53ef\u56de\u9000\u7684\u4efb\u52a1\uff0c\u8bf7\u91cd\u65b0\u786e\u8ba4\u3002", (String)"FlowRuSecondDomainService_7", (String)"opmc-pbs-business", (Object[])new Object[0]), "FlowRuSecondDomainService_7");
            }
            Map<Long, List<Long>> taskMap = evaluatorRollbackTasks.stream().collect(Collectors.toMap(RollbackParamBo::getRuTaskId, bo -> {
                List<Long> indicatorIds = bo.getIndicatorIds();
                if (CollectionUtils.isEmpty(indicatorIds)) {
                    indicatorIds = new ArrayList<Long>(10);
                }
                return indicatorIds;
            }));
            Map<Long, String> keyProcValReason = this.getReasonMap(evaluatorRollbackTasks, "procId");
            evaluatorFlowParamBo.setTaskAndReason(keyProcValReason);
            this.evaluatorRollbackToSpecifiedTask(taskMap, evaluatorFlowParamBo);
            Map<Long, String> taskAndReason = this.getReasonMap(evaluatorRollbackTasks, "taskId");
            evaluatorFlowParamBo.setTaskAndReason(taskAndReason);
            this.integrateBos(flowParamBo, evaluatorFlowParamBo);
        }
        FlowValidateResultBo resultBo = new FlowValidateResultBo();
        HashMap<Long, String> resultMap = new HashMap<Long, String>(16);
        this.findPendingTasks(flowParamBo);
        String updateResult = this.updateRollbackTasksStatus(flowParamBo);
        if (HRStringUtils.isNotEmpty((String)updateResult)) {
            HashMap<Long, String> errortMap = new HashMap<Long, String>(16);
            resultBo.setCode("-1");
            errortMap.put(1L, updateResult);
            resultBo.setValidateMap(errortMap);
            resultBo.setMessage(updateResult);
            return resultBo;
        }
        this.sendMessageMerge(flowParamBo, "2");
        this.sendPendingMessage(flowParamBo);
        this.updateEvaluatorFlowIndicatorEditStatus(flowParamBo);
        resultBo.setCode(resultMap.size() > 0 ? "-1" : "1");
        resultBo.setValidateMap(resultMap);
        return resultBo;
    }

    private Map<Long, String> getReasonMap(List<RollbackParamBo> rollbackTasks, String type) {
        Map<Object, Object> reasonMap = new HashMap(16);
        reasonMap = HRStringUtils.equals((String)"taskId", (String)type) ? rollbackTasks.stream().collect(Collectors.toMap(RollbackParamBo::getRuTaskId, bo -> WorkflowUtils.getReason(bo.getReason()), (oldValue, newValue) -> newValue)) : (HRStringUtils.equals((String)"procId", (String)type) ? rollbackTasks.stream().collect(Collectors.toMap(RollbackParamBo::getRuProcId, bo -> WorkflowUtils.getReason(bo.getReason()), (oldValue, newValue) -> newValue)) : rollbackTasks.stream().collect(Collectors.toMap(RollbackParamBo::getRuNodeId, bo -> WorkflowUtils.getReason(bo.getReason()), (oldValue, newValue) -> newValue)));
        return reasonMap;
    }

    private FlowValidateResultBo getFlowValidateResultBo(String description, String resourceID) {
        FlowValidateResultBo resultBo = new FlowValidateResultBo();
        resultBo.setCode("-1");
        String message = ResManager.loadKDString((String)description, (String)resourceID, (String)"opmc-pbs-business", (Object[])new Object[0]);
        resultBo.setMessage(message);
        return resultBo;
    }

    private void interviewOrIndicatorRollbackToSpecifiedTask(List<Long> taskIds, BatchFlowParamBo flowParamBo) {
        List<DynamicObject> ruTasks = Arrays.stream(FLOW_RU_TASK_ENTITY_SERVICE.queryRuTasksByIds(taskIds)).collect(Collectors.toList());
        List<Long> ruProcIds = ruTasks.stream().map(task -> task.getLong("flowruproc.id")).distinct().collect(Collectors.toList());
        List currentNodeIds = ruTasks.stream().map(task -> task.getLong("flowrunode.id")).distinct().collect(Collectors.toList());
        List currentRoleIds = ruTasks.stream().map(task -> task.getLong("flowrurole.id")).distinct().collect(Collectors.toList());
        DynamicObject[] ruProcs = FLOW_RU_PROC_ENTITY_SERVICE.queryRuProcByIds(ruProcIds);
        flowParamBo.setAllRuProcs(Arrays.asList(ruProcs));
        DynamicObject[] ruNodes = FLOW_RU_NODE_ENTITY_SERVICE.queryRuNodeByProcIds(ruProcIds);
        List<DynamicObject> currentNodes = Arrays.stream(ruNodes).filter(node -> currentNodeIds.contains(node.getLong("id"))).collect(Collectors.toList());
        Map<Long, DynamicObject> keyProcValCurrentNode = currentNodes.stream().collect(Collectors.toMap(nodeX -> nodeX.getLong("flowruproc.id"), nodeY -> nodeY));
        Map<Long, List<DynamicObject>> keyProcValNodes = Arrays.stream(ruNodes).collect(Collectors.groupingBy(node -> node.getLong("flowruproc.id")));
        ArrayList<Object> newNodes = new ArrayList<Object>(10);
        ArrayList lastNodes = new ArrayList(10);
        for (Long ruProcId : ruProcIds) {
            List<DynamicObject> nodes = keyProcValNodes.get(ruProcId);
            DynamicObject currentNode = keyProcValCurrentNode.get(ruProcId);
            if (HRObjectUtils.isEmpty((Object)currentNode)) continue;
            List nextNodes = nodes.stream().filter(node -> node.getInt("index") > currentNode.getInt("index")).collect(Collectors.toList());
            lastNodes.addAll(nextNodes);
        }
        WorkflowUtils.updateNodeStatus(currentNodes, FlowRuNodeStatusEnum.RUNNING.getCode());
        flowParamBo.getRuNodeColl().addAll(currentNodes);
        for (DynamicObject followNode : lastNodes) {
            if (HRStringUtils.equals((String)FlowRuNodeStatusEnum.RETURNED.getCode(), (String)followNode.getString("nodestatus"))) continue;
            WorkflowUtils.updateStatus(followNode, "nodestatus", FlowRuNodeStatusEnum.RETURNED.getCode());
            flowParamBo.getRuNodeColl().add((Object)followNode);
        }
        WorkflowUtils.updateTaskStatus(ruTasks, FlowRuTaskStatusEnum.WAITING.getCode());
        flowParamBo.getRuTaskColl().addAll(ruTasks);
        newNodes.addAll(currentNodes);
        newNodes.addAll(lastNodes);
        List<Long> ruNodeIds = newNodes.stream().map(node -> node.getLong("id")).collect(Collectors.toList());
        DynamicObject[] ruRoles = FLOW_RU_ROLE_ENTITY_SERVICE.queryRuRoleByNodeIds(ruNodeIds);
        Map<Long, List<DynamicObject>> keyNodeValRoles = Arrays.stream(ruRoles).collect(Collectors.groupingBy(role -> role.getLong("flowrunode.id")));
        Map<Long, List<DynamicObject>> keyNodeValCurrentRoles = Arrays.stream(ruRoles).filter(role -> currentRoleIds.contains(role.getLong("id"))).collect(Collectors.groupingBy(role -> role.getLong("flowrunode.id")));
        List<Long> ruRoleIds = Arrays.stream(ruRoles).map(role -> role.getLong("id")).collect(Collectors.toList());
        DynamicObject[] allRuTasks = FLOW_RU_TASK_ENTITY_SERVICE.queryTasksByRoleIds(ruRoleIds);
        Map<Long, List<DynamicObject>> keyRoleValTasks = Arrays.stream(allRuTasks).collect(Collectors.groupingBy(task -> task.getLong("flowrurole.id")));
        for (DynamicObject ruProc : ruProcs) {
            long ruProcId = ruProc.getLong("id");
            DynamicObject currentNode = keyProcValCurrentNode.get(ruProcId);
            DynamicObject opRecord = FLOW_RU_OP_ENTITY_SERVICE.generateOpRecord(ruProc);
            opRecord.set("optype", (Object)FLowOpEnum.ROLLBACK.getValue());
            opRecord.set("description", (Object)flowParamBo.getTaskAndReason().get(ruProcId));
            flowParamBo.getOpRecordColl().add((Object)opRecord);
            ruProc.set("currentnode", (Object)currentNode);
            long curNodeId = currentNode.getLong("id");
            List<DynamicObject> roles = keyNodeValRoles.get(curNodeId);
            List<DynamicObject> currentRoles = keyNodeValCurrentRoles.get(curNodeId);
            if (CollectionUtils.isEmpty(currentRoles)) continue;
            WorkflowUtils.updateRoleStatus(currentRoles, FlowRuRoleStatusEnum.RUNNING.getCode());
            flowParamBo.getRuRoleColl().addAll(currentRoles);
            WorkflowUtils.setCurrentRunRole(ruProc, currentRoles);
            for (DynamicObject currentRole : currentRoles) {
                List<DynamicObject> sortRoles = roles.stream().filter(role -> role.getInt("turnoversort") > currentRole.getInt("turnoversort")).collect(Collectors.toList());
                this.dealRoleAndTaskStatus(flowParamBo, currentRole, keyRoleValTasks, sortRoles);
            }
            WorkflowUtils.updateStatus(ruProc, "procstatus", FlowRuProcStatusEnum.RUNNING.getCode());
            flowParamBo.getRuProcColl().add((Object)ruProc);
        }
        if (CollectionUtils.isNotEmpty(lastNodes)) {
            for (DynamicObject lastNode : lastNodes) {
                long lastNodeId = lastNode.getLong("id");
                List<DynamicObject> lastRoles = keyNodeValRoles.get(lastNodeId);
                if (CollectionUtils.isEmpty(lastRoles)) continue;
                WorkflowUtils.updateRoleStatus(lastRoles, FlowRuRoleStatusEnum.RETURNED.getCode());
                flowParamBo.getRuRoleColl().addAll(lastRoles);
                for (DynamicObject role2 : lastRoles) {
                    long roleId = role2.getLong("id");
                    List<DynamicObject> tasks = keyRoleValTasks.get(roleId);
                    if (CollectionUtils.isEmpty(tasks)) continue;
                    WorkflowUtils.updateTaskStatus(tasks, FlowRuTaskStatusEnum.RETURNED.getCode());
                    flowParamBo.getRuTaskColl().addAll(tasks);
                }
            }
        }
    }

    private void evaluatorRollbackToSpecifiedTask(Map<Long, List<Long>> taskMap, BatchFlowParamBo flowParamBo) {
        Set<Long> taskIdset = taskMap.keySet();
        List<DynamicObject> targetTasks = Arrays.stream(FLOW_RU_TASK_ENTITY_SERVICE.loadTasksByIds(new ArrayList<Long>(taskIdset))).collect(Collectors.toList());
        Map<Long, List<DynamicObject>> keyNodeValTasks = targetTasks.stream().collect(Collectors.groupingBy(task -> task.getLong("flowrunode.id")));
        flowParamBo.setTaskAndIndicatorMap(taskMap);
        List<Long> ruProcIds = targetTasks.stream().map(task -> task.getLong("flowruproc.id")).distinct().collect(Collectors.toList());
        List currentNodeIds = targetTasks.stream().map(task -> task.getLong("flowrunode.id")).distinct().collect(Collectors.toList());
        List currentRoleIds = targetTasks.stream().map(task -> task.getLong("flowrurole.id")).distinct().collect(Collectors.toList());
        DynamicObject[] ruProcs = FLOW_RU_PROC_ENTITY_SERVICE.loadRuProcByIds(ruProcIds);
        flowParamBo.setAllRuProcs(Arrays.asList(ruProcs));
        DynamicObject[] ruNodes = FLOW_RU_NODE_ENTITY_SERVICE.loadRuNodeByProcIds(ruProcIds);
        Map<Long, List<DynamicObject>> keyProcValNodes = Arrays.stream(ruNodes).collect(Collectors.groupingBy(node -> node.getLong("flowruproc.id")));
        List currentNodes = Arrays.stream(ruNodes).filter(node -> currentNodeIds.contains(node.getLong("id"))).collect(Collectors.toList());
        Map<Long, DynamicObject> keyProcValCurrentNode = currentNodes.stream().collect(Collectors.toMap(nodeX -> nodeX.getLong("flowruproc.id"), nodeY -> nodeY));
        ArrayList<Object> newNodes = new ArrayList<Object>(10);
        ArrayList followNodes = new ArrayList(10);
        for (Long ruProcId : ruProcIds) {
            List<DynamicObject> nodes = keyProcValNodes.get(ruProcId);
            DynamicObject currentNode = keyProcValCurrentNode.get(ruProcId);
            if (HRObjectUtils.isEmpty((Object)currentNode)) continue;
            List nextNodes = nodes.stream().filter(node -> node.getInt("index") > currentNode.getInt("index")).collect(Collectors.toList());
            followNodes.addAll(nextNodes);
        }
        newNodes.addAll(currentNodes);
        newNodes.addAll(followNodes);
        List<Long> allRuNodeIds = newNodes.stream().map(node -> node.getLong("id")).distinct().collect(Collectors.toList());
        DynamicObject[] allRuRoles = FLOW_RU_ROLE_ENTITY_SERVICE.loadRuRoleByNodeIds(allRuNodeIds);
        Map<Long, List<DynamicObject>> keyNodeValRoles = Arrays.stream(allRuRoles).collect(Collectors.groupingBy(role -> role.getLong("flowrunode.id")));
        List<Long> ruRoleIds = Arrays.stream(allRuRoles).map(role -> role.getLong("id")).collect(Collectors.toList());
        DynamicObject[] ruTasks = FLOW_RU_TASK_ENTITY_SERVICE.loadTasksByRoleIds(ruRoleIds);
        Map<Long, List<DynamicObject>> keyRoleValTasks = Arrays.stream(ruTasks).collect(Collectors.groupingBy(task -> task.getLong("flowrurole.id")));
        for (DynamicObject currentNode : currentNodes) {
            if (HRStringUtils.equals((String)FlowRuNodeStatusEnum.RETURNED.getCode(), (String)currentNode.getString("nodestatus"))) continue;
            WorkflowUtils.updateStatus(currentNode, "nodestatus", FlowRuNodeStatusEnum.RUNNING.getCode());
        }
        flowParamBo.getRuNodeColl().addAll(currentNodes);
        for (DynamicObject followNode : followNodes) {
            if (HRStringUtils.equals((String)FlowRuNodeStatusEnum.RETURNED.getCode(), (String)followNode.getString("nodestatus"))) continue;
            WorkflowUtils.updateStatus(followNode, "nodestatus", FlowRuNodeStatusEnum.RETURNED.getCode());
            flowParamBo.getRuNodeColl().add((Object)followNode);
        }
        WorkflowUtils.updateTaskStatus(targetTasks, FlowRuTaskStatusEnum.WAITING.getCode());
        flowParamBo.getRuTaskColl().addAll(targetTasks);
        for (Iterator<Object> iterator : ruProcs) {
            long procId = iterator.getLong("id");
            DynamicObject currentNode = keyProcValCurrentNode.get(iterator.getLong("id"));
            String reason = HRStringUtils.isEmpty((String)flowParamBo.getTaskAndReason().get(procId)) ? flowParamBo.getTaskAndReason().get(null) : flowParamBo.getTaskAndReason().get(procId);
            DynamicObject opRecord = FLOW_RU_OP_ENTITY_SERVICE.generateOpRecord((DynamicObject)iterator);
            opRecord.set("optype", (Object)FLowOpEnum.ROLLBACK.getValue());
            opRecord.set("description", (Object)reason);
            flowParamBo.getOpRecordColl().add((Object)opRecord);
            boolean isCrossNode = currentNode.getBoolean("iscrossnode");
            long curNodeId = currentNode.getLong("id");
            List<DynamicObject> currentNodeRoles = keyNodeValRoles.get(curNodeId);
            if (CollectionUtils.isEmpty(currentNodeRoles)) continue;
            if (isCrossNode) {
                Map<String, List<DynamicObject>> ketSetNoValRoles = currentNodeRoles.stream().filter(role -> currentRoleIds.contains(role.getLong("id"))).sorted(Comparator.comparing(role -> role.getInt("turnoversort"), Comparator.nullsLast(Comparator.reverseOrder()))).collect(Collectors.groupingBy(role -> role.getString("setno")));
                for (Map.Entry<String, List<DynamicObject>> entry : ketSetNoValRoles.entrySet()) {
                    String setNo = entry.getKey();
                    List<DynamicObject> currentRoleList = entry.getValue();
                    WorkflowUtils.updateRoleStatus(currentRoleList, FlowRuRoleStatusEnum.RUNNING.getCode());
                    flowParamBo.getRuRoleColl().addAll(currentRoleList);
                    for (DynamicObject dynamicObject : currentRoleList) {
                        List currentLastRoles = currentNodeRoles.stream().filter(role -> HRStringUtils.equals((String)setNo, (String)role.getString("setno"))).filter(role -> role.getInt("turnoversort") > currentRole.getInt("turnoversort")).collect(Collectors.toList());
                        if (!CollectionUtils.isNotEmpty(currentLastRoles)) continue;
                        for (DynamicObject lastRole : currentLastRoles) {
                            long lastRoleId = lastRole.getLong("id");
                            WorkflowUtils.updateStatus(lastRole, "rolestatus", FlowRuRoleStatusEnum.RETURNED.getCode());
                            flowParamBo.getRuRoleColl().add((Object)lastRole);
                            List<DynamicObject> lastTasks = keyRoleValTasks.get(lastRoleId);
                            if (!CollectionUtils.isNotEmpty(lastTasks)) continue;
                            WorkflowUtils.updateTaskStatus(lastTasks, FlowRuTaskStatusEnum.RETURNED.getCode());
                            flowParamBo.getRuTaskColl().addAll(lastTasks);
                        }
                    }
                }
                List<DynamicObject> nodes = keyProcValNodes.get(procId);
                if (CollectionUtils.isNotEmpty((Collection)nodes)) {
                    Map<Boolean, List<DynamicObject>> keyCrossValNodes = nodes.stream().filter(node -> node.getInt("index") > currentNode.getInt("index")).collect(Collectors.groupingBy(node -> node.getBoolean("iscrossnode")));
                    List<DynamicObject> needGetIndicatorTasks = keyNodeValTasks.get(curNodeId);
                    Set<Long> taskIndicatorIds = new HashSet(16);
                    for (DynamicObject dynamicObject : needGetIndicatorTasks) {
                        List<Long> indicatorIds = taskMap.get(dynamicObject.getLong("id"));
                        taskIndicatorIds.addAll(indicatorIds);
                    }
                    if (CollectionUtils.isEmpty((Collection)taskIndicatorIds)) {
                        taskIndicatorIds = this.getRollbackTaskIndicatorIds(needGetIndicatorTasks, curNodeId);
                    }
                    for (Map.Entry entry : keyCrossValNodes.entrySet()) {
                        Boolean isfollowCrossNode = (Boolean)entry.getKey();
                        List lastNodes = (List)entry.getValue();
                        if (!CollectionUtils.isNotEmpty((Collection)lastNodes)) continue;
                        for (DynamicObject lastNode : lastNodes) {
                            long lastNodeId = lastNode.getLong("id");
                            List<DynamicObject> lastRoles = keyNodeValRoles.get(lastNodeId);
                            if (!CollectionUtils.isNotEmpty(lastRoles)) continue;
                            for (DynamicObject lastRole : lastRoles) {
                                boolean needUpdateStatus = false;
                                long lastRoleId = lastRole.getLong("id");
                                List<DynamicObject> lastTasks = keyRoleValTasks.get(lastRoleId);
                                if (!CollectionUtils.isNotEmpty(lastTasks)) continue;
                                if (Boolean.TRUE.equals(isfollowCrossNode)) {
                                    block11: for (DynamicObject task2 : lastTasks) {
                                        DynamicObjectCollection indicatorColl = task2.getDynamicObjectCollection("entryentity");
                                        Set indicIds = indicatorColl.stream().map(dym -> dym.getLong("indicatorid")).collect(Collectors.toSet());
                                        for (Long indicId : indicIds) {
                                            if (!taskIndicatorIds.contains(indicId)) continue;
                                            needUpdateStatus = true;
                                            continue block11;
                                        }
                                    }
                                    if (!needUpdateStatus) continue;
                                    WorkflowUtils.updateStatus(lastRole, "rolestatus", FlowRuRoleStatusEnum.RETURNED.getCode());
                                    flowParamBo.getRuRoleColl().add((Object)lastRole);
                                    WorkflowUtils.updateTaskStatus(lastTasks, FlowRuTaskStatusEnum.RETURNED.getCode());
                                    flowParamBo.getRuTaskColl().addAll(lastTasks);
                                    continue;
                                }
                                WorkflowUtils.updateStatus(lastRole, "rolestatus", FlowRuRoleStatusEnum.RETURNED.getCode());
                                flowParamBo.getRuRoleColl().add((Object)lastRole);
                                WorkflowUtils.updateTaskStatus(lastTasks, FlowRuTaskStatusEnum.RETURNED.getCode());
                                flowParamBo.getRuTaskColl().addAll(lastTasks);
                            }
                        }
                    }
                }
            } else {
                List lastNodes;
                List<DynamicObject> currentRoles = currentNodeRoles.stream().filter(role -> currentRoleIds.contains(role.getLong("id"))).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(currentRoles)) {
                    WorkflowUtils.updateRoleStatus(currentRoles, FlowRuRoleStatusEnum.RUNNING.getCode());
                    flowParamBo.getRuRoleColl().addAll(currentRoles);
                    for (DynamicObject currentRole : currentRoles) {
                        List<DynamicObject> currentLastRoles = currentNodeRoles.stream().filter(role -> role.getInt("turnoversort") > currentRole.getInt("turnoversort")).collect(Collectors.toList());
                        if (!CollectionUtils.isNotEmpty(currentLastRoles)) continue;
                        WorkflowUtils.updateRoleStatus(currentLastRoles, FlowRuRoleStatusEnum.RETURNED.getCode());
                        flowParamBo.getRuRoleColl().addAll(currentLastRoles);
                        for (DynamicObject lastRole : currentLastRoles) {
                            List<DynamicObject> list = keyRoleValTasks.get(lastRole.getLong("id"));
                            WorkflowUtils.updateTaskStatus(list, FlowRuTaskStatusEnum.RETURNED.getCode());
                            flowParamBo.getRuTaskColl().addAll(list);
                        }
                    }
                }
                if (CollectionUtils.isNotEmpty(lastNodes = keyProcValNodes.get(procId).stream().filter(node -> node.getInt("index") > currentNode.getInt("index")).collect(Collectors.toList()))) {
                    for (DynamicObject lastNode : lastNodes) {
                        List<DynamicObject> lastRoles = keyNodeValRoles.get(lastNode.getLong("id"));
                        if (!CollectionUtils.isNotEmpty(lastRoles)) continue;
                        WorkflowUtils.updateRoleStatus(lastRoles, FlowRuRoleStatusEnum.RETURNED.getCode());
                        flowParamBo.getRuRoleColl().addAll(lastRoles);
                        for (DynamicObject dynamicObject : lastRoles) {
                            List<DynamicObject> lastTasks = keyRoleValTasks.get(dynamicObject.getLong("id"));
                            if (!CollectionUtils.isNotEmpty(lastTasks)) continue;
                            WorkflowUtils.updateTaskStatus(lastTasks, FlowRuTaskStatusEnum.RETURNED.getCode());
                            flowParamBo.getRuTaskColl().addAll(lastTasks);
                        }
                    }
                }
            }
            String nodeStatus = currentNode.getString("nodestatus");
            if (!HRStringUtils.equals((String)FlowRuNodeStatusEnum.RETURNED.getCode(), (String)nodeStatus)) {
                iterator.set("currentnode", currentNode);
                if (CollectionUtils.isNotEmpty(currentNodeRoles)) {
                    List<DynamicObject> setCurrentRoleEntry = currentNodeRoles.stream().filter(role -> HRStringUtils.equals((String)FlowRuRoleStatusEnum.PENDING.getCode(), (String)role.getString("rolestatus")) || HRStringUtils.equals((String)FlowRuRoleStatusEnum.RUNNING.getCode(), (String)role.getString("rolestatus"))).collect(Collectors.toList());
                    WorkflowUtils.setCurrentRunRole(iterator, setCurrentRoleEntry);
                }
            }
            WorkflowUtils.updateStatus(iterator, "procstatus", FlowRuProcStatusEnum.RUNNING.getCode());
            flowParamBo.getRuProcColl().add(iterator);
        }
    }

    private void dealRoleAndTaskStatus(BatchFlowParamBo flowParamBo, DynamicObject ruRole, Map<Long, List<DynamicObject>> keyRoleValTasks, List<DynamicObject> roles) {
        for (DynamicObject role : roles) {
            long roleId = role.getLong("id");
            if (roleId == ruRole.getLong("id")) {
                WorkflowUtils.updateStatus(role, "rolestatus", FlowRuRoleStatusEnum.RUNNING.getCode());
                flowParamBo.getRuRoleColl().add((Object)role);
                continue;
            }
            WorkflowUtils.updateStatus(role, "rolestatus", FlowRuRoleStatusEnum.RETURNED.getCode());
            flowParamBo.getRuRoleColl().add((Object)role);
            List<DynamicObject> lastTasks = keyRoleValTasks.get(roleId);
            WorkflowUtils.updateTaskStatus(lastTasks, FlowRuTaskStatusEnum.RETURNED.getCode());
            flowParamBo.getRuTaskColl().addAll(lastTasks);
        }
    }

    public FlowValidateResultBo resetProcs(List<Long> actEvalObjIds, String workflowType) {
        HashMap<Boolean, List<Long>> actEvalObjIdMap = new HashMap<Boolean, List<Long>>(16);
        actEvalObjIdMap.put(Boolean.TRUE, actEvalObjIds);
        return this.resetProcs(actEvalObjIdMap, workflowType);
    }

    public FlowValidateResultBo resetProcs(Map<Boolean, List<Long>> actEvalObjIdMap, String workflowType) {
        HashMap<Long, String> resultMap = new HashMap<Long, String>(16);
        HashMap<Long, Long> ruProcIdMap = new HashMap<Long, Long>(16);
        ArrayList<Long> actEvalObjIds = new ArrayList<Long>(10);
        List<Long> needPreCreateIds = actEvalObjIdMap.get(Boolean.TRUE);
        if (CollectionUtils.isNotEmpty(needPreCreateIds)) {
            actEvalObjIds.addAll(needPreCreateIds);
        }
        LOG.info("resetProcs buildFlowRuProcBosByObjIds start:" + actEvalObjIds.size());
        List<FlowRuProcBo> flowRuProcBos = EPA_ACTEVAOBJ_SERVICE.buildFlowRuProcBosByObjIds(actEvalObjIds, workflowType);
        LOG.info("resetProcs buildFlowRuProcBosByObjIds end:" + actEvalObjIds.size());
        List<Long> canResetEvalObjIds = flowRuProcBos.stream().map(FlowRuProcBo::getActEvalObjId).collect(Collectors.toList());
        List<Long> noNeedPreCreateIds = actEvalObjIdMap.get(Boolean.FALSE);
        if (CollectionUtils.isNotEmpty(noNeedPreCreateIds)) {
            canResetEvalObjIds.addAll(noNeedPreCreateIds);
            noNeedPreCreateIds.forEach(actEvalObjId -> ruProcIdMap.put((Long)actEvalObjId, 0L));
        }
        LOG.info("resetProcs update start:" + actEvalObjIds.size());
        DynamicObject[] ruProcs = FLOW_RU_PROC_ENTITY_SERVICE.loadRuProcByActEvalObjIds(canResetEvalObjIds, workflowType);
        WorkflowUtils.updateProcStatus(ruProcs, FlowRuProcStatusEnum.DEPRECATED.getCode());
        List<Long> procIds = Arrays.stream(ruProcs).map(proc -> proc.getLong("id")).distinct().collect(Collectors.toList());
        DynamicObject[] ruTasks = FLOW_RU_TASK_ENTITY_SERVICE.loadTasksByProcIds(procIds);
        DynamicObject[] rawRuTasks = FLOW_RU_TASK_ENTITY_SERVICE.loadTasksByRowProcIds(procIds);
        WorkflowUtils.updateTaskStatus(ruTasks, FlowRuTaskStatusEnum.EXPIRED.getCode());
        List<Long> currentNodeIds = Arrays.stream(ruProcs).filter(proc -> !HRObjectUtils.isEmpty((Object)proc.getDynamicObject("currentnode"))).map(proc -> proc.getDynamicObject("currentnode").getLong("id")).collect(Collectors.toList());
        DynamicObject[] nodes = FLOW_RU_NODE_ENTITY_SERVICE.loadRuNodeByIds(currentNodeIds);
        WorkflowUtils.updateNodeStatus(nodes, FlowRuNodeStatusEnum.EXPIRED.getCode());
        ArrayList<Long> currentRoleIds = new ArrayList<Long>(10);
        for (DynamicObject ruProc : ruProcs) {
            DynamicObjectCollection curRunRoleColl = ruProc.getDynamicObjectCollection("entryentity");
            Iterator iterator = curRunRoleColl.iterator();
            while (iterator.hasNext()) {
                DynamicObject entity = (DynamicObject)iterator.next();
                currentRoleIds.add(entity.getDynamicObject("ruroleid").getLong("id"));
            }
        }
        DynamicObject[] roles = FLOW_RU_ROLE_ENTITY_SERVICE.queryByRuProcIds(procIds);
        WorkflowUtils.updateRoleStatus(roles, FlowRuRoleStatusEnum.EXPIRED.getCode());
        DynamicObject[] currentRoles = (DynamicObject[])Arrays.stream(roles).filter(role -> currentRoleIds.contains(role.getLong("id"))).toArray(DynamicObject[]::new);
        WorkflowUtils.updateRoleStatus(currentRoles, FlowRuRoleStatusEnum.EXPIRED.getCode());
        LOG.info("resetProcs update end:" + actEvalObjIds.size());
        Map rawActevalObjTaskMap = Arrays.stream(rawRuTasks).filter(e -> !e.getBoolean("isdeleteop")).collect(Collectors.groupingBy(k -> k.getLong("flowruproc.actevalobj"), Collectors.toList()));
        Map rawActevalObjRoleMap = Arrays.stream(roles).collect(Collectors.groupingBy(k -> k.getLong("flowruproc.actevalobj"), Collectors.toList()));
        LOG.info("resetProcs all preCreateProcessInstance start:" + actEvalObjIds.size());
        for (FlowRuProcBo flowRuProcBo2 : flowRuProcBos) {
            Long actEvalObjId2 = flowRuProcBo2.getActEvalObjId();
            Long flowVid = flowRuProcBo2.getFlowVid();
            if (null == flowVid || 0L == flowVid) {
                DynamicObject person = flowRuProcBo2.getPerson();
                String validateMsg = MessageFormat.format(ResManager.loadKDString((String)"\u8bc4\u4f30\u5bf9\u8c61{0}\uff08\u5de5\u53f7\uff1a{1}\uff09\uff1a\u6d41\u7a0b\u201c\u91cd\u7f6e\u201d\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"FlowRuSecondDomainService_34", (String)"opmc-pbs-business", (Object[])new Object[0]), person.getString("name"), person.getString("number"));
                resultMap.put(actEvalObjId2, validateMsg);
                continue;
            }
            flowRuProcBo2.setRawTasks(rawActevalObjTaskMap.get(actEvalObjId2));
            flowRuProcBo2.setRawRoles(rawActevalObjRoleMap.get(actEvalObjId2));
        }
        FlowRuProcBatchDomainService FLOW_RU_PROC_BATCH_DOMAIN_SERVICE = new FlowRuProcBatchDomainService();
        CommonResultBo preCreInsResult = FLOW_RU_PROC_BATCH_DOMAIN_SERVICE.preCreateProcessInstance(flowRuProcBos, FLowOpEnum.RESET.getValue());
        Map preCreResultMap = preCreInsResult.getResultMap();
        preCreResultMap.keySet().stream().forEach(k -> {
            ruProcIdMap.computeIfPresent((Long)k, (key, val) -> (Long)preCreResultMap.get(k));
            ruProcIdMap.computeIfAbsent((Long)k, v -> (Long)preCreResultMap.get(k));
        });
        flowRuProcBos.stream().forEach(flowRuProcBo -> resultMap.computeIfAbsent(flowRuProcBo.getActEvalObjId(), v -> {
            if (!ruProcIdMap.containsKey(flowRuProcBo.getActEvalObjId())) {
                DynamicObject person = flowRuProcBo.getPerson();
                String validateMsg = MessageFormat.format(ResManager.loadKDString((String)"\u8bc4\u4f30\u5bf9\u8c61-{0}\uff08{1}\uff09\uff1a\u91cd\u7f6e\u5931\u8d25\uff0c\u8bf7\u8054\u7cfbIT\u7ba1\u7406\u5458", (String)"FlowRuSecondDomainService_22", (String)"opmc-pbs-business", (Object[])new Object[0]), person.getString("name"), person.getString("number"));
                return validateMsg;
            }
            return null;
        }));
        if (!ruProcIdMap.isEmpty()) {
            Set actEvalObjIdSet = ruProcIdMap.keySet();
            DynamicObject[] newRuProcs = (DynamicObject[])Arrays.stream(ruProcs).filter(proc -> !HRObjectUtils.isEmpty((Object)proc.getLong("actevalobj"))).filter(proc -> actEvalObjIdSet.contains(proc.getLong("actevalobj"))).toArray(DynamicObject[]::new);
            List canUpdateProcIds = Arrays.stream(newRuProcs).map(proc -> proc.getLong("id")).collect(Collectors.toList());
            DynamicObject[] newNodes = (DynamicObject[])Arrays.stream(nodes).filter(node -> canUpdateProcIds.contains(node.getLong("flowruproc.id"))).toArray(DynamicObject[]::new);
            DynamicObject[] newCurrentRoles = (DynamicObject[])Arrays.stream(currentRoles).filter(node -> canUpdateProcIds.contains(node.getLong("flowruproc.id"))).toArray(DynamicObject[]::new);
            DynamicObject[] newRuTasks = (DynamicObject[])Arrays.stream(ruTasks).filter(node -> canUpdateProcIds.contains(node.getLong("flowruproc.id"))).toArray(DynamicObject[]::new);
            FLOW_RU_PROC_ENTITY_SERVICE.save(newRuProcs);
            FLOW_RU_NODE_ENTITY_SERVICE.save(newNodes);
            FLOW_RU_ROLE_ENTITY_SERVICE.save(newCurrentRoles);
            FLOW_RU_TASK_ENTITY_SERVICE.save(newRuTasks);
        }
        LOG.info("resetProcs all preCreateProcessInstance end:" + actEvalObjIds.size());
        FlowValidateResultBo resultBo = new FlowValidateResultBo();
        resultBo.setRuProcIdMap(ruProcIdMap);
        resultBo.setCode(resultMap.isEmpty() ? "1" : "-1");
        resultBo.setValidateMap(resultMap);
        return resultBo;
    }

    public DynamicObject[] queryTaskByIds(List<Long> taskIds) {
        return FLOW_RU_TASK_ENTITY_SERVICE.queryTasksByIds(taskIds);
    }

    public NodeIdAndTaskIdMapVO getNodeIdAndTaskIdMapVO(List<Long> taskIds) {
        DynamicObject[] taskDys = FLOW_RU_TASK_ENTITY_SERVICE.queryTasksByIds(taskIds);
        List<Long> nodeIds = Arrays.stream(taskDys).map(taskDy -> taskDy.getLong("flowrunode.id")).collect(Collectors.toList());
        Map<Long, Long> tasknodeIdMap = Arrays.stream(taskDys).collect(Collectors.toMap(taskDy -> taskDy.getLong("id"), y -> y.getLong("flowrunode.id")));
        return new NodeIdAndTaskIdMapVO(nodeIds, tasknodeIdMap);
    }

    public DynamicObject[] queryTaskIndicators(List<Long> taskIdList, Long areaInsId) {
        QFilter filter = new QFilter("id", "in", taskIdList);
        filter.and(new QFilter("entryentity.arearegid", "=", (Object)areaInsId));
        return FLOW_RU_TASK_ENTITY_SERVICE.queryOriginalArray("id,entryentity.indicatorid", new QFilter[]{filter});
    }

    public DynamicObject[] queryTaskIndicators(List<Long> taskIdList) {
        QFilter filter = new QFilter("id", "in", taskIdList);
        return FLOW_RU_TASK_ENTITY_SERVICE.queryOriginalArray("id,entryentity.arearegid,entryentity.indicatorid", new QFilter[]{filter});
    }

    public boolean judgeIsExistTargetOpByProcId(Long taskId, FLowOpEnum fLowOpEnum) {
        DynamicObject flowruproc;
        DynamicObject taskInfo = FLOW_RU_TASK_ENTITY_SERVICE.queryOne("flowruproc.id", new QFilter[]{QFilter.of((String)"id = ?", (Object[])new Object[]{taskId})});
        if (taskInfo != null && (flowruproc = taskInfo.getDynamicObject("flowruproc")) != null) {
            return FLOW_RU_OP_ENTITY_SERVICE.judgeIsExistTargetOpByProcId(flowruproc.getLong("id"), fLowOpEnum);
        }
        return false;
    }

    public DynamicObject queryTaskByPkValue(Long pkValue) {
        return FLOW_RU_TASK_ENTITY_SERVICE.queryTaskByPk(pkValue);
    }

    public boolean queryEffectiveTask(long ruNodeId, Long userId) {
        return FLOW_RU_TASK_ENTITY_SERVICE.queryEffectiveTask(ruNodeId, userId);
    }

    public void saveTask(DynamicObject ruTask) {
        FLOW_RU_TASK_ENTITY_SERVICE.saveOne(ruTask);
    }
}

