/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.pbs.business.domain.workflow.service;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.portal.util.SerializationUtils;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.pbs.business.ServiceFactory;
import kd.opmc.pbs.business.domain.msg.service.MergeMsgSendService;
import kd.opmc.pbs.business.domain.msg.service.MsgSendDomainService;
import kd.opmc.pbs.business.domain.workflow.entity.FlowCommonResultBo;
import kd.opmc.pbs.business.domain.workflow.entity.FlowPreTaskResultBo;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowDefNodeEntityService;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowDefProcEntityService;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowDefRoleEntityService;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowRuNodeEntityService;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowRuProcEntityService;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowRuRoleEntityService;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowRuTaskEntityService;
import kd.opmc.pbs.business.domain.workflow.entityservice.IndicatorRoleSetEntityService;
import kd.opmc.pbs.business.domain.workflow.entityservice.WorkFlowEntityService;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuMsgEnum;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuNodeStatusEnum;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuRoleStatusEnum;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuTaskStatusEnum;
import kd.opmc.pbs.business.domain.workflow.model.FlowRuNodeBo;
import kd.opmc.pbs.business.domain.workflow.model.FlowRuRoleBo;
import kd.opmc.pbs.business.domain.workflow.model.PreTaskParamBo;
import kd.opmc.pbs.business.domain.workflow.model.WorkflowInfoBo;
import kd.opmc.pbs.business.domain.workflow.model.WorkflowRuProcBo;
import kd.opmc.pbs.business.domain.workflow.service.FlowHandlerDomainService;
import kd.opmc.pbs.business.external.epa.IEPAActevalobjService;
import kd.opmc.pbs.business.model.MsgParamsBo;
import kd.opmc.pbs.business.model.NodeRoleConfigBo;
import kd.opmc.pbs.common.constants.NodeTypeConstants;

public class FlowRunSupDomainService {
    private static final Log LOG = LogFactory.getLog(FlowRunSupDomainService.class);
    private static final FlowRuNodeEntityService FLOW_RU_NODE_ENTITY_SERVICE = FlowRuNodeEntityService.getInstance();
    private static final FlowRuRoleEntityService FLOW_RU_ROLE_ENTITY_SERVICE = FlowRuRoleEntityService.getInstance();
    private static final FlowRuTaskEntityService FLOW_RU_TASK_ENTITY_SERVICE = FlowRuTaskEntityService.getInstance();
    private static final MsgSendDomainService MSG_SEND_DOMAIN_SERVICE = MsgSendDomainService.getInstance();
    private static final FlowRuProcEntityService FLOW_RU_PROC_ENTITY_SERVICE = FlowRuProcEntityService.getInstance();
    private static final FlowDefRoleEntityService FLOW_DEF_ROLE_ENTITY = FlowDefRoleEntityService.getInstance();
    private static final WorkFlowEntityService WORK_FLOW_ENTITY_SERVICE = WorkFlowEntityService.getInstance();
    private static final FlowDefProcEntityService FLOW_DEF_PROC_ENTITY_SERVICE = FlowDefProcEntityService.getInstance();
    private static final FlowDefNodeEntityService FLOW_DEF_NODE_ENTITY_SERVICE = FlowDefNodeEntityService.getInstance();
    private static final IndicatorRoleSetEntityService INDICATOR_ROLESET_ENTITYSERVICE = IndicatorRoleSetEntityService.getInstance();
    private static final IEPAActevalobjService EPA_ACTEVAOBJ_SERVICE = IEPAActevalobjService.getInstance();
    protected static final MergeMsgSendService MERGE_MSG_SEND_SERVICE = MergeMsgSendService.getInstance();

    public static FlowRunSupDomainService getInstance() {
        return ServiceFactory.getService(FlowRunSupDomainService.class);
    }

    public List<Long> getHandlerList(Long ruProcId, DynamicObject ruNode, DynamicObject ruRole, DynamicObject ruProc) {
        ArrayList<Long> handlerList = new ArrayList<Long>(10);
        FlowHandlerDomainService FLOW_HANDLER_DOMAIN_SERVICE = new FlowHandlerDomainService();
        Map<Long, List<Long>> procHandlerMap = FLOW_HANDLER_DOMAIN_SERVICE.batchQueryFlowRoleHandler(Collections.singletonList(ruProcId), ruRole.getLong("flowdefrole.id"), ruProc);
        List<Long> handlerIds = procHandlerMap.get(ruProcId);
        if (CollectionUtils.isEmpty(handlerIds)) {
            List<Long> nodeHandlerList;
            if (null != ruNode && null != ruNode.getDynamicObject("handlertype") && !CollectionUtils.isEmpty(nodeHandlerList = FLOW_HANDLER_DOMAIN_SERVICE.queryReplaceFlowRoleHandler(ruProcId, ruNode.getDynamicObject("handlertype").getLong("id"), ruRole))) {
                handlerList.addAll(nodeHandlerList);
            }
        } else {
            ruRole.set("rolestatus", (Object)FlowRuRoleStatusEnum.RUNNING.getCode());
            if (!CollectionUtils.isEmpty(handlerIds)) {
                handlerList.addAll(handlerIds);
            }
        }
        return handlerList;
    }

    public FlowCommonResultBo verifyHandlerBeforeStartProcess(List<Long> ruProcIds) {
        FlowCommonResultBo resultBo = new FlowCommonResultBo();
        HashMap<Long, List<Map<Long, String>>> resultMap = new HashMap<Long, List<Map<Long, String>>>(16);
        HashMap<Long, List<Map<Long, String>>> corssNodeMsgMap = new HashMap<Long, List<Map<Long, String>>>(16);
        String message = ResManager.loadKDString((String)"\u53ef\u4ee5\u542f\u52a8", (String)"FlowRunSupDomainService_0", (String)"opmc-pbs-business", (Object[])new Object[0]);
        DynamicObject[] flowruProcDyns = FlowRuProcEntityService.getInstance().queryProcByPkIds(ruProcIds);
        int code = 1;
        DynamicObjectCollection flowRuRoleColl = new DynamicObjectCollection();
        DynamicObject[] allRuNodeDyns = FLOW_RU_NODE_ENTITY_SERVICE.queryAllNodeByProcIds(ruProcIds.toArray(new Long[ruProcIds.size()]));
        Map<Object, Object> ruNodeMap = new HashMap(16);
        ruNodeMap = Arrays.stream(allRuNodeDyns).collect(Collectors.groupingBy(k -> k.getLong("flowruproc.id"), Collectors.mapping(v -> v, Collectors.toList())));
        List<Long> ruNodeIdList = Arrays.stream(allRuNodeDyns).map(k -> k.getLong("id")).collect(Collectors.toList());
        DynamicObject[] allRunRoles = FLOW_RU_ROLE_ENTITY_SERVICE.queryRolesByNodeIds(ruNodeIdList.toArray(new Long[ruNodeIdList.size()]));
        Map<Object, Object> ruRoleMap = new HashMap(16);
        ruRoleMap = Arrays.stream(allRunRoles).collect(Collectors.groupingBy(k -> k.getLong("flowrunode.id"), Collectors.mapping(v -> v, Collectors.toList())));
        List<Long> ruRoleIdList = Arrays.stream(allRunRoles).map(k -> k.getLong("id")).collect(Collectors.toList());
        DynamicObject[] allTaskDyns = FLOW_RU_TASK_ENTITY_SERVICE.queryTasksByRunRoleIds(ruRoleIdList);
        HashMap<Long, List<DynamicObject>> taskMap = new HashMap(16);
        taskMap = Arrays.stream(allTaskDyns).collect(Collectors.groupingBy(k -> k.getLong("flowrurole.id"), Collectors.mapping(v -> v, Collectors.toList())));
        for (DynamicObject ruProc : flowruProcDyns) {
            String settingmode = ruProc.getString("settingmode");
            ArrayList<Map<Long, String>> roleMsgList = new ArrayList<Map<Long, String>>(16);
            List ruNodeDyns = (List)ruNodeMap.get(ruProc.getLong("id"));
            for (DynamicObject ruNode : ruNodeDyns) {
                Boolean iscrossnode = ruNode.getBoolean("iscrossnode");
                if (iscrossnode.booleanValue()) {
                    code = this.validateCrossedNode(code, corssNodeMsgMap, ruNode, ruProc.getLong("actevalobj"));
                }
                if (iscrossnode.booleanValue() || !HRStringUtils.equals((String)settingmode, (String)"20")) continue;
                code = this.validateNoCrossedNode(code, flowRuRoleColl, roleMsgList, ruNode, (List)ruRoleMap.get(ruNode.getLong("id")), taskMap);
            }
            resultMap.put(ruProc.getLong("actevalobj"), roleMsgList);
        }
        if (CollectionUtils.isNotEmpty((Collection)flowRuRoleColl)) {
            FlowRuRoleEntityService.getInstance().save(flowRuRoleColl);
        }
        resultBo.setCode(String.valueOf(code));
        resultBo.setMsgMap(resultMap);
        resultBo.setCorssNodemsgMap(corssNodeMsgMap);
        if (-1 == code) {
            message = ResManager.loadKDString((String)"\u4e0d\u80fd\u542f\u52a8", (String)"FlowRunSupDomainService_1", (String)"opmc-pbs-business", (Object[])new Object[0]);
        }
        resultBo.setMessage(message);
        return resultBo;
    }

    private int validateCrossedNode(int code, Map<Long, List<Map<Long, String>>> corssNodeMsgMap, DynamicObject ruNode, Long evalObjId) {
        DynamicObject[] indicatorCrossDyArr;
        List indicatorCrossIdList;
        Map evalAndIndicatorMap = (Map)HRMServiceHelper.invokeBizService((String)"opmc", (String)"epa", (String)"IEPAActevalobjService", (String)"queryIndicatorByObjIds", (Object[])new Object[]{Collections.singletonList(evalObjId)});
        Map IndicatorMap = (Map)evalAndIndicatorMap.get(evalObjId);
        if (HRObjectUtils.isEmpty((Object)IndicatorMap)) {
            String validateErrorStr = MessageFormat.format(ResManager.loadKDString((String)"\u8282\u70b9\u201c{0}\u201d\uff0c\u65e0\u53ef\u914d\u7f6e\u7684\u6307\u6807\u3002", (String)"FlowRunSupDomainService_2", (String)"opmc-pbs-business", (Object[])new Object[0]), ruNode.getString("name"));
            this.setCrossNodeErrorInfo(corssNodeMsgMap, ruNode, evalObjId, validateErrorStr);
            return -1;
        }
        List<Long> indicatorIdList = IndicatorMap.entrySet().stream().map(entryEntity -> (Long)entryEntity.getKey()).collect(Collectors.toList());
        boolean isAllConfigWithIndicator = org.apache.commons.collections.CollectionUtils.isEqualCollection(indicatorIdList, indicatorCrossIdList = Arrays.asList(indicatorCrossDyArr = INDICATOR_ROLESET_ENTITYSERVICE.queryCrossRoleSet(ruNode.getDynamicObject("flownodedef").getLong("id"), indicatorIdList)).stream().map(indicatorDy -> indicatorDy.getLong("indicatorid")).distinct().collect(Collectors.toList()));
        if (!isAllConfigWithIndicator) {
            String validateErrorStr = MessageFormat.format(ResManager.loadKDString((String)"\u8282\u70b9\u201c{0}\u201d\uff0c\u8bf7\u914d\u7f6e\u6240\u6709\u6307\u6807\u7684\u5904\u7406\u4eba\u3002", (String)"FlowRunSupDomainService_3", (String)"opmc-pbs-business", (Object[])new Object[0]), ruNode.getString("name"));
            this.setCrossNodeErrorInfo(corssNodeMsgMap, ruNode, evalObjId, validateErrorStr);
            return -1;
        }
        return code;
    }

    private int validateHandlerIsEmpty(int code, Map<Long, List<Map<Long, String>>> corssNodeMsgMap, DynamicObject ruNode, Map<String, List<DynamicObject>> setNoAndRoleMap, Long evalObjId) {
        for (Map.Entry<String, List<DynamicObject>> entry : setNoAndRoleMap.entrySet()) {
            for (DynamicObject roleSetDy : entry.getValue()) {
                DynamicObjectCollection handlerEntryColl = roleSetDy.getDynamicObjectCollection("entryentity");
                for (DynamicObject handlerDy : handlerEntryColl) {
                    Long handler = handlerDy.getLong("handlerid.id");
                    if (null != handler && !handler.equals(0L)) continue;
                    String validateErrorStr = MessageFormat.format(ResManager.loadKDString((String)"\u8282\u70b9\u201c{0}\u201d\uff0c\u5b58\u5728\u5904\u7406\u4eba\u4e3a\u7a7a\uff0c\u8bf7\u5904\u7406\u3002", (String)"FlowRunSupDomainService_4", (String)"opmc-pbs-business", (Object[])new Object[0]), ruNode.getString("name"));
                    this.setCrossNodeErrorInfo(corssNodeMsgMap, ruNode, evalObjId, validateErrorStr);
                    return -1;
                }
            }
        }
        return code;
    }

    private void setCrossNodeErrorInfo(Map<Long, List<Map<Long, String>>> corssNodeMsgMap, DynamicObject ruNode, Long evalObjId, String validateErrorStr) {
        List<Map<Long, String>> nodeErrorDetailMap = corssNodeMsgMap.get(evalObjId);
        if (HRObjectUtils.isEmpty(nodeErrorDetailMap)) {
            nodeErrorDetailMap = new ArrayList<Map<Long, String>>(10);
        }
        HashMap<Long, String> crossNodeDetailMap = new HashMap<Long, String>(16);
        crossNodeDetailMap.put(ruNode.getLong("id"), validateErrorStr);
        nodeErrorDetailMap.add(crossNodeDetailMap);
        corssNodeMsgMap.put(evalObjId, nodeErrorDetailMap);
    }

    private int validateNoCrossedNode(int code, DynamicObjectCollection flowRuRoleColl, List<Map<Long, String>> roleMsgList, DynamicObject ruNode, List<DynamicObject> ruRoleDyns, Map<Long, List<DynamicObject>> taskMap) {
        String workflowType = ruNode.getString("flowruproc.workflowtype");
        for (DynamicObject ruRole : ruRoleDyns) {
            List<DynamicObject> taskDynList = taskMap.get(ruRole.get("id"));
            boolean isPending = Boolean.FALSE;
            for (DynamicObject task : taskDynList) {
                Long handler;
                String taskStatus = task.getString("taskstatus");
                if (HRStringUtils.equals((String)taskStatus, (String)FlowRuTaskStatusEnum.EXPIRED.getCode()) || null != (handler = Long.valueOf(task.getLong("handler.id"))) && !handler.equals(0L)) continue;
                isPending = true;
                break;
            }
            if (!isPending) continue;
            HashMap<Long, String> roleMsg = new HashMap<Long, String>(16);
            StringBuilder msgSb = new StringBuilder();
            String noHandlerMsg = "";
            noHandlerMsg = workflowType.equals("1") ? ResManager.loadKDString((String)"\u8282\u70b9\u201c%1$s\u201d\u7684\u89d2\u8272\u201c%2$s\u201d\u65e0\u5236\u5b9a\u4eba\u3002", (String)"FlowRunSupDomainService_6", (String)"opmc-pbs-business", (Object[])new Object[]{ruNode.getString("name"), ruRole.getString("name")}) : ResManager.loadKDString((String)"\u8282\u70b9\u201c%1$s\u201d\u7684\u89d2\u8272\u201c%2$s\u201d\u65e0\u8bc4\u4f30\u4eba\u3002", (String)"FlowRunSupDomainService_5", (String)"opmc-pbs-business", (Object[])new Object[]{ruNode.getString("name"), ruRole.getString("name")});
            msgSb.append(noHandlerMsg);
            roleMsg.put(ruRole.getLong("id"), msgSb.toString());
            code = -1;
            roleMsgList.add(roleMsg);
            ruRole.set("ishandlerempty", (Object)Boolean.TRUE);
            flowRuRoleColl.add((Object)ruRole);
        }
        return code;
    }

    public DynamicObject[] queryAllNodeByProcId(Long procId) {
        return FLOW_RU_NODE_ENTITY_SERVICE.queryAllNodeByProcId(procId);
    }

    public DynamicObject[] queryAllRoleByProcId(Long procId) {
        return FLOW_RU_ROLE_ENTITY_SERVICE.queryAllRoleByProcId(procId);
    }

    public DynamicObject[] queryAllTaskByProcId(Long procId) {
        return FLOW_RU_TASK_ENTITY_SERVICE.queryAllTaskByProcId(procId);
    }

    protected Map<Long, Function<MsgParamsBo, Boolean>> initNodeTypeMsgMap() {
        HashMap<Long, Function<MsgParamsBo, Boolean>> nodeTypeMsgMap = new HashMap<Long, Function<MsgParamsBo, Boolean>>(16);
        nodeTypeMsgMap.put(NodeTypeConstants.INDICATOR_FORMULATE, msgParamsBo -> {
            this.notifyHandlerForFormulate(msgParamsBo.getActEvaObj(), msgParamsBo.getTask(), FlowRuMsgEnum.FORMULATE_SIN, "epa_indicatormsg");
            return Boolean.TRUE;
        });
        nodeTypeMsgMap.put(NodeTypeConstants.INDICATOR_AUDIT, msgParamsBo -> {
            this.notifyHandlerForFormulate(msgParamsBo.getActEvaObj(), msgParamsBo.getTask(), FlowRuMsgEnum.FORMULATEAUDIT_SIN, "epa_indicatormsg");
            return Boolean.TRUE;
        });
        nodeTypeMsgMap.put(NodeTypeConstants.INDICATOR_CONFIRM, msgParamsBo -> {
            this.notifyHandlerForFormulate(msgParamsBo.getActEvaObj(), msgParamsBo.getTask(), FlowRuMsgEnum.FORMULATECONFIRM_SIN, "epa_indicatormsg");
            return Boolean.TRUE;
        });
        nodeTypeMsgMap.put(NodeTypeConstants.EVALUATE_SCORE, msgParamsBo -> {
            this.notifyHandler(msgParamsBo.getRuProc(), msgParamsBo.getTask(), msgParamsBo.getTask().getBoolean("isreplace") ? FlowRuMsgEnum.REPLACE : FlowRuMsgEnum.START);
            return Boolean.TRUE;
        });
        nodeTypeMsgMap.put(NodeTypeConstants.BATCH_EVALUSUMSCORE, msgParamsBo -> {
            this.notifyHandler(msgParamsBo.getRuProc(), msgParamsBo.getTask(), msgParamsBo.getTask().getBoolean("isreplace") ? FlowRuMsgEnum.REPLACE : FlowRuMsgEnum.START);
            return Boolean.TRUE;
        });
        nodeTypeMsgMap.put(NodeTypeConstants.BATCH_ADJUSTSUMSCORE, msgParamsBo -> {
            this.notifyHandler(msgParamsBo.getRuProc(), msgParamsBo.getTask(), msgParamsBo.getTask().getBoolean("isreplace") ? FlowRuMsgEnum.REPLACE : FlowRuMsgEnum.START);
            return Boolean.TRUE;
        });
        nodeTypeMsgMap.put(NodeTypeConstants.EVALUATE_AUDIT, msgParamsBo -> {
            this.notifyHandler(msgParamsBo.getRuProc(), msgParamsBo.getTask(), msgParamsBo.getTask().getBoolean("isreplace") ? FlowRuMsgEnum.REPLACE : FlowRuMsgEnum.START);
            return Boolean.TRUE;
        });
        return nodeTypeMsgMap;
    }

    protected void notifyHandler(DynamicObject ruProc, DynamicObject task, FlowRuMsgEnum flowRuMsgEnum) {
        long handlerId = task.getLong("handler.id");
        if (handlerId == 0L) {
            handlerId = task.getLong("handler");
        }
        HashMap urlParams = Maps.newHashMapWithExpectedSize((int)3);
        urlParams.put("formId", "epa_actevalobj_evalmsg");
        urlParams.put("pkId", ruProc.getString("actevalobj"));
        urlParams.put("taskId", task.getPkValue().toString());
        urlParams.put("batchTaskId", task.getPkValue().toString());
        MSG_SEND_DOMAIN_SERVICE.sendMessageWithUrl(flowRuMsgEnum.getTemplateId(), Collections.singletonList(handlerId), ruProc, urlParams, flowRuMsgEnum.getTag());
    }

    private void notifyHandlerForFormulate(DynamicObject actEvaObj, DynamicObject task, FlowRuMsgEnum flowRuMsgEnum, String formId) {
        long handlerId = task.getLong("handler.id");
        if (handlerId == 0L) {
            handlerId = task.getLong("handler");
        }
        HashMap urlParams = Maps.newHashMapWithExpectedSize((int)3);
        urlParams.put("formId", formId);
        urlParams.put("pkId", actEvaObj.getString("id"));
        urlParams.put("taskId", task.getPkValue().toString());
        MSG_SEND_DOMAIN_SERVICE.sendMessageWithUrl(flowRuMsgEnum.getTemplateId(), Collections.singletonList(handlerId), actEvaObj, urlParams, flowRuMsgEnum.getTag());
    }

    public NodeRoleConfigBo queryNodeRoleConfigByTask(Long taskId) {
        if (null == taskId || taskId == 0L) {
            return null;
        }
        DynamicObject taskDy = this.queryTaskByPk(taskId);
        long flowDefRoleId = taskDy.getLong("flowrurole.flowdefrole.id");
        DynamicObject flowDefRole = FLOW_DEF_ROLE_ENTITY.queryOne(flowDefRoleId);
        String confJson = flowDefRole.getString("confjson");
        return (NodeRoleConfigBo)SerializationUtils.fromJsonString((String)confJson, NodeRoleConfigBo.class);
    }

    public Map<Long, NodeRoleConfigBo> queryNodeRoleConfigByTask(Set<Long> flowDefRoleIds) {
        HashMap<Long, NodeRoleConfigBo> nodeRoleConfigBoMap = new HashMap<Long, NodeRoleConfigBo>(16);
        QFilter qFilter = new QFilter("id", "in", flowDefRoleIds);
        DynamicObject[] flowDefRoles = FLOW_DEF_ROLE_ENTITY.query("id,confjson", new QFilter[]{qFilter});
        if (flowDefRoles != null) {
            for (DynamicObject flowDefRole : flowDefRoles) {
                String confJson;
                if (flowDefRole == null || StringUtils.isBlank((String)(confJson = flowDefRole.getString("confjson")))) continue;
                NodeRoleConfigBo nodeRoleConfigBo = (NodeRoleConfigBo)SerializationUtils.fromJsonString((String)confJson, NodeRoleConfigBo.class);
                nodeRoleConfigBoMap.put(flowDefRole.getLong("id"), nodeRoleConfigBo);
            }
        }
        return nodeRoleConfigBoMap;
    }

    public DynamicObject queryNodeRoleByTask(Long taskId) {
        if (null == taskId || taskId == 0L) {
            return null;
        }
        DynamicObject taskDy = this.queryTaskByPk(taskId);
        long flowDefRoleId = taskDy.getLong("flowrurole.flowdefrole.id");
        DynamicObject flowDefRole = FLOW_DEF_ROLE_ENTITY.queryOne(flowDefRoleId);
        return flowDefRole;
    }

    public BigDecimal queryTaskWeight(Long taskId) {
        DynamicObject task = FLOW_RU_TASK_ENTITY_SERVICE.queryOriginalTaskByPk(taskId);
        int count = FLOW_RU_TASK_ENTITY_SERVICE.countValidTaskByRoleId(task.getLong("flowrurole"));
        if (count == 0) {
            return BigDecimal.ONE;
        }
        return BigDecimal.ONE.divide(new BigDecimal(count), 6, 4);
    }

    public Map<Long, BigDecimal> queryRoleWeightByNodeId(Long ruNodeId) {
        DynamicObject[] ruRoles = FLOW_RU_ROLE_ENTITY_SERVICE.queryRoleWeightByNodeId(ruNodeId);
        HashMap roleWeightMap = Maps.newHashMapWithExpectedSize((int)ruRoles.length);
        for (DynamicObject ruRole : ruRoles) {
            roleWeightMap.put(ruRole.getLong("id"), ruRole.getBigDecimal("roleweight"));
        }
        return roleWeightMap;
    }

    public Long queryNodeId(Long taskId) {
        DynamicObject task = FLOW_RU_TASK_ENTITY_SERVICE.queryOriginalTaskByPk(taskId);
        return task.getLong("flowrunode");
    }

    public Map<Long, BigDecimal> queryNodeWeightByProcId(Long ruProcId) {
        DynamicObject[] ruNodes = FLOW_RU_NODE_ENTITY_SERVICE.queryNodeWeightByProcId(ruProcId);
        HashMap nodeWeightMap = Maps.newHashMapWithExpectedSize((int)ruNodes.length);
        for (DynamicObject ruNode : ruNodes) {
            nodeWeightMap.put(ruNode.getLong("id"), ruNode.getBigDecimal("nodeweight"));
        }
        return nodeWeightMap;
    }

    public Map<Long, List<DynamicObject>> queryTaskByNodeIds(List<Long> nodeIds) {
        DynamicObject[] taskByNodeIds = FLOW_RU_TASK_ENTITY_SERVICE.queryTaskByNodeIds(nodeIds);
        return Arrays.stream(taskByNodeIds).collect(Collectors.groupingBy(task -> task.getLong("flowrunode")));
    }

    public Map<Long, List<DynamicObject>> queryCanSetHandlerTaskByNodeIds(List<Long> nodeIds) {
        DynamicObject[] taskByNodeIds = FLOW_RU_TASK_ENTITY_SERVICE.queryCanSetHandlerTaskByNodeIds(nodeIds);
        return Arrays.stream(taskByNodeIds).collect(Collectors.groupingBy(task -> task.getLong("flowrunode")));
    }

    public DynamicObject queryTaskByPk(Long taskId) {
        return FLOW_RU_TASK_ENTITY_SERVICE.queryTaskByPk(taskId);
    }

    public DynamicObject[] queryTaskByPks(List<Long> taskIds) {
        return FLOW_RU_TASK_ENTITY_SERVICE.queryTaskByPks(taskIds);
    }

    public DynamicObject[] queryProcByProcIds(List<Long> procIds) {
        return FLOW_RU_PROC_ENTITY_SERVICE.queryProcByPkIds(procIds);
    }

    public Long queryLastNodeTaskByRoleProp(Long taskId, String prop) {
        DynamicObject task = FLOW_RU_TASK_ENTITY_SERVICE.queryOriginalTaskByPk(taskId);
        Long procId = task.getLong("flowruproc");
        int index = task.getInt("flowrunode.index");
        if (index == 1) {
            return null;
        }
        Long preNodeId = (Long)FLOW_RU_NODE_ENTITY_SERVICE.queryRuNodeByIndex(procId, index - 1).getPkValue();
        if (StringUtils.isEmpty((String)prop)) {
            return FLOW_RU_TASK_ENTITY_SERVICE.queryLastTaskByNodeId(preNodeId).getLong("id");
        }
        DynamicObject ruRole = FLOW_RU_ROLE_ENTITY_SERVICE.queryRoleByProp(preNodeId, prop);
        if (ruRole != null) {
            return FLOW_RU_TASK_ENTITY_SERVICE.queryLastTaskByRoleId(ruRole.getLong("id")).getLong("id");
        }
        return null;
    }

    public List<Long> queryLevelTask(Long ruProcId) {
        DynamicObject ruRole = FLOW_RU_ROLE_ENTITY_SERVICE.queryGradeRole(ruProcId);
        ArrayList<Long> taskIdList = new ArrayList<Long>();
        if (ruRole != null) {
            DynamicObject[] tasks;
            for (DynamicObject task : tasks = FLOW_RU_TASK_ENTITY_SERVICE.queryTaskByRoleId(ruRole.getLong("id"))) {
                taskIdList.add(task.getLong("id"));
            }
        }
        return taskIdList;
    }

    public String queryProcStatus(Long ruProcId) {
        return FLOW_RU_PROC_ENTITY_SERVICE.queryProcStatus(ruProcId).getString("procstatus");
    }

    protected void sendPendingMsg(DynamicObject ruProc) {
        Map<Object, Object> objPerffileNames = Maps.newHashMapWithExpectedSize((int)1);
        DynamicObject[] workflows = WorkFlowEntityService.getInstance().getWorkFlowsByDefProcId(new HashSet<Long>(Collections.singleton(ruProc.getLong("defproc.id"))));
        HashMap urlParams = Maps.newHashMapWithExpectedSize((int)2);
        urlParams.put("formId", "pbs_flowrumonitor");
        urlParams.put("pkId", ruProc.getPkValue().toString());
        long userId = ruProc.getLong("creator.id");
        objPerffileNames = HRStringUtils.equals((String)ruProc.getString("workflowtype"), (String)"3") ? EPA_ACTEVAOBJ_SERVICE.queryInterViewObjPerffileNamesByObjIds(Collections.singletonList(ruProc.getLong("actevalobj"))) : EPA_ACTEVAOBJ_SERVICE.queryActEvalObjPerffileNamesByObjIds(Collections.singletonList(ruProc.getLong("actevalobj")));
        if (userId == 0L) {
            userId = ruProc.getLong("creator");
        }
        urlParams.put("actevalobj", HRStringUtils.isEmpty((String)((String)objPerffileNames.get(ruProc.getLong("actevalobj")))) ? "" : (String)objPerffileNames.get(ruProc.getLong("actevalobj")));
        urlParams.put("procname", HRStringUtils.isEmpty((String)((String)objPerffileNames.get(ruProc.getLong("actevalobj")))) ? "" : (String)objPerffileNames.get(ruProc.getLong("actevalobj")) + (workflows.length != 0 ? workflows[0].getString("name") : ruProc.getString("defproc.name")));
        MERGE_MSG_SEND_SERVICE.sendMessageWithUrl(FlowRuMsgEnum.PENDING.getTemplateId(), Collections.singletonList(userId), ruProc, urlParams, FlowRuMsgEnum.PENDING.getTag());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean changeHandler(Long ruTaskId, Long newHandlerId) {
        DynamicObject oldTask = FLOW_RU_TASK_ENTITY_SERVICE.queryTaskByPk(ruTaskId);
        String taskStatus = oldTask.getString("taskstatus");
        if (!FlowRuTaskStatusEnum.WAITING.getCode().equals(taskStatus) && !FlowRuTaskStatusEnum.PROCESSING.getCode().equals(taskStatus)) {
            return false;
        }
        Date date = new Date();
        long userId = UserServiceHelper.getCurrentUserId();
        this.updateTaskStatus(oldTask, FlowRuTaskStatusEnum.EXPIRED.getCode(), date, userId);
        DynamicObject newTask = FLOW_RU_TASK_ENTITY_SERVICE.generateTaskByOldTask(oldTask, date, userId, newHandlerId);
        try (TXHandle txhandle = TX.required();){
            FLOW_RU_TASK_ENTITY_SERVICE.saveOne(oldTask);
            FLOW_RU_TASK_ENTITY_SERVICE.saveOne(newTask);
        }
        FlowRunSupDomainService.getInstance().notifyHandler(oldTask.getDynamicObject("flowruproc"), newTask, FlowRuMsgEnum.START);
        return true;
    }

    protected void updateTaskStatus(DynamicObject task, String taskStatus, Date date, long userId) {
        task.set("taskstatus", (Object)taskStatus);
        task.set("updatestatustime", (Object)date);
        task.set("modifier", (Object)userId);
        task.set("modifytime", (Object)date);
    }

    public void updateTaskStatus(DynamicObject[] tasks, String taskStatus) {
        Date date = new Date();
        long userId = UserServiceHelper.getCurrentUserId();
        for (DynamicObject task : tasks) {
            this.updateTaskStatus(task, taskStatus, date, userId);
        }
    }

    protected boolean activeRuRole(DynamicObject ruNode, DynamicObject ruProc, DynamicObject[] nextToActiveRoles) {
        boolean isRolePending = Boolean.FALSE;
        Long ruNodeId = (Long)ruNode.getPkValue();
        DynamicObject ruRoles = nextToActiveRoles;
        if (null == ruRoles || ((DynamicObject[])ruRoles).length == 0) {
            ruRoles = FLOW_RU_ROLE_ENTITY_SERVICE.queryNeedActiveRunRoleByNodeId(ruNodeId);
        }
        if (null == ruRoles || ((DynamicObject[])ruRoles).length == 0) {
            String msg = String.format("activeRuRole: runtime role is missing, ruNodeId:%s", ruNodeId);
            LOG.error(msg);
            throw new KDException(new ErrorCode("activeRuRole", msg), new Object[0]);
        }
        ArrayList<DynamicObject> taskList = new ArrayList<DynamicObject>(((DynamicObject[])ruRoles).length);
        Date date = new Date();
        long userId = UserServiceHelper.getCurrentUserId();
        Long ruProcId = (Long)ruProc.getPkValue();
        List<Long> ruRoleIds = Arrays.stream(ruRoles).map(o -> o.getLong("id")).collect(Collectors.toList());
        DynamicObject[] taskDynsTmp = FLOW_RU_TASK_ENTITY_SERVICE.queryTasksByRunRoleIds(ruRoleIds);
        HashMap ruRoleTaskMap = new HashMap(16);
        for (DynamicObject taskDyn : taskDynsTmp) {
            List<Object> taskTmpList;
            if (CollectionUtils.isEmpty((Collection)((Collection)ruRoleTaskMap.get(taskDyn.getLong("flowrurole.id"))))) {
                taskTmpList = new ArrayList<DynamicObject>(10);
                taskTmpList.add(taskDyn);
                ruRoleTaskMap.put(taskDyn.getLong("flowrurole.id"), taskTmpList);
                continue;
            }
            taskTmpList = (List)ruRoleTaskMap.get(taskDyn.getLong("flowrurole.id"));
            taskTmpList.add(taskDyn);
            ruRoleTaskMap.put(taskDyn.getLong("flowrurole.id"), taskTmpList);
        }
        ArrayList<Long> handlerIdList = new ArrayList<Long>(10);
        for (Map.Entry taskEntry : ruRoleTaskMap.entrySet()) {
            for (DynamicObject taskDyn : (List)taskEntry.getValue()) {
                handlerIdList.add(taskDyn.getLong("handler.id"));
            }
        }
        FlowHandlerDomainService FLOW_HANDLER_DOMAIN_SERVICE = new FlowHandlerDomainService();
        Map<Long, Boolean> userValidMap = FLOW_HANDLER_DOMAIN_SERVICE.batchQueryUserIsEnable(handlerIdList);
        ArrayList allRoleTaskList = new ArrayList(10);
        for (DynamicObject ruRole : ruRoles) {
            ArrayList<DynamicObject> addTaskList = new ArrayList<DynamicObject>(10);
            boolean isPending = Boolean.FALSE;
            if (!(ruNode.getInt("index") == 1 || FlowRuRoleStatusEnum.NOT_ACTIVE.getCode().equals(ruRole.getString("rolestatus")) || FlowRuRoleStatusEnum.BE_WAITTING.getCode().equals(ruRole.getString("rolestatus")) || FlowRuRoleStatusEnum.RETURNED.getCode().equals(ruRole.getString("rolestatus")) || FlowRuRoleStatusEnum.PENDING.getCode().equals(ruRole.getString("rolestatus")))) {
                String msg = String.format("activeRuRole: runtime role status is invalid, ruRoleId:%s", ruRole.getPkValue());
                LOG.error(msg);
                throw new KDException(new ErrorCode("activeRuRole", msg), new Object[0]);
            }
            List taskTempList = (List)ruRoleTaskMap.get(ruRole.getLong("id"));
            if (!HRStringUtils.isEmpty((String)ruRole.getString("issethandler")) && "1".equals(ruRole.getString("issethandler")) || !CollectionUtils.isEmpty((Collection)taskTempList)) {
                DynamicObject[] taskDynArr;
                for (DynamicObject taskDyn : taskDynArr = taskTempList.toArray(new DynamicObject[0])) {
                    if (taskDyn.getString("taskstatus").equals(FlowRuTaskStatusEnum.EXPIRED.getCode()) || taskDyn.getString("taskstatus").equals(FlowRuTaskStatusEnum.PROCESSED.getCode())) continue;
                    taskDyn.set("modifier", (Object)userId);
                    taskDyn.set("modifytime", (Object)date);
                    Long handler = taskDyn.getLong("handler.id");
                    if (handler.equals(0L) || !userValidMap.isEmpty() && null != userValidMap.get(handler) && !userValidMap.get(handler).booleanValue()) {
                        isPending = true;
                        taskDyn.set("taskstatus", (Object)FlowRuTaskStatusEnum.PENDING.getCode());
                    } else if (ruNode.getBoolean("flownodedef.manualop")) {
                        taskDyn.set("taskstatus", (Object)FlowRuTaskStatusEnum.BE_WAITTING.getCode());
                    } else {
                        taskDyn.set("taskstatus", (Object)FlowRuTaskStatusEnum.WAITING.getCode());
                    }
                    taskDyn.set("isrollbacked", (Object)0);
                    taskDyn.set("updatestatustime", (Object)date);
                }
                FLOW_RU_TASK_ENTITY_SERVICE.save(taskDynArr);
                Collections.addAll(taskList, taskDynArr);
            } else {
                Map<Long, List<Long>> procHandlerMap = FLOW_HANDLER_DOMAIN_SERVICE.batchQueryFlowRoleHandler(Collections.singletonList(ruProcId), ruRole.getLong("flowdefrole.id"), ruProc);
                List<Long> handlerIds = procHandlerMap.get(ruProcId);
                if (CollectionUtils.isEmpty(handlerIds) || handlerIds.size() == 1 && handlerIds.get(0).equals(0L)) {
                    String msg = String.format("batchQueryFlowRoleHandler: not found handler, roleId:%s", ruRole.getLong("id"));
                    LOG.error(msg);
                    List<Long> nodeHandlerList = new ArrayList<Long>(10);
                    if (null != ruNode.getDynamicObject("handlertype")) {
                        nodeHandlerList = FLOW_HANDLER_DOMAIN_SERVICE.queryReplaceFlowRoleHandler(ruProcId, ruNode.getDynamicObject("handlertype").getLong("id"), ruRole);
                    }
                    if (CollectionUtils.isEmpty(nodeHandlerList)) {
                        String nodeHandlerMsg = String.format("queryReplaceFlowRoleHandler: not found handler, roleId:%s", ruRole.getLong("id"));
                        LOG.error(nodeHandlerMsg);
                        isPending = true;
                        ruRole.set("rolestatus", (Object)FlowRuRoleStatusEnum.PENDING.getCode());
                        if ("10".equals(ruProc.getString("settingmode"))) {
                            nodeHandlerList = new ArrayList(10);
                            nodeHandlerList.add(0L);
                            List<DynamicObject> defaultTaskList = FLOW_RU_TASK_ENTITY_SERVICE.generateTaskByRuRole(ruNode, ruRole, nodeHandlerList, true);
                            taskList.addAll(defaultTaskList);
                            addTaskList.addAll(defaultTaskList);
                            String emptyTaskMsg = String.format("auto mode create empty handler task,roleId :%s", ruRole.getLong("id"));
                            LOG.error(emptyTaskMsg);
                        }
                    } else {
                        List<DynamicObject> replaceTaskList = FLOW_RU_TASK_ENTITY_SERVICE.generateTaskByRuRole(ruNode, ruRole, nodeHandlerList, true);
                        taskList.addAll(replaceTaskList);
                        addTaskList.addAll(replaceTaskList);
                    }
                } else {
                    ruRole.set("rolestatus", (Object)FlowRuRoleStatusEnum.RUNNING.getCode());
                    List<DynamicObject> roleTaskList = FLOW_RU_TASK_ENTITY_SERVICE.generateTaskByRuRole(ruNode, ruRole, handlerIds, false);
                    taskList.addAll(roleTaskList);
                    addTaskList.addAll(roleTaskList);
                }
            }
            ruRole.set("rolestatus", (Object)FlowRuRoleStatusEnum.RUNNING.getCode());
            allRoleTaskList.addAll(addTaskList);
            for (DynamicObject task : addTaskList) {
                if (task.getString("taskstatus").equals(FlowRuTaskStatusEnum.PENDING.getCode())) {
                    isPending = Boolean.TRUE;
                    break;
                }
                if (ruNode.getBoolean("flownodedef.manualop")) {
                    task.set("taskstatus", (Object)FlowRuTaskStatusEnum.BE_WAITTING.getCode());
                    continue;
                }
                task.set("taskstatus", (Object)FlowRuTaskStatusEnum.WAITING.getCode());
            }
            if (isPending) {
                isRolePending = Boolean.TRUE;
                ruRole.set("rolestatus", (Object)FlowRuRoleStatusEnum.PENDING.getCode());
            }
            ruRole.set("updatestatustime", (Object)date);
            ruRole.set("modifier", (Object)userId);
            ruRole.set("modifytime", (Object)date);
        }
        if (allRoleTaskList.size() > 0) {
            DynamicObject[] tasks = allRoleTaskList.toArray(new DynamicObject[0]);
            FLOW_RU_TASK_ENTITY_SERVICE.save(tasks);
        }
        FLOW_RU_ROLE_ENTITY_SERVICE.save((DynamicObject[])ruRoles);
        return isRolePending;
    }

    protected boolean activeRuNode(DynamicObject ruNode, DynamicObject ruProc) {
        boolean isPending;
        if (!(FlowRuNodeStatusEnum.NOT_ACTIVE.getCode().equals(ruNode.getString("nodestatus")) || FlowRuNodeStatusEnum.BE_WAITTING.getCode().equals(ruNode.getString("nodestatus")) || FlowRuNodeStatusEnum.RETURNED.getCode().equals(ruNode.getString("nodestatus")))) {
            String msg = String.format("activeRuNode: runtime node status is invalid, ruNodeId:%s", ruNode.getPkValue());
            LOG.error(msg);
            isPending = Boolean.TRUE;
        } else {
            isPending = this.activeRuRole(ruNode, ruProc, null);
        }
        if (isPending) {
            ruNode.set("nodestatus", (Object)FlowRuNodeStatusEnum.PENDING.getCode());
            if (!"3".equals(ruProc.getString("workflowtype"))) {
                this.sendPendingMsg(ruProc);
            }
        } else {
            ruNode.set("nodestatus", (Object)FlowRuNodeStatusEnum.RUNNING.getCode());
        }
        Date date = new Date();
        ruNode.set("starttime", (Object)date);
        ruNode.set("updatestatustime", (Object)date);
        ruNode.set("modifier", (Object)UserServiceHelper.getCurrentUserId());
        ruNode.set("modifytime", (Object)date);
        FLOW_RU_NODE_ENTITY_SERVICE.saveOne(ruNode);
        return isPending;
    }

    public List<FlowRuRoleBo> getRoleByProcIdAndNodeId(Long ruProcId, Long ruNodeId) {
        if (null != ruProcId && ruProcId != 0L && null != ruNodeId && ruNodeId != 0L) {
            DynamicObject[] roleDefs = FLOW_RU_ROLE_ENTITY_SERVICE.queryRoleByProcIdAndNodeId(ruProcId, ruNodeId);
            ArrayList<FlowRuRoleBo> flowRuRoleBoList = new ArrayList<FlowRuRoleBo>(roleDefs.length);
            for (DynamicObject roRole : roleDefs) {
                long roRoleId = roRole.getLong("id");
                FlowRuRoleBo flowRuRoleBo = this.getRuRoleInstance(roRoleId);
                flowRuRoleBoList.add(flowRuRoleBo);
            }
            return flowRuRoleBoList;
        }
        String message = MessageFormat.format(ResManager.loadKDString((String)"\u6d41\u7a0b\u5b9e\u4f8bID\uff1a\u201c{0}\u201d\uff0c\u8282\u70b9\u5b9e\u4f8bID\uff1a\u201c{1}\u201d\uff0c\u5165\u53c2\u6821\u9a8c\u4e0d\u901a\u8fc7\u3002", (String)"FlowRunSupDomainService_14", (String)"opmc-pbs-business", (Object[])new Object[0]), ruProcId, ruNodeId);
        LOG.error(message);
        return new ArrayList<FlowRuRoleBo>();
    }

    public List<WorkflowRuProcBo> getAllNodesByActevalobjId(Long actEvalObjId) {
        if (null != actEvalObjId && actEvalObjId != 0L) {
            ArrayList<Long> actEvalObjIds = new ArrayList<Long>();
            actEvalObjIds.add(actEvalObjId);
            DynamicObject[] ruProcs = FLOW_RU_PROC_ENTITY_SERVICE.queryProcByEvaObjIds(actEvalObjIds);
            ArrayList<WorkflowRuProcBo> flowRuProcBoList = new ArrayList<WorkflowRuProcBo>(ruProcs.length);
            for (DynamicObject ruProc : ruProcs) {
                WorkflowRuProcBo flowRuProcBo = this.getRuProcInstance(ruProc.getLong("id"));
                flowRuProcBoList.add(flowRuProcBo);
            }
            return flowRuProcBoList;
        }
        String message = MessageFormat.format(ResManager.loadKDString((String)"\u8bc4\u4f30\u5bf9\u8c61ID\uff1a\u201c{0}\u201d\uff0c\u5165\u53c2\u6821\u9a8c\u4e0d\u901a\u8fc7\u3002", (String)"FlowRunSupDomainService_15", (String)"opmc-pbs-business", (Object[])new Object[0]), actEvalObjId);
        LOG.error(message);
        return new ArrayList<WorkflowRuProcBo>();
    }

    public WorkflowInfoBo getFlowInfoByActObjId(List<Long> actEvalObjIds) {
        WorkflowInfoBo workflowInfoBo = new WorkflowInfoBo();
        if (CollectionUtils.isEmpty(actEvalObjIds)) {
            String message = MessageFormat.format(ResManager.loadKDString((String)"\u8bc4\u4f30\u5bf9\u8c61ID\uff1a\u201c{0}\u201d\uff0c\u5165\u53c2\u6821\u9a8c\u4e0d\u901a\u8fc7\u3002", (String)"FlowRunSupDomainService_15", (String)"opmc-pbs-business", (Object[])new Object[0]), actEvalObjIds);
            LOG.warn(message);
            workflowInfoBo.setKeyActObjIdValProc(new HashMap<Long, List<DynamicObject>>(16));
            workflowInfoBo.setKeyProcIdValNode(new HashMap<Long, List<DynamicObject>>(16));
            workflowInfoBo.setKeyNodeIdValTask(new HashMap<Long, List<DynamicObject>>(16));
            workflowInfoBo.setKeyTaskIdValRole(new HashMap<Long, DynamicObject>(16));
        } else {
            DynamicObject[] ruProcs = FLOW_RU_PROC_ENTITY_SERVICE.queryProcByActObjIds(actEvalObjIds);
            Map<Long, List<DynamicObject>> keyActObjIdValProc = Arrays.stream(ruProcs).collect(Collectors.groupingBy(proc -> proc.getLong("actevalobj")));
            workflowInfoBo.setKeyActObjIdValProc(keyActObjIdValProc);
            List<Long> ruProcIds = Arrays.stream(ruProcs).map(proc -> proc.getLong("id")).distinct().collect(Collectors.toList());
            DynamicObject[] ruNodes = FLOW_RU_NODE_ENTITY_SERVICE.queryNodeByProcIds(ruProcIds);
            Map<Long, List<DynamicObject>> keyProcIdValNode = Arrays.stream(ruNodes).sorted(Comparator.comparing(node -> node.getInt("index"))).collect(Collectors.groupingBy(node -> node.getLong("flowruproc.id")));
            workflowInfoBo.setKeyProcIdValNode(keyProcIdValNode);
            List<Long> ruNodeIds = Arrays.stream(ruNodes).map(node -> node.getLong("id")).distinct().collect(Collectors.toList());
            DynamicObject[] ruTasks = FLOW_RU_TASK_ENTITY_SERVICE.queryTaskWithoutExpiredByNodeIds(ruNodeIds);
            Map<Long, List<DynamicObject>> keyNodeIdValTask = Arrays.stream(ruTasks).collect(Collectors.groupingBy(task -> task.getLong("flowrunode.id")));
            workflowInfoBo.setKeyNodeIdValTask(keyNodeIdValTask);
            Map<Long, DynamicObject> keyTaskIdValRole = Arrays.stream(ruTasks).collect(Collectors.toMap(task -> task.getLong("id"), taskY -> {
                DynamicObject role = FLOW_RU_ROLE_ENTITY_SERVICE.generateEmptyDynamicObject();
                role.set("id", (Object)taskY.getLong("flowrurole.id"));
                role.set("name", (Object)taskY.getString("flowrurole.name"));
                return role;
            }));
            workflowInfoBo.setKeyTaskIdValRole(keyTaskIdValRole);
        }
        return workflowInfoBo;
    }

    public WorkflowRuProcBo getRuProcInstance(Long ruProcId) {
        if (null != ruProcId && ruProcId != 0L) {
            DynamicObject ruProc = FLOW_RU_PROC_ENTITY_SERVICE.loadSingle(ruProcId);
            DynamicObject workflow = WORK_FLOW_ENTITY_SERVICE.getWorkflow(ruProcId);
            WorkflowRuProcBo flowRuProcBo = new WorkflowRuProcBo();
            if (!HRObjectUtils.isEmpty((Object)ruProc) && ruProc.getDynamicObject("defproc") != null) {
                long defProcId = ruProc.getDynamicObject("defproc").getLong("id");
                DynamicObject procDef = FLOW_DEF_PROC_ENTITY_SERVICE.loadSingle(defProcId);
                flowRuProcBo.setFlowdefDyn(procDef);
            }
            flowRuProcBo.setFlowruproc(ruProc);
            flowRuProcBo.setWorkflowDyn(workflow);
            DynamicObject[] ruNodes = FLOW_RU_NODE_ENTITY_SERVICE.queryAllNodeByProcId(ruProcId);
            LinkedList<FlowRuNodeBo> flowRuNodeBoList = new LinkedList<FlowRuNodeBo>();
            flowRuProcBo.setFlowRuNodeBoList(flowRuNodeBoList);
            for (DynamicObject ruNode : ruNodes) {
                long ruNodeId = ruNode.getLong("id");
                FlowRuNodeBo flowRuNodeBo = this.getRuNodeInstance(ruNodeId);
                flowRuNodeBoList.add(flowRuNodeBo);
            }
            return flowRuProcBo;
        }
        String message = MessageFormat.format(ResManager.loadKDString((String)"\u6d41\u7a0b\u5b9e\u4f8bID\uff1a{0}\uff0c\u5165\u53c2\u6821\u9a8c\u672a\u901a\u8fc7\u3002", (String)"FlowRunSupDomainService_16", (String)"opmc-pbs-business", (Object[])new Object[0]), ruProcId);
        LOG.error(message);
        return new WorkflowRuProcBo();
    }

    public FlowRuNodeBo getRuNodeInstance(Long ruNodeId) {
        if (null != ruNodeId && ruNodeId != 0L) {
            DynamicObject ruNode = FLOW_RU_NODE_ENTITY_SERVICE.loadSingle(ruNodeId);
            FlowRuNodeBo flowRuNodeBo = new FlowRuNodeBo();
            flowRuNodeBo.setFlowRuNode(ruNode);
            if (!HRObjectUtils.isEmpty((Object)ruNode) && ruNode.getDynamicObject("flownodedef") != null) {
                DynamicObject flowDefNode = FLOW_DEF_NODE_ENTITY_SERVICE.getFlowDefNode(ruNode.getDynamicObject("flownodedef").getLong("id"));
                flowRuNodeBo.setFlowDefNode(flowDefNode);
            }
            DynamicObject[] ruRoles = FLOW_RU_ROLE_ENTITY_SERVICE.queryRoleByNodeId(ruNodeId);
            LinkedList<FlowRuRoleBo> flowRuRoleBoList = new LinkedList<FlowRuRoleBo>();
            flowRuNodeBo.setFlowRuRoleBoList(flowRuRoleBoList);
            for (DynamicObject roRole : ruRoles) {
                long roRoleId = roRole.getLong("id");
                FlowRuRoleBo flowRuRoleBo = this.getRuRoleInstance(roRoleId);
                flowRuRoleBoList.add(flowRuRoleBo);
            }
            return flowRuNodeBo;
        }
        String message = MessageFormat.format(ResManager.loadKDString((String)"\u8282\u70b9\u5b9e\u4f8bID\uff1a{0}\uff0c\u5165\u53c2\u6821\u9a8c\u672a\u901a\u8fc7\u3002", (String)"FlowRunSupDomainService_17", (String)"opmc-pbs-business", (Object[])new Object[0]), ruNodeId);
        LOG.error(message);
        return new FlowRuNodeBo();
    }

    public FlowRuRoleBo getRuRoleInstance(Long ruRoleId) {
        if (null != ruRoleId && ruRoleId != 0L) {
            DynamicObject[] ruTasks;
            DynamicObject ruRole = FLOW_RU_ROLE_ENTITY_SERVICE.loadSingle(ruRoleId);
            FlowRuRoleBo flowRuRoleBo = new FlowRuRoleBo();
            flowRuRoleBo.setFlowRuRole(ruRole);
            if (!HRObjectUtils.isEmpty((Object)ruRole) && ruRole.getDynamicObject("flowdefrole") != null) {
                DynamicObject roleDef = FLOW_DEF_ROLE_ENTITY.loadSingle(ruRole.getDynamicObject("flowdefrole").getLong("id"));
                flowRuRoleBo.setFlowDefRole(roleDef);
            }
            if ((ruTasks = FLOW_RU_TASK_ENTITY_SERVICE.queryAllTaskByRoleId(ruRoleId)).length > 0) {
                flowRuRoleBo.setFlowRuTaskList(Arrays.asList(ruTasks));
            }
            return flowRuRoleBo;
        }
        String message = MessageFormat.format(ResManager.loadKDString((String)"\u89d2\u8272\u5b9e\u4f8bID\uff1a{0}\uff0c\u5165\u53c2\u6821\u9a8c\u672a\u901a\u8fc7\u3002", (String)"FlowRunSupDomainService_18", (String)"opmc-pbs-business", (Object[])new Object[0]), ruRoleId);
        LOG.error(message);
        return new FlowRuRoleBo();
    }

    public DynamicObject[] queryLessThanRoleSortRoles(Long flowRuRoleId) {
        return FLOW_RU_ROLE_ENTITY_SERVICE.queryLessThanRoleSortRoles(flowRuRoleId);
    }

    public boolean isFirstRole(Long flowRuRoleId) {
        return FLOW_RU_ROLE_ENTITY_SERVICE.isFirstRole(flowRuRoleId);
    }

    public DynamicObject[] queryLessThanNotCrossRoleSortRoles(Long flowRuRoleId) {
        return FLOW_RU_ROLE_ENTITY_SERVICE.queryLessThanNotCrossRoleSortRoles(flowRuRoleId);
    }

    public DynamicObject queryLastTaskByRoleIds(List<Long> ruRoleIds) {
        DynamicObject[] dynamicObjects = FLOW_RU_TASK_ENTITY_SERVICE.queryLastTaskByRoleIds(ruRoleIds);
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return null;
        }
        return dynamicObjects[0];
    }

    public boolean queryIsFirstNode(Long taskId) {
        DynamicObject task = FLOW_RU_TASK_ENTITY_SERVICE.queryOriginalTaskByPk(taskId);
        int index = task.getInt("flowrunode.index");
        return index == 1;
    }

    public List<Long> queryPreNodeLastRole(Long taskId) {
        DynamicObject task = FLOW_RU_TASK_ENTITY_SERVICE.queryOriginalTaskByPk(taskId);
        Long procId = task.getLong("flowruproc");
        int index = task.getInt("flowrunode.index");
        if (index == 1) {
            return new ArrayList<Long>(10);
        }
        DynamicObject ruNodeDy = FLOW_RU_NODE_ENTITY_SERVICE.queryRuNodeByIndex(procId, index - 1);
        if (ruNodeDy == null) {
            return new ArrayList<Long>(10);
        }
        Long preNodeId = (Long)ruNodeDy.getPkValue();
        DynamicObject[] roles = FLOW_RU_ROLE_ENTITY_SERVICE.queryRoleByNodeId(preNodeId);
        ArrayList<Long> maxOverSortRoleIds = new ArrayList<Long>(10);
        if (roles != null) {
            DynamicObject maxRole = null;
            for (int i = roles.length - 1; i >= 0; --i) {
                DynamicObject role = roles[i];
                if (role == null) continue;
                if (maxRole == null) {
                    maxRole = role;
                }
                int turnOverSort = role.getInt("turnoversort");
                int maxSort = maxRole.getInt("turnoversort");
                if (maxSort != turnOverSort) continue;
                maxOverSortRoleIds.add(role.getLong("id"));
            }
        }
        return maxOverSortRoleIds;
    }

    public List<Long> queryPreNotCrossNodeLastRole(Long taskId) {
        DynamicObject task = FLOW_RU_TASK_ENTITY_SERVICE.queryOriginalTaskByPk(taskId);
        Long procId = task.getLong("flowruproc");
        int index = task.getInt("flowrunode.index");
        if (index == 1) {
            return new ArrayList<Long>(10);
        }
        DynamicObject ruNodeDy = FLOW_RU_NODE_ENTITY_SERVICE.queryNotPreCrossRuNode(procId, index - 1);
        if (ruNodeDy == null) {
            return new ArrayList<Long>(10);
        }
        Long preNodeId = (Long)ruNodeDy.getPkValue();
        if (preNodeId == null || 0L == preNodeId) {
            return new ArrayList<Long>(10);
        }
        DynamicObject[] roles = FLOW_RU_ROLE_ENTITY_SERVICE.queryRoleByNodeId(preNodeId);
        ArrayList<Long> maxOverSortRoleIds = new ArrayList<Long>(10);
        if (roles != null) {
            DynamicObject maxRole = null;
            for (int i = roles.length - 1; i >= 0; --i) {
                DynamicObject role = roles[i];
                if (role == null) continue;
                if (maxRole == null) {
                    maxRole = role;
                }
                int turnOverSort = role.getInt("turnoversort");
                int maxSort = maxRole.getInt("turnoversort");
                if (maxSort != turnOverSort) continue;
                maxOverSortRoleIds.add(role.getLong("id"));
            }
        }
        return maxOverSortRoleIds;
    }

    public Map<Long, Long> queryPreNodeLastRoleMap(Long taskId) {
        DynamicObject task = FLOW_RU_TASK_ENTITY_SERVICE.queryOriginalTaskByPk(taskId);
        Long procId = task.getLong("flowruproc");
        int index = task.getInt("flowrunode.index");
        if (index == 1) {
            return new HashMap<Long, Long>(16);
        }
        DynamicObject ruNodeDy = FLOW_RU_NODE_ENTITY_SERVICE.queryRuNodeByIndex(procId, index - 1);
        if (ruNodeDy == null) {
            return new HashMap<Long, Long>(16);
        }
        Long preNodeId = (Long)ruNodeDy.getPkValue();
        DynamicObject[] roles = FLOW_RU_ROLE_ENTITY_SERVICE.queryRoleByNodeId(preNodeId);
        HashMap<Long, Long> sortRoleMap = new HashMap<Long, Long>(16);
        DynamicObject maxSortRole = null;
        for (int i = roles.length - 1; i >= 0; --i) {
            DynamicObject role = roles[i];
            if (role == null) continue;
            if (maxSortRole == null) {
                maxSortRole = role;
            }
            int turnOverSort = role.getInt("turnoversort");
            int maxTurnOverSort = maxSortRole.getInt("turnoversort");
            if (maxTurnOverSort != turnOverSort) continue;
            sortRoleMap.put(role.getLong("flowdefrole.id"), role.getLong("id"));
        }
        return sortRoleMap;
    }

    public Map<Long, Long> queryPreNotCrossNodeLastRoleMap(Long taskId) {
        DynamicObject task = FLOW_RU_TASK_ENTITY_SERVICE.queryOriginalTaskByPk(taskId);
        Long procId = task.getLong("flowruproc");
        int index = task.getInt("flowrunode.index");
        if (index == 1) {
            return new HashMap<Long, Long>(16);
        }
        DynamicObject ruNodeDy = FLOW_RU_NODE_ENTITY_SERVICE.queryNotPreCrossRuNode(procId, index - 1);
        if (ruNodeDy == null) {
            return new HashMap<Long, Long>(16);
        }
        Long preNodeId = (Long)ruNodeDy.getPkValue();
        DynamicObject[] roles = FLOW_RU_ROLE_ENTITY_SERVICE.queryRoleByNodeId(preNodeId);
        HashMap<Long, Long> sortRoleMap = new HashMap<Long, Long>(16);
        DynamicObject maxSortRole = null;
        for (int i = roles.length - 1; i >= 0; --i) {
            DynamicObject role = roles[i];
            if (role == null) continue;
            if (maxSortRole == null) {
                maxSortRole = role;
            }
            int turnOverSort = role.getInt("turnoversort");
            int maxTurnOverSort = maxSortRole.getInt("turnoversort");
            if (maxTurnOverSort != turnOverSort) continue;
            sortRoleMap.put(role.getLong("flowdefrole.id"), role.getLong("id"));
        }
        return sortRoleMap;
    }

    public DynamicObject[] queryRoleDefByNodeDef(List<Long> nodeIds) {
        QFilter qFilter = new QFilter("defnode", "in", nodeIds);
        DynamicObject[] flowDefRoles = FLOW_DEF_ROLE_ENTITY.query("id,rolename", new QFilter[]{qFilter});
        return flowDefRoles;
    }

    public FlowRuNodeBo querySpecifyRoles(long ruNodeId, int turnOverSort) {
        DynamicObject flowRuNode;
        FlowRuNodeBo ruNodeInstance = this.getRuNodeInstance(ruNodeId);
        List<FlowRuRoleBo> flowRuRoleBoList = ruNodeInstance.getFlowRuRoleBoList();
        List<FlowRuRoleBo> flowRuRoleBos = flowRuRoleBoList.stream().map(flowRuRoleBo -> {
            DynamicObject flowRuRole = flowRuRoleBo.getFlowRuRole();
            if (turnOverSort == flowRuRole.getInt("turnoversort")) {
                return flowRuRoleBo;
            }
            return null;
        }).filter(obj -> Optional.ofNullable(obj).isPresent()).collect(Collectors.toList());
        if (flowRuRoleBos.isEmpty() && !HRObjectUtils.isEmpty((Object)(flowRuNode = ruNodeInstance.getFlowRuNode()).getDynamicObject("flowruproc"))) {
            long ruProcId = flowRuNode.getDynamicObject("flowruproc").getLong("id");
            int index = flowRuNode.getInt("index");
            DynamicObject[] nodes = this.queryAllNodeByProcId(ruProcId);
            DynamicObject nextNode = Arrays.stream(nodes).filter(node -> index + 1 == node.getInt("index")).findFirst().orElse(null);
            if (!HRObjectUtils.isEmpty((Object)nextNode)) {
                ruNodeInstance = this.getRuNodeInstance(ruNodeId);
                List<FlowRuRoleBo> nextNodeRuRoleBoList = ruNodeInstance.getFlowRuRoleBoList();
                flowRuRoleBos = nextNodeRuRoleBoList.stream().map(flowRuRoleBo -> {
                    DynamicObject flowRuRole = flowRuRoleBo.getFlowRuRole();
                    if (flowRuRole.getInt("turnoversort") == 1) {
                        return flowRuRoleBo;
                    }
                    return null;
                }).filter(obj -> Optional.ofNullable(obj).isPresent()).collect(Collectors.toList());
            }
        }
        ruNodeInstance.setFlowRuRoleBoList(flowRuRoleBos);
        return ruNodeInstance;
    }

    public boolean notExistEvalSumNode(Long ruProcId) {
        DynamicObject ruProcDyo = FLOW_RU_PROC_ENTITY_SERVICE.queryRuProcByPk(ruProcId);
        DynamicObject flowDefDyo = FLOW_DEF_PROC_ENTITY_SERVICE.getFlowDefProcByPkValue(ruProcDyo.getLong("defproc.id"));
        DynamicObjectCollection nodeColl = flowDefDyo.getDynamicObjectCollection("nodeentry");
        for (DynamicObject node : nodeColl) {
            if (!NodeTypeConstants.BATCH_EVALUSUMSCORE.equals(node.getLong("nodetype.id"))) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public DynamicObject[] queryByRuNodeIds(List<Long> flowRuNodeIds) {
        return FLOW_RU_NODE_ENTITY_SERVICE.queryByRuNodeIds(flowRuNodeIds);
    }

    public FlowPreTaskResultBo getPreTask(Map<Long, List<Long>> taskMap, boolean isScoreNext) {
        ArrayList<PreTaskParamBo> preTaskParamBos = new ArrayList<PreTaskParamBo>(taskMap.size());
        for (Map.Entry<Long, List<Long>> entry : taskMap.entrySet()) {
            PreTaskParamBo bo = new PreTaskParamBo();
            bo.setTaskId(entry.getKey());
            bo.setIndicatorIds(entry.getValue());
            bo.setScoreNext(isScoreNext);
            preTaskParamBos.add(bo);
        }
        List<FlowPreTaskResultBo> flowPreTaskResultBos = this.batchGetPreTask(preTaskParamBos);
        return CollectionUtils.isNotEmpty(flowPreTaskResultBos) ? flowPreTaskResultBos.get(0) : new FlowPreTaskResultBo();
    }

    public List<FlowPreTaskResultBo> batchGetPreTask(List<PreTaskParamBo> preTaskParamBos) {
        List<Long> taskIds = preTaskParamBos.stream().map(PreTaskParamBo::getTaskId).collect(Collectors.toList());
        List targetTasks = Arrays.stream(FLOW_RU_TASK_ENTITY_SERVICE.queryOriginalTasksByIds(taskIds)).collect(Collectors.toList());
        Map<Long, Long> keyTaskValProcId = targetTasks.stream().collect(Collectors.toMap(task -> task.getLong("id"), task -> task.getLong("flowruproc.id"), (oldKey, newKey) -> oldKey));
        Map<Long, Long> keyTaskValRoleId = targetTasks.stream().collect(Collectors.toMap(task -> task.getLong("id"), task -> task.getLong("flowrurole.id"), (oldKey, newKey) -> oldKey));
        List<Long> ruProcIds = targetTasks.stream().map(task -> task.getLong("flowruproc.id")).distinct().collect(Collectors.toList());
        List currentNodeIds = targetTasks.stream().map(task -> task.getLong("flowrunode.id")).distinct().collect(Collectors.toList());
        List ruNodes = Arrays.stream(FLOW_RU_NODE_ENTITY_SERVICE.queryOriginalNodeByProcIds(ruProcIds)).collect(Collectors.toList());
        Map<Long, List<DynamicObject>> keyProcValNodes = ruNodes.stream().collect(Collectors.groupingBy(node -> node.getLong("flowruproc.id")));
        List currentNodes = ruNodes.stream().filter(node -> currentNodeIds.contains(node.getLong("id"))).collect(Collectors.toList());
        Map<Long, DynamicObject> keyProcValCurrentNode = currentNodes.stream().collect(Collectors.toMap(nodeX -> nodeX.getLong("flowruproc.id"), nodeY -> nodeY, (oldKey, newKey) -> oldKey));
        ArrayList<Object> newNodes = new ArrayList<Object>(10);
        ArrayList preNodes = new ArrayList(10);
        for (Long ruProcId : ruProcIds) {
            List<DynamicObject> nodes = keyProcValNodes.get(ruProcId);
            DynamicObject currentNode = keyProcValCurrentNode.get(ruProcId);
            if (HRObjectUtils.isEmpty((Object)currentNode)) continue;
            List nextNodes = nodes.stream().filter(node -> node.getInt("index") == currentNode.getInt("index") - 1).collect(Collectors.toList());
            preNodes.addAll(nextNodes);
        }
        newNodes.addAll(currentNodes);
        newNodes.addAll(preNodes);
        Map<Long, DynamicObject> keyProcValPreNode = preNodes.stream().collect(Collectors.toMap(nodeX -> nodeX.getLong("flowruproc.id"), nodeY -> nodeY, (oldKey, newKey) -> oldKey));
        List<Long> allRuNodeIds = newNodes.stream().map(node -> node.getLong("id")).distinct().collect(Collectors.toList());
        List allRuRoles = Arrays.stream(FLOW_RU_ROLE_ENTITY_SERVICE.queryOriginalRuRoleByNodeIds(allRuNodeIds)).collect(Collectors.toList());
        Map<Long, List<DynamicObject>> keyNodeValRoles = allRuRoles.stream().collect(Collectors.groupingBy(role -> role.getLong("flowrunode.id")));
        List<Long> ruRoleIds = allRuRoles.stream().map(role -> role.getLong("id")).collect(Collectors.toList());
        DynamicObject[] ruTasks = FLOW_RU_TASK_ENTITY_SERVICE.queryTasksByRoleIds(ruRoleIds);
        Map<Long, List<DynamicObject>> keyRoleValTasks = Arrays.stream(ruTasks).collect(Collectors.groupingBy(task -> task.getLong("flowrurole.id")));
        ArrayList<FlowPreTaskResultBo> resultBos = new ArrayList<FlowPreTaskResultBo>(preTaskParamBos.size());
        for (PreTaskParamBo preTaskParamBo : preTaskParamBos) {
            List<DynamicObject> curRoles;
            FlowPreTaskResultBo taskResultBo = new FlowPreTaskResultBo();
            Long taskId = preTaskParamBo.getTaskId();
            Boolean isScoreNext = preTaskParamBo.getScoreNext();
            taskResultBo.setTaskId(taskId);
            Long procId = keyTaskValProcId.get(taskId);
            DynamicObject currentNode = keyProcValCurrentNode.get(procId);
            boolean isCrossNode = currentNode.getBoolean("iscrossnode");
            Long currentRoleId = keyTaskValRoleId.get(taskId);
            Optional<DynamicObject> optional = allRuRoles.stream().filter(role -> currentRoleId.equals(role.getLong("id"))).findFirst();
            if (!optional.isPresent()) continue;
            DynamicObject currentRole = optional.get();
            int currentNodeIndex = currentNode.getInt("index");
            if (currentNodeIndex == 1) {
                taskResultBo.setCross(isCrossNode);
            }
            if (CollectionUtils.isEmpty(curRoles = keyNodeValRoles.get(currentNode.getLong("id")))) continue;
            if (isCrossNode) {
                DynamicObject lessThanCurrentRoleSortAndGetMax;
                Map<String, List<DynamicObject>> keySetNoValRole = curRoles.stream().collect(Collectors.groupingBy(role -> role.getString("setno")));
                List<DynamicObject> setNoRoles = keySetNoValRole.get(currentRole.getString("setno"));
                DynamicObject dynamicObject = lessThanCurrentRoleSortAndGetMax = CollectionUtils.isEmpty(setNoRoles) ? null : (DynamicObject)setNoRoles.stream().filter(role -> role.getInt("turnoversort") < currentRole.getInt("turnoversort")).sorted(Comparator.comparing(role -> role.getInt("turnoversort"), Comparator.nullsLast(Comparator.reverseOrder()))).max(Comparator.comparing(role -> role.getDate("modifytime"))).orElse(null);
                if (Boolean.TRUE.equals(isScoreNext)) {
                    List<DynamicObject> targetRoles;
                    List<DynamicObject> list = targetRoles = CollectionUtils.isEmpty(setNoRoles) ? null : setNoRoles.stream().filter(role -> role.getInt("turnoversort") < currentRole.getInt("turnoversort")).collect(Collectors.toList());
                    if (targetRoles != null && CollectionUtils.isNotEmpty(targetRoles)) {
                        lessThanCurrentRoleSortAndGetMax = this.getMaxRole(targetRoles, taskResultBo, resultBos);
                        if (lessThanCurrentRoleSortAndGetMax == null) {
                            continue;
                        }
                    } else {
                        lessThanCurrentRoleSortAndGetMax = null;
                    }
                }
                if (null == lessThanCurrentRoleSortAndGetMax || HRObjectUtils.isEmpty(lessThanCurrentRoleSortAndGetMax)) {
                    DynamicObject preNode = keyProcValPreNode.get(procId);
                    this.getPreNodeLastTask(taskResultBo, preNode, keyNodeValRoles, keyRoleValTasks, preTaskParamBo);
                } else {
                    HashMap<Long, Long> indicatorTaskMap = new HashMap<Long, Long>(16);
                    DynamicObject finalLessThanCurrentRoleSortAndGetMax = lessThanCurrentRoleSortAndGetMax;
                    List<DynamicObject> maxRoles = setNoRoles.stream().filter(role -> HRStringUtils.equals((String)role.getString("setno"), (String)finalLessThanCurrentRoleSortAndGetMax.getString("setno"))).filter(role -> role.getInt("turnoversort") == finalLessThanCurrentRoleSortAndGetMax.getInt("turnoversort")).collect(Collectors.toList());
                    List<DynamicObject> taskList = this.getMaxRoleTaskList(keyRoleValTasks, isScoreNext, maxRoles);
                    Map<Long, Long> tempIndicatorTaskMap = this.getPreTaskByEachIndicatorId(preTaskParamBo.getIndicatorIds(), taskList);
                    indicatorTaskMap.putAll(tempIndicatorTaskMap);
                    taskResultBo.setIndicatorTaskMap(indicatorTaskMap);
                    taskResultBo.setCross(true);
                }
            } else {
                DynamicObject maxRole = curRoles.stream().filter(role -> role.getInt("turnoversort") < currentRole.getInt("turnoversort")).sorted(Comparator.comparing(role -> role.getInt("turnoversort"), Comparator.nullsLast(Comparator.reverseOrder()))).max(Comparator.comparing(role -> role.getDate("modifytime"))).orElse(null);
                if (Boolean.TRUE.equals(isScoreNext)) {
                    List<DynamicObject> targetRoles = curRoles.stream().filter(role -> role.getInt("turnoversort") < currentRole.getInt("turnoversort")).collect(Collectors.toList());
                    if (CollectionUtils.isNotEmpty(targetRoles)) {
                        maxRole = this.getMaxRole(targetRoles, taskResultBo, resultBos);
                        if (maxRole == null) {
                            continue;
                        }
                    } else {
                        maxRole = null;
                    }
                }
                if (null == maxRole || HRObjectUtils.isEmpty((Object)maxRole)) {
                    DynamicObject preNode = keyProcValPreNode.get(procId);
                    this.getPreNodeLastTask(taskResultBo, preNode, keyNodeValRoles, keyRoleValTasks, preTaskParamBo);
                } else {
                    DynamicObject finalMaxRole = maxRole;
                    List<DynamicObject> maxRoles = curRoles.stream().filter(role -> role.getInt("turnoversort") == finalMaxRole.getInt("turnoversort")).collect(Collectors.toList());
                    List<DynamicObject> taskList = this.getMaxRoleTaskList(keyRoleValTasks, isScoreNext, maxRoles);
                    List preTasks = taskList.stream().sorted(Comparator.comparing(tempTask -> tempTask.getDate("modifytime"), Comparator.reverseOrder())).collect(Collectors.toList());
                    if (CollectionUtils.isNotEmpty(preTasks)) {
                        taskResultBo.setPreTask(((DynamicObject)preTasks.get(0)).getLong("id"));
                    } else {
                        taskResultBo.setPreTask(null);
                    }
                    taskResultBo.setCross(false);
                }
            }
            resultBos.add(taskResultBo);
        }
        return resultBos;
    }

    private List<DynamicObject> getMaxRoleTaskList(Map<Long, List<DynamicObject>> keyRoleValTasks, Boolean isScoreNext, List<DynamicObject> maxRoles) {
        if (isScoreNext.booleanValue()) {
            maxRoles = maxRoles.stream().filter(this::getRoleConfigIsScoreNext).collect(Collectors.toList());
        }
        ArrayList<DynamicObject> taskList = new ArrayList<DynamicObject>(10);
        maxRoles.forEach(role -> taskList.addAll((Collection)keyRoleValTasks.get(role.getLong("id"))));
        return taskList;
    }

    private DynamicObject getMaxRole(List<DynamicObject> targetRoles, FlowPreTaskResultBo taskResultBo, List<FlowPreTaskResultBo> resultBos) {
        DynamicObject maxRole = targetRoles.stream().filter(this::getRoleConfigIsScoreNext).max(Comparator.comparing(role -> role.getDate("modifytime"))).orElse(null);
        if (null == maxRole || HRObjectUtils.isEmpty((Object)maxRole)) {
            taskResultBo.setIndicatorTaskMap(null);
            taskResultBo.setCross(true);
            resultBos.add(taskResultBo);
            return null;
        }
        return maxRole;
    }

    private boolean getRoleConfigIsScoreNext(DynamicObject role) {
        String confJson = role.getString("flowdefrole.confjson");
        NodeRoleConfigBo bo = (NodeRoleConfigBo)SerializationUtils.fromJsonString((String)confJson, NodeRoleConfigBo.class);
        return bo.getIsscorenext();
    }

    private void getPreNodeLastTask(FlowPreTaskResultBo taskResultBo, DynamicObject preNode, Map<Long, List<DynamicObject>> keyNodeValRole, Map<Long, List<DynamicObject>> keyRoleValTasks, PreTaskParamBo preTaskParamBo) {
        if (!HRObjectUtils.isEmpty((Object)preNode)) {
            boolean isCrossPreNode = preNode.getBoolean("iscrossnode");
            List<Long> indicatorIds = preTaskParamBo.getIndicatorIds();
            Boolean isScoreNext = preTaskParamBo.getScoreNext();
            List<DynamicObject> preNodeRoles = keyNodeValRole.get(preNode.getLong("id"));
            if (isCrossPreNode) {
                Map<String, List<DynamicObject>> keySetNoValPreRole = preNodeRoles.stream().collect(Collectors.groupingBy(role -> role.getString("setno")));
                ArrayList maxSetNoRoles = new ArrayList(10);
                for (Map.Entry<String, List<DynamicObject>> roleEntry : keySetNoValPreRole.entrySet()) {
                    List<DynamicObject> setNoRole = roleEntry.getValue();
                    setNoRole.stream().max(Comparator.comparing(role -> role.getInt("turnoversort"))).ifPresent(maxRole -> {
                        List maxRoles = setNoRole.stream().filter(role -> role.getInt("turnoversort") == maxRole.getInt("turnoversort")).collect(Collectors.toList());
                        maxSetNoRoles.addAll(maxRoles);
                    });
                }
                HashMap<Long, Long> indicatorTaskMap = new HashMap<Long, Long>(16);
                ArrayList<DynamicObject> taskList = new ArrayList<DynamicObject>(10);
                for (DynamicObject maxSetNoRole : maxSetNoRoles) {
                    boolean configIsScoreNext = this.getRoleConfigIsScoreNext(maxSetNoRole);
                    if (isScoreNext.booleanValue() && !configIsScoreNext) {
                        long l = maxSetNoRole.getLong("id");
                        continue;
                    }
                    List<DynamicObject> tempTaskList = keyRoleValTasks.get(maxSetNoRole.getLong("id"));
                    taskList.addAll(tempTaskList);
                }
                if (CollectionUtils.isNotEmpty(taskList)) {
                    Map<Long, Long> tempIndicatorTaskMap = this.getPreTaskByEachIndicatorId(indicatorIds, taskList);
                    indicatorTaskMap.putAll(tempIndicatorTaskMap);
                }
                taskResultBo.setIndicatorTaskMap(indicatorTaskMap);
                taskResultBo.setCross(true);
            } else {
                DynamicObject maxRole2 = preNodeRoles.stream().max(Comparator.comparing(role -> role.getDate("modifytime"))).orElse(null);
                if (null != maxRole2) {
                    boolean configIsScoreNext = this.getRoleConfigIsScoreNext(maxRole2);
                    if (isScoreNext.booleanValue() && !configIsScoreNext) {
                        taskResultBo.setPreTask(null);
                    } else {
                        List<DynamicObject> maxRoles = preNodeRoles.stream().filter(role -> role.getInt("turnoversort") == maxRole2.getInt("turnoversort")).collect(Collectors.toList());
                        List<DynamicObject> taskList = this.getMaxRoleTaskList(keyRoleValTasks, isScoreNext, maxRoles);
                        List preTasks = taskList.stream().sorted(Comparator.comparing(tempTask -> tempTask.getDate("modifytime"), Comparator.nullsLast(Comparator.reverseOrder()))).collect(Collectors.toList());
                        if (CollectionUtils.isNotEmpty(preTasks)) {
                            DynamicObject preTask = (DynamicObject)preTasks.get(0);
                            taskResultBo.setPreTask(preTask.getLong("id"));
                        }
                    }
                }
                taskResultBo.setCross(false);
            }
        }
    }

    private Map<Long, Long> getPreTaskByEachIndicatorId(List<Long> indicatorIds, List<DynamicObject> taskList) {
        HashMap<Long, Long> tempIndicatorTaskMap = new HashMap<Long, Long>(16);
        if (CollectionUtils.isNotEmpty(indicatorIds) && CollectionUtils.isNotEmpty(taskList)) {
            for (Long indicatorId : indicatorIds) {
                List collect = taskList.stream().filter(indicatorTask -> {
                    DynamicObjectCollection indicatorColl = indicatorTask.getDynamicObjectCollection("entryentity");
                    List indicIds = indicatorColl.stream().filter(dym -> dym.getLong("indicatorid") == indicatorId.longValue()).collect(Collectors.toList());
                    return CollectionUtils.isNotEmpty(indicIds);
                }).sorted(Comparator.comparing(tempTask -> tempTask.getDate("modifytime"), Comparator.nullsLast(Comparator.reverseOrder()))).collect(Collectors.toList());
                if (!CollectionUtils.isNotEmpty(collect)) continue;
                tempIndicatorTaskMap.put(indicatorId, ((DynamicObject)collect.get(0)).getLong("id"));
            }
        }
        return tempIndicatorTaskMap;
    }

    protected boolean isExistUnHandleTask(DynamicObject ruRole, DynamicObject ruNode, Long ruProcId) {
        boolean isExistUnHandleTask = Boolean.FALSE;
        QFilter qFilter = new QFilter("flowruproc.id", "=", (Object)ruProcId);
        qFilter.and("flowrunode.index", "<", (Object)ruNode.getInt("index"));
        qFilter.and("taskstatus", "in", Arrays.asList(FlowRuTaskStatusEnum.WAITING.getCode(), FlowRuTaskStatusEnum.PROCESSING.getCode(), FlowRuTaskStatusEnum.PENDING.getCode()));
        if (FLOW_RU_TASK_ENTITY_SERVICE.isExists(new QFilter[]{qFilter})) {
            isExistUnHandleTask = Boolean.TRUE;
        } else {
            QFilter qFilter2 = new QFilter("flowruproc.id", "=", (Object)ruProcId);
            qFilter2.and("flowrunode.index", "=", (Object)ruNode.getInt("index"));
            qFilter2.and("flowrurole.turnoversort", "=", (Object)ruRole.getInt("turnoversort"));
            qFilter2.and("taskstatus", "in", Arrays.asList(FlowRuTaskStatusEnum.WAITING.getCode(), FlowRuTaskStatusEnum.PROCESSING.getCode(), FlowRuTaskStatusEnum.PENDING.getCode()));
            if (FLOW_RU_TASK_ENTITY_SERVICE.isExists(new QFilter[]{qFilter2})) {
                isExistUnHandleTask = Boolean.TRUE;
            }
        }
        return isExistUnHandleTask;
    }
}

