/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.pbs.business.domain.workflow.service;

import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.opmc.pbs.business.ServiceFactory;
import kd.opmc.pbs.business.domain.workflow.entityservice.WorkFlowEntityService;

public class WorkFlowDomainService {
    private static final WorkFlowEntityService WORK_FLOW_ENTITY_SERVICE = WorkFlowEntityService.getInstance();

    public static WorkFlowDomainService getInstance() {
        return ServiceFactory.getService(WorkFlowDomainService.class);
    }

    public DynamicObject[] getWorkflows(List<Long> flowIds) {
        return WORK_FLOW_ENTITY_SERVICE.getWorkflows(flowIds);
    }

    public DynamicObject[] getAllWorkflows(List<Long> flowIds) {
        return WORK_FLOW_ENTITY_SERVICE.getAllWorkflows(flowIds);
    }

    public DynamicObject[] getWorkflowsByVid(List<Long> vids) {
        return WORK_FLOW_ENTITY_SERVICE.getWorkflowsByVid(vids);
    }

    public DynamicObject[] getWorkflowsByVids(List<Long> vids) {
        return WORK_FLOW_ENTITY_SERVICE.getWorkflowsByVids(vids);
    }

    public DynamicObject[] getPublishFlows(List<Long> flowIds) {
        return WORK_FLOW_ENTITY_SERVICE.getPublishFlows(flowIds);
    }

    public DynamicObject getWorkflow(long flowId) {
        return WORK_FLOW_ENTITY_SERVICE.getWorkflow(flowId);
    }

    public DynamicObject getTempWorkflow(long flowId) {
        return WORK_FLOW_ENTITY_SERVICE.getTempWorkflow(flowId);
    }

    public DynamicObject getCurrentWorkflow(long flowId) {
        return WORK_FLOW_ENTITY_SERVICE.getCurrentWorkflow(flowId);
    }

    public DynamicObject getCurrentTempWorkflow(long flowId) {
        return WORK_FLOW_ENTITY_SERVICE.getCurrentTempWorkflow(flowId);
    }

    public DynamicObject[] getCurrentTempWorkflows(List<Long> flowIds) {
        return WORK_FLOW_ENTITY_SERVICE.getCurrentTempWorkflows(flowIds);
    }

    public DynamicObject[] getCopyTempWorkflow(List<Long> flowIds) {
        return WORK_FLOW_ENTITY_SERVICE.getCopyTempWorkflow(flowIds);
    }

    public DynamicObject generateEmptyDynamicObject() {
        return WORK_FLOW_ENTITY_SERVICE.generateEmptyDynamicObject();
    }

    public void deleteBackupFlows(List<Long> flowIds) {
        WORK_FLOW_ENTITY_SERVICE.deleteBackupFlows(flowIds);
    }

    public DynamicObject getWorkflowById(long flowId) {
        return WORK_FLOW_ENTITY_SERVICE.getWorkflowById(flowId);
    }

    public DynamicObject getSaveOrEffWorkflows(long flowId) {
        return WORK_FLOW_ENTITY_SERVICE.getSaveOrEffWorkflows(flowId);
    }

    public Object save(DynamicObject dynamicObject) {
        return WORK_FLOW_ENTITY_SERVICE.save(dynamicObject);
    }

    public Object[] save(DynamicObjectCollection dynamicObjects) {
        return WORK_FLOW_ENTITY_SERVICE.save(dynamicObjects);
    }

    public DynamicObject getWorkflowVersion(long flowId) {
        return WORK_FLOW_ENTITY_SERVICE.getWorkflowVersion(flowId);
    }

    public DynamicObject[] getWorkflowsByIdAndFlowType(List<Long> flowIds, String flowType) {
        return WORK_FLOW_ENTITY_SERVICE.getWorkflowsByIdAndFlowType(flowIds, flowType);
    }

    public DynamicObject[] loadWorkflows(Set<Long> workflowIds) {
        QFilter qFilter = new QFilter("iscurrentversion", "=", (Object)"1").and("boid", "in", workflowIds);
        return WORK_FLOW_ENTITY_SERVICE.loadDynamicObjectArray(new QFilter[]{qFilter});
    }

    public DynamicObject[] getAllHisWorkFlowByBoids(List<Long> boids) {
        QFilter qFilter = new QFilter("iscurrentversion", "=", (Object)"0").and("boid", "in", boids).and("hisversion", "!=", (Object)"COPYTEMP");
        return WORK_FLOW_ENTITY_SERVICE.queryOriginalArray("id,name", new QFilter[]{qFilter});
    }
}

