/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.pbs.business.domain.workflow.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.extplugin.PluginFilter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.pbs.business.domain.workflow.model.BatchFlowParamBo;
import kd.opmc.pbs.business.domain.workflow.outService.IRoleTypeUserDefService;
import kd.opmc.pbs.business.external.hrpi.IHRPIPersonService;

public class WorkflowUtils {
    private static final Log LOG = LogFactory.getLog(WorkflowUtils.class);
    private static final IRoleTypeUserDefService I_ROLE_TYPE_USER_DEF_SERVICE = IRoleTypeUserDefService.getInstance();
    protected static final IHRPIPersonService PERSON_SERVICE = IHRPIPersonService.getInstance();

    private WorkflowUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static void updateStatus(DynamicObject dym, String statusSymbol, String status) {
        if (!HRObjectUtils.isEmpty((Object)dym)) {
            Date date = new Date();
            long userId = UserServiceHelper.getCurrentUserId();
            dym.set(statusSymbol, (Object)status);
            dym.set("updatestatustime", (Object)date);
            dym.set("modifier", (Object)userId);
            dym.set("modifytime", (Object)date);
        }
    }

    public static void updateTaskStatus(List<DynamicObject> tasks, String taskStatus) {
        if (CollectionUtils.isNotEmpty(tasks)) {
            Date date = new Date();
            long userId = UserServiceHelper.getCurrentUserId();
            for (DynamicObject task : tasks) {
                task.set("taskstatus", (Object)taskStatus);
                task.set("updatestatustime", (Object)date);
                task.set("modifier", (Object)userId);
                task.set("modifytime", (Object)date);
            }
        }
    }

    public static void updateRollbackTaskStatus(List<DynamicObject> tasks, String taskStatus) {
        if (CollectionUtils.isNotEmpty(tasks)) {
            for (DynamicObject task : tasks) {
                WorkflowUtils.updateStatus(task, "taskstatus", taskStatus);
            }
        }
    }

    public static void updateTaskStatus(DynamicObject[] tasks, String taskStatus) {
        if (null != tasks && tasks.length > 0) {
            WorkflowUtils.updateTaskStatus(Arrays.stream(tasks).collect(Collectors.toList()), taskStatus);
        }
    }

    public static void updateRoleStatus(List<DynamicObject> roles, String roleStatus) {
        if (CollectionUtils.isNotEmpty(roles)) {
            Date date = new Date();
            long userId = UserServiceHelper.getCurrentUserId();
            for (DynamicObject role : roles) {
                role.set("rolestatus", (Object)roleStatus);
                role.set("updatestatustime", (Object)date);
                role.set("modifier", (Object)userId);
                role.set("modifytime", (Object)date);
            }
        }
    }

    public static void updateRoleStatus(DynamicObject[] roles, String roleStatus) {
        if (null != roles && roles.length > 0) {
            WorkflowUtils.updateRoleStatus(Arrays.stream(roles).collect(Collectors.toList()), roleStatus);
        }
    }

    public static void updateNodeStatus(List<DynamicObject> nodes, String roleStatus) {
        if (CollectionUtils.isNotEmpty(nodes)) {
            Date date = new Date();
            long userId = UserServiceHelper.getCurrentUserId();
            for (DynamicObject node : nodes) {
                node.set("nodestatus", (Object)roleStatus);
                node.set("updatestatustime", (Object)date);
                node.set("modifier", (Object)userId);
                node.set("modifytime", (Object)date);
            }
        }
    }

    public static void updateNodeStatus(DynamicObject[] nodes, String nodeStatus) {
        if (null != nodes && nodes.length > 0) {
            WorkflowUtils.updateNodeStatus(Arrays.stream(nodes).collect(Collectors.toList()), nodeStatus);
        }
    }

    public static void updateProcStatus(List<DynamicObject> procs, String procStatus) {
        if (CollectionUtils.isNotEmpty(procs)) {
            Date date = new Date();
            long userId = UserServiceHelper.getCurrentUserId();
            for (DynamicObject proc : procs) {
                proc.set("procstatus", (Object)procStatus);
                proc.set("updatestatustime", (Object)date);
                proc.set("modifier", (Object)userId);
                proc.set("modifytime", (Object)date);
            }
        }
    }

    public static void updateProcStatus(DynamicObject[] procs, String procStatus) {
        if (null != procs && procs.length > 0) {
            WorkflowUtils.updateProcStatus(Arrays.stream(procs).collect(Collectors.toList()), procStatus);
        }
    }

    public static DynamicObjectCollection setCurrentRunRole(DynamicObject ruProc, List<DynamicObject> currentRoles) {
        DynamicObjectCollection curRunRoleColl = ruProc.getDynamicObjectCollection("entryentity");
        curRunRoleColl.clear();
        for (DynamicObject ruRole : currentRoles) {
            DynamicObject roleDy = curRunRoleColl.addNew();
            roleDy.set("ruroleid", (Object)ruRole);
        }
        return curRunRoleColl;
    }

    public static void mergeCurrentRunRole(BatchFlowParamBo flowParamBo) {
        DynamicObjectCollection ruProcColl = flowParamBo.getRuProcColl();
        Map<Long, List<DynamicObject>> keyIdValProc = flowParamBo.getRuProcColl().stream().collect(Collectors.groupingBy(proc -> proc.getLong("id")));
        DynamicObjectCollection newProcs = new DynamicObjectCollection();
        if (!keyIdValProc.isEmpty()) {
            ArrayList<DynamicObject> currentRoles = new ArrayList<DynamicObject>();
            HashSet<Long> roleIds = new HashSet<Long>(16);
            for (Map.Entry<Long, List<DynamicObject>> entry : keyIdValProc.entrySet()) {
                List<DynamicObject> procs = entry.getValue();
                if (CollectionUtils.isNotEmpty(procs) && procs.size() > 1) {
                    for (DynamicObject proc2 : procs) {
                        DynamicObjectCollection procEntry = proc2.getDynamicObjectCollection("entryentity");
                        if (null == procEntry || procEntry.isEmpty()) continue;
                        for (DynamicObject procEnt : procEntry) {
                            DynamicObject rurole = procEnt.getDynamicObject("ruroleid");
                            if (roleIds.contains(rurole.getLong("id"))) continue;
                            currentRoles.add(rurole);
                            roleIds.add(rurole.getLong("id"));
                        }
                    }
                    DynamicObject dynamicObject = procs.get(0);
                    WorkflowUtils.setCurrentRunRole(dynamicObject, currentRoles);
                    newProcs.add((Object)dynamicObject);
                    continue;
                }
                newProcs.addAll(procs);
            }
            flowParamBo.getRuProcColl().removeAll((Collection)ruProcColl);
            flowParamBo.getRuProcColl().addAll((Collection)newProcs);
        }
    }

    public static Map<Long, List<Long>> getUserIdByUserDefRoleType(Long roleTypeId, DynamicObject ruProc) {
        HRPluginProxy proxy = new HRPluginProxy((Object)I_ROLE_TYPE_USER_DEF_SERVICE, IRoleTypeUserDefService.class, "kd.opmc.pbs.business.domain.workflow.outService.IRoleTypeUserDefService#getUserIdByUserDefRoleType", (PluginFilter)null);
        List results = proxy.callReplaceIfPresent(p -> p.getUserIdByUserDefRoleType(roleTypeId, ruProc));
        return CollectionUtils.isEmpty((Collection)results) ? null : (Map)results.get(0);
    }

    public static String getReason(String reason) {
        if (HRStringUtils.isEmpty((String)reason)) {
            reason = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u9000\u56de\u539f\u56e0\u3002", (String)"WorkflowUtils_1", (String)"opmc-pbs-business", (Object[])new Object[0]);
        } else if (reason.length() > 255) {
            reason = reason.substring(0, 255);
        }
        return reason;
    }

    public static Map<Long, Long> getUserIdsByPersonIds(List<Long> personIds) {
        HashMap<Long, Long> retMap = new HashMap<Long, Long>(16);
        HashMap<String, List<Long>> personIdMap = new HashMap<String, List<Long>>(16);
        personIdMap.put("person", personIds);
        Map<Object, Object> userIdByPersonInfo = new HashMap(16);
        try {
            userIdByPersonInfo = PERSON_SERVICE.getUserIdByPersonInfo(personIdMap);
        }
        catch (Exception e) {
            LOG.error("\u3010OPMC-WorkflowUtils\u3011-getUserIdsByPersonIds error,personIds:{}", personIds);
            LOG.error((Throwable)e);
        }
        LOG.info("\u3010OPMC-WorkflowUtils\u3011-getUserIdsByPersonIds,param personIds : {},userIdByPersonInfo : {}", personIds, userIdByPersonInfo);
        if (userIdByPersonInfo.isEmpty()) {
            return retMap;
        }
        Boolean success = (Boolean)userIdByPersonInfo.get("success");
        if (success.booleanValue()) {
            Map userInfo = (Map)userIdByPersonInfo.get("data");
            ArrayList<Long> userIds = new ArrayList<Long>(personIds.size());
            for (Long personId : personIds) {
                Map user = (Map)userInfo.get(personId);
                if (user == null) continue;
                Long userId = (Long)user.get("user");
                userIds.add(userId);
            }
            Map<Long, Boolean> userIsEnableMap = WorkflowUtils.batchQueryUserIsEnable(userIds);
            for (Long personId : personIds) {
                Long userId;
                Map user = (Map)userInfo.get(personId);
                if (user == null || !userIsEnableMap.getOrDefault(userId = (Long)user.get("user"), false).booleanValue()) continue;
                retMap.put(personId, userId);
            }
        }
        return retMap;
    }

    public static Map<Long, Boolean> batchQueryUserIsEnable(List<Long> userIds) {
        List userInfo = UserServiceHelper.get(userIds, (String[])new String[]{"id", "isforbidden", "enable"}, null);
        HashMap<Long, Boolean> ret = new HashMap<Long, Boolean>(16);
        if (CollectionUtils.isEmpty((Collection)userInfo)) {
            return ret;
        }
        for (Map user : userInfo) {
            ret.put((Long)user.get("id"), (Boolean)user.get("isforbidden") == false && "1".equals(user.get("enable")));
        }
        return ret;
    }
}

