/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.pbs.business.external.epa.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.opmc.pbs.business.external.epa.IEPARoleTypeService;
import kd.opmc.pbs.business.external.epa.po.RoleTypeCustomPo;
import kd.opmc.pbs.common.constants.RoleTypeConstants;

public class EPARoleTypeServiceImpl
implements IEPARoleTypeService {
    private static final Log LOGGER = LogFactory.getLog(EPARoleTypeServiceImpl.class);
    private static final String CLOUD_ID = "opmc";
    private static final String APP_ID = "epa";
    private static final String SERVICE_NAME = "IEPAActevalobjService";
    private static final String QUERY_ACTIVITY_RESPERSONIDBYIDS = "queryActivityRespersonIdByIds";
    private static final String QUERY_ACTIVITY_CREATE_SCHEMEIDBYIDS = "queryActivityCreateSchemeIdByIds";
    private static final String QUERY_ACTIVITY_CREATEIDBYIDS = "queryActivityCreateIdByIds";
    private static final String GET_PERFFILEV_ORGIDBYID = "getPerffilevOrgIdById";

    @Override
    public Map<Long, List<Long>> getUserIdByRoleType(DynamicObject roleType, RoleTypeCustomPo po) {
        LOGGER.info("DynamicObject of roleType is {}", (Object)roleType.getLong("id"));
        LOGGER.info("RoleTypeCustomPo is {}", (Object)po);
        Long id = roleType.getLong("id");
        Map<Long, List<Long>> map = new HashMap<Long, List<Long>>(16);
        if (RoleTypeConstants.ASSESSMENT_PLAN_CREATOR.equals(id)) {
            map = (Map)HRMServiceHelper.invokeBizService((String)CLOUD_ID, (String)APP_ID, (String)SERVICE_NAME, (String)QUERY_ACTIVITY_CREATE_SCHEMEIDBYIDS, (Object[])new Object[]{po.getActevalobjIdList()});
        } else if (RoleTypeConstants.ASSESSMENT_RESPONSIBLE_PERSON.equals(id)) {
            map = (Map)HRMServiceHelper.invokeBizService((String)CLOUD_ID, (String)APP_ID, (String)SERVICE_NAME, (String)QUERY_ACTIVITY_RESPERSONIDBYIDS, (Object[])new Object[]{po.getActevalobjIdList()});
        } else if (RoleTypeConstants.ASSESSMENT_ACTIVITY_CREATOR.equals(id)) {
            map = (Map)HRMServiceHelper.invokeBizService((String)CLOUD_ID, (String)APP_ID, (String)SERVICE_NAME, (String)QUERY_ACTIVITY_CREATEIDBYIDS, (Object[])new Object[]{po.getActevalobjIdList()});
        }
        LOGGER.info("map is {}", map);
        return map;
    }

    @Override
    public Map<Long, List<Long>> getOrgIdsByActevalobjIds(List<Long> actevalobjIdList) {
        LOGGER.info("actevalobjIdList is {}", actevalobjIdList);
        Map map = (Map)HRMServiceHelper.invokeBizService((String)CLOUD_ID, (String)APP_ID, (String)SERVICE_NAME, (String)GET_PERFFILEV_ORGIDBYID, (Object[])new Object[]{actevalobjIdList});
        LOGGER.info("map is {}", (Object)map);
        return map;
    }

    @Override
    public Map<Long, List<Long>> getUserIdByRoleTypeId(Long roleType, RoleTypeCustomPo po) {
        LOGGER.info("roleType is\uff1a" + roleType);
        Map<Long, List<Long>> map = new HashMap<Long, List<Long>>(16);
        if (RoleTypeConstants.ASSESSMENT_PLAN_CREATOR.equals(roleType)) {
            LOGGER.info("ASSESSMENT_PLAN_CREATOR,param is :" + po.getActevalobjIdList().toString());
            map = (Map)HRMServiceHelper.invokeBizService((String)CLOUD_ID, (String)APP_ID, (String)SERVICE_NAME, (String)QUERY_ACTIVITY_CREATE_SCHEMEIDBYIDS, (Object[])new Object[]{po.getActevalobjIdList()});
        } else if (RoleTypeConstants.ASSESSMENT_RESPONSIBLE_PERSON.equals(roleType)) {
            LOGGER.info("ASSESSMENT_RESPONSIBLE_PERSON,param is :" + po.getActevalobjIdList().toString());
            map = (Map)HRMServiceHelper.invokeBizService((String)CLOUD_ID, (String)APP_ID, (String)SERVICE_NAME, (String)QUERY_ACTIVITY_RESPERSONIDBYIDS, (Object[])new Object[]{po.getActevalobjIdList()});
        } else if (RoleTypeConstants.ASSESSMENT_ACTIVITY_CREATOR.equals(roleType)) {
            LOGGER.info("ASSESSMENT_ACTIVITY_CREATOR,param is :" + po.getActevalobjIdList().toString());
            map = (Map)HRMServiceHelper.invokeBizService((String)CLOUD_ID, (String)APP_ID, (String)SERVICE_NAME, (String)QUERY_ACTIVITY_CREATEIDBYIDS, (Object[])new Object[]{po.getActevalobjIdList()});
        }
        LOGGER.info("map is {}", map);
        return map;
    }
}

