/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.pbs.business.tips;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.Tips;
import kd.bos.form.IFormView;
import kd.bos.list.ListColumn;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.pbs.business.external.hrcs.IHRCSTipService;

public class ShowConfigTipsUtils {
    private static final Log LOG = LogFactory.getLog(ShowConfigTipsUtils.class);
    private static final IHRCSTipService SERVICE = IHRCSTipService.getInstance();

    public static void showListColumnTips(ListColumn listColumn, String key, String fromId) {
        String tipsText = ShowConfigTipsUtils.getTips(fromId, key);
        if (HRStringUtils.isEmpty((String)tipsText)) {
            LOG.error(MessageFormat.format("key:{0} fromId:{1} get tips is empty!", key, fromId));
        } else {
            Tips textTips = new Tips();
            textTips.setType("text");
            textTips.setContent(new LocaleString(tipsText));
            listColumn.setCtlTips(textTips);
        }
    }

    public static void showPanelOrControlTips(IFormView formView, String key, String fromId) {
        ShowConfigTipsUtils.showPanelOrControlTips(formView, key, key, fromId);
    }

    public static void showPanelOrControlTips(IFormView formView, String key, String fromId, DynamicObject dy) {
        ShowConfigTipsUtils.showPanelOrControlTips(formView, key, key, fromId, dy);
    }

    public static void showPanelOrControlTips(IFormView formView, String key, String targetKey, String fromId) {
        String tipsText = ShowConfigTipsUtils.getTips(fromId, key);
        if (HRStringUtils.isEmpty((String)tipsText)) {
            LOG.error(MessageFormat.format("key:{0} fromId:{1} get tips is empty!", key, fromId));
        } else {
            HashMap<String, Tips> textProps = new HashMap<String, Tips>(16);
            Tips textTips = new Tips();
            textTips.setType("text");
            textTips.setContent(new LocaleString(tipsText));
            textProps.put("tips", textTips);
            formView.updateControlMetadata(targetKey, textProps);
        }
    }

    public static void showPanelOrControlTips(IFormView formView, String key, String targetKey, String fromId, DynamicObject dy) {
        String tipsText;
        List<String> tips = SERVICE.getTips(fromId, key, dy);
        String string = tipsText = !ObjectUtils.isEmpty(tips) ? tips.get(0) : "";
        if (HRStringUtils.isEmpty((String)tipsText)) {
            LOG.error(MessageFormat.format("key:{0} fromId:{1} get tips is empty!", key, fromId));
        } else {
            HashMap<String, Tips> textProps = new HashMap<String, Tips>(16);
            Tips textTips = new Tips();
            textTips.setType("text");
            textTips.setContent(new LocaleString(tipsText));
            textProps.put("tips", textTips);
            formView.updateControlMetadata(targetKey, textProps);
        }
    }

    private static String getTips(String formId, String key) {
        List<String> tips = SERVICE.getTips(formId, key);
        return !ObjectUtils.isEmpty(tips) ? tips.get(0) : "";
    }

    public static Map<String, Map<String, Set<String>>> getTips(Map<String, Set<String>> controlMap, Map<String, DynamicObject> dataModelMap) {
        return SERVICE.getTips(controlMap, dataModelMap);
    }

    public static Map<String, Set<String>> getTipsByFormId(String formId) {
        HashMap<String, Set<String>> controlMap = new HashMap<String, Set<String>>(16);
        controlMap.put(formId, new HashSet(0));
        HashMap<String, DynamicObject> dataModelMap = new HashMap<String, DynamicObject>(0);
        Map<String, Map<String, Set<String>>> tips = ShowConfigTipsUtils.getTips(controlMap, dataModelMap);
        return tips.getOrDefault(formId, new HashMap(0));
    }
}

