/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.pbs.formplugin.web.batchop;

import java.io.IOException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.control.LabelAp;
import kd.hr.hbp.business.servicehelper.HRExportDataHelper;
import kd.hr.hbp.business.servicehelper.HRExportHeadObject;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;

public class BatchOperationTipsPlugin
extends HRDynamicFormBasePlugin {
    private static final Log logger = LogFactory.getLog(BatchOperationTipsPlugin.class);
    private static final String[] LBL_LIST = new String[]{"lbl_allnum", "lbl_fitnum", "lbl_fit", "lbl_nofitnum", "lbl_nofit", "lbl_final"};

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (HRStringUtils.equals((String)args.getOperateKey(), (String)"exportexcel")) {
            this.exportExcel();
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.updatePage();
    }

    private void exportExcel() {
        String excelName = (String)this.getView().getFormShowParameter().getCustomParam("excelname");
        List exportDataList = (List)this.getView().getFormShowParameter().getCustomParam("exportdatalist");
        List headDataList = new ArrayList();
        try {
            headDataList = (List)HRJSONUtils.cast((String)this.getView().getFormShowParameter().getCustomParam("headdatalist").toString(), List.class, (Class[])new Class[]{HRExportHeadObject.class});
        }
        catch (IOException e) {
            logger.error((Throwable)e);
        }
        String exportUrl = null;
        try {
            exportUrl = HRExportDataHelper.getExportExcelUrl((String)excelName, (List)exportDataList, headDataList);
        }
        catch (IOException e) {
            logger.error((Throwable)e);
        }
        if (!HRStringUtils.isEmpty((String)exportUrl)) {
            IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            clientViewProxy.addAction("download", (Object)exportUrl);
        }
    }

    private void updatePage() {
        for (String lbl : LBL_LIST) {
            String param = (String)this.getView().getFormShowParameter().getCustomParam(lbl);
            LabelAp labelAp = this.createLabel(lbl, param);
            this.getView().updateControlMetadata(lbl, labelAp.createControl());
        }
    }

    private LabelAp createLabel(String key, String name) {
        LabelAp labelAp = new LabelAp();
        labelAp.setKey(key);
        labelAp.setName(new LocaleString(name));
        return labelAp;
    }
}

