/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.pbs.formplugin.web.cecycle;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.opmc.pbs.business.application.service.PerfCecycleApplicationService;

public class PerfCecycleListPlugin
extends HRDataBaseList {
    public void setFilter(SetFilterEvent e) {
        e.setOrderBy("createtime asc");
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        String fieldName = args.getHyperLinkClickEvent().getFieldName();
        if (HRStringUtils.equals((String)fieldName, (String)"name")) {
            Long cycleId = (Long)this.getFocusRowPkId();
            this.showPageForCreateOnbrdBill(cycleId);
        }
    }

    private void showPageForCreateOnbrdBill(Long cecycleId) {
        StringBuilder errorMsg = new StringBuilder();
        if (!MutexHelper.require((String)"pbs_perfcecycle", (Object)cecycleId, (String)"modify", (boolean)true, (StringBuilder)errorMsg)) {
            this.getView().showErrorNotification(errorMsg.toString());
            return;
        }
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId("pbs_perfcecycle_detail");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.setPkId((Object)cecycleId);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "pbs_perfcecycle_detail"));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (HRStringUtils.equals((String)closedCallBackEvent.getActionId(), (String)"pbs_perfcecycle_detail")) {
            MutexHelper.release((String)"pbs_perfcecycle", (String)"modify", (String)String.valueOf(closedCallBackEvent.getReturnData()));
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection rows = super.getData(start, limit);
                if (rows.isEmpty()) {
                    return rows;
                }
                List idList = rows.stream().map(row -> row.getLong("id")).collect(Collectors.toList());
                DynamicObject[] dynamicObjects = PerfCecycleApplicationService.getInstance().getRunTimeCycleIns(idList);
                HashMap<Long, String> nodeNameMap = new HashMap<Long, String>(16);
                for (DynamicObject dynamicObject : dynamicObjects) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append(HRDateTimeUtils.format((Date)dynamicObject.getDate("insstarttime"), (String)"yyyy-MM-dd"));
                    stringBuilder.append('\uff5e');
                    stringBuilder.append(HRDateTimeUtils.format((Date)dynamicObject.getDate("insendtime"), (String)"yyyy-MM-dd"));
                    nodeNameMap.put(dynamicObject.getLong("cecycle.id"), stringBuilder.toString());
                }
                for (DynamicObject row2 : rows) {
                    PerfCecycleListPlugin.this.addPropertyIfNotFound(row2.getDataEntityType(), "currentstartend", null);
                    row2.set("currentstartend", nodeNameMap.get(row2.getLong("id")));
                }
                return rows;
            }
        });
    }

    private void addPropertyIfNotFound(IDataEntityType dataEntityType, String propertyName, Object defaultValue) {
        if (!dataEntityType.getProperties().containsKey((Object)propertyName)) {
            DynamicProperty property = new DynamicProperty();
            property.setName(propertyName);
            if (Objects.nonNull(defaultValue)) {
                property.setDefaultValue(defaultValue);
            }
            dataEntityType.getProperties().add((Object)property);
        }
    }
}

